/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import org.jmol.adapter.readers.quantum.SlaterReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.api.JmolAdapter;
import org.jmol.quantum.SlaterData;
import org.jmol.util.ArrayUtil;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;

public class AdfReader
extends SlaterReader {
    private Map<String, SymmetryData> htSymmetries;
    private JmolList<SymmetryData> vSymmetries;
    private String energy = null;
    private int nXX = 0;
    private String symLine;

    protected boolean checkLine() throws Exception {
        if (this.line.indexOf("Irreducible Representations, including subspecies") >= 0) {
            this.readSymmetries();
            return true;
        }
        if (this.line.indexOf("S F O s  ***  (Symmetrized Fragment Orbitals)  ***") >= 0) {
            this.readSlaterBasis();
            return true;
        }
        if (this.line.indexOf(" Coordinates (Cartesian, in Input Orientation)") >= 0 || this.line.indexOf("G E O M E T R Y  ***") >= 0) {
            if (!this.doGetModel(++this.modelNumber, null)) {
                return this.checkLastModel();
            }
            this.readCoordinates();
            return true;
        }
        if (this.line.indexOf(" ======  Eigenvectors (rows) in BAS representation") >= 0) {
            if (this.doReadMolecularOrbitals) {
                this.readMolecularOrbitals(AdfReader.getTokensStr((String)this.symLine)[1]);
            }
            return true;
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.indexOf("Energy:") >= 0) {
            String[] stringArray = AdfReader.getTokensStr((String)this.line.substring(this.line.indexOf("Energy:")));
            this.energy = stringArray[1];
            return true;
        }
        if (this.line.indexOf("Vibrations") >= 0) {
            this.readFrequencies();
            return true;
        }
        if (this.line.indexOf(" === ") >= 0) {
            this.symLine = this.line;
            return true;
        }
        if (this.line.indexOf(" ======  Eigenvectors (rows) in BAS representation") >= 0) {
            this.readMolecularOrbitals(AdfReader.getTokensStr((String)this.symLine)[1]);
            return true;
        }
        return true;
    }

    private void readCoordinates() throws Exception {
        String[] stringArray;
        boolean bl = this.line.indexOf("G E O M E T R Y") >= 0;
        this.atomSetCollection.newAtomSet();
        this.atomSetCollection.setAtomSetName("" + this.energy);
        this.discardLinesUntilContains("----");
        int n = bl ? 2 : 5;
        this.nXX = 0;
        while (this.readLine() != null && !this.line.startsWith(" -----") && (stringArray = this.getTokens()).length >= 5) {
            String string = stringArray[1];
            if (JmolAdapter.getElementNumber((String)string) < 1) {
                ++this.nXX;
                continue;
            }
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = string;
            this.setAtomCoordXYZ(atom, this.parseFloatStr(stringArray[n]), this.parseFloatStr(stringArray[n + 1]), this.parseFloatStr(stringArray[n + 2]));
        }
    }

    private void readFrequencies() throws Exception {
        this.readLine();
        while (this.readLine() != null) {
            while (this.readLine() != null && this.line.indexOf(".") < 0 && this.line.indexOf("====") < 0) {
            }
            if (this.line == null || this.line.indexOf(".") < 0) {
                return;
            }
            String[] stringArray = this.getTokens();
            this.readLine();
            int n = this.atomSetCollection.getAtomCount();
            int n2 = this.atomSetCollection.getLastAtomSetAtomCount();
            int n3 = stringArray.length;
            boolean[] blArray = new boolean[n3];
            for (int i = 0; i < n3; ++i) {
                boolean bl = blArray[i] = !this.doGetVibration(++this.vibrationNumber);
                if (blArray[i]) continue;
                this.atomSetCollection.cloneLastAtomSet();
                this.atomSetCollection.setAtomSetFrequency(null, null, stringArray[i], null);
            }
            this.readLines(this.nXX);
            this.fillFrequencyData(n, n2, n2, blArray, true, 0, 0, null, 0);
        }
    }

    private void readSymmetries() throws Exception {
        this.vSymmetries = new JmolList();
        this.htSymmetries = new Hashtable<String, SymmetryData>();
        this.readLine();
        int n = 0;
        String string = "";
        while (this.readLine() != null && this.line.length() > 1) {
            string = string + this.line;
        }
        String[] stringArray = AdfReader.getTokensStr((String)string);
        for (int i = 0; i < stringArray.length; ++i) {
            SymmetryData symmetryData = new SymmetryData(n++, stringArray[i]);
            this.htSymmetries.put(stringArray[i], symmetryData);
            this.vSymmetries.addLast((Object)symmetryData);
        }
    }

    private void readSlaterBasis() throws Exception {
        int n;
        int n2;
        Object[] objectArray;
        String[] stringArray;
        if (this.vSymmetries == null) {
            return;
        }
        int n3 = 0;
        for (int i = 0; i < this.vSymmetries.size(); ++i) {
            stringArray = (String[])this.vSymmetries.get(i);
            Logger.info((String)stringArray.sym);
            this.discardLinesUntilContains("=== " + stringArray.sym + " ===");
            if (this.line == null) {
                Logger.error((String)("Symmetry slater basis section not found: " + stringArray.sym));
                return;
            }
            stringArray.nSFO = this.parseIntStr(this.readLine().substring(15));
            stringArray.nBF = this.parseIntStr(this.readLine().substring(75));
            String string = "";
            while (this.readLine() != null && this.line.length() > 1) {
                string = string + this.line;
            }
            objectArray = AdfReader.getTokensStr((String)string);
            if (objectArray.length != stringArray.nBF) {
                return;
            }
            stringArray.basisFunctions = new int[objectArray.length];
            n2 = objectArray.length;
            while (--n2 >= 0) {
                n = this.parseIntStr((String)objectArray[n2]);
                if (n > n3) {
                    n3 = n;
                }
                stringArray.basisFunctions[n2] = n - 1;
            }
        }
        this.slaterArray = new SlaterData[n3];
        this.discardLinesUntilContains("(power of)");
        this.readLines(2);
        while (this.readLine() != null && this.line.length() > 2 && this.line.charAt(2) == ' ') {
            String string = this.line;
            while (this.readLine().indexOf("---") < 0) {
                string = string + this.line;
            }
            stringArray = AdfReader.getTokensStr((String)string);
            int n4 = stringArray.length - 1;
            objectArray = new int[n4];
            for (n2 = 1; n2 <= n4; ++n2) {
                objectArray[n2 - 1] = this.parseIntStr(stringArray[n2]) - 1;
            }
            this.readLine();
            while (this.line.length() >= 10) {
                string = this.line;
                while (this.readLine().length() > 35 && this.line.substring(0, 35).trim().length() == 0) {
                    string = string + this.line;
                }
                stringArray = AdfReader.getTokensStr((String)string);
                n2 = stringArray[0].equals("Core") ? 1 : 0;
                n = n2 != 0 ? 1 : 0;
                int n5 = this.parseIntStr(stringArray[n++]);
                int n6 = this.parseIntStr(stringArray[n++]);
                int n7 = this.parseIntStr(stringArray[n++]);
                int n8 = this.parseIntStr(stringArray[n++]);
                float f = this.parseFloatStr(stringArray[n++]);
                for (int i = 0; i < n4; ++i) {
                    int n9 = this.parseIntStr(stringArray[n++]) - 1;
                    this.slaterArray[n9] = new SlaterData(objectArray[i], n5, n6, n7, n8, f, 1.0);
                    this.slaterArray[n9].index = n9;
                }
            }
        }
    }

    private void readMolecularOrbitals(String string) throws Exception {
        int n;
        String[][] stringArray;
        int n2;
        SymmetryData symmetryData = this.htSymmetries.get(string);
        if (symmetryData == null) {
            return;
        }
        int n3 = symmetryData.index;
        boolean bl = n3 == this.vSymmetries.size() - 1;
        int n4 = 0;
        int n5 = this.slaterArray.length;
        symmetryData.coefs = new float[symmetryData.nSFO][n5];
        while (n4 < symmetryData.nBF) {
            this.readLine();
            n2 = AdfReader.getTokensStr((String)this.readLine()).length;
            this.readLine();
            symmetryData.mos = ArrayUtil.createArrayOfHashtable((int)symmetryData.nSFO);
            stringArray = new String[symmetryData.nSFO][];
            this.fillDataBlock(stringArray, 0);
            for (n = 1; n < n2; ++n) {
                int n6 = symmetryData.basisFunctions[n4++];
                for (int i = 0; i < symmetryData.nSFO; ++i) {
                    symmetryData.coefs[i][n6] = this.parseFloatStr(stringArray[i][n]);
                }
            }
        }
        for (n2 = 0; n2 < symmetryData.nSFO; ++n2) {
            stringArray = new Hashtable();
            stringArray.put("coefficients", symmetryData.coefs[n2]);
            stringArray.put("id", string + " " + (n2 + 1));
            symmetryData.mos[n2] = stringArray;
        }
        if (!bl) {
            return;
        }
        this.discardLinesUntilContains("Orbital Energies, all Irreps");
        this.readLines(4);
        while (this.readLine() != null && this.line.length() > 10) {
            String[] stringArray2 = this.getTokens();
            int n7 = stringArray2.length;
            string = stringArray2[0];
            n = this.parseIntStr(stringArray2[1]);
            float f = this.parseFloatStr(stringArray2[n7 - 3]);
            float f2 = this.parseFloatStr(stringArray2[n7 - 1]);
            symmetryData = this.htSymmetries.get(string);
            if (symmetryData == null) {
                for (Map.Entry<String, SymmetryData> entry : this.htSymmetries.entrySet()) {
                    String string2 = entry.getKey();
                    if (!string2.startsWith(string + ":")) continue;
                    this.addMo(entry.getValue(), n, f > 2.0f ? 2.0f : f, f2);
                }
                continue;
            }
            this.addMo(symmetryData, n, f, f2);
        }
        int n8 = this.atomSetCollection.getLastAtomSetAtomIndex();
        for (int i = 0; i < n5; ++i) {
            this.slaterArray[i].iAtom += n8;
        }
        this.setSlaters(true, true);
        this.sortOrbitals();
        this.setMOs("eV");
    }

    private void addMo(SymmetryData symmetryData, int n, float f, float f2) {
        Map<String, Object> map = symmetryData.mos[n - 1];
        map.put("occupancy", Float.valueOf(f));
        map.put("energy", Float.valueOf(f2));
        map.put("symmetry", symmetryData.sym + "_" + n);
        this.setMO(map);
    }

    class SymmetryData {
        int index;
        String sym;
        int nSFO;
        int nBF;
        float[][] coefs;
        Map<String, Object>[] mos;
        int[] basisFunctions;

        public SymmetryData(int n, String string) {
            Logger.info((String)("ADF reader creating SymmetryData " + string + " " + n));
            this.index = n;
            this.sym = string;
        }
    }
}

