/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.io2;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.api.Interface;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolFileInterface;
import org.jmol.api.JmolZipUtility;
import org.jmol.api.ZInputStream;
import org.jmol.io.JmolBinary;
import org.jmol.io2.JmolZipInputStream;
import org.jmol.util.Escape;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.SB;
import org.jmol.util.TextFormat;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipUtil
implements JmolZipUtility {
    private static final String SCENE_TAG = "###scene.spt###";

    public ZInputStream newZipInputStream(InputStream inputStream) {
        return ZipUtil.newZIS(inputStream);
    }

    private static ZInputStream newZIS(InputStream inputStream) {
        return inputStream instanceof ZInputStream ? (ZInputStream)inputStream : (inputStream instanceof BufferedInputStream ? new JmolZipInputStream(inputStream) : new JmolZipInputStream(new BufferedInputStream(inputStream)));
    }

    public void getAllZipData(InputStream inputStream, String[] stringArray, String string, String string2, Map<String, String> map) {
        ZipUtil.getAllZipDataStatic(inputStream, stringArray, string, string2, map);
    }

    private static void getAllZipDataStatic(InputStream inputStream, String[] stringArray, String string, String string2, Map<String, String> map) {
        ZipInputStream zipInputStream = (ZipInputStream)ZipUtil.newZIS(inputStream);
        SB sB = new SB();
        string2 = "|" + string2 + "|";
        String string3 = TextFormat.join((String[])stringArray, (char)'/', (int)1);
        String string4 = null;
        if (string3 != null && (string4 = string3.substring(0, string3.indexOf("/") + 1)).length() == 0) {
            string4 = null;
        }
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string5;
                String string6 = zipEntry.getName();
                if (string3 != null && string4 != null && !string6.equals(string3) && !string6.startsWith(string4)) continue;
                sB.append(string6).appendC('\n');
                String string7 = "|" + string6.substring(string6.lastIndexOf("/") + 1) + "|";
                boolean bl = string2.indexOf(string7) >= 0;
                byte[] byArray = JmolBinary.getStreamBytes((InputStream)zipInputStream, (long)zipEntry.getSize());
                if (bl) {
                    string5 = ZipUtil.getBinaryStringForBytes(byArray);
                    string6 = string6 + ":asBinaryString";
                } else {
                    string5 = JmolBinary.fixUTF((byte[])byArray);
                }
                string5 = "BEGIN Directory Entry " + string6 + "\n" + string5 + "\nEND Directory Entry " + string6 + "\n";
                map.put(string + "|" + string6, string5);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        map.put("#Directory_Listing", sB.toString());
    }

    private static String getBinaryStringForBytes(byte[] byArray) {
        SB sB = new SB();
        for (int i = 0; i < byArray.length; ++i) {
            sB.append(Integer.toHexString(byArray[i] & 0xFF)).appendC(' ');
        }
        return sB.toString();
    }

    public Object getZipFileContents(BufferedInputStream bufferedInputStream, String[] stringArray, int n, boolean bl) {
        if (stringArray == null || n >= stringArray.length) {
            return this.getZipDirectoryAsStringAndClose(bufferedInputStream);
        }
        String string = stringArray[n];
        ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
        try {
            ZipEntry zipEntry;
            boolean bl2 = string.equals(".");
            if (bl2 || string.lastIndexOf("/") == string.length() - 1) {
                String string2;
                ZipEntry zipEntry2;
                SB sB = new SB();
                while ((zipEntry2 = zipInputStream.getNextEntry()) != null) {
                    string2 = zipEntry2.getName();
                    if (!bl2 && !string2.startsWith(string)) continue;
                    sB.append(string2).appendC('\n');
                }
                string2 = sB.toString();
                if (bl) {
                    return new BufferedInputStream(new ByteArrayInputStream(string2.getBytes()));
                }
                return string2;
            }
            boolean bl3 = false;
            if (string.indexOf(":asBinaryString") > 0) {
                string = string.substring(0, string.indexOf(":asBinaryString"));
                bl3 = true;
            }
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!string.equals(zipEntry.getName())) continue;
                byte[] byArray = JmolBinary.getStreamBytes((InputStream)zipInputStream, (long)zipEntry.getSize());
                if (JmolBinary.isZipFile((byte[])byArray)) {
                    return this.getZipFileContents(new BufferedInputStream(new ByteArrayInputStream(byArray)), stringArray, ++n, bl);
                }
                if (bl) {
                    return new BufferedInputStream(new ByteArrayInputStream(byArray));
                }
                if (bl3) {
                    SB sB = new SB();
                    for (int i = 0; i < byArray.length; ++i) {
                        sB.append(Integer.toHexString(byArray[i] & 0xFF)).appendC(' ');
                    }
                    return sB.toString();
                }
                return JmolBinary.fixUTF((byte[])byArray);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public byte[] getZipFileContentsAsBytes(BufferedInputStream bufferedInputStream, String[] stringArray, int n) {
        byte[] byArray = new byte[]{};
        String string = stringArray[n];
        if (string.lastIndexOf("/") == string.length() - 1) {
            return byArray;
        }
        try {
            ZipEntry zipEntry;
            bufferedInputStream = JmolBinary.checkPngZipStream((BufferedInputStream)bufferedInputStream);
            ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!string.equals(zipEntry.getName())) continue;
                byte[] byArray2 = JmolBinary.getStreamBytes((InputStream)zipInputStream, (long)zipEntry.getSize());
                if (JmolBinary.isZipFile((byte[])byArray2) && ++n < stringArray.length) {
                    return this.getZipFileContentsAsBytes(new BufferedInputStream(new ByteArrayInputStream(byArray2)), stringArray, n);
                }
                return byArray2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    public String getZipDirectoryAsStringAndClose(BufferedInputStream bufferedInputStream) {
        SB sB = new SB();
        String[] stringArray = new String[]{};
        try {
            stringArray = this.getZipDirectoryOrErrorAndClose(bufferedInputStream, false);
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            Logger.error((String)exception.toString());
        }
        for (int i = 0; i < stringArray.length; ++i) {
            sB.append(stringArray[i]).appendC('\n');
        }
        return sB.toString();
    }

    public String[] getZipDirectoryAndClose(BufferedInputStream bufferedInputStream, boolean bl) {
        String[] stringArray = new String[]{};
        try {
            stringArray = this.getZipDirectoryOrErrorAndClose(bufferedInputStream, bl);
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            Logger.error((String)exception.toString());
        }
        return stringArray;
    }

    private String[] getZipDirectoryOrErrorAndClose(BufferedInputStream bufferedInputStream, boolean bl) throws IOException {
        ZipEntry zipEntry;
        bufferedInputStream = JmolBinary.checkPngZipStream((BufferedInputStream)bufferedInputStream);
        JmolList jmolList = new JmolList();
        ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
        String string = null;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string2 = zipEntry.getName();
            if (bl && ZipUtil.isJmolManifest(string2)) {
                string = ZipUtil.getZipEntryAsString(zipInputStream);
                continue;
            }
            if (string2.startsWith("__MACOS")) continue;
            jmolList.addLast((Object)string2);
        }
        zipInputStream.close();
        if (bl) {
            jmolList.add(0, (Object)(string == null ? "" : string + "\n############\n"));
        }
        return (String[])jmolList.toArray((Object[])new String[jmolList.size()]);
    }

    private static String getZipEntryAsString(InputStream inputStream) throws IOException {
        return JmolBinary.fixUTF((byte[])JmolBinary.getStreamBytes((InputStream)inputStream, (long)-1L));
    }

    private static boolean isJmolManifest(String string) {
        return string.startsWith("JmolManifest");
    }

    public String cacheZipContents(BufferedInputStream bufferedInputStream, String string, Map<String, byte[]> map) {
        ZipInputStream zipInputStream = (ZipInputStream)this.newZipInputStream(bufferedInputStream);
        SB sB = new SB();
        long l = 0L;
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string2 = zipEntry.getName();
                sB.append(string2).appendC('\n');
                long l2 = zipEntry.getSize();
                byte[] byArray = JmolBinary.getStreamBytes((InputStream)zipInputStream, (long)l2);
                l += (long)byArray.length;
                map.put(string + "|" + string2, byArray);
            }
            zipInputStream.close();
        }
        catch (Exception exception) {
            try {
                zipInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        Logger.info((String)("ZipUtil cached " + l + " bytes from " + string));
        return sB.toString();
    }

    public String getGzippedBytesAsString(byte[] byArray) {
        return ZipUtil.staticGetGzippedBytesAsString(byArray);
    }

    static String staticGetGzippedBytesAsString(byte[] byArray) {
        try {
            InputStream inputStream = new ByteArrayInputStream(byArray);
            while (JmolBinary.isGzipS((InputStream)(inputStream = new BufferedInputStream(new GZIPInputStream(inputStream, 512))))) {
            }
            String string = ZipUtil.getZipEntryAsString(inputStream);
            inputStream.close();
            return string;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public InputStream getGzippedInputStream(byte[] byArray) {
        try {
            InputStream inputStream = new ByteArrayInputStream(byArray);
            while (JmolBinary.isGzipS((InputStream)(inputStream = new BufferedInputStream(new GZIPInputStream(inputStream, 512))))) {
            }
            return inputStream;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public InputStream newGZIPInputStream(BufferedInputStream bufferedInputStream) throws IOException {
        return new GZIPInputStream((InputStream)bufferedInputStream, 512);
    }

    private String addPngFileBytes(String string, byte[] byArray, int n, Hashtable<Object, String> hashtable, boolean bl, String string2, int n2, JmolList<Object> jmolList) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, 0, byArray.length);
        Long l = cRC32.getValue();
        if (hashtable.containsKey(l)) {
            string2 = hashtable.get(l);
        } else {
            if (bl) {
                string2 = string2.replace('.', '_');
            }
            if (hashtable.containsKey(string2)) {
                int n3 = string2.lastIndexOf(".");
                string2 = n3 > n2 ? string2.substring(0, n3) + "[" + n + "]" + string2.substring(n3) : string2 + "[" + n + "]";
            }
            jmolList.addLast((Object)string);
            jmolList.addLast((Object)string2);
            jmolList.addLast((Object)byArray);
            hashtable.put(l, string2);
        }
        return string2;
    }

    public Object writeZipFile(FileManager fileManager, Viewer viewer, String string, JmolList<Object> jmolList, String string2) {
        byte[] byArray = new byte[1024];
        long l = 0L;
        long l2 = 0L;
        Logger.info((String)("creating zip file " + (string == null ? "" : string) + "..."));
        String string3 = null;
        String string4 = "";
        try {
            String string5;
            ByteArrayOutputStream byteArrayOutputStream = string == null || string.startsWith("http://") ? new ByteArrayOutputStream() : null;
            ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream == null ? new FileOutputStream(string) : byteArrayOutputStream);
            for (int i = 0; i < jmolList.size(); i += 3) {
                String string6;
                Object object;
                string5 = (String)jmolList.get(i);
                byte[] byArray2 = null;
                if (string5.indexOf("file:/") == 0) {
                    if ((string5 = string5.substring(5)).length() > 2 && string5.charAt(2) == ':') {
                        string5 = string5.substring(1);
                    }
                } else if (string5.indexOf("cache://") == 0) {
                    object = fileManager.cacheGet(string5, false);
                    string5 = string5.substring(8);
                    byte[] byArray3 = byArray2 = Escape.isAB((Object)object) ? (byte[])object : ((String)object).getBytes();
                }
                if ((object = (String)jmolList.get(i + 1)) == null) {
                    object = string5;
                }
                if (byArray2 == null) {
                    byArray2 = (byte[])jmolList.get(i + 2);
                }
                if (string4.indexOf(string6 = ";" + (String)object + ";") >= 0) {
                    Logger.info((String)"duplicate entry");
                    continue;
                }
                string4 = string4 + string6;
                zipOutputStream.putNextEntry(new ZipEntry((String)object));
                int n = 0;
                if (byArray2 == null) {
                    int n2;
                    FileInputStream fileInputStream = new FileInputStream(string5);
                    while ((n2 = fileInputStream.read(byArray, 0, 1024)) > 0) {
                        zipOutputStream.write(byArray, 0, n2);
                        n += n2;
                    }
                    fileInputStream.close();
                } else {
                    zipOutputStream.write(byArray2, 0, byArray2.length);
                    n += byArray2.length;
                }
                l += (long)n;
                zipOutputStream.closeEntry();
                Logger.info((String)("...added " + string5 + " (" + n + " bytes)"));
            }
            zipOutputStream.close();
            Logger.info((String)(l + " bytes prior to compression"));
            if (byteArrayOutputStream != null) {
                byte[] byArray4 = byteArrayOutputStream.toByteArray();
                if (string == null) {
                    return byArray4;
                }
                string3 = string;
                l2 = byArray4.length;
                string5 = JmolBinary.postByteArray((FileManager)fileManager, (String)string, (byte[])byArray4);
                if (string5.indexOf("Exception") >= 0) {
                    return string5;
                }
                string2 = string2 + " " + string5;
            } else {
                JmolFileInterface jmolFileInterface = viewer.apiPlatform.newFile(string);
                string3 = jmolFileInterface.getAbsolutePath().replace('\\', '/');
                l2 = jmolFileInterface.length();
            }
        }
        catch (IOException iOException) {
            Logger.info((String)iOException.toString());
            return iOException.toString();
        }
        return string2 + " " + l2 + " " + string3;
    }

    public String getSceneScript(String[] stringArray, Map<String, String> map, JmolList<Integer> jmolList) {
        int n = 0;
        int n2 = 0;
        SB sB = new SB().append(SCENE_TAG).append(" Jmol ").append(Viewer.getJmolVersion()).append("\n{\nsceneScripts={");
        for (int i = 1; i < stringArray.length; ++i) {
            stringArray[i - 1] = TextFormat.trim((String)stringArray[i - 1], (String)"\t\n\r ");
            int[] nArray = new int[1];
            n2 = Parser.parseIntNext((String)stringArray[i], (int[])nArray);
            if (n2 == Integer.MIN_VALUE) {
                return "bad scene ID: " + n2;
            }
            stringArray[i] = stringArray[i].substring(nArray[0]);
            jmolList.addLast((Object)n2);
            String string = n + "-" + n2;
            map.put(string, stringArray[i - 1]);
            if (i > 1) {
                sB.append(",");
            }
            sB.appendC('\n').append(Escape.eS((String)string)).append(": ").append(Escape.eS((String)stringArray[i - 1]));
            n = n2;
        }
        sB.append("\n}\n");
        if (jmolList.size() == 0) {
            return "no lines 'pause scene n'";
        }
        sB.append("\nthisSceneRoot = '$SCRIPT_PATH$'.split('_scene_')[1];\n").append("thisSceneID = 0 + ('$SCRIPT_PATH$'.split('_scene_')[2]).split('.')[1];\n").append("var thisSceneState = '$SCRIPT_PATH$'.replace('.min.png','.all.png') + 'state.spt';\n").append("var spath = ''+currentSceneID+'-'+thisSceneID;\n").append("print thisSceneRoot + ' ' + spath;\n").append("var sscript = sceneScripts[spath];\n").append("var isOK = true;\n").append("try{\n").append("if (thisSceneRoot != currentSceneRoot){\n").append(" isOK = false;\n").append("} else if (sscript != '') {\n").append(" isOK = true;\n").append("} else if (thisSceneID <= currentSceneID){\n").append(" isOK = false;\n").append("} else {\n").append(" sscript = '';\n").append(" for (var i = currentSceneID; i < thisSceneID; i++){\n").append("  var key = ''+i+'-'+(i + 1); var script = sceneScripts[key];\n").append("  if (script = '') {isOK = false;break;}\n").append("  sscript += ';'+script;\n").append(" }\n").append("}\n}catch(e){print e;isOK = false}\n").append("if (isOK) {" + ZipUtil.wrapPathForAllFiles("script inline @sscript", "print e;isOK = false") + "}\n").append("if (!isOK){script @thisSceneState}\n").append("currentSceneRoot = thisSceneRoot; currentSceneID = thisSceneID;\n}\n");
        return sB.toString();
    }

    private static String wrapPathForAllFiles(String string, String string2) {
        String string3 = "v__" + ("" + Math.random()).substring(3);
        return "# Jmol script\n{\n\tVar " + string3 + " = pathForAllFiles\n\tpathForAllFiles=\"$SCRIPT_PATH$\"\n\ttry{\n\t\t" + string + "\n\t}catch(e){" + string2 + "}\n\tpathForAllFiles = " + string3 + "\n}\n";
    }

    public Object createZipSet(FileManager fileManager, Viewer viewer, String string, String string2, String[] stringArray, boolean bl) {
        Object object;
        String string3;
        String string4;
        int n;
        boolean bl2;
        boolean bl3;
        JmolList jmolList = new JmolList();
        JmolList jmolList2 = new JmolList();
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        boolean bl4 = stringArray != null && stringArray.length == 3 && stringArray[1].startsWith(SCENE_TAG);
        boolean bl5 = bl3 = bl4 && stringArray[2].equals("min");
        if (!bl3) {
            JmolBinary.getFileReferences((String)string2, (List)jmolList2);
            if (bl4) {
                JmolBinary.getFileReferences((String)stringArray[1], (List)jmolList2);
            }
        }
        boolean bl6 = bl2 = !bl4 && stringArray != null && stringArray.length > 0;
        if (bl2) {
            string2 = ZipUtil.wrapPathForAllFiles("script " + Escape.eS((String)stringArray[0]), "");
            for (n = 0; n < stringArray.length; ++n) {
                jmolList2.addLast((Object)stringArray[n]);
            }
        }
        n = jmolList2.size();
        if (string != null) {
            string = string.replace('\\', '/');
        }
        if ((string4 = string) != null && (string4 = string.substring(string.lastIndexOf("/") + 1)).indexOf(".") >= 0) {
            string4 = string4.substring(0, string4.indexOf("."));
        }
        JmolList jmolList3 = new JmolList();
        for (int i = 0; i < n; ++i) {
            string3 = (String)jmolList2.get(i);
            boolean bl7 = !viewer.isJS && FileManager.isLocal((String)string3);
            String string5 = string3;
            if (bl7 || bl) {
                boolean bl8;
                int n2 = string3.lastIndexOf("/");
                string5 = string3.indexOf("?") > 0 && string3.indexOf("|") < 0 ? TextFormat.replaceAllCharacters((String)string3, (String)"/:?\"'=&", (String)"_") : FileManager.stripPath((String)string3);
                string5 = TextFormat.replaceAllCharacters((String)string5, (String)"[]", (String)"_");
                boolean bl9 = bl8 = fileManager.spardirCache != null && fileManager.spardirCache.containsKey(string3);
                if (bl7 && string3.indexOf("|") < 0 && !bl8) {
                    jmolList.addLast((Object)string3);
                    jmolList.addLast((Object)string5);
                    jmolList.addLast(null);
                } else {
                    Object object2;
                    Object object3 = object2 = bl8 ? fileManager.spardirCache.get(string3) : fileManager.getFileAsBytes(string3, null, true);
                    if (!Escape.isAB(object2)) {
                        return object2;
                    }
                    string5 = this.addPngFileBytes(string3, (byte[])object2, i, hashtable, bl8, string5, n2, (JmolList<Object>)jmolList);
                }
                string3 = "$SCRIPT_PATH$" + string5;
            }
            hashtable.put(string5, string5);
            jmolList3.addLast((Object)string3);
        }
        if (!bl3) {
            string2 = TextFormat.replaceQuotedStrings((String)string2, (List)jmolList2, (List)jmolList3);
            jmolList.addLast((Object)"state.spt");
            jmolList.addLast(null);
            jmolList.addLast((Object)string2.getBytes());
        }
        if (bl4) {
            if (stringArray[0] != null) {
                jmolList.addLast((Object)"animate.spt");
                jmolList.addLast(null);
                jmolList.addLast((Object)stringArray[0].getBytes());
            }
            jmolList.addLast((Object)"scene.spt");
            jmolList.addLast(null);
            string2 = TextFormat.replaceQuotedStrings((String)stringArray[1], (List)jmolList2, (List)jmolList3);
            jmolList.addLast((Object)string2.getBytes());
        }
        String string6 = bl4 ? "scene.spt" : "state.spt";
        jmolList.addLast((Object)"JmolManifest.txt");
        jmolList.addLast(null);
        string3 = "# Jmol Manifest Zip Format 1.1\n# Created " + new Date() + "\n" + "# JmolVersion " + Viewer.getJmolVersion() + "\n" + string6;
        jmolList.addLast((Object)string3.getBytes());
        jmolList.addLast((Object)("Jmol_version_" + Viewer.getJmolVersion().replace(' ', '_').replace(':', '.')));
        jmolList.addLast(null);
        jmolList.addLast((Object)new byte[0]);
        if (string4 != null && Escape.isAB((Object)(object = viewer.getImageAsWithComment("PNG", -1, -1, -1, null, null, null, JC.embedScript((String)string2))))) {
            jmolList.addLast((Object)"preview.png");
            jmolList.addLast(null);
            jmolList.addLast(object);
        }
        return JmolBinary.writeZipFile((FileManager)fileManager, (Viewer)viewer, (String)string, (JmolList)jmolList, (String)"OK JMOL");
    }

    public Object getAtomSetCollectionOrBufferedReaderFromZip(JmolAdapter jmolAdapter, InputStream inputStream, String string, String[] stringArray, Map<String, Object> map, int n, boolean bl, boolean bl2) {
        Object object;
        boolean bl3;
        boolean bl4;
        String string2;
        boolean bl5;
        String string3;
        boolean bl6 = n == 1;
        map.put("zipSet", string);
        String[] stringArray2 = (String[])map.get("subFileList");
        if (stringArray2 == null) {
            stringArray2 = ZipUtil.checkSpecialInZip(stringArray);
        }
        String string4 = string3 = stringArray2 == null || n >= stringArray2.length ? null : stringArray2[n];
        if (string3 != null && (string3.startsWith("/") || string3.startsWith("\\"))) {
            string3 = string3.substring(1);
        }
        int n2 = 0;
        if (string3 == null && map.containsKey("modelNumber") && (n2 = ((Integer)map.get("modelNumber")).intValue()) > 0 && bl6) {
            map.remove("modelNumber");
        }
        boolean bl7 = bl5 = (string2 = (String)map.get("manifest")) == null;
        if (bl5) {
            string2 = stringArray.length > 0 ? stringArray[0] : "";
        }
        boolean bl8 = bl4 = string2.length() > 0;
        if (bl4 && Logger.debugging) {
            Logger.info((String)("manifest for  " + string + ":\n" + string2));
        }
        boolean bl9 = string2.indexOf("IGNORE_ERRORS") >= 0;
        boolean bl10 = string2.indexOf("IGNORE_MANIFEST") >= 0;
        boolean bl11 = bl3 = string2.indexOf("EXCEPT_FILES") >= 0;
        if (bl10 || string3 != null) {
            bl4 = false;
        }
        if (bl5 && bl4 && (object = JmolBinary.getManifestScriptPath((String)string2)) != null) {
            return "NOTE: file recognized as a script file: " + string + (String)object + "\n";
        }
        object = new JmolList();
        Hashtable<AtomSetCollection, Object> hashtable = bl4 ? new Hashtable<AtomSetCollection, Object>() : null;
        boolean bl12 = false;
        Object object2 = ZipUtil.checkSpecialData(inputStream, stringArray);
        if (object2 instanceof String) {
            return object2;
        }
        SB sB = object2;
        try {
            Object object3;
            AtomSetCollection atomSetCollection;
            ZipEntry zipEntry;
            if (sB != null) {
                BufferedReader bufferedReader = new BufferedReader(new StringReader(sB.toString()));
                if (bl) {
                    return bufferedReader;
                }
                object2 = jmolAdapter.getAtomSetCollectionFromReader(string, (Object)bufferedReader, map);
                if (object2 instanceof String) {
                    return object2;
                }
                if (object2 instanceof AtomSetCollection) {
                    AtomSetCollection atomSetCollection2 = (AtomSetCollection)object2;
                    if (atomSetCollection2.errorMessage != null) {
                        if (bl9) {
                            return null;
                        }
                        return atomSetCollection2.errorMessage;
                    }
                    return atomSetCollection2;
                }
                if (bl9) {
                    return null;
                }
                return "unknown reader error";
            }
            if (inputStream instanceof BufferedInputStream) {
                inputStream = JmolBinary.checkPngZipStream((BufferedInputStream)((BufferedInputStream)inputStream));
            }
            ZipInputStream zipInputStream = (ZipInputStream)JmolBinary.newZipInputStream((InputStream)inputStream);
            if (bl4) {
                string2 = '|' + string2.replace('\r', '|').replace('\n', '|') + '|';
            }
            while ((zipEntry = zipInputStream.getNextEntry()) != null && (n2 <= 0 || object.size() < n2)) {
                Object object4;
                String[] stringArray3;
                if (zipEntry.isDirectory()) continue;
                atomSetCollection = zipEntry.getName();
                if (string3 != null && !atomSetCollection.equals(string3)) continue;
                if (string3 != null) {
                    map.put("subFileName", string3);
                }
                if (ZipUtil.isJmolManifest((String)atomSetCollection) || bl4 && bl3 == string2.indexOf("|" + (String)atomSetCollection + "|") >= 0) continue;
                byte[] byArray = JmolBinary.getStreamBytes((InputStream)zipInputStream, (long)zipEntry.getSize());
                if (JmolBinary.isZipFile((byte[])byArray)) {
                    object3 = new BufferedInputStream(new ByteArrayInputStream(byArray));
                    stringArray3 = JmolBinary.getZipDirectoryAndClose((BufferedInputStream)object3, (boolean)true);
                    object3 = new BufferedInputStream(new ByteArrayInputStream(byArray));
                    object4 = this.getAtomSetCollectionOrBufferedReaderFromZip(jmolAdapter, (InputStream)object3, string + "|" + (String)atomSetCollection, stringArray3, map, ++n, bl, bl2);
                    if (object4 instanceof String) {
                        if (bl9) continue;
                        return object4;
                    }
                    if (object4 instanceof AtomSetCollection || object4 instanceof JmolList) {
                        if (bl4 && !bl3) {
                            hashtable.put(atomSetCollection, object4);
                            continue;
                        }
                        object.addLast(object4);
                        continue;
                    }
                    if (object4 instanceof BufferedReader) {
                        if (bl6) {
                            zipInputStream.close();
                        }
                        return object4;
                    }
                    if (bl9) continue;
                    zipInputStream.close();
                    return "unknown zip reader error";
                }
                if (bl2) {
                    if (JmolBinary.isGzipB((byte[])byArray)) {
                        return this.getGzippedInputStream(byArray);
                    }
                    object3 = new BufferedInputStream(new ByteArrayInputStream(byArray));
                    if (bl6) {
                        zipInputStream.close();
                    }
                    return object3;
                }
                if (JmolBinary.isCompoundDocumentArray((byte[])byArray)) {
                    stringArray3 = (String[])Interface.getInterface((String)"jmol.util.CompoundDocument");
                    stringArray3.setStream(new BufferedInputStream(new ByteArrayInputStream(byArray)), true);
                    object3 = stringArray3.getAllDataFiles("Molecule", "Input").toString();
                } else {
                    object3 = JmolBinary.isGzipB((byte[])byArray) ? JmolBinary.getGzippedBytesAsString((byte[])byArray) : JmolBinary.fixUTF((byte[])byArray);
                }
                stringArray3 = new BufferedReader(new StringReader((String)object3));
                if (bl) {
                    if (bl6) {
                        zipInputStream.close();
                    }
                    return stringArray3;
                }
                object4 = string + "|" + zipEntry.getName();
                object2 = jmolAdapter.getAtomSetCollectionFromReader((String)object4, (Object)stringArray3, map);
                if (!(object2 instanceof AtomSetCollection)) {
                    if (bl9) continue;
                    zipInputStream.close();
                    return "" + object2;
                }
                if (bl4 && !bl3) {
                    hashtable.put(atomSetCollection, object2);
                } else {
                    object.addLast(object2);
                }
                AtomSetCollection atomSetCollection3 = (AtomSetCollection)object2;
                if (atomSetCollection3.errorMessage == null || bl9) continue;
                zipInputStream.close();
                return atomSetCollection3.errorMessage;
            }
            if (bl6) {
                zipInputStream.close();
            }
            if (bl4 && !bl3) {
                atomSetCollection = TextFormat.split((String)string2, (char)'|');
                for (int i = 0; i < ((AtomSetCollection)atomSetCollection).length; ++i) {
                    object3 = atomSetCollection[i];
                    if (object3.length() == 0 || object3.indexOf("#") == 0) continue;
                    if (hashtable.containsKey(object3)) {
                        object.addLast(hashtable.get(object3));
                        continue;
                    }
                    if (!Logger.debugging) continue;
                    Logger.info((String)("manifested file " + (String)object3 + " was not found in " + string));
                }
            }
            if (!bl6) {
                return object;
            }
            atomSetCollection = new AtomSetCollection("Array", null, null, object);
            if (atomSetCollection.errorMessage != null) {
                if (bl9) {
                    return null;
                }
                return atomSetCollection.errorMessage;
            }
            if (bl12) {
                n2 = 1;
            }
            if (n2 > 0 && n2 <= object.size()) {
                return object.get(n2 - 1);
            }
            return atomSetCollection;
        }
        catch (Exception exception) {
            if (bl9) {
                return null;
            }
            Logger.error((String)("" + exception));
            return "" + exception;
        }
        catch (Error error) {
            Logger.errorEx(null, (Throwable)error);
            return "" + error;
        }
    }

    private static SB checkSpecialData(InputStream inputStream, String[] stringArray) {
        boolean bl = false;
        for (int i = 1; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(".spardir/") && stringArray[i].indexOf("_spartandir") < 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return null;
        }
        SB sB = new SB();
        sB.append("Zip File Directory: ").append("\n").append(Escape.eAS((String[])stringArray, (boolean)true)).append("\n");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        ZipUtil.getAllZipDataStatic(inputStream, new String[0], "", "Molecule", hashtable);
        String string = "|";
        String string2 = (String)hashtable.get(string + "output");
        if (string2 == null) {
            string = "|" + stringArray[1];
            string2 = (String)hashtable.get(string + "output");
        }
        sB.append(string2);
        String[] stringArray2 = ZipUtil.getSpartanFileList(string, ZipUtil.getSpartanDirs(string2));
        for (int i = 2; i < stringArray2.length; ++i) {
            String string3 = stringArray2[i];
            if (hashtable.containsKey(string3)) {
                sB.append((String)hashtable.get(string3));
                continue;
            }
            sB.append(string3 + "\n");
        }
        return sB;
    }

    public String[] spartanFileList(String string, String string2) {
        String[] stringArray = ZipUtil.getSpartanDirs(string2);
        if (stringArray.length == 0 && string.endsWith(".spardir.zip") && string2.indexOf(".zip|output") >= 0) {
            String string3 = string.replace('\\', '/');
            int n = string.lastIndexOf(".spardir");
            n = string3.lastIndexOf("/");
            string3 = string + "|" + string.substring(n + 1, string.length() - 4);
            return new String[]{"SpartanSmol", string3, string3 + "/output"};
        }
        return ZipUtil.getSpartanFileList(string, stringArray);
    }

    private static String[] getSpartanDirs(String string) {
        if (string == null) {
            return new String[0];
        }
        if (string.startsWith("java.io.FileNotFoundException") || string.startsWith("FILE NOT FOUND") || string.indexOf("<html") >= 0) {
            return new String[]{"M0001"};
        }
        JmolList jmolList = new JmolList();
        String string2 = "";
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\r\n");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.equals(")")) {
                    jmolList.addLast((Object)string2);
                } else if (string3.equals("Start-") && stringTokenizer.nextToken().equals("Molecule")) {
                    jmolList.addLast((Object)TextFormat.split((String)stringTokenizer.nextToken(), (char)'\"')[1]);
                }
                string2 = string3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (String[])jmolList.toArray((Object[])new String[jmolList.size()]);
    }

    private static String[] getSpartanFileList(String string, String[] stringArray) {
        String[] stringArray2 = new String[2 + stringArray.length * 5];
        stringArray2[0] = "SpartanSmol";
        stringArray2[1] = "Directory Entry ";
        int n = 2;
        if ((string = string.replace('\\', '/')).endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = string + (Character.isDigit(stringArray[i].charAt(0)) ? "/Profile." + stringArray[i] : "/" + stringArray[i]);
            stringArray2[n++] = string2 + "/#JMOL_MODEL " + stringArray[i];
            stringArray2[n++] = string2 + "/input";
            stringArray2[n++] = string2 + "/archive";
            stringArray2[n++] = string2 + "/Molecule:asBinaryString";
            stringArray2[n++] = string2 + "/proparc";
        }
        return stringArray2;
    }

    static String[] checkSpecialInZip(String[] stringArray) {
        String[] stringArray2;
        if (stringArray.length < 2) {
            stringArray2 = null;
        } else {
            String string = stringArray[1];
            if (string.endsWith(".spardir/") || stringArray.length == 2) {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "";
                stringArray2 = stringArray3;
                stringArray3[1] = string.endsWith("/") ? string.substring(0, string.length() - 1) : string;
            } else {
                stringArray2 = null;
            }
        }
        return stringArray2;
    }

    public byte[] getCachedPngjBytes(FileManager fileManager, String string) {
        boolean bl;
        if (string.indexOf(".png") < 0) {
            return null;
        }
        Logger.info((String)("FileManager checking PNGJ cache for " + string));
        Object object = ZipUtil.shortSceneFilename(string);
        if (fileManager.pngjCache == null && !this.cachePngjFile(fileManager, new String[]{string, null})) {
            return null;
        }
        Map map = fileManager.pngjCache;
        boolean bl2 = bl = string.indexOf(".min.") >= 0;
        if (!bl) {
            String string2 = fileManager.getCanonicalName(JmolBinary.getZipRoot((String)string));
            if (!map.containsKey(string2) && !this.cachePngjFile(fileManager, new String[]{string, null})) {
                return null;
            }
            if (string.indexOf("|") < 0) {
                object = string2;
            }
        }
        if (map.containsKey(object)) {
            Logger.info((String)("FileManager using memory cache " + (String)object));
            return (byte[])map.get(object);
        }
        for (String string3 : map.keySet()) {
            System.out.println(string3);
        }
        System.out.println("FileManager memory cache (" + map.size() + ") did not find " + string + " as " + (String)object);
        if (!bl || !this.cachePngjFile(fileManager, new String[]{string, null})) {
            return null;
        }
        Logger.info((String)("FileManager using memory cache " + (String)object));
        return (byte[])map.get(object);
    }

    public boolean cachePngjFile(FileManager fileManager, String[] stringArray) {
        Hashtable<String, byte[]> hashtable = fileManager.pngjCache = new Hashtable<String, byte[]>();
        stringArray[1] = null;
        if (stringArray[0] == null) {
            return false;
        }
        stringArray[0] = JmolBinary.getZipRoot((String)stringArray[0]);
        String string = ZipUtil.shortSceneFilename(stringArray[0]);
        try {
            stringArray[1] = this.cacheZipContents(JmolBinary.checkPngZipStream((BufferedInputStream)((BufferedInputStream)fileManager.getBufferedInputStreamOrErrorMessageFromName(stringArray[0], null, false, false, null, false))), string, fileManager.pngjCache);
        }
        catch (Exception exception) {
            return false;
        }
        if (stringArray[1] == null) {
            return false;
        }
        byte[] byArray = stringArray[1].getBytes();
        hashtable.put(fileManager.getCanonicalName(stringArray[0]), byArray);
        if (string.indexOf("_scene_") >= 0) {
            hashtable.put(ZipUtil.shortSceneFilename(stringArray[0]), byArray);
            byArray = (byte[])hashtable.remove(string + "|state.spt");
            if (byArray != null) {
                hashtable.put(ZipUtil.shortSceneFilename(stringArray[0] + "|state.spt"), byArray);
            }
        }
        for (String string2 : hashtable.keySet()) {
            System.out.println(string2);
        }
        return true;
    }

    private static String shortSceneFilename(String string) {
        int n;
        int n2 = string.indexOf("_scene_") + 7;
        if (n2 < 7) {
            return string;
        }
        String string2 = "";
        if (string.endsWith("|state.spt")) {
            n = string.indexOf(46, n2);
            if (n < 0) {
                return string;
            }
            string2 = string.substring(n2, n);
        }
        n = string.lastIndexOf("|");
        return string.substring(0, n2) + string2 + (n > 0 ? string.substring(n) : "");
    }
}

