/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import org.jmol.adapter.readers.more.BinaryReader;
import org.jmol.util.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.P3;
import org.jmol.util.SB;

public class BinaryDcdReader
extends BinaryReader {
    private int nModels;
    private int nAtoms;
    private int nFree;
    private BS bsFree;
    private float[] xAll;
    private float[] yAll;
    private float[] zAll;

    protected void initializeReader() {
        this.initializeTrajectoryFile();
    }

    protected void readDocument() throws Exception {
        int n;
        byte[] byArray = new byte[40];
        int n2 = this.binaryDoc.readInt();
        this.binaryDoc.setStream(null, n2 != 84);
        n2 = this.binaryDoc.readInt();
        this.nModels = this.binaryDoc.readInt();
        this.binaryDoc.readInt();
        this.binaryDoc.readInt();
        this.binaryDoc.readInt();
        this.binaryDoc.readInt();
        this.binaryDoc.readInt();
        this.binaryDoc.readInt();
        int n3 = this.binaryDoc.readInt();
        this.nFree = n3 / 3;
        int n4 = this.binaryDoc.readInt();
        this.binaryDoc.readInt();
        this.binaryDoc.readByteArray(byArray, 0, 36);
        this.binaryDoc.readInt();
        n2 = this.binaryDoc.readInt();
        n2 = this.binaryDoc.readInt();
        n2 = this.binaryDoc.readInt();
        SB sB = new SB();
        for (n = 0; n < n2; ++n) {
            sB.append(this.binaryDoc.readString(80).trim()).appendC('\n');
        }
        n2 = this.binaryDoc.readInt();
        Logger.info((String)("BinaryDcdReadaer:\n" + sB));
        n2 = this.binaryDoc.readInt();
        this.nAtoms = this.binaryDoc.readInt();
        n2 = this.binaryDoc.readInt();
        this.nFree = this.nAtoms - n4;
        if (n4 != 0) {
            this.binaryDoc.readInt();
            this.bsFree = BSUtil.newBitSet((int)this.nFree);
            for (n = 0; n < this.nFree; ++n) {
                this.bsFree.set(this.binaryDoc.readInt() - 1);
            }
            n2 = this.binaryDoc.readInt() / 4;
            Logger.info((String)("free: " + this.bsFree.cardinality() + " " + Escape.eBS((BS)this.bsFree)));
        }
        this.readCoordinates();
        Logger.info((String)("Total number of trajectory steps=" + this.trajectorySteps.size()));
    }

    private float[] readFloatArray() throws Exception {
        int n = this.binaryDoc.readInt() / 4;
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = this.binaryDoc.readFloat();
        }
        n = this.binaryDoc.readInt() / 4;
        if (Logger.debugging) {
            System.out.println(this.modelNumber + " " + this.binaryDoc.getPosition() + ": " + n + " " + fArray[0] + "\t" + fArray[1] + "\t" + fArray[2]);
        }
        return fArray;
    }

    private void readCoordinates() throws Exception {
        int n = this.bsFilter == null ? this.templateAtomCount : (Integer)this.htParams.get("filteredAtomCount");
        for (int i = 0; i < this.nModels; ++i) {
            if (this.doGetModel(++this.modelNumber, null)) {
                P3[] p3Array = new P3[n];
                if (!this.getTrajectoryStep(p3Array)) {
                    return;
                }
                this.trajectorySteps.addLast((Object)p3Array);
                if (!this.isLastModel(this.modelNumber)) continue;
                return;
            }
            this.readFloatArray();
            this.readFloatArray();
            this.readFloatArray();
        }
    }

    private boolean getTrajectoryStep(P3[] p3Array) throws Exception {
        try {
            BS bS;
            int n = p3Array.length;
            int n2 = -1;
            float[] fArray = this.readFloatArray();
            float[] fArray2 = this.readFloatArray();
            float[] fArray3 = this.readFloatArray();
            BS bS2 = bS = this.xAll == null ? null : this.bsFree;
            if (bS == null) {
                this.xAll = fArray;
                this.yAll = fArray2;
                this.zAll = fArray3;
            }
            int n3 = 0;
            for (int i = 0; i < this.nAtoms; ++i) {
                P3 p3 = new P3();
                if (bS == null || bS.get(i)) {
                    p3.set(fArray[n3], fArray2[n3], fArray3[n3]);
                    ++n3;
                } else {
                    p3.set(this.xAll[i], this.yAll[i], this.zAll[i]);
                }
                if (this.bsFilter != null && !this.bsFilter.get(i)) continue;
                if (++n2 == n) {
                    return true;
                }
                p3Array[n2] = p3;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

