/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolMolecule;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BoxInfo;
import org.jmol.modelset.MeasurementData;
import org.jmol.script.ScriptEvaluator;
import org.jmol.script.ScriptVariable;
import org.jmol.script.Token;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.Parser;
import org.jmol.util.Point3fi;
import org.jmol.util.Quaternion;
import org.jmol.util.TextFormat;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.PropertyManager;
import org.jmol.viewer.Viewer;

class ScriptMathProcessor {
    private boolean isSyntaxCheck;
    private boolean wasSyntaxCheck;
    private boolean logMessages;
    private ScriptEvaluator eval;
    private Viewer viewer;
    private Token[] oStack = new Token[8];
    private ScriptVariable[] xStack = new ScriptVariable[8];
    private char[] ifStack = new char[8];
    private int ifPt = -1;
    private int oPt = -1;
    private int xPt = -1;
    private int parenCount;
    private int squareCount;
    private int braceCount;
    private boolean wasX;
    private int incrementX;
    private boolean isArrayItem;
    private boolean asVector;
    private boolean asBitSet;
    private int ptid = 0;
    private int ptx = Integer.MAX_VALUE;
    private boolean skipping;
    private boolean haveSpaceBeforeSquare;
    private int equalCount;

    ScriptMathProcessor(ScriptEvaluator scriptEvaluator, boolean bl, boolean bl2, boolean bl3) {
        this.eval = scriptEvaluator;
        this.viewer = scriptEvaluator.viewer;
        this.logMessages = scriptEvaluator.logMessages;
        this.isSyntaxCheck = this.wasSyntaxCheck = scriptEvaluator.isSyntaxCheck;
        this.isArrayItem = bl;
        this.asVector = bl2 || bl;
        this.asBitSet = bl3;
        this.wasX = bl;
        if (this.logMessages) {
            Logger.info("initialize RPN");
        }
    }

    ScriptVariable getResult(boolean bl) throws ScriptEvaluator.ScriptException {
        boolean bl2 = true;
        ScriptVariable scriptVariable = null;
        while (bl2 && this.oPt >= 0) {
            bl2 = this.operate();
        }
        if (bl2) {
            if (this.asVector) {
                ArrayList<ScriptVariable> arrayList = new ArrayList<ScriptVariable>();
                for (int i = 0; i <= this.xPt; ++i) {
                    arrayList.add(ScriptVariable.selectItem(this.xStack[i]));
                }
                return new ScriptVariable(135233, arrayList);
            }
            if (this.xPt == 0) {
                if (scriptVariable == null) {
                    scriptVariable = this.xStack[0];
                }
                if (scriptVariable.tok == 10 || scriptVariable.tok == 7 || scriptVariable.tok == 4 || scriptVariable.tok == 11 || scriptVariable.tok == 12) {
                    scriptVariable = ScriptVariable.selectItem(scriptVariable);
                }
                if (this.asBitSet && scriptVariable.tok == 7) {
                    scriptVariable = new ScriptVariable(10, ScriptVariable.unEscapeBitSetArray((List)scriptVariable.value, false));
                }
                return scriptVariable;
            }
        }
        if (!(bl || this.xPt < 0 && this.oPt < 0)) {
            this.eval.error(22);
        }
        return null;
    }

    private void putX(ScriptVariable scriptVariable) {
        if (this.skipping) {
            return;
        }
        if (++this.xPt == this.xStack.length) {
            this.xStack = (ScriptVariable[])ArrayUtil.doubleLength(this.xStack);
        }
        if (this.logMessages) {
            Logger.info("\nputX: " + scriptVariable);
        }
        this.xStack[this.xPt] = scriptVariable;
        this.ptx = ++this.ptid;
    }

    private void putOp(Token token) {
        if (++this.oPt >= this.oStack.length) {
            this.oStack = (Token[])ArrayUtil.doubleLength(this.oStack);
        }
        this.oStack[this.oPt] = token;
        ++this.ptid;
    }

    private void putIf(char c) {
        if (++this.ifPt >= this.ifStack.length) {
            this.ifStack = (char[])ArrayUtil.doubleLength((Object)this.ifStack);
        }
        this.ifStack[this.ifPt] = c;
    }

    boolean addX(ScriptVariable scriptVariable) {
        this.putX(scriptVariable);
        this.wasX = true;
        return true;
    }

    boolean addX(Object object) {
        ScriptVariable scriptVariable = ScriptVariable.getVariable(object);
        if (scriptVariable == null) {
            return false;
        }
        this.putX(scriptVariable);
        this.wasX = true;
        return true;
    }

    boolean addX(BitSet bitSet) {
        ScriptVariable scriptVariable = new ScriptVariable(10, bitSet);
        if (scriptVariable == null) {
            return false;
        }
        this.putX(scriptVariable);
        this.wasX = true;
        return true;
    }

    boolean addX(Point3f point3f) {
        ScriptVariable scriptVariable = new ScriptVariable(8, point3f);
        if (scriptVariable == null) {
            return false;
        }
        this.putX(scriptVariable);
        this.wasX = true;
        return true;
    }

    boolean addXNum(ScriptVariable scriptVariable) throws ScriptEvaluator.ScriptException {
        if (this.wasX) {
            switch (scriptVariable.tok) {
                case 2: {
                    if (scriptVariable.intValue >= 0) break;
                    this.addOp(Token.tokenMinus);
                    scriptVariable = ScriptVariable.intVariable(-scriptVariable.intValue);
                    break;
                }
                case 3: {
                    float f = ((Float)scriptVariable.value).floatValue();
                    if (!(f < 0.0f) && (f != 0.0f || 1.0f / f != Float.NEGATIVE_INFINITY)) break;
                    this.addOp(Token.tokenMinus);
                    scriptVariable = new ScriptVariable(3, new Float(-f));
                }
            }
        }
        this.putX(scriptVariable);
        this.wasX = true;
        return true;
    }

    private boolean addX(boolean bl) {
        this.putX(ScriptVariable.getVariable(bl ? Boolean.TRUE : Boolean.FALSE));
        this.wasX = true;
        return true;
    }

    private boolean addX(int n) {
        this.putX(ScriptVariable.intVariable(n));
        this.wasX = true;
        return true;
    }

    private boolean addX(float f) {
        return Float.isNaN(f) ? this.addX("NaN") : this.addX(new Float(f));
    }

    private static boolean isOpFunc(Token token) {
        return Token.tokAttr(token.tok, 0x8100000) && token != Token.tokenArraySquare || token.tok == 0x101000D1 && Token.tokAttr(token.intValue, 0x8100000);
    }

    boolean addOp(Token token) throws ScriptEvaluator.ScriptException {
        return this.addOp(token, true);
    }

    boolean addOp(Token token, boolean bl) throws ScriptEvaluator.ScriptException {
        boolean bl2;
        boolean bl3;
        if (this.logMessages) {
            Logger.info("addOp entry\naddOp: " + token);
        }
        int n = this.oPt >= 0 ? this.oStack[this.oPt].tok : 0;
        boolean bl4 = this.skipping = this.ifPt >= 0 && (this.ifStack[this.ifPt] == 'F' || this.ifStack[this.ifPt] == 'X');
        if (this.skipping) {
            switch (token.tok) {
                case 0x10100010: {
                    this.putOp(token);
                    return true;
                }
                case 0x10100022: {
                    if (n != 0x10100022 || this.ifStack[this.ifPt] == 'X') {
                        return true;
                    }
                    this.ifStack[this.ifPt] = 84;
                    this.wasX = false;
                    this.skipping = false;
                    return true;
                }
                case 0x10100011: {
                    if (n == 0x10100010) {
                        --this.oPt;
                        return true;
                    }
                    if (n != 0x10100022) {
                        this.putOp(token);
                        return true;
                    }
                    this.wasX = true;
                    --this.ifPt;
                    this.oPt -= 2;
                    this.skipping = false;
                    return true;
                }
            }
            return true;
        }
        Token token2 = null;
        boolean bl5 = false;
        boolean bl6 = bl3 = token.tok == 0x101000D1;
        if (bl3 && !this.wasX) {
            return false;
        }
        boolean bl7 = bl2 = bl && ScriptMathProcessor.isOpFunc(token);
        if (this.oPt >= 1 && token.tok != 0x10100010 && n == 135266313) {
            n = this.oStack[--this.oPt].tok;
        }
        boolean bl8 = this.oPt >= 1 && n == 0x10100010;
        switch (token.tok) {
            case 1073742195: {
                this.haveSpaceBeforeSquare = true;
                return true;
            }
            case 0x10100030: {
                if (this.wasX) break;
                return false;
            }
            case 32: 
            case 64: 
            case 96: 
            case 128: 
            case 160: 
            case 192: 
            case 480: {
                int n2;
                int n3 = n2 = this.oPt < 0 ? 0 : n;
                if (!this.wasX || n2 != 0x101000D1 && n2 != 1678770178 && n2 != 0x44100001) {
                    return false;
                }
                this.oStack[this.oPt].intValue |= token.tok;
                return true;
            }
            case 0x10100040: {
                bl5 = true;
                if (this.wasX && !this.haveSpaceBeforeSquare) break;
                ++this.squareCount;
                token = token2 = Token.tokenArraySquare;
                this.haveSpaceBeforeSquare = false;
                break;
            }
            case 0x10100041: {
                break;
            }
            case 0x101000C1: 
            case 269484226: {
                int n4 = this.incrementX = token.tok == 269484226 ? 1 : -1;
                if (this.ptid != this.ptx) break;
                if (this.isSyntaxCheck) {
                    return true;
                }
                ScriptVariable scriptVariable = this.xStack[this.xPt];
                this.xStack[this.xPt] = new ScriptVariable().set(scriptVariable, false);
                return scriptVariable.increment(this.incrementX);
            }
            case 0x101000A0: {
                if (this.wasX) break;
                this.addX(0);
                token = new ScriptVariable(0x101000C0, "-");
                break;
            }
            case 0x10100011: {
                if (this.wasX || this.oPt < 1 || n != 0x10100010 || ScriptMathProcessor.isOpFunc(this.oStack[this.oPt - 1])) break;
                return false;
            }
            case 0x10100010: 
            case 0x10100070: {
                bl5 = true;
            }
            default: {
                if (bl2) {
                    if (!bl3 && this.wasX && !bl8) {
                        return false;
                    }
                    token2 = token;
                    bl5 = true;
                    break;
                }
                if (this.wasX != bl5 || n == 0x101000D1) break;
                return false;
            }
        }
        while (!(this.oPt < 0 || n == 0x10100022 || bl5 && (n != 0x101000D1 || token.tok != 0x101000D1 && token.tok != 0x10100040) || Token.getPrecedence(n) < Token.getPrecedence(token.tok))) {
            if (this.logMessages) {
                Logger.info("\noperating, oPt=" + this.oPt + " isLeftOp=" + bl5 + " oStack[oPt]=" + Token.nameOf(n) + "        prec=" + Token.getPrecedence(n) + " pending op=\"" + Token.nameOf(token.tok) + "\" prec=" + Token.getPrecedence(token.tok));
                this.dumpStacks("operating");
            }
            if (token.tok == 0x10100011 && n == 0x10100010) {
                if (this.xPt < 0) break;
                this.xStack[this.xPt] = ScriptVariable.selectItem(this.xStack[this.xPt]);
                break;
            }
            if (token.tok == 0x10100041 && n == 0x8100001) break;
            if (token.tok == 0x10100041 && n == 0x10100040) {
                if (this.isArrayItem && this.squareCount == 1 && this.equalCount == 0) {
                    this.addX(new ScriptVariable(Token.tokenArraySelector));
                    break;
                }
                if (this.doBitsetSelect()) break;
                return false;
            }
            if (!this.operate()) {
                return false;
            }
            n = this.oPt >= 0 ? this.oStack[this.oPt].tok : 0;
        }
        if (token2 != null) {
            this.addX(new ScriptVariable(269484436, token2));
        }
        switch (token.tok) {
            case 0x10100010: {
                ++this.parenCount;
                this.wasX = false;
                break;
            }
            case 806354977: {
                boolean bl9 = ScriptVariable.bValue(this.getX());
                if (n == 0x10100022) {
                    --this.ifPt;
                } else {
                    this.putOp(Token.tokenColon);
                }
                this.putIf(bl9 ? (char)'T' : 'F');
                this.skipping = !bl9;
                this.wasX = false;
                return true;
            }
            case 0x10100022: {
                if (n != 0x10100022) {
                    return false;
                }
                if (this.ifPt < 0) {
                    return false;
                }
                this.ifStack[this.ifPt] = 88;
                this.wasX = false;
                this.skipping = true;
                return true;
            }
            case 0x10100011: {
                this.wasX = true;
                if (this.parenCount-- <= 0) {
                    return false;
                }
                if (n == 0x10100022) {
                    --this.ifPt;
                    --this.oPt;
                }
                --this.oPt;
                if (this.oPt < 0) {
                    return true;
                }
                if (ScriptMathProcessor.isOpFunc(this.oStack[this.oPt]) && !this.evaluateFunction(0)) {
                    return false;
                }
                this.skipping = this.ifPt >= 0 && this.ifStack[this.ifPt] == 'X';
                return true;
            }
            case 0x10100030: {
                this.wasX = false;
                return true;
            }
            case 0x10100040: {
                ++this.squareCount;
                this.wasX = false;
                break;
            }
            case 0x10100041: {
                this.wasX = true;
                if (this.squareCount-- <= 0 || this.oPt < 0) {
                    return false;
                }
                if (this.oStack[this.oPt].tok == 0x8100001) {
                    return this.evaluateFunction(0x10100040);
                }
                --this.oPt;
                return true;
            }
            case 0x101000D1: {
                this.wasX = !bl || !Token.tokAttr(token.intValue, 0x8100000);
                break;
            }
            case 0x10000A: {
                ++this.braceCount;
                this.wasX = false;
                break;
            }
            case 0x10000E: {
                if (this.braceCount-- <= 0) {
                    return false;
                }
                this.wasX = false;
                break;
            }
            case 0x10100050: 
            case 0x10100060: {
                if (!this.wasSyntaxCheck && this.xStack[this.xPt].tok != 10 && this.xStack[this.xPt].tok != 7) {
                    boolean bl10 = ScriptVariable.bValue(this.getX());
                    this.addX(ScriptVariable.getBoolean(bl10));
                    if (bl10 == (token.tok == 0x10100050)) {
                        this.isSyntaxCheck = true;
                        token = token.tok == 0x10100050 ? Token.tokenOrTRUE : Token.tokenAndFALSE;
                    }
                }
                this.wasX = false;
                break;
            }
            case 269484436: {
                if (this.squareCount == 0) {
                    ++this.equalCount;
                }
                this.wasX = false;
                break;
            }
            default: {
                this.wasX = false;
            }
        }
        this.putOp(token);
        if (token.tok == 0x101000D1 && (token.intValue & 0xFFFFFE1F) == 135368708 && token.intValue != 135368708) {
            return this.evaluateFunction(0);
        }
        return true;
    }

    private boolean doBitsetSelect() {
        if (this.xPt < 0 || this.xPt == 0 && !this.isArrayItem) {
            return false;
        }
        ScriptVariable scriptVariable = this.xStack[this.xPt--];
        ScriptVariable scriptVariable2 = this.xStack[this.xPt];
        if (scriptVariable2.tok == 6) {
            ScriptVariable scriptVariable3 = scriptVariable2.mapValue(ScriptVariable.sValue(scriptVariable));
            this.xStack[this.xPt] = scriptVariable3 == null ? ScriptVariable.getVariable("") : scriptVariable3;
            return true;
        }
        int n = ScriptVariable.iValue(scriptVariable);
        switch (scriptVariable2.tok) {
            default: {
                scriptVariable2 = new ScriptVariable(4, ScriptVariable.sValue(scriptVariable2));
            }
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
        }
        this.xStack[this.xPt] = ScriptVariable.selectItem(scriptVariable2, n);
        return true;
    }

    void dumpStacks(String string) {
        int n;
        Logger.info("\n\n------------------\nRPN stacks: " + string + "\n");
        for (n = 0; n <= this.xPt; ++n) {
            Logger.info("x[" + n + "]: " + this.xStack[n]);
        }
        Logger.info("\n");
        for (n = 0; n <= this.oPt; ++n) {
            Logger.info("o[" + n + "]: " + this.oStack[n] + " prec=" + Token.getPrecedence(this.oStack[n].tok));
        }
        Logger.info(" ifStack = " + new String(this.ifStack).substring(0, this.ifPt + 1));
    }

    private ScriptVariable getX() throws ScriptEvaluator.ScriptException {
        if (this.xPt < 0) {
            this.eval.error(13);
        }
        ScriptVariable scriptVariable = ScriptVariable.selectItem(this.xStack[this.xPt]);
        this.xStack[this.xPt--] = null;
        return scriptVariable;
    }

    private boolean evaluateFunction(int n) throws ScriptEvaluator.ScriptException {
        Token token = this.oStack[this.oPt--];
        if (n == 0) {
            n = token.tok == 0x101000D1 ? token.intValue & 0xFFFFFE1F : token.tok;
        }
        int n2 = Token.getMaxMathParams(n);
        int n3 = 0;
        int n4 = this.xPt;
        while (n4 >= 0 && this.xStack[n4--].value != token) {
            ++n3;
        }
        if (n2 > 0 && n3 > n2) {
            return false;
        }
        ScriptVariable[] scriptVariableArray = new ScriptVariable[n3];
        int n5 = n3;
        while (--n5 >= 0) {
            scriptVariableArray[n5] = this.getX();
        }
        --this.xPt;
        if (this.isSyntaxCheck) {
            return token.tok == 0x101000D1 ? true : this.addX(true);
        }
        switch (n) {
            case 0x8100011: 
            case 135266819: 
            case 135266820: 
            case 135266821: 
            case 135266822: 
            case 135266826: {
                return this.evaluateMath(scriptVariableArray, n);
            }
            case 1276117504: 
            case 1276117507: 
            case 1276117509: 
            case 1276118017: {
                return this.evaluateList(token.intValue, scriptVariableArray);
            }
            case 0x8100001: 
            case 0x10100040: {
                return this.evaluateArray(scriptVariableArray, n == 0x10100040);
            }
            case 135266316: 
            case 135270411: {
                return this.evaluateQuaternion(scriptVariableArray, n);
            }
            case 1276118529: {
                return this.evaluateBin(scriptVariableArray);
            }
            case 1276117512: 
            case 1276117513: {
                return this.evaluateRowCol(scriptVariableArray, n);
            }
            case 1632638983: {
                return this.evaluateColor(scriptVariableArray);
            }
            case 135270413: {
                return this.evaluateCompare(scriptVariableArray);
            }
            case 135266319: {
                return this.evaluateConnected(scriptVariableArray);
            }
            case 135267329: {
                return this.evaluateCross(scriptVariableArray);
            }
            case 0x8101008: {
                return this.evaluateData(scriptVariableArray);
            }
            case 135266311: 
            case 1276117505: 
            case 1276118018: 
            case 1746538503: {
                if ((n == 1276118018 || n == 1276117505) && token.tok == 0x101000D1) {
                    return this.evaluateDot(scriptVariableArray, n);
                }
                return this.evaluateMeasure(scriptVariableArray, token.tok);
            }
            case 135271426: 
            case 1229984263: {
                return this.evaluateLoad(scriptVariableArray, n);
            }
            case 1276118532: {
                return this.evaluateFind(scriptVariableArray);
            }
            case 135368708: {
                return this.evaluateUserFunction((String)token.value, scriptVariableArray, token.intValue, token.tok == 0x101000D1);
            }
            case 1288701954: 
            case 1826248707: {
                return this.evaluateLabel(token.intValue, scriptVariableArray);
            }
            case 135270405: {
                return this.evaluateGetProperty(scriptVariableArray);
            }
            case 137363472: {
                return this.evaluateHelix(scriptVariableArray);
            }
            case 135266313: 
            case 135267841: {
                return this.evaluatePlane(scriptVariableArray, n);
            }
            case 135271429: 
            case 135287308: {
                return this.evaluateScript(scriptVariableArray, n);
            }
            case 1276117506: 
            case 1276117508: 
            case 1276117510: {
                return this.evaluateString(token.intValue, scriptVariableArray);
            }
            case 135266314: {
                return this.evaluatePoint(scriptVariableArray);
            }
            case 135304706: {
                return this.evaluatePrompt(scriptVariableArray);
            }
            case 135267332: {
                return this.evaluateRandom(scriptVariableArray);
            }
            case 1276118019: {
                return this.evaluateReplace(scriptVariableArray);
            }
            case 135267335: 
            case 135267336: 
            case 1238369286: {
                return this.evaluateSubstructure(scriptVariableArray, n);
            }
            case 1141899271: {
                return this.evaluateSort(scriptVariableArray);
            }
            case 1297090050: {
                return this.evaluateSymop(scriptVariableArray, token.tok == 0x101000D1);
            }
            case 1313866247: {
                return this.evaluateVolume(scriptVariableArray);
            }
            case 135266318: {
                return this.evaluateWithin(scriptVariableArray);
            }
            case 135270406: {
                return this.evaluateWrite(scriptVariableArray);
            }
        }
        return false;
    }

    private boolean evaluateCompare(ScriptVariable[] scriptVariableArray) throws ScriptEvaluator.ScriptException {
        if (scriptVariableArray.length < 2 || scriptVariableArray.length > 5) {
            return false;
        }
        String string = ScriptVariable.sValue(scriptVariableArray[scriptVariableArray.length - 1]);
        boolean bl = string.equalsIgnoreCase("stddev");
        boolean bl2 = string.equalsIgnoreCase("ISOMER");
        boolean bl3 = !bl2 && scriptVariableArray.length > (bl ? 3 : 2);
        BitSet bitSet = scriptVariableArray[0].tok == 10 ? (BitSet)scriptVariableArray[0].value : null;
        BitSet bitSet2 = scriptVariableArray[1].tok == 10 ? (BitSet)scriptVariableArray[1].value : null;
        String string2 = bitSet == null ? ScriptVariable.sValue(scriptVariableArray[0]) : "";
        String string3 = bitSet2 == null ? ScriptVariable.sValue(scriptVariableArray[1]) : "";
        Matrix4f matrix4f = new Matrix4f();
        float f = Float.NaN;
        if (bl3 && (bitSet == null || bitSet2 == null)) {
            return false;
        }
        if (bl2) {
            boolean bl4;
            String string4;
            if (scriptVariableArray.length != 3) {
                return false;
            }
            String string5 = bitSet == null ? this.viewer.getSmilesMatcher().getMolecularFormula(string2, false) : JmolMolecule.getMolecularFormula(this.viewer.getModelSet().atoms, bitSet, false);
            String string6 = string4 = bitSet2 == null ? this.viewer.getSmilesMatcher().getMolecularFormula(string3, false) : JmolMolecule.getMolecularFormula(this.viewer.getModelSet().atoms, bitSet2, false);
            if (!string5.equals(string4)) {
                return this.addX("NONE");
            }
            if (bitSet != null) {
                string2 = (String)this.eval.getSmilesMatches("", null, bitSet, null, false, true);
            }
            if (bitSet2 == null) {
                bl4 = this.viewer.getSmilesMatcher().areEqual(string3, string2) > 0;
            } else {
                boolean bl5 = bl4 = ((BitSet)this.eval.getSmilesMatches(string2, null, bitSet2, null, false, true)).nextSetBit(0) >= 0;
            }
            if (!bl4) {
                String string7 = string2 + string3;
                if (string7.indexOf("/") >= 0 || string7.indexOf("\\") >= 0 || string7.indexOf("@") >= 0) {
                    if (string2.indexOf("@") >= 0 && (bitSet2 != null || string3.indexOf("@") >= 0)) {
                        string2 = TextFormat.simpleReplace(string2, "@@", "!@");
                        string2 = TextFormat.simpleReplace(string2, "@", "@@");
                        string2 = TextFormat.simpleReplace(string2, "!@@", "@");
                        string2 = TextFormat.simpleReplace(string2, "@@SP", "@SP");
                        string2 = TextFormat.simpleReplace(string2, "@@OH", "@OH");
                        string2 = TextFormat.simpleReplace(string2, "@@TB", "@TB");
                        if (bitSet2 == null) {
                            bl4 = this.viewer.getSmilesMatcher().areEqual(string2, string3) > 0;
                        } else {
                            boolean bl6 = bl4 = ((BitSet)this.eval.getSmilesMatches(string2, null, bitSet2, null, false, true)).nextSetBit(0) >= 0;
                        }
                        if (bl4) {
                            return this.addX("ENANTIOMERS");
                        }
                    }
                    if (bitSet2 == null) {
                        bl4 = this.viewer.getSmilesMatcher().areEqual("/nostereo/" + string3, string2) > 0;
                    } else {
                        Object object = this.eval.getSmilesMatches("/nostereo/" + string2, null, bitSet2, null, false, true);
                        boolean bl7 = bl4 = ((BitSet)object).nextSetBit(0) >= 0;
                    }
                    if (bl4) {
                        return this.addX("DIASTERIOMERS");
                    }
                }
                return this.addX("CONSTITUTIONAL ISOMERS");
            }
            if (bitSet == null || bitSet2 == null) {
                return this.addX("IDENTICAL");
            }
            f = this.eval.getSmilesCorrelation(bitSet, bitSet2, string2, null, null, null, null, false);
            return this.addX(f < 0.2f ? "IDENTICAL" : "IDENTICAL or CONFORMATIONAL ISOMERS (RMSD=" + f + ")");
        }
        if (bl3) {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            string = ScriptVariable.sValue(scriptVariableArray[2]);
            bl3 = string.equalsIgnoreCase("SMILES");
            boolean bl8 = string.equalsIgnoreCase("SMARTS");
            if (bl3 || bl8) {
                String string8 = string = scriptVariableArray.length > 3 ? ScriptVariable.sValue(scriptVariableArray[3]) : null;
            }
            if (string == null) {
                return false;
            }
            f = this.eval.getSmilesCorrelation(bitSet, bitSet2, string, arrayList, arrayList2, matrix4f, null, !bl3);
        } else {
            List list = this.eval.getPointVector(scriptVariableArray[0], 0);
            List list2 = this.eval.getPointVector(scriptVariableArray[1], 0);
            if (list != null && list2 != null) {
                f = Measure.getTransformMatrix4(list, list2, matrix4f, null);
            }
        }
        return bl || Float.isNaN(f) ? this.addX(f) : this.addX(matrix4f);
    }

    private boolean evaluateVolume(ScriptVariable[] scriptVariableArray) throws ScriptEvaluator.ScriptException {
        ScriptVariable scriptVariable = this.getX();
        if (scriptVariable.tok != 10) {
            return false;
        }
        String string = scriptVariableArray.length == 0 ? null : ScriptVariable.sValue(scriptVariableArray[0]);
        return this.addX(this.viewer.getVolume((BitSet)scriptVariable.value, string));
    }

    private boolean evaluateSort(ScriptVariable[] scriptVariableArray) throws ScriptEvaluator.ScriptException {
        if (scriptVariableArray.length > 1) {
            return false;
        }
        int n = ScriptVariable.iValue(scriptVariableArray[0]);
        return this.addX(this.getX().sortOrReverse(n));
    }

    private boolean evaluateSymop(ScriptVariable[] scriptVariableArray, boolean bl) throws ScriptEvaluator.ScriptException {
        Point3f point3f;
        String string;
        ScriptVariable scriptVariable;
        if (scriptVariableArray.length == 0) {
            return false;
        }
        ScriptVariable scriptVariable2 = scriptVariable = bl ? this.getX() : null;
        if (scriptVariable != null && scriptVariable.tok != 10) {
            return false;
        }
        BitSet bitSet = scriptVariable != null ? (BitSet)scriptVariable.value : (scriptVariableArray.length > 2 && scriptVariableArray[1].tok == 10 ? (BitSet)scriptVariableArray[1].value : this.viewer.getModelUndeletedAtomsBitSet(-1));
        switch (scriptVariableArray[0].tok) {
            case 4: {
                string = ScriptVariable.sValue(scriptVariableArray[0]);
                break;
            }
            case 12: {
                string = scriptVariableArray[0].escape();
                break;
            }
            default: {
                string = null;
            }
        }
        int n = string == null ? ScriptVariable.iValue(scriptVariableArray[0]) : 0;
        Point3f point3f2 = point3f = scriptVariableArray.length > 1 ? this.ptValue(scriptVariableArray[1], true) : null;
        if (scriptVariableArray.length == 2 && !Float.isNaN(point3f.x)) {
            return this.addX(this.viewer.getSymmetryInfo(bitSet, string, n, point3f, null, null, 135266314));
        }
        String string2 = (scriptVariableArray.length == 1 ? "" : ScriptVariable.sValue(scriptVariableArray[scriptVariableArray.length - 1])).toLowerCase();
        int n2 = 135184;
        if (scriptVariableArray.length == 1 || string2.equalsIgnoreCase("matrix")) {
            n2 = 12;
        } else if (string2.equalsIgnoreCase("array") || string2.equalsIgnoreCase("list")) {
            n2 = 1073742001;
        } else if (string2.equalsIgnoreCase("description")) {
            n2 = 1826248707;
        } else if (string2.equalsIgnoreCase("xyz")) {
            n2 = 1073741982;
        } else if (string2.equalsIgnoreCase("translation")) {
            n2 = 1073742178;
        } else if (string2.equalsIgnoreCase("axis")) {
            n2 = 1073741854;
        } else if (string2.equalsIgnoreCase("plane")) {
            n2 = 135266313;
        } else if (string2.equalsIgnoreCase("angle")) {
            n2 = 135266311;
        } else if (string2.equalsIgnoreCase("axispoint")) {
            n2 = 135266314;
        } else if (string2.equalsIgnoreCase("center")) {
            n2 = 12289;
        }
        return this.addX(this.viewer.getSymmetryInfo(bitSet, string, n, point3f, null, string2, n2));
    }

    private boolean evaluateBin(ScriptVariable[] scriptVariableArray) throws ScriptEvaluator.ScriptException {
        float[] fArray;
        boolean bl;
        if (scriptVariableArray.length != 3) {
            return false;
        }
        ScriptVariable scriptVariable = this.getX();
        boolean bl2 = bl = scriptVariable.tok == 13;
        if (!bl && scriptVariable.tok != 7) {
            return this.addX(scriptVariable);
        }
        float f = ScriptVariable.fValue(scriptVariableArray[0]);
        float f2 = ScriptVariable.fValue(scriptVariableArray[1]);
        float f3 = ScriptVariable.fValue(scriptVariableArray[2]);
        if (bl) {
            fArray = (float[])scriptVariable.value;
        } else {
            List list = scriptVariable.getList();
            fArray = new float[list.size()];
            int n = list.size();
            while (--n >= 0) {
                fArray[n] = ScriptVariable.fValue((ScriptVariable)list.get(n));
            }
        }
        int n = (int)((f2 - f) / f3 + 0.01f);
        int[] nArray = new int[n];
        int n2 = fArray.length;
        for (int i = 0; i < n2; ++i) {
            float f4 = fArray[i];
            int n3 = (int)((f4 - f) / f3);
            if (n3 < 0) {
                n3 = 0;
            } else if (n3 >= n) {
                n3 = n;
            }
            int n4 = n3;
            nArray[n4] = nArray[n4] + 1;
        }
        return this.addX(nArray);
    }

    private boolean evaluateHelix(ScriptVariable[] scriptVariableArray) throws ScriptEvaluator.ScriptException {
        if (scriptVariableArray.length < 1 || scriptVariableArray.length > 5) {
            return false;
        }
        int n = scriptVariableArray.length > 2 ? 3 : 1;
        String string = (n >= scriptVariableArray.length ? "array" : ScriptVariable.sValue(scriptVariableArray[n])).toLowerCase();
        int n2 = Token.getTokFromName(string);
        if (scriptVariableArray.length > 2) {
            Point3f point3f = this.ptValue(scriptVariableArray[0], true);
            Point3f point3f2 = this.ptValue(scriptVariableArray[1], true);
            if (scriptVariableArray[2].tok != 9) {
                return false;
            }
            Quaternion quaternion = new Quaternion((Point4f)scriptVariableArray[2].value);
            switch (n2) {
                case 0: {
                    break;
                }
                case 135266311: 
                case 135266314: 
                case 1073741854: 
                case 1666189313: 
                case 1746538503: {
                    return this.addX(Measure.computeHelicalAxis(null, n2, point3f, point3f2, quaternion));
                }
                case 0x8100001: {
                    String[] stringArray = (String[])Measure.computeHelicalAxis(null, 1073742001, point3f, point3f2, quaternion);
                    if (stringArray == null) {
                        return false;
                    }
                    return this.addX(stringArray);
                }
                default: {
                    return this.addX(Measure.computeHelicalAxis(string, 135184, point3f, point3f2, quaternion));
                }
            }
        } else {
            BitSet bitSet = scriptVariableArray[0].value instanceof BitSet ? (BitSet)scriptVariableArray[0].value : this.eval.compareInt(1095761937, 269484436, ScriptVariable.iValue(scriptVariableArray[0]));
            switch (n2) {
                case 135266314: {
                    return this.addX(this.viewer.getHelixData(bitSet, 135266314));
                }
                case 1073741854: {
                    return this.addX(this.viewer.getHelixData(bitSet, 1073741854));
                }
                case 1666189313: {
                    return this.addX(this.viewer.getHelixData(bitSet, 1666189313));
                }
                case 135266311: {
                    return this.addX(((Float)this.viewer.getHelixData(bitSet, 135266311)).floatValue());
                }
                case 135184: 
                case 1746538503: {
                    return this.addX(this.viewer.getHelixData(bitSet, n2));
                }
                case 0x8100001: {
                    String[] stringArray = (String[])this.viewer.getHelixData(bitSet, 1073742001);
                    if (stringArray == null) {
                        return false;
                    }
                    return this.addX(stringArray);
                }
            }
        }
        return false;
    }

    private boolean evaluateDot(ScriptVariable[] scriptVariableArray, int n) throws ScriptEvaluator.ScriptException {
        if (scriptVariableArray.length != 1) {
            return false;
        }
        ScriptVariable scriptVariable = this.getX();
        ScriptVariable scriptVariable2 = scriptVariableArray[0];
        Point3f point3f = this.ptValue(scriptVariable2, true);
        Point4f point4f = this.planeValue(scriptVariable2);
        if (scriptVariable.tok == 10 && n != 1276117505) {
            return this.addX(this.eval.getBitsetProperty(ScriptVariable.bsSelect(scriptVariable), 1276118018, point3f, point4f, scriptVariable.value, null, false, scriptVariable.index, false));
        }
        Point3f point3f2 = this.ptValue(scriptVariable, true);
        Point4f point4f2 = this.planeValue(scriptVariable);
        if (n == 1276117505) {
            if (point4f2 != null && point4f != null) {
                return this.addX(point4f2.x * point4f.x + point4f2.y * point4f.y + point4f2.z * point4f.z + point4f2.w * point4f.w);
            }
            if (point4f2 != null) {
                point3f2 = new Point3f(point4f2.x, point4f2.y, point4f2.z);
            }
            if (point4f != null) {
                point3f = new Point3f(point4f.x, point4f.y, point4f.z);
            }
            return this.addX(point3f2.x * point3f.x + point3f2.y * point3f.y + point3f2.z * point3f.z);
        }
        if (point4f2 == null) {
            return this.addX(point4f == null ? point3f.distance(point3f2) : Measure.distanceToPlane(point4f, point3f2));
        }
        return this.addX(Measure.distanceToPlane(point4f2, point3f));
    }

    public Point3f ptValue(ScriptVariable scriptVariable, boolean bl) throws ScriptEvaluator.ScriptException {
        if (this.isSyntaxCheck) {
            return new Point3f();
        }
        switch (scriptVariable.tok) {
            case 8: {
                return (Point3f)scriptVariable.value;
            }
            case 10: {
                return (Point3f)this.eval.getBitsetProperty(ScriptVariable.bsSelect(scriptVariable), 1146095626, null, null, scriptVariable.value, null, false, Integer.MAX_VALUE, false);
            }
            case 4: {
                Object object = Escape.unescapePoint(ScriptVariable.sValue(scriptVariable));
                if (!(object instanceof Point3f)) break;
                return (Point3f)object;
            }
            case 7: {
                Object object = Escape.unescapePoint("{" + ScriptVariable.sValue(scriptVariable) + "}");
                if (!(object instanceof Point3f)) break;
                return (Point3f)object;
            }
        }
        if (!bl) {
            return null;
        }
        float f = ScriptVariable.fValue(scriptVariable);
        return new Point3f(f, f, f);
    }

    private Point4f planeValue(Token token) {
        if (this.isSyntaxCheck) {
            return new Point4f();
        }
        switch (token.tok) {
            case 9: {
                return (Point4f)token.value;
            }
            case 4: 
            case 7: {
                Object object = Escape.unescapePoint(ScriptVariable.sValue(token));
                return object instanceof Point4f ? (Point4f)object : null;
            }
        }
        return null;
    }

    private boolean evaluateMeasure(ScriptVariable[] scriptVariableArray, int n) throws ScriptEvaluator.ScriptException {
        int n2 = 0;
        switch (n) {
            case 1746538503: {
                ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
                float[] fArray = new float[]{Float.MAX_VALUE, Float.MAX_VALUE};
                String string = null;
                String string2 = null;
                boolean bl = false;
                boolean bl2 = false;
                int n3 = 0;
                boolean bl3 = false;
                block15: for (int i = 0; i < scriptVariableArray.length; ++i) {
                    switch (scriptVariableArray[i].tok) {
                        case 10: {
                            BitSet bitSet = (BitSet)scriptVariableArray[i].value;
                            if (bitSet.length() == 0) {
                                bl3 = true;
                            }
                            arrayList.add(bitSet);
                            ++n2;
                            continue block15;
                        }
                        case 8: {
                            Point3fi point3fi = new Point3fi((Point3f)scriptVariableArray[i].value);
                            arrayList.add(point3fi);
                            ++n2;
                            continue block15;
                        }
                        case 2: 
                        case 3: {
                            fArray[n3++ % 2] = ScriptVariable.fValue(scriptVariableArray[i]);
                            continue block15;
                        }
                        case 4: {
                            String string3 = ScriptVariable.sValue(scriptVariableArray[i]);
                            if (string3.equalsIgnoreCase("notConnected")) {
                                bl2 = true;
                                continue block15;
                            }
                            if (string3.equalsIgnoreCase("connected")) {
                                bl = true;
                                continue block15;
                            }
                            if (Parser.isOneOf(string3.toLowerCase(), "nm;nanometers;pm;picometers;angstroms;ang;au")) {
                                string2 = string3.toLowerCase();
                                continue block15;
                            }
                            string = n2 + ":" + string3;
                            continue block15;
                        }
                        default: {
                            return false;
                        }
                    }
                }
                if (n2 < 2 || n2 > 4 || n3 > 2 || bl2 && bl) {
                    return false;
                }
                if (bl3) {
                    return this.addX("");
                }
                MeasurementData measurementData = new MeasurementData(arrayList, 0, fArray, string, string2, null, bl, bl2, true);
                return this.addX(measurementData.getMeasurements(this.viewer));
            }
            case 135266311: {
                n2 = scriptVariableArray.length;
                if (n2 == 3 || n2 == 4) break;
                return false;
            }
            default: {
                n2 = scriptVariableArray.length;
                if (n2 == 2) break;
                return false;
            }
        }
        Point3f[] point3fArray = new Point3f[n2];
        for (int i = 0; i < n2; ++i) {
            point3fArray[i] = this.ptValue(scriptVariableArray[i], true);
        }
        switch (n2) {
            case 2: {
                return this.addX(point3fArray[0].distance(point3fArray[1]));
            }
            case 3: {
                return this.addX(Measure.computeAngle(point3fArray[0], point3fArray[1], point3fArray[2], true));
            }
            case 4: {
                return this.addX(Measure.computeTorsion(point3fArray[0], point3fArray[1], point3fArray[2], point3fArray[3], true));
            }
        }
        return false;
    }

    private boolean evaluateUserFunction(String string, ScriptVariable[] scriptVariableArray, int n, boolean bl) throws ScriptEvaluator.ScriptException {
        ScriptVariable scriptVariable = null;
        if (bl) {
            scriptVariable = this.getX();
            if (scriptVariable.tok != 10) {
                return false;
            }
        }
        this.wasX = false;
        ArrayList<ScriptVariable> arrayList = new ArrayList<ScriptVariable>();
        for (int i = 0; i < scriptVariableArray.length; ++i) {
            arrayList.add(scriptVariableArray[i]);
        }
        if (bl) {
            return this.addX(this.eval.getBitsetProperty(ScriptVariable.bsSelect(scriptVariable), n, null, null, scriptVariable.value, new Object[]{string, arrayList}, false, scriptVariable.index, false));
        }
        ScriptVariable scriptVariable2 = this.eval.runFunction(null, string, arrayList, null, true);
        return scriptVariable2 == null ? false : this.addX(scriptVariable2);
    }

    private boolean evaluateFind(ScriptVariable[] scriptVariableArray) throws ScriptEvaluator.ScriptException {
        boolean bl;
        if (scriptVariableArray.length == 0) {
            return false;
        }
        ScriptVariable scriptVariable = this.getX();
        String string = ScriptVariable.sValue(scriptVariableArray[0]);
        String string2 = scriptVariableArray.length > 1 && scriptVariableArray[1].tok != 0x10000D && scriptVariableArray[1].tok != 0x10000C ? ScriptVariable.sValue(scriptVariableArray[1]) : "";
        boolean bl2 = string.equalsIgnoreCase("SEQUENCE");
        boolean bl3 = string.equalsIgnoreCase("SMILES");
        boolean bl4 = string.equalsIgnoreCase("SMARTS");
        boolean bl5 = string.equalsIgnoreCase("MF");
        if (bl3 || bl4 || scriptVariable.tok == 10) {
            int n = bl3 || bl4 ? 2 : 1;
            BitSet bitSet = n < scriptVariableArray.length && scriptVariableArray[n].tok == 10 ? (BitSet)scriptVariableArray[n++].value : null;
            boolean bl6 = scriptVariableArray[scriptVariableArray.length - 1].tok == 0x10000D;
            Object object = null;
            switch (scriptVariable.tok) {
                case 4: {
                    String string3 = ScriptVariable.sValue(scriptVariable);
                    if (bitSet != null) {
                        return false;
                    }
                    if (string2.equalsIgnoreCase("mf")) {
                        object = this.viewer.getSmilesMatcher().getMolecularFormula(string3, bl4);
                        if (object != null) break;
                        this.eval.evalError(this.viewer.getSmilesMatcher().getLastException(), null);
                        break;
                    }
                    object = this.eval.getSmilesMatches(string2, string3, null, null, bl4, !bl6);
                    break;
                }
                case 10: {
                    if (bl5) {
                        return this.addX(JmolMolecule.getMolecularFormula(this.viewer.getModelSet().atoms, (BitSet)scriptVariable.value, false));
                    }
                    if (bl2) {
                        return this.addX(this.viewer.getSmiles(-1, -1, (BitSet)scriptVariable.value, true, bl6, bl6, false));
                    }
                    if (bl3 || bl4) {
                        string = string2;
                    }
                    BitSet bitSet2 = bitSet;
                    object = this.eval.getSmilesMatches(string, null, (BitSet)scriptVariable.value, bitSet2, !bl3, !bl6);
                }
            }
            if (object == null) {
                this.eval.error(22);
            }
            return this.addX(object);
        }
        boolean bl7 = string2.indexOf("v") >= 0;
        boolean bl8 = string2.indexOf("i") >= 0;
        boolean bl9 = string2.indexOf("m") >= 0;
        boolean bl10 = scriptVariable.tok == 7;
        boolean bl11 = bl = scriptVariableArray.length == 2;
        if (bl10 || bl) {
            Pattern pattern = null;
            try {
                pattern = Pattern.compile(string, bl8 ? 2 : 0);
            }
            catch (Exception exception) {
                this.eval.evalError(exception.getMessage(), null);
            }
            String[] stringArray = ScriptVariable.listValue(scriptVariable);
            if (Logger.debugging) {
                Logger.debug("finding " + string);
            }
            BitSet bitSet = new BitSet();
            int n = 0;
            int n2 = 0;
            Matcher matcher = null;
            ArrayList<String> arrayList = bl9 ? new ArrayList<String>() : null;
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i];
                matcher = pattern.matcher(string4);
                boolean bl12 = matcher.find();
                if ((!bl9 || !bl12) && (bl9 || bl12 != !bl7)) continue;
                ++n2;
                n = i;
                bitSet.set(i);
                if (!bl9) continue;
                arrayList.add(bl7 ? string4.substring(0, matcher.start()) + string4.substring(matcher.end()) : matcher.group());
            }
            if (!bl10) {
                return bl9 ? this.addX(arrayList.size() == 1 ? (String)arrayList.get(0) : "") : (bl7 ? this.addX(n2 == 1) : (bl9 ? this.addX(n2 == 0 ? "" : matcher.group()) : this.addX(n2 == 0 ? 0 : matcher.start() + 1)));
            }
            if (n2 == 1) {
                return this.addX(bl9 ? (String)arrayList.get(0) : stringArray[n]);
            }
            String[] stringArray2 = new String[n2];
            if (n2 > 0) {
                int n3 = stringArray.length;
                while (--n3 >= 0) {
                    if (!bitSet.get(n3)) continue;
                    String string5 = bl9 ? (String)arrayList.get(--n2) : stringArray[n3];
                    stringArray2[n2] = string5;
                }
            }
            return this.addX(stringArray2);
        }
        return this.addX(ScriptVariable.sValue(scriptVariable).indexOf(string) + 1);
    }

    private boolean evaluateGetProperty(ScriptVariable[] scriptVariableArray) {
        String string;
        Object object;
        String string2;
        int n = 0;
        String string3 = string2 = scriptVariableArray.length > n ? ScriptVariable.sValue(scriptVariableArray[n++]).toLowerCase() : "";
        if (string2.startsWith("$")) {
            // empty if block
        }
        if (string2.equalsIgnoreCase("fileContents") && scriptVariableArray.length > 2) {
            object = ScriptVariable.sValue(scriptVariableArray[1]);
            for (int i = 2; i < scriptVariableArray.length; ++i) {
                object = (String)object + "|" + ScriptVariable.sValue(scriptVariableArray[i]);
            }
            string = object;
            n = scriptVariableArray.length;
        } else {
            string = scriptVariableArray.length > n && scriptVariableArray[n].tok == 10 ? ScriptVariable.bsSelect(scriptVariableArray[n++]) : (scriptVariableArray.length > n && scriptVariableArray[n].tok == 4 && PropertyManager.acceptsStringParameter(string2) ? scriptVariableArray[n++].value : "");
        }
        object = this.viewer.getProperty(null, string2, (Object)string);
        if (n < scriptVariableArray.length) {
            object = PropertyManager.extractProperty(object, scriptVariableArray, n);
        }
        return this.addX(ScriptVariable.isVariableType(object) ? object : Escape.toReadable(string2, object));
    }

    private boolean evaluatePlane(ScriptVariable[] scriptVariableArray, int n) throws ScriptEvaluator.ScriptException {
        if (n == 135267841 && scriptVariableArray.length != 3 || scriptVariableArray.length == 0 || scriptVariableArray.length > 4) {
            return false;
        }
        switch (scriptVariableArray.length) {
            case 1: {
                Object object = Escape.unescapePoint(ScriptVariable.sValue(scriptVariableArray[0]));
                if (object instanceof Point4f) {
                    return this.addX(object);
                }
                return this.addX("" + object);
            }
            case 2: 
            case 3: 
            case 4: {
                switch (n) {
                    case 135267841: {
                        return this.addX(this.eval.getHklPlane(new Point3f(ScriptVariable.fValue(scriptVariableArray[0]), ScriptVariable.fValue(scriptVariableArray[1]), ScriptVariable.fValue(scriptVariableArray[2]))));
                    }
                }
                switch (scriptVariableArray[0].tok) {
                    case 8: 
                    case 10: {
                        Point3f point3f = this.ptValue(scriptVariableArray[0], false);
                        Point3f point3f2 = this.ptValue(scriptVariableArray[1], false);
                        if (point3f2 == null) {
                            return false;
                        }
                        Point3f point3f3 = scriptVariableArray.length > 2 && (scriptVariableArray[2].tok == 10 || scriptVariableArray[2].tok == 8) ? this.ptValue(scriptVariableArray[2], false) : null;
                        Vector3f vector3f = new Vector3f(point3f2);
                        if (point3f3 == null) {
                            if (scriptVariableArray.length == 2 || !ScriptVariable.bValue(scriptVariableArray[2])) {
                                point3f3 = new Point3f(point3f);
                                point3f3.add(point3f2);
                                point3f3.scale(0.5f);
                                vector3f.sub(point3f);
                                vector3f.normalize();
                            }
                            return this.addX(Measure.getPlaneThroughPoint(point3f3, vector3f));
                        }
                        Vector3f vector3f2 = new Vector3f();
                        Vector3f vector3f3 = new Vector3f();
                        float f = Measure.getDirectedNormalThroughPoints(point3f, point3f2, point3f3, scriptVariableArray.length == 4 ? this.ptValue(scriptVariableArray[3], true) : null, vector3f, vector3f2, vector3f3);
                        return this.addX(new Point4f(vector3f.x, vector3f.y, vector3f.z, f));
                    }
                }
            }
        }
        if (scriptVariableArray.length != 4) {
            return false;
        }
        float f = ScriptVariable.fValue(scriptVariableArray[0]);
        float f2 = ScriptVariable.fValue(scriptVariableArray[1]);
        float f3 = ScriptVariable.fValue(scriptVariableArray[2]);
        float f4 = ScriptVariable.fValue(scriptVariableArray[3]);
        return this.addX(new Point4f(f, f2, f3, f4));
    }

    private boolean evaluatePoint(ScriptVariable[] scriptVariableArray) {
        if (scriptVariableArray.length != 1 && scriptVariableArray.length != 3 && scriptVariableArray.length != 4) {
            return false;
        }
        switch (scriptVariableArray.length) {
            case 1: {
                if (scriptVariableArray[0].tok == 3 || scriptVariableArray[0].tok == 2) {
                    return this.addX((Object)ScriptVariable.iValue(scriptVariableArray[0]));
                }
                Object object = Escape.unescapePoint(ScriptVariable.sValue(scriptVariableArray[0]));
                if (object instanceof Point3f) {
                    return this.addX((Point3f)object);
                }
                return this.addX("" + object);
            }
            case 3: {
                return this.addX(new Point3f(ScriptVariable.fValue(scriptVariableArray[0]), ScriptVariable.fValue(scriptVariableArray[1]), ScriptVariable.fValue(scriptVariableArray[2])));
            }
            case 4: {
                return this.addX(new Point4f(ScriptVariable.fValue(scriptVariableArray[0]), ScriptVariable.fValue(scriptVariableArray[1]), ScriptVariable.fValue(scriptVariableArray[2]), ScriptVariable.fValue(scriptVariableArray[3])));
            }
        }
        return false;
    }

    private boolean evaluatePrompt(ScriptVariable[] scriptVariableArray) {
        boolean bl;
        if (scriptVariableArray.length != 1 && scriptVariableArray.length != 2 && scriptVariableArray.length != 3) {
            return false;
        }
        String string = ScriptVariable.sValue(scriptVariableArray[0]);
        String[] stringArray = scriptVariableArray.length > 1 && scriptVariableArray[1].tok == 7 ? ScriptVariable.listValue(scriptVariableArray[1]) : null;
        boolean bl2 = bl = stringArray != null || scriptVariableArray.length == 1 || scriptVariableArray.length == 3 && ScriptVariable.bValue(scriptVariableArray[2]);
        String string2 = stringArray != null ? null : (scriptVariableArray.length >= 2 ? ScriptVariable.sValue(scriptVariableArray[1]) : "OK");
        String string3 = this.viewer.prompt(string, string2, stringArray, bl);
        return bl && stringArray != null ? this.addX(Integer.parseInt(string3) + 1) : this.addX(string3);
    }

    private boolean evaluateReplace(ScriptVariable[] scriptVariableArray) throws ScriptEvaluator.ScriptException {
        String string;
        if (scriptVariableArray.length != 2) {
            return false;
        }
        ScriptVariable scriptVariable = this.getX();
        String string2 = ScriptVariable.sValue(scriptVariableArray[0]);
        String string3 = ScriptVariable.sValue(scriptVariableArray[1]);
        String string4 = string = scriptVariable.tok == 7 ? null : ScriptVariable.sValue(scriptVariable);
        if (string != null) {
            return this.addX(TextFormat.simpleReplace(string, string2, string3));
        }
        String[] stringArray = ScriptVariable.listValue(scriptVariable);
        int n = stringArray.length;
        while (--n >= 0) {
            stringArray[n] = TextFormat.simpleReplace(stringArray[n], string2, string3);
        }
        return this.addX(stringArray);
    }

    private boolean evaluateString(int n, ScriptVariable[] scriptVariableArray) throws ScriptEvaluator.ScriptException {
        String string;
        if (scriptVariableArray.length > 1) {
            return false;
        }
        ScriptVariable scriptVariable = this.getX();
        String string2 = string = n == 1276117508 && scriptVariable.tok == 10 || n == 1276117510 && scriptVariable.tok == 7 ? null : ScriptVariable.sValue(scriptVariable);
        String string3 = scriptVariableArray.length == 1 ? ScriptVariable.sValue(scriptVariableArray[0]) : (n == 1276117510 ? "" : "\n");
        switch (n) {
            case 1276117508: {
                if (scriptVariable.tok == 10) {
                    BitSet bitSet = ScriptVariable.bsSelect(scriptVariable);
                    string3 = "\n";
                    int n2 = this.viewer.getModelCount();
                    string = "";
                    for (int i = 0; i < n2; ++i) {
                        string = string + (i == 0 ? "" : "\n");
                        BitSet bitSet2 = this.viewer.getModelUndeletedAtomsBitSet(i);
                        bitSet2.and(bitSet);
                        string = string + Escape.escape(bitSet2);
                    }
                }
                return this.addX(TextFormat.split(string, string3));
            }
            case 1276117506: {
                if (string.length() > 0 && string.charAt(string.length() - 1) == '\n') {
                    string = string.substring(0, string.length() - 1);
                }
                return this.addX(TextFormat.simpleReplace(string, "\n", string3));
            }
            case 1276117510: {
                if (string != null) {
                    return this.addX(TextFormat.trim(string, string3));
                }
                String[] stringArray = ScriptVariable.listValue(scriptVariable);
                int n3 = stringArray.length;
                while (--n3 >= 0) {
                    stringArray[n3] = TextFormat.trim(stringArray[n3], string3);
                }
                return this.addX(stringArray);
            }
        }
        return this.addX("");
    }

    private boolean evaluateList(int n, ScriptVariable[] scriptVariableArray) throws ScriptEvaluator.ScriptException {
        int n2;
        boolean bl;
        if (scriptVariableArray.length != 1 && (n != 1276118017 || scriptVariableArray.length != 0 && scriptVariableArray.length != 2)) {
            return false;
        }
        ScriptVariable scriptVariable = this.getX();
        String[] stringArray = null;
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        if (scriptVariableArray.length == 2) {
            int n3 = scriptVariableArray[0].tok == 4 ? 0 : 1;
            String string = ScriptVariable.sValue(scriptVariableArray[n3]);
            stringArray = scriptVariable.tok == 7 ? ScriptVariable.listValue(scriptVariable) : TextFormat.split(ScriptVariable.sValue(scriptVariable), '\n');
            ScriptVariable scriptVariable2 = scriptVariableArray[1 - n3];
            stringArray2 = scriptVariable2.tok == 7 ? ScriptVariable.listValue(scriptVariable2) : TextFormat.split(ScriptVariable.sValue(scriptVariable2), '\n');
            int n4 = Math.max(stringArray.length, stringArray2.length);
            stringArray3 = new String[n4];
            for (int i = 0; i < n4; ++i) {
                stringArray3[i] = (i >= stringArray.length ? "" : stringArray[i]) + string + (i >= stringArray2.length ? "" : stringArray2[i]);
            }
            return this.addX(stringArray3);
        }
        ScriptVariable scriptVariable3 = scriptVariableArray.length == 0 ? ScriptVariable.vAll : scriptVariableArray[0];
        boolean bl2 = bl = scriptVariable3.tok == 0x100003;
        if (scriptVariable.tok != 7 && scriptVariable.tok != 4) {
            this.wasX = false;
            this.addOp(Token.tokenLeftParen);
            this.addX(scriptVariable);
            switch (n) {
                case 1276118017: {
                    this.addOp(Token.tokenPlus);
                    break;
                }
                case 1276117509: {
                    this.addOp(Token.tokenMinus);
                    break;
                }
                case 1276117507: {
                    this.addOp(Token.tokenTimes);
                    break;
                }
                case 1276117504: {
                    this.addOp(Token.tokenDivide);
                }
            }
            this.addX(scriptVariable3);
            return this.addOp(Token.tokenRightParen);
        }
        boolean bl3 = scriptVariable3.tok != 7 && ScriptVariable.sValue(scriptVariable3).indexOf("\n") < 0;
        float[] fArray = null;
        float[] fArray2 = null;
        List list = scriptVariable.getList();
        List list2 = scriptVariable3.getList();
        if (scriptVariable.tok == 7) {
            n2 = list.size();
        } else {
            stringArray = TextFormat.split((String)scriptVariable.value, "\n");
            n2 = stringArray.length;
            fArray = new float[n2];
            Parser.parseFloatArray(stringArray, fArray);
        }
        if (bl) {
            float f = 0.0f;
            if (scriptVariable.tok == 7) {
                int n5 = n2;
                while (--n5 >= 0) {
                    f += ScriptVariable.fValue((ScriptVariable)list.get(n5));
                }
            } else {
                int n6 = n2;
                while (--n6 >= 0) {
                    f += fArray[n6];
                }
            }
            return this.addX(f);
        }
        ScriptVariable scriptVariable4 = null;
        if (bl3) {
            scriptVariable4 = scriptVariable3;
        } else if (scriptVariable3.tok == 7) {
            n2 = Math.min(fArray.length, list2.size());
        } else {
            stringArray2 = TextFormat.split((String)scriptVariable3.value, "\n");
            fArray2 = new float[stringArray2.length];
            Parser.parseFloatArray(stringArray2, fArray2);
            n2 = Math.min(fArray.length, fArray2.length);
        }
        Token token = null;
        switch (n) {
            case 1276118017: {
                token = Token.tokenPlus;
                break;
            }
            case 1276117509: {
                token = Token.tokenMinus;
                break;
            }
            case 1276117507: {
                token = Token.tokenTimes;
                break;
            }
            case 1276117504: {
                token = Token.tokenDivide;
            }
        }
        ScriptVariable[] scriptVariableArray2 = new ScriptVariable[n2];
        for (int i = 0; i < n2; ++i) {
            if (scriptVariable.tok == 7) {
                this.addX(list.get(i));
            } else if (Float.isNaN(fArray[i])) {
                this.addX(ScriptVariable.unescapePointOrBitsetAsVariable(stringArray[i]));
            } else {
                this.addX(fArray[i]);
            }
            if (bl3) {
                this.addX(scriptVariable4);
            } else if (scriptVariable3.tok == 7) {
                this.addX(list2.get(i));
            } else if (Float.isNaN(fArray2[i])) {
                this.addX(ScriptVariable.unescapePointOrBitsetAsVariable(stringArray2[i]));
            } else {
                this.addX(fArray2[i]);
            }
            if (!this.addOp(token) || !this.operate()) {
                return false;
            }
            scriptVariableArray2[i] = this.xStack[this.xPt--];
        }
        return this.addX(scriptVariableArray2);
    }

    private boolean evaluateRowCol(ScriptVariable[] scriptVariableArray, int n) throws ScriptEvaluator.ScriptException {
        if (scriptVariableArray.length != 1) {
            return false;
        }
        int n2 = ScriptVariable.iValue(scriptVariableArray[0]) - 1;
        ScriptVariable scriptVariable = this.getX();
        switch (scriptVariable.tok) {
            case 11: {
                if (n2 < 0 || n2 > 2) {
                    return false;
                }
                Matrix3f matrix3f = (Matrix3f)scriptVariable.value;
                switch (n) {
                    case 1276117513: {
                        float[] fArray = new float[3];
                        matrix3f.getRow(n2, fArray);
                        return this.addX(fArray);
                    }
                }
                float[] fArray = new float[3];
                matrix3f.getColumn(n2, fArray);
                return this.addX(fArray);
            }
            case 12: {
                if (n2 < 0 || n2 > 2) {
                    return false;
                }
                Matrix4f matrix4f = (Matrix4f)scriptVariable.value;
                switch (n) {
                    case 1276117513: {
                        float[] fArray = new float[4];
                        matrix4f.getRow(n2, fArray);
                        return this.addX(fArray);
                    }
                }
                float[] fArray = new float[4];
                matrix4f.getColumn(n2, fArray);
                return this.addX(fArray);
            }
        }
        return false;
    }

    private boolean evaluateArray(ScriptVariable[] scriptVariableArray, boolean bl) {
        int n;
        int n2 = scriptVariableArray.length;
        if (bl && (n2 == 4 || n2 == 3)) {
            boolean bl2 = true;
            for (n = 0; n < n2 && bl2; ++n) {
                bl2 = scriptVariableArray[n].tok == 7 && scriptVariableArray[n].getList().size() == n2;
            }
            if (bl2) {
                float[] fArray = new float[n2 * n2];
                int n3 = 0;
                block1: for (int i = 0; i < n2 && bl2; ++i) {
                    List list = scriptVariableArray[i].getList();
                    for (int j = 0; j < n2; ++j) {
                        float f = ScriptVariable.fValue((ScriptVariable)list.get(j));
                        if (Float.isNaN(f)) {
                            bl2 = false;
                            continue block1;
                        }
                        fArray[n3++] = f;
                    }
                }
                if (bl2) {
                    if (n2 == 3) {
                        return this.addX(new Matrix3f(fArray));
                    }
                    return this.addX(new Matrix4f(fArray));
                }
            }
        }
        ScriptVariable[] scriptVariableArray2 = new ScriptVariable[scriptVariableArray.length];
        n = scriptVariableArray2.length;
        while (--n >= 0) {
            scriptVariableArray2[n] = new ScriptVariable(scriptVariableArray[n]);
        }
        return this.addX(scriptVariableArray2);
    }

    private boolean evaluateMath(ScriptVariable[] scriptVariableArray, int n) {
        if (n == 0x8100011) {
            if (scriptVariableArray.length == 1 && scriptVariableArray[0].tok == 4) {
                return this.addX(new Date() + "\t" + ScriptVariable.sValue(scriptVariableArray[0]));
            }
            return this.addX(((int)System.currentTimeMillis() & Integer.MAX_VALUE) - (scriptVariableArray.length == 0 ? 0 : ScriptVariable.iValue(scriptVariableArray[0])));
        }
        if (scriptVariableArray.length != 1) {
            return false;
        }
        if (n == 135266826) {
            if (scriptVariableArray[0].tok == 2) {
                return this.addX(Math.abs(ScriptVariable.iValue(scriptVariableArray[0])));
            }
            return this.addX(Math.abs(ScriptVariable.fValue(scriptVariableArray[0])));
        }
        double d = ScriptVariable.fValue(scriptVariableArray[0]);
        switch (n) {
            case 135266819: {
                return this.addX((float)(Math.acos(d) * 180.0 / Math.PI));
            }
            case 135266821: {
                return this.addX((float)Math.cos(d * Math.PI / 180.0));
            }
            case 135266820: {
                return this.addX((float)Math.sin(d * Math.PI / 180.0));
            }
            case 135266822: {
                return this.addX((float)Math.sqrt(d));
            }
        }
        return false;
    }

    private boolean evaluateQuaternion(ScriptVariable[] scriptVariableArray, int n) throws ScriptEvaluator.ScriptException {
        Object object;
        Point3f point3f = null;
        int n2 = scriptVariableArray.length;
        int n3 = Integer.MAX_VALUE;
        boolean bl = false;
        if (n == 135270411) {
            if (n2 > 1 && scriptVariableArray[n2 - 1].tok == 4 && ((String)scriptVariableArray[n2 - 1].value).equalsIgnoreCase("relative")) {
                --n2;
                bl = true;
            }
            if (n2 > 1 && scriptVariableArray[n2 - 1].tok == 2 && scriptVariableArray[0].tok == 10) {
                n3 = ScriptVariable.iValue(scriptVariableArray[n2 - 1]);
                if (n3 <= 0) {
                    n3 = 0x7FFFFFFE;
                }
                --n2;
            }
        }
        switch (n2) {
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                if (n == 135270411 && (scriptVariableArray[0].tok == 7 && scriptVariableArray[1].tok == 7 || scriptVariableArray[0].tok == 10 && (scriptVariableArray[1].tok == 2 || scriptVariableArray[1].tok == 10)) || (point3f = this.ptValue(scriptVariableArray[0], false)) != null && (n == 135270411 || scriptVariableArray[1].tok != 8)) break;
                return false;
            }
            case 3: {
                if (n != 135270411) {
                    return false;
                }
                if (scriptVariableArray[0].tok == 9) {
                    if (scriptVariableArray[2].tok == 8 || scriptVariableArray[2].tok == 10) break;
                    return false;
                }
                for (int i = 0; i < 3; ++i) {
                    if (scriptVariableArray[i].tok == 8 || scriptVariableArray[i].tok == 10) continue;
                    return false;
                }
                break;
            }
            default: {
                return false;
            }
        }
        Quaternion quaternion = null;
        Quaternion[] quaternionArray = null;
        Point4f point4f = null;
        switch (n2) {
            default: {
                Object object2;
                if (n == 135270411 && scriptVariableArray[0].tok == 7) {
                    object = ScriptMathProcessor.getQuaternionArray(scriptVariableArray[0].getList());
                    object2 = Quaternion.sphereMean(object, null, 1.0E-4f);
                    quaternion = object2 instanceof Quaternion ? (Quaternion)object2 : null;
                    break;
                }
                if (n == 135270411 && scriptVariableArray[0].tok == 10) {
                    quaternionArray = this.viewer.getAtomGroupQuaternions((BitSet)scriptVariableArray[0].value, n3);
                } else if (scriptVariableArray[0].tok == 11) {
                    quaternion = new Quaternion((Matrix3f)scriptVariableArray[0].value);
                } else if (scriptVariableArray[0].tok == 9) {
                    point4f = (Point4f)scriptVariableArray[0].value;
                } else {
                    object = Escape.unescapePoint(ScriptVariable.sValue(scriptVariableArray[0]));
                    if (!(object instanceof Point4f)) {
                        return false;
                    }
                    point4f = (Point4f)object;
                }
                if (n != 135266316) break;
                quaternion = new Quaternion(new Point3f(point4f.x, point4f.y, point4f.z), point4f.w);
                break;
            }
            case 2: {
                Object object2;
                if (n == 135270411) {
                    if (scriptVariableArray[0].tok == 7 && scriptVariableArray[1].tok == 7) {
                        object = ScriptMathProcessor.getQuaternionArray(scriptVariableArray[0].getList());
                        object2 = ScriptMathProcessor.getQuaternionArray(scriptVariableArray[1].getList());
                        quaternionArray = Quaternion.div((Quaternion[])object2, object, n3, bl);
                        break;
                    }
                    if (scriptVariableArray[0].tok == 10 && scriptVariableArray[1].tok == 10) {
                        object = this.viewer.getAtomGroupQuaternions((BitSet)scriptVariableArray[0].value, Integer.MAX_VALUE);
                        object2 = this.viewer.getAtomGroupQuaternions((BitSet)scriptVariableArray[1].value, Integer.MAX_VALUE);
                        quaternionArray = Quaternion.div((Quaternion[])object2, object, n3, bl);
                        break;
                    }
                }
                object = this.ptValue(scriptVariableArray[1], false);
                point4f = this.planeValue(scriptVariableArray[0]);
                if (object != null) {
                    quaternion = Quaternion.getQuaternionFrame(new Point3f(0.0f, 0.0f, 0.0f), point3f, (Tuple3f)object);
                    break;
                }
                quaternion = new Quaternion(point3f, ScriptVariable.fValue(scriptVariableArray[1]));
                break;
            }
            case 3: {
                if (scriptVariableArray[0].tok == 9) {
                    Point3f point3f2 = scriptVariableArray[2].tok == 8 ? (Point3f)scriptVariableArray[2].value : this.viewer.getAtomSetCenter((BitSet)scriptVariableArray[2].value);
                    return this.addX(new Quaternion((Point4f)scriptVariableArray[0].value).draw("q", ScriptVariable.sValue(scriptVariableArray[1]), point3f2, 1.0f));
                }
                Object object2 = new Point3f[3];
                for (int i = 0; i < 3; ++i) {
                    object2[i] = scriptVariableArray[i].tok == 8 ? (Point3f)scriptVariableArray[i].value : this.viewer.getAtomSetCenter((BitSet)scriptVariableArray[i].value);
                }
                quaternion = Quaternion.getQuaternionFrame(object2[0], object2[1], object2[2]);
                break;
            }
            case 4: {
                if (n == 135270411) {
                    point4f = new Point4f(ScriptVariable.fValue(scriptVariableArray[1]), ScriptVariable.fValue(scriptVariableArray[2]), ScriptVariable.fValue(scriptVariableArray[3]), ScriptVariable.fValue(scriptVariableArray[0]));
                    break;
                }
                quaternion = new Quaternion(new Point3f(ScriptVariable.fValue(scriptVariableArray[0]), ScriptVariable.fValue(scriptVariableArray[1]), ScriptVariable.fValue(scriptVariableArray[2])), ScriptVariable.fValue(scriptVariableArray[3]));
            }
        }
        if (quaternionArray != null) {
            if (n3 == Integer.MAX_VALUE) {
                quaternion = quaternionArray.length > 0 ? quaternionArray[0] : null;
            } else {
                object = new ArrayList[quaternionArray.length];
                for (int i = 0; i < quaternionArray.length; ++i) {
                    object[i].add(quaternionArray[i].toPoint4f());
                }
                return this.addX(object);
            }
        }
        return this.addX((quaternion == null ? new Quaternion(point4f) : quaternion).toPoint4f());
    }

    private boolean evaluateRandom(ScriptVariable[] scriptVariableArray) {
        if (scriptVariableArray.length > 2) {
            return false;
        }
        float f = scriptVariableArray.length < 2 ? 0.0f : ScriptVariable.fValue(scriptVariableArray[0]);
        float f2 = scriptVariableArray.length == 0 ? 1.0f : ScriptVariable.fValue(scriptVariableArray[scriptVariableArray.length - 1]);
        return this.addX((float)(Math.random() * (double)(f2 -= f)) + f);
    }

    private boolean evaluateCross(ScriptVariable[] scriptVariableArray) {
        if (scriptVariableArray.length != 2) {
            return false;
        }
        ScriptVariable scriptVariable = scriptVariableArray[0];
        ScriptVariable scriptVariable2 = scriptVariableArray[1];
        if (scriptVariable.tok != 8 || scriptVariable2.tok != 8) {
            return false;
        }
        Vector3f vector3f = new Vector3f((Point3f)scriptVariable.value);
        Vector3f vector3f2 = new Vector3f((Point3f)scriptVariable2.value);
        vector3f.cross(vector3f, vector3f2);
        return this.addX(new Point3f(vector3f));
    }

    private boolean evaluateLoad(ScriptVariable[] scriptVariableArray, int n) {
        if (scriptVariableArray.length > 2 || scriptVariableArray.length < 1) {
            return false;
        }
        String string = ScriptVariable.sValue(scriptVariableArray[0]);
        int n2 = scriptVariableArray.length == 2 ? ScriptVariable.iValue(scriptVariableArray[1]) : Integer.MAX_VALUE;
        return this.addX(n == 135271426 ? this.viewer.getFileAsString(string, n2, false) : this.viewer.getFilePath(string, false));
    }

    private boolean evaluateWrite(ScriptVariable[] scriptVariableArray) throws ScriptEvaluator.ScriptException {
        if (scriptVariableArray.length == 0) {
            return false;
        }
        return this.addX(this.eval.write(scriptVariableArray));
    }

    private boolean evaluateScript(ScriptVariable[] scriptVariableArray, int n) throws ScriptEvaluator.ScriptException {
        if (n == 135287308 && scriptVariableArray.length != 1 || scriptVariableArray.length == 0 || scriptVariableArray.length > 2) {
            return false;
        }
        String string = ScriptVariable.sValue(scriptVariableArray[0]);
        StringBuffer stringBuffer = new StringBuffer();
        switch (n) {
            case 135271429: {
                String string2;
                String string3 = string2 = scriptVariableArray.length == 2 ? ScriptVariable.sValue(scriptVariableArray[1]) : ".";
                if (!string2.equals(".")) {
                    stringBuffer.append(this.viewer.jsEval(string2 + "\u0001" + string));
                }
                if (!string2.equals(".") && !string2.equals("*")) break;
                this.eval.runScript(string, stringBuffer);
                break;
            }
            case 135287308: {
                stringBuffer.append(this.viewer.jsEval(string));
            }
        }
        string = stringBuffer.toString();
        float f = Parser.parseFloatStrict(string);
        return Float.isNaN(f) ? this.addX(string) : (string.indexOf(".") >= 0 ? this.addX(f) : this.addX(Parser.parseInt(string)));
    }

    private boolean evaluateData(ScriptVariable[] scriptVariableArray) {
        String string;
        if (scriptVariableArray.length != 1 && scriptVariableArray.length != 2 && scriptVariableArray.length != 4) {
            return false;
        }
        String string2 = ScriptVariable.sValue(scriptVariableArray[0]);
        String string3 = string = scriptVariableArray.length == 2 ? ScriptVariable.sValue(scriptVariableArray[1]) : "";
        if (scriptVariableArray.length == 4) {
            int n = ScriptVariable.iValue(scriptVariableArray[1]);
            int n2 = ScriptVariable.iValue(scriptVariableArray[2]);
            int n3 = ScriptVariable.iValue(scriptVariableArray[3]);
            float[] fArray = Parser.extractData(string2, n, n2, n3);
            return this.addX(Escape.escape(fArray, false));
        }
        if (string2.indexOf("data2d_") == 0) {
            float[][] fArray = this.viewer.getDataFloat2D(string2);
            if (fArray == null) {
                return this.addX("");
            }
            if (scriptVariableArray.length == 2 && scriptVariableArray[1].tok == 2) {
                int n = scriptVariableArray[1].intValue;
                if (n < 0) {
                    n += fArray.length;
                }
                if (n >= 0 && n < fArray.length) {
                    return this.addX(Escape.escape(fArray[n], false));
                }
                return this.addX("");
            }
            return this.addX(Escape.escape(fArray, false));
        }
        if (string2.indexOf("property_") == 0) {
            float[] fArray;
            float[] fArray2 = this.viewer.getDataFloat(string2);
            if (fArray2 == null) {
                return this.addX("");
            }
            float[] fArray3 = fArray = string.indexOf("property_") == 0 ? this.viewer.getDataFloat(string) : null;
            if (fArray != null) {
                fArray2 = (float[])fArray2.clone();
                int n = Math.min(fArray2.length, fArray.length);
                while (--n >= 0) {
                    int n4 = n;
                    fArray2[n4] = fArray2[n4] + fArray[n];
                }
            }
            return this.addX(Escape.escape(fArray2, false));
        }
        if (scriptVariableArray.length == 1) {
            Object[] objectArray = this.viewer.getData(string2);
            return this.addX(objectArray == null ? "" : "" + objectArray[1]);
        }
        return this.addX(this.viewer.getData(string2, string));
    }

    private boolean evaluateLabel(int n, ScriptVariable[] scriptVariableArray) throws ScriptEvaluator.ScriptException {
        ScriptVariable scriptVariable = scriptVariableArray.length < 2 ? this.getX() : null;
        String string = scriptVariableArray.length == 0 ? "%U" : ScriptVariable.sValue(scriptVariableArray[0]);
        boolean bl = Token.tokAttr(n, 480);
        if (scriptVariable == null) {
            return this.addX(ScriptVariable.sprintf(scriptVariableArray));
        }
        BitSet bitSet = ScriptVariable.getBitSet(scriptVariable, true);
        if (bitSet == null) {
            return this.addX(ScriptVariable.sprintf(TextFormat.formatCheck(string), scriptVariable));
        }
        return this.addX(this.eval.getBitsetIdent(bitSet, string, scriptVariable.value, true, scriptVariable.index, bl));
    }

    private boolean evaluateWithin(ScriptVariable[] scriptVariableArray) throws ScriptEvaluator.ScriptException {
        BitSet bitSet;
        if (scriptVariableArray.length < 1 || scriptVariableArray.length > 5) {
            return false;
        }
        int n = scriptVariableArray.length;
        Object object = scriptVariableArray[0].value;
        String string = "" + object;
        int n2 = scriptVariableArray[0].tok;
        if (n2 == 4) {
            n2 = Token.getTokFromName(string.toLowerCase());
        }
        float f = 0.0f;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = n2 == 3 || n2 == 2;
        switch (n2) {
            case 0x100004: {
                if (n != 3 || !(scriptVariableArray[1].value instanceof BitSet) || !(scriptVariableArray[2].value instanceof BitSet)) {
                    return false;
                }
                return this.addX(this.viewer.getBranchBitSet(((BitSet)scriptVariableArray[2].value).nextSetBit(0), ((BitSet)scriptVariableArray[1].value).nextSetBit(0)));
            }
            case 135267335: 
            case 135267336: 
            case 1238369286: {
                BitSet bitSet2 = null;
                boolean bl4 = true;
                switch (n) {
                    case 2: {
                        break;
                    }
                    case 3: {
                        boolean bl5 = bl4 = scriptVariableArray[2].tok == 10;
                        if (!bl4) break;
                        bitSet2 = (BitSet)scriptVariableArray[2].value;
                        break;
                    }
                    default: {
                        bl4 = false;
                    }
                }
                if (!bl4) {
                    this.eval.error(22);
                }
                return this.addX(this.eval.getSmilesMatches(ScriptVariable.sValue(scriptVariableArray[1]), null, bitSet2, null, n2 == 135267335, this.asBitSet));
            }
        }
        if (object instanceof String) {
            if (n2 == 0) {
                n2 = 1048614;
                if (n > 2) {
                    return false;
                }
                n = 2;
            }
        } else if (bl3) {
            f = ScriptVariable.fValue(scriptVariableArray[0]);
            if (n < 2) {
                return false;
            }
            n2 = scriptVariableArray[1].tok;
            switch (n2) {
                case 0x10000C: 
                case 0x10000D: {
                    bl = ScriptVariable.bValue(scriptVariableArray[1]);
                    n = 0;
                    break;
                }
                case 4: {
                    bl2 = ScriptVariable.sValue(scriptVariableArray[1]).equalsIgnoreCase("group");
                    n2 = 1087373318;
                }
            }
        } else {
            return false;
        }
        Point3f point3f = null;
        Point4f point4f = null;
        block12 : switch (n) {
            case 1: {
                switch (n2) {
                    case 0x300020: 
                    case 137363472: 
                    case 1679429641: {
                        return this.addX(this.viewer.getAtomBits(n2, null));
                    }
                    case 1073741864: {
                        return this.addX(this.viewer.getAtomBits(n2, ""));
                    }
                    case 1048614: {
                        return this.addX(this.viewer.getAtomBits(1087373320, string));
                    }
                }
                return false;
            }
            case 2: {
                switch (n2) {
                    case 1048614: {
                        n2 = 1087373320;
                        break block12;
                    }
                    case 1073741864: 
                    case 1087373320: 
                    case 1087375361: 
                    case 1087375362: {
                        return this.addX(this.viewer.getAtomBits(n2, ScriptVariable.sValue(scriptVariableArray[scriptVariableArray.length - 1])));
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 0x100006: 
                    case 0x10000C: 
                    case 0x10000D: 
                    case 135266313: 
                    case 135267841: 
                    case 1087373318: {
                        break block12;
                    }
                    case 1087373320: {
                        string = ScriptVariable.sValue(scriptVariableArray[2]);
                        break block12;
                    }
                }
                return false;
            }
        }
        n = scriptVariableArray.length - 1;
        if (scriptVariableArray[n].value instanceof Point4f) {
            point4f = (Point4f)scriptVariableArray[n].value;
        } else if (scriptVariableArray[n].value instanceof Point3f) {
            point3f = (Point3f)scriptVariableArray[n].value;
            if (ScriptVariable.sValue(scriptVariableArray[1]).equalsIgnoreCase("hkl")) {
                point4f = this.eval.getHklPlane(point3f);
            }
        }
        if (n > 0 && point4f == null && point3f == null && !(scriptVariableArray[n].value instanceof BitSet)) {
            return false;
        }
        if (point4f != null) {
            return this.addX(this.viewer.getAtomsWithin(f, point4f));
        }
        if (point3f != null) {
            return this.addX(this.viewer.getAtomsWithin(f, point3f));
        }
        BitSet bitSet3 = bitSet = scriptVariableArray[n].tok == 10 ? ScriptVariable.bsSelect(scriptVariableArray[n]) : null;
        if (n2 == 1087373320) {
            return this.addX(this.viewer.getSequenceBits(string, bitSet));
        }
        if (bitSet == null) {
            bitSet = new BitSet();
        }
        if (!bl3) {
            return this.addX(this.viewer.getAtomBits(n2, bitSet));
        }
        if (bl2) {
            return this.addX(this.viewer.getGroupsWithin((int)f, bitSet));
        }
        return this.addX(this.viewer.getAtomsWithin(f, bitSet, bl));
    }

    private boolean evaluateColor(ScriptVariable[] scriptVariableArray) {
        Object object;
        boolean bl;
        ColorEncoder colorEncoder;
        String string = scriptVariableArray.length > 0 ? ScriptVariable.sValue(scriptVariableArray[0]) : "";
        boolean bl2 = string.startsWith("$");
        ColorEncoder colorEncoder2 = colorEncoder = bl2 ? null : this.viewer.getColorEncoder(string);
        if (!bl2 && colorEncoder == null) {
            return this.addX("");
        }
        float f = scriptVariableArray.length > 1 ? ScriptVariable.fValue(scriptVariableArray[1]) : Float.MAX_VALUE;
        Object object2 = scriptVariableArray.length > 2 ? ScriptVariable.fValue(scriptVariableArray[2]) : Float.MAX_VALUE;
        float f2 = scriptVariableArray.length > 3 ? ScriptVariable.fValue(scriptVariableArray[3]) : Float.MAX_VALUE;
        boolean bl3 = f2 != Float.MAX_VALUE || f != Float.MAX_VALUE && object2 == Float.MAX_VALUE;
        boolean bl4 = bl = object2 != Float.MAX_VALUE;
        if (!bl && string.length() == 0) {
            f2 = f;
            object = this.viewer.getCurrentColorRange();
            f = (float)object[0];
            object2 = object[1];
        }
        if (bl2) {
            object = string.substring(1);
            Object[] objectArray = new Object[]{object, null};
            if (!this.viewer.getShapeProperty(23, "colorEncoder", objectArray)) {
                return this.addX("");
            }
            colorEncoder = (ColorEncoder)objectArray[1];
        } else {
            colorEncoder.setRange(f, (float)object2, f > object2);
        }
        object = colorEncoder.getColorKey();
        if (bl3) {
            return this.addX(Graphics3D.colorPointFromInt2(colorEncoder.getArgb(object2 == Float.MAX_VALUE ? f : f2)));
        }
        return this.addX(ScriptVariable.getVariable(object));
    }

    private boolean evaluateConnected(ScriptVariable[] scriptVariableArray) {
        if (scriptVariableArray.length > 5) {
            return false;
        }
        float f = -2.1474836E9f;
        float f2 = 2.1474836E9f;
        float f3 = 0.0f;
        float f4 = Float.MAX_VALUE;
        int n = 65535;
        BitSet bitSet = null;
        BitSet bitSet2 = null;
        boolean bl = false;
        boolean bl2 = false;
        block5: for (int i = 0; i < scriptVariableArray.length; ++i) {
            ScriptVariable scriptVariable = scriptVariableArray[i];
            switch (scriptVariable.tok) {
                case 10: {
                    bl2 = scriptVariable.value instanceof Bond.BondSet;
                    if (bl2 && bitSet != null) {
                        return false;
                    }
                    if (bitSet == null) {
                        bitSet = ScriptVariable.bsSelect(scriptVariable);
                        continue block5;
                    }
                    if (bitSet2 == null) {
                        bitSet2 = ScriptVariable.bsSelect(scriptVariable);
                        continue block5;
                    }
                    return false;
                }
                case 4: {
                    String string = ScriptVariable.sValue(scriptVariable);
                    n = string.equalsIgnoreCase("hbond") ? 30720 : JmolConstants.getBondOrderFromString(string);
                    if (n != 131071) continue block5;
                    return false;
                }
                case 3: {
                    bl = true;
                }
                default: {
                    int n2 = ScriptVariable.iValue(scriptVariable);
                    float f5 = ScriptVariable.fValue(scriptVariable);
                    if (f2 != 2.1474836E9f) {
                        return false;
                    }
                    if (f == -2.1474836E9f) {
                        f = Math.max(n2, 0);
                        f3 = f5;
                        continue block5;
                    }
                    f2 = n2;
                    f4 = f5;
                }
            }
        }
        if (f == -2.1474836E9f) {
            f = 1.0f;
            f2 = 100.0f;
            f3 = 0.1f;
            f4 = 1.0E8f;
        } else if (f2 == 2.1474836E9f) {
            f2 = f;
            f4 = f3;
            f3 = 0.1f;
        }
        if (bitSet == null) {
            bitSet = this.viewer.getModelUndeletedAtomsBitSet(-1);
        }
        if (bl && bitSet2 == null) {
            bitSet2 = bitSet;
        }
        if (bitSet2 != null) {
            BitSet bitSet3 = new BitSet();
            this.viewer.makeConnections(f3, f4, n, 1087373321, bitSet, bitSet2, bitSet3, bl2, 0.0f);
            return this.addX(new ScriptVariable(10, new Bond.BondSet(bitSet3, this.viewer.getAtomIndices(this.viewer.getAtomBits(1678770178, bitSet3)))));
        }
        return this.addX(this.viewer.getAtomsConnected(f, f2, n, bitSet));
    }

    private boolean evaluateSubstructure(ScriptVariable[] scriptVariableArray, int n) throws ScriptEvaluator.ScriptException {
        if (scriptVariableArray.length == 0) {
            return false;
        }
        BitSet bitSet = new BitSet();
        String string = ScriptVariable.sValue(scriptVariableArray[0]);
        if (string.length() > 0) {
            try {
                BitSet bitSet2 = scriptVariableArray.length == 2 && scriptVariableArray[1].tok == 10 ? ScriptVariable.bsSelect(scriptVariableArray[1]) : null;
                bitSet = this.viewer.getSmilesMatcher().getSubstructureSet(string, this.viewer.getModelSet().atoms, this.viewer.getAtomCount(), bitSet2, n != 135267336 && n != 1238369286, false);
            }
            catch (Exception exception) {
                this.eval.evalError(exception.getMessage(), null);
            }
        }
        return this.addX(bitSet);
    }

    private boolean operate() throws ScriptEvaluator.ScriptException {
        Token token = this.oStack[this.oPt--];
        if (this.logMessages) {
            this.dumpStacks("operate: " + token);
        }
        if (this.isArrayItem && this.squareCount == 0 && this.equalCount == 1 && this.oPt < 0 && token.tok == 269484436) {
            return true;
        }
        ScriptVariable scriptVariable = this.getX();
        if (scriptVariable == Token.tokenArraySelector) {
            return false;
        }
        if (scriptVariable.tok == 7 || scriptVariable.tok == 11 || scriptVariable.tok == 12) {
            scriptVariable = ScriptVariable.selectItem(scriptVariable);
        }
        if (token.tok == 0x101000C1 || token.tok == 269484226) {
            if (!this.isSyntaxCheck && !scriptVariable.increment(this.incrementX)) {
                return false;
            }
            this.wasX = true;
            this.putX(scriptVariable);
            return true;
        }
        if (token.tok == 0x10100070) {
            if (this.isSyntaxCheck) {
                return this.addX(true);
            }
            switch (scriptVariable.tok) {
                case 9: {
                    return this.addX(new Quaternion((Point4f)scriptVariable.value).inv().toPoint4f());
                }
                case 11: {
                    Matrix3f matrix3f = new Matrix3f((Matrix3f)scriptVariable.value);
                    matrix3f.invert();
                    return this.addX(matrix3f);
                }
                case 12: {
                    Matrix4f matrix4f = new Matrix4f((Matrix4f)scriptVariable.value);
                    matrix4f.invert();
                    return this.addX(matrix4f);
                }
                case 10: {
                    return this.addX(BitSetUtil.copyInvert(ScriptVariable.bsSelect(scriptVariable), scriptVariable.value instanceof Bond.BondSet ? this.viewer.getBondCount() : this.viewer.getAtomCount()));
                }
            }
            return this.addX(!ScriptVariable.bValue(scriptVariable));
        }
        int n = token.intValue & 0xFFFFFE1F;
        if (token.tok == 0x101000D1) {
            switch (n) {
                case 1141899267: {
                    if (scriptVariable.value instanceof Bond.BondSet) break;
                    return this.addX(ScriptVariable.sizeOf(scriptVariable));
                }
                case 1141899270: {
                    return this.addX(ScriptVariable.sizeOf(scriptVariable));
                }
                case 1141899272: {
                    return this.addX(ScriptVariable.typeOf(scriptVariable));
                }
                case 0x44100010: {
                    if (scriptVariable.tok != 6) {
                        return this.addX("");
                    }
                    Object[] objectArray = ((Map)scriptVariable.value).keySet().toArray();
                    Arrays.sort(objectArray);
                    String[] stringArray = new String[objectArray.length];
                    for (int i = 0; i < objectArray.length; ++i) {
                        stringArray[i] = (String)objectArray[i];
                    }
                    return this.addX(stringArray);
                }
                case 0x44100004: {
                    String string;
                    switch (scriptVariable.tok) {
                        case 11: 
                        case 12: {
                            string = ScriptVariable.sValue(scriptVariable);
                            string = TextFormat.simpleReplace(string.substring(1, string.length() - 1), "],[", "]\n[");
                            break;
                        }
                        case 4: {
                            string = (String)scriptVariable.value;
                            break;
                        }
                        default: {
                            string = ScriptVariable.sValue(scriptVariable);
                        }
                    }
                    string = TextFormat.simpleReplace(string, "\n\r", "\n").replace('\r', '\n');
                    return this.addX(TextFormat.split(string, '\n'));
                }
                case 1632638983: {
                    switch (scriptVariable.tok) {
                        case 4: 
                        case 7: {
                            String string = ScriptVariable.sValue(scriptVariable);
                            Point3f point3f = new Point3f();
                            return this.addX(Graphics3D.colorPointFromString(string, point3f));
                        }
                        case 2: 
                        case 3: {
                            return this.addX(this.viewer.getColorPointForPropertyValue(ScriptVariable.fValue(scriptVariable)));
                        }
                        case 8: {
                            return this.addX(Escape.escapeColor(Graphics3D.colorPtToInt((Point3f)scriptVariable.value)));
                        }
                    }
                    break;
                }
                case 1679429641: {
                    return this.isSyntaxCheck ? this.addX("x") : this.getBoundBox(scriptVariable);
                }
            }
            if (this.isSyntaxCheck) {
                return this.addX(ScriptVariable.sValue(scriptVariable));
            }
            if (scriptVariable.tok == 4) {
                Object object = ScriptVariable.unescapePointOrBitsetAsVariable(ScriptVariable.sValue(scriptVariable));
                if (!(object instanceof ScriptVariable)) {
                    return false;
                }
                scriptVariable = (ScriptVariable)object;
            }
            if (token.tok == scriptVariable.tok) {
                scriptVariable = this.getX();
            }
            return this.getPointOrBitsetOperation(token, scriptVariable);
        }
        ScriptVariable scriptVariable2 = this.getX();
        if (this.isSyntaxCheck) {
            if (token == Token.tokenAndFALSE || token == Token.tokenOrTRUE) {
                this.isSyntaxCheck = false;
            }
            return this.addX(new ScriptVariable(scriptVariable2));
        }
        switch (token.tok) {
            case 0x10100060: 
            case 0x10100080: {
                switch (scriptVariable2.tok) {
                    case 10: {
                        BitSet bitSet = ScriptVariable.bsSelect(scriptVariable2);
                        switch (scriptVariable.tok) {
                            case 10: {
                                bitSet = BitSetUtil.copy(bitSet);
                                bitSet.and(ScriptVariable.bsSelect(scriptVariable));
                                return this.addX(bitSet);
                            }
                            case 2: {
                                int n2 = ScriptVariable.iValue(scriptVariable);
                                return this.addX(n2 < 0 ? false : bitSet.get(n2));
                            }
                        }
                    }
                }
                return this.addX(ScriptVariable.bValue(scriptVariable2) && ScriptVariable.bValue(scriptVariable));
            }
            case 0x10100050: {
                switch (scriptVariable2.tok) {
                    case 10: {
                        BitSet bitSet = BitSetUtil.copy(ScriptVariable.bsSelect(scriptVariable2));
                        switch (scriptVariable.tok) {
                            case 10: {
                                bitSet.or(ScriptVariable.bsSelect(scriptVariable));
                                return this.addX(bitSet);
                            }
                            case 2: {
                                int n3 = ScriptVariable.iValue(scriptVariable);
                                if (n3 < 0) break;
                                bitSet.set(n3);
                                return this.addX(bitSet);
                            }
                            case 7: {
                                ArrayList arrayList = (ArrayList)scriptVariable.value;
                                int n4 = arrayList.size();
                                while (--n4 >= 0) {
                                    bitSet.set(ScriptVariable.iValue((ScriptVariable)arrayList.get(n4)));
                                }
                                return this.addX(bitSet);
                            }
                        }
                    }
                    case 7: {
                        return this.addX(ScriptVariable.concatList(scriptVariable2, scriptVariable, false));
                    }
                }
                return this.addX(ScriptVariable.bValue(scriptVariable2) || ScriptVariable.bValue(scriptVariable));
            }
            case 0x10100051: {
                if (scriptVariable2.tok == 10 && scriptVariable.tok == 10) {
                    BitSet bitSet = BitSetUtil.copy(ScriptVariable.bsSelect(scriptVariable2));
                    bitSet.xor(ScriptVariable.bsSelect(scriptVariable));
                    return this.addX(bitSet);
                }
                boolean bl = ScriptVariable.bValue(scriptVariable2);
                boolean bl2 = ScriptVariable.bValue(scriptVariable);
                return this.addX(bl && !bl2 || bl2 && !bl);
            }
            case 269484114: {
                if (scriptVariable2.tok != 10 || scriptVariable.tok != 10) {
                    return false;
                }
                return this.addX(BitSetUtil.toggleInPlace(BitSetUtil.copy(ScriptVariable.bsSelect(scriptVariable2)), ScriptVariable.bsSelect(scriptVariable)));
            }
            case 269484434: {
                return this.addX(ScriptVariable.fValue(scriptVariable2) <= ScriptVariable.fValue(scriptVariable));
            }
            case 0x10100191: {
                return this.addX(ScriptVariable.fValue(scriptVariable2) >= ScriptVariable.fValue(scriptVariable));
            }
            case 0x10100190: {
                return this.addX(ScriptVariable.fValue(scriptVariable2) > ScriptVariable.fValue(scriptVariable));
            }
            case 269484435: {
                return this.addX(ScriptVariable.fValue(scriptVariable2) < ScriptVariable.fValue(scriptVariable));
            }
            case 269484436: {
                return this.addX(ScriptVariable.areEqual(scriptVariable2, scriptVariable));
            }
            case 269484437: {
                if (scriptVariable2.tok == 4 && scriptVariable.tok == 4) {
                    return this.addX(!ScriptVariable.sValue(scriptVariable2).equalsIgnoreCase(ScriptVariable.sValue(scriptVariable)));
                }
                if (scriptVariable2.tok == 8 && scriptVariable.tok == 8) {
                    return this.addX((double)((Point3f)scriptVariable2.value).distance((Point3f)scriptVariable.value) >= 1.0E-6);
                }
                if (scriptVariable2.tok == 9 && scriptVariable.tok == 9) {
                    return this.addX((double)((Point4f)scriptVariable2.value).distance((Point4f)scriptVariable.value) >= 1.0E-6);
                }
                float f = ScriptVariable.fValue(scriptVariable2);
                float f2 = ScriptVariable.fValue(scriptVariable);
                return this.addX(Float.isNaN(f) || Float.isNaN(f2) || (double)Math.abs(f - f2) >= 1.0E-6);
            }
            case 0x101000A1: {
                switch (scriptVariable2.tok) {
                    default: {
                        return this.addX(ScriptVariable.fValue(scriptVariable2) + ScriptVariable.fValue(scriptVariable));
                    }
                    case 7: {
                        return this.addX(ScriptVariable.concatList(scriptVariable2, scriptVariable, true));
                    }
                    case 2: {
                        switch (scriptVariable.tok) {
                            case 4: {
                                String string = ScriptVariable.sValue(scriptVariable).trim();
                                if (string.indexOf(".") >= 0 || string.indexOf("+") > 0 || string.lastIndexOf("-") > 0) break;
                                return this.addX(scriptVariable2.intValue + ScriptVariable.iValue(scriptVariable));
                            }
                            case 3: {
                                return this.addX((float)scriptVariable2.intValue + ScriptVariable.fValue(scriptVariable));
                            }
                            default: {
                                return this.addX(scriptVariable2.intValue + ScriptVariable.iValue(scriptVariable));
                            }
                        }
                    }
                    case 4: {
                        return this.addX(new ScriptVariable(4, ScriptVariable.sValue(scriptVariable2) + ScriptVariable.sValue(scriptVariable)));
                    }
                    case 9: {
                        Quaternion quaternion = new Quaternion((Point4f)scriptVariable2.value);
                        switch (scriptVariable.tok) {
                            default: {
                                return this.addX(quaternion.add(ScriptVariable.fValue(scriptVariable)).toPoint4f());
                            }
                            case 9: 
                        }
                        return this.addX(quaternion.mul(new Quaternion((Point4f)scriptVariable.value)).toPoint4f());
                    }
                    case 8: {
                        Point3f point3f = new Point3f((Point3f)scriptVariable2.value);
                        switch (scriptVariable.tok) {
                            case 8: {
                                point3f.add((Point3f)scriptVariable.value);
                                return this.addX(point3f);
                            }
                            case 9: {
                                Point4f point4f = (Point4f)scriptVariable.value;
                                point3f.add(new Point3f(point4f.x, point4f.y, point4f.z));
                                return this.addX(point3f);
                            }
                        }
                        float f = ScriptVariable.fValue(scriptVariable);
                        return this.addX(new Point3f(point3f.x + f, point3f.y + f, point3f.z + f));
                    }
                    case 11: 
                }
                switch (scriptVariable.tok) {
                    default: {
                        return this.addX(ScriptVariable.fValue(scriptVariable2) + ScriptVariable.fValue(scriptVariable));
                    }
                    case 11: {
                        Matrix3f matrix3f = new Matrix3f((Matrix3f)scriptVariable2.value);
                        matrix3f.add((Matrix3f)scriptVariable.value);
                        return this.addX(matrix3f);
                    }
                    case 8: 
                }
                return this.addX(ScriptMathProcessor.getMatrix4f((Matrix3f)scriptVariable2.value, (Point3f)scriptVariable.value));
            }
            case 0x101000A0: {
                String string;
                if (scriptVariable2.tok == 2 && (scriptVariable.tok == 4 ? (string = ScriptVariable.sValue(scriptVariable).trim()).indexOf(".") < 0 && string.indexOf("+") <= 0 && string.lastIndexOf("-") <= 0 : scriptVariable.tok != 3)) {
                    return this.addX(scriptVariable2.intValue - ScriptVariable.iValue(scriptVariable));
                }
                if (scriptVariable2.tok == 4 && scriptVariable.tok == 2 && (string = ScriptVariable.sValue(scriptVariable2).trim()).indexOf(".") < 0 && string.indexOf("+") <= 0 && string.lastIndexOf("-") <= 0) {
                    return this.addX(ScriptVariable.iValue(scriptVariable2) - scriptVariable.intValue);
                }
                switch (scriptVariable2.tok) {
                    default: {
                        return this.addX(ScriptVariable.fValue(scriptVariable2) - ScriptVariable.fValue(scriptVariable));
                    }
                    case 6: {
                        Hashtable hashtable = new Hashtable((Map)scriptVariable2.value);
                        hashtable.remove(ScriptVariable.sValue(scriptVariable));
                        return this.addX(ScriptVariable.getVariable(hashtable));
                    }
                    case 11: {
                        switch (scriptVariable.tok) {
                            default: {
                                return this.addX(ScriptVariable.fValue(scriptVariable2) - ScriptVariable.fValue(scriptVariable));
                            }
                            case 11: 
                        }
                        Matrix3f matrix3f = new Matrix3f((Matrix3f)scriptVariable2.value);
                        matrix3f.sub((Matrix3f)scriptVariable.value);
                        return this.addX(matrix3f);
                    }
                    case 12: {
                        switch (scriptVariable.tok) {
                            default: {
                                return this.addX(ScriptVariable.fValue(scriptVariable2) - ScriptVariable.fValue(scriptVariable));
                            }
                            case 12: 
                        }
                        Matrix4f matrix4f = new Matrix4f((Matrix4f)scriptVariable2.value);
                        matrix4f.sub((Matrix4f)scriptVariable.value);
                        return this.addX(matrix4f);
                    }
                    case 8: {
                        Point3f point3f = new Point3f((Point3f)scriptVariable2.value);
                        switch (scriptVariable.tok) {
                            default: {
                                float f = ScriptVariable.fValue(scriptVariable);
                                return this.addX(new Point3f(point3f.x - f, point3f.y - f, point3f.z - f));
                            }
                            case 8: {
                                point3f.sub((Point3f)scriptVariable.value);
                                return this.addX(point3f);
                            }
                            case 9: 
                        }
                        Point4f point4f = (Point4f)scriptVariable.value;
                        point3f.sub(new Point3f(point4f.x, point4f.y, point4f.z));
                        return this.addX(point3f);
                    }
                    case 9: 
                }
                Quaternion quaternion = new Quaternion((Point4f)scriptVariable2.value);
                switch (scriptVariable.tok) {
                    default: {
                        return this.addX(quaternion.add(-ScriptVariable.fValue(scriptVariable)).toPoint4f());
                    }
                    case 9: 
                }
                Quaternion quaternion2 = new Quaternion((Point4f)scriptVariable.value);
                return this.addX(quaternion2.mul(quaternion.inv()).toPoint4f());
            }
            case 0x101000C0: {
                switch (scriptVariable.tok) {
                    default: {
                        return this.addX(-ScriptVariable.fValue(scriptVariable));
                    }
                    case 2: {
                        return this.addX(-ScriptVariable.iValue(scriptVariable));
                    }
                    case 8: {
                        Point3f point3f = new Point3f((Point3f)scriptVariable.value);
                        point3f.scale(-1.0f);
                        return this.addX(point3f);
                    }
                    case 9: {
                        Point4f point4f = new Point4f((Point4f)scriptVariable.value);
                        point4f.scale(-1.0f);
                        return this.addX(point4f);
                    }
                    case 11: {
                        Matrix3f matrix3f = new Matrix3f((Matrix3f)scriptVariable.value);
                        matrix3f.transpose();
                        return this.addX(matrix3f);
                    }
                    case 12: {
                        Matrix4f matrix4f = new Matrix4f((Matrix4f)scriptVariable.value);
                        matrix4f.transpose();
                        return this.addX(matrix4f);
                    }
                    case 10: 
                }
                return this.addX(BitSetUtil.copyInvert(ScriptVariable.bsSelect(scriptVariable), scriptVariable.value instanceof Bond.BondSet ? this.viewer.getBondCount() : this.viewer.getAtomCount()));
            }
            case 0x101000B1: {
                Point3f point3f;
                if (scriptVariable2.tok == 2 && scriptVariable.tok != 3) {
                    return this.addX(scriptVariable2.intValue * ScriptVariable.iValue(scriptVariable));
                }
                Point3f point3f2 = scriptVariable2.tok == 11 ? this.ptValue(scriptVariable, false) : (point3f = scriptVariable.tok == 11 ? this.ptValue(scriptVariable2, false) : null);
                Point4f point4f = scriptVariable2.tok == 12 ? this.planeValue(scriptVariable) : (scriptVariable.tok == 12 ? this.planeValue(scriptVariable2) : null);
                switch (scriptVariable.tok) {
                    case 11: {
                        if (point3f != null) {
                            Matrix3f matrix3f = new Matrix3f((Matrix3f)scriptVariable.value);
                            matrix3f.transpose();
                            matrix3f.transform(point3f);
                            if (scriptVariable2.tok == 7) {
                                return this.addX(ScriptVariable.getVariable(new float[]{point3f.x, point3f.y, point3f.z}));
                            }
                            return this.addX(point3f);
                        }
                        if (point4f == null) break;
                        return this.addX(new Quaternion(point4f).mul(new Quaternion((Matrix3f)scriptVariable.value)));
                    }
                    case 12: {
                        if (point4f == null) break;
                        Matrix4f matrix4f = new Matrix4f((Matrix4f)scriptVariable.value);
                        matrix4f.transpose();
                        matrix4f.transform(point4f);
                        if (scriptVariable2.tok == 7) {
                            return this.addX(ScriptVariable.getVariable(new float[]{point4f.x, point4f.y, point4f.z, point4f.w}));
                        }
                        return this.addX(point4f);
                    }
                }
                switch (scriptVariable2.tok) {
                    default: {
                        return this.addX(ScriptVariable.fValue(scriptVariable2) * ScriptVariable.fValue(scriptVariable));
                    }
                    case 11: {
                        Matrix3f matrix3f = (Matrix3f)scriptVariable2.value;
                        if (point3f != null) {
                            matrix3f.transform(point3f);
                            if (scriptVariable.tok == 7) {
                                return this.addX(ScriptVariable.getVariable(new float[]{point3f.x, point3f.y, point3f.z}));
                            }
                            return this.addX(point3f);
                        }
                        switch (scriptVariable.tok) {
                            case 11: {
                                Matrix3f matrix3f2 = new Matrix3f((Matrix3f)scriptVariable.value);
                                matrix3f2.mul(matrix3f, matrix3f2);
                                return this.addX(matrix3f2);
                            }
                            case 9: {
                                return this.addX(new Quaternion(matrix3f).mul(new Quaternion((Point4f)scriptVariable.value)).getMatrix());
                            }
                        }
                        float f = ScriptVariable.fValue(scriptVariable);
                        AxisAngle4f axisAngle4f = new AxisAngle4f();
                        axisAngle4f.set(matrix3f);
                        axisAngle4f.angle *= f;
                        Matrix3f matrix3f3 = new Matrix3f();
                        matrix3f3.set(axisAngle4f);
                        return this.addX(matrix3f3);
                    }
                    case 12: {
                        Matrix4f matrix4f = (Matrix4f)scriptVariable2.value;
                        if (point3f != null) {
                            matrix4f.transform(point3f);
                            if (scriptVariable.tok == 7) {
                                return this.addX(ScriptVariable.getVariable(new float[]{point3f.x, point3f.y, point3f.z}));
                            }
                            return this.addX(point3f);
                        }
                        if (point4f != null) {
                            matrix4f.transform(point4f);
                            if (scriptVariable.tok == 7) {
                                return this.addX(ScriptVariable.getVariable(new float[]{point4f.x, point4f.y, point4f.z, point4f.w}));
                            }
                            return this.addX(point4f);
                        }
                        switch (scriptVariable.tok) {
                            case 12: {
                                Matrix4f matrix4f2 = new Matrix4f((Matrix4f)scriptVariable.value);
                                matrix4f2.mul(matrix4f, matrix4f2);
                                return this.addX(matrix4f2);
                            }
                        }
                        return this.addX("NaN");
                    }
                    case 8: {
                        point3f = new Point3f((Point3f)scriptVariable2.value);
                        switch (scriptVariable.tok) {
                            case 8: {
                                Point3f point3f3 = (Point3f)scriptVariable.value;
                                return this.addX(point3f.x * point3f3.x + point3f.y * point3f3.y + point3f.z * point3f3.z);
                            }
                        }
                        float f = ScriptVariable.fValue(scriptVariable);
                        return this.addX(new Point3f(point3f.x * f, point3f.y * f, point3f.z * f));
                    }
                    case 9: 
                }
                switch (scriptVariable.tok) {
                    case 9: {
                        return this.addX(new Quaternion((Point4f)scriptVariable2.value).mul(new Quaternion((Point4f)scriptVariable.value)));
                    }
                }
                return this.addX(new Quaternion((Point4f)scriptVariable2.value).mul(ScriptVariable.fValue(scriptVariable)).toPoint4f());
            }
            case 269484210: {
                String string = null;
                int n5 = ScriptVariable.iValue(scriptVariable);
                switch (scriptVariable2.tok) {
                    default: {
                        if (n5 == 0) {
                            return this.addX(0);
                        }
                        return this.addX(ScriptVariable.iValue(scriptVariable2) % n5);
                    }
                    case 3: {
                        float f = ScriptVariable.fValue(scriptVariable2);
                        if (n5 == 0) {
                            return this.addX((int)(f + 0.5f * (float)(f < 0.0f ? -1 : 1)));
                        }
                        string = TextFormat.formatDecimal(f, n5);
                        return this.addX(string);
                    }
                    case 4: {
                        string = (String)scriptVariable2.value;
                        if (n5 == 0) {
                            return this.addX(TextFormat.trim(string, "\n\t "));
                        }
                        if (n5 == 9999) {
                            return this.addX(string.toUpperCase());
                        }
                        if (n5 == -9999) {
                            return this.addX(string.toLowerCase());
                        }
                        if (n5 > 0) {
                            return this.addX(TextFormat.format(string, n5, n5, false, false));
                        }
                        return this.addX(TextFormat.format(string, -n5, n5, true, false));
                    }
                    case 7: {
                        String[] stringArray = ScriptVariable.listValue(scriptVariable2);
                        for (int i = 0; i < stringArray.length; ++i) {
                            stringArray[i] = n5 == 0 ? stringArray[i].trim() : (n5 > 0 ? TextFormat.format(stringArray[i], n5, n5, true, false) : TextFormat.format(string, -n5, n5, false, false));
                        }
                        return this.addX(stringArray);
                    }
                    case 8: {
                        Point3f point3f = new Point3f((Point3f)scriptVariable2.value);
                        this.viewer.toUnitCell(point3f, new Point3f(n5, n5, n5));
                        return this.addX(point3f);
                    }
                    case 9: {
                        Point4f point4f = (Point4f)scriptVariable2.value;
                        if (scriptVariable.tok == 8) {
                            return this.addX(new Quaternion(point4f).transform((Point3f)scriptVariable.value));
                        }
                        if (scriptVariable.tok == 9) {
                            Point4f point4f2 = new Point4f((Point4f)scriptVariable.value);
                            new Quaternion(point4f).getThetaDirected(point4f2);
                            return this.addX(point4f2);
                        }
                        switch (n5) {
                            case 0: {
                                return this.addX(point4f.w);
                            }
                            case 1: {
                                return this.addX(point4f.x);
                            }
                            case 2: {
                                return this.addX(point4f.y);
                            }
                            case 3: {
                                return this.addX(point4f.z);
                            }
                            case 4: {
                                return this.addX(new Quaternion(point4f).getNormal());
                            }
                            case -1: {
                                return this.addX(new Quaternion(point4f).getVector(-1));
                            }
                            case -2: {
                                return this.addX(new Quaternion(point4f).getTheta());
                            }
                            case -3: {
                                return this.addX(new Quaternion(point4f).getVector(0));
                            }
                            case -4: {
                                return this.addX(new Quaternion(point4f).getVector(1));
                            }
                            case -5: {
                                return this.addX(new Quaternion(point4f).getVector(2));
                            }
                            case -6: {
                                AxisAngle4f axisAngle4f = new Quaternion(point4f).toAxisAngle4f();
                                return this.addX(new Point4f(axisAngle4f.x, axisAngle4f.y, axisAngle4f.z, (float)((double)(axisAngle4f.angle * 180.0f) / Math.PI)));
                            }
                            case -9: {
                                return this.addX(new Quaternion(point4f).getMatrix());
                            }
                        }
                        return this.addX(point4f);
                    }
                    case 12: {
                        Matrix4f matrix4f = (Matrix4f)scriptVariable2.value;
                        switch (n5) {
                            case 1: {
                                Matrix3f matrix3f = new Matrix3f();
                                matrix4f.get(matrix3f);
                                return this.addX(matrix3f);
                            }
                            case 2: {
                                Vector3f vector3f = new Vector3f();
                                matrix4f.get(vector3f);
                                return this.addX(vector3f);
                            }
                        }
                        return false;
                    }
                    case 10: 
                }
                return this.addX(ScriptVariable.bsSelectRange(scriptVariable2, n5));
            }
            case 0x101000B0: {
                if (scriptVariable2.tok == 2 && scriptVariable.tok == 2 && scriptVariable.intValue != 0) {
                    return this.addX(scriptVariable2.intValue / scriptVariable.intValue);
                }
                float f = ScriptVariable.fValue(scriptVariable);
                switch (scriptVariable2.tok) {
                    default: {
                        float f3 = ScriptVariable.fValue(scriptVariable2);
                        if (f == 0.0f) {
                            return this.addX(f3 == 0.0f ? 0.0f : (f3 < 0.0f ? Float.POSITIVE_INFINITY : Float.POSITIVE_INFINITY));
                        }
                        return this.addX(f3 / f);
                    }
                    case 8: {
                        Point3f point3f = new Point3f((Point3f)scriptVariable2.value);
                        if (f == 0.0f) {
                            return this.addX(new Point3f(Float.NaN, Float.NaN, Float.NaN));
                        }
                        return this.addX(new Point3f(point3f.x / f, point3f.y / f, point3f.z / f));
                    }
                    case 9: 
                }
                if (scriptVariable.tok == 9) {
                    return this.addX(new Quaternion((Point4f)scriptVariable2.value).div(new Quaternion((Point4f)scriptVariable.value)).toPoint4f());
                }
                if (f == 0.0f) {
                    return this.addX(new Point4f(Float.NaN, Float.NaN, Float.NaN, Float.NaN));
                }
                return this.addX(new Quaternion((Point4f)scriptVariable2.value).mul(1.0f / f).toPoint4f());
            }
            case 269484211: {
                float f = ScriptVariable.fValue(scriptVariable);
                switch (scriptVariable2.tok) {
                    default: {
                        return this.addX(f == 0.0f ? 0 : (int)(ScriptVariable.fValue(scriptVariable2) / ScriptVariable.fValue(scriptVariable)));
                    }
                    case 9: 
                }
                if (f == 0.0f) {
                    return this.addX(new Point4f(Float.NaN, Float.NaN, Float.NaN, Float.NaN));
                }
                if (scriptVariable.tok == 9) {
                    return this.addX(new Quaternion((Point4f)scriptVariable2.value).divLeft(new Quaternion((Point4f)scriptVariable.value)).toPoint4f());
                }
                return this.addX(new Quaternion((Point4f)scriptVariable2.value).mul(1.0f / f).toPoint4f());
            }
            case 269484227: {
                float f = (float)Math.pow(ScriptVariable.fValue(scriptVariable2), ScriptVariable.fValue(scriptVariable));
                return scriptVariable2.tok == 2 && scriptVariable.tok == 2 ? this.addX((int)f) : this.addX(f);
            }
        }
        return true;
    }

    static Matrix4f getMatrix4f(Matrix3f matrix3f, Tuple3f tuple3f) {
        return new Matrix4f(matrix3f, tuple3f == null ? new Vector3f() : new Vector3f(tuple3f), 1.0f);
    }

    private boolean getBoundBox(ScriptVariable scriptVariable) {
        if (scriptVariable.tok != 10) {
            return false;
        }
        if (this.isSyntaxCheck) {
            return this.addX("");
        }
        BoxInfo boxInfo = this.viewer.getBoxInfo(ScriptVariable.bsSelect(scriptVariable), 1.0f);
        Point3f[] point3fArray = boxInfo.getBoundBoxPoints();
        return this.addX(new String[]{Escape.escape(point3fArray[0]), Escape.escape(point3fArray[1]), Escape.escape(point3fArray[2]), Escape.escape(point3fArray[3])});
    }

    private boolean getPointOrBitsetOperation(Token token, ScriptVariable scriptVariable) throws ScriptEvaluator.ScriptException {
        switch (scriptVariable.tok) {
            case 7: {
                if (token.intValue == 32 || token.intValue == 64 || token.intValue == 96 || token.intValue == 192 || token.intValue == 128 || token.intValue == 160) {
                    return this.addX(ScriptMathProcessor.getMinMax(scriptVariable.getList(), token.intValue));
                }
                if (token.intValue == 1141899271 || token.intValue == 1141899269) {
                    return this.addX(scriptVariable.sortOrReverse(token.intValue == 1141899269 ? Integer.MIN_VALUE : 1));
                }
                ScriptVariable[] scriptVariableArray = new ScriptVariable[scriptVariable.getList().size()];
                for (int i = 0; i < scriptVariableArray.length; ++i) {
                    Object object = ScriptVariable.unescapePointOrBitsetAsVariable(scriptVariable.getList().get(i));
                    if (!(object instanceof ScriptVariable) || !this.getPointOrBitsetOperation(token, (ScriptVariable)object)) {
                        return false;
                    }
                    scriptVariableArray[i] = this.xStack[this.xPt--];
                }
                return this.addX(scriptVariableArray);
            }
            case 8: {
                switch (token.intValue) {
                    case 1112541185: 
                    case 1112541203: {
                        return this.addX(((Point3f)scriptVariable.value).x);
                    }
                    case 1112541186: 
                    case 1112541204: {
                        return this.addX(((Point3f)scriptVariable.value).y);
                    }
                    case 1112541187: 
                    case 1112541205: {
                        return this.addX(((Point3f)scriptVariable.value).z);
                    }
                    case 1146095626: {
                        Point3f point3f = new Point3f((Point3f)scriptVariable.value);
                        this.viewer.toCartesian(point3f, true);
                        return this.addX(point3f);
                    }
                    case 1112541188: 
                    case 1112541189: 
                    case 1112541190: 
                    case 1146095627: {
                        Point3f point3f = new Point3f((Point3f)scriptVariable.value);
                        this.viewer.toFractional(point3f, true);
                        return token.intValue == 1146095627 ? this.addX(point3f) : this.addX(token.intValue == 1112541188 ? point3f.x : (token.intValue == 1112541189 ? point3f.y : point3f.z));
                    }
                    case 1112541191: 
                    case 1112541192: 
                    case 1112541193: 
                    case 1146095628: {
                        Point3f point3f = new Point3f((Point3f)scriptVariable.value);
                        this.viewer.toFractional(point3f, false);
                        return token.intValue == 1146095627 ? this.addX(point3f) : this.addX(token.intValue == 1112541191 ? point3f.x : (token.intValue == 1112541192 ? point3f.y : point3f.z));
                    }
                    case 1112539147: 
                    case 1112539148: 
                    case 1112539149: 
                    case 1146093581: {
                        Point3f point3f = new Point3f((Point3f)scriptVariable.value);
                        this.viewer.toUnitCell(point3f, null);
                        this.viewer.toFractional(point3f, false);
                        return token.intValue == 1146093581 ? this.addX(point3f) : this.addX(token.intValue == 1112539147 ? point3f.x : (token.intValue == 1112539148 ? point3f.y : point3f.z));
                    }
                }
                break;
            }
            case 9: {
                switch (token.intValue) {
                    case 1112541185: 
                    case 1112541203: {
                        return this.addX(((Point4f)scriptVariable.value).x);
                    }
                    case 1112541186: 
                    case 1112541204: {
                        return this.addX(((Point4f)scriptVariable.value).y);
                    }
                    case 1112541187: 
                    case 1112541205: {
                        return this.addX(((Point4f)scriptVariable.value).z);
                    }
                    case 1141899279: {
                        return this.addX(((Point4f)scriptVariable.value).w);
                    }
                }
                break;
            }
            case 10: {
                if (token.intValue == 1678770178 && scriptVariable.value instanceof Bond.BondSet) {
                    return this.addX(scriptVariable);
                }
                BitSet bitSet = ScriptVariable.bsSelect(scriptVariable);
                Object object = this.eval.getBitsetProperty(bitSet, token.intValue, null, null, scriptVariable.value, token.value, false, scriptVariable.index, false);
                if (token.intValue == 1678770178) {
                    object = new ScriptVariable(10, new Bond.BondSet((BitSet)object, this.viewer.getAtomIndices(bitSet)));
                }
                return this.addX(object);
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object getMinMax(Object object, int n) {
        double d;
        float[] fArray = null;
        List list = null;
        int n2 = 0;
        if (object instanceof float[]) {
            fArray = (float[])object;
            n2 = fArray.length;
            if (n2 == 0) {
                return "NaN";
            }
        } else {
            if (!(object instanceof List) || (n2 = (list = (List)object).size()) == 0) return "NaN";
            ScriptVariable scriptVariable = (ScriptVariable)list.get(0);
            if (scriptVariable.tok == 4 && ((String)scriptVariable.value).startsWith("{")) {
                Point3f point3f = ScriptVariable.ptValue(scriptVariable);
                if (point3f instanceof Point3f) {
                    return ScriptMathProcessor.getMinMaxPoint(list, n);
                }
                if (!(point3f instanceof Point4f)) return "NaN";
                return ScriptMathProcessor.getMinMaxQuaternion(list, n);
            }
        }
        switch (n) {
            case 32: {
                d = 3.4028234663852886E38;
                break;
            }
            case 64: {
                d = -3.4028234663852886E38;
                break;
            }
            default: {
                d = 0.0;
            }
        }
        double d2 = 0.0;
        int n3 = 0;
        int n4 = n2;
        while (--n4 >= 0) {
            float f;
            float f2 = f = fArray == null ? ScriptVariable.fValue((ScriptVariable)list.get(n4)) : fArray[n4];
            if (Float.isNaN(f)) continue;
            ++n3;
            switch (n) {
                case 160: 
                case 192: {
                    d2 += (double)f * (double)f;
                }
                case 96: 
                case 128: {
                    d += (double)f;
                    break;
                }
                case 32: {
                    if (!((double)f < d)) break;
                    d = f;
                    break;
                }
                case 64: {
                    if (!((double)f > d)) break;
                    d = f;
                }
            }
        }
        if (n3 == 0) return "NaN";
        switch (n) {
            case 96: {
                d /= (double)n3;
                return Float.valueOf((float)d);
            }
            case 192: {
                if (n3 == 1) return Float.valueOf((float)d);
                d = Math.sqrt((d2 - d * d / (double)n3) / (double)(n3 - 1));
                return Float.valueOf((float)d);
            }
            case 32: 
            case 64: 
            case 128: {
                return Float.valueOf((float)d);
            }
            case 160: {
                d = d2;
            }
        }
        return Float.valueOf((float)d);
    }

    private static Object getMinMaxPoint(Object object, int n) {
        Point3f[] point3fArray = null;
        List list = null;
        int n2 = 0;
        if (object instanceof Quaternion[]) {
            point3fArray = (Point3f[])object;
            n2 = point3fArray.length;
        } else if (object instanceof List) {
            list = (List)object;
            n2 = list.size();
        }
        if (list != null || point3fArray != null) {
            Point3f point3f = new Point3f();
            float[] fArray = new float[n2];
            boolean bl = true;
            block10: for (int i = 0; i < 3 && bl; ++i) {
                Object object2;
                block11: for (int j = 0; j < n2; ++j) {
                    Point3f point3f2;
                    Point3f point3f3 = point3f2 = point3fArray == null ? ScriptVariable.ptValue((ScriptVariable)list.get(j)) : point3fArray[j];
                    if (point3f2 == null) {
                        bl = false;
                        break;
                    }
                    switch (i) {
                        case 0: {
                            fArray[j] = point3f2.x;
                            continue block11;
                        }
                        case 1: {
                            fArray[j] = point3f2.y;
                            continue block11;
                        }
                        case 2: {
                            fArray[j] = point3f2.z;
                        }
                    }
                }
                if (!bl || !((object2 = ScriptMathProcessor.getMinMax(fArray, n)) instanceof Float)) break;
                float f = ((Float)object2).floatValue();
                switch (i) {
                    case 0: {
                        point3f.x = f;
                        continue block10;
                    }
                    case 1: {
                        point3f.y = f;
                        continue block10;
                    }
                    case 2: {
                        point3f.z = f;
                    }
                }
            }
            return point3f;
        }
        return "NaN";
    }

    private static Object getMinMaxQuaternion(Object object, int n) {
        block7: {
            switch (n) {
                case 32: 
                case 64: 
                case 128: 
                case 160: {
                    return "NaN";
                }
            }
            Quaternion[] quaternionArray = ScriptMathProcessor.getQuaternionArray(object);
            if (quaternionArray == null) break block7;
            float[] fArray = new float[1];
            Quaternion quaternion = Quaternion.sphereMean(quaternionArray, fArray, 1.0E-4f);
            switch (n) {
                case 96: {
                    return quaternion;
                }
                case 192: {
                    return new Float(fArray[0]);
                }
            }
        }
        return "NaN";
    }

    protected static Quaternion[] getQuaternionArray(Object object) {
        Quaternion[] quaternionArray;
        if (object instanceof Quaternion[]) {
            quaternionArray = (Quaternion[])object;
        } else if (object instanceof Point4f[]) {
            Point4f[] point4fArray = (Point4f[])object;
            quaternionArray = new Quaternion[point4fArray.length];
            for (int i = 0; i < point4fArray.length; ++i) {
                quaternionArray[i] = new Quaternion(point4fArray[i]);
            }
        } else if (object instanceof List) {
            List list = (List)object;
            quaternionArray = new Quaternion[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Point4f point4f = ScriptVariable.pt4Value((ScriptVariable)list.get(i));
                if (point4f == null) {
                    return null;
                }
                quaternionArray[i] = new Quaternion(point4f);
            }
        } else {
            return null;
        }
        return quaternionArray;
    }
}

