/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.applet;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Keymap;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jmol.api.JmolAppConsoleInterface;
import org.jmol.api.JmolViewer;
import org.jmol.console.JmolConsole;
import org.jmol.i18n.GT;
import org.jmol.viewer.Viewer;

public class AppletConsole
extends JmolConsole
implements JmolAppConsoleInterface {
    final JTextArea input = new ControlEnterTextArea();
    private final JTextPane output = new JTextPane();
    private final Document outputDocument = this.output.getDocument();
    private JFrame jf;
    private final SimpleAttributeSet attributesCommand = new SimpleAttributeSet();
    private JMenuBar menubar;
    private JButton clearOutButton;
    private JButton clearInButton;
    private JButton loadButton;
    protected Hashtable map = new Hashtable();
    protected Hashtable labels = null;

    public Object getMyMenuBar() {
        return this.menubar;
    }

    public void dispose() {
        this.jf.dispose();
        super.dispose();
    }

    public AppletConsole() {
    }

    public JmolAppConsoleInterface getAppConsole(Viewer viewer, Component component) {
        return new AppletConsole(viewer, component);
    }

    private AppletConsole(Viewer viewer, Component component) {
        this.display = component;
        this.set(viewer);
    }

    public void sendConsoleEcho(String string) {
        this.output(string);
    }

    public void sendConsoleMessage(String string) {
        this.output(string);
    }

    public void zap() {
    }

    private void set(JmolViewer jmolViewer) {
        this.viewer = jmolViewer;
        boolean bl = GT.getDoTranslate();
        GT.setDoTranslate(true);
        this.jf = new JFrame(AppletConsole.getTitleText());
        this.jf.setSize(600, 400);
        this.editButton = new JButton(GT._("Editor"));
        this.stateButton = new JButton(GT._("State"));
        this.runButton = new JButton(GT._("Run"));
        this.clearOutButton = new JButton(GT._("Clear Output"));
        this.clearInButton = new JButton(GT._("Clear Input"));
        this.historyButton = new JButton(GT._("History"));
        this.loadButton = new JButton(GT._("Load"));
        this.setupInput();
        this.setupOutput();
        JScrollPane jScrollPane = new JScrollPane(this.input);
        jScrollPane.setMinimumSize(new Dimension(2, 100));
        JScrollPane jScrollPane2 = new JScrollPane(this.output);
        jScrollPane2.setMinimumSize(new Dimension(2, 100));
        Container container = this.jf.getContentPane();
        this.menubar = this.createMenubar();
        this.jf.setJMenuBar(this.menubar);
        container.setLayout(new BoxLayout(container, 1));
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane2, jScrollPane);
        jSplitPane.setResizeWeight(0.9);
        jSplitPane.setDividerLocation(200);
        jSplitPane.setAlignmentX(0.5f);
        container.add(jSplitPane);
        Container container2 = new Container();
        container2.setLayout(new BoxLayout(container2, 0));
        container2.add(Box.createGlue());
        container2.add(this.editButton);
        container2.add(this.runButton);
        container2.add(this.loadButton);
        container2.add(this.clearInButton);
        container2.add(this.clearOutButton);
        container2.add(this.historyButton);
        container2.add(this.stateButton);
        container2.add(Box.createGlue());
        container.add(container2);
        JLabel jLabel = new JLabel(GT._("press CTRL-ENTER for new line or paste model data and press Load"), 0);
        jLabel.setAlignmentX(0.5f);
        container.add(jLabel);
        this.editButton.addActionListener((ActionListener)((Object)this));
        this.runButton.addActionListener((ActionListener)((Object)this));
        this.clearInButton.addActionListener((ActionListener)((Object)this));
        this.clearOutButton.addActionListener((ActionListener)((Object)this));
        this.historyButton.addActionListener((ActionListener)((Object)this));
        this.stateButton.addActionListener((ActionListener)((Object)this));
        this.loadButton.addActionListener((ActionListener)((Object)this));
        this.jf.addWindowListener((WindowListener)((Object)this));
        GT.setDoTranslate(bl);
    }

    protected JMenuBar createMenubar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(Box.createHorizontalGlue());
        this.addHelpMenuBar(jMenuBar);
        return jMenuBar;
    }

    protected void addHelpMenuBar(JMenuBar jMenuBar) {
        JMenu jMenu = this.newJMenu("help");
        JMenuItem jMenuItem = this.newJMenuItem("search");
        jMenuItem.addActionListener((ActionListener)((Object)this));
        jMenuItem.setName("help ?search=?");
        jMenu.add(jMenuItem);
        if (jMenu == null) {
            return;
        }
        this.addHelpItems(jMenu, "commands", "command");
        this.addHelpItems(jMenu, "functions", "mathfunc");
        this.addHelpItems(jMenu, "parameters", "setparam");
        this.addHelpItems(jMenu, "more", "misc");
        jMenuBar.add(jMenu);
    }

    private void addHelpItems(JMenu jMenu, String string, String string2) {
        JMenu jMenu2 = this.newJMenu(string);
        String[] stringArray = (String[])this.viewer.getProperty(null, "tokenList", string2);
        jMenu.add(jMenu2);
        JMenu jMenu3 = null;
        String string3 = null;
        int n = 20;
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if (!Character.isLetter(string4.charAt(0))) continue;
            JMenuItem jMenuItem = new JMenuItem(string4);
            jMenuItem.addActionListener((ActionListener)((Object)this));
            jMenuItem.setName("help " + string4);
            if (jMenu3 == null) {
                jMenu3 = new JMenu();
                string3 = string4;
                jMenu3.add(jMenuItem);
                jMenu3.setText(string3);
                continue;
            }
            if (i % n + 1 == n) {
                jMenu3.add(jMenuItem);
                jMenu3.setText(string3 + " - " + string4);
                jMenu2.add(jMenu3);
                jMenu3 = null;
                continue;
            }
            jMenu3.add(jMenuItem);
            if (i + 1 != stringArray.length || jMenu3 == null) continue;
            jMenu3.setText(string3 + " - " + string4);
            jMenu2.add(jMenu3);
        }
    }

    protected JMenuItem createMenuItem(String string) {
        return this.newJMenuItem(string);
    }

    private void setupInput() {
        this.input.setLineWrap(true);
        this.input.setWrapStyleWord(true);
        this.input.setDragEnabled(true);
        Keymap keymap = this.input.getKeymap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(65, 1);
        keymap.removeKeyStrokeBinding(keyStroke);
    }

    private void setupOutput() {
        this.output.setEditable(false);
        this.output.setDragEnabled(true);
        StyleConstants.setBold(this.attributesCommand, true);
    }

    public void setVisible(boolean bl) {
        this.jf.setVisible(bl);
        this.input.requestFocus();
    }

    private void output(String string) {
        this.output(string, null);
    }

    private void output(String string, AttributeSet attributeSet) {
        System.out.println("AppletConsole.output " + string + " " + attributeSet);
        if (string == null || string.length() == 0) {
            this.output.setText("");
            return;
        }
        if (string.charAt(string.length() - 1) != '\n') {
            string = string + "\n";
        }
        try {
            this.outputDocument.insertString(this.outputDocument.getLength(), string, attributeSet);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.output.setCaretPosition(this.outputDocument.getLength());
    }

    public String getText() {
        return this.output.getText();
    }

    protected void clearContent(String string) {
        this.output.setText(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.clearInButton) {
            this.input.setText("");
            return;
        }
        if (object == this.clearOutButton) {
            this.output.setText("");
            return;
        }
        if (object == this.loadButton) {
            this.viewer.loadInline(this.input.getText(), false);
            return;
        }
        if (object instanceof JMenuItem) {
            this.execute(((JMenuItem)object).getName());
            return;
        }
        super.actionPerformed(actionEvent);
    }

    protected void execute(String string) {
        String string2;
        String string3;
        String string4 = string3 = string == null ? this.input.getText() : string;
        if (string == null) {
            this.input.setText(null);
        }
        if ((string2 = this.viewer.script(string3 + "\u0001## EDITOR_IGNORE ##")) != null && !string2.equals("pending")) {
            this.output(string2);
        }
        if (string == null) {
            this.input.requestFocus();
        }
    }

    protected String completeCommand(String string) {
        return super.completeCommand(string);
    }

    public void windowClosed(WindowEvent windowEvent) {
        this.destroyConsole();
    }

    private void destroyConsole() {
        this.viewer.getProperty("DATA_API", "getAppConsole", Boolean.FALSE);
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.destroyConsole();
    }

    private Hashtable setupLabels() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("help", GT._("&Help"));
        hashtable.put("search", GT._("&Search..."));
        hashtable.put("commands", GT._("&Commands"));
        hashtable.put("functions", GT._("Math &Functions"));
        hashtable.put("parameters", GT._("Set &Parameters"));
        hashtable.put("more", GT._("&More"));
        return hashtable;
    }

    private String getLabel(String string) {
        if (this.labels == null) {
            this.labels = this.setupLabels();
        }
        return (String)this.labels.get(string);
    }

    private JMenu newJMenu(String string) {
        String string2 = this.getLabel(string);
        return new KeyJMenu(string, AppletConsole.getLabelWithoutMnemonic(string2), AppletConsole.getMnemonic(string2));
    }

    private JMenuItem newJMenuItem(String string) {
        String string2 = this.getLabel(string);
        return new KeyJMenuItem(string, AppletConsole.getLabelWithoutMnemonic(string2), AppletConsole.getMnemonic(string2));
    }

    private static String getLabelWithoutMnemonic(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(38);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n) + (n < string.length() - 1 ? string.substring(n + 1) : "");
    }

    private static char getMnemonic(String string) {
        if (string == null) {
            return ' ';
        }
        int n = string.indexOf(38);
        if (n == -1 || n == string.length() - 1) {
            return ' ';
        }
        return string.charAt(n + 1);
    }

    static {
        System.out.println("AppletConsole initialized");
    }

    private class KeyJMenuItem
    extends JMenuItem
    implements GetKey {
        String key;

        KeyJMenuItem(String string, String string2, char c) {
            super(string2);
            if (c != ' ') {
                this.setMnemonic(c);
            }
            this.key = string;
            AppletConsole.this.map.put(string, this);
        }

        public String getKey() {
            return this.key;
        }
    }

    private class KeyJMenu
    extends JMenu
    implements GetKey {
        String key;

        KeyJMenu(String string, String string2, char c) {
            super(string2);
            if (c != ' ') {
                this.setMnemonic(c);
            }
            this.key = string;
            AppletConsole.this.map.put(string, this);
        }

        public String getKey() {
            return this.key;
        }
    }

    private static interface GetKey {
        public String getKey();
    }

    class ControlEnterTextArea
    extends JTextArea {
        ControlEnterTextArea() {
        }

        public void processComponentKeyEvent(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            switch (keyEvent.getID()) {
                case 401: {
                    switch (n) {
                        case 9: {
                            keyEvent.consume();
                            if (AppletConsole.this.input.getCaretPosition() != AppletConsole.this.input.getText().length()) break;
                            String string = AppletConsole.this.completeCommand(this.getText());
                            if (string != null) {
                                this.setText(string.replace('\t', ' '));
                            }
                            ++AppletConsole.this.nTab;
                            return;
                        }
                        case 27: {
                            keyEvent.consume();
                            this.setText("");
                        }
                    }
                    AppletConsole.this.nTab = 0;
                    if (n == 10 && !keyEvent.isControlDown()) {
                        AppletConsole.this.execute(null);
                        return;
                    }
                    if (n != 38 && n != 40) break;
                    this.recallCommand(n == 38);
                    return;
                }
                case 402: {
                    if (n != 10 || keyEvent.isControlDown()) break;
                    return;
                }
            }
            if (n == 10) {
                keyEvent.setModifiers(0);
            }
            super.processComponentKeyEvent(keyEvent);
        }

        private void recallCommand(boolean bl) {
            String string = AppletConsole.this.viewer.getSetHistory(bl ? -1 : 1);
            if (string == null) {
                return;
            }
            this.setText(string);
        }
    }
}

