/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.jmol.api.JmolViewer;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.openscience.jmol.app.jmolpanel.JmolPanel;

public class PovrayDialog
extends JDialog {
    private transient JmolViewer viewer;
    protected JButton povrayPathButton;
    protected JButton goButton;
    protected JTextField saveField;
    protected JTextField savePathLabel;
    private int outputWidth = -1;
    private int outputHeight = -1;
    protected JTextField povrayPathLabel;
    protected JCheckBox runPovCheck;
    protected JCheckBox allFramesCheck;
    protected JCheckBox antiAliasCheck;
    protected JCheckBox displayWhileRenderingCheck;
    private JLabel imageSizeWidth;
    private JFormattedTextField imageSizeTextWidth;
    private JLabel imageSizeHeight;
    private JFormattedTextField imageSizeTextHeight;
    private JCheckBox imageSizeRatioBox;
    private JComboBox imageSizeRatioCombo;
    private JCheckBox outputFormatCheck;
    private JComboBox outputFormatCombo;
    private JCheckBox outputAlphaCheck;
    private JCheckBox mosaicPreviewCheck;
    private JLabel mosaicPreviewStart;
    private JComboBox mosaicPreviewComboStart;
    private JLabel mosaicPreviewEnd;
    private JComboBox mosaicPreviewComboEnd;
    private String outputExtension = ".png";
    private String outputFileType = "N";

    public PovrayDialog(JFrame jFrame, JmolViewer jmolViewer) {
        super(jFrame, GT._("Render in POV-Ray"), true);
        int n;
        this.viewer = jmolViewer;
        String string = null;
        int n2 = jmolViewer.getScreenWidth();
        int n3 = jmolViewer.getScreenHeight();
        this.setImageDimensions(n2, n3);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PovrayDialog.this.updateScreen();
            }
        };
        InputVerifier inputVerifier = new InputVerifier(){

            public boolean verify(JComponent jComponent) {
                PovrayDialog.this.updateScreen();
                return true;
            }
        };
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PovrayDialog.this.updateScreen();
            }
        };
        Box box = Box.createVerticalBox();
        this.getContentPane().add(box);
        Box box2 = Box.createVerticalBox();
        Box box3 = Box.createVerticalBox();
        string = GT._("Conversion from Jmol to POV-Ray");
        box3.setBorder(new TitledBorder(string));
        Box box4 = Box.createHorizontalBox();
        string = GT._("File Name:");
        box4.setBorder(new TitledBorder(string));
        string = GT._("'caffeine.pov' -> 'caffeine.pov', 'caffeine.pov.ini', 'caffeine.pov.spt'");
        box4.setToolTipText(string);
        this.saveField = new JTextField("Jmol.pov", 20);
        this.saveField.addActionListener(actionListener);
        this.saveField.setInputVerifier(inputVerifier);
        box4.add(this.saveField);
        box3.add(box4);
        Box box5 = Box.createHorizontalBox();
        string = GT._("Working Directory");
        box5.setBorder(new TitledBorder(string));
        string = GT._("Where the .pov files will be saved");
        box5.setToolTipText(string);
        this.savePathLabel = new JTextField("");
        this.savePathLabel.setEditable(false);
        this.savePathLabel.setBorder(null);
        box5.add(this.savePathLabel);
        string = GT._("Select");
        JButton jButton = new JButton(string);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PovrayDialog.this.showSavePathDialog();
            }
        });
        box5.add(jButton);
        box3.add(box5);
        box2.add(box3);
        Box box6 = Box.createVerticalBox();
        string = GT._("POV-Ray Runtime Options");
        box6.setBorder(new TitledBorder(string));
        Box box7 = Box.createHorizontalBox();
        string = GT._("Run POV-Ray directly");
        this.runPovCheck = new JCheckBox(string, true);
        string = GT._("Launch POV-Ray from within Jmol");
        this.runPovCheck.setToolTipText(string);
        this.runPovCheck.addItemListener(itemListener);
        box7.add(this.runPovCheck);
        box7.add(Box.createGlue());
        box6.add(box7);
        Box box8 = Box.createHorizontalBox();
        string = GT._("Display While Rendering");
        this.displayWhileRenderingCheck = new JCheckBox(string, true);
        string = GT._("Should POV-Ray attempt to display while rendering?");
        this.displayWhileRenderingCheck.setToolTipText(string);
        this.displayWhileRenderingCheck.addItemListener(itemListener);
        box8.add(this.displayWhileRenderingCheck);
        box8.add(Box.createGlue());
        box6.add(box8);
        Box box9 = Box.createHorizontalBox();
        box9.add(Box.createHorizontalStrut(10));
        Box box10 = Box.createVerticalBox();
        Box box11 = Box.createHorizontalBox();
        string = GT._("width:") + " ";
        this.imageSizeWidth = new JLabel(string);
        string = GT._("Image width");
        this.imageSizeWidth.setToolTipText(string);
        box11.add(this.imageSizeWidth);
        this.imageSizeTextWidth = new JFormattedTextField();
        this.imageSizeTextWidth.setValue(new Integer(this.outputWidth));
        this.imageSizeTextWidth.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PovrayDialog.this.imageSizeChanged();
                PovrayDialog.this.updateCommandLine();
            }
        });
        box11.add(this.imageSizeTextWidth);
        box11.add(Box.createHorizontalStrut(10));
        string = GT._("height:") + " ";
        this.imageSizeHeight = new JLabel(string);
        string = GT._("Image height");
        this.imageSizeHeight.setToolTipText(string);
        box11.add(this.imageSizeHeight);
        this.imageSizeTextHeight = new JFormattedTextField();
        this.imageSizeTextHeight.setValue(new Integer(this.outputHeight));
        this.imageSizeTextHeight.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PovrayDialog.this.imageSizeChanged();
                PovrayDialog.this.updateCommandLine();
            }
        });
        box11.add(this.imageSizeTextHeight);
        box11.add(Box.createGlue());
        box10.add(box11);
        Box box12 = Box.createHorizontalBox();
        string = GT._("Fixed ratio : ");
        this.imageSizeRatioBox = new JCheckBox(string, true);
        string = GT._("Use a fixed ratio for width:height");
        this.imageSizeRatioBox.setToolTipText(string);
        this.imageSizeRatioBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PovrayDialog.this.imageSizeChanged();
                PovrayDialog.this.updateCommandLine();
            }
        });
        box12.add(this.imageSizeRatioBox);
        box12.add(Box.createHorizontalStrut(10));
        this.imageSizeRatioCombo = new JComboBox();
        string = GT._("User defined");
        this.imageSizeRatioCombo.addItem(string);
        string = GT._("Keep ratio of Jmol window");
        this.imageSizeRatioCombo.addItem(string);
        string = "4:3";
        this.imageSizeRatioCombo.addItem(string);
        string = "16:9";
        this.imageSizeRatioCombo.addItem(string);
        this.imageSizeRatioCombo.setSelectedIndex(1);
        this.imageSizeRatioCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PovrayDialog.this.imageSizeChanged();
                PovrayDialog.this.updateCommandLine();
            }
        });
        box12.add(this.imageSizeRatioCombo);
        box12.add(Box.createGlue());
        box10.add(box12);
        box10.add(Box.createGlue());
        box9.add(box10);
        box9.add(Box.createGlue());
        box6.add(box9);
        this.imageSizeChanged();
        Box box13 = Box.createHorizontalBox();
        box13.add(Box.createHorizontalStrut(10));
        this.outputFormatCombo = new JComboBox();
        string = GT._("N - PNG");
        this.outputFormatCombo.addItem(string);
        string = GT._("P - PPM");
        this.outputFormatCombo.addItem(string);
        string = GT._("C - Compressed Targa-24");
        this.outputFormatCombo.addItem(string);
        string = GT._("T - Uncompressed Targa-24");
        this.outputFormatCombo.addItem(string);
        this.outputFormatCombo.setSelectedIndex(0);
        this.outputFormatCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PovrayDialog.this.outputFormatChanged();
                PovrayDialog.this.updateCommandLine();
            }
        });
        box13.add(this.outputFormatCombo);
        box13.add(Box.createGlue());
        box6.add(box13);
        this.outputFormatChanged();
        Box box14 = Box.createHorizontalBox();
        string = GT._("Alpha transparency");
        this.outputAlphaCheck = new JCheckBox(string, false);
        string = GT._("Output Alpha transparency data");
        this.outputAlphaCheck.setToolTipText(string);
        this.outputAlphaCheck.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PovrayDialog.this.updateCommandLine();
            }
        });
        box14.add(this.outputAlphaCheck);
        box14.add(Box.createGlue());
        box6.add(box14);
        Box box15 = Box.createHorizontalBox();
        string = GT._("Mosaic preview");
        this.mosaicPreviewCheck = new JCheckBox(string, false);
        string = GT._("Render the image in several passes");
        this.mosaicPreviewCheck.setToolTipText(string);
        this.mosaicPreviewCheck.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PovrayDialog.this.mosaicPreviewChanged();
                PovrayDialog.this.updateCommandLine();
            }
        });
        box15.add(this.mosaicPreviewCheck);
        box15.add(Box.createHorizontalStrut(10));
        string = GT._("Start size : ");
        this.mosaicPreviewStart = new JLabel(string);
        string = GT._("Initial size of the tiles");
        this.mosaicPreviewStart.setToolTipText(string);
        box15.add(this.mosaicPreviewStart);
        this.mosaicPreviewComboStart = new JComboBox();
        for (n = 0; n < 8; ++n) {
            this.mosaicPreviewComboStart.addItem(Integer.toString((int)Math.pow(2.0, n)));
        }
        this.mosaicPreviewComboStart.setSelectedIndex(3);
        this.mosaicPreviewComboStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PovrayDialog.this.mosaicPreviewChanged();
                PovrayDialog.this.updateCommandLine();
            }
        });
        box15.add(this.mosaicPreviewComboStart);
        box15.add(Box.createHorizontalStrut(10));
        string = GT._("End size : ");
        this.mosaicPreviewEnd = new JLabel(string);
        string = GT._("Final size of the tiles");
        this.mosaicPreviewEnd.setToolTipText(string);
        box15.add(this.mosaicPreviewEnd);
        this.mosaicPreviewComboEnd = new JComboBox();
        for (n = 0; n < 8; ++n) {
            this.mosaicPreviewComboEnd.addItem(Integer.toString((int)Math.pow(2.0, n)));
        }
        this.mosaicPreviewComboEnd.setSelectedIndex(0);
        this.mosaicPreviewComboEnd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PovrayDialog.this.mosaicPreviewChanged();
                PovrayDialog.this.updateCommandLine();
            }
        });
        box15.add(this.mosaicPreviewComboEnd);
        box15.add(Box.createGlue());
        box6.add(box15);
        this.mosaicPreviewChanged();
        Box box16 = Box.createHorizontalBox();
        string = GT._("Location of the POV-Ray Executable");
        box16.setBorder(new TitledBorder(string));
        string = GT._("Location of the POV-Ray Executable");
        box16.setToolTipText(string);
        this.povrayPathLabel = new JTextField("");
        this.povrayPathLabel.setEditable(false);
        this.povrayPathLabel.setBorder(null);
        box16.add(this.povrayPathLabel);
        string = GT._("Select");
        this.povrayPathButton = new JButton(string);
        this.povrayPathButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PovrayDialog.this.showPovrayPathDialog();
            }
        });
        box16.add(this.povrayPathButton);
        box6.add(box16);
        box2.add(box6);
        Box box17 = Box.createHorizontalBox();
        box17.add(Box.createGlue());
        string = GT._("Go!");
        this.goButton = new JButton(string);
        string = GT._("Save file and possibly launch POV-Ray");
        this.goButton.setToolTipText(string);
        this.goButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PovrayDialog.this.goPressed();
            }
        });
        box17.add(this.goButton);
        string = GT._("Cancel");
        JButton jButton2 = new JButton(string);
        string = GT._("Cancel this dialog without saving");
        jButton2.setToolTipText(string);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PovrayDialog.this.cancelPressed();
            }
        });
        box17.add(jButton2);
        box.add(box2);
        box.add(box17);
        this.getPathHistory();
        this.updateScreen();
        this.pack();
        this.centerDialog();
        this.setVisible(true);
    }

    public void setImageDimensions(int n, int n2) {
        this.outputWidth = n;
        this.outputHeight = n2;
        this.updateCommandLine();
    }

    void goPressed() {
        int n;
        String string;
        String string2 = string = this.saveField.getText();
        String string3 = this.savePathLabel.getText();
        File file = new File(string3, string2);
        if (file != null) {
            string = string2 = file.getAbsolutePath();
            n = Integer.parseInt(this.imageSizeTextHeight.getValue().toString());
            int n2 = Integer.parseInt(this.imageSizeTextWidth.getValue().toString());
            String[] stringArray = new String[]{string2 + ":::" + this.getINI()};
            String string4 = this.viewer.generateOutput("Povray", stringArray, n2, n);
            if (string4 == null) {
                return;
            }
            this.viewer.writeTextFile(string2 + ".ini", string4);
        }
        if ((n = this.runPovCheck.isSelected()) != 0) {
            String[] stringArray = null;
            stringArray = new String[]{this.povrayPathLabel.getText(), string2 + ".ini"};
            try {
                Runtime.getRuntime().exec(stringArray);
            }
            catch (IOException iOException) {
                Logger.error("Caught IOException in povray exec", iOException);
                Logger.error("CmdLine:");
                for (int i = 0; i < stringArray.length; ++i) {
                    Logger.error("  <" + stringArray[i] + ">");
                }
            }
        }
        this.setVisible(false);
        this.saveHistory();
        this.dispose();
    }

    void cancelPressed() {
        this.setVisible(false);
        this.dispose();
    }

    void showSavePathDialog() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showDialog(this, GT._("Select"));
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            String string = file.isDirectory() ? file.toString() : file.getParent();
            this.savePathLabel.setText(string);
            this.updateCommandLine();
            this.pack();
        }
    }

    void showPovrayPathDialog() {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showDialog(this, GT._("Select"));
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.povrayPathLabel.setText(file.toString());
            this.updateCommandLine();
            this.pack();
        }
    }

    void imageSizeChanged() {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        if (this.imageSizeRatioBox != null) {
            bl3 = this.imageSizeRatioBox.isSelected();
            this.imageSizeRatioBox.setEnabled(bl && bl2);
        }
        if (this.imageSizeWidth != null) {
            this.imageSizeWidth.setEnabled(bl && bl2);
        }
        if (this.imageSizeTextWidth != null) {
            this.imageSizeTextWidth.setEnabled(bl && bl2);
        }
        if (this.imageSizeHeight != null) {
            this.imageSizeHeight.setEnabled(bl && !bl3 && bl2);
        }
        if (this.imageSizeTextHeight != null) {
            this.imageSizeTextHeight.setEnabled(bl && !bl3 && bl2);
        }
        if (this.imageSizeRatioCombo != null) {
            this.imageSizeRatioCombo.setEnabled(bl && bl3 && bl2);
            if (this.imageSizeTextWidth != null && this.imageSizeTextHeight != null) {
                int n = Integer.parseInt(this.imageSizeTextWidth.getValue().toString());
                switch (this.imageSizeRatioCombo.getSelectedIndex()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        int n2 = (int)((double)n * (double)this.outputHeight / (double)this.outputWidth);
                        this.imageSizeTextHeight.setValue(new Integer(n2));
                        break;
                    }
                    case 2: {
                        int n3 = (int)((double)n * 3.0 / 4.0);
                        this.imageSizeTextHeight.setValue(new Integer(n3));
                        break;
                    }
                    case 3: {
                        int n4 = (int)((double)n * 9.0 / 16.0);
                        this.imageSizeTextHeight.setValue(new Integer(n4));
                    }
                }
            }
        }
    }

    void outputFormatChanged() {
        if (this.outputFormatCheck != null) {
            boolean bl = this.outputFormatCheck.isSelected();
            boolean bl2 = true;
            this.outputFormatCheck.setEnabled(bl2);
            if (this.outputFormatCombo != null) {
                this.outputFormatCombo.setEnabled(bl && bl2);
                switch (this.outputFormatCombo.getSelectedIndex()) {
                    case 0: {
                        this.outputExtension = ".png";
                        this.outputFileType = "N";
                        break;
                    }
                    case 1: {
                        this.outputExtension = ".ppm";
                        this.outputFileType = "P";
                        break;
                    }
                    case 2: {
                        this.outputExtension = ".tga";
                        this.outputFileType = "C";
                        break;
                    }
                    case 3: {
                        this.outputExtension = ".tga";
                        this.outputFileType = "T";
                    }
                }
            }
        }
    }

    void mosaicPreviewChanged() {
        if (this.mosaicPreviewCheck != null) {
            boolean bl = this.mosaicPreviewCheck.isSelected();
            boolean bl2 = this.runPovCheck.isSelected();
            this.mosaicPreviewCheck.setEnabled(bl2);
            if (this.mosaicPreviewStart != null) {
                this.mosaicPreviewStart.setEnabled(bl && bl2);
            }
            if (this.mosaicPreviewComboStart != null) {
                this.mosaicPreviewComboStart.setEnabled(bl && bl2);
            }
            if (this.mosaicPreviewEnd != null) {
                this.mosaicPreviewEnd.setEnabled(bl && bl2);
            }
            if (this.mosaicPreviewComboEnd != null) {
                this.mosaicPreviewComboEnd.setEnabled(bl && bl2);
            }
        }
    }

    protected void updateScreen() {
        boolean bl = false;
        if (this.runPovCheck != null) {
            bl = this.runPovCheck.isSelected();
        }
        String string = null;
        string = bl ? GT._("Go!") : GT._("Save");
        if (this.goButton != null) {
            this.goButton.setText(string);
        }
        boolean bl2 = true;
        if (this.antiAliasCheck != null) {
            this.antiAliasCheck.setEnabled(bl || bl2);
        }
        if (this.povrayPathButton != null) {
            this.povrayPathButton.setEnabled(bl || bl2);
        }
        this.imageSizeChanged();
        this.outputFormatChanged();
        this.updateCommandLine();
    }

    protected void updateCommandLine() {
    }

    protected String getCommandLine() {
        String string = null;
        if (this.saveField != null) {
            string = this.saveField.getText();
        }
        String string2 = null;
        if (this.savePathLabel != null) {
            string2 = this.savePathLabel.getText();
        }
        String string3 = null;
        if (this.povrayPathLabel != null) {
            string3 = this.povrayPathLabel.getText();
        }
        if (string2 == null || string3 == null || string == null) {
            return "";
        }
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        String string4 = this.doubleQuoteIfContainsSpace(string3) + " +I" + this.simpleQuoteIfContainsSpace(string2 + string + ".pov");
        string4 = string4 + " +O" + this.simpleQuoteIfContainsSpace(string2 + string + this.outputExtension) + " +F" + this.outputFileType;
        if (this.outputAlphaCheck != null && this.outputAlphaCheck.isSelected()) {
            string4 = string4 + " +UA";
        }
        string4 = string4 + " +H" + this.imageSizeTextHeight.getValue() + " +W" + this.imageSizeTextWidth.getValue();
        string4 = string4 + " +A0.1";
        if (this.displayWhileRenderingCheck != null && this.displayWhileRenderingCheck.isSelected()) {
            string4 = string4 + " +D +P";
        }
        if (this.allFramesCheck != null && this.allFramesCheck.isSelected()) {
            string4 = string4 + " +KFI1";
            string4 = string4 + " +KFF" + this.viewer.getModelCount();
            string4 = string4 + " +KI1";
            string4 = string4 + " +KF" + this.viewer.getModelCount();
        }
        if (this.mosaicPreviewCheck != null && this.mosaicPreviewCheck.isSelected()) {
            string4 = string4 + " +SP" + this.mosaicPreviewComboStart.getSelectedItem() + " +EP" + this.mosaicPreviewComboEnd.getSelectedItem();
        }
        string4 = string4 + " -V";
        return string4;
    }

    private String getINI() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.savePathLabel.getText();
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        String string2 = this.saveField.getText();
        stringBuffer.append("Input_File_Name=" + string + string2 + "\n");
        stringBuffer.append("Output_to_File=true\n");
        stringBuffer.append("Output_File_Type=" + this.outputFileType + "\n");
        stringBuffer.append("Output_File_Name=" + string + string2 + this.outputExtension + "\n");
        stringBuffer.append("Height=" + this.imageSizeTextHeight.getValue() + "\n");
        stringBuffer.append("Width=" + this.imageSizeTextWidth.getValue() + "\n");
        if (this.allFramesCheck != null && this.allFramesCheck.isSelected()) {
            stringBuffer.append("Initial_Frame=1\n");
            stringBuffer.append("Final_Frame=" + this.viewer.getModelCount() + "\n");
            stringBuffer.append("Initial_Clock=1\n");
            stringBuffer.append("Final_Clock=" + this.viewer.getModelCount() + "\n");
        }
        if (this.outputAlphaCheck != null && this.outputAlphaCheck.isSelected()) {
            stringBuffer.append("Output_Alpha=true\n");
        }
        stringBuffer.append("Antialias=true\n");
        stringBuffer.append("Antialias_Threshold=0.1\n");
        if (this.displayWhileRenderingCheck != null && this.displayWhileRenderingCheck.isSelected()) {
            stringBuffer.append("Display=true\n");
            stringBuffer.append("Pause_When_Done=true\n");
        }
        if (this.mosaicPreviewCheck != null && this.mosaicPreviewCheck.isSelected()) {
            stringBuffer.append("Preview_Start_Size=" + this.mosaicPreviewComboStart.getSelectedItem() + "\n");
            stringBuffer.append("Preview_End_Size=" + this.mosaicPreviewComboEnd.getSelectedItem() + "\n");
        }
        stringBuffer.append("Warning_Level=5\n");
        stringBuffer.append("Verbose=false\n");
        return stringBuffer.toString();
    }

    protected void centerDialog() {
        Dimension dimension = this.getToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        dimension.height /= 2;
        dimension.width /= 2;
        dimension2.height /= 2;
        dimension2.width /= 2;
        int n = dimension.height - dimension2.height;
        int n2 = dimension.width - dimension2.width;
        this.setLocation(n2, n);
    }

    private void getPathHistory() {
        String string;
        Properties properties = JmolPanel.historyFile.getProperties();
        if (this.povrayPathLabel != null && (string = properties.getProperty("povrayPath", System.getProperty("user.home"))) != null) {
            this.povrayPathLabel.setText(string);
        }
        if (this.savePathLabel != null && (string = properties.getProperty("povraySavePath", System.getProperty("user.home"))) != null) {
            this.savePathLabel.setText(string);
        }
    }

    private void saveHistory() {
        Properties properties = new Properties();
        properties.setProperty("povrayPath", this.povrayPathLabel.getText());
        properties.setProperty("povraySavePath", this.savePathLabel.getText());
        JmolPanel.historyFile.addProperties(properties);
    }

    String doubleQuoteIfContainsSpace(String string) {
        int n = string.length();
        while (--n >= 0) {
            if (string.charAt(n) != ' ') continue;
            return "\"" + string + "\"";
        }
        return string;
    }

    String simpleQuoteIfContainsSpace(String string) {
        int n = string.length();
        while (--n >= 0) {
            if (string.charAt(n) != ' ') continue;
            return "'" + string + "'";
        }
        return string;
    }

    class PovrayWindowListener
    extends WindowAdapter {
        PovrayWindowListener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            PovrayDialog.this.cancelPressed();
            PovrayDialog.this.setVisible(false);
            PovrayDialog.this.dispose();
        }
    }
}

