/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.multitouch.sparshui;

import com.sparshui.client.ClientServerConnection;
import com.sparshui.client.SparshClient;
import com.sparshui.common.Event;
import com.sparshui.common.Location;
import com.sparshui.common.messages.events.DragEvent;
import com.sparshui.common.messages.events.RotateEvent;
import com.sparshui.common.messages.events.TouchEvent;
import com.sparshui.common.messages.events.ZoomEvent;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.List;
import org.jmol.api.Interface;
import org.jmol.api.JmolGestureServerInterface;
import org.jmol.multitouch.JmolMultiTouchClient;
import org.jmol.multitouch.JmolMultiTouchClientAdapter;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class JmolSparshClientAdapter
extends JmolMultiTouchClientAdapter
implements SparshClient {
    private ClientServerConnection serverConnection;
    boolean doneHere;
    private JmolGestureServerInterface gestureServer;

    public void dispose() {
        Logger.debug("JmolSparshClientAdapter -- dispose");
        this.doneHere = true;
        try {
            if (this.serverConnection != null) {
                this.serverConnection.close();
                this.serverConnection.interrupt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.gestureServer != null) {
                this.gestureServer.dispose();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean setMultiTouchClient(Viewer viewer, JmolMultiTouchClient jmolMultiTouchClient, boolean bl) {
        String string;
        super.setMultiTouchClient(viewer, jmolMultiTouchClient, bl);
        this.gestureServer = (JmolGestureServerInterface)Interface.getInterface("com.sparshui.server.GestureServer");
        this.gestureServer.startGestureServer();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.isServer = (this.gestureServer.getState() & 1) != 0;
        int n = 5946;
        try {
            this.serverConnection = new ClientServerConnection("127.0.0.1", this);
            Logger.info("SparshUI connection established at 127.0.0.1 port " + n);
            return true;
        }
        catch (UnknownHostException unknownHostException) {
            string = unknownHostException.getMessage();
        }
        catch (IOException iOException) {
            string = iOException.getMessage();
        }
        this.actionManager = null;
        Logger.error("Cannot create SparshUI connection at 127.0.0.1 port " + n + ": " + string);
        return false;
    }

    public List getAllowedGestures(int n) {
        return this.actionManager == null ? null : this.actionManager.getAllowedGestures(n);
    }

    public int getGroupID(Location location) {
        if (this.actionManager == null) {
            return 0;
        }
        this.fixXY(location.getX(), location.getY(), true);
        return this.actionManager == null ? 0 : this.actionManager.getGroupID(this.xyTemp.x, this.xyTemp.y);
    }

    public void processEvent(int n, Event event) {
        if (this.actionManager == null) {
            return;
        }
        if (event == null) {
            int n2 = n;
            switch (n2) {
                case -1: {
                    Logger.info("JmolSparshAdapter service lost event...disposing ");
                    this.dispose();
                    break;
                }
            }
            this.actionManager.processEvent(-1, n2, -1, -1, null, -1L);
            return;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = event.getEventType();
        long l = 0L;
        switch (n5) {
            case 3: {
                n3 = ((TouchEvent)event).getTouchID();
                this.fixXY(((TouchEvent)event).getX(), ((TouchEvent)event).getY(), true);
                n4 = ((TouchEvent)event).getState();
                l = ((TouchEvent)event).getTime();
                break;
            }
            case 0: {
                this.fixXY(((DragEvent)event).getDx(), ((DragEvent)event).getDy(), false);
                n4 = ((DragEvent)event).getNPoints();
                l = ((DragEvent)event).getTime();
                break;
            }
            case 4: {
                this.fixXY(((ZoomEvent)event).getX(), ((ZoomEvent)event).getY(), true);
                this.ptTemp.z = ((ZoomEvent)event).getScale();
                l = ((ZoomEvent)event).getTime();
                break;
            }
            case 1: {
                this.fixXY(((RotateEvent)event).getX(), ((RotateEvent)event).getY(), true);
                this.ptTemp.z = ((RotateEvent)event).getRotation();
                l = ((RotateEvent)event).getTime();
            }
        }
        this.actionManager.processEvent(n, n5, n3, n4, this.ptTemp, l);
    }
}

