/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.client;

import com.sparshui.client.SparshClient;
import com.sparshui.common.ClientProtocol;
import com.sparshui.common.Event;
import com.sparshui.common.Location;
import com.sparshui.common.messages.events.DragEvent;
import com.sparshui.common.messages.events.FlickEvent;
import com.sparshui.common.messages.events.RelativeDragEvent;
import com.sparshui.common.messages.events.RotateEvent;
import com.sparshui.common.messages.events.SpinEvent;
import com.sparshui.common.messages.events.TouchEvent;
import com.sparshui.common.messages.events.ZoomEvent;
import com.sparshui.common.utils.Converter;
import java.io.IOException;
import java.net.Socket;
import java.util.List;

public class ClientToServerProtocol
extends ClientProtocol {
    public ClientToServerProtocol(Socket socket) throws IOException {
        super(socket);
    }

    public boolean processRequest(SparshClient sparshClient) {
        try {
            byte by = this._in.readByte();
            int n = this._in.readInt();
            byte[] byArray = new byte[n];
            if (n > 0) {
                this._in.readFully(byArray);
            }
            switch (by) {
                case 0: {
                    this.handleEvents(sparshClient, byArray);
                    break;
                }
                case 1: {
                    this.handleGetGroupID(sparshClient, byArray);
                    break;
                }
                case 2: {
                    this.handleGetAllowedGestures(sparshClient, byArray);
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("[Client Protocol] GestureServer Connection Lost");
            this.handleEvents(sparshClient, null);
            return false;
        }
        return true;
    }

    private void handleEvents(SparshClient sparshClient, byte[] byArray) {
        if (byArray == null) {
            sparshClient.processEvent(-1, null);
            return;
        }
        if (byArray.length < 1) {
            return;
        }
        int n = Converter.byteArrayToInt(byArray);
        int n2 = Converter.byteArrayToInt(byArray, 4);
        byte[] byArray2 = new byte[byArray.length - 8];
        System.arraycopy(byArray, 8, byArray2, 0, byArray.length - 8);
        Event event = null;
        switch (n2) {
            case -2: {
                sparshClient.processEvent(-2, null);
                return;
            }
            case 0: {
                event = new DragEvent(byArray2);
                break;
            }
            case 1: {
                event = new RotateEvent(byArray2);
                break;
            }
            case 2: {
                event = new SpinEvent();
                break;
            }
            case 3: {
                event = new TouchEvent(byArray2);
                break;
            }
            case 4: {
                event = new ZoomEvent(byArray2);
                break;
            }
            case 6: {
                event = new FlickEvent(byArray2);
                break;
            }
            case 7: {
                event = new RelativeDragEvent(byArray2);
            }
        }
        if (event != null) {
            sparshClient.processEvent(n, event);
        }
    }

    private void handleGetGroupID(SparshClient sparshClient, byte[] byArray) throws IOException {
        this._out.writeInt(sparshClient.getGroupID(new Location(Converter.byteArrayToFloat(byArray, 0), Converter.byteArrayToFloat(byArray, 4))));
    }

    private void handleGetAllowedGestures(SparshClient sparshClient, byte[] byArray) throws IOException {
        Object e;
        int n;
        List list = sparshClient.getAllowedGestures(Converter.byteArrayToInt(byArray));
        int n2 = list == null ? 0 : list.size();
        int n3 = n2 * 4;
        for (n = 0; n < n2; ++n) {
            e = list.get(n);
            if (!(e instanceof String)) continue;
            n3 += ((String)e).length();
        }
        this._out.writeInt(n3);
        for (n = 0; n < n2; ++n) {
            int n4;
            e = list.get(n);
            if (e instanceof Integer) {
                this._out.writeInt((Integer)e);
                continue;
            }
            if (!(e instanceof String) || (n4 = ((String)e).length()) <= 0) continue;
            this._out.writeInt(-n4);
            this._out.write(Converter.stringToByteArray((String)e));
        }
    }
}

