/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.molxyz;

import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class MolReader
extends AtomSetCollectionReader {
    boolean is2D;
    private boolean isV3000;
    private String dimension;

    public void initializeReader() throws Exception {
        this.is2D = this.checkFilter("2D");
    }

    protected boolean checkLine() throws Exception {
        boolean bl = this.line.startsWith("$MDL");
        if (bl) {
            this.discardLinesUntilStartsWith("$HDR");
            this.readLine();
            if (this.line == null) {
                Logger.warn((String)"$HDR not found in MDL RG file");
                this.continuing = false;
                return false;
            }
        }
        if (this.doGetModel(++this.modelNumber)) {
            this.processMolSdHeader();
            this.processCtab(bl);
            if (this.isLastModel(this.modelNumber)) {
                this.continuing = false;
                return false;
            }
        }
        this.discardLinesUntilStartsWith("$$$$");
        return true;
    }

    public void finalizeReader() throws Exception {
        if (this.is2D) {
            this.set2D();
        }
        super.finalizeReader();
    }

    void processMolSdHeader() throws Exception {
        String string = "";
        String string2 = this.line;
        string = string + this.line + "\n";
        this.atomSetCollection.setCollectionName(this.line);
        this.readLine();
        if (this.line == null) {
            return;
        }
        string = string + this.line + "\n";
        this.dimension = this.line.length() < 22 ? "3D" : this.line.substring(20, 22);
        this.readLine();
        if (this.line == null) {
            return;
        }
        string = string + this.line + "\n";
        this.checkLineForScript();
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("fileHeader", (Object)string);
        this.newAtomSet(string2);
    }

    void processCtab(boolean bl) throws Exception {
        String[] stringArray = null;
        if (bl) {
            this.discardLinesUntilStartsWith("$CTAB");
        }
        boolean bl2 = this.isV3000 = this.readLine() != null && this.line.indexOf("V3000") >= 0;
        if (this.isV3000) {
            this.is2D = this.dimension.equals("2D");
            this.discardLinesUntilContains("COUNTS");
            stringArray = this.getTokens();
        }
        if (this.line == null) {
            return;
        }
        int n = this.isV3000 ? this.parseInt((String)stringArray[3]) : this.parseInt(this.line, 0, 3);
        int n2 = this.isV3000 ? this.parseInt(stringArray[4]) : this.parseInt(this.line, 3, 6);
        int n3 = this.atomSetCollection.getAtomCount();
        this.readAtoms(n);
        this.readBonds(n3, n2);
        this.applySymmetryAndSetTrajectory();
    }

    void readAtoms(int n) throws Exception {
        if (this.isV3000) {
            this.discardLinesUntilContains("BEGIN ATOM");
        }
        for (int i = 0; i < n; ++i) {
            float f;
            float f2;
            float f3;
            String string;
            Atom atom;
            this.readLine();
            int n2 = 0;
            int n3 = 0;
            if (this.isV3000) {
                this.checkLineContinuation();
                atom = this.getTokens();
                string = atom[3];
                f3 = this.parseFloat(atom[4]);
                f2 = this.parseFloat(atom[5]);
                f = this.parseFloat(atom[6]);
                for (int j = 7; j < ((String[])atom).length; ++j) {
                    String string2 = atom[j].toUpperCase();
                    if (string2.startsWith("CHG=")) {
                        n2 = this.parseInt(atom[j].substring(4));
                        continue;
                    }
                    if (!string2.startsWith("MASS=")) continue;
                    n3 = this.parseInt(atom[j].substring(5));
                }
                if (n3 > 1 && string.equals("H")) {
                    n3 = 1 - n3;
                }
            } else {
                string = this.line.length() > 34 ? this.line.substring(31, 34).trim() : this.line.substring(31).trim();
                f3 = this.parseFloat(this.line, 0, 10);
                f2 = this.parseFloat(this.line, 10, 20);
                f = this.parseFloat(this.line, 20, 30);
                if (this.line.length() >= 39) {
                    int n4 = this.parseInt(this.line, 36, 39);
                    if (n4 >= 1 && n4 <= 7) {
                        n2 = 4 - n4;
                    }
                    if ((n4 = this.parseInt(this.line, 34, 36)) != 0 && n4 >= -3 && n4 <= 4) {
                        n3 = JmolAdapter.getNaturalIsotope((int)JmolAdapter.getElementNumber((String)string));
                        switch (n3) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                n3 = -n4;
                                break;
                            }
                            default: {
                                n3 += n4;
                            }
                        }
                    }
                }
            }
            switch (n3) {
                case 0: {
                    break;
                }
                case -1: {
                    string = "D";
                    break;
                }
                case -2: {
                    string = "T";
                    break;
                }
                default: {
                    string = n3 + string;
                }
            }
            if (this.is2D && f != 0.0f) {
                this.is2D = false;
            }
            atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = string;
            atom.formalCharge = n2;
            this.setAtomCoord(atom, f3, f2, f);
        }
    }

    private void checkLineContinuation() throws Exception {
        while (this.line.endsWith("-")) {
            String string = this.line;
            this.readLine();
            this.line = string + this.line;
        }
    }

    void readBonds(int n, int n2) throws Exception {
        if (this.isV3000) {
            this.discardLinesUntilContains("BEGIN BOND");
        }
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4;
            int n5;
            this.readLine();
            int n6 = 0;
            if (this.isV3000) {
                this.checkLineContinuation();
                String[] stringArray = this.getTokens();
                n5 = this.parseInt(stringArray[3]);
                n4 = this.parseInt(stringArray[4]);
                n3 = this.parseInt(stringArray[5]);
                for (int j = 6; j < stringArray.length; ++j) {
                    String string = stringArray[j].toUpperCase();
                    if (!string.startsWith("CFG=")) continue;
                    n6 = this.parseInt(stringArray[j].substring(4));
                    break;
                }
            } else {
                n4 = this.parseInt(this.line, 0, 3);
                n3 = this.parseInt(this.line, 3, 6);
                n5 = this.parseInt(this.line, 6, 9);
                if (this.is2D && n5 == 1 && this.line.length() >= 12) {
                    n6 = this.parseInt(this.line.substring(9, 12));
                }
            }
            switch (n5) {
                case -10: 
                case 0: {
                    n5 = 1;
                    break;
                }
                case 1: {
                    switch (n6) {
                        case 1: {
                            n5 = 1025;
                            break;
                        }
                        case 3: 
                        case 6: {
                            n5 = 1041;
                        }
                    }
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    n5 = 515;
                    break;
                }
                case 5: {
                    n5 = 66;
                    break;
                }
                case 6: {
                    n5 = 513;
                    break;
                }
                case 7: {
                    n5 = 514;
                    break;
                }
                case 8: {
                    n5 = 33;
                }
            }
            this.atomSetCollection.addBond(new Bond(n + n4 - 1, n + n3 - 1, n5));
        }
    }
}

