/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapebio;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3i;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.shapebio.BioShape;
import org.jmol.shapebio.RocketsRenderer;

public class CartoonRenderer
extends RocketsRenderer {
    private boolean newRockets = true;
    private boolean renderAsRockets;
    private boolean renderEdges;
    private short colixSugarEdge;
    private short colixWatsonCrickEdge;
    private short colixHoogsteenEdge;
    Point3i ptConnect = new Point3i();
    private final Point3f[] ring6Points = new Point3f[6];
    private final Point3i[] ring6Screens = new Point3i[6];
    private final Point3f[] ring5Points = new Point3f[5];
    private final Point3i[] ring5Screens = new Point3i[5];

    public CartoonRenderer() {
        this.ring6Screens[5] = new Point3i();
        int n = 5;
        while (--n >= 0) {
            this.ring5Screens[n] = new Point3i();
            this.ring6Screens[n] = new Point3i();
        }
    }

    protected void renderBioShape(BioShape bioShape) {
        int n;
        if (bioShape.wingVectors == null || this.isCarbohydrate) {
            return;
        }
        this.calcScreenControlPoints();
        if (this.isNucleic) {
            this.renderNucleic();
            return;
        }
        boolean bl = this.viewer.getCartoonRocketFlag();
        if (this.renderAsRockets != bl) {
            for (n = 0; n < this.monomerCount; ++n) {
                bioShape.falsifyMesh(n, false);
            }
            this.renderAsRockets = bl;
        }
        boolean bl2 = bl = !this.viewer.getRocketBarrelFlag();
        if (this.renderArrowHeads != bl) {
            for (n = 0; n < this.monomerCount; ++n) {
                bioShape.falsifyMesh(n, false);
            }
            this.renderArrowHeads = bl;
        }
        this.ribbonTopScreens = this.calcScreens(0.5f);
        this.ribbonBottomScreens = this.calcScreens(-0.5f);
        this.calcRopeMidPoints(this.newRockets);
        if (!this.renderArrowHeads) {
            this.calcScreenControlPoints(this.cordMidPoints);
            this.controlPoints = this.cordMidPoints;
        }
        this.render1();
        this.viewer.freeTempPoints(this.cordMidPoints);
        this.viewer.freeTempScreens(this.ribbonTopScreens);
        this.viewer.freeTempScreens(this.ribbonBottomScreens);
    }

    void renderNucleic() {
        this.renderEdges = this.viewer.getCartoonBaseEdgesFlag();
        boolean bl = Graphics3D.isColixTranslucent((short)this.colix);
        if (this.renderEdges) {
            float f = Graphics3D.getColixTranslucencyLevel((short)this.colix);
            this.colixSugarEdge = Graphics3D.getColixTranslucent((short)10, (boolean)bl, (float)f);
            this.colixWatsonCrickEdge = Graphics3D.getColixTranslucent((short)11, (boolean)bl, (float)f);
            this.colixHoogsteenEdge = Graphics3D.getColixTranslucent((short)7, (boolean)bl, (float)f);
        }
        boolean bl2 = this.viewer.getTraceAlpha();
        int n = this.bsVisible.nextSetBit(0);
        while (n >= 0) {
            if (bl2) {
                this.ptConnect.set((this.controlPointScreens[n].x + this.controlPointScreens[n + 1].x) / 2, (this.controlPointScreens[n].y + this.controlPointScreens[n + 1].y) / 2, (this.controlPointScreens[n].z + this.controlPointScreens[n + 1].z) / 2);
            } else {
                this.ptConnect.set((Tuple3i)this.controlPointScreens[n + 1]);
            }
            this.renderHermiteConic(n, false);
            this.colix = this.getLeadColix(n);
            if (this.g3d.setColix(this.colix)) {
                this.renderNucleicBaseStep((NucleicMonomer)this.monomers[n], this.mads[n], this.ptConnect);
            }
            n = this.bsVisible.nextSetBit(n + 1);
        }
    }

    protected void render1() {
        boolean bl = false;
        boolean bl2 = false;
        ProteinStructure proteinStructure = null;
        int n = this.monomerCount;
        while (--n >= 0) {
            boolean bl3;
            ProteinStructure proteinStructure2 = this.monomers[n].getProteinStructure();
            if (proteinStructure2 != proteinStructure) {
                if (this.renderAsRockets) {
                    bl2 = false;
                }
                bl = false;
            }
            proteinStructure = proteinStructure2;
            boolean bl4 = this.isHelix(n);
            boolean bl5 = this.isSheet(n);
            boolean bl6 = bl3 = this.renderAsRockets || !this.renderArrowHeads ? bl4 : false;
            if (this.bsVisible.get(n) && !bl3) {
                if (bl5 || bl4) {
                    if (bl && bl5 || bl2 && bl4) {
                        this.renderHermiteRibbon(true, n, true);
                    } else {
                        this.renderHermiteArrowHead(n);
                    }
                } else if (n != this.monomerCount - 1) {
                    this.renderHermiteConic(n, true);
                }
            }
            bl = bl5;
            bl2 = bl4;
        }
        if (this.renderAsRockets || !this.renderArrowHeads) {
            this.renderRockets();
        }
    }

    private void renderRockets() {
        this.tPending = false;
        int n = this.bsVisible.nextSetBit(0);
        while (n >= 0) {
            if (this.isHelix(n)) {
                this.renderSpecialSegment(this.monomers[n], this.getLeadColix(n), this.mads[n]);
            }
            n = this.bsVisible.nextSetBit(n + 1);
        }
        this.renderPending();
    }

    private void renderNucleicBaseStep(NucleicMonomer nucleicMonomer, short n, Point3i point3i) {
        Point3i point3i2;
        if (this.renderEdges) {
            this.renderLenotisWesthofEdges(nucleicMonomer, (short)n, point3i);
            return;
        }
        nucleicMonomer.getBaseRing6Points(this.ring6Points);
        this.viewer.transformPoints(this.ring6Points, this.ring6Screens);
        this.renderRing6();
        boolean bl = nucleicMonomer.maybeGetBaseRing5Points(this.ring5Points);
        if (bl) {
            this.viewer.transformPoints(this.ring5Points, this.ring5Screens);
            this.renderRing5();
            point3i2 = this.ring5Screens[3];
        } else {
            point3i2 = this.ring6Screens[2];
        }
        this.mad = (short)(n > 1 ? n / 2 : n);
        this.g3d.fillCylinderScreen((byte)3, (int)this.viewer.scaleToScreen(point3i.z, (int)this.mad), point3i, point3i2);
        --this.ring6Screens[5].z;
        int n2 = 5;
        while (--n2 >= 0) {
            --this.ring6Screens[n2].z;
            if (!bl) continue;
            --this.ring5Screens[n2].z;
        }
        n2 = 6;
        while (--n2 > 0) {
            this.g3d.fillCylinderScreen((byte)3, 3, this.ring6Screens[n2], this.ring6Screens[n2 - 1]);
        }
        if (bl) {
            n2 = 5;
            while (--n2 > 0) {
                this.g3d.fillCylinderScreen((byte)3, 3, this.ring5Screens[n2], this.ring5Screens[n2 - 1]);
            }
        } else {
            this.g3d.fillCylinderScreen((byte)3, 3, this.ring6Screens[5], this.ring6Screens[0]);
        }
    }

    private void renderLenotisWesthofEdges(NucleicMonomer nucleicMonomer, short n, Point3i point3i) {
        if (!nucleicMonomer.getEdgePoints(this.ring6Points)) {
            return;
        }
        this.viewer.transformPoints(this.ring6Points, this.ring6Screens);
        this.renderTriangle(this.ring6Points);
        this.mad = (short)(n > 1 ? n / 2 : n);
        this.g3d.fillCylinderScreen((byte)3, 3, this.ring6Screens[0], this.ring6Screens[1]);
        this.g3d.fillCylinderScreen((byte)3, 3, this.ring6Screens[1], this.ring6Screens[2]);
        this.g3d.setColix(this.colixSugarEdge);
        this.g3d.fillCylinderScreen((byte)3, 3, this.ring6Screens[2], this.ring6Screens[3]);
        this.g3d.setColix(this.colixWatsonCrickEdge);
        this.g3d.fillCylinderScreen((byte)3, 3, this.ring6Screens[3], this.ring6Screens[4]);
        this.g3d.setColix(this.colixHoogsteenEdge);
        this.g3d.fillCylinderScreen((byte)3, 3, this.ring6Screens[4], this.ring6Screens[5]);
    }

    private void renderTriangle(Point3f[] point3fArray) {
        this.g3d.setNoisySurfaceShade(this.ring6Screens[2], this.ring6Screens[3], this.ring6Screens[4]);
        this.g3d.fillTriangle(this.ring6Screens[2], this.ring6Screens[3], this.ring6Screens[4]);
    }

    private void renderRing6() {
        this.g3d.setNoisySurfaceShade(this.ring6Screens[0], this.ring6Screens[2], this.ring6Screens[4]);
        this.g3d.fillTriangle(this.ring6Screens[0], this.ring6Screens[2], this.ring6Screens[4]);
        this.g3d.fillTriangle(this.ring6Screens[0], this.ring6Screens[1], this.ring6Screens[2]);
        this.g3d.fillTriangle(this.ring6Screens[0], this.ring6Screens[4], this.ring6Screens[5]);
        this.g3d.fillTriangle(this.ring6Screens[2], this.ring6Screens[3], this.ring6Screens[4]);
    }

    private void renderRing5() {
        this.g3d.fillTriangle(this.ring5Screens[0], this.ring5Screens[2], this.ring5Screens[3]);
        this.g3d.fillTriangle(this.ring5Screens[0], this.ring5Screens[1], this.ring5Screens[2]);
        this.g3d.fillTriangle(this.ring5Screens[0], this.ring5Screens[3], this.ring5Screens[4]);
    }
}

