/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.jmol.adapter.readers.quantum.MOReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class PsiReader
extends MOReader {
    List atomNames = new ArrayList();
    List shellsByUniqueAtom = new ArrayList();
    Hashtable uniqueAtomMap = new Hashtable();

    protected boolean checkLine() throws Exception {
        if (this.line.indexOf("-Geometry after Center-of-Mass shift and reorientation (a.u.):") >= 0) {
            this.readAtoms(true);
            this.doProcessLines = true;
            return true;
        }
        if (this.line.indexOf("-Unique atoms in the canonical coordinate system (a.u.):") >= 0) {
            this.readUniqueAtoms();
            this.doProcessLines = true;
            return true;
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.indexOf("New Cartesian Geometry in a.u.") >= 0) {
            this.readAtoms(false);
            return true;
        }
        if (this.line.startsWith("  label        = ")) {
            this.calculationType = this.line.substring(17).trim();
            this.moData.put("calculationType", this.calculationType);
            return true;
        }
        if (this.line.startsWith("molecular orbitals for ")) {
            this.moData.put("energyUnits", "");
            return true;
        }
        if (this.line.startsWith("  -BASIS SETS:")) {
            this.readBasis();
            return true;
        }
        if (this.line.indexOf("Molecular Orbital Coefficients") >= 0) {
            if (this.filterMO()) {
                this.readPsiMolecularOrbitals();
            }
            return true;
        }
        if (this.line.indexOf("SCF total energy   =") >= 0) {
            this.readSCFDone();
            return true;
        }
        return this.checkNboLine();
    }

    private void readSCFDone() throws Exception {
        this.atomSetCollection.setAtomSetName(this.line);
    }

    private void readAtoms(boolean bl) throws Exception {
        if (bl) {
            this.atomSetCollection.newAtomSet();
            this.atomSetCollection.setAtomSetName("");
            this.discardLinesUntilContains("----");
        }
        int n = 0;
        while (this.readLine() != null && this.line.length() > 0) {
            Atom atom;
            String[] stringArray = this.getTokens();
            Atom atom2 = atom = bl ? this.atomSetCollection.addNewAtom() : this.atomSetCollection.getAtom(n++);
            if (bl) {
                this.atomNames.add(stringArray[0]);
            } else {
                atom.elementNumber = (short)this.parseInt(stringArray[0]);
            }
            if (atom.elementNumber < 0) {
                atom.elementNumber = 0;
            }
            atom.set(this.parseFloat(stringArray[1]), this.parseFloat(stringArray[2]), this.parseFloat(stringArray[3]));
            atom.scale(0.5291772f);
        }
    }

    void readBasis() throws Exception {
        int n;
        String[] stringArray;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        this.gaussianCount = 0;
        this.shellCount = 0;
        int[] nArray = null;
        ArrayList<int[]> arrayList2 = null;
        this.readLine();
        while (this.readLine() != null && this.line.startsWith("   -Basis set on")) {
            arrayList2 = new ArrayList<int[]>();
            int n2 = 0;
            while (this.readLine() != null && !this.line.startsWith("       )")) {
                this.line = this.line.replace('(', ' ').replace(')', ' ');
                stringArray = this.getTokens();
                n = 0;
                switch (stringArray.length) {
                    case 3: {
                        if (nArray != null) {
                            arrayList2.add(nArray);
                        }
                        n = 1;
                        nArray = new int[3];
                        nArray[0] = JmolAdapter.getQuantumShellTagID((String)stringArray[0]);
                        nArray[1] = this.gaussianCount;
                        ++this.shellCount;
                        break;
                    }
                }
                arrayList.add(new String[]{stringArray[n], stringArray[n + 1]});
                nArray[2] = ++n2;
            }
            if (nArray != null) {
                arrayList2.add(nArray);
            }
            this.shellsByUniqueAtom.add(arrayList2);
            this.gaussianCount += n2;
            this.readLine();
        }
        float[][] fArrayArray = new float[this.gaussianCount][];
        for (n = 0; n < this.gaussianCount; ++n) {
            stringArray = (String[])arrayList.get(n);
            fArrayArray[n] = new float[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                fArrayArray[n][i] = this.parseFloat(stringArray[i]);
            }
        }
        this.moData.put("gaussians", fArrayArray);
        if (Logger.debugging) {
            Logger.debug((String)(this.shellCount + " slater shells read"));
            Logger.debug((String)(this.gaussianCount + " gaussian primitives read"));
        }
    }

    private void readUniqueAtoms() throws Exception {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        this.discardLinesUntilContains("----");
        int n = 0;
        while (this.readLine() != null && this.line.length() > 0) {
            String[] stringArray = this.getTokens();
            this.uniqueAtomMap.put(stringArray[0], new Integer(n++));
        }
        int n2 = this.atomNames.size();
        for (int i = 0; i < n2; ++i) {
            String string = (String)this.atomNames.get(i);
            int n3 = (Integer)this.uniqueAtomMap.get(string);
            List list = (List)this.shellsByUniqueAtom.get(n3);
            if (list == null) {
                Logger.error((String)("slater for atom " + i + " atomType " + string + " was not found in listing. Ignoring molecular orbitals"));
                return;
            }
            for (int j = 0; j < list.size(); ++j) {
                int[] nArray = (int[])list.get(j);
                arrayList.add(new int[]{i, nArray[0], nArray[1], nArray[2]});
            }
        }
        this.moData.put("shells", arrayList);
    }

    void readPsiMolecularOrbitals() throws Exception {
        Hashtable[] hashtableArray = new Hashtable[5];
        List[] listArray = new ArrayList[5];
        int n = 0;
        while (this.readLine() != null && this.line.toUpperCase().indexOf("DENS") < 0) {
            int n2;
            int n3;
            String[] stringArray = this.getTokens();
            int n4 = n3 = this.line.charAt(5) == ' ' ? 2 : 4;
            if (this.line.indexOf("                    ") == 0) {
                this.addMOData(n, listArray, hashtableArray);
                n = stringArray.length;
                stringArray = PsiReader.getTokens((String)this.readLine());
                for (n2 = 0; n2 < n; ++n2) {
                    hashtableArray[n2] = new Hashtable();
                    listArray[n2] = new ArrayList();
                    hashtableArray[n2].put("symmetry", stringArray[n2]);
                }
                stringArray = PsiReader.getStrings((String)this.readLine().substring(21), (int)n, (int)10);
                for (n2 = 0; n2 < n; ++n2) {
                    hashtableArray[n2].put("energy", new Float(stringArray[n2]));
                }
                continue;
            }
            try {
                for (n2 = 0; n2 < n; ++n2) {
                    listArray[n2].add(stringArray[n2 + n3]);
                }
            }
            catch (Exception exception) {
                Logger.error((String)("Error reading Psi3 file molecular orbitals at line: " + this.line));
                break;
            }
        }
        this.addMOData(n, listArray, hashtableArray);
        this.moData.put("mos", this.orbitals);
        this.setMOData(this.moData);
    }
}

