/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Group;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;

public final class Chain {
    ModelSet modelSet;
    Model model;
    char chainID;
    int groupCount;
    Group[] groups = new Group[16];
    private int selectedGroupCount;
    private boolean isDna;
    private boolean isRna;
    private BitSet bsSelectedGroups;

    public Chain(ModelSet modelSet, Model model, char c) {
        this.modelSet = modelSet;
        this.model = model;
        this.chainID = c;
    }

    public void setModelSet(ModelSet modelSet) {
        this.modelSet = modelSet;
    }

    public char getChainID() {
        return this.chainID;
    }

    public ModelSet getModelSet() {
        return this.modelSet;
    }

    public boolean isDna() {
        return this.isDna;
    }

    public boolean isRna() {
        return this.isRna;
    }

    public void setIsDna(boolean bl) {
        this.isDna = bl;
    }

    public void setIsRna(boolean bl) {
        this.isRna = bl;
    }

    public Group getGroup(int n) {
        return this.groups[n];
    }

    public int getGroupCount() {
        return this.groupCount;
    }

    public int getAtomCount() {
        return this.groups[this.groupCount - 1].lastAtomIndex + 1 - this.groups[0].firstAtomIndex;
    }

    public Atom getAtom(int n) {
        return this.modelSet.atoms[n];
    }

    public void calcSelectedGroupsCount(BitSet bitSet) {
        this.selectedGroupCount = 0;
        if (this.bsSelectedGroups == null) {
            this.bsSelectedGroups = new BitSet();
        }
        this.bsSelectedGroups.clear();
        for (int i = 0; i < this.groupCount; ++i) {
            if (this.groups[i].isSelected(bitSet)) {
                ++this.selectedGroupCount;
                this.groups[i].selectedIndex = this.groups[i].selectedIndex;
                this.bsSelectedGroups.set(i);
                continue;
            }
            this.groups[i].selectedIndex = -1;
        }
    }

    public int selectSeqcodeRange(int n, int n2, int n3, BitSet bitSet) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        boolean bl = false;
        for (n8 = n; n8 < this.groupCount && this.groups[n8].seqcode != n2; ++n8) {
        }
        if (n8 == this.groupCount) {
            if (n > 0) {
                return -1;
            }
            bl = true;
            n7 = Integer.MAX_VALUE;
            n6 = this.groupCount;
            while (--n6 >= 0) {
                n5 = this.groups[n6].seqcode;
                if (n5 <= n2 || n5 - n2 >= n7) continue;
                n8 = n6;
                n7 = n5 - n2;
            }
            if (n7 == Integer.MAX_VALUE) {
                return -1;
            }
        }
        if (n3 == Integer.MAX_VALUE) {
            n4 = this.groupCount - 1;
            bl = true;
        } else {
            for (n4 = n8; n4 < this.groupCount && this.groups[n4].seqcode != n3; ++n4) {
            }
            if (n4 == this.groupCount) {
                if (n > 0) {
                    return -1;
                }
                bl = true;
                n7 = Integer.MAX_VALUE;
                for (n6 = n8; n6 < this.groupCount; ++n6) {
                    n5 = this.groups[n6].seqcode;
                    if (n5 >= n3 || n3 - n5 >= n7) continue;
                    n4 = n6;
                    n7 = n3 - n5;
                }
                if (n7 == Integer.MAX_VALUE) {
                    return -1;
                }
            }
        }
        for (n6 = n8; n6 <= n4; ++n6) {
            this.groups[n6].selectAtoms(bitSet);
        }
        return bl ? -1 : n4 + 1;
    }

    int getSelectedGroupCount() {
        return this.selectedGroupCount;
    }

    public final void updateOffsetsForAlternativeLocations(BitSet bitSet, int n, byte[] byArray, int n2, int n3) {
        Atom[] atomArray = this.modelSet.atoms;
        int n4 = byArray.length;
        block0: while (--n4 >= 0) {
            int n5;
            Atom atom;
            int n6 = byArray[n4] & 0xFF;
            if (n6 == 255 || (atom = this.getAtom(n5 = n2 + n6)).getAlternateLocationID() == '\u0000') continue;
            int n7 = n3 - n2;
            for (int i = 1; i <= n7; ++i) {
                int n8;
                int n9 = n5 + i;
                if (n9 > n3) {
                    n9 -= n7 + 1;
                }
                if ((n8 = n9 - n2) < 0 || n8 > 255 || n9 == n5 || !bitSet.get(n9) || atomArray[n9].atomID != atomArray[n5].atomID || atomArray[n9].atomID == 0 && !atomArray[n9].getAtomName().equals(atomArray[n5].getAtomName())) continue;
                byArray[n4] = (byte)n8;
                continue block0;
            }
        }
    }

    public void fixIndices(int n) {
        for (int i = 0; i < this.groupCount; ++i) {
            this.groups[i].firstAtomIndex -= n;
            this.groups[i].leadAtomIndex -= n;
            this.groups[i].lastAtomIndex -= n;
        }
    }
}

