/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.Helix;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.modelsetbio.Sheet;
import org.jmol.modelsetbio.Turn;
import org.jmol.util.Quaternion;

public class AlphaMonomer
extends Monomer {
    static final byte[] alphaOffsets = new byte[]{0};
    protected ProteinStructure proteinStructure;
    protected Point3f nitrogenHydrogenPoint;

    public boolean isProtein() {
        return true;
    }

    static Monomer validateAndAllocate(Chain chain, String string, int n, int n2, int n3, int[] nArray) {
        if (n2 != n3 || nArray[2] != n2) {
            return null;
        }
        return new AlphaMonomer(chain, string, n, n2, n3, alphaOffsets);
    }

    AlphaMonomer(Chain chain, String string, int n, int n2, int n3, byte[] byArray) {
        super(chain, string, n, n2, n3, byArray);
    }

    boolean isAlphaMonomer() {
        return true;
    }

    public ProteinStructure getProteinStructure() {
        return this.proteinStructure;
    }

    public Object getStructure() {
        return this.getProteinStructure();
    }

    void setStructure(ProteinStructure proteinStructure) {
        this.proteinStructure = proteinStructure;
        if (proteinStructure == null) {
            this.nitrogenHydrogenPoint = null;
        }
    }

    public void setProteinStructureId(int n) {
        if (this.proteinStructure != null) {
            this.proteinStructure.uniqueID = n;
        }
    }

    public byte getProteinStructureType() {
        return this.proteinStructure == null ? (byte)0 : this.proteinStructure.type;
    }

    public byte getProteinStructureSubType() {
        return this.proteinStructure == null ? (byte)0 : this.proteinStructure.subtype;
    }

    public int getStrucNo() {
        return this.proteinStructure != null ? this.proteinStructure.uniqueID : 0;
    }

    public boolean isHelix() {
        return this.proteinStructure != null && this.proteinStructure.type == 3;
    }

    public boolean isSheet() {
        return this.proteinStructure != null && this.proteinStructure.type == 2;
    }

    public int setProteinStructureType(byte by, int n) {
        if (n < 0 || n > 0 && this.monomerIndex == 0) {
            int n2;
            if (this.proteinStructure != null && (n2 = this.proteinStructure.removeMonomer(this.monomerIndex)) > 0) {
                this.getBioPolymer().removeProteinStructure(this.monomerIndex + 1, n2);
            }
            switch (by) {
                case 3: 
                case 7: 
                case 8: 
                case 9: {
                    this.setStructure(new Helix((AlphaPolymer)this.bioPolymer, this.monomerIndex, 1, 0, by));
                    break;
                }
                case 2: {
                    this.setStructure(new Sheet((AlphaPolymer)this.bioPolymer, this.monomerIndex, 1, 0, by));
                    break;
                }
                case 1: {
                    this.setStructure(new Turn((AlphaPolymer)this.bioPolymer, this.monomerIndex, 1, 0));
                    break;
                }
                case 0: {
                    this.setStructure(null);
                }
            }
        } else {
            this.setStructure(this.getBioPolymer().getProteinStructure(n));
            if (this.proteinStructure != null) {
                this.proteinStructure.addMonomer(this.monomerIndex);
            }
        }
        return this.monomerIndex;
    }

    public final Atom getAtom(byte by) {
        return by == 2 ? this.getLeadAtom() : null;
    }

    public final Point3f getAtomPoint(byte by) {
        return by == 2 ? this.getLeadAtom() : null;
    }

    boolean isConnectedAfter(Monomer monomer) {
        Atom atom;
        if (monomer == null) {
            return true;
        }
        if (!(monomer instanceof AlphaMonomer)) {
            return false;
        }
        Atom atom2 = this.getLeadAtom();
        return atom2.isBonded(atom = monomer.getLeadAtom()) || atom2.distance((Point3f)atom) <= 4.2f;
    }

    Point3f getQuaternionFrameCenter(char c) {
        switch (c) {
            case 'C': 
            case 'b': 
            case 'c': 
            case 'x': {
                return this.getLeadAtom();
            }
        }
        return null;
    }

    public Object getHelixData(int n, char c, int n2) {
        return this.getHelixData2(n, c, n2);
    }

    public Quaternion getQuaternion(char c) {
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = null;
        switch (c) {
            default: {
                return null;
            }
            case 'b': 
            case 'c': 
            case 'x': 
        }
        if (this.monomerIndex == 0 || this.monomerIndex == this.bioPolymer.monomerCount - 1) {
            return null;
        }
        Atom atom = this.getLeadAtom();
        Point3f point3f = this.bioPolymer.getLeadPoint(this.monomerIndex + 1);
        Point3f point3f2 = this.bioPolymer.getLeadPoint(this.monomerIndex - 1);
        vector3f.sub((Tuple3f)point3f, (Tuple3f)atom);
        vector3f2.sub((Tuple3f)point3f2, (Tuple3f)atom);
        return Quaternion.getQuaternionFrame((Vector3f)vector3f, (Vector3f)vector3f2, vector3f3, (boolean)false);
    }
}

