/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.util.BitSet;
import java.util.Hashtable;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.jvxl.readers.SurfaceFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

abstract class VolumeFileReader
extends SurfaceFileReader {
    protected boolean endOfData;
    protected boolean negativeAtomCount;
    protected int atomCount;
    protected int nSurfaces;
    protected boolean isAngstroms;
    protected boolean canDownsample;
    private int[] downsampleRemainders;
    boolean readerClosed;
    Point4f thePlane;
    private int downsampleFactor;
    private int nSkipX;
    private int nSkipY;
    private int nSkipZ;
    private float[][] yzPlanes;
    private int yzCount;
    protected Point3f[] boundingBox;

    VolumeFileReader(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        super(surfaceGenerator, bufferedReader);
        this.isXLowToHigh = true;
        this.isProgressive = true;
        this.canDownsample = true;
        this.jvxlData.wasCubic = true;
        this.boundingBox = this.params.boundingBox;
    }

    protected float recordData(float f) {
        if (f < this.dataMin) {
            this.dataMin = f;
        }
        if (f > this.dataMax) {
            this.dataMax = f;
        }
        this.dataMean += f;
        return f;
    }

    protected void closeReader() {
        if (this.readerClosed) {
            return;
        }
        this.readerClosed = true;
        super.closeReader();
        int n = this.nPointsX * this.nPointsY * this.nPointsZ;
        if (n == 0 || this.dataMax == -3.4028235E38f) {
            return;
        }
        this.dataMean /= (float)n;
        Logger.info((String)("VolumeFileReader closing file: " + n + " points read \ndata min/max/mean = " + this.dataMin + ", " + this.dataMax + ", " + this.dataMean));
    }

    protected boolean readVolumeParameters() {
        this.endOfData = false;
        this.nSurfaces = this.readVolumetricHeader();
        if (this.nSurfaces == 0) {
            return false;
        }
        if (this.nSurfaces < this.params.fileIndex) {
            Logger.warn((String)("not enough surfaces in file -- resetting params.fileIndex to " + this.nSurfaces));
            this.params.fileIndex = this.nSurfaces;
        }
        return true;
    }

    protected boolean readVolumeData(boolean bl) {
        if (!this.gotoAndReadVoxelData(bl)) {
            return false;
        }
        if (!this.vertexDataOnly) {
            Logger.info((String)("JVXL read: " + this.nPointsX + " x " + this.nPointsY + " x " + this.nPointsZ + " data points"));
        }
        return true;
    }

    private int readVolumetricHeader() {
        try {
            int n;
            boolean bl;
            this.readParameters();
            if (this.atomCount == Integer.MIN_VALUE) {
                return 0;
            }
            if (this.isAnisotropic) {
                this.setVolumetricOriginAnisotropy();
            }
            Logger.info((String)("voxel grid origin:" + this.volumetricOrigin));
            int n2 = this.params.downsampleFactor;
            boolean bl2 = bl = this.canDownsample && n2 > 0;
            if (bl) {
                this.downsampleRemainders = new int[3];
                Logger.info((String)("downsample factor = " + n2));
                for (n = 0; n < 3; ++n) {
                    int n3 = this.voxelCounts[n];
                    this.downsampleRemainders[n] = n3 % n2;
                    int n4 = n;
                    this.voxelCounts[n4] = this.voxelCounts[n4] / n2;
                    this.volumetricVectors[n].scale((float)n2);
                    Logger.info((String)("downsampling axis " + (n + 1) + " from " + n3 + " to " + this.voxelCounts[n]));
                }
            }
            for (n = 0; n < 3; ++n) {
                this.line = this.voxelCounts[n] + " " + this.volumetricVectors[n].x + " " + this.volumetricVectors[n].y + " " + this.volumetricVectors[n].z;
                this.jvxlFileHeaderBuffer.append(this.line).append('\n');
                Logger.info((String)("voxel grid count/vector:" + this.line));
                if (this.isAngstroms) continue;
                this.volumetricVectors[n].scale(0.5291772f);
            }
            if (this.isAnisotropic) {
                this.setVolumetricAnisotropy();
            }
            this.volumeData.setVolumetricXml();
            return this.nSurfaces;
        }
        catch (Exception exception) {
            Logger.error((String)exception.toString());
            return 0;
        }
    }

    protected abstract void readParameters() throws Exception;

    protected String skipComments(boolean bl) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.readLine() != null && (bl && this.line.length() == 0 || this.line.indexOf("#") == 0)) {
            stringBuffer.append(this.line).append('\n');
        }
        return stringBuffer.toString();
    }

    protected void readVoxelVector(int n) throws Exception {
        this.readLine();
        Vector3f vector3f = this.volumetricVectors[n];
        this.voxelCounts[n] = this.parseInt(this.line);
        if (this.voxelCounts[n] == Integer.MIN_VALUE) {
            this.next[0] = this.line.indexOf(" ");
        }
        vector3f.set(this.parseFloat(), this.parseFloat(), this.parseFloat());
        if (this.isAnisotropic) {
            this.setVectorAnisotropy(vector3f);
        }
    }

    protected void readSurfaceData(boolean bl) throws Exception {
        this.next[0] = 0;
        this.downsampleFactor = this.params.downsampleFactor;
        this.nSkipX = 0;
        this.nSkipY = 0;
        this.nSkipZ = 0;
        if (this.canDownsample && this.downsampleFactor > 0) {
            this.nSkipX = this.downsampleFactor - 1;
            this.nSkipZ = this.nPointsZ * this.downsampleFactor + this.downsampleRemainders[2];
            this.nSkipY = this.downsampleRemainders[2] + (this.downsampleFactor - 1) * this.nSkipZ;
            this.nSkipZ = this.downsampleRemainders[1] * this.nSkipZ + (this.downsampleFactor - 1) * this.nSkipZ * (this.nPointsY * this.downsampleFactor + this.downsampleRemainders[1]);
        }
        if (this.params.thePlane != null) {
            this.params.cutoff = 0.0f;
        } else if (this.isJvxl) {
            this.params.cutoff = this.params.isBicolorMap || this.params.colorBySign ? 0.01f : 0.5f;
        }
        this.nDataPoints = 0;
        this.line = "";
        this.jvxlNSurfaceInts = 0;
        if (this.isProgressive && !bl || this.isJvxl) {
            this.nDataPoints = this.volumeData.setVoxelCounts(this.nPointsX, this.nPointsY, this.nPointsZ);
            this.voxelData = null;
            if (this.isJvxl) {
                this.jvxlVoxelBitSet = this.getVoxelBitSet(this.nDataPoints);
            }
        } else if (bl && this.mappingPlane != null) {
            this.volumeData.setVoxelMap(new Hashtable());
            float f = this.volumeData.getToPlaneParameter(this.mappingPlane);
            for (int i = 0; i < this.nPointsX; ++i) {
                for (int j = 0; j < this.nPointsY; ++j) {
                    for (int k = 0; k < this.nPointsZ; ++k) {
                        float f2 = this.recordData(this.getNextVoxelValue());
                        if (this.volumeData.isNearPlane(i, j, k, this.mappingPlane, f)) {
                            this.volumeData.setVoxelMapValue(i, j, k, f2);
                        }
                        if (this.nSkipX == 0) continue;
                        this.skipVoxels(this.nSkipX);
                    }
                    if (this.nSkipY == 0) continue;
                    this.skipVoxels(this.nSkipY);
                }
                if (this.nSkipZ == 0) continue;
                this.skipVoxels(this.nSkipZ);
            }
        } else {
            this.voxelData = new float[this.nPointsX][][];
            for (int i = 0; i < this.nPointsX; ++i) {
                float[][] fArrayArray = new float[this.nPointsY][];
                this.voxelData[i] = fArrayArray;
                for (int j = 0; j < this.nPointsY; ++j) {
                    float[] fArray = new float[this.nPointsZ];
                    fArrayArray[j] = fArray;
                    for (int k = 0; k < this.nPointsZ; ++k) {
                        fArray[k] = this.recordData(this.getNextVoxelValue());
                        if (this.nSkipX == 0) continue;
                        this.skipVoxels(this.nSkipX);
                    }
                    if (this.nSkipY == 0) continue;
                    this.skipVoxels(this.nSkipY);
                }
                if (this.nSkipZ == 0) continue;
                this.skipVoxels(this.nSkipZ);
            }
        }
        this.volumeData.setVoxelData(this.voxelData);
    }

    public void getPlane(int n) {
        if (this.yzCount == 0) {
            Logger.info((String)"VolumeFileReader reading data progressively");
            this.yzPlanes = new float[2][];
            this.yzCount = this.nPointsY * this.nPointsZ;
            this.yzPlanes[0] = new float[this.yzCount];
            this.yzPlanes[1] = new float[this.yzCount];
        }
        float[] fArray = this.yzPlanes[n % 2];
        try {
            int n2 = 0;
            for (int i = 0; i < this.nPointsY; ++i) {
                for (int j = 0; j < this.nPointsZ; ++j) {
                    fArray[n2++] = this.recordData(this.getNextVoxelValue());
                    if (this.nSkipX == 0) continue;
                    this.skipVoxels(this.nSkipX);
                }
                if (this.nSkipY == 0) continue;
                this.skipVoxels(this.nSkipY);
            }
            if (this.nSkipZ != 0) {
                this.skipVoxels(this.nSkipZ);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public float getValue(int n, int n2, int n3, int n4) {
        if (this.boundingBox != null) {
            this.volumeData.voxelPtToXYZ(n, n2, n3, this.ptTemp);
            if (this.ptTemp.x < this.boundingBox[0].x || this.ptTemp.x > this.boundingBox[1].x || this.ptTemp.y < this.boundingBox[0].y || this.ptTemp.y > this.boundingBox[1].y || this.ptTemp.z < this.boundingBox[0].z || this.ptTemp.z > this.boundingBox[1].z) {
                return Float.NaN;
            }
        }
        if (this.yzPlanes == null) {
            return super.getValue(n, n2, n3, n4);
        }
        return this.yzPlanes[n % 2][n4];
    }

    private void skipVoxels(int n) throws Exception {
        int n2 = n;
        while (--n2 >= 0) {
            this.getNextVoxelValue();
        }
    }

    protected BitSet getVoxelBitSet(int n) throws Exception {
        return null;
    }

    protected float getNextVoxelValue() throws Exception {
        float f = 0.0f;
        if (this.nSurfaces > 1 && !this.params.blockCubeData) {
            int n;
            for (n = 1; n < this.params.fileIndex; ++n) {
                this.nextVoxel();
            }
            f = this.nextVoxel();
            for (n = this.params.fileIndex; n < this.nSurfaces; ++n) {
                this.nextVoxel();
            }
        } else {
            f = this.nextVoxel();
        }
        return f;
    }

    protected float nextVoxel() throws Exception {
        float f = this.parseFloat();
        if (Float.isNaN(f)) {
            while (this.readLine() != null && Float.isNaN(f = this.parseFloat(this.line))) {
            }
            if (this.line == null) {
                if (!this.endOfData) {
                    Logger.warn((String)("end of file reading cube voxel data? nBytes=" + this.nBytes + " nDataPoints=" + this.nDataPoints + " (line):" + this.line));
                }
                this.endOfData = true;
                this.line = "0 0 0 0 0 0 0 0 0 0";
            }
        }
        return f;
    }

    protected void gotoData(int n, int n2) throws Exception {
        if (!this.params.blockCubeData) {
            return;
        }
        if (n > 0) {
            Logger.info((String)("skipping " + n + " data sets, " + n2 + " points each"));
        }
        for (int i = 0; i < n; ++i) {
            this.skipData(n2);
        }
    }

    protected void skipData(int n) throws Exception {
        for (int i = 0; i < n; i += this.countData(this.readLine())) {
        }
    }

    private int countData(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            char c;
            while (n2 < n3 && ((c = string.charAt(n2)) == ' ' || c == '\t')) {
                ++n2;
            }
            if (n2 < n3) {
                ++n;
            }
            while (n2 < n3 && (c = string.charAt(n2)) != ' ' && c != '\t') {
                ++n2;
            }
        }
        return n;
    }

    protected static boolean checkAtomLine(boolean bl, boolean bl2, String string, String string2, StringBuffer stringBuffer) {
        if (string2.indexOf("ANGSTROMS") >= 0) {
            bl2 = true;
        }
        int n = string == null ? Integer.MAX_VALUE : Parser.parseInt((String)string);
        switch (n) {
            case -2147483648: {
                n = 0;
                string2 = " " + string2.substring(string2.indexOf(" ") + 1);
                break;
            }
            case 0x7FFFFFFF: {
                n = Integer.MIN_VALUE;
                break;
            }
            default: {
                String string3 = "" + n;
                string2 = string2.substring(string2.indexOf(string3) + string3.length());
            }
        }
        if (bl2) {
            if (string2.indexOf("ANGSTROM") < 0) {
                string2 = string2 + " ANGSTROMS";
            }
        } else if (string2.indexOf("BOHR") < 0) {
            string2 = string2 + " BOHR";
        }
        string2 = (n == Integer.MIN_VALUE ? "" : (bl ? "+" : "-") + Math.abs(n)) + string2 + "\n";
        stringBuffer.append(string2);
        return bl2;
    }
}

