/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.simple;

import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Parser;

public class MopacReader
extends AtomSetCollectionReader {
    private int baseAtomIndex;
    private boolean chargesFound = false;
    private boolean haveHeader;

    protected boolean checkLine() throws Exception {
        if (!this.haveHeader) {
            if (this.line.trim().equals("CARTESIAN COORDINATES")) {
                this.processCoordinates();
                this.atomSetCollection.setAtomSetName("Input Structure");
                return true;
            }
            this.haveHeader = this.line.startsWith(" ---");
            return true;
        }
        if (this.line.indexOf("TOTAL ENERGY") >= 0) {
            this.processTotalEnergy();
            return true;
        }
        if (this.line.indexOf("ATOMIC CHARGES") >= 0) {
            this.processAtomicCharges();
            return true;
        }
        if (this.line.trim().equals("CARTESIAN COORDINATES")) {
            this.processCoordinates();
            return true;
        }
        if (this.line.indexOf("ORIENTATION OF MOLECULE IN FORCE") >= 0) {
            this.processCoordinates();
            this.atomSetCollection.setAtomSetName("Orientation in Force Field");
            return true;
        }
        if (this.line.indexOf("NORMAL COORDINATE ANALYSIS") >= 0) {
            this.readFrequencies();
            return true;
        }
        return true;
    }

    void processTotalEnergy() {
    }

    void processAtomicCharges() throws Exception {
        int n;
        this.discardLines(2);
        this.atomSetCollection.newAtomSet();
        this.baseAtomIndex = this.atomSetCollection.getAtomCount();
        int n2 = 0;
        while (this.readLine() != null && (n = this.parseInt(this.line)) != Integer.MIN_VALUE) {
            if (n != ++n2) {
                throw new Exception("unexpected atom number in atomic charges");
            }
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = this.parseToken();
            atom.partialCharge = this.parseFloat();
        }
        this.chargesFound = true;
    }

    void processCoordinates() throws Exception {
        int n;
        this.discardLines(3);
        int n2 = 0;
        if (!this.chargesFound) {
            this.atomSetCollection.newAtomSet();
            this.baseAtomIndex = this.atomSetCollection.getAtomCount();
        } else {
            this.chargesFound = false;
        }
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        while (this.readLine() != null && (n = this.parseInt(this.line)) != Integer.MIN_VALUE) {
            if (n != ++n2) {
                throw new Exception("unexpected atom number in coordinates");
            }
            String string = this.parseToken();
            Atom atom = atomArray[this.baseAtomIndex + n - 1];
            if (atom == null) {
                atom = this.atomSetCollection.addNewAtom();
            }
            atom.atomSerial = n;
            atom.x = this.parseFloat();
            atom.y = this.parseFloat();
            atom.z = this.parseFloat();
            int n3 = this.parseInt(string);
            if (n3 != Integer.MIN_VALUE) {
                string = MopacReader.getElementSymbol(n3);
            }
            atom.elementSymbol = string;
        }
    }

    private void readFrequencies() throws Exception {
        while (this.readLine() != null && this.line.indexOf("DESCRIPTION") < 0) {
            if (this.line.toUpperCase().indexOf("ROOT") < 0) continue;
            int n = this.getTokens().length - 2;
            this.discardLinesUntilNonBlank();
            String[] stringArray = this.getTokens();
            String[] stringArray2 = null;
            if (Float.isNaN(Parser.parseFloatStrict(stringArray[0]))) {
                stringArray2 = stringArray;
                this.discardLinesUntilNonBlank();
                stringArray = this.getTokens();
            }
            int n2 = this.atomSetCollection.getAtomCount();
            int n3 = this.atomSetCollection.getLastAtomSetAtomCount();
            boolean[] blArray = new boolean[n];
            for (int i = 0; i < n; ++i) {
                boolean bl = blArray[i] = !this.doGetVibration(++this.vibrationNumber);
                if (blArray[i]) continue;
                this.atomSetCollection.cloneLastAtomSet();
                this.atomSetCollection.setAtomSetFrequency(null, stringArray2 == null ? "" : " " + stringArray2[i], stringArray[i], null);
            }
            this.fillFrequencyData(n2, n3, n3, blArray, false, 0, 0, null);
        }
    }
}

