/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Vector;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;

public abstract class MOReader
extends BasisFunctionReader {
    protected int shellCount = 0;
    protected int gaussianCount = 0;
    protected float[][] gaussians;
    protected String energyUnits = "";
    protected Vector moTypes;
    private boolean getNBOs;
    private boolean getNBOCharges;
    protected boolean haveNboCharges;
    protected boolean haveNboOrbitals;
    protected boolean orbitalsRead;
    protected final int HEADER_GAMESS_UK_MO = 3;
    protected final int HEADER_GAMESS_OCCUPANCIES = 2;
    protected final int HEADER_GAMESS_ORIGINAL = 1;
    protected final int HEADER_NONE = 0;
    private boolean haveCoeffMap;
    private static final String P_LIST = "(PX)  (PY)  (PZ)";
    private static final String DS_LIST = "(D5)  (D2)  (D3)  (D4)  (D1)";
    private static final String DC_LIST = "(D1)  (D4)  (D6)  (D2)  (D3)  (D5)";
    private static final String FS_LIST = "(F1)  (F2)  (F3)  (F4)  (F5)  (F6)  (F7)";
    private static String FC_LIST = "(F1)  (F2)  (F10) (F4)  (F2)  (F3)  (F6)  (F9)  (F8)  F(5)";

    protected void initializeReader() throws Exception {
        this.line = "\nNBOs in the AO basis:";
        this.getNBOs = this.filterMO();
        this.line = "\nNBOCHARGES";
        boolean bl = this.getNBOCharges = this.filter != null && this.filterMO();
        if (this.filter == null) {
            return;
        }
        String string = TextFormat.simpleReplace((String)this.filter, (String)"NBOCHARGES", (String)"");
        if (string.length() < 3) {
            this.filter = null;
        }
    }

    protected boolean checkNboLine() throws Exception {
        if (this.getNBOs) {
            if (this.line.indexOf("(Occupancy)   Bond orbital/ Coefficients/ Hybrids") >= 0) {
                this.getNboTypes();
                return false;
            }
            if (this.line.indexOf("NBOs in the AO basis:") >= 0) {
                this.readMolecularOrbitals(0);
                return false;
            }
        }
        if (this.getNBOCharges && this.line.indexOf("Summary of Natural Population Analysis:") >= 0) {
            this.getNboCharges();
            return true;
        }
        return true;
    }

    private void getNboCharges() throws Exception {
        if (this.haveNboCharges) {
            return;
        }
        this.discardLinesUntilContains("----");
        this.discardLinesUntilContains("----");
        this.haveNboCharges = true;
        int n = this.atomSetCollection.getAtomCount();
        int n2 = this.atomSetCollection.getLastAtomSetAtomIndex();
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        for (int i = n2; i < n; ++i) {
            float f;
            while (atomArray[i].elementNumber == 0) {
                ++i;
            }
            String[] stringArray = MOReader.getTokens((String)this.readLine());
            if (stringArray == null || stringArray.length < 3 || Float.isNaN(f = this.parseFloat(stringArray[2]))) {
                Logger.info((String)("Error reading NBO charges: " + this.line));
                return;
            }
            atomArray[i].partialCharge = f;
            if (!Logger.debugging) continue;
            Logger.debug((String)("Atom " + i + " using NBOcharge: " + f));
        }
        Logger.info((String)("Using NBO charges for Model " + this.atomSetCollection.getAtomSetCount()));
    }

    protected void getNboTypes() throws Exception {
        this.moTypes = new Vector();
        this.readLine();
        this.readLine();
        int n = 0;
        int n2 = 0;
        while (this.line != null && (n2 = this.line.indexOf(".")) >= 0 && n2 < 10 && this.parseInt(this.line.substring(0, n2)) == n + 1) {
            this.moTypes.add(n++, this.line.substring(n2 + 1, Math.min(40, this.line.length())).trim());
            while (this.readLine() != null && this.line.startsWith("       ")) {
            }
        }
        Logger.info((String)(n + " natural bond AO basis functions found"));
    }

    protected void readMolecularOrbitals(int n) throws Exception {
        if (this.ignoreMOs) {
            this.readLine();
            return;
        }
        this.dfCoefMaps = null;
        if (this.haveNboOrbitals) {
            this.orbitals = new Vector();
            this.alphaBeta = "";
        }
        this.haveNboOrbitals = true;
        this.orbitalsRead = true;
        Hashtable[] hashtableArray = null;
        Vector[] vectorArray = null;
        String string = "";
        String string2 = "";
        String string3 = "";
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        this.readLine();
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        if (this.line.indexOf("---") >= 0) {
            this.readLine();
        }
        while (this.readLine() != null) {
            int n7;
            int n8;
            String string4;
            String[] stringArray = this.getTokens();
            if (Logger.debugging) {
                Logger.debug((String)(stringArray.length + " --- " + this.line));
            }
            if (this.line.indexOf("end") >= 0) break;
            if (this.line.indexOf(" ALPHA SET ") >= 0) {
                this.alphaBeta = "alpha";
                if (this.readLine() == null) {
                    break;
                }
            } else if (this.line.indexOf(" BETA SET ") >= 0) {
                if (bl) break;
                this.alphaBeta = "beta";
                if (this.readLine() == null) break;
            }
            if ((string4 = this.line.toUpperCase()).length() == 0 || string4.indexOf("--") >= 0 || string4.indexOf(".....") >= 0 || string4.indexOf("NBO BASIS") >= 0 || string4.indexOf("CI EIGENVECTORS WILL BE LABELED") >= 0 || string4.indexOf("LZ VALUE") >= 0 || string4.indexOf("   THIS LOCALIZATION HAD") >= 0) {
                if (!this.haveCoeffMap) {
                    this.haveCoeffMap = true;
                    n8 = 1;
                    if (string3.length() > 0) {
                        n8 = this.getDFMap(string3, 1, P_LIST, 4);
                    }
                    if (string.length() > 0) {
                        n8 = string.indexOf("X") >= 0 ? (int)(this.getDFMap(string, 4, CANONICAL_DC_LIST, 2) ? 1 : 0) : (string.indexOf("(D6)") >= 0 ? (int)(this.getDFMap(string, 4, DC_LIST, 4) ? 1 : 0) : (int)(this.getDFMap(string, 3, DS_LIST, 4) ? 1 : 0));
                    }
                    if (string2.length() > 0) {
                        n8 = string2.indexOf("X") >= 0 ? (int)(this.getDFMap(string2, 6, CANONICAL_FC_LIST, 2) ? 1 : 0) : (string2.indexOf("(F10)") >= 0 ? (int)(this.getDFMap(string2, 6, FC_LIST, 5) ? 1 : 0) : (int)(this.getDFMap(string2, 5, FS_LIST, 4) ? 1 : 0));
                    }
                    if (n8 == 0) {
                        // empty if block
                    }
                }
                n6 = string4.length() == 0 ? ++n6 : 0;
                if (n6 == 2) break;
                if (string4.indexOf("LZ VALUE") >= 0) {
                    this.discardLinesUntilBlank();
                }
                for (n8 = 0; n8 < n4; ++n8) {
                    float[] fArray = new float[vectorArray[n8].size()];
                    for (int i = 0; i < fArray.length; ++i) {
                        fArray[i] = this.parseFloat((String)vectorArray[n8].get(i));
                    }
                    bl = true;
                    hashtableArray[n8].put("coefficients", fArray);
                    n5 = this.setMOType(hashtableArray[n8], n5);
                    this.setMO(hashtableArray[n8]);
                }
                n4 = 0;
                if (this.line.length() != 0) break;
                continue;
            }
            n6 = 0;
            if (n4 == 0) {
                n4 = stringArray.length;
                if (stringArray[0].equals("AO")) {
                    --n4;
                    n2 = 16;
                    n3 = 8;
                }
                if (hashtableArray == null || n4 > hashtableArray.length) {
                    hashtableArray = new Hashtable[n4];
                    vectorArray = new Vector[n4];
                }
                for (n8 = 0; n8 < n4; ++n8) {
                    hashtableArray[n8] = new Hashtable();
                    vectorArray[n8] = new Vector();
                }
                this.getMOHeader(n, stringArray, hashtableArray, n4);
                continue;
            }
            int n9 = stringArray.length - n4;
            String string5 = stringArray[n9 - 1];
            if (string5.charAt(0) == '(') {
                n8 = string5.charAt(1);
                if (!this.haveCoeffMap) {
                    switch (n8) {
                        case 112: {
                            string3 = string3 + " " + string5.toUpperCase();
                            break;
                        }
                        case 100: {
                            string = string + " " + MOReader.canonicalizeQuantumSubshellTag(string5.toUpperCase());
                            break;
                        }
                        case 102: {
                            string2 = string2 + " " + MOReader.canonicalizeQuantumSubshellTag(string5.toUpperCase());
                            break;
                        }
                    }
                }
            } else {
                n7 = string5.length();
                int n10 = n7 < 4 ? 83 : (n7 == 4 ? 71 : (n8 = n7 == 5 ? 72 : 63));
                if (!this.haveCoeffMap && n7 == 3) {
                    string2 = string2 + " " + MOReader.canonicalizeQuantumSubshellTag(string5.toUpperCase());
                } else if (!this.haveCoeffMap && n7 == 2) {
                    string = string + " " + MOReader.canonicalizeQuantumSubshellTag(string5.toUpperCase());
                }
            }
            if (this.isQuantumBasisSupported((char)n8)) {
                if (n2 < 0) {
                    for (n7 = 0; n7 < n4; ++n7) {
                        vectorArray[n7].addElement(stringArray[n7 + n9]);
                    }
                } else {
                    n7 = n2;
                    int n11 = 0;
                    while (n11 < n4) {
                        vectorArray[n11].addElement(this.line.substring(n7, n7 + n3).trim());
                        ++n11;
                        n7 += n3;
                    }
                }
            }
            this.line = "";
        }
        this.energyUnits = "a.u.";
        this.setMOData(!this.alphaBeta.equals("alpha"));
        this.haveCoeffMap = false;
        this.dfCoefMaps = null;
    }

    protected int setMOType(Hashtable hashtable, int n) {
        if (this.moTypes != null) {
            String string = (String)this.moTypes.get(n % this.moTypes.size());
            ++n;
            hashtable.put("type", string);
            hashtable.put("occupancy", new Float(string.indexOf("*") >= 0 ? 0.0f : 2.0f));
        } else if (this.alphaBeta.length() > 0) {
            hashtable.put("type", this.alphaBeta);
        }
        return n;
    }

    protected void getMOHeader(int n, String[] stringArray, Hashtable[] hashtableArray, int n2) throws Exception {
        int n3;
        this.readLine();
        switch (n) {
            default: {
                for (int i = 0; i < n2; ++i) {
                    hashtableArray[i].put("energy", "");
                }
                return;
            }
            case 3: {
                for (int i = 0; i < n2; ++i) {
                    hashtableArray[i].put("energy", new Float(stringArray[i]));
                }
                this.discardLines(5);
                return;
            }
            case 1: {
                stringArray = this.getTokens();
                if (stringArray.length == 0) {
                    stringArray = MOReader.getTokens((String)this.readLine());
                }
                for (n3 = 0; n3 < n2; ++n3) {
                    hashtableArray[n3].put("energy", new Float(stringArray[n3]));
                }
                this.readLine();
                break;
            }
            case 2: {
                n3 = this.line.length() > 0 || this.readLine() != null ? 1 : 0;
                stringArray = this.getTokens();
                for (int i = 0; i < n2; ++i) {
                    hashtableArray[i].put("occupancy", new Float(stringArray[i].charAt(0) == '-' ? 2.0f : this.parseFloat(stringArray[i])));
                }
                this.readLine();
                if (n3 != 0) break;
                return;
            }
        }
        if (this.line.length() > 0) {
            stringArray = this.getTokens();
            for (n3 = 0; n3 < n2; ++n3) {
                hashtableArray[n3].put("symmetry", stringArray[n3]);
            }
        }
    }

    protected void addMOData(int n, Vector[] vectorArray, Hashtable[] hashtableArray) {
        for (int i = 0; i < n; ++i) {
            float[] fArray = new float[vectorArray[i].size()];
            int n2 = fArray.length;
            while (--n2 >= 0) {
                fArray[n2] = this.parseFloat((String)vectorArray[i].get(n2));
            }
            hashtableArray[i].put("coefficients", fArray);
            this.setMO(hashtableArray[i]);
        }
    }

    protected void setMOData(boolean bl) {
        if (this.shells != null && this.gaussians != null) {
            this.moData.put("calculationType", this.calculationType);
            this.moData.put("energyUnits", this.energyUnits);
            this.moData.put("shells", this.shells);
            this.moData.put("gaussians", this.gaussians);
            this.moData.put("mos", this.orbitals);
            this.setMOData(this.moData);
        }
        if (bl) {
            this.orbitals = new Vector();
            this.moData = new Hashtable();
            this.alphaBeta = "";
        }
    }
}

