/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.BitSet;
import java.util.List;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.modelset.Atom;
import org.jmol.modelset.HBond;
import org.jmol.modelset.Polymer;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.util.Measure;
import org.jmol.util.OutputStringBuffer;
import org.jmol.viewer.Viewer;

public class NucleicPolymer
extends BioPolymer {
    NucleicPolymer(Monomer[] monomerArray) {
        super(monomerArray);
        this.type = 2;
        this.hasWingPoints = true;
    }

    Atom getNucleicPhosphorusAtom(int n) {
        return this.monomers[n].getLeadAtom();
    }

    protected boolean calcEtaThetaAngles() {
        float f = Float.NaN;
        for (int i = 0; i < this.monomerCount - 2; ++i) {
            NucleicMonomer nucleicMonomer = (NucleicMonomer)this.monomers[i];
            NucleicMonomer nucleicMonomer2 = (NucleicMonomer)this.monomers[i + 1];
            Atom atom = nucleicMonomer.getP();
            Atom atom2 = nucleicMonomer.getC4P();
            Atom atom3 = nucleicMonomer2.getP();
            Atom atom4 = nucleicMonomer2.getC4P();
            if (i > 0) {
                NucleicMonomer nucleicMonomer3 = (NucleicMonomer)this.monomers[i - 1];
                Atom atom5 = nucleicMonomer3.getC4P();
                f = Measure.computeTorsion((Tuple3f)atom5, (Tuple3f)atom, (Tuple3f)atom2, (Tuple3f)atom3, (boolean)true);
            }
            float f2 = Measure.computeTorsion((Tuple3f)atom, (Tuple3f)atom2, (Tuple3f)atom3, (Tuple3f)atom4, (boolean)true);
            if (f < 0.0f) {
                f += 360.0f;
            }
            if (f2 < 0.0f) {
                f2 += 360.0f;
            }
            nucleicMonomer.setGroupParameter(1112539140, f);
            nucleicMonomer.setGroupParameter(1112539146, f2);
        }
        return true;
    }

    public void calcRasmolHydrogenBonds(Polymer polymer, BitSet bitSet, BitSet bitSet2, List list, int n, int[][][] nArray, boolean bl, boolean bl2) {
        NucleicPolymer nucleicPolymer = (NucleicPolymer)polymer;
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        int n2 = this.monomerCount;
        while (--n2 >= 0) {
            NucleicMonomer nucleicMonomer = (NucleicMonomer)this.monomers[n2];
            if (!nucleicMonomer.isPurine()) continue;
            Atom atom = nucleicMonomer.getN3();
            boolean bl3 = bitSet.get(atom.index);
            if (!bl3 && !bitSet2.get(atom.index)) continue;
            Atom atom2 = nucleicMonomer.getN1();
            Atom atom3 = nucleicMonomer.getN0();
            Point4f point4f = Measure.getPlaneThroughPoints((Point3f)atom, (Point3f)atom2, (Point3f)atom3, (Vector3f)vector3f, (Vector3f)vector3f2, (Vector3f)vector3f3);
            Atom atom4 = null;
            float f = 25.0f;
            NucleicMonomer nucleicMonomer2 = null;
            int n3 = nucleicPolymer.monomerCount;
            while (--n3 >= 0) {
                NucleicMonomer nucleicMonomer3 = (NucleicMonomer)nucleicPolymer.monomers[n3];
                if (!nucleicMonomer3.isPyrimidine()) continue;
                Atom atom5 = nucleicMonomer3.getN3();
                if (bl3 ? !bitSet2.get(atom5.index) : !bitSet.get(atom5.index)) continue;
                Atom atom6 = nucleicMonomer3.getN0();
                float f2 = atom2.distanceSquared((Point3f)atom5);
                if (!(f2 < f) || !(atom3.distanceSquared((Point3f)atom6) > 50.0f) || !(Math.abs(Measure.distanceToPlane((Point4f)point4f, (Point3f)atom5)) < 1.0f)) continue;
                nucleicMonomer2 = nucleicMonomer3;
                atom4 = atom5;
                f = f2;
            }
            n3 = 0;
            if (atom4 == null || (n3 += NucleicPolymer.addHydrogenBond(list, atom2, atom4)) >= n) continue;
            if (nucleicMonomer.isGuanine()) {
                if ((n3 += NucleicPolymer.addHydrogenBond(list, nucleicMonomer.getN2(), nucleicMonomer2.getO2())) >= n || (n3 += NucleicPolymer.addHydrogenBond(list, nucleicMonomer.getO6(), nucleicMonomer2.getN4())) < n) continue;
                continue;
            }
            n3 += NucleicPolymer.addHydrogenBond(list, nucleicMonomer.getN6(), nucleicMonomer2.getO4());
        }
    }

    protected static int addHydrogenBond(List list, Atom atom, Atom atom2) {
        if (atom == null || atom2 == null) {
            return 0;
        }
        list.add(new HBond(atom, atom2, 18432, 0.0f));
        return 1;
    }

    public void getPdbData(Viewer viewer, char c, char c2, int n, int n2, boolean bl, BitSet bitSet, OutputStringBuffer outputStringBuffer, StringBuffer stringBuffer, BitSet bitSet2, boolean bl2, boolean bl3, BitSet bitSet3) {
        NucleicPolymer.getPdbData(viewer, this, c, c2, n, n2, bl, bitSet, outputStringBuffer, stringBuffer, bitSet2, bl2, bl3, bitSet3);
    }
}

