/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolEdge;
import org.jmol.api.JmolNode;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.RadiusData;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.ModelSet;
import org.jmol.util.Elements;
import org.jmol.util.Point3fi;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

public final class Atom
extends Point3fi
implements JmolNode {
    private static final byte VIBRATION_VECTOR_FLAG = 1;
    private static final byte IS_HETERO_FLAG = 2;
    private static final byte FLAG_MASK = 3;
    public static final int RADIUS_MAX = 16;
    Group group;
    private BitSet atomSymmetry;
    int atomSite;
    private float userDefinedVanDerWaalRadius;
    private short atomicAndIsotopeNumber;
    private byte formalChargeAndFlags;
    private byte valence;
    char alternateLocationID;
    public byte atomID;
    public short madAtom;
    short colixAtom;
    byte paletteID = 1;
    Bond[] bonds;
    int nBondsDisplayed = 0;
    int nBackbonesDisplayed = 0;
    int clickabilityFlags;
    int shapeVisibilityFlags;

    public byte getAtomID() {
        return this.atomID;
    }

    public Bond[] getBonds() {
        return this.bonds;
    }

    public void setBonds(Bond[] bondArray) {
        this.bonds = bondArray;
    }

    public int getNBackbonesDisplayed() {
        return this.nBackbonesDisplayed;
    }

    public Atom(int n, int n2, float f, float f2, float f3, float f4, BitSet bitSet, int n3, short s, int n4, boolean bl, char c) {
        this.modelIndex = (short)n;
        this.atomSymmetry = bitSet;
        this.atomSite = n3;
        this.index = n2;
        this.atomicAndIsotopeNumber = s;
        if (bl) {
            this.formalChargeAndFlags = (byte)2;
        }
        this.setFormalCharge(n4);
        this.alternateLocationID = c;
        this.userDefinedVanDerWaalRadius = f4;
        this.set(f, f2, f3);
    }

    public final void setShapeVisibilityFlags(int n) {
        this.shapeVisibilityFlags = n;
    }

    public final void setShapeVisibility(int n, boolean bl) {
        this.shapeVisibilityFlags = bl ? (this.shapeVisibilityFlags |= n) : (this.shapeVisibilityFlags &= ~n);
    }

    public boolean isBonded(Atom atom) {
        if (this.bonds != null) {
            int n = this.bonds.length;
            while (--n >= 0) {
                if (this.bonds[n].getOtherAtom(this) != atom) continue;
                return true;
            }
        }
        return false;
    }

    public Bond getBond(Atom atom) {
        if (this.bonds != null) {
            int n = this.bonds.length;
            while (--n >= 0) {
                if (this.bonds[n].getOtherAtom(atom) == null) continue;
                return this.bonds[n];
            }
        }
        return null;
    }

    void addDisplayedBond(int n, boolean bl) {
        this.nBondsDisplayed += bl ? 1 : -1;
        this.setShapeVisibility(n, bl);
    }

    public void addDisplayedBackbone(int n, boolean bl) {
        this.nBackbonesDisplayed += bl ? 1 : -1;
        this.setShapeVisibility(n, bl);
    }

    void deleteBond(Bond bond) {
        if (this.bonds != null) {
            int n = this.bonds.length;
            while (--n >= 0) {
                if (this.bonds[n] != bond) continue;
                this.deleteBond(n);
                return;
            }
        }
    }

    private void deleteBond(int n) {
        int n2;
        int n3 = this.bonds.length - 1;
        if (n3 == 0) {
            this.bonds = null;
            return;
        }
        Bond[] bondArray = new Bond[n3];
        for (n2 = 0; n2 < n; ++n2) {
            bondArray[n2] = this.bonds[n2];
        }
        while (n2 < n3) {
            bondArray[n2] = this.bonds[n2 + 1];
            ++n2;
        }
        this.bonds = bondArray;
    }

    void clearBonds() {
        this.bonds = null;
    }

    public int getBondedAtomIndex(int n) {
        return this.bonds[n].getOtherAtom((Atom)this).index;
    }

    public void setMadAtom(Viewer viewer, RadiusData radiusData) {
        this.madAtom = this.calculateMad(viewer, radiusData);
    }

    public short calculateMad(Viewer viewer, RadiusData radiusData) {
        if (radiusData == null) {
            return 0;
        }
        float f = radiusData.value;
        if (f == 0.0f) {
            return 0;
        }
        switch (radiusData.type) {
            case 3: {
                return (short)f;
            }
            case 1: 
            case 2: {
                float f2 = 0.0f;
                switch (radiusData.vdwType) {
                    case 1112541198: {
                        float f3 = viewer.getBfactor100Hi();
                        f2 = f3 > 0.0f ? (float)this.getBfactor100() / f3 : 0.0f;
                        break;
                    }
                    case 1112541194: {
                        f2 = this.getBondingRadiusFloat();
                        break;
                    }
                    case 1112539137: 
                    case 1112539138: {
                        f2 = this.getADPMinMax(radiusData.vdwType == 1112539137);
                        break;
                    }
                    default: {
                        f2 = this.getVanderwaalsRadiusFloat(viewer, radiusData.vdwType);
                    }
                }
                if (radiusData.type == 2) {
                    f *= f2;
                    break;
                }
                f += f2;
                break;
            }
        }
        short s = (short)(f < 0.0f ? f : f * 2000.0f);
        if (s < 0 && f > 0.0f) {
            s = 0;
        }
        return s;
    }

    public float getADPMinMax(boolean bl) {
        Object[] objectArray = this.getEllipsoid();
        if (objectArray == null) {
            return 0.0f;
        }
        return ((float[])objectArray[1])[bl ? 5 : 3];
    }

    public int getRasMolRadius() {
        return Math.abs(this.madAtom / 8);
    }

    public int getCovalentBondCount() {
        if (this.bonds == null) {
            return 0;
        }
        int n = 0;
        int n2 = this.bonds.length;
        while (--n2 >= 0) {
            Bond bond = this.bonds[n2];
            if ((bond.order & 0x3FF) == 0 || bond.getOtherAtom(this).isDeleted()) continue;
            ++n;
        }
        return n;
    }

    public int getCovalentHydrogenCount() {
        if (this.bonds == null) {
            return 0;
        }
        int n = 0;
        int n2 = this.bonds.length;
        while (--n2 >= 0) {
            if ((this.bonds[n2].order & 0x3FF) == 0) continue;
            Atom atom = this.bonds[n2].getOtherAtom(this);
            if (atom.valence < 0 || atom.getElementNumber() != 1) continue;
            ++n;
        }
        return n;
    }

    public JmolEdge[] getEdges() {
        return this.bonds;
    }

    public void setColixAtom(short s) {
        this.colixAtom = s;
    }

    public void setPaletteID(byte by) {
        this.paletteID = by;
    }

    public void setTranslucent(boolean bl, float f) {
        this.colixAtom = Graphics3D.getColixTranslucent(this.colixAtom, bl, f);
    }

    public boolean isTranslucent() {
        return Graphics3D.isColixTranslucent(this.colixAtom);
    }

    public short getElementNumber() {
        return (short)(this.atomicAndIsotopeNumber % 128);
    }

    public short getIsotopeNumber() {
        return (short)(this.atomicAndIsotopeNumber >> 7);
    }

    public short getAtomicAndIsotopeNumber() {
        return this.atomicAndIsotopeNumber;
    }

    public void setAtomicAndIsotopeNumber(int n) {
        if (n < 0 || n % 128 >= Elements.elementNumberMax || n > Short.MAX_VALUE) {
            n = 0;
        }
        this.atomicAndIsotopeNumber = (short)n;
    }

    public String getElementSymbol(boolean bl) {
        return Elements.elementSymbolFromNumber(bl ? this.atomicAndIsotopeNumber : this.atomicAndIsotopeNumber % 128);
    }

    public String getElementSymbol() {
        return this.getElementSymbol(true);
    }

    public char getAlternateLocationID() {
        return this.alternateLocationID;
    }

    boolean isAlternateLocationMatch(String string) {
        if (string == null) {
            return this.alternateLocationID == '\u0000';
        }
        if (string.length() != 1) {
            return false;
        }
        char c = string.charAt(0);
        return c == '*' || c == '?' && this.alternateLocationID != '\u0000' || this.alternateLocationID == c;
    }

    public boolean isHetero() {
        return (this.formalChargeAndFlags & 2) != 0;
    }

    public boolean hasVibration() {
        return (this.formalChargeAndFlags & 1) != 0;
    }

    void setFormalCharge(int n) {
        this.formalChargeAndFlags = (byte)(this.formalChargeAndFlags & 3 | (n == Integer.MIN_VALUE ? 0 : (n > 7 ? 7 : (n < -3 ? -3 : n))) << 2);
    }

    void setVibrationVector() {
        this.formalChargeAndFlags = (byte)(this.formalChargeAndFlags | 1);
    }

    public int getFormalCharge() {
        return this.formalChargeAndFlags >> 2;
    }

    public int getOccupancy100() {
        byte[] byArray = this.group.chain.modelSet.occupancies;
        return byArray == null ? 100 : byArray[this.index];
    }

    public int getBfactor100() {
        short[] sArray = this.group.chain.modelSet.bfactor100s;
        if (sArray == null) {
            return 0;
        }
        return sArray[this.index];
    }

    public boolean setRadius(float f) {
        this.userDefinedVanDerWaalRadius = f > 0.0f ? f : Float.NaN;
        return !Float.isNaN(this.userDefinedVanDerWaalRadius);
    }

    public void delete(BitSet bitSet) {
        this.valence = (byte)-1;
        if (this.bonds != null) {
            int n = this.bonds.length;
            while (--n >= 0) {
                Bond bond = this.bonds[n];
                bond.getOtherAtom(this).deleteBond(bond);
                bitSet.set(bond.index);
            }
        }
        this.bonds = null;
    }

    public boolean isDeleted() {
        return this.valence < 0;
    }

    public void setValence(int n) {
        if (this.isDeleted()) {
            return;
        }
        this.valence = (byte)(n < 0 ? 0 : (n < 239 ? n : 239));
    }

    public int getValence() {
        if (this.isDeleted()) {
            return -1;
        }
        int n = this.valence;
        if (n == 0 && this.bonds != null) {
            int n2 = this.bonds.length;
            while (--n2 >= 0) {
                n += this.bonds[n2].getValence();
            }
        }
        return n;
    }

    public int getImplicitHydrogenCount() {
        int n;
        int n2 = this.getTargetValence();
        int n3 = this.getFormalCharge();
        if (n3 != 0) {
            n2 += n2 == 4 ? -Math.abs(n3) : n3;
        }
        return (n = n2 - this.getValence()) < 0 ? 0 : n;
    }

    int getTargetValence() {
        switch (this.getElementNumber()) {
            case 6: 
            case 14: {
                return 4;
            }
            case 5: 
            case 7: 
            case 15: {
                return 3;
            }
            case 8: 
            case 16: {
                return 2;
            }
            case 9: 
            case 17: 
            case 35: 
            case 53: {
                return 1;
            }
        }
        return -1;
    }

    public float getDimensionValue(int n) {
        return n == 0 ? this.x : (n == 1 ? this.y : this.z);
    }

    public float getVanderwaalsRadiusFloat(Viewer viewer, int n) {
        return Float.isNaN(this.userDefinedVanDerWaalRadius) ? (float)viewer.getVanderwaalsMar(this.atomicAndIsotopeNumber % 128, this.getVdwType(n)) / 1000.0f : this.userDefinedVanDerWaalRadius;
    }

    private int getVdwType(int n) {
        switch (n) {
            case 8: {
                n = this.group.chain.modelSet.getDefaultVdwType(this.modelIndex);
                break;
            }
            case 7: {
                n = this.group.chain.modelSet.getDefaultVdwType(this.modelIndex);
                if (n != 4) break;
                n = 5;
            }
        }
        return n;
    }

    public float getCovalentRadiusFloat() {
        return JmolConstants.getBondingRadiusFloat(this.atomicAndIsotopeNumber % 128, 0);
    }

    public float getBondingRadiusFloat() {
        float[] fArray = this.group.chain.modelSet.ionicRadii;
        float f = fArray == null ? 0.0f : fArray[this.index];
        return f == 0.0f ? JmolConstants.getBondingRadiusFloat(this.atomicAndIsotopeNumber % 128, this.getFormalCharge()) : f;
    }

    float getVolume(Viewer viewer, int n) {
        float f;
        float f2 = f = n < 0 ? this.userDefinedVanDerWaalRadius : Float.NaN;
        if (Float.isNaN(f)) {
            f = (float)viewer.getVanderwaalsMar(this.getElementNumber(), this.getVdwType(n)) / 1000.0f;
        }
        double d = 0.0;
        if (this.bonds != null) {
            for (int i = 0; i < this.bonds.length; ++i) {
                float f3;
                float f4;
                if (!this.bonds[i].isCovalent()) continue;
                Atom atom = this.bonds[i].getOtherAtom(this);
                float f5 = f4 = n < 0 ? atom.userDefinedVanDerWaalRadius : Float.NaN;
                if (Float.isNaN(f4)) {
                    f4 = (float)viewer.getVanderwaalsMar(atom.getElementNumber(), atom.getVdwType(n)) / 1000.0f;
                }
                if ((f3 = this.distance(atom)) > f + f4) continue;
                if (f3 + f <= f4) {
                    return 0.0f;
                }
                double d2 = (double)f - (double)(f * f + f3 * f3 - f4 * f4) / (2.0 * (double)f3);
                d -= 1.0471975511965976 * d2 * d2 * ((double)(3.0f * f) - d2);
            }
        }
        return (float)(d + 4.1887902047863905 * (double)f * (double)f * (double)f);
    }

    int getCurrentBondCount() {
        return this.bonds == null ? 0 : this.bonds.length;
    }

    public short getColix() {
        return this.colixAtom;
    }

    public byte getPaletteID() {
        return this.paletteID;
    }

    public float getRadius() {
        return Math.abs((float)this.madAtom / 2000.0f);
    }

    public int getIndex() {
        return this.index;
    }

    public int getAtomSite() {
        return this.atomSite;
    }

    public BitSet getAtomSymmetry() {
        return this.atomSymmetry;
    }

    void setGroup(Group group) {
        this.group = group;
    }

    public Group getGroup() {
        return this.group;
    }

    public void setGroupBits(BitSet bitSet) {
        this.group.selectAtoms(bitSet);
    }

    public String getAtomName() {
        return this.atomID > 0 ? JmolConstants.getSpecialAtomName(this.atomID) : this.group.chain.modelSet.atomNames[this.index];
    }

    public String getAtomType() {
        String[] stringArray = this.group.chain.modelSet.atomTypes;
        String string = stringArray == null ? null : stringArray[this.index];
        return string == null ? this.getAtomName() : string;
    }

    public int getAtomNumber() {
        int[] nArray = this.group.chain.modelSet.atomSerials;
        return nArray != null ? nArray[this.index] : this.index;
    }

    public boolean isInFrame() {
        return (this.shapeVisibilityFlags & 1) != 0;
    }

    public int getShapeVisibilityFlags() {
        return this.shapeVisibilityFlags;
    }

    public boolean isShapeVisible(int n) {
        return (this.shapeVisibilityFlags & n) != 0;
    }

    public float getPartialCharge() {
        float[] fArray = this.group.chain.modelSet.partialCharges;
        return fArray == null ? 0.0f : fArray[this.index];
    }

    public Object[] getEllipsoid() {
        return this.group.chain.modelSet.getEllipsoid(this.index);
    }

    public int getSymmetryTranslation(int n, int[] nArray, int n2) {
        int n3 = n;
        for (int i = 0; i < nArray.length; ++i) {
            if (!this.atomSymmetry.get(n3 += n2)) continue;
            return nArray[i];
        }
        return 0;
    }

    public int getCellTranslation(int n, int[] nArray, int n2) {
        int n3 = n2;
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = 0;
            while (n4 < n2) {
                if (this.atomSymmetry.get(n3) && nArray[i] == n) {
                    return nArray[i];
                }
                ++n4;
                ++n3;
            }
        }
        return 0;
    }

    String getSymmetryOperatorList() {
        String string = "";
        ModelSet modelSet = this.group.chain.modelSet;
        int n = modelSet.getModelSymmetryCount(this.modelIndex);
        if (n == 0 || this.atomSymmetry == null) {
            return "";
        }
        int[] nArray = modelSet.getModelCellRange(this.modelIndex);
        int n2 = n;
        int n3 = nArray == null ? 1 : nArray.length;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!this.atomSymmetry.get(n2++)) continue;
                string = string + "," + (j + 1) + "" + nArray[i];
            }
        }
        return string.substring(1);
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    public int getMoleculeNumber() {
        return this.group.chain.modelSet.getMoleculeIndex(this.index) + 1;
    }

    private float getFractionalCoord(char c, boolean bl) {
        Point3f point3f = this.getFractionalCoord(bl);
        return c == 'X' ? point3f.x : (c == 'Y' ? point3f.y : point3f.z);
    }

    private float getFractionalUnitCoord(char c) {
        Point3f point3f = this.getFractionalUnitCoord(false);
        return c == 'X' ? point3f.x : (c == 'Y' ? point3f.y : point3f.z);
    }

    private Point3f getFractionalCoord(boolean bl) {
        SymmetryInterface[] symmetryInterfaceArray = this.group.chain.modelSet.unitCells;
        Point3f point3f = new Point3f(this);
        if (symmetryInterfaceArray != null && symmetryInterfaceArray[this.modelIndex].haveUnitCell()) {
            symmetryInterfaceArray[this.modelIndex].toFractional(point3f, bl);
        }
        return point3f;
    }

    public Point3f getFractionalUnitCoord(boolean bl) {
        SymmetryInterface[] symmetryInterfaceArray = this.group.chain.modelSet.unitCells;
        Point3f point3f = new Point3f(this);
        if (symmetryInterfaceArray != null && symmetryInterfaceArray[this.modelIndex].haveUnitCell()) {
            if (this.group.chain.model.isJmolDataFrame) {
                symmetryInterfaceArray[this.modelIndex].toFractional(point3f, false);
                if (bl) {
                    symmetryInterfaceArray[this.modelIndex].toCartesian(point3f, false);
                }
            } else {
                symmetryInterfaceArray[this.modelIndex].toUnitCell(point3f, null);
                if (!bl) {
                    symmetryInterfaceArray[this.modelIndex].toFractional(point3f, false);
                }
            }
        }
        return point3f;
    }

    public float getFractionalUnitDistance(Point3f point3f, Point3f point3f2, Point3f point3f3) {
        SymmetryInterface[] symmetryInterfaceArray = this.group.chain.modelSet.unitCells;
        if (symmetryInterfaceArray == null) {
            return this.distance(point3f);
        }
        point3f2.set(this);
        point3f3.set(point3f);
        if (this.group.chain.model.isJmolDataFrame) {
            symmetryInterfaceArray[this.modelIndex].toFractional(point3f2, true);
            symmetryInterfaceArray[this.modelIndex].toFractional(point3f3, true);
        } else {
            symmetryInterfaceArray[this.modelIndex].toUnitCell(point3f2, null);
            symmetryInterfaceArray[this.modelIndex].toUnitCell(point3f3, null);
        }
        return point3f2.distance(point3f3);
    }

    void setFractionalCoord(int n, float f, boolean bl) {
        SymmetryInterface[] symmetryInterfaceArray = this.group.chain.modelSet.unitCells;
        if (symmetryInterfaceArray != null && symmetryInterfaceArray[this.modelIndex].haveUnitCell()) {
            symmetryInterfaceArray[this.modelIndex].toFractional(this, bl);
        }
        switch (n) {
            case 1112541188: 
            case 1112541191: {
                this.x = f;
                break;
            }
            case 1112541189: 
            case 1112541192: {
                this.y = f;
                break;
            }
            case 1112541190: 
            case 1112541193: {
                this.z = f;
            }
        }
        if (symmetryInterfaceArray != null && symmetryInterfaceArray[this.modelIndex].haveUnitCell()) {
            symmetryInterfaceArray[this.modelIndex].toCartesian(this, bl);
        }
    }

    void setFractionalCoord(Point3f point3f, boolean bl) {
        this.setFractionalCoord(this, point3f, bl);
    }

    void setFractionalCoord(Point3f point3f, Point3f point3f2, boolean bl) {
        point3f.set(point3f2);
        SymmetryInterface[] symmetryInterfaceArray = this.group.chain.modelSet.unitCells;
        if (symmetryInterfaceArray != null && symmetryInterfaceArray[this.modelIndex].haveUnitCell()) {
            symmetryInterfaceArray[this.modelIndex].toCartesian(point3f, bl && !this.group.chain.model.isJmolDataFrame);
        }
    }

    boolean isCursorOnTopOf(int n, int n2, int n3, Atom atom) {
        int n4;
        int n5;
        int n6;
        int n7 = this.screenDiameter / 2;
        if (n7 < n3) {
            n7 = n3;
        }
        if ((n6 = (n5 = this.screenX - n) * n5) > (n4 = n7 * n7)) {
            return false;
        }
        int n8 = this.screenY - n2;
        int n9 = n8 * n8;
        int n10 = n4 - (n6 + n9);
        if (n10 < 0) {
            return false;
        }
        if (atom == null) {
            return true;
        }
        int n11 = this.screenZ;
        int n12 = atom.screenZ;
        int n13 = atom.screenDiameter / 2;
        if (n11 < n12 - n13) {
            return true;
        }
        int n14 = atom.screenX - n;
        int n15 = n14 * n14;
        int n16 = atom.screenY - n2;
        int n17 = n16 * n16;
        int n18 = n13 * n13;
        int n19 = n18 - (n15 + n17);
        return (double)n11 - Math.sqrt(n10) < (double)n12 - Math.sqrt(n19);
    }

    public String getInfo() {
        return this.getIdentity(true);
    }

    String getInfoXYZ(boolean bl) {
        if (bl) {
            String string = this.getGroup3(true);
            char c = this.getChainID();
            Point3f point3f = this.group.chain.modelSet.unitCells == null ? null : this.getFractionalCoord(true);
            return "Atom: " + (string == null ? this.getElementSymbol() : this.getAtomName()) + " " + this.getAtomNumber() + (string != null && string.length() > 0 ? (this.isHetero() ? " Hetero: " : " Group: ") + string + " " + this.getResno() + (c != '\u0000' && c != ' ' ? " Chain: " + c : "") : "") + " Model: " + this.getModelNumber() + " Coordinates: " + this.x + " " + this.y + " " + this.z + (point3f == null ? "" : " Fractional: " + point3f.x + " " + point3f.y + " " + point3f.z);
        }
        return this.getIdentityXYZ(true);
    }

    String getIdentityXYZ(boolean bl) {
        Atom atom = this.group.chain.model.isJmolDataFrame ? this.getFractionalCoord(false) : this;
        return this.getIdentity(bl) + " " + atom.x + " " + atom.y + " " + atom.z;
    }

    String getIdentity(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getGroup3(true);
        String string2 = this.getSeqcodeString();
        char c = this.getChainID();
        if (string != null && string.length() > 0) {
            stringBuffer.append("[");
            stringBuffer.append(string);
            stringBuffer.append("]");
        }
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        if (c != '\u0000' && c != ' ') {
            stringBuffer.append(":");
            stringBuffer.append(c);
        }
        if (!bl) {
            return stringBuffer.toString();
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.append(".");
        }
        stringBuffer.append(this.getAtomName());
        if (stringBuffer.length() == 0) {
            stringBuffer.append(this.getElementSymbol(false));
            stringBuffer.append(" ");
            stringBuffer.append(this.getAtomNumber());
        }
        if (this.alternateLocationID != '\u0000') {
            stringBuffer.append("%");
            stringBuffer.append(this.alternateLocationID);
        }
        if (this.group.chain.modelSet.getModelCount() > 1) {
            stringBuffer.append("/");
            stringBuffer.append(this.getModelNumberForLabel());
        }
        stringBuffer.append(" #");
        stringBuffer.append(this.getAtomNumber());
        return stringBuffer.toString();
    }

    public int getGroupIndex() {
        return this.group.getGroupIndex();
    }

    public String getGroup3(boolean bl) {
        String string = this.group.getGroup3();
        return bl || string != null && string.length() > 0 ? string : "UNK";
    }

    public String getGroup1(char c) {
        char c2 = this.group.getGroup1();
        return c2 != '\u0000' ? "" + c2 : (c != '\u0000' ? "" + c : "");
    }

    boolean isGroup3(String string) {
        return this.group.isGroup3(string);
    }

    public boolean isProtein() {
        return this.group.isProtein();
    }

    public boolean isCarbohydrate() {
        return this.group.isCarbohydrate();
    }

    public boolean isNucleic() {
        return this.group.isNucleic();
    }

    public boolean isDna() {
        return this.group.isDna();
    }

    public boolean isRna() {
        return this.group.isRna();
    }

    public boolean isPurine() {
        return this.group.isPurine();
    }

    public boolean isPyrimidine() {
        return this.group.isPyrimidine();
    }

    int getSeqcode() {
        return this.group.getSeqcode();
    }

    public int getResno() {
        return this.group.getResno();
    }

    public boolean isClickable() {
        if (!this.isVisible(0)) {
            return false;
        }
        int n = this.shapeVisibilityFlags | this.group.shapeVisibilityFlags;
        return (n & this.clickabilityFlags) != 0;
    }

    public int getClickabilityFlags() {
        return this.clickabilityFlags;
    }

    public void setClickable(int n) {
        this.clickabilityFlags = n == 0 ? 0 : (this.clickabilityFlags |= n);
    }

    public boolean isVisible(int n) {
        if (!this.isInFrame() || this.group.chain.modelSet.isAtomHidden(this.index)) {
            return false;
        }
        if (n != 0) {
            return this.isShapeVisible(n);
        }
        n = this.shapeVisibilityFlags;
        if (this.group.shapeVisibilityFlags != JmolConstants.BACKBONE_VISIBILITY_FLAG || this.isLeadAtom()) {
            n |= this.group.shapeVisibilityFlags;
        }
        return (n & 0xFFFFFFFE) != 0;
    }

    public boolean isLeadAtom() {
        return this.group.isLeadAtom(this.index);
    }

    public float getGroupParameter(int n) {
        return this.group.getGroupParameter(n);
    }

    public char getChainID() {
        return this.group.chain.chainID;
    }

    public int getSurfaceDistance100() {
        return this.group.chain.modelSet.getSurfaceDistance100(this.index);
    }

    public Vector3f getVibrationVector() {
        return this.group.chain.modelSet.getVibrationVector(this.index, false);
    }

    public float getVibrationCoord(char c) {
        return this.group.chain.modelSet.getVibrationCoord(this.index, c);
    }

    public int getPolymerLength() {
        return this.group.getBioPolymerLength();
    }

    public int getPolymerIndexInModel() {
        return this.group.getBioPolymerIndexInModel();
    }

    public int getMonomerIndex() {
        return this.group.getMonomerIndex();
    }

    public int getSelectedGroupCountWithinChain() {
        return this.group.chain.getSelectedGroupCount();
    }

    public int getSelectedGroupIndexWithinChain() {
        return this.group.getSelectedGroupIndex();
    }

    public int getSelectedMonomerCountWithinPolymer() {
        return this.group.getSelectedMonomerCount();
    }

    public int getSelectedMonomerIndexWithinPolymer() {
        return this.group.getSelectedMonomerIndex();
    }

    Chain getChain() {
        return this.group.chain;
    }

    String getModelNumberForLabel() {
        return this.group.chain.modelSet.getModelNumberForAtomLabel(this.modelIndex);
    }

    public int getModelNumber() {
        return this.group.chain.modelSet.getModelNumber(this.modelIndex) % 1000000;
    }

    public int getModelFileIndex() {
        return this.group.chain.model.fileIndex;
    }

    public int getModelFileNumber() {
        return this.group.chain.modelSet.getModelFileNumber(this.modelIndex);
    }

    public String getGroupType() {
        return JmolConstants.getProteinStructureName(this.getProteinStructureType(), true);
    }

    public byte getProteinStructureType() {
        return this.group.getProteinStructureType();
    }

    public byte getProteinStructureSubType() {
        return this.group.getProteinStructureSubType();
    }

    public int getStrucNo() {
        return this.group.getStrucNo();
    }

    public String getStructureId() {
        return this.group.getStructureId();
    }

    public String getProteinStructureTag() {
        return this.group.getProteinStructureTag();
    }

    public short getGroupID() {
        return this.group.groupID;
    }

    String getSeqcodeString() {
        return this.group.getSeqcodeString();
    }

    int getSeqNumber() {
        return this.group.getSeqNumber();
    }

    public char getInsertionCode() {
        return this.group.getInsertionCode();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return this.index;
    }

    public Atom findAromaticNeighbor(int n) {
        if (this.bonds == null) {
            return null;
        }
        int n2 = this.bonds.length;
        while (--n2 >= 0) {
            Bond bond = this.bonds[n2];
            Atom atom = bond.getOtherAtom(this);
            if (!bond.isAromatic() || atom.index == n) continue;
            return atom;
        }
        return null;
    }

    public static int atomPropertyInt(Atom atom, int n) {
        switch (n) {
            case 1095763969: {
                return atom.getAtomNumber();
            }
            case 1095761922: {
                return atom.atomID;
            }
            case 1095761923: {
                return atom.getIndex();
            }
            case 1095761924: {
                return atom.getCovalentBondCount();
            }
            case 1632638983: {
                return atom.group.chain.modelSet.viewer.getColorArgbOrGray(atom.getColix());
            }
            case 1087375365: 
            case 1095763976: {
                return atom.getElementNumber();
            }
            case 1229984263: {
                return atom.getModelFileIndex() + 1;
            }
            case 1632634889: {
                return atom.getFormalCharge();
            }
            case 1095761930: {
                return atom.getGroupID();
            }
            case 1095761931: {
                return atom.getGroupIndex();
            }
            case 1095766028: {
                return atom.getModelNumber();
            }
            case -1095766028: {
                return atom.getModelFileNumber();
            }
            case 1095761933: {
                return atom.modelIndex;
            }
            case 1095761934: {
                return atom.getMoleculeNumber();
            }
            case 1129318402: {
                return atom.getOccupancy100();
            }
            case 1095761935: {
                return atom.getGroup().getBioPolymerIndexInModel() + 1;
            }
            case 1095761936: {
                return atom.getPolymerLength();
            }
            case 1666189313: {
                return atom.getRasMolRadius();
            }
            case 1095761937: {
                return atom.getResno();
            }
            case 1095761938: {
                return atom.getAtomSite();
            }
            case 1104154627: {
                return atom.getProteinStructureType();
            }
            case 1238369286: {
                return atom.getProteinStructureSubType();
            }
            case 1095761939: {
                return atom.getStrucNo();
            }
            case 1095763988: {
                return atom.getValence();
            }
        }
        return 0;
    }

    public static float atomPropertyFloat(Viewer viewer, Atom atom, int n) {
        switch (n) {
            case 1666189313: {
                return atom.getRadius();
            }
            case 1114638349: {
                return viewer.isAtomSelected(atom.index) ? 1 : 0;
            }
            case 1112539145: {
                atom.group.chain.modelSet.getSurfaceDistanceMax();
                return (float)atom.getSurfaceDistance100() / 100.0f;
            }
            case 1112541198: {
                return (float)atom.getBfactor100() / 100.0f;
            }
            case 1313866247: {
                return atom.getVolume(viewer, 8);
            }
            case 1112539137: {
                return atom.getADPMinMax(true);
            }
            case 1112539138: {
                return atom.getADPMinMax(false);
            }
            case 1112541185: 
            case 1112541203: {
                return atom.x;
            }
            case 1112541186: 
            case 1112541204: {
                return atom.y;
            }
            case 1112541187: 
            case 1112541205: {
                return atom.z;
            }
            case 1112539139: {
                return atom.getCovalentRadiusFloat();
            }
            case 1112541188: {
                return atom.getFractionalCoord('X', true);
            }
            case 1112541189: {
                return atom.getFractionalCoord('Y', true);
            }
            case 1112541190: {
                return atom.getFractionalCoord('Z', true);
            }
            case 1112541191: {
                return atom.getFractionalCoord('X', false);
            }
            case 1112541192: {
                return atom.getFractionalCoord('Y', false);
            }
            case 1112541193: {
                return atom.getFractionalCoord('Z', false);
            }
            case 1112541194: {
                return atom.getBondingRadiusFloat();
            }
            case 1129318402: {
                return (float)atom.getOccupancy100() / 100.0f;
            }
            case 1112541195: {
                return atom.getPartialCharge();
            }
            case 1112539140: 
            case 1112539141: 
            case 1112539142: 
            case 1112539143: 
            case 1112539144: 
            case 1112539146: {
                return atom.getGroupParameter(n);
            }
            case 1113200651: {
                return atom.getRadius();
            }
            case 1113198595: 
            case 1113198596: 
            case 1113198597: 
            case 1113200642: 
            case 1113200646: 
            case 1113200647: 
            case 1113200649: 
            case 1113200650: 
            case 1113200652: 
            case 1113200654: 
            case 1115297793: 
            case 1650071565: {
                return viewer.getAtomShapeValue(n, atom.group, atom.index);
            }
            case 1112539147: {
                return atom.getFractionalUnitCoord('X');
            }
            case 1112539148: {
                return atom.getFractionalUnitCoord('Y');
            }
            case 1112539149: {
                return atom.getFractionalUnitCoord('Z');
            }
            case 1112541199: {
                return atom.getVanderwaalsRadiusFloat(viewer, 8);
            }
            case 1112541200: {
                return atom.getVibrationCoord('X');
            }
            case 1112541201: {
                return atom.getVibrationCoord('Y');
            }
            case 1112541202: {
                return atom.getVibrationCoord('Z');
            }
        }
        return Atom.atomPropertyInt(atom, n);
    }

    public static String atomPropertyString(Atom atom, int n) {
        switch (n) {
            case 1087373315: {
                char c = atom.getAlternateLocationID();
                return c == '\u0000' ? "" : "" + c;
            }
            case 1087375362: {
                return atom.getAtomName();
            }
            case 1087375361: {
                return atom.getAtomType();
            }
            case 0x40D00004: {
                char c = atom.getChainID();
                return c == '\u0000' ? "" : "" + c;
            }
            case 1087373320: {
                return atom.getGroup1('?');
            }
            case 1087373319: {
                return atom.getGroup1('\u0000');
            }
            case 1087373318: {
                return atom.getGroup3(false);
            }
            case 1087375365: {
                return atom.getElementSymbol(true);
            }
            case 1087373321: {
                return atom.getIdentity(true);
            }
            case 1087373322: {
                char c = atom.getInsertionCode();
                return c == '\u0000' ? "" : "" + c;
            }
            case 1288701954: 
            case 1826248707: {
                String string = atom.group.chain.modelSet.getAtomLabel(atom.getIndex());
                if (string == null) {
                    string = "";
                }
                return string;
            }
            case 1104154627: {
                return JmolConstants.getProteinStructureName(atom.getProteinStructureType(), false);
            }
            case 1238369286: {
                return JmolConstants.getProteinStructureName(atom.getProteinStructureSubType(), false);
            }
            case 1087373323: {
                return atom.getStructureId();
            }
            case 1087375372: {
                return atom.getElementSymbol(false);
            }
            case 1089470477: {
                return atom.getSymmetryOperatorList();
            }
        }
        return "";
    }

    public static Tuple3f atomPropertyTuple(Atom atom, int n) {
        switch (n) {
            case 1146095627: {
                return atom.getFractionalCoord(!atom.group.chain.model.isJmolDataFrame);
            }
            case 1146095628: {
                return atom.getFractionalCoord(false);
            }
            case 1146093581: {
                return atom.group.chain.model.isJmolDataFrame ? atom.getFractionalCoord(false) : atom.getFractionalUnitCoord(false);
            }
            case 1146095630: {
                Vector3f vector3f = atom.getVibrationVector();
                if (vector3f == null) {
                    vector3f = new Vector3f();
                }
                return vector3f;
            }
            case 1146095626: {
                return atom;
            }
            case 1632638983: {
                return Graphics3D.colorPointFromInt2(atom.group.chain.modelSet.viewer.getColorArgbOrGray(atom.getColix()));
            }
        }
        return null;
    }

    boolean isWithinStructure(byte by) {
        return this.group.isWithinStructure(by);
    }

    public int getOffsetResidueAtom(String string, int n) {
        return this.group.chain.modelSet.getGroupAtom(this, n, string);
    }

    public boolean isCrossLinked(JmolNode jmolNode) {
        return this.group.isCrossLinked(((Atom)jmolNode).getGroup());
    }

    public boolean getCrossLinkLeadAtomIndexes(Vector vector) {
        return this.group.getCrossLinkLeadAtomIndexes(vector);
    }

    public String toString() {
        return this.getInfo();
    }
}

