/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.server;

import com.sparshui.common.Location;
import com.sparshui.server.ClientConnection;
import com.sparshui.server.InputDeviceConnection;
import com.sparshui.server.TouchPoint;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Vector;
import org.jmol.api.JmolGestureServerInterface;
import org.jmol.util.Logger;

public class GestureServer
implements Runnable,
JmolGestureServerInterface {
    GestureServer clientServer;
    GestureServer deviceServer;
    GestureServer main;
    Thread clientThread;
    Thread deviceThread;
    ServerSocket _clientSocket;
    ServerSocket _deviceSocket;
    ServerSocket _mySocket;
    private Vector _clients = new Vector();
    private int port;
    InputDeviceConnection ic = null;
    private int myState;

    public GestureServer() {
        Logger.info(this + " constructed");
    }

    public void finalize() {
        Logger.debug(this + " finalized");
    }

    public GestureServer(int n, GestureServer gestureServer) {
        this.port = n;
        this.main = gestureServer;
    }

    public void startGestureServer() {
        this.clientServer = new GestureServer(5946, this);
        this.clientThread = new Thread(this.clientServer);
        this.clientThread.setName("Jmol SparshUI Client GestureServer on port 5946");
        this.clientThread.start();
        this.deviceServer = new GestureServer(5947, this);
        this.deviceThread = new Thread(this.deviceServer);
        this.deviceThread.setName("Jmol SparshUI Device GestureServer on port 5947");
        this.deviceThread.start();
    }

    public void dispose() {
        try {
            this._clientSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this._deviceSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.clientThread.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.deviceThread.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._clientSocket = null;
        this.clientThread = null;
        this._deviceSocket = null;
        this.deviceThread = null;
        this.clientServer = null;
        this.deviceServer = null;
    }

    public void run() {
        try {
            this.openSocket();
            this.acceptConnections();
        }
        catch (Exception exception) {
            Logger.info("[GestureServer] connection unavailable");
        }
    }

    private void openSocket() {
        try {
            this._mySocket = this.port == 5946 ? (this.main._clientSocket = new ServerSocket(this.port)) : (this.main._deviceSocket = new ServerSocket(this.port));
            Logger.info("[GestureServer] Socket Open: " + this.port);
            this.main.myState = 1;
        }
        catch (IOException iOException) {
            Logger.error("[GestureServer] Failed to open a server socket.");
            iOException.printStackTrace();
            this.main.myState = 0;
        }
    }

    private void acceptConnections() {
        while (!this._mySocket.isClosed()) {
            try {
                if (this.port == 5947) {
                    Logger.info("[GestureServer] Accepting device connections");
                    this.acceptConnection(this._mySocket.accept());
                    return;
                }
                Logger.info("[GestureServer] Accepting client connections");
                this.acceptConnection(this._mySocket.accept());
            }
            catch (IOException iOException) {
                Logger.error("[GestureServer] Failed to establish connection on port " + this.port);
                iOException.printStackTrace();
            }
        }
        Logger.info("[GestureServer] Socket Closed on port " + this.port);
    }

    private void acceptConnection(Socket socket) throws IOException {
        byte[] byArray = socket.getInetAddress().getAddress();
        if (byArray[0] != 127 || byArray[1] != 0 || byArray[2] != 0 || byArray[3] != 1) {
            return;
        }
        int n = socket.getInputStream().read();
        if (n == 0) {
            Logger.info("[GestureServer] client connection established on port " + this.port);
            this.acceptClientConnection(socket);
        } else if (n == 1) {
            Logger.info("[GestureServer] device connection established on port " + this.port);
            this.acceptInputDeviceConnection(socket);
        }
    }

    private void acceptClientConnection(Socket socket) throws IOException {
        Logger.info("[GestureServer] Client connection accepted");
        ClientConnection clientConnection = new ClientConnection(socket);
        this.main._clients.add(clientConnection);
        if (this.main.ic == null) {
            clientConnection.processError(-2);
        } else {
            this.main.myState |= 2;
        }
    }

    private void acceptInputDeviceConnection(Socket socket) throws IOException {
        Logger.info("[GestureServer] Input device connection accepted");
        this.main.ic = new InputDeviceConnection(this, socket);
        this.main.myState |= 4;
    }

    void notifyInputLost() {
        Logger.error("[GestureServer] sending clients message that input device was lost.");
        this.main.ic = null;
        this.main.myState &= 0xFFFFFFFB;
        this.processBirth(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processTouchPoint(HashMap hashMap, int n, Location location, long l, int n2) {
        Integer n3;
        if (Logger.debugging) {
            Logger.info("[GestureServer] processTouchPoint id=" + n + " state=" + n2 + " " + location + " " + l);
        }
        if (hashMap.containsKey(n3 = new Integer(n))) {
            TouchPoint touchPoint = (TouchPoint)hashMap.get(n3);
            if (!touchPoint.isClaimed()) {
                return false;
            }
            Logger.debug("[GestureServer] OK");
            TouchPoint touchPoint2 = touchPoint;
            synchronized (touchPoint2) {
                touchPoint.update(location, l, n2);
            }
            return true;
        }
        TouchPoint touchPoint = new TouchPoint(n, location, l);
        hashMap.put(n3, touchPoint);
        return this.processBirth(touchPoint);
    }

    private boolean processBirth(TouchPoint touchPoint) {
        int n;
        Vector<ClientConnection> vector = null;
        boolean bl = false;
        for (n = 0; n < this.main._clients.size(); ++n) {
            ClientConnection clientConnection = (ClientConnection)this.main._clients.get(n);
            try {
                if (touchPoint == null) {
                    clientConnection.processError(-2);
                } else {
                    bl = clientConnection.processBirth(touchPoint);
                }
                if (!bl) continue;
                break;
            }
            catch (IOException iOException) {
                if (vector == null) {
                    vector = new Vector<ClientConnection>();
                }
                vector.add(clientConnection);
            }
        }
        if (vector != null) {
            for (n = 0; n < vector.size(); ++n) {
                this.main._clients.remove(vector.elementAt(n));
                Logger.info("[GestureServer] Client Disconnected");
            }
        }
        return bl;
    }

    public int getState() {
        return this.myState;
    }
}

