/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.util.ArrayUtil;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Elements;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

class ColorManager {
    private Viewer viewer;
    private Graphics3D g3d;
    private int[] argbsCpk;
    private int[] altArgbsCpk;
    private float colorHi;
    private float colorLo;
    private float[] colorData;
    private int currentPalette = 0;
    private boolean currentTranslucent = false;
    private boolean isDefaultColorRasmol;
    short colixRubberband = (short)22;
    short colixBackgroundContrast;

    ColorManager(Viewer viewer, Graphics3D graphics3D) {
        this.viewer = viewer;
        this.g3d = graphics3D;
        this.argbsCpk = JmolConstants.argbsCpk;
        this.altArgbsCpk = ArrayUtil.arrayCopy(JmolConstants.altArgbsCpk, 0, -1, false);
    }

    void clear() {
    }

    boolean getDefaultColorRasmol() {
        return this.isDefaultColorRasmol;
    }

    void resetElementColors() {
        this.setDefaultColors("Jmol");
    }

    void setDefaultColors(String string) {
        if (string.equalsIgnoreCase("Jmol")) {
            this.isDefaultColorRasmol = false;
            this.argbsCpk = JmolConstants.argbsCpk;
        } else if (string.equalsIgnoreCase("RasMol")) {
            this.isDefaultColorRasmol = true;
            this.argbsCpk = ColorEncoder.getRasmolScale(true);
        } else {
            Logger.error("unrecognized color scheme");
            return;
        }
        this.altArgbsCpk = ArrayUtil.arrayCopy(JmolConstants.altArgbsCpk, 0, -1, false);
        ColorEncoder.makeColorScheme(string, null, true);
        int n = JmolConstants.argbsCpk.length;
        while (--n >= 0) {
            this.g3d.changeColixArgb((short)n, this.argbsCpk[n]);
        }
        n = JmolConstants.altArgbsCpk.length;
        while (--n >= 0) {
            this.g3d.changeColixArgb((short)(Elements.elementNumberMax + n), this.altArgbsCpk[n]);
        }
    }

    void setRubberbandArgb(int n) {
        this.colixRubberband = n == 0 ? (short)0 : Graphics3D.getColix(n);
    }

    void setColixBackgroundContrast(int n) {
        this.colixBackgroundContrast = (short)((Graphics3D.calcGreyscaleRgbFromRgb(n) & 0xFF) < 128 ? 8 : 4);
    }

    short getColixBondPalette(Bond bond, byte by) {
        int n = 0;
        switch (by) {
            case 19: {
                return ColorEncoder.getColorIndexFromPalette(bond.getEnergy(), -2.5f, -0.5f, 7, false);
            }
        }
        return n == 0 ? (short)10 : (short)Graphics3D.getColix(n);
    }

    short getColixAtomPalette(Atom atom, byte by) {
        int n = 0;
        switch (by) {
            case 84: {
                return this.colorData == null || atom.index >= this.colorData.length ? (short)12 : this.getColixForPropertyValue(this.colorData[atom.index]);
            }
            case 0: 
            case 1: {
                short s = atom.getAtomicAndIsotopeNumber();
                if (s < Elements.elementNumberMax) {
                    return this.g3d.getChangeableColix(s, this.argbsCpk[s]);
                }
                s = (short)Elements.altElementIndexFromNumber(s);
                return this.g3d.getChangeableColix((short)(Elements.elementNumberMax + s), this.altArgbsCpk[s]);
            }
            case 2: {
                int n2 = ColorEncoder.quantize(atom.getPartialCharge(), -1.0f, 1.0f, 31);
                return this.g3d.getChangeableColix((short)(JmolConstants.PARTIAL_CHARGE_COLIX_RED + n2), JmolConstants.argbsRwbScale[n2]);
            }
            case 3: {
                int n3 = atom.getFormalCharge() - -4;
                return this.g3d.getChangeableColix((short)(JmolConstants.FORMAL_CHARGE_COLIX_RED + n3), JmolConstants.argbsFormalCharge[n3]);
            }
            case 5: 
            case 68: {
                float f;
                float f2;
                if (by == 68) {
                    ModelSet modelSet = this.viewer.getModelSet();
                    f2 = modelSet.getBfactor100Lo();
                    f = modelSet.getBfactor100Hi();
                } else {
                    f2 = 0.0f;
                    f = 10000.0f;
                }
                return ColorEncoder.getColorIndexFromPalette(atom.getBfactor100(), f2, f, 7, false);
            }
            case 86: {
                return ColorEncoder.getColorIndexFromPalette(atom.getGroupParameter(1112539144), -1.0f, 1.0f, 7, false);
            }
            case 70: {
                float f = this.viewer.getSurfaceDistanceMax();
                return ColorEncoder.getColorIndexFromPalette(atom.getSurfaceDistance100(), 0.0f, f, 7, false);
            }
            case 8: {
                return ColorEncoder.getColorIndexFromPalette(atom.getGroupID(), 0.0f, 0.0f, 5, false);
            }
            case 9: {
                return ColorEncoder.getColorIndexFromPalette(atom.getGroupID(), 0.0f, 0.0f, 4, false);
            }
            case 75: {
                return ColorEncoder.getColorIndexFromPalette(atom.getSelectedGroupIndexWithinChain(), 0.0f, atom.getSelectedGroupCountWithinChain() - 1, 1, false);
            }
            case 87: {
                Model model = this.viewer.getModelSet().getModels()[atom.modelIndex];
                return ColorEncoder.getColorIndexFromPalette(atom.getPolymerIndexInModel(), 0.0f, model.getBioPolymerCount() - 1, 1, false);
            }
            case 76: {
                return ColorEncoder.getColorIndexFromPalette(atom.getSelectedMonomerIndexWithinPolymer(), 0.0f, atom.getSelectedMonomerCountWithinPolymer() - 1, 1, false);
            }
            case 77: {
                ModelSet modelSet = this.viewer.getModelSet();
                return ColorEncoder.getColorIndexFromPalette(modelSet.getMoleculeIndex(atom.getIndex()), 0.0f, modelSet.getMoleculeCountInModel(atom.getModelIndex()) - 1, 0, false);
            }
            case 14: {
                ModelSet modelSet = this.viewer.getModelSet();
                int n4 = atom.getModelIndex();
                return ColorEncoder.getColorIndexFromPalette(modelSet.getAltLocIndexInModel(n4, atom.getAlternateLocationID()), 0.0f, modelSet.getAltLocCountInModel(n4), 0, false);
            }
            case 15: {
                ModelSet modelSet = this.viewer.getModelSet();
                int n5 = atom.getModelIndex();
                return ColorEncoder.getColorIndexFromPalette(modelSet.getInsertionCodeIndexInModel(n5, atom.getInsertionCode()), 0.0f, modelSet.getInsertionCountInModel(n5), 0, false);
            }
            case 16: {
                short s = atom.getAtomicAndIsotopeNumber();
                n = ColorManager.getJmolOrRasmolArgb(s, 1073741992);
                break;
            }
            case 17: {
                short s = atom.getAtomicAndIsotopeNumber();
                n = ColorManager.getJmolOrRasmolArgb(s, 1073742116);
                break;
            }
            case 7: {
                n = JmolConstants.argbsStructure[atom.getProteinStructureSubType() + 1];
                break;
            }
            case 10: {
                int n6 = atom.getChainID() & 0x1F;
                if (n6 < 0) {
                    n6 = 0;
                }
                if (n6 >= JmolConstants.argbsChainAtom.length) {
                    n6 %= JmolConstants.argbsChainAtom.length;
                }
                n = (atom.isHetero() ? JmolConstants.argbsChainHetero : JmolConstants.argbsChainAtom)[n6];
            }
        }
        return n == 0 ? (short)22 : (short)Graphics3D.getColix(n);
    }

    private static int getJmolOrRasmolArgb(int n, int n2) {
        switch (n2) {
            case 1073741992: {
                if (n >= Elements.elementNumberMax) break;
                return ColorEncoder.getArgbFromPalette(n, 0.0f, 0.0f, 2);
            }
            case 1073742116: {
                if (n >= Elements.elementNumberMax) break;
                return ColorEncoder.getArgbFromPalette(n, 0.0f, 0.0f, 3);
            }
            default: {
                return n2;
            }
        }
        return JmolConstants.altArgbsCpk[Elements.altElementIndexFromNumber(n)];
    }

    void setElementArgb(int n, int n2) {
        if (n2 == 1073741992 && this.argbsCpk == JmolConstants.argbsCpk) {
            return;
        }
        n2 = ColorManager.getJmolOrRasmolArgb(n, n2);
        if (this.argbsCpk == JmolConstants.argbsCpk) {
            this.argbsCpk = ArrayUtil.arrayCopy(JmolConstants.argbsCpk, 0, -1, false);
            this.altArgbsCpk = ArrayUtil.arrayCopy(JmolConstants.altArgbsCpk, 0, -1, false);
        }
        if (n < Elements.elementNumberMax) {
            this.argbsCpk[n] = n2;
            this.g3d.changeColixArgb((short)n, n2);
            return;
        }
        n = Elements.altElementIndexFromNumber(n);
        this.altArgbsCpk[n] = n2;
        this.g3d.changeColixArgb((short)(Elements.elementNumberMax + n), n2);
    }

    int setColorScheme(String string, boolean bl, boolean bl2) {
        this.currentTranslucent = bl;
        this.currentPalette = ColorEncoder.getColorScheme(string, bl2);
        Logger.info("ColorManager: color scheme now \"" + ColorEncoder.getColorSchemeName(this.currentPalette) + "\" color value range: " + this.colorLo + " to " + this.colorHi);
        return this.currentPalette;
    }

    void setCurrentColorRange(float[] fArray, BitSet bitSet, String string) {
        int n;
        this.colorData = fArray;
        this.currentPalette = ColorEncoder.getColorScheme(string, false);
        this.colorHi = Float.MIN_VALUE;
        this.colorLo = Float.MAX_VALUE;
        if (fArray == null) {
            return;
        }
        boolean bl = bitSet == null;
        int n2 = n = bl ? fArray.length - 1 : bitSet.nextSetBit(0);
        while (n2 >= 0) {
            float f = fArray[n2];
            if (!Float.isNaN(f)) {
                this.colorHi = Math.max(this.colorHi, f);
                this.colorLo = Math.min(this.colorLo, f);
            }
            n2 = bl ? n2 - 1 : bitSet.nextSetBit(n2 + 1);
        }
        this.setCurrentColorRange(this.colorLo, this.colorHi);
    }

    void setCurrentColorRange(float f, float f2) {
        this.colorHi = f2;
        this.colorLo = f;
        Logger.info("color \"" + ColorEncoder.getColorSchemeName(this.currentPalette) + "\" range " + this.colorLo + " " + this.colorHi);
    }

    static String getState(StringBuffer stringBuffer) {
        return ColorEncoder.getState(stringBuffer);
    }

    static void setUserScale(int[] nArray) {
        ColorEncoder.setUserScale(nArray);
    }

    int[] getColorSchemeArray(String string) {
        return ColorEncoder.getColorSchemeArray(string == null || string.length() == 0 ? this.currentPalette : ColorEncoder.getColorScheme(string, false));
    }

    String getColorSchemeList(String string, boolean bl) {
        if (!bl && ColorEncoder.getColorScheme(string, false) >= 0) {
            return "";
        }
        return ColorEncoder.getColorSchemeList(this.getColorSchemeArray(string));
    }

    short getColixForPropertyValue(float f) {
        return this.colorLo < this.colorHi ? ColorEncoder.getColorIndexFromPalette(f, this.colorLo, this.colorHi, this.currentPalette, this.currentTranslucent) : ColorEncoder.getColorIndexFromPalette(-f, -this.colorLo, -this.colorHi, this.currentPalette, this.currentTranslucent);
    }
}

