/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.io.BufferedReader;
import java.util.HashMap;
import javax.vecmath.Vector3f;
import netscape.javascript.JSObject;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.xml.sax.XMLReader;

public class XmlVaspReader
extends XmlReader {
    String[] vaspImplementedAttributes = new String[]{"name"};
    StringBuffer data;
    String name;
    int atomCount;
    int iAtom;
    boolean modelRead = false;
    boolean readThisModel = true;
    boolean haveUnitCell = false;
    String[] atomNames;
    String[] atomSyms;
    String atomName;
    String atomSym;
    float a;
    float b;
    float c;
    float alpha;
    float beta;
    float gamma;

    XmlVaspReader() {
    }

    protected void processXml(XmlReader xmlReader, AtomSetCollection atomSetCollection, BufferedReader bufferedReader, XMLReader xMLReader) {
        this.parent = xmlReader;
        xmlReader.doProcessLines = true;
        this.reader = bufferedReader;
        this.atomSetCollection = atomSetCollection;
        new VaspHandler(xMLReader);
        this.parseReaderXML(xMLReader);
    }

    protected void processXml(XmlReader xmlReader, AtomSetCollection atomSetCollection, BufferedReader bufferedReader, JSObject jSObject) {
        this.parent = xmlReader;
        xmlReader.doProcessLines = true;
        this.atomSetCollection = atomSetCollection;
        this.implementedAttributes = this.vaspImplementedAttributes;
        new VaspHandler().walkDOMTree(jSObject);
    }

    public void processStartElement(String string, String string2, String string3, HashMap hashMap) {
        if (Logger.debugging) {
            Logger.debug((String)("xmlvasp: start " + string2));
        }
        if (!this.parent.continuing) {
            return;
        }
        if ("structure".equals(string2)) {
            if (!this.parent.doGetModel(++this.parent.modelNumber)) {
                this.parent.checkLastModel();
                return;
            }
            this.parent.setFractionalCoordinates(true);
            this.atomSetCollection.setDoFixPeriodic();
            this.atomSetCollection.newAtomSet();
            return;
        }
        if (!this.parent.doProcessLines) {
            return;
        }
        if ("v".equals(string2)) {
            this.keepChars = this.data != null;
            return;
        }
        if ("c".equals(string2)) {
            this.keepChars = this.iAtom < this.atomCount;
            return;
        }
        if ("varray".equals(string2)) {
            this.name = (String)hashMap.get("name");
            if (this.name != null && Parser.isOneOf((String)this.name, (String)"basis;positions;forces")) {
                this.data = new StringBuffer();
            }
            return;
        }
        if ("atoms".equals(string2)) {
            this.keepChars = true;
            return;
        }
    }

    public void processEndElement(String string, String string2, String string3) {
        if (Logger.debugging) {
            Logger.debug((String)("xmlvasp: end " + string2 + " " + this.name));
        }
        if (this.parent.doProcessLines) {
            if ("v".equals(string2) && this.data != null) {
                this.data.append(this.chars);
            } else if ("c".equals(string2)) {
                if (this.iAtom < this.atomCount) {
                    if (this.atomName == null) {
                        this.atomName = this.atomSym = this.chars.trim();
                    } else {
                        this.atomNames[this.iAtom++] = this.atomName + this.chars.trim();
                        this.atomName = null;
                    }
                }
            } else if ("atoms".equals(string2)) {
                this.atomCount = this.parseInt(this.chars);
                this.atomNames = new String[this.atomCount];
                this.atomSyms = new String[this.atomCount];
                this.iAtom = 0;
            } else if ("varray".equals(string2) && this.data != null) {
                if (this.name != null) {
                    if ("basis".equals(this.name) && !this.haveUnitCell) {
                        this.haveUnitCell = true;
                        float[] fArray = new float[9];
                        XmlVaspReader.getTokensFloat((String)this.data.toString(), (float[])fArray, (int)9);
                        Vector3f vector3f = new Vector3f(fArray[0], fArray[1], fArray[2]);
                        Vector3f vector3f2 = new Vector3f(fArray[3], fArray[4], fArray[5]);
                        Vector3f vector3f3 = new Vector3f(fArray[6], fArray[7], fArray[8]);
                        this.a = vector3f.length();
                        this.b = vector3f2.length();
                        this.c = vector3f3.length();
                        vector3f.normalize();
                        vector3f2.normalize();
                        vector3f3.normalize();
                        this.alpha = (float)(Math.acos(vector3f2.dot(vector3f3)) * 180.0 / Math.PI);
                        this.beta = (float)(Math.acos(vector3f.dot(vector3f3)) * 180.0 / Math.PI);
                        this.gamma = (float)(Math.acos(vector3f.dot(vector3f2)) * 180.0 / Math.PI);
                    } else if ("positions".equals(this.name)) {
                        this.parent.setUnitCell(this.a, this.b, this.c, this.alpha, this.beta, this.gamma);
                        float[] fArray = new float[this.atomCount * 3];
                        XmlVaspReader.getTokensFloat((String)this.data.toString(), (float[])fArray, (int)(this.atomCount * 3));
                        int n = 0;
                        for (int i = 0; i < this.atomCount; ++i) {
                            Atom atom = this.atomSetCollection.addNewAtom();
                            atom.set(fArray[n++], fArray[n++], fArray[n++]);
                            atom.elementSymbol = this.atomSyms[i];
                            atom.atomName = this.atomNames[i];
                            this.parent.setAtomCoord(atom);
                        }
                    } else if ("forces".equals(this.name)) {
                        float[] fArray = new float[this.atomCount * 3];
                        XmlVaspReader.getTokensFloat((String)this.data.toString(), (float[])fArray, (int)(this.atomCount * 3));
                        int n = 0;
                        int n2 = this.atomSetCollection.getLastAtomSetAtomIndex();
                        for (int i = 0; i < this.atomCount; ++i) {
                            this.atomSetCollection.addVibrationVector(n2 + i, fArray[n++], fArray[n++], fArray[n++]);
                        }
                    }
                }
                this.data = null;
            } else if ("structure".equals(string2)) {
                try {
                    this.parent.applySymmetryAndSetTrajectory();
                }
                catch (Exception exception) {}
            } else {
                return;
            }
        }
        this.chars = null;
        this.keepChars = false;
    }

    class VaspHandler
    extends XmlReader.JmolXmlHandler {
        VaspHandler() {
        }

        VaspHandler(XMLReader xMLReader) {
            this.setHandler(xMLReader, this);
        }
    }
}

