/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.BitSet;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.AtomIndexIterator;
import org.jmol.api.Interface;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolAppConsoleInterface;
import org.jmol.api.JmolCallbackListener;
import org.jmol.api.JmolImageCreatorInterface;
import org.jmol.api.JmolModelKitInterface;
import org.jmol.api.JmolMolecule;
import org.jmol.api.JmolNode;
import org.jmol.api.JmolScriptEditorInterface;
import org.jmol.api.JmolSelectionListener;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolViewer;
import org.jmol.api.MepCalculationInterface;
import org.jmol.api.MinimizerInterface;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.AtomDataServer;
import org.jmol.atomdata.RadiusData;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.i18n.GT;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BoxInfo;
import org.jmol.modelset.Group;
import org.jmol.modelset.MeasurementPending;
import org.jmol.modelset.ModelCollection;
import org.jmol.modelset.ModelLoader;
import org.jmol.modelset.ModelSet;
import org.jmol.popup.JmolPopup;
import org.jmol.script.ParallelProcessor;
import org.jmol.script.ScriptCompiler;
import org.jmol.script.ScriptContext;
import org.jmol.script.ScriptEvaluator;
import org.jmol.script.ScriptFunction;
import org.jmol.script.ScriptVariable;
import org.jmol.script.Token;
import org.jmol.shape.Shape;
import org.jmol.util.Base64;
import org.jmol.util.BitSetUtil;
import org.jmol.util.CifDataReader;
import org.jmol.util.CommandHistory;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.JpegEncoder;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.OutputStringBuffer;
import org.jmol.util.Parser;
import org.jmol.util.Quaternion;
import org.jmol.util.SurfaceFileTyper;
import org.jmol.util.TempArray;
import org.jmol.util.TextFormat;
import org.jmol.viewer.ActionManager;
import org.jmol.viewer.AnimationManager;
import org.jmol.viewer.ColorManager;
import org.jmol.viewer.DataManager;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.ModelManager;
import org.jmol.viewer.MouseManager14;
import org.jmol.viewer.PropertyManager;
import org.jmol.viewer.RepaintManager;
import org.jmol.viewer.ScriptManager;
import org.jmol.viewer.SelectionManager;
import org.jmol.viewer.ShapeManager;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.StatusManager;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.TransformManager10;
import org.jmol.viewer.TransformManager11;
import org.jmol.viewer.binding.Binding;

public class Viewer
extends JmolViewer
implements AtomDataServer {
    private Component display;
    private Graphics3D g3d;
    private JmolAdapter modelAdapter;
    private CommandHistory commandHistory = new CommandHistory();
    private ColorManager colorManager;
    public ScriptCompiler compiler;
    public Hashtable definedAtomSets;
    private SymmetryInterface symmetry;
    private SmilesMatcherInterface smilesMatcher;
    ScriptEvaluator eval;
    private AnimationManager animationManager;
    private DataManager dataManager;
    private FileManager fileManager;
    private ActionManager actionManager;
    private ShapeManager shapeManager;
    private ModelManager modelManager;
    private ModelSet modelSet;
    private MouseManager14 mouseManager;
    private RepaintManager repaintManager;
    private ScriptManager scriptManager;
    private SelectionManager selectionManager;
    private StateManager stateManager;
    private StateManager.GlobalSettings global;
    private StatusManager statusManager;
    private TempArray tempManager;
    private TransformManager transformManager;
    private String strJavaVendor;
    private String strJavaVersion;
    private String strOSName;
    private String htmlName = "";
    private String fullName = "";
    private String syncId = "";
    private String appletDocumentBase = "";
    private String appletCodeBase = "";
    private String logFilePath = "";
    private boolean multiTouch = false;
    private boolean isSilent = false;
    private boolean isApplet = false;
    private boolean isPreviewOnly = false;
    public boolean haveDisplay = false;
    public boolean autoExit = false;
    private boolean mustRender = true;
    private boolean isPrintOnly = false;
    private boolean isCmdLine_C_Option = false;
    private boolean isCmdLine_c_or_C_Option = false;
    private boolean listCommands = false;
    private boolean useCommandThread = false;
    private boolean isSignedApplet = false;
    private boolean isSignedAppletLocal = false;
    private boolean isDataOnly = false;
    private String appletContext;
    private boolean mouseEnabled = true;
    private boolean noneSelected;
    private static final int FILE_STATUS_CREATING_MODELSET = 2;
    public static final String STATE_VERSION_STAMP = "# Jmol state version ";
    BitSet bsFrameOffsets;
    Point3f[] frameOffsets;
    boolean wasInMotion = false;
    int motionEventNumber;
    private boolean refreshing = true;
    private boolean axesAreTainted = false;
    final Dimension dimScreen = new Dimension();
    private int maximumSize = Integer.MAX_VALUE;
    private float imageFontScaling = 1.0f;
    private boolean antialiasDisplay;
    String interruptScript = "";
    int scriptIndex;
    boolean isScriptQueued = true;
    int hoverAtomIndex = -1;
    String hoverText;
    boolean hoverEnabled = true;
    public static final int CURSOR_DEFAULT = 0;
    public static final int CURSOR_HAND = 1;
    public static final int CURSOR_CROSSHAIR = 2;
    public static final int CURSOR_MOVE = 3;
    public static final int CURSOR_WAIT = 4;
    public static final int CURSOR_ZOOM = 5;
    private int currentCursor = 0;
    int prevFrame = Integer.MIN_VALUE;
    private String language = GT.getLanguage();
    private RadiusData rd = new RadiusData();
    private boolean frankOn = true;
    private boolean scriptEditorVisible;
    JmolAppConsoleInterface appConsole;
    JmolScriptEditorInterface scriptEditor;
    JmolPopup jmolpopup;
    JmolModelKitInterface modelkit;
    String menuStructure;
    boolean isTainted = true;
    private boolean movingSelected;
    private boolean showSelected;
    private int rotateBondIndex = -1;
    private int rotatePrev1 = -1;
    private int rotatePrev2 = -1;
    private BitSet bsRotateBranch;
    private boolean creatingImage;
    public static final String SYNC_GRAPHICS_MESSAGE = "GET_GRAPHICS";
    public static final String SYNC_NO_GRAPHICS_MESSAGE = "SET_GRAPHICS_OFF";
    private String errorMessage;
    private String errorMessageUntranslated;
    private int currentShapeID = -1;
    private String currentShapeState;
    private double privateKey = Math.random();
    private String logFile = null;
    private boolean isKiosk;
    private MinimizerInterface minimizer;
    private Object executor;
    public static int nProcessors = Runtime.getRuntime().availableProcessors();
    boolean displayLoadErrors = true;
    boolean isParallel;
    private static final int MAX_ACTION_UNDO = 100;
    private final Vector actionStates = new Vector();
    private final Vector actionStatesRedo = new Vector();
    private int lastUndoRedo = 0;
    private int stateScriptVersionInt;

    protected void finalize() throws Throwable {
        Logger.debug("viewer finalize " + this);
        super.finalize();
    }

    public JmolAdapter getModelAdapter() {
        if (this.modelAdapter == null) {
            this.modelAdapter = new SmarterJmolAdapter();
        }
        return this.modelAdapter;
    }

    public SymmetryInterface getSymmetry() {
        if (this.symmetry == null) {
            this.symmetry = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
        }
        return this.symmetry;
    }

    public Object getSymmetryInfo(BitSet bitSet, String string, int n, Point3f point3f, Point3f point3f2, String string2, int n2) {
        return this.modelSet.getSymmetryInfo(bitSet, string, n, point3f, point3f2, string2, n2);
    }

    private void clearModelDependentObjects() {
        this.setFrameOffsets(null);
        this.stopMinimization();
        this.minimizer = null;
        if (this.smilesMatcher != null) {
            this.smilesMatcher = null;
        }
        if (this.symmetry != null) {
            this.symmetry = null;
        }
    }

    public SmilesMatcherInterface getSmilesMatcher() {
        if (this.smilesMatcher == null) {
            this.smilesMatcher = (SmilesMatcherInterface)Interface.getOptionInterface("smiles.SmilesMatcher");
        }
        return this.smilesMatcher;
    }

    public BitSet getSmartsMatch(String string, BitSet bitSet) {
        if (bitSet == null) {
            bitSet = this.getSelectionSet(false);
        }
        return this.getSmilesMatcher().getSubstructureSet(string, this.getModelSet().atoms, this.getAtomCount(), bitSet, true, false);
    }

    StateManager.GlobalSettings getGlobalSettings() {
        return this.global;
    }

    private Viewer(Component component, JmolAdapter jmolAdapter, String string) {
        if (Logger.debugging) {
            Logger.debug("Viewer constructor " + this);
        }
        this.g3d = new Graphics3D(component);
        this.isDataOnly = component == null;
        this.mustRender = this.haveDisplay = !this.isDataOnly && (string == null || string.indexOf("-n") < 0);
        if (!this.haveDisplay) {
            component = null;
        }
        this.display = component;
        this.modelAdapter = jmolAdapter;
        this.strJavaVendor = System.getProperty("java.vendor");
        this.strOSName = System.getProperty("os.name");
        this.strJavaVersion = System.getProperty("java.version");
        this.multiTouch = string != null && string.indexOf("-multitouch") >= 0;
        this.stateManager = new StateManager(this);
        this.colorManager = new ColorManager(this, this.g3d);
        this.statusManager = new StatusManager(this);
        this.scriptManager = new ScriptManager(this);
        this.transformManager = new TransformManager11(this);
        this.selectionManager = new SelectionManager(this);
        if (this.haveDisplay) {
            if (this.multiTouch) {
                if (string.indexOf("-multitouch-sparshui-simulated") < 0) {
                    int[] nArray = new int[1];
                    Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(1, 1, nArray, 0, 1));
                    Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), "invisibleCursor");
                    component.setCursor(cursor);
                }
                this.actionManager = (ActionManager)Interface.getInterface("multitouch.ActionManagerMT");
            } else {
                this.actionManager = new ActionManager();
            }
            this.actionManager.setViewer(this, string);
            this.mouseManager = new MouseManager14(this, this.actionManager);
        }
        this.modelManager = new ModelManager(this);
        this.shapeManager = new ShapeManager(this);
        this.tempManager = new TempArray();
        this.dataManager = new DataManager(this);
        this.animationManager = new AnimationManager(this);
        this.repaintManager = new RepaintManager(this, this.shapeManager);
        this.initialize();
        this.fileManager = new FileManager(this);
        this.compiler = new ScriptCompiler(this);
        this.definedAtomSets = new Hashtable();
        this.eval = new ScriptEvaluator(this);
    }

    public static JmolViewer allocateViewer(Component component, JmolAdapter jmolAdapter, String string, URL uRL, URL uRL2, String string2, JmolStatusListener jmolStatusListener) {
        Viewer viewer = new Viewer(component, jmolAdapter, string2);
        viewer.setAppletContext(string, uRL, uRL2, string2);
        viewer.setJmolStatusListener(jmolStatusListener);
        return viewer;
    }

    public boolean isApplet() {
        return this.isApplet;
    }

    public boolean isPreviewOnly() {
        return this.isPreviewOnly;
    }

    String getAppletContext() {
        return this.appletContext;
    }

    public synchronized void setAppletContext(String string, URL uRL, URL uRL2, String string2) {
        this.appletContext = string2 == null ? "" : string2;
        string = string == null ? "" : string;
        this.fullName = string;
        this.appletDocumentBase = uRL == null ? "" : uRL.toString();
        this.appletCodeBase = uRL2 == null ? "" : uRL2.toString();
        int n = string.lastIndexOf("[");
        this.htmlName = n < 0 ? string : string.substring(0, n);
        this.syncId = n < 0 ? "" : string.substring(n + 1, string.length() - 1);
        String string3 = this.appletContext;
        this.isPrintOnly = this.appletContext.indexOf("-p") >= 0;
        boolean bl = this.isApplet = this.appletContext.indexOf("-applet") >= 0;
        if (this.isApplet) {
            Logger.info("applet context: " + this.appletContext);
            String string4 = null;
            n = string3.indexOf("-appletProxy ");
            if (n >= 0) {
                string4 = string3.substring(n + 13);
                string3 = string3.substring(0, n);
            }
            this.fileManager.setAppletContext(uRL, uRL2, string4);
            boolean bl2 = this.isSignedApplet = string3.indexOf("-signed") >= 0;
            if (this.isSignedApplet) {
                this.logFilePath = TextFormat.simpleReplace(this.appletCodeBase, "file://", "");
                this.logFilePath = TextFormat.simpleReplace(this.logFilePath, "file:/", "");
                if (this.logFilePath.indexOf("//") >= 0) {
                    this.logFilePath = null;
                } else {
                    this.isSignedAppletLocal = true;
                }
            } else {
                this.logFilePath = null;
            }
            n = string3.indexOf("-maximumSize ");
            if (n >= 0) {
                this.setMaximumSize(Parser.parseInt(string3.substring(n + 13)));
            }
            boolean bl3 = this.useCommandThread = string3.indexOf("-threaded") >= 0;
            if (this.useCommandThread) {
                this.scriptManager.startCommandWatcher(true);
            }
        } else {
            this.g3d.setBackgroundTransparent(string3.indexOf("-b") >= 0);
            boolean bl4 = this.isSilent = string3.indexOf("-i") >= 0;
            if (this.isSilent) {
                Logger.setLogLevel(3);
            }
            this.isCmdLine_c_or_C_Option = string3.toLowerCase().indexOf("-c") >= 0;
            this.isCmdLine_C_Option = string3.indexOf("-C") >= 0;
            this.listCommands = string3.indexOf("-l") >= 0;
            this.autoExit = string3.indexOf("-x") >= 0;
            this.cd(".");
        }
        this.isPreviewOnly = string3.indexOf("#previewOnly") >= 0;
        this.setBooleanProperty("_applet", this.isApplet);
        this.setBooleanProperty("_signedApplet", this.isSignedApplet);
        this.setBooleanProperty("_useCommandThread", this.useCommandThread);
        this.setIntProperty("_nProcessors", nProcessors);
        if (!this.isSilent) {
            Logger.info("(C) 2009 Jmol Development\nJmol Version: " + Viewer.getJmolVersion() + "\njava.vendor: " + this.strJavaVendor + "\njava.version: " + this.strJavaVersion + "\nos.name: " + this.strOSName + "\nmemory: " + this.getParameter("_memory") + "\nprocessors available: " + nProcessors + "\nuseCommandThread: " + this.useCommandThread + (!this.isApplet ? "" : "\nappletId:" + this.htmlName + (this.isSignedApplet ? " (signed)" : "")));
        }
        this.zap(false, true, false);
        this.global.setParameterValue("language", GT.getLanguage());
    }

    public boolean isDataOnly() {
        return this.isDataOnly;
    }

    public static String getJmolVersion() {
        return JmolConstants.version + "  " + JmolConstants.date;
    }

    public String getExportDriverList() {
        return (String)this.global.getParameter("exportDrivers");
    }

    String getHtmlName() {
        return this.htmlName;
    }

    boolean mustRenderFlag() {
        return this.mustRender && this.refreshing;
    }

    public Component getDisplay() {
        return this.display;
    }

    public boolean handleOldJvm10Event(Event event) {
        return this.mouseManager.handleOldJvm10Event(event);
    }

    public void reset(boolean bl) {
        this.modelSet.calcBoundBoxDimensions(null, 1.0f);
        this.axesAreTainted = true;
        this.transformManager.homePosition(bl);
        if (this.modelSet.setCrystallographicDefaults()) {
            this.stateManager.setCrystallographicDefaults();
        } else {
            this.setAxesModeMolecular(false);
        }
        this.prevFrame = Integer.MIN_VALUE;
        if (!this.getSpinOn()) {
            this.refresh(1, "Viewer:homePosition()");
        }
    }

    public void homePosition() {
        this.evalString("reset spin");
    }

    Hashtable getAppletInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("htmlName", this.htmlName);
        hashtable.put("syncId", this.syncId);
        hashtable.put("fullName", this.fullName);
        if (this.isApplet) {
            hashtable.put("documentBase", this.appletDocumentBase);
            hashtable.put("codeBase", this.appletCodeBase);
            hashtable.put("registry", this.statusManager.getRegistryInfo());
        }
        hashtable.put("version", JmolConstants.version);
        hashtable.put("date", JmolConstants.date);
        hashtable.put("javaVendor", this.strJavaVendor);
        hashtable.put("javaVersion", this.strJavaVersion);
        hashtable.put("operatingSystem", this.strOSName);
        return hashtable;
    }

    public void initialize() {
        this.global = this.stateManager.getGlobalSettings(this.global);
        this.global.setParameterValue("_applet", this.isApplet);
        this.global.setParameterValue("_signedApplet", this.isSignedApplet);
        this.global.setParameterValue("_useCommandThread", this.useCommandThread);
        this.global.setParameterValue("_width", this.dimScreen.width);
        this.global.setParameterValue("_height", this.dimScreen.height);
        if (this.haveDisplay) {
            this.global.setParameterValue("_multiTouchClient", this.actionManager.isMTClient());
            this.global.setParameterValue("_multiTouchServer", this.actionManager.isMTServer());
        }
        this.colorManager.resetElementColors();
        this.setObjectColor("background", "black");
        this.setObjectColor("axis1", "red");
        this.setObjectColor("axis2", "green");
        this.setObjectColor("axis3", "blue");
        Graphics3D.setAmbientPercent(this.global.ambientPercent);
        Graphics3D.setDiffusePercent(this.global.diffusePercent);
        Graphics3D.setSpecular(this.global.specular);
        Graphics3D.setSpecularPercent(this.global.specularPercent);
        Graphics3D.setSpecularPower(-this.global.specularExponent);
        Graphics3D.setPhongExponent(this.global.phongExponent);
        Graphics3D.setSpecularPower(this.global.specularPower);
        Graphics3D.setZShadePower(this.global.zShadePower);
        if (this.modelSet != null) {
            this.animationManager.setAnimationOn(false);
        }
        this.animationManager.setAnimationFps(this.global.animationFps);
        this.statusManager.setAllowStatusReporting(this.global.statusReporting);
        this.setBooleanProperty("antialiasDisplay", this.global.antialiasDisplay);
        this.setTransformManagerDefaults();
    }

    public String listSavedStates() {
        return this.stateManager.listSavedStates();
    }

    public void saveOrientation(String string) {
        this.stateManager.saveOrientation(string);
    }

    public boolean restoreOrientation(String string, float f) {
        return this.stateManager.restoreOrientation(string, f, true);
    }

    public void restoreRotation(String string, float f) {
        this.stateManager.restoreOrientation(string, f, false);
    }

    void saveModelOrientation() {
        this.modelSet.saveModelOrientation(this.animationManager.currentModelIndex, this.stateManager.getOrientation());
    }

    public StateManager.Orientation getOrientation() {
        return this.stateManager.getOrientation();
    }

    public String getSavedOrienationText(String string) {
        return this.stateManager.getSavedOrientationText(string);
    }

    void restoreModelOrientation(int n) {
        StateManager.Orientation orientation = this.modelSet.getModelOrientation(n);
        if (orientation != null) {
            orientation.restore(-1.0f, true);
        }
    }

    void restoreModelRotation(int n) {
        StateManager.Orientation orientation = this.modelSet.getModelOrientation(n);
        if (orientation != null) {
            orientation.restore(-1.0f, false);
        }
    }

    public void saveBonds(String string) {
        this.stateManager.saveBonds(string);
    }

    public boolean restoreBonds(String string) {
        this.clearModelDependentObjects();
        return this.stateManager.restoreBonds(string);
    }

    public void saveState(String string) {
        this.stateManager.saveState(string);
    }

    public void deleteSavedState(String string) {
        this.stateManager.deleteSaved("State_" + string);
    }

    public String getSavedState(String string) {
        return this.stateManager.getSavedState(string);
    }

    public void saveStructure(String string) {
        this.stateManager.saveStructure(string);
    }

    public String getSavedStructure(String string) {
        return this.stateManager.getSavedStructure(string);
    }

    public void saveCoordinates(String string, BitSet bitSet) {
        this.stateManager.saveCoordinates(string, bitSet);
    }

    public String getSavedCoordinates(String string) {
        return this.stateManager.getSavedCoordinates(string);
    }

    public void saveSelection(String string) {
        this.stateManager.saveSelection(string, this.getSelectionSet(false));
        this.stateManager.restoreSelection(string);
    }

    public boolean restoreSelection(String string) {
        return this.stateManager.restoreSelection(string);
    }

    public Matrix4f getMatrixtransform() {
        return this.transformManager.getMatrixtransform();
    }

    public Quaternion getRotationQuaternion() {
        return this.transformManager.getRotationQuaternion();
    }

    public float getRotationRadius() {
        return this.transformManager.getRotationRadius();
    }

    public void setRotationRadius(float f, boolean bl) {
        if (bl) {
            f = this.transformManager.setRotationRadius(f, false);
        }
        if (this.modelSet.setRotationRadius(this.animationManager.currentModelIndex, f)) {
            this.global.setParameterValue("rotationRadius", f);
        }
    }

    public Point3f getRotationCenter() {
        return this.transformManager.getRotationCenter();
    }

    public void setCenterAt(String string, Point3f point3f) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.setCenterAt(string, point3f);
    }

    public void setCenterBitSet(BitSet bitSet, boolean bl) {
        Point3f point3f;
        Point3f point3f2 = point3f = BitSetUtil.cardinalityOf(bitSet) > 0 ? this.getAtomSetCenter(bitSet) : null;
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.setNewRotationCenter(point3f, bl);
    }

    public void setNewRotationCenter(Point3f point3f) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.setNewRotationCenter(point3f, true);
    }

    public Point3f getNavigationCenter() {
        return this.transformManager.getNavigationCenter();
    }

    public float getNavigationDepthPercent() {
        return this.transformManager.getNavigationDepthPercent();
    }

    void navigate(int n, int n2) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navigate(n, n2);
        if (!this.transformManager.vibrationOn && n != 0) {
            this.refresh(1, "Viewer:navigate()");
        }
    }

    public Point3f getNavigationOffset() {
        return this.transformManager.getNavigationOffset();
    }

    float getNavigationOffsetPercent(char c) {
        return this.transformManager.getNavigationOffsetPercent(c);
    }

    public boolean isNavigating() {
        return this.transformManager.isNavigating();
    }

    public boolean isInPosition(Vector3f vector3f, float f) {
        return this.transformManager.isInPosition(vector3f, f);
    }

    public void move(Vector3f vector3f, float f, Vector3f vector3f2, float f2, float f3, int n) {
        this.transformManager.move(vector3f, f, vector3f2, f2, f3, n);
        this.moveUpdate(f3);
    }

    public boolean waitForMoveTo() {
        return this.global.waitForMoveTo;
    }

    public void stopMotion() {
        this.transformManager.stopMotion();
    }

    void setRotationMatrix(Matrix3f matrix3f) {
        this.transformManager.setRotation(matrix3f);
    }

    public void moveTo(float f, Point3f point3f, Vector3f vector3f, float f2, Matrix3f matrix3f, float f3, float f4, float f5, float f6, Point3f point3f2, float f7, float f8, float f9) {
        if (!this.haveDisplay) {
            f = 0.0f;
        }
        this.setTainted(true);
        this.transformManager.moveTo(f, point3f, vector3f, f2, matrix3f, f3, f4, f5, f6, point3f2, f7, f8, f9);
        this.moveUpdate(f);
        this.finalizeTransformParameters();
    }

    private void moveUpdate(float f) {
        if (f > 0.0f) {
            this.requestRepaintAndWait();
        } else if (f == 0.0f) {
            this.setSync();
        }
    }

    String getMoveToText(float f) {
        return this.transformManager.getMoveToText(f, false);
    }

    public void navigate(float f, Point3f[] point3fArray, float[] fArray, int n, int n2) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navigate(f, point3fArray, fArray, n, n2);
        this.moveUpdate(f);
    }

    public void navigate(float f, Point3f point3f) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navigate(f, point3f);
        this.moveUpdate(f);
    }

    public void navigate(float f, Point3f[][] point3fArray) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navigate(f, point3fArray);
        this.moveUpdate(f);
    }

    public void navigateSurface(float f, String string) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navigateSurface(f, string);
        this.moveUpdate(f);
    }

    public void navigate(float f, Vector3f vector3f, float f2) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navigate(f, vector3f, f2);
        this.moveUpdate(f);
    }

    public void navTranslate(float f, Point3f point3f) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navTranslate(f, point3f);
        this.moveUpdate(f);
    }

    public void navTranslatePercent(float f, float f2, float f3) {
        if (this.isJmolDataFrame()) {
            return;
        }
        this.transformManager.navTranslatePercent(f, f2, f3);
        this.moveUpdate(f);
    }

    public void setMouseEnabled(boolean bl) {
        this.mouseEnabled = bl;
    }

    void zoomBy(int n) {
        if (this.mouseEnabled) {
            this.transformManager.zoomBy(n);
        }
        this.refresh(2, this.statusManager.syncingMouse ? "Mouse: zoomBy " + n : "");
    }

    void zoomByFactor(float f, int n, int n2) {
        if (this.mouseEnabled) {
            this.transformManager.zoomByFactor(f, n, n2);
        }
        this.refresh(2, !this.statusManager.syncingMouse ? "" : "Mouse: zoomByFactor " + f + (n == Integer.MAX_VALUE ? "" : " " + n + " " + n2));
    }

    void rotateXYBy(float f, float f2) {
        if (this.mouseEnabled) {
            this.transformManager.rotateXYBy(f, f2, null);
        }
        this.refresh(2, this.statusManager.syncingMouse ? "Mouse: rotateXYBy " + f + " " + f2 : "");
    }

    public void spinXYBy(int n, int n2, float f) {
        if (this.mouseEnabled) {
            this.transformManager.spinXYBy(n, n2, f);
        }
        if (n == 0 && n2 == 0) {
            return;
        }
        this.refresh(2, this.statusManager.syncingMouse ? "Mouse: spinXYBy " + n + " " + n2 + " " + f : "");
    }

    public void rotateZBy(int n, int n2, int n3) {
        if (this.mouseEnabled) {
            this.transformManager.rotateZBy(n, n2, n3);
        }
        this.refresh(2, this.statusManager.syncingMouse ? "Mouse: rotateZBy " + n + (n2 == Integer.MAX_VALUE ? "" : " " + n2 + " " + n3) : "");
    }

    void rotateMolecule(float f, float f2, BitSet bitSet) {
        if (this.isJmolDataFrame()) {
            return;
        }
        if (this.mouseEnabled) {
            if (bitSet == null) {
                bitSet = this.getSelectionSet(false);
            }
            this.transformManager.setRotateMolecule(true);
            this.transformManager.rotateXYBy(f, f2, bitSet);
            this.transformManager.setRotateMolecule(false);
            this.refreshMeasures(true);
        }
        this.refresh(2, this.statusManager.syncingMouse ? "Mouse: rotateMolecule " + f + " " + f2 : "");
    }

    public void translateXYBy(int n, int n2) {
        if (this.mouseEnabled) {
            this.transformManager.translateXYBy(n, n2);
        }
        this.refresh(2, this.statusManager.syncingMouse ? "Mouse: translateXYBy " + n + " " + n2 : "");
    }

    void centerAt(int n, int n2, Point3f point3f) {
        if (this.mouseEnabled) {
            this.transformManager.centerAt(n, n2, point3f);
        }
        this.refresh(2, this.statusManager.syncingMouse ? "Mouse: centerAt " + n + " " + n2 + " " + point3f.x + " " + point3f.y + " " + point3f.z : "");
    }

    public void rotateFront() {
        this.transformManager.rotateFront();
        this.refresh(1, "Viewer:rotateFront()");
    }

    public void rotateX(float f) {
        this.transformManager.rotateX(f);
        this.refresh(1, "Viewer:rotateX()");
    }

    public void rotateY(float f) {
        this.transformManager.rotateY(f);
        this.refresh(1, "Viewer:rotateY()");
    }

    public void rotateZ(float f) {
        this.transformManager.rotateZ(f);
        this.refresh(1, "Viewer:rotateZ()");
    }

    public void rotateX(int n) {
        this.rotateX((float)n * ((float)Math.PI / 180));
    }

    public void rotateY(int n) {
        this.rotateY((float)n * ((float)Math.PI / 180));
    }

    public void translate(char c, float f, char c2, BitSet bitSet) {
        int n;
        int n2 = c2 == '\u0000' ? (int)f : (c2 == '%' ? this.transformManager.percentToPixels(c, f) : (n = this.transformManager.angstromsToPixels(f * (c2 == 'n' ? 10.0f : 1.0f))));
        if (bitSet != null) {
            if (n == 0) {
                return;
            }
            this.repaintManager.setSelectedTranslation(bitSet, c, n);
        } else {
            switch (c) {
                case 'x': {
                    if (c2 == '\u0000') {
                        this.transformManager.translateToPercent('x', f);
                        break;
                    }
                    this.transformManager.translateXYBy(n, 0);
                    break;
                }
                case 'y': {
                    if (c2 == '\u0000') {
                        this.transformManager.translateToPercent('y', f);
                        break;
                    }
                    this.transformManager.translateXYBy(0, n);
                    break;
                }
                case 'z': {
                    if (c2 == '\u0000') {
                        this.transformManager.translateToPercent('z', f);
                        break;
                    }
                    this.transformManager.translateZBy(n);
                }
            }
        }
        this.refresh(1, "Viewer:translate()");
    }

    public float getTranslationXPercent() {
        return this.transformManager.getTranslationXPercent();
    }

    public float getTranslationYPercent() {
        return this.transformManager.getTranslationYPercent();
    }

    float getTranslationZPercent() {
        return this.transformManager.getTranslationZPercent();
    }

    public String getTranslationScript() {
        return this.transformManager.getTranslationScript();
    }

    public int getZoomPercent() {
        return (int)this.getZoomSetting();
    }

    public float getZoomSetting() {
        return this.transformManager.getZoomSetting();
    }

    public float getZoomPercentFloat() {
        return this.transformManager.getZoomPercentFloat();
    }

    public float getMaxZoomPercent() {
        return 200000.0f;
    }

    public void slabReset() {
        this.transformManager.slabReset();
    }

    public boolean getZoomEnabled() {
        return this.transformManager.zoomEnabled;
    }

    public boolean getSlabEnabled() {
        return this.transformManager.slabEnabled;
    }

    public boolean getSlabByMolecule() {
        return this.global.slabByMolecule;
    }

    public boolean getSlabByAtom() {
        return this.global.slabByAtom;
    }

    void slabByPixels(int n) {
        this.transformManager.slabByPercentagePoints(n);
        this.refresh(3, "slabByPixels");
    }

    void depthByPixels(int n) {
        this.transformManager.depthByPercentagePoints(n);
        this.refresh(3, "depthByPixels");
    }

    void slabDepthByPixels(int n) {
        this.transformManager.slabDepthByPercentagePoints(n);
        this.refresh(3, "slabDepthByPixels");
    }

    public void slabToPercent(int n) {
        this.transformManager.slabToPercent(n);
    }

    public void slabInternal(Point4f point4f, boolean bl) {
        this.transformManager.slabInternal(point4f, bl);
    }

    public void depthToPercent(int n) {
        this.transformManager.depthToPercent(n);
    }

    public void setSlabDepthInternal(boolean bl) {
        this.transformManager.setSlabDepthInternal(bl);
    }

    public int zValueFromPercent(int n) {
        return this.transformManager.zValueFromPercent(n);
    }

    public Matrix4f getUnscaledTransformMatrix() {
        return this.transformManager.getUnscaledTransformMatrix();
    }

    void finalizeTransformParameters() {
        this.transformManager.finalizeTransformParameters();
        this.g3d.setSlabAndDepthValues(this.transformManager.slabValue, this.transformManager.depthValue, this.transformManager.zShadeEnabled, this.transformManager.zSlabValue, this.transformManager.zDepthValue);
    }

    public void rotatePoint(Point3f point3f, Point3f point3f2) {
        this.transformManager.rotatePoint(point3f, point3f2);
    }

    public Point3i transformPoint(Point3f point3f) {
        return this.transformManager.transformPoint(point3f);
    }

    public Point3i transformPoint(Point3f point3f, Vector3f vector3f) {
        return this.transformManager.transformPoint(point3f, vector3f);
    }

    public void transformPoint(Point3f point3f, Point3i point3i) {
        this.transformManager.transformPoint(point3f, point3i);
    }

    public void transformPointNoClip(Point3f point3f, Point3f point3f2) {
        this.transformManager.transformPointNoClip(point3f, point3f2);
    }

    public void transformPoint(Point3f point3f, Point3f point3f2) {
        this.transformManager.transformPoint(point3f, point3f2);
    }

    public void transformPoints(Point3f[] point3fArray, Point3i[] point3iArray) {
        this.transformManager.transformPoints(point3fArray.length, point3fArray, point3iArray);
    }

    public void transformVector(Vector3f vector3f, Vector3f vector3f2) {
        this.transformManager.transformVector(vector3f, vector3f2);
    }

    public void unTransformPoint(Point3f point3f, Point3f point3f2) {
        this.transformManager.unTransformPoint(point3f, point3f2);
    }

    public float getScalePixelsPerAngstrom(boolean bl) {
        return this.transformManager.scalePixelsPerAngstrom * (bl || !this.global.antialiasDisplay ? 1.0f : 0.5f);
    }

    public short scaleToScreen(int n, int n2) {
        return this.transformManager.scaleToScreen(n, n2);
    }

    public float unscaleToScreen(float f, float f2) {
        return this.transformManager.unscaleToScreen(f, f2);
    }

    public float scaleToPerspective(int n, float f) {
        return this.transformManager.scaleToPerspective(n, f);
    }

    public void setSpin(String string, int n) {
        if (!Parser.isOneOf(string, "x;y;z;fps;X;Y;Z;FPS")) {
            return;
        }
        int n2 = "x;y;z;fps;X;Y;Z;FPS".indexOf(string);
        switch (n2) {
            case 0: {
                this.transformManager.setSpinXYZ(n, Float.NaN, Float.NaN);
                break;
            }
            case 2: {
                this.transformManager.setSpinXYZ(Float.NaN, n, Float.NaN);
                break;
            }
            case 4: {
                this.transformManager.setSpinXYZ(Float.NaN, Float.NaN, n);
                break;
            }
            default: {
                this.transformManager.setSpinFps(n);
                break;
            }
            case 10: {
                this.transformManager.setNavXYZ(n, Float.NaN, Float.NaN);
                break;
            }
            case 12: {
                this.transformManager.setNavXYZ(Float.NaN, n, Float.NaN);
                break;
            }
            case 14: {
                this.transformManager.setNavXYZ(Float.NaN, Float.NaN, n);
                break;
            }
            case 16: {
                this.transformManager.setNavFps(n);
            }
        }
        this.global.setParameterValue((n2 < 10 ? "spin" : "nav") + string, n);
    }

    public String getSpinState() {
        return this.transformManager.getSpinState(false);
    }

    public void setSpinOn(boolean bl) {
        this.transformManager.setSpinOn(bl);
    }

    boolean getSpinOn() {
        return this.transformManager.getSpinOn();
    }

    public void setNavOn(boolean bl) {
        this.transformManager.setNavOn(bl);
    }

    boolean getNavOn() {
        return this.transformManager.getNavOn();
    }

    public void setNavXYZ(float f, float f2, float f3) {
        this.transformManager.setNavXYZ((int)f, (int)f2, (int)f3);
    }

    public String getOrientationText(int n, String string) {
        return string == null ? this.transformManager.getOrientationText(n) : this.stateManager.getSavedOrientationText(string);
    }

    Hashtable getOrientationInfo() {
        return this.transformManager.getOrientationInfo();
    }

    Matrix3f getMatrixRotate() {
        return this.transformManager.getMatrixRotate();
    }

    public void getAxisAngle(AxisAngle4f axisAngle4f) {
        this.transformManager.getAxisAngle(axisAngle4f);
    }

    public String getTransformText() {
        return this.transformManager.getTransformText();
    }

    void getRotation(Matrix3f matrix3f) {
        this.transformManager.getRotation(matrix3f);
    }

    private void setDefaultColors(String string) {
        this.colorManager.setDefaultColors(string);
        this.global.setParameterValue("colorRasmol", string.equalsIgnoreCase("rasmol"));
    }

    public float getDefaultTranslucent() {
        return this.global.defaultTranslucent;
    }

    public int getColorArgbOrGray(short s) {
        return this.g3d.getColorArgbOrGray(s);
    }

    public void setRubberbandArgb(int n) {
        this.colorManager.setRubberbandArgb(n);
    }

    public short getColixRubberband() {
        return this.colorManager.colixRubberband;
    }

    public void setElementArgb(int n, int n2) {
        this.global.setParameterValue("=color " + Elements.elementNameFromNumber(n), Escape.escapeColor(n2));
        this.colorManager.setElementArgb(n, n2);
    }

    public float getVectorScale() {
        return this.global.vectorScale;
    }

    public void setVectorScale(float f) {
        this.global.setParameterValue("vectorScale", f);
        this.global.vectorScale = f;
    }

    public float getDefaultDrawArrowScale() {
        return this.global.defaultDrawArrowScale;
    }

    float getVibrationScale() {
        return this.global.vibrationScale;
    }

    public float getVibrationPeriod() {
        return this.global.vibrationPeriod;
    }

    public boolean isVibrationOn() {
        return this.transformManager.vibrationOn;
    }

    public void setVibrationScale(float f) {
        this.transformManager.setVibrationScale(f);
        this.global.vibrationScale = f;
        this.global.setParameterValue("vibrationScale", f);
    }

    public void setVibrationOff() {
        this.transformManager.setVibrationPeriod(0.0f);
    }

    public void setVibrationPeriod(float f) {
        this.transformManager.setVibrationPeriod(f);
        this.global.vibrationPeriod = f = Math.abs(f);
        this.global.setParameterValue("vibrationPeriod", f);
    }

    void setObjectColor(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return;
        }
        this.setObjectArgb(string, Graphics3D.getArgbFromString(string2));
    }

    public void setObjectArgb(String string, int n) {
        int n2 = StateManager.getObjectIdFromName(string);
        if (n2 < 0) {
            if (string.equalsIgnoreCase("axes")) {
                this.setObjectArgb("axis1", n);
                this.setObjectArgb("axis2", n);
                this.setObjectArgb("axis3", n);
            }
            return;
        }
        this.global.objColors[n2] = n;
        switch (n2) {
            case 0: {
                this.g3d.setBackgroundArgb(n);
                this.colorManager.setColixBackgroundContrast(n);
            }
        }
        this.global.setParameterValue(string + "Color", Escape.escapeColor(n));
    }

    public void setBackgroundImage(String string, Image image) {
        this.global.backgroundImageFileName = string;
        this.g3d.setBackgroundImage(image);
    }

    int getObjectArgb(int n) {
        return this.global.objColors[n];
    }

    public short getObjectColix(int n) {
        int n2 = this.getObjectArgb(n);
        if (n2 == 0) {
            return this.getColixBackgroundContrast();
        }
        return Graphics3D.getColix(n2);
    }

    public String getObjectState(String string) {
        int n = StateManager.getObjectIdFromName(string.equalsIgnoreCase("axes") ? "axis" : string);
        if (n < 0) {
            return "";
        }
        int n2 = this.getObjectMad(n);
        StringBuffer stringBuffer = new StringBuffer("\n");
        Shape.appendCmd(stringBuffer, string + (n2 == 0 ? " off" : (n2 == 1 ? " on" : (n2 == -1 ? " dotted" : (n2 < 20 ? " " + n2 : " " + (float)n2 / 2000.0f)))));
        return stringBuffer.toString();
    }

    public void setColorBackground(String string) {
        this.setObjectColor("background", string);
    }

    public int getBackgroundArgb() {
        return this.getObjectArgb(0);
    }

    public void setObjectMad(int n, String string, int n2) {
        int n3 = StateManager.getObjectIdFromName(string.equalsIgnoreCase("axes") ? "axis" : string);
        if (n3 < 0) {
            return;
        }
        if (n2 == -2 || n2 == -4) {
            int n4 = n2 + 3;
            n2 = this.getObjectMad(n3);
            if (n2 == 0) {
                n2 = n4;
            }
        }
        this.global.setParameterValue("show" + string, n2 != 0);
        boolean bl = this.global.objStateOn[n3] = n2 != 0;
        if (n2 == 0) {
            return;
        }
        this.global.objMad[n3] = n2;
        this.setShapeSize(n, n2, null);
    }

    public int getObjectMad(int n) {
        return this.global.objStateOn[n] ? this.global.objMad[n] : 0;
    }

    public void setPropertyColorScheme(String string, boolean bl, boolean bl2) {
        this.global.propertyColorScheme = string;
        if (string.startsWith("translucent ")) {
            bl = true;
            string = string.substring(12).trim();
        }
        this.colorManager.setColorScheme(string, bl, bl2);
    }

    public String getPropertyColorScheme() {
        return this.global.propertyColorScheme;
    }

    public short getColixBackgroundContrast() {
        return this.colorManager.colixBackgroundContrast;
    }

    public String getSpecularState() {
        return this.global.getSpecularState();
    }

    public short getColixAtomPalette(Atom atom, byte by) {
        return this.colorManager.getColixAtomPalette(atom, by);
    }

    public short getColixBondPalette(Bond bond, byte by) {
        return this.colorManager.getColixBondPalette(bond, by);
    }

    public int[] getColorSchemeArray(String string) {
        return this.colorManager.getColorSchemeArray(string);
    }

    public String getColorSchemeList(String string, boolean bl) {
        return this.colorManager.getColorSchemeList(string, bl);
    }

    public static void setUserScale(int[] nArray) {
        ColorManager.setUserScale(nArray);
    }

    public short getColixForPropertyValue(float f) {
        return this.colorManager.getColixForPropertyValue(f);
    }

    public Point3f getColorPointForPropertyValue(float f) {
        return Graphics3D.colorPointFromInt2(this.g3d.getColorArgbOrGray(this.colorManager.getColixForPropertyValue(f)));
    }

    public void select(BitSet bitSet, boolean bl) {
        this.selectionManager.select(bitSet, bl);
        this.shapeManager.setShapeSize(1, Integer.MAX_VALUE, null, null);
    }

    public void setSelectionSet(BitSet bitSet) {
        this.select(bitSet, true);
    }

    public void selectBonds(BitSet bitSet) {
        this.shapeManager.setShapeSize(1, Integer.MAX_VALUE, null, bitSet);
    }

    public void hide(BitSet bitSet, boolean bl) {
        this.selectionManager.hide(bitSet, bl);
    }

    public void display(BitSet bitSet, boolean bl) {
        this.selectionManager.display(this.modelSet.getModelAtomBitSetIncludingDeleted(-1, false), bitSet, bl);
    }

    public BitSet getHiddenSet() {
        return this.selectionManager.getHiddenSet();
    }

    public boolean isSelected(int n) {
        return this.selectionManager.isSelected(n);
    }

    boolean isInSelectionSubset(int n) {
        return this.selectionManager.isInSelectionSubset(n);
    }

    void reportSelection(String string) {
        if (this.modelSet.getSelectionHaloEnabled()) {
            this.setTainted(true);
        }
        if (this.isScriptQueued || this.global.debugScript) {
            this.scriptStatus(string);
        }
    }

    public Point3f getAtomSetCenter(BitSet bitSet) {
        return this.modelSet.getAtomSetCenter(bitSet);
    }

    private void clearAtomSets() {
        this.setSelectionSubset(null);
        this.definedAtomSets.clear();
    }

    public void selectAll() {
        this.selectionManager.selectAll(false);
    }

    public void setNoneSelected(boolean bl) {
        this.noneSelected = bl;
    }

    public Boolean getNoneSelected() {
        return this.noneSelected ? Boolean.TRUE : Boolean.FALSE;
    }

    public void clearSelection() {
        this.selectionManager.clearSelection(true);
        this.global.setParameterValue("hideNotSelected", false);
    }

    public void setSelectionSubset(BitSet bitSet) {
        this.selectionManager.setSelectionSubset(bitSet);
    }

    public BitSet getSelectionSubset() {
        return this.selectionManager.getSelectionSubset();
    }

    public void invertSelection() {
        this.selectionManager.invertSelection();
    }

    public BitSet getSelectionSet(boolean bl) {
        return this.selectionManager.getSelectionSet(bl);
    }

    public void setSelectedAtom(int n, boolean bl) {
        this.selectionManager.setSelectedAtom(n, bl);
    }

    public boolean isAtomSelected(int n) {
        return this.selectionManager.isAtomSelected(n);
    }

    public int getSelectionCount() {
        return this.selectionManager.getSelectionCount();
    }

    public void setFormalCharges(int n) {
        this.modelSet.setFormalCharges(this.getSelectionSet(false), n);
    }

    public void addSelectionListener(JmolSelectionListener jmolSelectionListener) {
        this.selectionManager.addListener(jmolSelectionListener);
    }

    public void removeSelectionListener(JmolSelectionListener jmolSelectionListener) {
        this.selectionManager.addListener(jmolSelectionListener);
    }

    BitSet getAtomBitSet(ScriptEvaluator scriptEvaluator, Object object) {
        if (scriptEvaluator == null) {
            scriptEvaluator = new ScriptEvaluator(this);
        }
        return ScriptEvaluator.getAtomBitSet(scriptEvaluator, object);
    }

    public BitSet getAtomBitSet(Object object) {
        return this.getAtomBitSet(this.eval, object);
    }

    Vector getAtomBitSetVector(Object object) {
        return ScriptEvaluator.getAtomBitSetVector(this.eval, this.getAtomCount(), object);
    }

    public void setModeMouse(int n) {
        if (this.haveDisplay && n == -1) {
            this.mouseManager.dispose();
        }
        if (n == -1) {
            this.clearScriptQueue();
            this.haltScriptExecution();
            this.stopAnimationThreads("setModeMouse NONE");
            this.scriptManager.startCommandWatcher(false);
            this.scriptManager.interruptQueueThreads();
            this.g3d.destroy();
            try {
                if (this.appConsole != null) {
                    this.appConsole.dispose();
                    this.appConsole = null;
                }
                if (this.scriptEditor != null) {
                    this.scriptEditor.dispose();
                    this.scriptEditor = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    Rectangle getRubberBandSelection() {
        return this.haveDisplay ? this.actionManager.getRubberBand() : null;
    }

    public boolean isBound(int n, int n2) {
        return this.haveDisplay && this.actionManager.isBound(n, n2);
    }

    public int getCursorX() {
        return this.haveDisplay ? this.actionManager.getCurrentX() : 0;
    }

    public int getCursorY() {
        return this.haveDisplay ? this.actionManager.getCurrentY() : 0;
    }

    String getDefaultDirectory() {
        return this.global.defaultDirectory;
    }

    public BufferedInputStream getBufferedInputStream(String string) {
        return this.fileManager.getBufferedInputStream(string);
    }

    public Object getBufferedReaderOrErrorMessageFromName(String string, String[] stringArray, boolean bl) {
        return this.fileManager.getBufferedReaderOrErrorMessageFromName(string, stringArray, bl, true);
    }

    private Hashtable setLoadParameters(Hashtable hashtable, boolean bl) {
        String string;
        if (hashtable == null) {
            hashtable = new Hashtable<String, Viewer>();
        }
        hashtable.put("viewer", this);
        if (this.global.atomTypes.length() > 0) {
            hashtable.put("atomTypes", (Viewer)((Object)this.global.atomTypes));
        }
        if (!hashtable.containsKey("lattice")) {
            hashtable.put("lattice", (Viewer)((Object)this.global.getDefaultLattice()));
        }
        if (this.global.applySymmetryToBonds) {
            hashtable.put("applySymmetryToBonds", (Viewer)((Object)Boolean.TRUE));
        }
        if (this.global.pdbGetHeader) {
            hashtable.put("getHeader", (Viewer)((Object)Boolean.TRUE));
        }
        if (this.global.pdbSequential) {
            hashtable.put("isSequential", (Viewer)((Object)Boolean.TRUE));
        }
        if (!hashtable.containsKey("filter") && (string = this.getDefaultLoadFilter()).length() > 0) {
            hashtable.put("filter", (Viewer)((Object)string));
        }
        if (bl && !this.global.appendNew && this.getAtomCount() > 0) {
            hashtable.put("merging", (Viewer)((Object)Boolean.TRUE));
        }
        return hashtable;
    }

    public void openFileAsynchronously(String string) {
        boolean bl;
        boolean bl2 = bl = !(string = string.trim()).startsWith("\t");
        if (!bl) {
            string = string.substring(1);
        }
        string = string.replace('\\', '/');
        if (this.isApplet && string.indexOf("://") < 0) {
            string = "file://" + (string.startsWith("/") ? "" : "/") + string;
        }
        String string2 = null;
        if (string.endsWith("jvxl")) {
            string2 = "isosurface ";
        } else if (!string.endsWith(".spt")) {
            String string3 = this.fileManager.getFileTypeName(string);
            if (string3 == null) {
                string3 = SurfaceFileTyper.determineSurfaceFileType(this.getBufferedInputStream(string));
                if (string3.equals("Pdb") || string3.equals("Cif")) {
                    this.evalString("if (_filetype == 'Pdb') { isosurface sigma 1.0 within 2.0 {*} " + Escape.escape(string) + " mesh nofill }; else; { isosurface " + Escape.escape(string) + "}");
                    return;
                }
            } else if (string3.equals("Jmol")) {
                string2 = "load ";
            } else if (!string3.equals("spt")) {
                this.evalString("zap; load auto " + Escape.escape(string) + ";if (_loadScript = '' && defaultLoadScript == '' && _filetype == 'Pdb') { select protein or nucleic;cartoons Only;color structure; select * }");
                return;
            }
        }
        if (bl && this.scriptEditorVisible && string2 == null) {
            this.showEditor(new String[]{string, this.getFileAsString(string)});
        } else {
            this.evalString((string2 == null ? "script " : string2) + Escape.escape(string));
        }
    }

    public String openFile(String string) {
        this.zap(true, true, false);
        return this.loadModelFromFile(null, string, null, null, false, null, null, 0);
    }

    public String openFiles(String[] stringArray) {
        this.zap(true, true, false);
        return this.loadModelFromFile(null, null, stringArray, null, false, null, null, 0);
    }

    public String openReader(String string, String string2, Reader reader) {
        this.zap(true, true, false);
        return this.loadModelFromFile(string, string2, null, reader, false, null, null, 0);
    }

    public String openDOM(Object object) {
        this.zap(true, true, false);
        this.setBooleanProperty("preserveState", false);
        return this.loadModelFromFile("?", "?", null, object, false, null, null, 0);
    }

    public String loadModelFromFile(String string, String string2, String[] stringArray, Object object, boolean bl, Hashtable hashtable, StringBuffer stringBuffer, int n) {
        Object object2;
        if (hashtable == null) {
            hashtable = this.setLoadParameters(null, bl);
        }
        String[] stringArray2 = this.fileManager.getFileInfo();
        if (stringArray != null) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer("load files");
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(" /*file*/$FILENAME" + (i + 1) + "$");
                }
            }
            long l = System.currentTimeMillis();
            object2 = this.fileManager.createAtomSetCollectionFromFiles(stringArray, this.setLoadParameters(hashtable, bl), bl);
            long l2 = System.currentTimeMillis() - l;
            String string3 = "";
            for (int i = 0; i < stringArray.length; ++i) {
                string3 = string3 + (i == 0 ? "" : ",") + stringArray[i];
            }
            Logger.info("openFiles(" + stringArray.length + ") " + l2 + " ms");
            stringArray = (String[])hashtable.get("fullPathNames");
            String string4 = stringBuffer.toString();
            for (int i = 0; i < stringArray.length; ++i) {
                string4 = TextFormat.simpleReplace(string4, "$FILENAME" + (i + 1) + "$", Escape.escape(stringArray[i].replace('\\', '/')));
            }
            stringBuffer = new StringBuffer(string4);
        } else {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer("load /*file*/$FILENAME$");
            }
            if (object == null) {
                object2 = this.getAtomSetCollection(string2, bl, hashtable, stringBuffer);
            } else if (object instanceof Reader) {
                hashtable = this.setLoadParameters(null, bl);
                object2 = this.fileManager.createAtomSetCollectionFromReader(string, string2, (Reader)object, hashtable);
            } else {
                hashtable = this.setLoadParameters(null, bl);
                object2 = this.fileManager.createAtomSetCollectionFromDOM(object, hashtable);
            }
        }
        if (n != 0) {
            this.fileManager.setFileInfo(stringArray2);
            return this.loadAtomDataAndReturnError(object2, n);
        }
        if (hashtable.containsKey("isData")) {
            return (String)object2;
        }
        if (stringBuffer != null) {
            String string5 = (String)hashtable.get("fullPathName");
            if (string5 == null) {
                string5 = "";
            }
            if (hashtable.containsKey("loadScript")) {
                stringBuffer = (StringBuffer)hashtable.get("loadScript");
            }
            stringBuffer = new StringBuffer(TextFormat.simpleReplace(stringBuffer.toString(), "$FILENAME$", Escape.escape(string5.replace('\\', '/'))));
            hashtable.put("loadScript", stringBuffer);
        }
        return this.createModelSetAndReturnError(object2, bl, stringBuffer);
    }

    private Object getAtomSetCollection(String string, boolean bl, Hashtable hashtable, StringBuffer stringBuffer) {
        Object object;
        if (string == null) {
            return null;
        }
        if (string.indexOf("[]") >= 0) {
            return null;
        }
        Logger.startTimer();
        hashtable = this.setLoadParameters(hashtable, bl);
        boolean bl2 = string.startsWith("@");
        boolean bl3 = hashtable.containsKey("fileData");
        if (string.indexOf(36) == 0) {
            hashtable.put("smilesString", string.substring(1));
        }
        boolean bl4 = string.equalsIgnoreCase("string") || string.equals("Jmol Model Kit");
        String string2 = null;
        if (bl3) {
            string2 = (String)hashtable.get("fileData");
            if (hashtable.containsKey("isData")) {
                return this.loadInline(string2, '\u0000', bl, hashtable);
            }
        } else if (bl4) {
            string2 = this.modelSet.getInlineData(-1);
            if (string2 == null) {
                if (this.isModelKitMode()) {
                    string2 = "1 0 C 0 0";
                } else {
                    return "cannot find string data";
                }
            }
            if (stringBuffer != null) {
                stringBuffer = new StringBuffer(TextFormat.simpleReplace(stringBuffer.toString(), "$FILENAME$", "data \"model inline\"\n" + string2 + "end \"model inline\""));
                hashtable.put("loadScript", stringBuffer);
            }
        }
        if (string2 != null) {
            if (!bl) {
                this.zap(true, true, false);
            }
            object = this.fileManager.createAtomSetCollectionFromString(string2, stringBuffer, hashtable, bl, bl2 || bl3 && !bl4);
        } else {
            object = this.fileManager.createAtomSetCollectionFromFile(string, hashtable, stringBuffer, bl);
        }
        Logger.checkTimer("openFile(" + string + ")");
        return object;
    }

    public String openStringInline(String string) {
        return this.openStringInline(string, null, false);
    }

    public String loadInline(String string) {
        return this.loadInline(string, this.global.inlineNewlineChar, false, null);
    }

    public String loadInline(String string, char c) {
        return this.loadInline(string, c, false, null);
    }

    public String loadInline(String string, boolean bl) {
        return this.loadInline(string, '\u0000', bl, null);
    }

    public String loadInline(String[] stringArray) {
        return this.loadInline(stringArray, false);
    }

    public String loadInline(String[] stringArray, boolean bl) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return this.openStringsInline(stringArray, null, bl);
    }

    public String loadInline(Vector vector, boolean bl) {
        if (vector == null || vector.size() == 0) {
            return null;
        }
        if (!bl) {
            this.zap(true, true, false);
        }
        this.setBooleanProperty("preserveState", false);
        Object object = this.fileManager.createAtomSeCollectionFromArrayData(vector, this.setLoadParameters(null, bl), bl);
        return this.createModelSetAndReturnError(object, bl, null);
    }

    public String loadInline(String string, char c, boolean bl, Hashtable hashtable) {
        int n;
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.startsWith("LOAD files")) {
            this.script(string);
            return null;
        }
        string = this.fixInlineString(string, c);
        if (c != '\u0000') {
            Logger.info("loading model inline, " + string.length() + " bytes, with newLine character " + c + " isAppend=" + bl);
        }
        Logger.debug(string);
        String string2 = this.getDataSeparator();
        if (string2 != null && string2 != "" && (n = string.indexOf(string2)) >= 0 && string.indexOf("# Jmol state") < 0) {
            int n2 = 2;
            while ((n = string.indexOf(string2, n + 1)) >= 0) {
                ++n2;
            }
            String[] stringArray = new String[n2];
            int n3 = 0;
            int n4 = 0;
            for (n = 0; n < n2; ++n) {
                n3 = string.indexOf(string2, n4);
                if (n3 < 0) {
                    n3 = string.length();
                }
                stringArray[n] = string.substring(n4, n3);
                n4 = n3 + string2.length();
            }
            return this.openStringsInline(stringArray, hashtable, bl);
        }
        return this.openStringInline(string, hashtable, bl);
    }

    public String fixInlineString(String string, char c) {
        if (string.indexOf("\\/n") >= 0) {
            string = TextFormat.simpleReplace(string, "\n", "");
            string = TextFormat.simpleReplace(string, "\\/n", "\n");
            c = '\u0000';
        }
        if (c != '\u0000' && c != '\n') {
            int n;
            boolean bl = string.indexOf(10) >= 0;
            int n2 = string.length();
            for (n = 0; n < n2 && string.charAt(n) == ' '; ++n) {
            }
            if (n < n2 && string.charAt(n) == c) {
                string = string.substring(n + 1);
            }
            string = bl ? TextFormat.simpleReplace(string, "" + c, "") : string.replace(c, '\n');
        }
        return string;
    }

    private String openStringInline(String string, Hashtable hashtable, boolean bl) {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        String string2 = this.getModelAdapter().getFileTypeName(bufferedReader);
        if (string2 == null) {
            return "unknown file type";
        }
        if (string2.equals("spt")) {
            return "cannot open script inline";
        }
        hashtable = this.setLoadParameters(hashtable, bl);
        StringBuffer stringBuffer = (StringBuffer)hashtable.get("loadScript");
        boolean bl2 = hashtable.containsKey("isData");
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
        }
        if (!bl) {
            this.zap(true, true, false);
        }
        Object object = this.fileManager.createAtomSetCollectionFromString(string, stringBuffer, hashtable, bl, bl2);
        return this.createModelSetAndReturnError(object, bl, stringBuffer);
    }

    private String openStringsInline(String[] stringArray, Hashtable hashtable, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!bl) {
            this.zap(true, true, false);
        }
        Object object = this.fileManager.createAtomSeCollectionFromStrings(stringArray, stringBuffer, this.setLoadParameters(hashtable, bl), bl);
        return this.createModelSetAndReturnError(object, bl, stringBuffer);
    }

    public char getInlineChar() {
        return this.global.inlineNewlineChar;
    }

    String getDataSeparator() {
        return (String)this.global.getParameter("dataseparator");
    }

    private String createModelSetAndReturnError(Object object, boolean bl, StringBuffer stringBuffer) {
        String string;
        String string2 = this.fileManager.getFullPathName();
        String string3 = this.fileManager.getFileName();
        if (stringBuffer == null) {
            this.setBooleanProperty("preserveState", false);
            stringBuffer = new StringBuffer("load \"???\"");
        }
        if (object instanceof String) {
            String string4 = (String)object;
            this.setFileLoadStatus(-1, string2, null, null, string4);
            if (this.displayLoadErrors && string4 != null && !bl && !string4.equals("#CANCELED#")) {
                this.zap(string4);
            }
            return string4;
        }
        if (bl) {
            this.clearAtomSets();
        } else if (this.getModelkitMode() && !string3.equals("Jmol Model Kit")) {
            this.setModelKitMode(false);
        }
        this.setFileLoadStatus(2, string2, string3, null, null);
        this.pushHoldRepaint("createModelSet");
        this.setErrorMessage(null);
        try {
            BitSet bitSet = new BitSet();
            this.modelSet = this.modelManager.createModelSet(string2, string3, stringBuffer, object, bitSet, bl);
            if (bitSet.cardinality() > 0) {
                String string5 = (String)this.modelSet.getModelSetAuxiliaryInfo("jmolscript");
                this.minimize(Integer.MAX_VALUE, 0.0f, bitSet, null, 0.0f, true, true, true);
                if (string5 != null) {
                    this.modelSet.getModelSetAuxiliaryInfo().put("jmolscript", string5);
                }
            }
            if (!bl) {
                this.initializeModel();
            }
        }
        catch (Error error) {
            this.handleError(error, true);
            string = this.getShapeErrorState();
            string = "ERROR creating model: " + error + (string.length() == 0 ? "" : "|" + string);
            this.zap(string);
            this.setErrorMessage(string);
        }
        this.popHoldRepaint("createModelSet");
        string = this.getErrorMessage();
        this.setFileLoadStatus(3, string2, string3, this.getModelSetName(), string);
        if (bl) {
            this.selectAll();
            this.setTainted(true);
            this.axesAreTainted = true;
        }
        object = null;
        System.gc();
        return string;
    }

    private String loadAtomDataAndReturnError(Object object, int n) {
        if (object instanceof String) {
            return (String)object;
        }
        this.setErrorMessage(null);
        try {
            ((ModelLoader)this.modelSet).createAtomDataSet(n, object, this.getSelectionSet(false));
            if (n == 4166) {
                this.setStatusFrameChanged(Integer.MIN_VALUE);
            }
        }
        catch (Error error) {
            this.handleError(error, true);
            String string = this.getShapeErrorState();
            string = "ERROR adding atom data: " + error + (string.length() == 0 ? "" : "|" + string);
            this.zap(string);
            this.setErrorMessage(string);
            this.setParallel(false);
        }
        return this.getErrorMessage();
    }

    public String writeCurrentFile(OutputStream outputStream) {
        String string = this.getFullPathName();
        if (string.equals("string") || string.indexOf("[]") >= 0 || string.equals("JSNode")) {
            String string2 = this.getCurrentFileAsString();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
            OutputStringBuffer outputStringBuffer = new OutputStringBuffer(bufferedOutputStream);
            outputStringBuffer.append(string2);
            return outputStringBuffer.toString();
        }
        String string3 = this.modelManager.getModelSetPathName();
        return string3 == null ? "" : (String)this.getFileAsBytes(string3, outputStream);
    }

    public Object getFileAsBytes(String string, OutputStream outputStream) {
        return this.fileManager.getFileAsBytes(string, outputStream);
    }

    public String getCurrentFileAsString() {
        String string = this.getFullPathName();
        if (string.equals("string") || string.equals("Jmol Model Kit")) {
            return this.modelSet.getInlineData(this.getCurrentModelIndex());
        }
        if (string.indexOf("[]") >= 0) {
            return string;
        }
        if (string == "JSNode") {
            return "<DOM NODE>";
        }
        String string2 = this.modelManager.getModelSetPathName();
        if (string2 == null) {
            return null;
        }
        return this.getFileAsString(string2, Integer.MAX_VALUE, true);
    }

    public String getFullPathName() {
        return this.fileManager.getFullPathName();
    }

    public String getFileName() {
        return this.fileManager.getFileName();
    }

    public String[] getFullPathNameOrError(String string) {
        return this.fileManager.getFullPathNameOrError(string);
    }

    public String getFileAsString(String string) {
        return this.getFileAsString(string, Integer.MAX_VALUE, false);
    }

    public String getFileAsString(String string, int n, boolean bl) {
        if (string == null) {
            return this.getCurrentFileAsString();
        }
        String[] stringArray = new String[2];
        stringArray[0] = string;
        this.getFileAsString(stringArray, n, bl);
        return stringArray[1];
    }

    public String getFilePath(String string, boolean bl) {
        return this.fileManager.getFilePath(string, false, bl);
    }

    public boolean getFileAsString(String[] stringArray, int n, boolean bl) {
        return this.fileManager.getFileDataOrErrorAsString(stringArray, n, bl);
    }

    public String[] getFileInfo() {
        return this.fileManager.getFileInfo();
    }

    public void setFileInfo(String[] stringArray) {
        this.fileManager.setFileInfo(stringArray);
    }

    public void autoCalculate(int n) {
        switch (n) {
            case 1112539145: {
                this.modelSet.getSurfaceDistanceMax();
                break;
            }
            case 1112539144: {
                this.modelSet.calculateStraightness();
            }
        }
    }

    public float getVolume(BitSet bitSet, String string) {
        int n;
        if (bitSet == null) {
            bitSet = this.getSelectionSet(false);
        }
        if ((n = JmolConstants.getVdwType(string)) == -1) {
            n = 8;
        }
        return this.modelSet.calculateVolume(bitSet, n);
    }

    int getSurfaceDistanceMax() {
        return this.modelSet.getSurfaceDistanceMax();
    }

    public void calculateStraightness() {
        this.modelSet.setHaveStraightness(false);
        this.modelSet.calculateStraightness();
    }

    public Point3f[] calculateSurface(BitSet bitSet, float f) {
        if (bitSet == null) {
            bitSet = this.getSelectionSet(false);
        }
        this.addStateScript("calculate surfaceDistance " + (f == Float.MAX_VALUE ? "FROM" : "WITHIN"), null, bitSet, null, "", false, true);
        return this.modelSet.calculateSurface(bitSet, f);
    }

    public boolean getDefaultStructureDSSP() {
        return this.global.defaultStructureDSSP;
    }

    public String calculateStructures(BitSet bitSet, boolean bl, boolean bl2) {
        if (bitSet == null) {
            bitSet = this.getSelectionSet(false);
        }
        return this.modelSet.calculateStructures(bitSet, bl, this.global.dsspCalcHydrogen, bl2);
    }

    public AtomIndexIterator getSelectedAtomIterator(BitSet bitSet, boolean bl, boolean bl2) {
        return this.modelSet.getSelectedAtomIterator(bitSet, bl, bl2, false);
    }

    public void setIteratorForAtom(AtomIndexIterator atomIndexIterator, int n, float f) {
        this.modelSet.setIteratorForAtom(atomIndexIterator, -1, n, f);
    }

    public void setIteratorForPoint(AtomIndexIterator atomIndexIterator, int n, Point3f point3f, float f) {
        this.modelSet.setIteratorForPoint(atomIndexIterator, n, point3f, f);
    }

    public void fillAtomData(AtomData atomData, int n) {
        atomData.programInfo = "Jmol Version " + Viewer.getJmolVersion();
        atomData.fileName = this.getFileName();
        this.modelSet.fillAtomData(atomData, n);
    }

    public ModelCollection.StateScript addStateScript(String string, boolean bl, boolean bl2) {
        return this.addStateScript(string, null, null, null, null, bl, bl2);
    }

    public ModelCollection.StateScript addStateScript(String string, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, String string2, boolean bl, boolean bl2) {
        return this.modelSet.addStateScript(string, bitSet, bitSet2, bitSet3, string2, bl, bl2);
    }

    public boolean getEchoStateActive() {
        return this.modelSet.getEchoStateActive();
    }

    public void setEchoStateActive(boolean bl) {
        this.modelSet.setEchoStateActive(bl);
    }

    public void zap(boolean bl, boolean bl2, boolean bl3) {
        this.stopAnimationThreads("zap");
        if (this.modelSet != null) {
            this.clearModelDependentObjects();
            this.fileManager.clear();
            this.repaintManager.clear();
            this.animationManager.clear();
            this.transformManager.clear();
            this.selectionManager.clear();
            this.clearAllMeasurements();
            this.clearMinimization();
            this.modelSet = this.modelManager.zap();
            if (this.haveDisplay) {
                this.mouseManager.clear();
                this.actionManager.clear();
            }
            this.stateManager.clear(this.global);
            this.tempManager.clear();
            this.colorManager.clear();
            this.definedAtomSets.clear();
            this.dataManager.clear();
            if (bl2) {
                if (bl3 && this.isModelKitMode()) {
                    this.loadInline("1 0 C 0 0");
                    this.setRotationRadius(5.0f, true);
                    this.setStringProperty("picking", "assignAtom_C");
                    this.setStringProperty("picking", "assignBond_p");
                }
                this.actionStates.clear();
                this.actionStatesRedo.clear();
                this.lastUndoRedo = 0;
            }
            System.gc();
        } else {
            this.modelSet = this.modelManager.zap();
        }
        this.initializeModel();
        if (bl) {
            this.setFileLoadStatus(0, null, bl2 ? "resetUndo" : this.getZapName(), null, null);
        }
        if (Logger.debugging) {
            Logger.checkMemory();
        }
    }

    private void zap(String string) {
        this.zap(true, true, false);
        this.echoMessage(string);
    }

    void echoMessage(String string) {
        int n = 28;
        this.loadShape(n);
        this.setShapeProperty(n, "font", this.getFont3D("SansSerif", "Plain", 9.0f));
        this.setShapeProperty(n, "target", "error");
        this.setShapeProperty(n, "text", string);
    }

    private void initializeModel() {
        this.stopAnimationThreads("stop from init model");
        this.reset(true);
        this.selectAll();
        this.rotateBondIndex = -1;
        this.rotatePrev1 = -1;
        this.movingSelected = false;
        this.noneSelected = false;
        this.hoverEnabled = true;
        this.transformManager.setCenter();
        this.clearAtomSets();
        this.animationManager.initializePointers(1);
        this.setCurrentModelIndex(0);
        this.setBackgroundModelIndex(-1);
        this.setFrankOn(this.getShowFrank());
        if (this.haveDisplay) {
            this.actionManager.startHoverWatcher(true);
        }
        this.setTainted(true);
        this.finalizeTransformParameters();
    }

    public String getModelSetName() {
        if (this.modelSet == null) {
            return null;
        }
        return this.modelSet.getModelSetName();
    }

    public String getModelSetFileName() {
        return this.modelManager.getModelSetFileName();
    }

    public String getUnitCellInfoText() {
        return this.modelSet.getUnitCellInfoText();
    }

    public float getUnitCellInfo(int n) {
        SymmetryInterface symmetryInterface = this.getCurrentUnitCell();
        if (symmetryInterface == null) {
            return Float.NaN;
        }
        return symmetryInterface.getUnitCellAsArray(n);
    }

    public Hashtable getSpaceGroupInfo(String string) {
        return this.modelSet.getSpaceGroupInfo(-1, string, 0, null, null, null);
    }

    public void getPolymerPointsAndVectors(BitSet bitSet, Vector vector) {
        this.modelSet.getPolymerPointsAndVectors(bitSet, vector);
    }

    public String getModelSetProperty(String string) {
        return this.modelSet.getModelSetProperty(string);
    }

    public Object getModelSetAuxiliaryInfo(String string) {
        return this.modelSet.getModelSetAuxiliaryInfo(string);
    }

    public String getModelSetPathName() {
        return this.modelManager.getModelSetPathName();
    }

    public String getModelSetTypeName() {
        return this.modelSet.getModelSetTypeName();
    }

    public boolean haveFrame() {
        return this.haveModelSet();
    }

    boolean haveModelSet() {
        return this.modelSet != null;
    }

    public void clearBfactorRange() {
        this.modelSet.clearBfactorRange();
    }

    public String getHybridizationAndAxes(int n, Vector3f vector3f, Vector3f vector3f2, String string) {
        return this.modelSet.getHybridizationAndAxes(n, vector3f, vector3f2, string, true, true);
    }

    public BitSet getMoleculeBitSet(int n) {
        return this.modelSet.getMoleculeBitSet(n);
    }

    public BitSet getModelUndeletedAtomsBitSet(int n) {
        BitSet bitSet = this.modelSet.getModelAtomBitSetIncludingDeleted(n, true);
        this.excludeAtoms(bitSet, false);
        return bitSet;
    }

    public BitSet getModelUndeletedAtomsBitSet(BitSet bitSet) {
        BitSet bitSet2 = this.modelSet.getModelAtomBitSetIncludingDeleted(bitSet);
        this.excludeAtoms(bitSet2, false);
        return bitSet2;
    }

    public void excludeAtoms(BitSet bitSet, boolean bl) {
        this.selectionManager.excludeAtoms(bitSet, bl);
    }

    public BitSet getModelBitSet(BitSet bitSet, boolean bl) {
        return this.modelSet.getModelBitSet(bitSet, bl);
    }

    public ModelSet getModelSet() {
        return this.modelSet;
    }

    public String getBoundBoxCommand(boolean bl) {
        return this.modelSet.getBoundBoxCommand(bl);
    }

    public void setBoundBox(Point3f point3f, Point3f point3f2, boolean bl, float f) {
        this.modelSet.setBoundBox(point3f, point3f2, bl, f);
    }

    public Point3f getBoundBoxCenter() {
        return this.modelSet.getBoundBoxCenter(this.animationManager.currentModelIndex);
    }

    Point3f getAverageAtomPoint() {
        return this.modelSet.getAverageAtomPoint();
    }

    public void calcBoundBoxDimensions(BitSet bitSet, float f) {
        this.modelSet.calcBoundBoxDimensions(bitSet, f);
        this.axesAreTainted = true;
    }

    public BoxInfo getBoxInfo(BitSet bitSet, float f) {
        return this.modelSet.getBoxInfo(bitSet, f);
    }

    float calcRotationRadius(Point3f point3f) {
        return this.modelSet.calcRotationRadius(this.animationManager.currentModelIndex, point3f);
    }

    public float calcRotationRadius(BitSet bitSet) {
        return this.modelSet.calcRotationRadius(bitSet);
    }

    public Vector3f getBoundBoxCornerVector() {
        return this.modelSet.getBoundBoxCornerVector();
    }

    public Point3f[] getBoundBoxVertices() {
        return this.modelSet.getBboxVertices();
    }

    Hashtable getBoundBoxInfo() {
        return this.modelSet.getBoundBoxInfo();
    }

    public BitSet getBoundBoxModels() {
        return this.modelSet.getBoundBoxModels();
    }

    public int getBoundBoxCenterX() {
        return this.dimScreen.width / 2;
    }

    public int getBoundBoxCenterY() {
        return this.dimScreen.height / 2;
    }

    public int getModelCount() {
        return this.modelSet.getModelCount();
    }

    public String getModelInfoAsString() {
        return this.modelSet.getModelInfoAsString();
    }

    public String getSymmetryInfoAsString() {
        return this.modelSet.getSymmetryInfoAsString();
    }

    public String getSymmetryOperation(String string, int n, Point3f point3f, Point3f point3f2, boolean bl) {
        return this.modelSet.getSymmetryOperation(this.animationManager.currentModelIndex, string, n, point3f, point3f2, null, bl);
    }

    public Properties getModelSetProperties() {
        return this.modelSet.getModelSetProperties();
    }

    public Hashtable getModelSetAuxiliaryInfo() {
        return this.modelSet.getModelSetAuxiliaryInfo();
    }

    public int getModelNumber(int n) {
        if (n < 0) {
            return n;
        }
        return this.modelSet.getModelNumber(n);
    }

    public int getModelFileNumber(int n) {
        if (n < 0) {
            return 0;
        }
        return this.modelSet.getModelFileNumber(n);
    }

    public String getModelNumberDotted(int n) {
        return n < 0 ? "0" : (this.modelSet == null ? null : this.modelSet.getModelNumberDotted(n));
    }

    public String getModelName(int n) {
        return this.modelSet == null ? null : this.modelSet.getModelName(n);
    }

    public Properties getModelProperties(int n) {
        return this.modelSet.getModelProperties(n);
    }

    public String getModelProperty(int n, String string) {
        return this.modelSet.getModelProperty(n, string);
    }

    public String getModelFileInfo() {
        return this.modelSet.getModelFileInfo(this.getVisibleFramesBitSet());
    }

    public String getModelFileInfoAll() {
        return this.modelSet.getModelFileInfo(null);
    }

    public Hashtable getModelAuxiliaryInfo(int n) {
        return this.modelSet.getModelAuxiliaryInfo(n);
    }

    public Object getModelAuxiliaryInfo(int n, String string) {
        return this.modelSet.getModelAuxiliaryInfo(n, string);
    }

    public int getModelNumberIndex(int n, boolean bl, boolean bl2) {
        return this.modelSet.getModelNumberIndex(n, bl, bl2);
    }

    boolean modelSetHasVibrationVectors() {
        return this.modelSet.modelSetHasVibrationVectors();
    }

    public boolean modelHasVibrationVectors(int n) {
        return this.modelSet.modelHasVibrationVectors(n);
    }

    public int getChainCount() {
        return this.modelSet.getChainCount(true);
    }

    public int getChainCountInModel(int n) {
        return this.modelSet.getChainCountInModel(n, false);
    }

    public int getChainCountInModel(int n, boolean bl) {
        return this.modelSet.getChainCountInModel(n, bl);
    }

    public int getGroupCount() {
        return this.modelSet.getGroupCount();
    }

    public int getGroupCountInModel(int n) {
        return this.modelSet.getGroupCountInModel(n);
    }

    public int getPolymerCount() {
        return this.modelSet.getBioPolymerCount();
    }

    public int getPolymerCountInModel(int n) {
        return this.modelSet.getBioPolymerCountInModel(n);
    }

    public int getAtomCount() {
        return this.modelSet.getAtomCount();
    }

    public int getAtomCountInModel(int n) {
        return this.modelSet.getAtomCountInModel(n);
    }

    public int getBondCount() {
        return this.modelSet.getBondCount();
    }

    public int getBondCountInModel(int n) {
        return this.modelSet.getBondCountInModel(n);
    }

    public BitSet getBondsForSelectedAtoms(BitSet bitSet) {
        return this.modelSet.getBondsForSelectedAtoms(bitSet, this.global.bondModeOr || BitSetUtil.cardinalityOf(bitSet) == 1);
    }

    public boolean frankClicked(int n, int n2) {
        return !this.global.disablePopupMenu && this.getShowFrank() && this.shapeManager.frankClicked(n, n2);
    }

    public boolean frankClickedModelKit(int n, int n2) {
        return !this.global.disablePopupMenu && this.isModelKitMode() && n >= 0 && n2 >= 0 && n < 40 && n2 < 80;
    }

    public int findNearestAtomIndex(int n, int n2) {
        return this.findNearestAtomIndex(n, n2, false);
    }

    public int findNearestAtomIndex(int n, int n2, boolean bl) {
        return this.modelSet == null || !this.getAtomPicking() ? -1 : this.modelSet.findNearestAtomIndex(n, n2, bl ? this.selectionManager.getMotionFixedAtoms() : null);
    }

    BitSet findAtomsInRectangle(Rectangle rectangle) {
        return this.modelSet.findAtomsInRectangle(rectangle, this.getVisibleFramesBitSet());
    }

    public void toCartesian(Point3f point3f, boolean bl) {
        SymmetryInterface symmetryInterface = this.getCurrentUnitCell();
        if (symmetryInterface != null) {
            symmetryInterface.toCartesian(point3f, bl);
        }
    }

    public void toFractional(Point3f point3f, boolean bl) {
        SymmetryInterface symmetryInterface = this.getCurrentUnitCell();
        if (symmetryInterface != null) {
            symmetryInterface.toFractional(point3f, bl);
        }
    }

    public void toUnitCell(Point3f point3f, Point3f point3f2) {
        SymmetryInterface symmetryInterface = this.getCurrentUnitCell();
        if (symmetryInterface != null) {
            symmetryInterface.toUnitCell(point3f, point3f2);
        }
    }

    public void setCurrentUnitCellOffset(int n) {
        SymmetryInterface symmetryInterface = this.getCurrentUnitCell();
        if (symmetryInterface == null) {
            return;
        }
        symmetryInterface.setOffset(n);
        this.global.setParameterValue("=frame " + this.getModelNumberDotted(this.animationManager.currentModelIndex) + "; set unitcell ", n);
    }

    public void setCurrentUnitCellOffset(Point3f point3f) {
        SymmetryInterface symmetryInterface = this.getCurrentUnitCell();
        if (symmetryInterface == null) {
            return;
        }
        symmetryInterface.setUnitCellOffset(point3f);
        this.global.setParameterValue("=frame " + this.getModelNumberDotted(this.animationManager.currentModelIndex) + "; set unitcell ", Escape.escape(point3f));
    }

    public boolean getFractionalRelative() {
        return this.global.fractionalRelative;
    }

    public void addUnitCellOffset(Point3f point3f) {
        SymmetryInterface symmetryInterface = this.getCurrentUnitCell();
        if (symmetryInterface == null) {
            return;
        }
        point3f.add(symmetryInterface.getCartesianOffset());
    }

    public void setAtomData(int n, String string, String string2, boolean bl) {
        this.modelSet.setAtomData(n, string, string2, bl);
        this.refreshMeasures(true);
    }

    public void setCenterSelected() {
        this.setCenterBitSet(this.getSelectionSet(false), true);
    }

    public boolean getApplySymmetryToBonds() {
        return this.global.applySymmetryToBonds;
    }

    void setApplySymmetryToBonds(boolean bl) {
        this.global.applySymmetryToBonds = bl;
    }

    public void setBondTolerance(float f) {
        this.global.setParameterValue("bondTolerance", f);
        this.global.bondTolerance = f;
    }

    public float getBondTolerance() {
        return this.global.bondTolerance;
    }

    public void setMinBondDistance(float f) {
        this.global.setParameterValue("minBondDistance", f);
        this.global.minBondDistance = f;
    }

    public float getMinBondDistance() {
        return this.global.minBondDistance;
    }

    public int[] getAtomIndices(BitSet bitSet) {
        return this.modelSet.getAtomIndices(bitSet);
    }

    public BitSet getAtomBits(int n, Object object) {
        return this.modelSet.getAtomBits(n, object);
    }

    public BitSet getSequenceBits(String string, BitSet bitSet) {
        return this.modelSet.getSequenceBits(string, bitSet);
    }

    public BitSet getAtomsWithin(float f, Point3f point3f) {
        BitSet bitSet = new BitSet();
        this.modelSet.getAtomsWithin(f, point3f, bitSet, -1);
        return bitSet;
    }

    public BitSet getAtomsWithin(float f, Point4f point4f) {
        return this.modelSet.getAtomsWithin(f, point4f);
    }

    public BitSet getAtomsWithin(float f, BitSet bitSet, boolean bl) {
        return this.modelSet.getAtomsWithin(f, bitSet, bl);
    }

    public BitSet getAtomsConnected(float f, float f2, int n, BitSet bitSet) {
        return this.modelSet.getAtomsConnected(f, f2, n, bitSet);
    }

    public BitSet getBranchBitSet(int n, int n2) {
        if (n < 0 || n >= this.getAtomCount()) {
            return new BitSet();
        }
        return JmolMolecule.getBranchBitSet(this.modelSet.atoms, this.getModelUndeletedAtomsBitSet(this.modelSet.atoms[n].modelIndex), n, n2, true, true);
    }

    public int getAtomIndexFromAtomNumber(int n) {
        return this.modelSet.getAtomIndexFromAtomNumber(n, this.getVisibleFramesBitSet());
    }

    public BitSet getElementsPresentBitSet(int n) {
        return this.modelSet.getElementsPresentBitSet(n);
    }

    public Hashtable getHeteroList(int n) {
        return this.modelSet.getHeteroList(n);
    }

    public BitSet getVisibleSet() {
        return this.modelSet.getVisibleSet();
    }

    public BitSet getClickableSet() {
        return this.modelSet.getClickableSet();
    }

    public void calcSelectedGroupsCount() {
        this.modelSet.calcSelectedGroupsCount(this.getSelectionSet(false));
    }

    public void calcSelectedMonomersCount() {
        this.modelSet.calcSelectedMonomersCount(this.getSelectionSet(false));
    }

    public void calcSelectedMoleculesCount() {
        this.modelSet.calcSelectedMoleculesCount(this.getSelectionSet(false));
    }

    String getFileHeader() {
        return this.modelSet.getFileHeader(this.animationManager.currentModelIndex);
    }

    Object getFileData() {
        return this.modelSet.getFileData(this.animationManager.currentModelIndex);
    }

    public Hashtable getCifData(int n) {
        String string = this.getModelFileName(n);
        String string2 = this.getFileAsString(string);
        if (string2 == null) {
            return null;
        }
        return CifDataReader.readCifData(new BufferedReader(new StringReader(string2)));
    }

    public String getPDBHeader() {
        return this.modelSet.getPDBHeader(this.animationManager.currentModelIndex);
    }

    public Hashtable getModelInfo(Object object) {
        return this.modelSet.getModelInfo(this.getModelBitSet(this.getAtomBitSet(object), false));
    }

    public Hashtable getAuxiliaryInfo(Object object) {
        return this.modelSet.getAuxiliaryInfo(this.getModelBitSet(this.getAtomBitSet(object), false));
    }

    Vector getAllAtomInfo(Object object) {
        return this.modelSet.getAllAtomInfo(this.getAtomBitSet(object));
    }

    Vector getAllBondInfo(Object object) {
        return this.modelSet.getAllBondInfo(this.getAtomBitSet(object));
    }

    Vector getMoleculeInfo(Object object) {
        return this.modelSet.getMoleculeInfo(this.getAtomBitSet(object));
    }

    public String getChimeInfo(int n) {
        return this.modelSet.getChimeInfo(n, this.getSelectionSet(true));
    }

    public Hashtable getAllChainInfo(Object object) {
        return this.modelSet.getAllChainInfo(this.getAtomBitSet(object));
    }

    public Hashtable getAllPolymerInfo(Object object) {
        return this.modelSet.getAllPolymerInfo(this.getAtomBitSet(object));
    }

    public String getWrappedState(boolean bl) {
        if (bl && !this.global.imageState || !this.global.preserveState) {
            return "";
        }
        return JmolConstants.embedScript(FileManager.setScriptFileReferences(this.getStateInfo(null), ".", null, null));
    }

    public String getStateInfo() {
        return this.getStateInfo(null);
    }

    public String getStateInfo(String string) {
        StringBuffer stringBuffer;
        if (!this.global.preserveState) {
            return "";
        }
        boolean bl = string == null || string.equalsIgnoreCase("all");
        StringBuffer stringBuffer2 = new StringBuffer("");
        StringBuffer stringBuffer3 = stringBuffer = bl ? new StringBuffer("function _setState() {\n") : null;
        if (bl) {
            stringBuffer2.append(STATE_VERSION_STAMP + Viewer.getJmolVersion() + ";\n");
        }
        if (this.isApplet && bl) {
            StateManager.appendCmd(stringBuffer2, "# fullName = " + Escape.escape(this.fullName));
            StateManager.appendCmd(stringBuffer2, "# documentBase = " + Escape.escape(this.appletDocumentBase));
            StateManager.appendCmd(stringBuffer2, "# codeBase = " + Escape.escape(this.appletCodeBase));
            stringBuffer2.append("\n");
        }
        if (bl || string.equalsIgnoreCase("windowState")) {
            stringBuffer2.append(this.global.getWindowState(stringBuffer));
        }
        if (bl || string.equalsIgnoreCase("fileState")) {
            stringBuffer2.append(this.fileManager.getState(stringBuffer));
        }
        if (bl || string.equalsIgnoreCase("definedState")) {
            stringBuffer2.append(this.modelSet.getDefinedState(stringBuffer, true));
        }
        if (bl || string.equalsIgnoreCase("variableState")) {
            stringBuffer2.append(this.global.getState(stringBuffer));
        }
        if (bl || string.equalsIgnoreCase("dataState")) {
            this.dataManager.getDataState(stringBuffer2, stringBuffer, this.modelSet.getAtomicPropertyState(-1, null));
        }
        if (bl || string.equalsIgnoreCase("modelState")) {
            stringBuffer2.append(this.modelSet.getState(stringBuffer, true, this.getBooleanProperty("saveProteinStructureState")));
        }
        if (bl || string.equalsIgnoreCase("colorState")) {
            stringBuffer2.append(ColorManager.getState(stringBuffer));
        }
        if (bl || string.equalsIgnoreCase("frameState")) {
            stringBuffer2.append(this.animationManager.getState(stringBuffer));
        }
        if (bl || string.equalsIgnoreCase("perspectiveState")) {
            stringBuffer2.append(this.transformManager.getState(stringBuffer));
        }
        if (bl || string.equalsIgnoreCase("selectionState")) {
            stringBuffer2.append(this.selectionManager.getState(stringBuffer));
        }
        if (stringBuffer != null) {
            StateManager.appendCmd(stringBuffer, "set refreshing true");
            StateManager.appendCmd(stringBuffer, "set antialiasDisplay " + this.global.antialiasDisplay);
            StateManager.appendCmd(stringBuffer, "set antialiasTranslucent " + this.global.antialiasTranslucent);
            StateManager.appendCmd(stringBuffer, "set antialiasImages " + this.global.antialiasImages);
            if (this.getSpinOn()) {
                StateManager.appendCmd(stringBuffer, "spin on");
            }
            stringBuffer.append("}\n\n_setState;\n");
        }
        if (bl) {
            stringBuffer2.append(stringBuffer);
        }
        return stringBuffer2.toString();
    }

    public String getStructureState() {
        return this.modelSet.getState(null, false, true);
    }

    public String getProteinStructureState() {
        return this.modelSet.getProteinStructureState(this.getSelectionSet(false), false, false, false);
    }

    public String getCoordinateState(BitSet bitSet) {
        return this.modelSet.getAtomicPropertyState(2, bitSet);
    }

    public void setCurrentColorRange(String string) {
        BitSet bitSet;
        float[] fArray = this.getDataFloat(string);
        BitSet bitSet2 = bitSet = fArray == null ? null : (BitSet)this.dataManager.getData(string)[2];
        if (bitSet != null && this.isRangeSelected()) {
            bitSet.and(this.getSelectionSet(false));
        }
        this.setCurrentColorRange(fArray, bitSet);
    }

    public void setCurrentColorRange(float[] fArray, BitSet bitSet) {
        this.colorManager.setCurrentColorRange(fArray, bitSet, this.global.propertyColorScheme);
    }

    public void setCurrentColorRange(float f, float f2) {
        this.colorManager.setCurrentColorRange(f, f2);
    }

    public void setData(String string, Object[] objectArray, int n, int n2, int n3, int n4, int n5) {
        this.dataManager.setData(string, objectArray, n, n2, n3, n4, n5);
    }

    public Object[] getData(String string) {
        return this.dataManager.getData(string);
    }

    public float[] getDataFloat(String string) {
        return this.dataManager.getDataFloat(string);
    }

    public float[][] getDataFloat2D(String string) {
        return this.dataManager.getDataFloat2D(string);
    }

    public float[][][] getDataFloat3D(String string) {
        return this.dataManager.getDataFloat3D(string);
    }

    public float getDataFloat(String string, int n) {
        return this.dataManager.getDataFloat(string, n);
    }

    public String getAltLocListInModel(int n) {
        return this.modelSet.getAltLocListInModel(n);
    }

    public BitSet setConformation() {
        return this.modelSet.setConformation(this.getSelectionSet(false));
    }

    public BitSet getConformation(int n, int n2, boolean bl) {
        return this.modelSet.getConformation(n, n2, bl);
    }

    public int autoHbond(BitSet bitSet, BitSet bitSet2) {
        if (bitSet == null) {
            bitSet = bitSet2 = this.getSelectionSet(false);
        }
        return this.modelSet.autoHbond(bitSet, bitSet2);
    }

    public float getHbondsAngleMin() {
        return this.global.hbondsAngleMinimum;
    }

    public float getHbondsDistanceMax() {
        return this.global.hbondsDistanceMaximum;
    }

    public boolean getHbondsRasmol() {
        return this.global.hbondsRasmol;
    }

    public boolean hasCalculatedHBonds(BitSet bitSet) {
        return this.modelSet.hasCalculatedHBonds(bitSet);
    }

    public boolean havePartialCharges() {
        return this.modelSet.getPartialCharges() != null;
    }

    public SymmetryInterface getCurrentUnitCell() {
        return this.modelSet.getUnitCell(this.animationManager.currentModelIndex);
    }

    public SymmetryInterface getModelUnitCell(int n) {
        return this.modelSet.getUnitCell(n);
    }

    public String getDefaultMeasurementLabel(int n) {
        switch (n) {
            case 2: {
                return this.global.defaultDistanceLabel;
            }
            case 3: {
                return this.global.defaultAngleLabel;
            }
        }
        return this.global.defaultTorsionLabel;
    }

    public int getMeasurementCount() {
        int n = this.getShapePropertyAsInt(6, "count");
        return n <= 0 ? 0 : n;
    }

    public String getMeasurementStringValue(int n) {
        String string = "" + this.getShapeProperty(6, "stringValue", n);
        return string;
    }

    Vector getMeasurementInfo() {
        return (Vector)this.getShapeProperty(6, "info");
    }

    public String getMeasurementInfoAsString() {
        return (String)this.getShapeProperty(6, "infostring");
    }

    public int[] getMeasurementCountPlusIndices(int n) {
        int[] nArray = (int[])this.getShapeProperty(6, "countPlusIndices", n);
        return nArray;
    }

    void setPendingMeasurement(MeasurementPending measurementPending) {
        this.setShapeProperty(6, "pending", measurementPending);
    }

    MeasurementPending getPendingMeasurement() {
        return (MeasurementPending)this.getShapeProperty(6, "pending");
    }

    public void clearAllMeasurements() {
        this.setShapeProperty(6, "clear", null);
    }

    public void clearMeasurements() {
        this.evalString("measures delete");
    }

    public boolean getJustifyMeasurements() {
        return this.global.justifyMeasurements;
    }

    public void setAnimation(int n) {
        switch (n) {
            case 1073742098: {
                this.animationManager.reverseAnimation();
            }
            case 266286: 
            case 0x40000110: {
                if (!this.animationManager.animationOn) {
                    this.animationManager.resumeAnimation();
                }
                return;
            }
            case 20486: {
                if (this.animationManager.animationOn && !this.animationManager.animationPaused) {
                    this.animationManager.pauseAnimation();
                }
                return;
            }
            case 1073742034: {
                this.animationManager.setAnimationNext();
                return;
            }
            case 1073742108: {
                this.animationManager.setAnimationPrevious();
                return;
            }
            case 1073741942: 
            case 1073742126: {
                this.animationManager.rewindAnimation();
                return;
            }
            case 0x400000AA: {
                this.animationManager.setAnimationLast();
                return;
            }
        }
    }

    public void setAnimationDirection(int n) {
        this.animationManager.setAnimationDirection(n);
    }

    int getAnimationDirection() {
        return this.animationManager.animationDirection;
    }

    Hashtable getAnimationInfo() {
        return this.animationManager.getAnimationInfo();
    }

    public void setAnimationFps(int n) {
        if (n < 1) {
            n = 1;
        }
        if (n > 50) {
            n = 50;
        }
        this.global.setParameterValue("animationFps", n);
        this.animationManager.setAnimationFps(n);
    }

    public int getAnimationFps() {
        return this.animationManager.animationFps;
    }

    public void setAnimationReplayMode(int n, float f, float f2) {
        this.animationManager.setAnimationReplayMode(n, f, f2);
    }

    int getAnimationReplayMode() {
        return this.animationManager.animationReplayMode;
    }

    public void setAnimationOn(boolean bl) {
        boolean bl2 = this.animationManager.animationOn;
        if (bl == bl2) {
            return;
        }
        this.animationManager.setAnimationOn(bl);
    }

    public void setAnimationRange(int n, int n2) {
        this.animationManager.setAnimationRange(n, n2);
    }

    public BitSet getVisibleFramesBitSet() {
        BitSet bitSet = BitSetUtil.copy(this.animationManager.getVisibleFramesBitSet());
        this.modelSet.selectDisplayedTrajectories(bitSet);
        return bitSet;
    }

    boolean isAnimationOn() {
        return this.animationManager.animationOn;
    }

    public void setCurrentModelIndex(int n) {
        if (n == Integer.MIN_VALUE) {
            this.prevFrame = Integer.MIN_VALUE;
            this.setCurrentModelIndex(this.animationManager.currentModelIndex, true);
            return;
        }
        this.animationManager.setCurrentModelIndex(n);
    }

    void setTrajectory(int n) {
        this.modelSet.setTrajectory(n);
    }

    public void setTrajectory(BitSet bitSet) {
        this.modelSet.setTrajectory(bitSet);
    }

    public boolean isTrajectory(int n) {
        return this.modelSet.isTrajectory(n);
    }

    public BitSet getBitSetTrajectories() {
        return this.modelSet.getBitSetTrajectories();
    }

    public String getTrajectoryInfo() {
        return this.modelSet.getTrajectoryInfo();
    }

    void setFrameOffset(int n) {
        this.transformManager.setFrameOffset(n);
    }

    public void setFrameOffsets(BitSet bitSet) {
        this.bsFrameOffsets = bitSet;
        this.frameOffsets = this.modelSet.getFrameOffsets(this.bsFrameOffsets);
        this.transformManager.setFrameOffsets(this.frameOffsets);
    }

    public BitSet getFrameOffsets() {
        return this.bsFrameOffsets;
    }

    public void setCurrentModelIndex(int n, boolean bl) {
        this.animationManager.setCurrentModelIndex(n, bl);
    }

    public int getCurrentModelIndex() {
        return this.animationManager.currentModelIndex;
    }

    public int getDisplayModelIndex() {
        return this.animationManager.currentModelIndex;
    }

    public boolean haveFileSet() {
        return this.getModelCount() > 1 && this.getModelNumber(0) > 1000000;
    }

    public void setBackgroundModelIndex(int n) {
        this.animationManager.setBackgroundModelIndex(n);
        this.global.setParameterValue("backgroundModel", this.modelSet.getModelNumberDotted(n));
    }

    void setFrameVariables(int n, int n2) {
        this.global.setParameterValue("_firstFrame", this.getModelNumberDotted(n));
        this.global.setParameterValue("_lastFrame", this.getModelNumberDotted(n2));
    }

    public int getMotionEventNumber() {
        return this.motionEventNumber;
    }

    void setInMotion(boolean bl) {
        if (this.wasInMotion ^ bl) {
            this.animationManager.setInMotion(bl);
            if (bl) {
                ++this.motionEventNumber;
            } else {
                this.refresh(3, "viewer stInMotion " + bl);
            }
            this.wasInMotion = bl;
        }
    }

    public boolean getInMotion() {
        return this.animationManager.inMotion;
    }

    public void pushHoldRepaint() {
        this.pushHoldRepaint(null);
    }

    public void pushHoldRepaint(String string) {
        this.repaintManager.pushHoldRepaint();
    }

    public void popHoldRepaint() {
        this.repaintManager.popHoldRepaint(true);
    }

    public void popHoldRepaint(String string) {
        this.repaintManager.popHoldRepaint(!string.equals("pause"));
    }

    private void setRefreshing(boolean bl) {
        this.refreshing = bl;
    }

    public boolean getRefreshing() {
        return this.refreshing;
    }

    public void refresh(int n, String string) {
        if (n == 6 && this.getInMotion()) {
            return;
        }
        if (this.repaintManager == null || !this.refreshing) {
            return;
        }
        if (n > 0) {
            this.repaintManager.refresh();
        }
        if (n % 3 != 0 && this.statusManager.doSync()) {
            this.statusManager.setSync(n == 2 ? string : null);
        }
    }

    public void requestRepaintAndWait() {
        if (!this.haveDisplay) {
            return;
        }
        this.repaintManager.requestRepaintAndWait();
        if (this.statusManager.doSync()) {
            this.statusManager.setSync(null);
        }
    }

    void setSync() {
        if (this.statusManager.doSync()) {
            this.statusManager.setSync(null);
        }
    }

    public void notifyViewerRepaintDone() {
        this.repaintManager.repaintDone();
    }

    public boolean areAxesTainted() {
        boolean bl = this.axesAreTainted;
        this.axesAreTainted = false;
        return bl;
    }

    private void setMaximumSize(int n) {
        this.maximumSize = Math.max(n, 100);
    }

    public void setScreenDimension(Dimension dimension) {
        dimension.height = Math.min(dimension.height, this.maximumSize);
        dimension.width = Math.min(dimension.width, this.maximumSize);
        int n = dimension.height;
        int n2 = dimension.width;
        if (this.transformManager.stereoMode == 1) {
            n2 = (n2 + 1) / 2;
        }
        if (this.dimScreen.width == n2 && this.dimScreen.height == n) {
            return;
        }
        this.resizeImage(n2, n, false, false, true);
    }

    public float getImageFontScaling() {
        return this.imageFontScaling;
    }

    private void resizeImage(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        if (!bl && this.creatingImage) {
            return;
        }
        boolean bl4 = bl3 ? this.global.antialiasDisplay : (this.antialiasDisplay = bl && !bl2 ? this.global.antialiasImages : false);
        this.imageFontScaling = (bl3 || n <= 0 ? 1 : (this.global.zoomLarge == n2 > n ? n2 : n) / this.getScreenDim()) * (this.antialiasDisplay ? 2 : 1);
        if (n > 0) {
            this.dimScreen.width = n;
            this.dimScreen.height = n2;
            if (!bl) {
                this.global.setParameterValue("_width", n);
                this.global.setParameterValue("_height", n2);
                this.setStatusResized(n, n2);
            }
        } else {
            n = this.dimScreen.width;
            n2 = this.dimScreen.height;
        }
        this.transformManager.setScreenParameters(n, n2, bl || bl3 ? this.global.zoomLarge : false, this.antialiasDisplay, false, false);
        this.g3d.setWindowParameters(n, n2, this.antialiasDisplay);
    }

    public int getScreenWidth() {
        return this.dimScreen.width;
    }

    public int getScreenHeight() {
        return this.dimScreen.height;
    }

    public int getScreenDim() {
        return this.global.zoomLarge == this.dimScreen.height > this.dimScreen.width ? this.dimScreen.height : this.dimScreen.width;
    }

    public String generateOutput(String string, String[] stringArray, int n, int n2) {
        if (this.isDataOnly) {
            return "";
        }
        String string2 = null;
        if (stringArray != null) {
            stringArray[0] = this.getFileNameFromDialog(stringArray[0], Integer.MIN_VALUE);
            if (stringArray[0] == null) {
                return null;
            }
            string2 = stringArray[0];
        }
        this.mustRender = true;
        int n3 = this.dimScreen.width;
        int n4 = this.dimScreen.height;
        this.resizeImage(n, n2, true, true, false);
        this.setModelVisibility();
        this.finalizeTransformParameters();
        String string3 = this.repaintManager.generateOutput(string, this.g3d, this.modelSet, string2);
        this.resizeImage(n3, n4, true, true, true);
        return string3;
    }

    public void renderScreenImage(Graphics graphics, Graphics graphics2, Dimension dimension, Rectangle rectangle) {
        if (!this.creatingImage) {
            if (this.isTainted || this.getSlabEnabled()) {
                this.setModelVisibility();
            }
            this.isTainted = false;
            if (dimension != null) {
                this.setScreenDimension(dimension);
            }
            if (graphics2 == null) {
                Image image = this.getScreenImage();
                if (this.transformManager.stereoMode == 1) {
                    this.render1(graphics, image, this.dimScreen.width, 0);
                    image = this.getImage(false);
                }
                this.render1(graphics, image, 0, 0);
            } else {
                this.render1(graphics2, this.getImage(true), 0, 0);
                this.render1(graphics, this.getImage(false), 0, 0);
            }
        }
        this.notifyViewerRepaintDone();
    }

    public void renderScreenImage(Graphics graphics, Dimension dimension, Rectangle rectangle) {
        this.renderScreenImage(graphics, null, dimension, rectangle);
    }

    private Image getImage(boolean bl) {
        Image image = null;
        try {
            this.g3d.beginRendering(this.transformManager.getStereoRotationMatrix(bl));
            this.render();
            this.g3d.endRendering();
            image = this.g3d.getScreenImage();
        }
        catch (Error error) {
            this.handleError(error, false);
            this.setErrorMessage("Error during rendering: " + error);
        }
        return image;
    }

    private void render() {
        boolean bl = this.antialiasDisplay && this.global.antialiasTranslucent;
        this.repaintManager.render(this.g3d, this.modelSet);
        if (this.g3d.setPass2(bl)) {
            this.transformManager.setAntialias(bl);
            this.repaintManager.render(this.g3d, this.modelSet);
            this.transformManager.setAntialias(this.antialiasDisplay);
        }
    }

    private Image getStereoImage(int n) {
        this.g3d.beginRendering(this.transformManager.getStereoRotationMatrix(true));
        this.render();
        this.g3d.endRendering();
        this.g3d.snapshotAnaglyphChannelBytes();
        this.g3d.beginRendering(this.transformManager.getStereoRotationMatrix(false));
        this.render();
        this.g3d.endRendering();
        switch (n) {
            case 2: {
                this.g3d.applyCyanAnaglyph();
                break;
            }
            case 5: {
                this.g3d.applyCustomAnaglyph(this.transformManager.stereoColors);
                break;
            }
            case 3: {
                this.g3d.applyBlueAnaglyph();
                break;
            }
            default: {
                this.g3d.applyGreenAnaglyph();
            }
        }
        return this.g3d.getScreenImage();
    }

    private void render1(Graphics graphics, Image image, int n, int n2) {
        if (graphics != null && image != null) {
            try {
                graphics.drawImage(image, n, n2, null);
            }
            catch (NullPointerException nullPointerException) {
                Logger.error("Sun!! ... fix graphics your bugs!");
            }
        }
        this.g3d.releaseScreenImage();
    }

    public Image getScreenImage() {
        return this.transformManager.stereoMode <= 1 ? this.getImage(this.transformManager.stereoMode == 1) : this.getStereoImage(this.transformManager.stereoMode);
    }

    public Object getImageAs(String string, int n, int n2, int n3, String string2, OutputStream outputStream) {
        return this.getImageAs(string, n, n2, n3, string2, outputStream, "");
    }

    Object getImageAs(String string, int n, int n2, int n3, String string2, OutputStream outputStream, String string3) {
        int n4 = this.dimScreen.width;
        int n5 = this.dimScreen.height;
        this.mustRender = true;
        this.resizeImage(n2, n3, true, false, false);
        this.setModelVisibility();
        this.creatingImage = true;
        JmolImageCreatorInterface jmolImageCreatorInterface = null;
        Object object = null;
        string = string.toLowerCase();
        if (!Parser.isOneOf(string, "jpg;jpeg;jpg64;jpeg64")) {
            try {
                jmolImageCreatorInterface = (JmolImageCreatorInterface)Interface.getOptionInterface("export.image.ImageCreator");
            }
            catch (Error error) {
                // empty catch block
            }
        }
        if (jmolImageCreatorInterface == null) {
            Image image = this.getScreenImage();
            if (image != null) {
                try {
                    if (n < 0) {
                        n = 75;
                    }
                    object = JpegEncoder.getBytes(image, n, string3);
                    this.releaseScreenImage();
                    if (string.equals("jpg64") || string.equals("jpeg64")) {
                        object = object == null ? "" : Base64.getBase64((byte[])object).toString();
                    }
                }
                catch (Error error) {
                    this.releaseScreenImage();
                    this.handleError(error, false);
                    this.setErrorMessage("Error creating image: " + error);
                    object = this.getErrorMessage();
                }
            }
        } else {
            jmolImageCreatorInterface.setViewer(this, this.privateKey);
            try {
                object = jmolImageCreatorInterface.getImageBytes(string, n, string2, null, outputStream);
            }
            catch (IOException iOException) {
                object = iOException;
                this.setErrorMessage("Error creating image: " + iOException);
            }
            catch (Error error) {
                this.handleError(error, false);
                this.setErrorMessage("Error creating image: " + error);
                object = this.getErrorMessage();
            }
        }
        this.creatingImage = false;
        this.resizeImage(n4, n5, true, false, true);
        return object;
    }

    public void releaseScreenImage() {
        this.g3d.releaseScreenImage();
    }

    public boolean getAllowEmbeddedScripts() {
        return this.global.allowEmbeddedScripts;
    }

    public String evalFile(String string) {
        int n = string.indexOf(" -noqueue");
        if (n >= 0) {
            return (String)this.evalStringWaitStatus("String", string.substring(0, n), "", true, false, false);
        }
        return this.scriptManager.addScript(string, true, false);
    }

    public String getInterruptScript() {
        String string = this.interruptScript;
        this.interruptScript = "";
        if (Logger.debugging && string != "") {
            Logger.debug("interrupt: " + string);
        }
        return string;
    }

    public String script(String string) {
        return this.evalString(string);
    }

    public String evalString(String string) {
        return this.evalStringQuiet(string, false, true);
    }

    public String evalStringQuiet(String string) {
        return this.evalStringQuiet(string, true, true);
    }

    String evalStringQuiet(String string, boolean bl, boolean bl2) {
        String string2;
        boolean bl3;
        if (bl2 && this.statusManager.syncingScripts && string.indexOf("#NOSYNC;") < 0) {
            this.syncScript(string + " #NOSYNC;", null);
        }
        if (this.eval.isExecutionPaused() && string.charAt(0) != '!') {
            string = '!' + TextFormat.trim(string, "\n\r\t ");
        }
        boolean bl4 = bl3 = string.length() > 0 && string.charAt(0) == '!';
        if (bl3) {
            string = string.substring(1);
        }
        if ((string2 = this.checkScriptExecution(string, bl3)) != null) {
            return string2;
        }
        if (this.isScriptExecuting() && (bl3 || this.eval.isExecutionPaused())) {
            this.interruptScript = string;
            if (string.indexOf("moveto ") == 0) {
                this.scriptManager.flushQueue("moveto ");
            }
            return "!" + string;
        }
        this.interruptScript = "";
        if (bl) {
            string = string + "\u0001## EDITOR_IGNORE ##";
        }
        return this.scriptManager.addScript(string, false, bl && !this.getMessageStyleChime());
    }

    private String checkScriptExecution(String string, boolean bl) {
        String string2 = string;
        if (string2.indexOf("\u0001##") >= 0) {
            string2 = string2.substring(0, string2.indexOf("\u0001##"));
        }
        if (this.checkResume(string2)) {
            return "script processing resumed";
        }
        if (this.checkStepping(string2)) {
            return "script processing stepped";
        }
        if (this.checkHalt(string2, bl)) {
            return "script execution halted";
        }
        if (this.checkUndo(string2)) {
            return "OK - " + string2;
        }
        return null;
    }

    private boolean checkUndo(String string) {
        if (string.equalsIgnoreCase("redo")) {
            this.undoAction(false, 0, -1);
        } else if (string.equalsIgnoreCase("undo")) {
            this.undoAction(false, 0, 1);
        } else {
            return false;
        }
        return true;
    }

    public boolean usingScriptQueue() {
        return this.global.useScriptQueue;
    }

    public void clearScriptQueue() {
        this.scriptManager.clearQueue();
    }

    private void setScriptQueue(boolean bl) {
        this.global.useScriptQueue = bl;
        if (!bl) {
            this.clearScriptQueue();
        }
    }

    public boolean checkResume(String string) {
        if (string.equalsIgnoreCase("resume")) {
            this.scriptStatus("", "execution resumed", 0, null);
            this.resumeScriptExecution();
            return true;
        }
        return false;
    }

    public boolean checkStepping(String string) {
        if (string.equalsIgnoreCase("step")) {
            this.stepScriptExecution();
            return true;
        }
        if (string.equalsIgnoreCase("?")) {
            this.scriptStatus(this.eval.getNextStatement());
            return true;
        }
        return false;
    }

    public boolean checkHalt(String string, boolean bl) {
        if (string.equalsIgnoreCase("pause")) {
            this.pauseScriptExecution();
            if (this.scriptEditorVisible) {
                this.scriptStatus("", "paused -- type RESUME to continue", 0, null);
            }
            return true;
        }
        string = string.toLowerCase();
        boolean bl2 = false;
        String string2 = null;
        if (string.startsWith("exit")) {
            this.haltScriptExecution();
            this.clearScriptQueue();
            this.clearTimeout(null);
            string2 = "exit";
            bl2 = string.equals("exit");
        } else if (string.startsWith("quit")) {
            this.haltScriptExecution();
            string2 = "quit";
            bl2 = string.equals("quit");
        }
        if (string2 == null) {
            return false;
        }
        if (bl) {
            this.transformManager.setSpinOn(false);
            this.stopMinimization();
        }
        if (bl || this.waitForMoveTo()) {
            this.stopMotion();
        }
        Logger.info(this.isCmdLine_c_or_C_Option ? string2 + " -- stops script checking" : (bl ? "!" : "") + string2 + " received");
        this.isCmdLine_c_or_C_Option = false;
        return bl2;
    }

    public String scriptWait(String string) {
        this.scriptManager.waitForQueue();
        boolean bl = GT.getDoTranslate();
        GT.setDoTranslate(false);
        String string2 = (String)this.evalStringWaitStatus("JSON", string, "+scriptStarted,+scriptStatus,+scriptEcho,+scriptTerminated", false, false, false);
        GT.setDoTranslate(bl);
        return string2;
    }

    public Object scriptWaitStatus(String string, String string2) {
        this.scriptManager.waitForQueue();
        boolean bl = GT.getDoTranslate();
        GT.setDoTranslate(false);
        Object object = this.evalStringWaitStatus("object", string, string2, false, false, false);
        GT.setDoTranslate(bl);
        return object;
    }

    public Object evalStringWaitStatus(String string, String string2, String string3) {
        this.scriptManager.waitForQueue();
        return this.evalStringWaitStatus(string, string2, string3, false, false, false);
    }

    synchronized Object evalStringWaitStatus(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        if (string2 == null) {
            return null;
        }
        String string4 = this.checkScriptExecution(string2, false);
        if (string4 != null) {
            return string4;
        }
        String string5 = this.statusManager.getStatusList();
        this.getProperty("String", "jmolStatus", string3);
        if (this.isCmdLine_c_or_C_Option) {
            Logger.info("--checking script:\n" + this.eval.getScript() + "\n----\n");
        }
        boolean bl5 = bl4 = string2.indexOf(")") == 0;
        if (bl4) {
            string2 = string2.substring(1);
        }
        bl4 = bl4 || !bl3;
        this.setErrorMessage(null);
        boolean bl6 = bl ? this.eval.compileScriptFile(string2, bl2) : this.eval.compileScriptString(string2, bl2);
        String string6 = this.eval.getErrorMessage();
        String string7 = this.eval.getErrorMessageUntranslated();
        this.setErrorMessage(string6, string7);
        if (bl6) {
            this.isScriptQueued = bl3;
            if (!bl2) {
                this.scriptStatus(null, string2, -2 - ++this.scriptIndex, null);
            }
            this.eval.evaluateCompiledScript(this.isCmdLine_c_or_C_Option, this.isCmdLine_C_Option, bl4, this.listCommands);
            string6 = this.eval.getErrorMessage();
            string7 = this.eval.getErrorMessageUntranslated();
            this.setErrorMessage(string6, string7);
            if (!bl2) {
                this.scriptStatus("Jmol script terminated", string6, 1 + this.eval.getExecutionWalltime(), string7);
            }
        } else {
            this.scriptStatus(string6);
            this.scriptStatus("Jmol script terminated", string6, 1, string7);
        }
        this.setStateScriptVersion(null);
        if (string6 != null && this.autoExit) {
            this.exitJmol();
        }
        if (this.isCmdLine_c_or_C_Option) {
            if (string6 == null) {
                Logger.info("--script check ok");
            } else {
                Logger.error("--script check error\n" + string7);
            }
        }
        if (this.isCmdLine_c_or_C_Option) {
            Logger.info("(use 'exit' to stop checking)");
        }
        this.isScriptQueued = true;
        if (string.equalsIgnoreCase("String")) {
            return string7;
        }
        Object object = this.getProperty(string, "jmolStatus", string3);
        this.getProperty("object", "jmolStatus", string5);
        return object;
    }

    public void exitJmol() {
        Logger.debug("exitJmol -- exiting");
        System.out.flush();
        System.exit(0);
    }

    private Object scriptCheck(String string, boolean bl) {
        if (string.indexOf(")") == 0 || string.indexOf("!") == 0) {
            string = string.substring(1);
        }
        ScriptContext scriptContext = new ScriptEvaluator(this).checkScriptSilent(string);
        if (bl || scriptContext.errorMessage == null) {
            return scriptContext;
        }
        return scriptContext.errorMessage;
    }

    public synchronized Object scriptCheck(String string) {
        return this.scriptCheck(string, false);
    }

    public boolean isScriptExecuting() {
        return this.eval.isScriptExecuting();
    }

    public void haltScriptExecution() {
        this.eval.haltExecution();
    }

    public void resumeScriptExecution() {
        this.eval.resumePausedExecution();
    }

    public void stepScriptExecution() {
        this.eval.stepPausedExecution();
    }

    public void pauseScriptExecution() {
        this.eval.pauseExecution(true);
    }

    public String getDefaultLoadFilter() {
        return this.global.defaultLoadFilter;
    }

    public String getDefaultLoadScript() {
        return this.global.defaultLoadScript;
    }

    public Object setLoadFormat(String string, char c, boolean bl) {
        String string2 = string.substring(1);
        switch (c) {
            case '=': {
                String string3 = this.global.loadFormat;
                if (string2.indexOf(".") > 0 && string3.indexOf("%FILE.") >= 0) {
                    string3 = string3.substring(0, string3.indexOf("%FILE") + 5);
                }
                return TextFormat.formatString(string3, "FILE", string2);
            }
            case '$': {
                string2 = TextFormat.simpleReplace(string2, "%", "%25");
                string2 = TextFormat.simpleReplace(string2, " ", "%20");
                return (bl ? "MOL::" : "") + TextFormat.formatString(this.global.smilesUrlFormat, "FILE", string2);
            }
            case '_': {
                String string4 = FileManager.fixFileNameVariables(this.global.edsUrlFormat, string2);
                String string5 = FileManager.fixFileNameVariables(this.global.edsUrlCutoff, string2);
                return new String[]{string4, string5};
            }
        }
        return string.substring(1);
    }

    public String[] getElectronDensityLoadInfo() {
        return new String[]{this.global.edsUrlFormat, this.global.edsUrlCutoff, this.global.edsUrlOptions};
    }

    public String getStandardLabelFormat() {
        return this.stateManager.getStandardLabelFormat();
    }

    public int getRibbonAspectRatio() {
        return this.global.ribbonAspectRatio;
    }

    public float getSheetSmoothing() {
        return this.global.sheetSmoothing;
    }

    public boolean getSsbondsBackbone() {
        return this.global.ssbondsBackbone;
    }

    public boolean getHbondsBackbone() {
        return this.global.hbondsBackbone;
    }

    public boolean getHbondsSolid() {
        return this.global.hbondsSolid;
    }

    public Point3f[] getAdditionalHydrogens(BitSet bitSet, boolean bl, boolean bl2, Vector vector) {
        if (bitSet == null) {
            bitSet = this.getSelectionSet(false);
        }
        int[] nArray = new int[1];
        Point3f[][] point3fArray = this.modelSet.calculateHydrogens(bitSet, nArray, bl, bl2, vector);
        Point3f[] point3fArray2 = new Point3f[nArray[0]];
        int n = 0;
        for (int i = 0; i < point3fArray.length; ++i) {
            if (point3fArray[i] == null) continue;
            for (int j = 0; j < point3fArray[i].length; ++j) {
                point3fArray2[n++] = point3fArray[i][j];
            }
        }
        return point3fArray2;
    }

    public BitSet addHydrogens(BitSet bitSet, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = bitSet == null;
        if (bitSet == null) {
            bitSet = this.getModelUndeletedAtomsBitSet(this.getVisibleFramesBitSet().length() - 1);
        }
        BitSet bitSet2 = new BitSet();
        if (bitSet.cardinality() == 0) {
            return bitSet2;
        }
        short s = this.modelSet.atoms[bitSet.nextSetBit((int)0)].modelIndex;
        if (s != this.modelSet.getModelCount() - 1) {
            return bitSet2;
        }
        Vector vector = new Vector();
        Point3f[] point3fArray = this.getAdditionalHydrogens(bitSet, bl3, false, vector);
        boolean bl5 = false;
        bl5 = this.getAppendNew();
        if (point3fArray.length > 0) {
            this.clearModelDependentObjects();
            try {
                bitSet2 = bl ? this.modelSet.addHydrogens(vector, point3fArray) : this.addHydrogensInline(bitSet, vector, point3fArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (bl5) {
                this.setAppendNew(true);
            }
        }
        if (!bl2) {
            this.scriptStatus(GT._("{0} hydrogens added", point3fArray.length));
        }
        return bitSet2;
    }

    public BitSet addHydrogensInline(BitSet bitSet, Vector vector, Point3f[] point3fArray) throws Exception {
        int n = this.getAtomModelIndex(bitSet.nextSetBit(0));
        if (n != this.modelSet.getModelCount() - 1) {
            return new BitSet();
        }
        BitSet bitSet2 = this.getModelUndeletedAtomsBitSet(n);
        this.setAppendNew(false);
        int n2 = this.modelSet.getAtomCount();
        int n3 = this.modelSet.getAtomCountInModel(n);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            Atom atom = (Atom)vector.get(i);
            stringBuffer.append(";  connect 0 100 ").append("({" + n2++ + "}) ").append("({" + atom.index + "});");
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(point3fArray.length).append("\nViewer.AddHydrogens#noautobond");
        stringBuffer2.append("\n");
        for (int i = 0; i < point3fArray.length; ++i) {
            stringBuffer2.append("H ").append(point3fArray[i].x).append(" ").append(point3fArray[i].y).append(" ").append(point3fArray[i].z).append(" - - - - ").append(++n3).append('\n');
        }
        this.loadInline(stringBuffer2.toString(), '\n', true, null);
        this.eval.runScript(stringBuffer.toString(), null);
        BitSet bitSet3 = this.getModelUndeletedAtomsBitSet(n);
        bitSet3.andNot(bitSet2);
        return bitSet3;
    }

    public void setMarBond(short s) {
        this.global.bondRadiusMilliAngstroms = s;
        this.global.setParameterValue("bondRadiusMilliAngstroms", s);
        this.setShapeSize(1, s * 2, BitSetUtil.setAll(this.getAtomCount()));
    }

    public boolean isHoverEnabled() {
        return this.hoverEnabled;
    }

    public void setHoverLabel(String string) {
        this.loadShape(32);
        this.setShapeProperty(32, "label", string);
        this.hoverEnabled = string != null;
    }

    void hoverOn(int n, int n2) {
        this.setStatusAtomHovered(n, this.getAtomInfoXYZ(n, false));
        if (!this.hoverEnabled) {
            return;
        }
        if (this.isModelKitMode()) {
            if (this.isAtomAssignable(n)) {
                this.highlight(BitSetUtil.setBit(n));
            }
            this.refresh(3, "hover on atom");
            return;
        }
        if (this.eval != null && this.isScriptExecuting() || n == this.hoverAtomIndex || this.global.hoverDelayMs == 0) {
            return;
        }
        if (!this.isInSelectionSubset(n)) {
            return;
        }
        this.loadShape(32);
        if (this.isBound(n2, 29) && this.getPickingMode() == 2 && this.modelSet.atoms[n].isShapeVisible(JmolConstants.getShapeVisibilityFlag(5))) {
            this.setShapeProperty(32, "specialLabel", GT._("Drag to move label"));
        }
        this.setShapeProperty(32, "text", null);
        this.setShapeProperty(32, "target", new Integer(n));
        this.hoverText = null;
        this.hoverAtomIndex = n;
        this.refresh(3, "hover on atom");
    }

    int getHoverDelay() {
        return this.global.modelKitMode ? 20 : this.global.hoverDelayMs;
    }

    public void hoverOn(int n, int n2, String string) {
        if (!this.isHoverEnabled()) {
            return;
        }
        if (this.eval != null && this.isScriptExecuting()) {
            return;
        }
        this.loadShape(32);
        this.setShapeProperty(32, "xy", new Point3i(n, n2, 0));
        this.setShapeProperty(32, "target", null);
        this.setShapeProperty(32, "specialLabel", null);
        this.setShapeProperty(32, "text", string);
        this.hoverAtomIndex = -1;
        this.hoverText = string;
        this.refresh(3, "hover on point");
    }

    void hoverOff() {
        boolean bl;
        if (this.isModelKitMode()) {
            this.highlight(null);
        }
        if (!this.isHoverEnabled()) {
            return;
        }
        boolean bl2 = bl = this.hoverText != null || this.hoverAtomIndex >= 0;
        if (this.hoverAtomIndex >= 0) {
            this.setShapeProperty(32, "target", null);
            this.hoverAtomIndex = -1;
        }
        if (this.hoverText != null) {
            this.setShapeProperty(32, "text", null);
            this.hoverText = null;
        }
        this.setShapeProperty(32, "specialLabel", null);
        if (bl) {
            this.refresh(3, "hover off");
        }
    }

    public void clearShapeRenderers() {
        this.repaintManager.clear();
    }

    public int getBfactor100Hi() {
        return this.modelSet.getBfactor100Hi();
    }

    short getColix(Object object) {
        return Graphics3D.getColix(object);
    }

    public boolean getRasmolSetting(int n) {
        switch (n) {
            case 1613758476: {
                return this.global.rasmolHydrogenSetting;
            }
            case 0x60300006: {
                return this.global.rasmolHeteroSetting;
            }
        }
        return false;
    }

    public boolean getDebugScript() {
        return this.global.debugScript;
    }

    public void setDebugScript(boolean bl) {
        this.global.debugScript = bl;
        this.global.setParameterValue("debugScript", bl);
        this.eval.setDebugging();
    }

    void clearClickCount() {
        this.setTainted(true);
    }

    public int getCursor() {
        return this.currentCursor;
    }

    public void setCursor(int n) {
        int n2;
        if (this.multiTouch || this.currentCursor == n || !this.haveDisplay) {
            return;
        }
        this.currentCursor = n;
        switch (this.currentCursor) {
            case 1: {
                n2 = 12;
                break;
            }
            case 3: {
                n2 = 13;
                break;
            }
            case 5: {
                n2 = 8;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
            default: {
                this.display.setCursor(Cursor.getDefaultCursor());
                return;
            }
        }
        this.display.setCursor(Cursor.getPredefinedCursor(n2));
    }

    void setPickingMode(String string, int n) {
        if (!this.haveDisplay) {
            return;
        }
        String string2 = null;
        if (string != null) {
            int n2 = string.indexOf("_");
            if (n2 >= 0) {
                string2 = string.substring(n2 + 1);
                string = string.substring(0, n2);
            }
            n = ActionManager.getPickingMode(string);
        }
        if (n < 0) {
            n = 1;
        }
        this.actionManager.setPickingMode(n);
        this.global.setParameterValue("picking", ActionManager.getPickingModeName(this.actionManager.getAtomPickingMode()));
        if (string2 == null || string2.length() == 0) {
            return;
        }
        string2 = Character.toUpperCase(string2.charAt(0)) + (string2.length() == 1 ? "" : string2.substring(1, 2));
        switch (n) {
            case 31: {
                this.setAtomPickingOption(string2);
                break;
            }
            case 32: {
                this.setBondPickingOption(string2);
                break;
            }
            default: {
                Logger.error("Bad picking mode: " + string + "_" + string2);
            }
        }
    }

    public int getPickingMode() {
        return this.haveDisplay ? this.actionManager.getAtomPickingMode() : 0;
    }

    public boolean getDrawPicking() {
        return this.global.drawPicking;
    }

    public boolean isModelKitMode() {
        return this.global.modelKitMode;
    }

    public boolean getBondPicking() {
        return this.global.bondPicking || this.global.modelKitMode;
    }

    private boolean getAtomPicking() {
        return this.global.atomPicking;
    }

    void setPickingStyle(String string, int n) {
        if (!this.haveDisplay) {
            return;
        }
        if (string != null) {
            n = ActionManager.getPickingStyle(string);
        }
        if (n < 0) {
            n = 0;
        }
        this.actionManager.setPickingStyle(n);
        this.global.setParameterValue("pickingStyle", ActionManager.getPickingStyleName(this.actionManager.getPickingStyle()));
    }

    public boolean getDrawHover() {
        return this.haveDisplay && this.global.drawHover;
    }

    public String getAtomInfo(int n) {
        return n >= 0 ? this.modelSet.getAtomInfo(n, null) : (String)this.shapeManager.getShapeProperty(6, "pointInfo", -n);
    }

    public String getAtomInfoXYZ(int n, boolean bl) {
        return this.modelSet.getAtomInfoXYZ(n, bl);
    }

    public void setJmolCallbackListener(JmolCallbackListener jmolCallbackListener) {
        this.statusManager.setJmolCallbackListener(jmolCallbackListener);
    }

    public void setJmolStatusListener(JmolStatusListener jmolStatusListener) {
        this.statusManager.setJmolStatusListener(jmolStatusListener, null);
    }

    public Hashtable getMessageQueue() {
        return this.statusManager.getMessageQueue();
    }

    Vector getStatusChanged(String string) {
        return this.statusManager.getStatusChanged(string);
    }

    public boolean menuEnabled() {
        return !this.global.disablePopupMenu;
    }

    void popupMenu(int n, int n2, char c) {
        if (!this.haveDisplay || !this.refreshing || this.isPreviewOnly || this.global.disablePopupMenu) {
            return;
        }
        switch (c) {
            case 'j': {
                if (this.jmolpopup == null) {
                    this.jmolpopup = JmolPopup.newJmolPopup(this, true, this.menuStructure, true);
                }
                this.jmolpopup.show(n, n2);
                break;
            }
            case 'a': 
            case 'b': 
            case 'm': {
                if (this.modelkit == null) {
                    this.modelkit = (JmolModelKitInterface)Interface.getOptionInterface("modelkit.ModelKit");
                    if (this.modelkit == null) {
                        return;
                    }
                    this.modelkit = this.modelkit.getModelKit(this, this.display);
                    this.modelkit.getMenus(true);
                }
                this.modelkit.show(n, n2, c);
            }
        }
    }

    public String getMenu(String string) {
        if (this.jmolpopup == null) {
            this.jmolpopup = JmolPopup.newJmolPopup(this, true, this.menuStructure, true);
        }
        return this.jmolpopup == null ? "" : this.jmolpopup.getMenu("Jmol version " + Viewer.getJmolVersion() + "|_GET_MENU|" + string);
    }

    public void setMenu(String string, boolean bl) {
        if (bl) {
            Logger.info("Setting menu " + (string.length() == 0 ? "to Jmol defaults" : "from file " + string));
        }
        if (string.length() == 0) {
            string = null;
        } else if (bl) {
            string = this.getFileAsString(string);
        }
        this.getProperty("DATA_API", "setMenu", string);
        this.statusManager.setCallbackFunction("menu", string);
    }

    void setStatusFrameChanged(int n) {
        String string;
        int n2;
        int n3 = this.animationManager.currentModelIndex;
        if (n == Integer.MIN_VALUE) {
            this.prevFrame = Integer.MIN_VALUE;
            n = n3;
        }
        this.transformManager.setVibrationPeriod(Float.NaN);
        int n4 = this.animationManager.firstModelIndex;
        int n5 = this.animationManager.lastModelIndex;
        if (n4 == n5) {
            n3 = n4;
        }
        int n6 = n2 = this.getModelFileNumber(n3);
        int n7 = n2 % 1000000;
        int n8 = this.getModelFileNumber(n4);
        int n9 = this.getModelFileNumber(n5);
        if (n6 == 0) {
            string = this.getModelNumberDotted(n4);
            if (n4 != n5) {
                string = string + " - " + this.getModelNumberDotted(n5);
            }
            if (n8 / 1000000 == n9 / 1000000) {
                n6 = n8;
            }
        } else {
            string = this.getModelNumberDotted(n3);
        }
        if (n6 != 0) {
            n6 = n6 < 1000000 ? 1 : n6 / 1000000;
        }
        this.global.setParameterValue("_currentFileNumber", n6);
        this.global.setParameterValue("_currentModelNumberInFile", n7);
        this.global.setParameterValue("_frameID", n2);
        this.global.setParameterValue("_modelNumber", string);
        this.global.setParameterValue("_modelName", n3 < 0 ? "" : this.getModelName(n3));
        this.global.setParameterValue("_modelTitle", n3 < 0 ? "" : this.getModelTitle(n3));
        this.global.setParameterValue("_modelFile", n3 < 0 ? "" : this.getModelFileName(n3));
        if (n3 == this.prevFrame) {
            return;
        }
        this.prevFrame = n3;
        this.statusManager.setStatusFrameChanged(n, n6, n7, this.animationManager.animationDirection < 0 ? -n8 : n8, this.animationManager.currentDirection < 0 ? -n9 : n9);
    }

    public void scriptEcho(String string) {
        if (!Logger.isActiveLevel(4)) {
            return;
        }
        this.statusManager.setScriptEcho(string, this.isScriptQueued);
        if (this.listCommands && string != null && string.indexOf("$[") == 0) {
            Logger.info(string);
        }
    }

    public void notifyError(String string, String string2, String string3) {
        this.global.setParameterValue("_errormessage", string3);
        this.statusManager.notifyError(string, string2, string3);
    }

    public String jsEval(String string) {
        return this.statusManager.jsEval(string);
    }

    public void setStatusAtomHovered(int n, String string) {
        this.global.setParameterValue("_atomhovered", n);
        this.statusManager.setStatusAtomHovered(n, string);
    }

    private void setFileLoadStatus(int n, String string, String string2, String string3, String string4) {
        this.setErrorMessage(string4);
        this.global.setParameterValue("_loadPoint", n);
        boolean bl = n != 2;
        this.statusManager.setFileLoadStatus(string, string2, string3, string4, n, bl);
    }

    public String getZapName() {
        return this.getModelkitMode() ? "Jmol Model Kit" : "zapped";
    }

    public void setStatusMeasuring(String string, int n, String string2, float f) {
        this.statusManager.setStatusMeasuring(string, n, string2, f);
    }

    public void notifyMinimizationStatus() {
        Object object = this.getParameter("_minimizationStep");
        this.statusManager.notifyMinimizationStatus((String)this.getParameter("_minimizationStatus"), object instanceof String ? new Integer(0) : (Integer)object, (Float)this.getParameter("_minimizationEnergy"), (Float)this.getParameter("_minimizationEnergyDiff"));
    }

    public void setStatusAtomPicked(int n, String string) {
        if (string == null) {
            string = this.global.pickLabel;
            string = string.length() == 0 ? this.getAtomInfoXYZ(n, this.getMessageStyleChime()) : this.modelSet.getAtomInfo(n, string);
        }
        this.global.setParameterValue("_atompicked", n);
        this.global.setParameterValue("_pickinfo", string);
        this.statusManager.setStatusAtomPicked(n, string);
    }

    public void setStatusResized(int n, int n2) {
        this.statusManager.setStatusResized(n, n2);
    }

    public void scriptStatus(String string) {
        this.scriptStatus(string, "", 0, null);
    }

    public void scriptStatus(String string, String string2) {
        this.scriptStatus(string, string2, 0, null);
    }

    public void scriptStatus(String string, String string2, int n, String string3) {
        this.statusManager.setScriptStatus(string, string2, n, string3);
    }

    private String getModelTitle(int n) {
        return this.modelSet == null ? null : this.modelSet.getModelTitle(n);
    }

    public String getModelFileName(int n) {
        return this.modelSet == null ? null : this.modelSet.getModelFileName(n);
    }

    public String dialogAsk(String string, String string2) {
        return this.statusManager.dialogAsk(string, string2);
    }

    public int getScriptDelay() {
        return this.global.scriptDelay;
    }

    public void showUrl(String string) {
        if (string == null) {
            return;
        }
        if (string.indexOf(":") < 0) {
            String string2 = this.fileManager.getAppletDocumentBase();
            if (string2 == "") {
                string2 = this.fileManager.getFullPathName();
            }
            if (string2.indexOf("/") >= 0) {
                string2 = string2.substring(0, string2.lastIndexOf("/") + 1);
            } else if (string2.indexOf("\\") >= 0) {
                string2 = string2.substring(0, string2.lastIndexOf("\\") + 1);
            }
            string = string2 + string;
        }
        Logger.info("showUrl:" + string);
        this.statusManager.showUrl(string);
    }

    public void setMeshCreator(Object object) {
        this.loadShape(23);
        this.setShapeProperty(23, "meshCreator", object);
    }

    public void showConsole(boolean bl) {
        if (!this.haveDisplay) {
            return;
        }
        try {
            if (this.appConsole == null) {
                this.getProperty("DATA_API", "getAppConsole", Boolean.TRUE);
            }
            this.appConsole.setVisible(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clearConsole() {
        this.statusManager.clearConsole();
    }

    public Object getParameterEscaped(String string) {
        return this.global.getParameterEscaped(string, 0);
    }

    public Object getParameter(String string) {
        return this.global.getParameter(string);
    }

    public ScriptVariable getOrSetNewVariable(String string, boolean bl) {
        return this.global.getOrSetNewVariable(string, bl);
    }

    public ScriptVariable setUserVariable(String string, ScriptVariable scriptVariable) {
        return this.global.setUserVariable(string, scriptVariable);
    }

    public void unsetProperty(String string) {
        this.global.unsetUserVariable(string);
    }

    public String getVariableList() {
        return this.global.getVariableList();
    }

    public boolean getBooleanProperty(String string) {
        if (this.global.htBooleanParameterFlags.containsKey(string = string.toLowerCase())) {
            return (Boolean)this.global.htBooleanParameterFlags.get(string);
        }
        if (string.endsWith("p!")) {
            if (this.actionManager == null) {
                return false;
            }
            String string2 = this.actionManager.getPickingState().toLowerCase();
            return string2.indexOf(string = string.substring(0, string.length() - 2) + ";") >= 0;
        }
        if (string.equalsIgnoreCase("executionPaused")) {
            return this.eval.isExecutionPaused();
        }
        if (string.equalsIgnoreCase("executionStepping")) {
            return this.eval.isExecutionStepping();
        }
        if (string.equalsIgnoreCase("haveBFactors")) {
            return this.modelSet.getBFactors() != null;
        }
        if (string.equalsIgnoreCase("colorRasmol")) {
            return this.colorManager.getDefaultColorRasmol();
        }
        if (string.equalsIgnoreCase("frank")) {
            return this.getShowFrank();
        }
        if (string.equalsIgnoreCase("showSelections")) {
            return this.getSelectionHaloEnabled();
        }
        if (this.global.htUserVariables.containsKey(string)) {
            ScriptVariable scriptVariable = this.global.getUserVariable(string);
            if (scriptVariable.tok == 0x10000D) {
                return true;
            }
            if (scriptVariable.tok == 0x10000C) {
                return false;
            }
        }
        Logger.error("viewer.getBooleanProperty(" + string + ") - unrecognized");
        return false;
    }

    public void setStringProperty(String string, String string2) {
        if (string2 == null) {
            return;
        }
        if (string.charAt(0) == '_') {
            this.global.setParameterValue(string, string2);
            return;
        }
        this.setStringProperty(string, Token.getTokFromName(string.toLowerCase()), string2);
    }

    public void setStringProperty(String string, int n, String string2) {
        boolean bl = true;
        switch (n) {
            case 545259549: {
                this.global.defaultLoadFilter = string2;
                break;
            }
            case 545259567: {
                string2 = this.setLogFile(string2);
                if (string2 != null) break;
                return;
            }
            case 545259559: {
                break;
            }
            case 545259524: {
                this.global.atomTypes = string2;
                break;
            }
            case 545259538: {
                break;
            }
            case 545259572: {
                this.global.pickLabel = string2;
                break;
            }
            case 545259578: {
                this.global.quaternionFrame = string2.length() == 2 && string2.startsWith("R") ? string2.substring(0, 2) : "" + (string2.toLowerCase() + "p").charAt(0);
                if (!Parser.isOneOf(this.global.quaternionFrame, "RC;RP;a;b;c;n;p;q;x;")) {
                    this.global.quaternionFrame = "p";
                }
                this.modelSet.setHaveStraightness(false);
                break;
            }
            case 545259556: {
                this.setDefaultVdw(string2);
                return;
            }
            case 545259564: {
                new GT(string2);
                this.language = GT.getLanguage();
                this.modelkit = null;
                if (this.jmolpopup != null) {
                    this.jmolpopup = JmolPopup.newJmolPopup(this, true, this.menuStructure, true);
                }
                this.statusManager.setCallbackFunction("language", this.language);
                string2 = GT.getLanguage();
                break;
            }
            case 545259566: {
                this.global.loadFormat = string2;
                break;
            }
            case 545259534: {
                this.setObjectColor("background", string2);
                return;
            }
            case 0x20800008: {
                this.setObjectColor("axis1", string2);
                return;
            }
            case 545259530: {
                this.setObjectColor("axis2", string2);
                return;
            }
            case 545259532: {
                this.setObjectColor("axis3", string2);
                return;
            }
            case 545259536: {
                this.setObjectColor("boundbox", string2);
                return;
            }
            case 545259582: {
                this.setObjectColor("unitcell", string2);
                return;
            }
            case 545259574: {
                this.setPropertyColorScheme(string2, false, false);
                break;
            }
            case 545259562: {
                this.setShapeProperty(32, "atomLabel", string2);
                break;
            }
            case 545259548: {
                this.global.defaultDistanceLabel = string2;
                break;
            }
            case 545259542: {
                this.global.defaultAngleLabel = string2;
                break;
            }
            case 0x20800022: {
                this.global.defaultTorsionLabel = string2;
                break;
            }
            case 545259550: {
                this.global.defaultLoadScript = string2;
                break;
            }
            case 0x20800002: {
                this.fileManager.setAppletProxy(string2);
                break;
            }
            case 545259546: {
                if (string2 == null) {
                    string2 = "";
                }
                this.global.defaultDirectory = string2 = string2.replace('\\', '/');
                break;
            }
            case 0x20800028: {
                this.global.helpPath = string2;
                break;
            }
            case 0x20800020: {
                this.setDefaults(string2);
                break;
            }
            case 545259544: {
                this.setDefaultColors(string2);
                break;
            }
            case 545259569: {
                this.setPickingMode(string2, 0);
                return;
            }
            case 545259570: {
                this.setPickingStyle(string2, 0);
                return;
            }
            case 545259540: {
                break;
            }
            default: {
                if (string.toLowerCase().indexOf("callback") >= 0) {
                    this.statusManager.setCallbackFunction(string, string2.length() == 0 || string2.equalsIgnoreCase("none") ? null : string2);
                    break;
                }
                bl = false;
            }
        }
        string = string.toLowerCase();
        if (this.global.htNonbooleanParameterValues.containsKey(string)) {
            this.global.setParameterValue(string, string2);
        } else if (bl || string.charAt(0) == '@' || !this.global.htBooleanParameterFlags.containsKey(string) && !this.global.htPropertyFlagsRemoved.containsKey(string)) {
            this.global.setUserVariable(string, new ScriptVariable(4, string2));
        }
    }

    public void setFloatProperty(String string, float f) {
        if (Float.isNaN(f)) {
            return;
        }
        if (string.charAt(0) == '_') {
            this.global.setParameterValue(string, f);
            return;
        }
        this.setFloatProperty(string, Token.getTokFromName(string.toLowerCase()), f, false);
    }

    public boolean setFloatProperty(String string, int n, float f, boolean bl) {
        boolean bl2 = true;
        switch (n) {
            case 570425368: {
                this.global.multipleBondRadiusFactor = f;
                break;
            }
            case 570425369: {
                this.global.multipleBondSpacing = f;
                break;
            }
            case 570425365: {
                this.global.minimizationCriterion = f;
                break;
            }
            case 0x2200000F: {
                if (!this.haveDisplay) break;
                this.actionManager.setGestureSwipeFactor(f);
                break;
            }
            case 570425366: {
                if (!this.haveDisplay) break;
                this.actionManager.setMouseDragFactor(f);
                break;
            }
            case 570425367: {
                if (!this.haveDisplay) break;
                this.actionManager.setMouseWheelFactor(f);
                break;
            }
            case 0x22000040: {
                this.global.strutLengthMaximum = f;
                break;
            }
            case 570425406: {
                this.global.strutDefaultRadius = f;
                break;
            }
            case 0x22000020: {
                this.setSpin("X", (int)f);
                break;
            }
            case 0x22000022: {
                this.setSpin("Y", (int)f);
                break;
            }
            case 0x22000024: {
                this.setSpin("Z", (int)f);
                break;
            }
            case 570425370: {
                if (Float.isNaN(f)) {
                    return true;
                }
                this.setSpin("FPS", (int)f);
                break;
            }
            case 570425363: {
                this.global.loadAtomDataTolerance = f;
                break;
            }
            case 0x22000010: {
                this.global.hbondsAngleMinimum = f;
                break;
            }
            case 0x22000011: {
                this.global.hbondsDistanceMaximum = f;
                break;
            }
            case 0x22000026: {
                this.global.pointGroupDistanceTolerance = f;
                break;
            }
            case 0x22000028: {
                this.global.pointGroupLinearTolerance = f;
                break;
            }
            case 0x2200000E: {
                if (!bl) break;
                f /= 1000.0f;
                break;
            }
            case 570425398: {
                this.setSpin("x", (int)f);
                break;
            }
            case 570425400: {
                this.setSpin("y", (int)f);
                break;
            }
            case 570425402: {
                this.setSpin("z", (int)f);
                break;
            }
            case 570425396: {
                this.setSpin("fps", (int)f);
                break;
            }
            case 0x22000008: {
                this.global.defaultDrawArrowScale = f;
                break;
            }
            case 0x2200000A: {
                this.global.defaultTranslucent = f;
                break;
            }
            case 0x22000002: {
                this.setAxesScale(f);
                break;
            }
            case 570425416: {
                this.transformManager.setVisualRange(f);
                this.refresh(1, "set visualRange");
                break;
            }
            case 570425371: {
                this.setNavigationDepthPercent(0.0f, f);
                break;
            }
            case 570425374: {
                this.global.navigationSpeed = f;
                break;
            }
            case 570425372: {
                this.transformManager.setNavigationSlabOffsetPercent(f);
                break;
            }
            case 0x22000006: {
                this.transformManager.setCameraDepthPercent(f);
                this.refresh(1, "set cameraDepth");
                break;
            }
            case 0x2200002C: {
                this.setRotationRadius(f, true);
                return true;
            }
            case 0x22000012: {
                this.global.hoverDelayMs = (int)(f * 1000.0f);
                break;
            }
            case 0x22000030: {
                this.global.sheetSmoothing = f;
                break;
            }
            case 0x2200000C: {
                this.global.dipoleScale = f;
                break;
            }
            case 570425404: {
                this.transformManager.setStereoDegrees(f);
                break;
            }
            case 0x22000042: {
                this.setVectorScale(f);
                return true;
            }
            case 0x22000044: {
                this.setVibrationPeriod(f);
                return true;
            }
            case 570425414: {
                this.setVibrationScale(f);
                return true;
            }
            case 0x22000004: {
                this.setBondTolerance(f);
                return true;
            }
            case 570425364: {
                this.setMinBondDistance(f);
                return true;
            }
            case 0x2200002E: {
                this.transformManager.setScaleAngstromsPerInch(f);
                break;
            }
            case 0x22000032: {
                this.global.solventProbeRadius = f;
                break;
            }
            default: {
                if (bl) {
                    return false;
                }
                bl2 = false;
            }
        }
        string = string.toLowerCase();
        if (this.global.htNonbooleanParameterValues.containsKey(string)) {
            this.global.setParameterValue(string, f);
        } else if (bl2 || !this.global.htBooleanParameterFlags.containsKey(string)) {
            this.global.setUserVariable(string, new ScriptVariable(3, new Float(f)));
        }
        return true;
    }

    public void setIntProperty(String string, int n) {
        if (n == Integer.MIN_VALUE) {
            return;
        }
        if (string.charAt(0) == '_') {
            this.global.setParameterValue(string, n);
            return;
        }
        this.setIntProperty(string, Token.getTokFromName(string.toLowerCase()), n);
    }

    public void setIntProperty(String string, int n, int n2) {
        boolean bl = true;
        switch (n) {
            case 553648165: {
                this.global.repaintWaitMs = n2;
                break;
            }
            case 553648170: {
                this.global.smallMoleculeMaxAtoms = n2;
                break;
            }
            case 553648151: {
                this.global.minimizationSteps = n2;
                break;
            }
            case 0x21000011: 
            case 553648159: 
            case 0x21000020: 
            case 553648164: {
                break;
            }
            case 553648184: {
                this.global.strutSpacing = n2;
                break;
            }
            case 553648156: {
                Graphics3D.setPhongExponent(n2);
                break;
            }
            case 0x21000012: {
                this.global.helixStep = n2;
                this.modelSet.setHaveStraightness(false);
                break;
            }
            case 0x21000010: {
                this.global.dotScale = n2;
                break;
            }
            case 553648143: {
                this.global.dotDensity = n2;
                break;
            }
            case 553648138: {
                this.global.delayMaximumMs = n2;
                break;
            }
            case 553648150: {
                Logger.setLogLevel(n2);
                Logger.info("logging level set to " + n2);
                this.global.setParameterValue("logLevel", n2);
                this.eval.setDebugging();
                return;
            }
            case 553648134: {
                switch (n2) {
                    case 1: {
                        this.setAxesModeMolecular(true);
                        return;
                    }
                    case 0: {
                        this.setAxesModeMolecular(false);
                        return;
                    }
                    case 2: {
                        this.setAxesModeUnitCell(true);
                        return;
                    }
                }
                return;
            }
            case 553648178: {
                this.setStrandCount(0, n2);
                return;
            }
            case 553648182: {
                this.setStrandCount(12, n2);
                return;
            }
            case 553648180: {
                this.setStrandCount(13, n2);
                return;
            }
            case 553648154: {
                this.setPerspectiveModel(n2);
                break;
            }
            case 0x2000000A: {
                this.global.scriptDelay = n2;
                break;
            }
            case 553648176: {
                Graphics3D.setSpecularPower(n2);
                break;
            }
            case 553648172: {
                Graphics3D.setSpecularPower(-n2);
                break;
            }
            case 553648136: {
                this.setMarBond((short)n2);
                return;
            }
            case 0x2000000C: {
                this.setBooleanProperty(string, n, n2 == 1, true);
                return;
            }
            case 553648174: {
                Graphics3D.setSpecularPercent(n2);
                break;
            }
            case 553648142: {
                Graphics3D.setDiffusePercent(n2);
                break;
            }
            case 0x21000002: {
                Graphics3D.setAmbientPercent(n2);
                break;
            }
            case 553648186: {
                Graphics3D.setZShadePower(Math.max(n2, 1));
                break;
            }
            case 553648166: {
                this.global.ribbonAspectRatio = n2;
                break;
            }
            case 553648158: {
                this.global.pickingSpinRate = n2 < 1 ? 1 : n2;
                break;
            }
            case 553648132: {
                this.setAnimationFps(n2);
                break;
            }
            case 553648152: {
                this.setPercentVdwAtom(n2);
                break;
            }
            case 553648148: {
                this.global.hermiteLevel = n2;
                break;
            }
            default: {
                if ((n2 != 0 && n2 != 1 || !this.setBooleanProperty(string, n, n2 == 1, false)) && this.setFloatProperty(string, n, n2, true)) {
                    return;
                }
                bl = false;
            }
        }
        string = string.toLowerCase();
        if (this.global.htNonbooleanParameterValues.containsKey(string)) {
            this.global.setParameterValue(string, n2);
        } else if (bl || !this.global.htBooleanParameterFlags.containsKey(string)) {
            this.global.setUserVariable(string, ScriptVariable.intVariable(n2));
        }
    }

    public void setBooleanProperty(String string, boolean bl) {
        if (string.charAt(0) == '_') {
            this.global.setParameterValue(string, bl);
            return;
        }
        this.setBooleanProperty(string, Token.getTokFromName(string.toLowerCase()), bl, true);
    }

    private boolean setBooleanProperty(String string, int n, boolean bl, boolean bl2) {
        boolean bl3 = true;
        boolean bl4 = true;
        switch (n) {
            case 603979874: {
                this.global.legacyAutoBonding = bl;
                break;
            }
            case 603979825: {
                this.global.defaultStructureDSSP = bl;
                break;
            }
            case 603979834: {
                this.global.dsspCalcHydrogen = bl;
                break;
            }
            case 603979782: {
                this.global.allowModelkit = bl;
                if (bl) break;
                this.setModelKitMode(false);
                break;
            }
            case 603979882: {
                this.setModelKitMode(bl);
                break;
            }
            case 603979884: {
                this.global.multiProcessor = bl && nProcessors > 1;
                break;
            }
            case 603979883: {
                this.global.monitorEnergy = bl;
                break;
            }
            case 603979853: {
                this.global.hbondsRasmol = bl;
                break;
            }
            case 603979880: {
                this.global.minimizationRefresh = bl;
                break;
            }
            case 603979881: {
                this.global.minimizationSilent = bl;
                break;
            }
            case 603979969: {
                this.global.useArcBall = bl;
                break;
            }
            case 603979869: {
                this.isKiosk = bl;
                break;
            }
            case 603979973: {
                this.global.waitForMoveTo = bl;
                break;
            }
            case 603979875: {
                this.global.logCommands = true;
                break;
            }
            case 603979876: {
                this.global.logGestures = true;
                break;
            }
            case 603979783: {
                this.global.allowMultiTouch = bl;
                break;
            }
            case 603979893: {
                this.global.preserveState = bl;
                this.modelSet.setPreserveState(bl);
                break;
            }
            case 603979955: {
                this.global.strutsMultiple = bl;
                break;
            }
            case 0x24000042: {
                break;
            }
            case 603979938: {
                this.global.slabByAtom = bl;
                break;
            }
            case 603979940: {
                this.global.slabByMolecule = bl;
                break;
            }
            case 603979902: {
                this.global.saveProteinStructureState = bl;
                break;
            }
            case 0x24000004: {
                this.global.allowGestures = bl;
                break;
            }
            case 603979868: {
                this.global.imageState = bl;
                break;
            }
            case 603979970: {
                this.global.useMinimizationThread = bl;
                break;
            }
            case 603979781: {
                if (this.global.disablePopupMenu) {
                    bl = false;
                }
                this.global.allowKeyStrokes = bl;
                break;
            }
            case 603979831: {
                this.global.dragSelected = bl;
                break;
            }
            case 603979924: {
                this.global.showKeyStrokes = bl;
                break;
            }
            case 0x24000044: {
                this.global.fontCaching = bl;
                break;
            }
            case 603979796: {
                this.global.atomPicking = bl;
                break;
            }
            case 603979814: {
                this.global.bondPicking = bl;
                break;
            }
            case 603979906: {
                this.global.selectAllModels = bl;
                break;
            }
            case 603979879: {
                this.global.messageStyleChime = bl;
                break;
            }
            case 603979890: {
                this.global.pdbSequential = bl;
                break;
            }
            case 603979888: {
                this.global.pdbGetHeader = bl;
                break;
            }
            case 603979837: {
                this.global.ellipsoidAxes = bl;
                break;
            }
            case 603979836: {
                this.global.ellipsoidArcs = bl;
                break;
            }
            case 603979838: {
                this.global.ellipsoidBall = bl;
                break;
            }
            case 603979839: {
                this.global.ellipsoidDots = bl;
                break;
            }
            case 0x24000040: {
                this.global.ellipsoidFill = bl;
                break;
            }
            case 603979845: {
                this.global.fontScaling = bl;
                break;
            }
            case 603979956: {
                this.setSyncTarget(0, bl);
                break;
            }
            case 603979958: {
                this.setSyncTarget(1, bl);
                break;
            }
            case 603979976: {
                this.global.wireframeRotation = bl;
                break;
            }
            case 603979870: {
                this.global.isosurfacePropertySmoothing = bl;
                break;
            }
            case 603979833: {
                this.global.drawPicking = bl;
                break;
            }
            case 603979786: {
                this.setAntialias(0, bl);
                break;
            }
            case 603979790: {
                this.setAntialias(1, bl);
                break;
            }
            case 603979788: {
                this.setAntialias(2, bl);
                break;
            }
            case 603979944: {
                this.global.smartAromatic = bl;
                break;
            }
            case 603979794: {
                this.setApplySymmetryToBonds(bl);
                break;
            }
            case 603979792: {
                this.setAppendNew(bl);
                break;
            }
            case 603979800: {
                this.global.autoFps = bl;
                break;
            }
            case 603979972: {
                this.global.useNumberLocalization = bl;
                TextFormat.setUseNumberLocalization(this.global.useNumberLocalization);
                break;
            }
            case 1611272213: {
                string = "showFrank";
                this.setFrankOn(bl);
                break;
            }
            case 603979918: {
                this.setFrankOn(bl);
                break;
            }
            case 1613758488: {
                string = "solventProbe";
                this.global.solventOn = bl;
                break;
            }
            case 603979948: {
                this.global.solventOn = bl;
                break;
            }
            case 603979835: {
                this.setDynamicMeasurements(bl);
                break;
            }
            case 603979784: {
                this.setAllowRotateSelected(bl);
                break;
            }
            case 0x2000000A: {
                this.setIntProperty("showScript", n, bl ? 1 : 0);
                return true;
            }
            case 0x24000002: {
                this.global.allowEmbeddedScripts = bl;
                break;
            }
            case 603979887: {
                this.global.navigationPeriodic = bl;
                break;
            }
            case 603979984: {
                this.transformManager.setZShadeEnabled(bl);
                return true;
            }
            case 603979832: {
                if (!this.haveDisplay) break;
                this.global.drawHover = bl;
                break;
            }
            case 603979886: {
                this.setNavigationMode(bl);
                break;
            }
            case 603979885: {
                this.global.navigateSurface = bl;
                break;
            }
            case 603979860: {
                this.global.hideNavigationPoint = bl;
                break;
            }
            case 603979930: {
                this.global.showNavigationPointAlways = bl;
                break;
            }
            case 603979896: {
                this.setRefreshing(bl);
                break;
            }
            case 603979872: {
                this.global.justifyMeasurements = bl;
                break;
            }
            case 603979952: {
                this.global.ssbondsBackbone = bl;
                break;
            }
            case 603979852: {
                this.global.hbondsBackbone = bl;
                break;
            }
            case 603979854: {
                this.global.hbondsSolid = bl;
                break;
            }
            case 0x2000000C: {
                Graphics3D.setSpecular(bl);
                break;
            }
            case 603979942: {
                this.transformManager.setSlabEnabled(bl);
                return true;
            }
            case 603979980: {
                this.transformManager.setZoomEnabled(bl);
                return true;
            }
            case 603979864: {
                this.global.highResolutionFlag = bl;
                break;
            }
            case 603979967: {
                this.global.traceAlpha = bl;
                break;
            }
            case 603979982: {
                this.global.zoomLarge = bl;
                this.transformManager.scaleFitToScreen(false, bl, false, true);
                break;
            }
            case 603979873: {
                GT.setDoTranslate(bl);
                break;
            }
            case 603979862: {
                this.selectionManager.setHideNotSelected(bl);
                break;
            }
            case 603979904: {
                this.setScriptQueue(bl);
                break;
            }
            case 603979830: {
                this.global.dotSurface = bl;
                break;
            }
            case 603979829: {
                this.global.dotsSelectedOnly = bl;
                break;
            }
            case 1611141171: {
                this.setSelectionHalos(bl);
                break;
            }
            case 603979910: {
                this.global.rasmolHydrogenSetting = bl;
                break;
            }
            case 603979908: {
                this.global.rasmolHeteroSetting = bl;
                break;
            }
            case 603979928: {
                this.global.showMultipleBonds = bl;
                break;
            }
            case 603979920: {
                this.global.showHiddenSelectionHalos = bl;
                break;
            }
            case 603979974: {
                this.transformManager.setWindowCentered(bl);
                break;
            }
            case 603979828: {
                this.global.displayCellParameters = bl;
                break;
            }
            case 603979960: {
                this.global.testFlag1 = bl;
                break;
            }
            case 603979962: {
                this.global.testFlag2 = bl;
                break;
            }
            case 603979964: {
                this.global.testFlag3 = bl;
                break;
            }
            case 603979966: {
                this.jmolTest();
                this.global.testFlag4 = bl;
                break;
            }
            case 603979898: {
                this.global.ribbonBorder = bl;
                break;
            }
            case 603979818: {
                this.global.cartoonBaseEdges = bl;
                break;
            }
            case 603979819: {
                this.global.cartoonRockets = bl;
                break;
            }
            case 603979900: {
                this.global.rocketBarrels = bl;
                break;
            }
            case 603979850: {
                this.global.greyscaleRendering = bl;
                this.g3d.setGreyscaleMode(this.global.greyscaleRendering);
                break;
            }
            case 603979878: {
                this.global.measurementLabels = bl;
                break;
            }
            case 0x24000022: {
                this.setAxesModeMolecular(!bl);
                return true;
            }
            case 603979804: {
                this.setAxesModeMolecular(bl);
                return true;
            }
            case 0x24000020: {
                this.setAxesModeUnitCell(bl);
                return true;
            }
            case 603979806: {
                this.setAxesOrientationRasmol(bl);
                return true;
            }
            case 603979822: {
                this.setStringProperty("defaultcolorscheme", 545259544, bl ? "rasmol" : "jmol");
                return true;
            }
            case 603979824: {
                this.setDebugScript(bl);
                return true;
            }
            case 603979892: {
                this.setPerspectiveDepth(bl);
                return true;
            }
            case 603979798: {
                this.setAutoBond(bl);
                return true;
            }
            case 603979914: {
                this.setShowAxes(bl);
                return true;
            }
            case 603979916: {
                this.setShowBbcage(bl);
                return true;
            }
            case 603979922: {
                this.setShowHydrogens(bl);
                return true;
            }
            case 603979926: {
                this.setShowMeasurements(bl);
                return true;
            }
            case 603979936: {
                this.setShowUnitCell(bl);
                return true;
            }
            case 0x24000024: {
                bl4 = false;
                this.global.bondModeOr = bl;
                break;
            }
            case 603979978: {
                bl4 = false;
                this.global.zeroBasedXyzRasmol = bl;
                this.reset(true);
                break;
            }
            case 603979894: {
                bl4 = false;
                this.global.rangeSelected = bl;
                break;
            }
            case 603979877: {
                bl4 = false;
                this.global.measureAllModels = bl;
                break;
            }
            case 603979954: {
                bl4 = false;
                this.statusManager.setAllowStatusReporting(bl);
                break;
            }
            case 603979820: {
                bl4 = false;
                this.global.chainCaseSensitive = bl;
                break;
            }
            case 603979858: {
                bl4 = false;
                this.global.hideNameInPopup = bl;
                break;
            }
            case 603979826: {
                bl4 = false;
                this.global.disablePopupMenu = bl;
                break;
            }
            case 603979846: {
                bl4 = false;
                this.global.forceAutoBond = bl;
                break;
            }
            case 603979848: {
                bl4 = false;
                this.global.fractionalRelative = bl;
                break;
            }
            default: {
                bl4 = false;
                bl3 = false;
            }
        }
        if (!bl2) {
            return bl3;
        }
        boolean bl5 = this.global.htBooleanParameterFlags.containsKey(string = string.toLowerCase());
        if (bl5) {
            this.global.setParameterValue(string, bl);
        } else {
            if (!bl3 && this.global.htNonbooleanParameterValues.containsKey(string)) {
                return true;
            }
            this.global.setUserVariable(string, ScriptVariable.getBoolean(bl));
        }
        if (!bl3) {
            return false;
        }
        if (bl4) {
            this.setTainted(true);
        }
        return true;
    }

    private void setModelKitMode(boolean bl) {
        if (bl || this.global.modelKitMode) {
            this.setPickingMode(null, bl ? 32 : 1);
            this.setPickingMode(null, bl ? 31 : 1);
        }
        boolean bl2 = this.global.modelKitMode != bl;
        this.global.modelKitMode = bl;
        this.highlight(null);
        if (bl) {
            this.setNavigationMode(false);
            this.selectAll();
            this.setAtomPickingOption("C");
            this.setBondPickingOption("p");
            if (!this.isApplet) {
                this.popupMenu(0, 0, 'm');
            }
            if (bl2) {
                this.statusManager.setCallbackFunction("modelkit", "ON");
            }
            this.global.modelKitMode = true;
            if (this.getAtomCount() == 0) {
                this.zap(false, true, true);
            }
        } else {
            this.setStringProperty("pickingMode", "ident");
            this.setStringProperty("pickingStyle", "toggle");
            this.setBooleanProperty("bondPicking", false);
            if (bl2) {
                this.statusManager.setCallbackFunction("modelkit", "OFF");
            }
        }
    }

    public boolean getModelkitMode() {
        return this.global.modelKitMode;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setSmilesString(String string) {
        if (string == null) {
            this.global.removeJmolParameter("_smilesString");
        } else {
            this.global.setParameterValue("_smilesString", string);
        }
    }

    public void removeUserVariable(String string) {
        this.global.removeUserVariable(string);
        if (string.indexOf("callback") >= 0) {
            this.statusManager.setCallbackFunction(string, null);
        }
    }

    public boolean isJmolVariable(String string) {
        return this.global.isJmolVariable(string);
    }

    private void jmolTest() {
    }

    public boolean isPdbSequential() {
        return this.global.pdbSequential;
    }

    boolean getSelectAllModels() {
        return this.global.selectAllModels;
    }

    public boolean getMessageStyleChime() {
        return this.global.messageStyleChime;
    }

    public boolean getFontCaching() {
        return this.global.fontCaching;
    }

    public boolean getFontScaling() {
        return this.global.fontScaling;
    }

    public void showParameter(String string, boolean bl, int n) {
        String string2 = "" + this.global.getParameterEscaped(string, n);
        if (bl || string2.indexOf("<not defined>") < 0) {
            this.showString(string + " = " + string2, false);
        }
    }

    public void showString(String string, boolean bl) {
        if (this.isScriptQueued && (!this.isSilent || bl)) {
            Logger.info(string);
        }
        this.scriptEcho(string);
    }

    public String getAllSettings(String string) {
        return this.global.getAllSettings(string);
    }

    public String getBindingInfo(String string) {
        return this.haveDisplay ? this.actionManager.getBindingInfo(string) : "";
    }

    public int getDelayMaximum() {
        return this.haveDisplay ? this.global.delayMaximumMs : 1;
    }

    public boolean getDotSurfaceFlag() {
        return this.global.dotSurface;
    }

    public boolean getDotsSelectedOnlyFlag() {
        return this.global.dotsSelectedOnly;
    }

    public int getDotDensity() {
        return this.global.dotDensity;
    }

    public int getDotScale() {
        return this.global.dotScale;
    }

    public boolean isRangeSelected() {
        return this.global.rangeSelected;
    }

    public boolean getIsosurfacePropertySmoothing() {
        return this.global.isosurfacePropertySmoothing;
    }

    public boolean getWireframeRotation() {
        return this.global.wireframeRotation;
    }

    public boolean isWindowCentered() {
        return this.transformManager.isWindowCentered();
    }

    public void setNavigationDepthPercent(float f, float f2) {
        this.transformManager.setNavigationDepthPercent(f, f2);
        this.refresh(1, "set navigationDepth");
    }

    float getNavigationSpeed() {
        return this.global.navigationSpeed;
    }

    public boolean getShowNavigationPoint() {
        if (!this.global.navigationMode || !this.transformManager.canNavigate()) {
            return false;
        }
        return this.isNavigating() && !this.global.hideNavigationPoint || this.global.showNavigationPointAlways || this.getInMotion();
    }

    public float getSolventProbeRadius() {
        return this.global.solventProbeRadius;
    }

    public float getCurrentSolventProbeRadius() {
        return this.global.solventOn ? this.global.solventProbeRadius : 0.0f;
    }

    boolean getSolventOn() {
        return this.global.solventOn;
    }

    public boolean getTestFlag1() {
        return this.global.testFlag1;
    }

    public boolean getTestFlag2() {
        return this.global.testFlag2;
    }

    public boolean getTestFlag3() {
        return this.global.testFlag3;
    }

    public boolean getTestFlag4() {
        return this.global.testFlag4;
    }

    public void setPerspectiveDepth(boolean bl) {
        this.global.setParameterValue("perspectiveDepth", bl);
        this.transformManager.setPerspectiveDepth(bl);
    }

    public void setAxesOrientationRasmol(boolean bl) {
        this.global.setParameterValue("axesOrientationRasmol", bl);
        this.global.axesOrientationRasmol = bl;
        this.reset(true);
    }

    public boolean getAxesOrientationRasmol() {
        return this.global.axesOrientationRasmol;
    }

    void setAxesScale(float f) {
        this.global.axesScale = f;
        this.axesAreTainted = true;
    }

    public Point3f[] getAxisPoints() {
        return this.getObjectMad(1) == 0 || this.getAxesMode() != 2 || (Boolean)this.getShapeProperty(29, "axesTypeXY") != false || this.getShapeProperty(29, "origin") != null ? null : (Point3f[])this.getShapeProperty(29, "axisPoints");
    }

    public float getAxesScale() {
        return this.global.axesScale;
    }

    public void resetError() {
        this.global.removeJmolParameter("_errormessage");
    }

    private void setAxesModeMolecular(boolean bl) {
        this.global.axesMode = bl ? 1 : 0;
        this.axesAreTainted = true;
        this.global.removeJmolParameter("axesunitcell");
        this.global.removeJmolParameter(bl ? "axeswindow" : "axesmolecular");
        this.global.setParameterValue("axesMode", this.global.axesMode);
        this.global.setParameterValue(bl ? "axesMolecular" : "axesWindow", true);
    }

    void setAxesModeUnitCell(boolean bl) {
        this.global.axesMode = bl ? 2 : 0;
        this.axesAreTainted = true;
        this.global.removeJmolParameter("axesmolecular");
        this.global.removeJmolParameter(bl ? "axeswindow" : "axesunitcell");
        this.global.setParameterValue(bl ? "axesUnitcell" : "axesWindow", true);
        this.global.setParameterValue("axesMode", this.global.axesMode);
    }

    public int getAxesMode() {
        return this.global.axesMode;
    }

    public boolean getDisplayCellParameters() {
        return this.global.displayCellParameters;
    }

    public boolean getPerspectiveDepth() {
        return this.transformManager.getPerspectiveDepth();
    }

    public void setSelectionHalos(boolean bl) {
        if (this.modelSet == null || bl == this.getSelectionHaloEnabled()) {
            return;
        }
        this.global.setParameterValue("selectionHalos", bl);
        this.loadShape(8);
        this.modelSet.setSelectionHaloEnabled(bl);
    }

    public boolean getSelectionHaloEnabled() {
        return this.modelSet.getSelectionHaloEnabled() || this.showSelected;
    }

    public boolean getBondSelectionModeOr() {
        return this.global.bondModeOr;
    }

    public boolean getChainCaseSensitive() {
        return this.global.chainCaseSensitive;
    }

    public boolean getRibbonBorder() {
        return this.global.ribbonBorder;
    }

    public boolean getCartoonRocketFlag() {
        return this.global.cartoonRockets;
    }

    public boolean getRocketBarrelFlag() {
        return this.global.rocketBarrels;
    }

    public boolean getCartoonBaseEdgesFlag() {
        return this.global.cartoonBaseEdges;
    }

    private void setStrandCount(int n, int n2) {
        switch (n) {
            case 12: {
                this.global.strandCountForStrands = n2;
                break;
            }
            case 13: {
                this.global.strandCountForMeshRibbon = n2;
                break;
            }
            default: {
                this.global.strandCountForStrands = n2;
                this.global.strandCountForMeshRibbon = n2;
            }
        }
        this.global.setParameterValue("strandCount", n2);
        this.global.setParameterValue("strandCountForStrands", this.global.strandCountForStrands);
        this.global.setParameterValue("strandCountForMeshRibbon", this.global.strandCountForMeshRibbon);
    }

    public int getStrandCount(int n) {
        return n == 12 ? this.global.strandCountForStrands : this.global.strandCountForMeshRibbon;
    }

    boolean getHideNameInPopup() {
        return this.global.hideNameInPopup;
    }

    boolean getNavigationPeriodic() {
        return this.global.navigationPeriodic;
    }

    private void stopAnimationThreads(String string) {
        this.setVibrationOff();
        this.setSpinOn(false);
        this.setNavOn(false);
        this.setAnimationOn(false);
    }

    private void setNavigationMode(boolean bl) {
        this.global.navigationMode = bl;
        if (bl && !this.transformManager.canNavigate()) {
            this.stopAnimationThreads("setNavigationMode");
            this.transformManager = this.transformManager.getNavigationManager(this, this.dimScreen.width, this.dimScreen.height);
            this.transformManager.homePosition(true);
        }
        this.transformManager.setNavigationMode(bl);
    }

    public boolean getNavigationMode() {
        return this.global.navigationMode;
    }

    public boolean getNavigateSurface() {
        return this.global.navigateSurface;
    }

    public void setTransformManager(TransformManager transformManager) {
        this.stopAnimationThreads("setTransformMan");
        this.transformManager = transformManager;
        transformManager.setViewer(this, this.dimScreen.width, this.dimScreen.height);
        this.setTransformManagerDefaults();
        transformManager.homePosition(true);
    }

    private void setPerspectiveModel(int n) {
        if (this.transformManager.perspectiveModel == n) {
            return;
        }
        this.stopAnimationThreads("setPerspectivemodeg");
        switch (n) {
            case 10: {
                this.transformManager = new TransformManager10(this, this.dimScreen.width, this.dimScreen.height);
                break;
            }
            default: {
                this.transformManager = this.transformManager.getNavigationManager(this, this.dimScreen.width, this.dimScreen.height);
            }
        }
        this.setTransformManagerDefaults();
        this.transformManager.homePosition(true);
    }

    private void setTransformManagerDefaults() {
        this.transformManager.setCameraDepthPercent(this.global.cameraDepth);
        this.transformManager.setPerspectiveDepth(this.global.perspectiveDepth);
        this.transformManager.setStereoDegrees(-5.0f);
        this.transformManager.setVisualRange(this.global.visualRange);
        this.transformManager.setSpinOn(false);
        this.transformManager.setVibrationPeriod(0.0f);
        this.transformManager.setFrameOffsets(this.frameOffsets);
    }

    public Point3f[] getCameraFactors() {
        return this.transformManager.getCameraFactors();
    }

    boolean getZoomLarge() {
        return this.global.zoomLarge;
    }

    public boolean getTraceAlpha() {
        return this.global.traceAlpha;
    }

    public int getHermiteLevel() {
        return this.getSpinOn() ? 0 : this.global.hermiteLevel;
    }

    public boolean getHighResolution() {
        return this.global.highResolutionFlag;
    }

    String getLoadState() {
        return this.global.getLoadState();
    }

    public void setAutoBond(boolean bl) {
        this.global.setParameterValue("autobond", bl);
        this.global.autoBond = bl;
    }

    public boolean getAutoBond() {
        return this.global.autoBond;
    }

    public int[] makeConnections(float f, float f2, int n, int n2, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, boolean bl, float f3) {
        this.clearModelDependentObjects();
        this.clearAllMeasurements();
        this.clearMinimization();
        return this.modelSet.makeConnections(f, f2, n, n2, bitSet, bitSet2, bitSet3, bl, f3);
    }

    public void rebond() {
        this.clearModelDependentObjects();
        this.modelSet.deleteAllBonds();
        this.modelSet.autoBond(null, null, null, null, this.getMadBond(), false);
        this.addStateScript("connect;", false, true);
    }

    public void setPdbConectBonding(boolean bl) {
        this.clearModelDependentObjects();
        this.modelSet.deleteAllBonds();
        BitSet bitSet = new BitSet();
        this.modelSet.setPdbConectBonding(0, 0, bitSet);
        if (bl) {
            this.modelSet.autoBond(null, null, bitSet, null, this.getMadBond(), false);
            this.addStateScript("connect PDB AUTO;", false, true);
            return;
        }
        this.addStateScript("connect PDB;", false, true);
    }

    boolean getGreyscaleRendering() {
        return this.global.greyscaleRendering;
    }

    boolean getDisablePopupMenu() {
        return this.global.disablePopupMenu;
    }

    public boolean getForceAutoBond() {
        return this.global.forceAutoBond;
    }

    public void setPercentVdwAtom(int n) {
        this.global.setParameterValue("percentVdwAtom", n);
        this.global.percentVdwAtom = n;
        this.rd.value = (float)n / 100.0f;
        this.rd.type = 2;
        this.rd.vdwType = 8;
        this.setShapeSize(0, this.rd, null);
    }

    public int getPercentVdwAtom() {
        return this.global.percentVdwAtom;
    }

    public RadiusData getDefaultRadiusData() {
        return this.rd;
    }

    public short getMadBond() {
        return (short)(this.global.bondRadiusMilliAngstroms * 2);
    }

    public short getMarBond() {
        return this.global.bondRadiusMilliAngstroms;
    }

    public byte getModeMultipleBond() {
        return this.global.modeMultipleBond;
    }

    public boolean getShowMultipleBonds() {
        return this.global.showMultipleBonds;
    }

    public float getMultipleBondSpacing() {
        return this.global.multipleBondSpacing;
    }

    public float getMultipleBondRadiusFactor() {
        return this.global.multipleBondRadiusFactor;
    }

    public void setShowHydrogens(boolean bl) {
        this.global.setParameterValue("showHydrogens", bl);
        this.global.showHydrogens = bl;
    }

    public boolean getShowHydrogens() {
        return this.global.showHydrogens;
    }

    public boolean getShowHiddenSelectionHalos() {
        return this.global.showHiddenSelectionHalos;
    }

    public void setShowBbcage(boolean bl) {
        this.setObjectMad(30, "boundbox", (short)(bl ? -4 : 0));
        this.global.setParameterValue("showBoundBox", bl);
    }

    public boolean getShowBbcage() {
        return this.getObjectMad(4) != 0;
    }

    public void setShowUnitCell(boolean bl) {
        this.setObjectMad(31, "unitcell", (short)(bl ? -2 : 0));
        this.global.setParameterValue("showUnitCell", bl);
    }

    public boolean getShowUnitCell() {
        return this.getObjectMad(5) != 0;
    }

    public void setShowAxes(boolean bl) {
        this.setObjectMad(29, "axes", (short)(bl ? -2 : 0));
        this.global.setParameterValue("showAxes", bl);
    }

    public boolean getShowAxes() {
        return this.getObjectMad(1) != 0;
    }

    public void setFrankOn(boolean bl) {
        if (this.isPreviewOnly) {
            bl = false;
        }
        this.frankOn = bl;
        this.setObjectMad(33, "frank", (short)(bl ? 1 : 0));
    }

    public boolean getShowFrank() {
        if (this.isPreviewOnly || this.isApplet && this.creatingImage) {
            return false;
        }
        return this.isSignedApplet && !this.isSignedAppletLocal || this.frankOn;
    }

    public boolean isSignedApplet() {
        return this.isSignedApplet;
    }

    public void setShowMeasurements(boolean bl) {
        this.global.setParameterValue("showMeasurements", bl);
        this.global.showMeasurements = bl;
    }

    public boolean getShowMeasurements() {
        return this.global.showMeasurements;
    }

    public boolean getShowMeasurementLabels() {
        return this.global.measurementLabels;
    }

    public boolean getMeasureAllModelsFlag() {
        return this.global.measureAllModels;
    }

    public void setMeasureDistanceUnits(String string) {
        this.global.setMeasureDistanceUnits(string);
        this.setShapeProperty(6, "reformatDistances", null);
    }

    public String getMeasureDistanceUnits() {
        return this.global.getMeasureDistanceUnits();
    }

    public boolean getUseNumberLocalization() {
        return this.global.useNumberLocalization;
    }

    public void setAppendNew(boolean bl) {
        this.global.appendNew = bl;
    }

    public boolean getAppendNew() {
        return this.global.appendNew;
    }

    boolean getAutoFps() {
        return this.global.autoFps;
    }

    public void setRasmolDefaults() {
        this.setDefaults("RasMol");
    }

    public void setJmolDefaults() {
        this.setDefaults("Jmol");
    }

    private void setDefaults(String string) {
        if (string.equalsIgnoreCase("RasMol")) {
            this.stateManager.setRasMolDefaults();
            return;
        }
        this.stateManager.setJmolDefaults();
        this.setShapeSize(0, this.rd, this.getModelUndeletedAtomsBitSet(-1));
    }

    public boolean getZeroBasedXyzRasmol() {
        return this.global.zeroBasedXyzRasmol;
    }

    private void setAntialias(int n, boolean bl) {
        switch (n) {
            case 0: {
                this.global.antialiasDisplay = bl;
                break;
            }
            case 1: {
                this.global.antialiasTranslucent = bl;
                break;
            }
            case 2: {
                this.global.antialiasImages = bl;
                return;
            }
        }
        this.resizeImage(0, 0, false, false, true);
    }

    public Point3f[] allocTempPoints(int n) {
        return this.tempManager.allocTempPoints(n);
    }

    public void freeTempPoints(Point3f[] point3fArray) {
        this.tempManager.freeTempPoints(point3fArray);
    }

    public Point3i[] allocTempScreens(int n) {
        return this.tempManager.allocTempScreens(n);
    }

    public void freeTempScreens(Point3i[] point3iArray) {
        this.tempManager.freeTempScreens(point3iArray);
    }

    public byte[] allocTempBytes(int n) {
        return this.tempManager.allocTempBytes(n);
    }

    public void freeTempBytes(byte[] byArray) {
        this.tempManager.freeTempBytes(byArray);
    }

    public Font3D getFont3D(String string, String string2, float f) {
        return this.g3d.getFont3D(string, string2, f);
    }

    public String formatText(String string) {
        boolean bl;
        int n = string.indexOf("@{");
        if (n < 0 && (n = string.indexOf("%{")) < 0) {
            return string;
        }
        String string2 = string;
        boolean bl2 = bl = string2.indexOf("\\") >= 0;
        if (bl) {
            string2 = TextFormat.simpleReplace(string2, "\\%", "\u0001");
            bl = !(string2 = TextFormat.simpleReplace(string2, "\\@", "\u0002")).equals(string);
        }
        string2 = TextFormat.simpleReplace(string2, "%{", "@{");
        while ((n = string2.indexOf("@{")) >= 0) {
            int n2 = ++n + 1;
            int n3 = string2.length();
            if ((n = ScriptCompiler.ichMathTerminator(string2, n, n3)) >= n3) {
                return string2;
            }
            String string3 = string2.substring(n2, n);
            if (string3.length() == 0) {
                return string2;
            }
            Object object = this.evaluateExpression(string3);
            if (object instanceof Point3f) {
                object = Escape.escape((Point3f)object);
            }
            string2 = string2.substring(0, n2 - 2) + object.toString() + string2.substring(n + 1);
        }
        if (bl) {
            string2 = TextFormat.simpleReplace(string2, "\u0002", "@");
            string2 = TextFormat.simpleReplace(string2, "\u0001", "%");
        }
        return string2;
    }

    String getElementSymbol(int n) {
        return this.modelSet.getElementSymbol(n);
    }

    int getElementNumber(int n) {
        return this.modelSet.getElementNumber(n);
    }

    public String getAtomName(int n) {
        return this.modelSet.getAtomName(n);
    }

    public int getAtomNumber(int n) {
        return this.modelSet.getAtomNumber(n);
    }

    public Quaternion[] getAtomGroupQuaternions(BitSet bitSet, int n) {
        return this.modelSet.getAtomGroupQuaternions(bitSet, n, this.getQuaternionFrame());
    }

    public Quaternion getAtomQuaternion(int n) {
        return this.modelSet.getQuaternion(n, this.getQuaternionFrame());
    }

    public Point3f getAtomPoint3f(int n) {
        return this.modelSet.atoms[n];
    }

    public Vector getAtomPointVector(BitSet bitSet) {
        return this.modelSet.getAtomPointVector(bitSet);
    }

    public float getAtomRadius(int n) {
        return this.modelSet.getAtomRadius(n);
    }

    public int getAtomArgb(int n) {
        return this.g3d.getColorArgbOrGray(this.modelSet.getAtomColix(n));
    }

    String getAtomChain(int n) {
        return this.modelSet.getAtomChain(n);
    }

    public int getAtomModelIndex(int n) {
        return this.modelSet.getAtomModelIndex(n);
    }

    String getAtomSequenceCode(int n) {
        return this.modelSet.getAtomSequenceCode(n);
    }

    public float getBondRadius(int n) {
        return this.modelSet.getBondRadius(n);
    }

    public int getBondOrder(int n) {
        return this.modelSet.getBondOrder(n);
    }

    public void assignAromaticBonds() {
        this.modelSet.assignAromaticBonds();
    }

    public boolean getSmartAromatic() {
        return this.global.smartAromatic;
    }

    public void resetAromatic() {
        this.modelSet.resetAromatic();
    }

    public int getBondArgb1(int n) {
        return this.g3d.getColorArgbOrGray(this.modelSet.getBondColix1(n));
    }

    public int getBondModelIndex(int n) {
        return this.modelSet.getBondModelIndex(n);
    }

    public int getBondArgb2(int n) {
        return this.g3d.getColorArgbOrGray(this.modelSet.getBondColix2(n));
    }

    public Point3f[] getPolymerLeadMidPoints(int n, int n2) {
        return this.modelSet.getPolymerLeadMidPoints(n, n2);
    }

    public void setStereoMode(int[] nArray, int n, float f) {
        this.setFloatProperty("stereoDegrees", f);
        this.setBooleanProperty("greyscaleRendering", n > 1);
        if (nArray != null) {
            this.transformManager.setStereoMode(nArray);
        } else {
            this.transformManager.setStereoMode(n);
        }
    }

    boolean isStereoDouble() {
        return this.transformManager.stereoMode == 1;
    }

    public String getOperatingSystemName() {
        return this.strOSName;
    }

    public String getJavaVendor() {
        return this.strJavaVendor;
    }

    public String getJavaVersion() {
        return this.strJavaVersion;
    }

    public Graphics3D getGraphics3D() {
        return this.g3d;
    }

    public boolean showModelSetDownload() {
        return true;
    }

    public Object getProperty(String string, String string2, String string3) {
        return this.getProperty(string, string2, (Object)string3);
    }

    public boolean isScriptEditorVisible() {
        return this.scriptEditorVisible;
    }

    public Object getProperty(String string, String string2, Object object) {
        if ("DATA_API".equals(string)) {
            switch ("scriptCheck.........scriptContext.......scriptEditor........scriptEditorState...getAppConsole.......getScriptEditor.....setMenu.............spaceGroupInfo......disablePopupMenu....defaultDirectory....".indexOf(string2)) {
                case 0: {
                    return this.scriptCheck((String)object, true);
                }
                case 20: {
                    return this.eval.getScriptContext();
                }
                case 40: {
                    this.showEditor((String[])object);
                    return null;
                }
                case 60: {
                    this.scriptEditorVisible = (Boolean)object;
                    return null;
                }
                case 80: {
                    if (object instanceof JmolAppConsoleInterface) {
                        this.appConsole = (JmolAppConsoleInterface)object;
                    } else if (object != null && !((Boolean)object).booleanValue()) {
                        this.appConsole = null;
                    } else if (this.appConsole == null && object != null && ((Boolean)object).booleanValue()) {
                        for (int i = 0; i < 4 && this.appConsole == null; ++i) {
                            this.appConsole = (this.isApplet ? (JmolAppConsoleInterface)Interface.getOptionInterface("applet.AppletConsole") : (JmolAppConsoleInterface)Interface.getApplicationInterface("jmolpanel.AppConsole")).getAppConsole(this, this.display);
                            if (this.appConsole != null) continue;
                            try {
                                Thread.currentThread().wait(100L);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    this.scriptEditor = this.appConsole == null ? null : this.appConsole.getScriptEditor();
                    return this.appConsole;
                }
                case 100: {
                    if (this.appConsole == null && object != null && ((Boolean)object).booleanValue()) {
                        this.getProperty("DATA_API", "getAppConsole", Boolean.TRUE);
                        this.scriptEditor = this.appConsole == null ? null : this.appConsole.getScriptEditor();
                    }
                    return this.scriptEditor;
                }
                case 120: {
                    this.menuStructure = (String)object;
                    return this.menuStructure;
                }
                case 140: {
                    return this.getSpaceGroupInfo(null);
                }
                case 160: {
                    this.global.disablePopupMenu = true;
                    return null;
                }
                case 180: {
                    return this.global.defaultDirectory;
                }
            }
            Logger.error("ERROR in getProperty DATA_API: " + string2);
            return null;
        }
        return PropertyManager.getProperty(this, string, string2, object);
    }

    void showEditor(String[] stringArray) {
        if (stringArray == null) {
            stringArray = new String[]{null, null};
        }
        if (stringArray[1] == null) {
            stringArray[1] = "<no data>";
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        JmolScriptEditorInterface jmolScriptEditorInterface = (JmolScriptEditorInterface)this.getProperty("DATA_API", "getScriptEditor", Boolean.TRUE);
        if (string2 != null) {
            jmolScriptEditorInterface.setFilename(string);
            jmolScriptEditorInterface.output(ScriptCompiler.getEmbeddedScript(string2));
        }
        jmolScriptEditorInterface.setVisible(true);
    }

    public String getModelExtract(Object object, boolean bl, boolean bl2, boolean bl3) {
        return this.modelSet.getModelExtract(this.getAtomBitSet(object), bl, false, bl2, bl3);
    }

    public void setTainted(boolean bl) {
        this.isTainted = bl && this.refreshing;
        this.axesAreTainted = bl && this.refreshing;
    }

    public int notifyMouseClicked(int n, int n2, int n3, int n4) {
        int n5 = Binding.getModifiers(n3);
        int n6 = Binding.getClickCount(n3);
        this.global.setParameterValue("_mouseX", n);
        this.global.setParameterValue("_mouseY", this.dimScreen.height - n2);
        this.global.setParameterValue("_mouseAction", n3);
        this.global.setParameterValue("_mouseModifiers", n5);
        this.global.setParameterValue("_clickCount", n6);
        return this.statusManager.setStatusClicked(n, this.dimScreen.height - n2, n3, n6, n4);
    }

    Token checkObjectClicked(int n, int n2, int n3) {
        return this.shapeManager.checkObjectClicked(n, n2, n3, this.getVisibleFramesBitSet());
    }

    boolean checkObjectHovered(int n, int n2) {
        return this.shapeManager != null && this.shapeManager.checkObjectHovered(n, n2, this.getVisibleFramesBitSet(), this.getBondPicking());
    }

    void checkObjectDragged(int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        switch (this.getPickingMode()) {
            case 2: {
                n6 = 5;
                break;
            }
            case 4: {
                n6 = 22;
            }
        }
        if (this.shapeManager.checkObjectDragged(n, n2, n3, n4, n5, this.getVisibleFramesBitSet(), n6)) {
            this.refresh(1, "checkObjectDragged");
        }
    }

    public void rotateAxisAngleAtCenter(Point3f point3f, Vector3f vector3f, float f, float f2, boolean bl, BitSet bitSet) {
        if (Float.isNaN(f) || f == 0.0f || f2 == 0.0f) {
            return;
        }
        this.transformManager.rotateAxisAngleAtCenter(point3f, vector3f, f, f2, bl, bitSet);
        this.refresh(-1, "rotateAxisAngleAtCenter");
        if (bitSet != null && !bl) {
            this.checkMinimization();
        }
    }

    public void rotateAboutPointsInternal(Point3f point3f, Point3f point3f2, float f, float f2, boolean bl, BitSet bitSet, Vector3f vector3f, Vector vector) {
        if (!(vector3f != null && !((double)vector3f.length() < 0.001) || bl && f2 != 0.0f && !Float.isNaN(f) && f != 0.0f || !bl && f2 != 0.0f)) {
            return;
        }
        this.transformManager.rotateAboutPointsInternal(point3f, point3f2, f, f2, false, bl, bitSet, false, vector3f, vector);
        this.refresh(-1, "rotateAxisAboutPointsInternal");
        if (bitSet != null && !bl) {
            this.checkMinimization();
        }
    }

    int getPickingSpinRate() {
        return this.global.pickingSpinRate;
    }

    public void startSpinningAxis(Point3f point3f, Point3f point3f2, boolean bl) {
        if (this.getSpinOn() || this.getNavOn()) {
            this.setSpinOn(false);
            this.setNavOn(false);
            return;
        }
        this.transformManager.rotateAboutPointsInternal(point3f, point3f2, this.global.pickingSpinRate, Float.MAX_VALUE, bl, true, null, false, null, null);
    }

    public Vector3f getModelDipole() {
        return this.modelSet.getModelDipole(this.animationManager.currentModelIndex);
    }

    public Vector3f calculateMolecularDipole() {
        return this.modelSet.calculateMolecularDipole(this.animationManager.currentModelIndex);
    }

    public float getDipoleScale() {
        return this.global.dipoleScale;
    }

    public void getAtomIdentityInfo(int n, Hashtable hashtable) {
        this.modelSet.getAtomIdentityInfo(n, hashtable);
    }

    public void setDefaultLattice(Point3f point3f) {
        this.global.setDefaultLattice(point3f);
        this.global.setParameterValue("defaultLattice", Escape.escape(point3f));
    }

    public Point3f getDefaultLattice() {
        return this.global.getDefaultLattice();
    }

    public BitSet getTaintedAtoms(byte by) {
        return this.modelSet.getTaintedAtoms(by);
    }

    public void setTaintedAtoms(BitSet bitSet, byte by) {
        this.modelSet.setTaintedAtoms(bitSet, by);
    }

    public String getData(String string, String string2) {
        String string3 = "";
        if (string2.equalsIgnoreCase("MOL") || string2.equalsIgnoreCase("SDF") || string2.equalsIgnoreCase("V2000") || string2.equalsIgnoreCase("V3000")) {
            return this.getModelExtract(string, false, string2.equalsIgnoreCase("SDF"), string2.equalsIgnoreCase("V3000"));
        }
        if (string2.toLowerCase().indexOf("property_") == 0) {
            string3 = "{selected}.label(\"%{" + string2 + "}\")";
        } else {
            if (string2.equalsIgnoreCase("CML")) {
                return this.getModelCml(this.getAtomBitSet(string), Integer.MAX_VALUE, true);
            }
            string3 = string2.equalsIgnoreCase("PDB") ? "{selected and not hetero}.label(\"ATOM  %5i %-4a%1A%3.3n %1c%4R%1E   %8.3x%8.3y%8.3z%6.2Q%6.2b          %2e  \").lines+{selected and hetero}.label(\"HETATM%5i %-4a%1A%3.3n %1c%4R%1E   %8.3x%8.3y%8.3z%6.2Q%6.2b          %2e  \").lines" : (string2.startsWith("USER:") ? "{selected}.label(\"" + string2.substring(5) + "\").lines" : "\"\" + {selected}.size + \"\n\n\"+{selected}.label(\"%-2e %10.5x %10.5y %10.5z\").lines");
        }
        if (!string.equals("selected")) {
            string3 = TextFormat.simpleReplace(string3, "selected", string);
        }
        return (String)this.evaluateExpression(string3);
    }

    public String getModelCml(BitSet bitSet, int n, boolean bl) {
        return this.modelSet.getModelCml(bitSet, n, bl);
    }

    public Object evaluateExpression(Object object) {
        return ScriptEvaluator.evaluateExpression(this, object);
    }

    public Object getHelixData(BitSet bitSet, int n) {
        return this.modelSet.getHelixData(bitSet, n);
    }

    public String getPdbData(BitSet bitSet, OutputStringBuffer outputStringBuffer) {
        if (bitSet == null) {
            bitSet = this.getSelectionSet(true);
        }
        return this.modelSet.getPdbAtomData(bitSet, outputStringBuffer);
    }

    public boolean isJmolDataFrame(int n) {
        return this.modelSet.isJmolDataFrame(n);
    }

    public boolean isJmolDataFrame() {
        return this.modelSet.isJmolDataFrame(this.animationManager.currentModelIndex);
    }

    public int getJmolDataFrameIndex(int n, String string) {
        return this.modelSet.getJmolDataFrameIndex(n, string);
    }

    public void setJmolDataFrame(String string, int n, int n2) {
        this.modelSet.setJmolDataFrame(string, n, n2);
    }

    public void setFrameTitle(int n, String string) {
        this.modelSet.setFrameTitle(BitSetUtil.setBit(n), string);
    }

    public void setFrameTitle(String string) {
        this.loadShape(28);
        this.modelSet.setFrameTitle(this.getVisibleFramesBitSet(), string);
    }

    public String getFrameTitle() {
        return this.modelSet.getFrameTitle(this.animationManager.currentModelIndex);
    }

    String getJmolFrameType(int n) {
        return this.modelSet.getJmolFrameType(n);
    }

    public int getJmolDataSourceFrame(int n) {
        return this.modelSet.getJmolDataSourceFrame(n);
    }

    public void setAtomProperty(BitSet bitSet, int n, int n2, float f, String string, float[] fArray, String[] stringArray) {
        this.clearMinimization();
        this.modelSet.setAtomProperty(bitSet, n, n2, f, string, fArray, stringArray);
        switch (n) {
            case 1087375365: 
            case 1112539147: 
            case 1112539148: 
            case 1112539149: 
            case 1112541185: 
            case 1112541186: 
            case 1112541187: 
            case 1112541188: 
            case 1112541189: 
            case 1112541190: {
                this.refreshMeasures(true);
            }
        }
    }

    public void checkCoordinatesChanged() {
        this.modelSet.recalculatePositionDependentQuantities(null);
        this.refreshMeasures(true);
    }

    public void setAtomCoord(int n, float f, float f2, float f3) {
        this.modelSet.setAtomCoord(n, f, f2, f3);
    }

    public void setAtomCoord(BitSet bitSet, int n, Object object) {
        this.modelSet.setAtomCoord(bitSet, n, object);
        this.refreshMeasures(true);
    }

    public void setAtomCoordRelative(int n, float f, float f2, float f3) {
        this.modelSet.setAtomCoordRelative(n, f, f2, f3);
    }

    public void setAtomCoordRelative(Tuple3f tuple3f, BitSet bitSet) {
        this.modelSet.setAtomCoordRelative(tuple3f, bitSet == null ? this.getSelectionSet(false) : bitSet);
        this.refreshMeasures(true);
    }

    void setAllowRotateSelected(boolean bl) {
        this.global.allowRotateSelected = bl;
    }

    boolean allowRotateSelected() {
        return this.global.allowRotateSelected;
    }

    public void invertAtomCoord(Point3f point3f, BitSet bitSet) {
        this.modelSet.invertSelected(point3f, null, -1, null, bitSet);
        this.refreshMeasures(true);
        this.checkMinimization();
    }

    public void invertAtomCoord(Point4f point4f, BitSet bitSet) {
        this.modelSet.invertSelected(null, point4f, -1, null, bitSet);
        this.refreshMeasures(true);
        this.checkMinimization();
    }

    public void invertSelected(Point3f point3f, Point4f point4f, int n, BitSet bitSet) {
        this.modelSet.invertSelected(point3f, point4f, n, bitSet, this.getSelectionSet(false));
        this.refreshMeasures(true);
        this.checkMinimization();
    }

    public void moveSelected(int n, int n2, int n3, int n4, BitSet bitSet, boolean bl) {
        if (n3 == Integer.MIN_VALUE) {
            this.rotateBondIndex = -1;
        }
        if (this.isJmolDataFrame()) {
            return;
        }
        if (bitSet == null) {
            bitSet = this.getSelectionSet(false);
        }
        bitSet.andNot(this.selectionManager.getMotionFixedAtoms());
        if (n == Integer.MIN_VALUE) {
            this.showSelected = true;
            this.loadShape(8);
            this.refresh(6, "moveSelected");
            return;
        }
        if (n == Integer.MAX_VALUE) {
            this.showSelected = false;
            this.refresh(6, "moveSelected");
            return;
        }
        if (this.movingSelected) {
            return;
        }
        this.movingSelected = true;
        if (this.rotateBondIndex >= 0 && n3 != Integer.MIN_VALUE) {
            this.actionRotateBond(n, n2, n3, n4);
        } else if (bl) {
            Point3f point3f = this.getAtomSetCenter(bitSet);
            Point3i point3i = this.transformPoint(point3f);
            Point3f point3f2 = new Point3f((float)(point3i.x + n) + 0.5f, (float)(point3i.y + n2) + 0.5f, point3i.z);
            Point3f point3f3 = new Point3f();
            this.transformManager.finalizeTransformParameters();
            this.unTransformPoint(point3f2, point3f3);
            point3f3.sub(point3f);
            this.modelSet.setAtomCoordRelative(point3f3, bitSet);
        } else {
            this.transformManager.setRotateMolecule(true);
            this.transformManager.rotateXYBy(n, n2, bitSet);
            this.transformManager.setRotateMolecule(false);
        }
        this.refresh(2, "");
        this.refreshMeasures(true);
        this.checkMinimization();
        this.movingSelected = false;
    }

    public void highlightBond(int n, boolean bl) {
        if (bl && !this.isHoverEnabled()) {
            return;
        }
        BitSet bitSet = null;
        if (n >= 0) {
            Bond bond = this.modelSet.getBonds()[n];
            int n2 = bond.getAtomIndex2();
            if (!this.isAtomAssignable(n2)) {
                return;
            }
            bitSet = BitSetUtil.setBit(n2);
            bitSet.set(bond.getAtomIndex1());
        }
        this.highlight(bitSet);
        this.refresh(3, "highlightBond");
    }

    public void highlight(BitSet bitSet) {
        if (bitSet != null) {
            this.loadShape(8);
        }
        this.setShapeProperty(8, "highlight", bitSet);
    }

    void setRotateBondIndex(int n) {
        boolean bl;
        boolean bl2 = bl = this.rotateBondIndex >= 0;
        if (!bl && n < 0) {
            return;
        }
        this.rotatePrev1 = -1;
        this.bsRotateBranch = null;
        if (n == Integer.MIN_VALUE) {
            return;
        }
        this.rotateBondIndex = n;
        this.highlightBond(n, false);
    }

    int getRotateBondIndex() {
        return this.rotateBondIndex;
    }

    void actionRotateBond(int n, int n2, int n3, int n4) {
        Tuple3f tuple3f;
        Atom atom;
        Atom atom2;
        Object object;
        if (this.rotateBondIndex < 0) {
            return;
        }
        BitSet bitSet = this.bsRotateBranch;
        if (bitSet == null) {
            object = this.modelSet.getBonds()[this.rotateBondIndex];
            atom2 = ((Bond)object).getAtom1();
            atom = ((Bond)object).getAtom2();
            this.undoAction(true, atom2.index, 2);
            tuple3f = new Point3f(n3, n4, (atom2.screenZ + atom.screenZ) / 2);
            this.transformManager.unTransformPoint((Point3f)tuple3f, (Point3f)tuple3f);
            if (atom.getCovalentBondCount() == 1 || ((Point3f)tuple3f).distance(atom2) < ((Point3f)tuple3f).distance(atom) && atom2.getCovalentBondCount() != 1) {
                Atom atom3 = atom2;
                atom2 = atom;
                atom = atom3;
            }
            if (Measure.computeAngle(tuple3f, atom2, atom, true) > 90.0f || Measure.computeAngle(tuple3f, atom, atom2, true) > 90.0f) {
                bitSet = this.getBranchBitSet(atom.index, atom2.index);
            }
            if (bitSet != null) {
                int n5 = 0;
                int n6 = atom2.getBonds().length;
                while (--n6 >= 0) {
                    if (!bitSet.get(atom2.getBondedAtomIndex(n6)) || ++n5 != 2) continue;
                    bitSet = null;
                    break;
                }
            }
            if (bitSet == null) {
                bitSet = this.getMoleculeBitSet(atom2.index);
            }
            this.bsRotateBranch = bitSet;
            this.rotatePrev1 = atom2.index;
            this.rotatePrev2 = atom.index;
        } else {
            atom2 = this.modelSet.atoms[this.rotatePrev1];
            atom = this.modelSet.atoms[this.rotatePrev2];
        }
        object = new Vector3f(atom.screenX - atom2.screenX, atom.screenY - atom2.screenY, 0.0f);
        tuple3f = new Vector3f(n, n2, 0.0f);
        ((Vector3f)object).cross((Vector3f)object, (Vector3f)tuple3f);
        float f = (float)(((Vector3f)object).z > 0.0f ? 1 : -1) * ((Vector3f)tuple3f).length();
        BitSet bitSet2 = BitSetUtil.copy(bitSet);
        bitSet2.andNot(this.selectionManager.getMotionFixedAtoms());
        this.rotateAboutPointsInternal(atom2, atom, 0.0f, f, false, bitSet2, null, null);
    }

    void rotateAtoms(Matrix3f matrix3f, Matrix3f matrix3f2, boolean bl, Point3f point3f, boolean bl2, BitSet bitSet) {
        this.modelSet.rotateAtoms(matrix3f, matrix3f2, bitSet, bl, point3f, bl2);
        this.refreshMeasures(true);
        this.checkMinimization();
    }

    public void refreshMeasures(boolean bl) {
        this.setShapeProperty(6, "refresh", null);
        if (bl) {
            this.stopMinimization();
        }
    }

    void setDynamicMeasurements(boolean bl) {
        this.global.dynamicMeasurements = bl;
    }

    public boolean getDynamicMeasurements() {
        return this.global.dynamicMeasurements;
    }

    public float[][] functionXY(String string, int n, int n2) {
        float[][] fArray;
        String string2 = null;
        if (string.indexOf("file:") == 0) {
            string2 = this.getFileAsString(string.substring(5));
        } else if (string.indexOf("data2d_") != 0) {
            return this.statusManager.functionXY(string, n, n2);
        }
        n = Math.abs(n);
        n2 = Math.abs(n2);
        if (string2 == null) {
            fArray = this.getDataFloat2D(string);
            if (fArray != null) {
                return fArray;
            }
            string2 = "";
        }
        fArray = new float[n][n2];
        float[] fArray2 = new float[n * n2];
        Parser.parseStringInfestedFloatArray(string2, null, fArray2);
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                fArray[i][j] = fArray2[n3++];
            }
        }
        return fArray;
    }

    public float[][][] functionXYZ(String string, int n, int n2, int n3) {
        float[][][] fArray;
        String string2 = null;
        if (string.indexOf("file:") == 0) {
            string2 = this.getFileAsString(string.substring(5));
        } else if (string.indexOf("data3d_") != 0) {
            return this.statusManager.functionXYZ(string, n, n2, n3);
        }
        n = Math.abs(n);
        n2 = Math.abs(n2);
        n3 = Math.abs(n3);
        if (string2 == null) {
            fArray = this.getDataFloat3D(string);
            if (fArray != null) {
                return fArray;
            }
            string2 = "";
        }
        fArray = new float[n][n2][n3];
        float[] fArray2 = new float[n * n2 * n3];
        Parser.parseStringInfestedFloatArray(string2, null, fArray2);
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    fArray[i][j][k] = fArray2[n4++];
                }
            }
        }
        return fArray;
    }

    public void getHelp(String string) {
        if (string.length() > 0 && string.indexOf("?") != 0 && this.global.helpPath.indexOf("?") < 0) {
            string = "?search=" + string;
        }
        this.showUrl(this.global.helpPath + string);
    }

    public void addCommand(String string) {
        if (this.autoExit || !this.haveDisplay || !this.getPreserveState()) {
            return;
        }
        this.commandHistory.addCommand(TextFormat.replaceAllCharacters(string, "\r\n\t", " "));
    }

    public String removeCommand() {
        return this.commandHistory.removeCommand();
    }

    public String getSetHistory(int n) {
        return this.commandHistory.getSetHistory(n);
    }

    public void writeTextFile(String string, String string2) {
        this.createImage(string, "txt", string2, Integer.MIN_VALUE, 0, 0);
    }

    public String clipImage(String string) {
        try {
            JmolImageCreatorInterface jmolImageCreatorInterface = (JmolImageCreatorInterface)Interface.getOptionInterface("export.image.ImageCreator");
            jmolImageCreatorInterface.setViewer(this, this.privateKey);
            return jmolImageCreatorInterface.clipImage(string);
        }
        catch (Error error) {
            return GT._("clipboard is not accessible -- use signed applet");
        }
    }

    public String createImage(String string, String string2, Object object, int n, int n2, int n3, BitSet bitSet, String[] stringArray) {
        if (bitSet == null) {
            return (String)this.createImage(string, string2, object, n, n2, n3, stringArray);
        }
        String string3 = "";
        int n4 = 0;
        int n5 = string.indexOf(".");
        if (n5 < 0) {
            n5 = string.length();
        }
        String string4 = string.substring(0, n5);
        String string5 = string.substring(n5);
        int n6 = bitSet.nextSetBit(0);
        while (n6 >= 0) {
            this.setCurrentModelIndex(n6);
            string = "0000" + ++n4;
            string = string4 + string.substring(string.length() - 4) + string5;
            if (stringArray != null) {
                stringArray[0] = string;
            }
            String string6 = (String)this.createImage(string, string2, object, n, n2, n3);
            Logger.info(string6);
            string3 = string3 + string6 + "\n";
            if (!string6.startsWith("OK")) {
                return "ERROR WRITING FILE SET: \n" + string3;
            }
            n6 = bitSet.nextSetBit(n6 + 1);
        }
        if (string3.length() == 0) {
            string3 = "OK\n";
        }
        return string3 + "\n" + n4 + " files created";
    }

    public Object createImage(String string, String string2, Object object, int n, int n2, int n3) {
        return this.createImage(string, string2, object, n, n2, n3, null);
    }

    public Object createImage(String string, String string2, Object object, int n, int n2, int n3, String[] stringArray) {
        int n4 = this.dimScreen.width;
        int n5 = this.dimScreen.height;
        if (n != Integer.MIN_VALUE) {
            this.mustRender = true;
            this.resizeImage(n2, n3, true, false, false);
            this.setModelVisibility();
        }
        this.creatingImage = true;
        Object object2 = null;
        try {
            if (string == null) {
                object2 = this.clipImage((String)object);
            } else {
                string = this.getFileNameFromDialog(string, n);
                if (stringArray != null) {
                    stringArray[0] = string;
                }
                if (string == null) {
                    object2 = "CANCELED";
                } else if (string2.equals("ZIP") || string2.equals("ZIPALL")) {
                    object2 = this.fileManager.createZipSet(string, (String)object, string2.equals("ZIPALL"));
                } else {
                    if (!string2.equals("OutputStream")) {
                        object2 = this.statusManager.createImage(string, string2, object, n);
                    }
                    if (object2 == null) {
                        JmolImageCreatorInterface jmolImageCreatorInterface = (JmolImageCreatorInterface)Interface.getOptionInterface("export.image.ImageCreator");
                        jmolImageCreatorInterface.setViewer(this, this.privateKey);
                        object2 = jmolImageCreatorInterface.createImage(string, string2, object, n);
                        if (object2 instanceof String) {
                            this.statusManager.createImage((String)object2, string2, null, n);
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            object2 = "ERROR creating image: " + throwable;
            Logger.error(this.setErrorMessage((String)object2));
        }
        this.creatingImage = false;
        if (n != Integer.MIN_VALUE) {
            this.resizeImage(n4, n5, true, false, true);
        }
        return "CANCELED".equals(object2) ? null : object2;
    }

    private String getFileNameFromDialog(String string, int n) {
        boolean bl;
        if (string == null) {
            return null;
        }
        boolean bl2 = bl = string.indexOf("?") == 0;
        if (bl) {
            string = string.substring(1);
        }
        string = FileManager.getLocalPathForWritingFile(this, string);
        if (bl |= this.isApplet) {
            string = this.dialogAsk(n == Integer.MIN_VALUE ? "save" : "saveImage", string);
        }
        return string;
    }

    private void setSyncTarget(int n, boolean bl) {
        switch (n) {
            case 0: {
                this.statusManager.syncingMouse = bl;
                break;
            }
            case 1: {
                this.statusManager.syncingScripts = bl;
                break;
            }
            case 2: {
                this.statusManager.syncSend(bl ? SYNC_GRAPHICS_MESSAGE : SYNC_NO_GRAPHICS_MESSAGE, "*");
                if (Float.isNaN(this.transformManager.stereoDegrees)) {
                    this.setFloatProperty("stereoDegrees", -5.0f);
                }
                if (bl) {
                    this.setBooleanProperty("_syncMouse", false);
                    this.setBooleanProperty("_syncScript", false);
                }
                return;
            }
        }
        if (!this.statusManager.syncingScripts && !this.statusManager.syncingMouse) {
            this.refresh(-1, "set sync");
        }
    }

    public void syncScript(String string, String string2) {
        if (string.equalsIgnoreCase(SYNC_GRAPHICS_MESSAGE)) {
            this.statusManager.setSyncDriver(5);
            this.statusManager.syncSend(string, string2);
            this.setBooleanProperty("_syncMouse", false);
            this.setBooleanProperty("_syncScript", false);
            return;
        }
        boolean bl = "~".equals(string2);
        if (!bl && !".".equals(string2)) {
            this.statusManager.syncSend(string, string2);
            if (!"*".equals(string2)) {
                return;
            }
        }
        if (string.equalsIgnoreCase("on")) {
            this.statusManager.setSyncDriver(1);
            return;
        }
        if (string.equalsIgnoreCase("off")) {
            this.statusManager.setSyncDriver(0);
            return;
        }
        if (string.equalsIgnoreCase("slave")) {
            this.statusManager.setSyncDriver(2);
            return;
        }
        int n = this.statusManager.getSyncMode();
        if (n == 0) {
            return;
        }
        if (n != 1) {
            bl = false;
        }
        if (Logger.debugging) {
            Logger.debug(this.htmlName + " syncing with script: " + string);
        }
        if (bl) {
            this.statusManager.setSyncDriver(3);
        }
        if (string.indexOf("Mouse: ") != 0) {
            this.evalStringQuiet(string, true, false);
            return;
        }
        String[] stringArray = Parser.getTokens(string);
        String string3 = stringArray[1];
        switch (stringArray.length) {
            case 3: {
                if (string3.equals("zoomByFactor")) {
                    this.zoomByFactor(Parser.parseFloat(stringArray[2]), Integer.MAX_VALUE, Integer.MAX_VALUE);
                    break;
                }
                if (string3.equals("zoomBy")) {
                    this.zoomBy(Parser.parseInt(stringArray[2]));
                    break;
                }
                if (!string3.equals("rotateZBy")) break;
                this.rotateZBy(Parser.parseInt(stringArray[2]), Integer.MAX_VALUE, Integer.MAX_VALUE);
                break;
            }
            case 4: {
                if (string3.equals("rotateXYBy")) {
                    this.rotateXYBy(Parser.parseFloat(stringArray[2]), Parser.parseFloat(stringArray[3]));
                    break;
                }
                if (string3.equals("translateXYBy")) {
                    this.translateXYBy(Parser.parseInt(stringArray[2]), Parser.parseInt(stringArray[3]));
                    break;
                }
                if (!string3.equals("rotateMolecule")) break;
                this.rotateMolecule(Parser.parseFloat(stringArray[2]), Parser.parseFloat(stringArray[3]), null);
                break;
            }
            case 5: {
                if (string3.equals("spinXYBy")) {
                    this.spinXYBy(Parser.parseInt(stringArray[2]), Parser.parseInt(stringArray[3]), Parser.parseFloat(stringArray[4]));
                    break;
                }
                if (string3.equals("zoomByFactor")) {
                    this.zoomByFactor(Parser.parseFloat(stringArray[2]), Parser.parseInt(stringArray[3]), Parser.parseInt(stringArray[4]));
                    break;
                }
                if (string3.equals("rotateZBy")) {
                    this.rotateZBy(Parser.parseInt(stringArray[2]), Parser.parseInt(stringArray[3]), Parser.parseInt(stringArray[4]));
                    break;
                }
                if (!string3.equals("rotateArcBall")) break;
                this.rotateArcBall(Parser.parseInt(stringArray[2]), Parser.parseInt(stringArray[3]), Parser.parseFloat(stringArray[4]));
                break;
            }
            case 7: {
                if (!string3.equals("centerAt")) break;
                this.centerAt(Parser.parseInt(stringArray[2]), Parser.parseInt(stringArray[3]), new Point3f(Parser.parseFloat(stringArray[4]), Parser.parseFloat(stringArray[5]), Parser.parseFloat(stringArray[6])));
            }
        }
        if (bl) {
            this.setSyncDriver(4);
        }
    }

    void setSyncDriver(int n) {
        this.statusManager.setSyncDriver(n);
    }

    public float[] getPartialCharges() {
        return this.modelSet.getPartialCharges();
    }

    public float[] getAtomicPotentials(boolean bl, BitSet bitSet, BitSet bitSet2, String string) {
        float[] fArray = new float[this.getAtomCount()];
        MepCalculationInterface mepCalculationInterface = (MepCalculationInterface)Interface.getOptionInterface("quantum.MlpCalculation");
        String string2 = string == null ? null : this.getFileAsString(string);
        mepCalculationInterface.assignPotentials(this.modelSet.atoms, fArray, this.getSmartsMatch("a", bitSet), this.getSmartsMatch("/noAromatic/[$(C=O),$(O=C),$(NC=O)]", bitSet), bitSet2, string2);
        return fArray;
    }

    public void setProteinType(byte by, BitSet bitSet) {
        this.modelSet.setProteinType(bitSet == null ? this.getSelectionSet(false) : bitSet, by);
    }

    public Point3f getBondPoint3f1(int n) {
        return this.modelSet.getBondAtom1(n);
    }

    public Point3f getBondPoint3f2(int n) {
        return this.modelSet.getBondAtom2(n);
    }

    public Vector3f getVibrationVector(int n) {
        return this.modelSet.getVibrationVector(n, false);
    }

    public int getVanderwaalsMar(int n) {
        return this.dataManager.defaultVdw == 9 ? this.dataManager.userVdwMars[n] : JmolConstants.getVanderwaalsMar(n, this.dataManager.defaultVdw);
    }

    public int getVanderwaalsMar(int n, int n2) {
        switch (n2) {
            case 9: {
                if (this.dataManager.bsUserVdws == null) {
                    n2 = this.dataManager.defaultVdw;
                    break;
                }
                return this.dataManager.userVdwMars[n];
            }
            case -1: {
                n2 = this.dataManager.defaultVdw;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                if (this.dataManager.defaultVdw == 8) break;
                n2 = this.dataManager.defaultVdw;
            }
        }
        return JmolConstants.getVanderwaalsMar(n, n2);
    }

    void setDefaultVdw(String string) {
        int n = JmolConstants.getVdwType(string);
        if (n == -1) {
            n = 8;
        }
        this.dataManager.setDefaultVdw(n);
        this.global.setParameterValue("defaultVDW", this.getDefaultVdwTypeNameOrData(Integer.MIN_VALUE));
    }

    public String getDefaultVdwTypeNameOrData(int n) {
        return this.dataManager.getDefaultVdwNameOrData(n, null);
    }

    public int deleteAtoms(BitSet bitSet, boolean bl) {
        this.clearModelDependentObjects();
        if (!bl) {
            this.modelSet.deleteAtoms(bitSet);
            int n = this.selectionManager.deleteAtoms(bitSet);
            this.setTainted(true);
            return n;
        }
        this.setCurrentModelIndex(0, false);
        this.animationManager.setAnimationOn(false);
        BitSet bitSet2 = BitSetUtil.copy(this.getDeletedAtoms());
        BitSet bitSet3 = this.modelSet.deleteModels(bitSet);
        this.selectionManager.processDeletedModelAtoms(bitSet3);
        this.setAnimationRange(0, 0);
        this.eval.deleteAtomsInVariables(bitSet3);
        this.repaintManager.clear();
        this.animationManager.clear();
        this.animationManager.initializePointers(1);
        if (this.getModelCount() > 1) {
            this.setCurrentModelIndex(-1, true);
        }
        this.hoverAtomIndex = -1;
        this.setFileLoadStatus(5, null, null, null, null);
        this.refreshMeasures(true);
        if (bitSet2 != null) {
            bitSet3.andNot(bitSet2);
        }
        return BitSetUtil.cardinalityOf(bitSet3);
    }

    public void deleteBonds(BitSet bitSet) {
        this.modelSet.deleteBonds(bitSet, false);
    }

    public void deleteModelAtoms(int n, int n2, BitSet bitSet) {
        this.selectionManager.deleteModelAtoms(n, n2, bitSet);
        BitSetUtil.deleteBits(this.getFrameOffsets(), bitSet);
        this.setFrameOffsets(this.getFrameOffsets());
        this.dataManager.deleteModelAtoms(n, n2, bitSet);
    }

    public BitSet getDeletedAtoms() {
        return this.selectionManager.getDeletedAtoms();
    }

    public char getQuaternionFrame() {
        return this.global.quaternionFrame.charAt(this.global.quaternionFrame.length() == 2 ? 1 : 0);
    }

    public int getHelixStep() {
        return this.global.helixStep;
    }

    public String calculatePointGroup() {
        return this.modelSet.calculatePointGroup(this.getSelectionSet(false));
    }

    public Hashtable getPointGroupInfo(Object object) {
        return this.modelSet.getPointGroupInfo(this.getAtomBitSet(object));
    }

    public String getPointGroupAsString(boolean bl, String string, int n, float f) {
        return this.modelSet.getPointGroupAsString(this.getSelectionSet(false), bl, string, n, f);
    }

    public float getPointGroupTolerance(int n) {
        switch (n) {
            case 0: {
                return this.global.pointGroupDistanceTolerance;
            }
            case 1: {
                return this.global.pointGroupLinearTolerance;
            }
        }
        return 0.0f;
    }

    public Object getFileAsImage(String string, Hashtable hashtable) {
        if (!this.haveDisplay) {
            return "no display";
        }
        Object object = this.fileManager.getFileAsImage(string, hashtable);
        if (object instanceof String) {
            return object;
        }
        Image image = (Image)object;
        MediaTracker mediaTracker = new MediaTracker(this.display);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return image;
    }

    public String cd(String string) {
        String string2;
        if (string == null) {
            string = ".";
        } else if (string.length() == 0) {
            this.setStringProperty("defaultDirectory", "");
            string = ".";
        }
        string = this.fileManager.getDefaultDirectory(string + (string.equals("=") || string.endsWith("/") ? "" : "/X"));
        if (string.length() > 0) {
            this.setStringProperty("defaultDirectory", string);
        }
        if ((string2 = this.fileManager.getFilePath(string + "/", true, false)).startsWith("file:/")) {
            FileManager.setLocalPath(this, string, false);
        }
        return string;
    }

    private String setErrorMessage(String string) {
        return this.setErrorMessage(string, null);
    }

    private String setErrorMessage(String string, String string2) {
        this.errorMessageUntranslated = string2;
        this.errorMessage = string;
        return this.errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorMessageUntranslated() {
        return this.errorMessageUntranslated == null ? this.errorMessage : this.errorMessageUntranslated;
    }

    public void setShapeErrorState(int n, String string) {
        this.currentShapeID = n;
        this.currentShapeState = string;
    }

    public String getShapeErrorState() {
        if (this.currentShapeID < 0) {
            return "";
        }
        if (this.modelSet != null) {
            this.shapeManager.releaseShape(this.currentShapeID);
        }
        this.repaintManager.clear(this.currentShapeID);
        return JmolConstants.getShapeClassName(this.currentShapeID) + " " + this.currentShapeState;
    }

    public void handleError(Error error, boolean bl) {
        try {
            if (bl) {
                this.zap("" + error);
            }
            this.setCursor(0);
            this.setBooleanProperty("refreshing", true);
            Logger.error("viewer handling error condition: " + error);
            this.notifyError("Error", "doClear=" + bl + "; " + error, "" + error);
        }
        catch (Throwable throwable) {
            try {
                Logger.error("Could not notify error " + error + ": due to " + throwable);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
    }

    public float[] getAtomicCharges() {
        return this.modelSet.getAtomicCharges();
    }

    public ScriptFunction getFunction(String string) {
        return this.stateManager.getFunction(string);
    }

    public void addFunction(ScriptFunction scriptFunction) {
        this.stateManager.addFunction(scriptFunction);
    }

    public void clearFunctions() {
        this.stateManager.clearFunctions();
    }

    public boolean isFunction(String string) {
        return this.stateManager.isFunction(string);
    }

    public String getFunctionCalls(String string) {
        return this.stateManager.getFunctionCalls(string);
    }

    public void showMessage(String string) {
        if (!this.isPrintOnly) {
            Logger.warn(string);
        }
    }

    public String getMoInfo(int n) {
        return this.modelSet.getMoInfo(n);
    }

    boolean isRepaintPending() {
        return this.repaintManager.repaintPending;
    }

    public Hashtable getContextVariables() {
        return this.eval.getContextVariables();
    }

    public boolean checkPrivateKey(double d) {
        return d == this.privateKey;
    }

    public void bindAction(String string, String string2, Point3f point3f, Point3f point3f2) {
        if (this.haveDisplay) {
            this.actionManager.bindAction(string, string2, point3f, point3f2);
        }
    }

    public void unBindAction(String string, String string2) {
        if (this.haveDisplay) {
            this.actionManager.unbindAction(string, string2);
        }
    }

    public Object getMouseInfo() {
        return this.haveDisplay ? this.actionManager.getMouseInfo() : null;
    }

    public void clearTimeout(String string) {
        this.setTimeout(string, 0, null);
    }

    public void setTimeout(String string, int n, String string2) {
        if (this.haveDisplay) {
            this.actionManager.setTimeout(string, n, string2);
        }
    }

    public String showTimeout(String string) {
        return this.haveDisplay ? this.actionManager.showTimeout(string) : "";
    }

    public int getFrontPlane() {
        return this.transformManager.getFrontPlane();
    }

    public Vector getPlaneIntersection(int n, Point4f point4f, float f, int n2) {
        return this.modelSet.getPlaneIntersection(n, point4f, f, n2, this.animationManager.currentModelIndex);
    }

    void repaint() {
        if (this.haveDisplay) {
            this.display.repaint();
        }
    }

    public OutputStream getOutputStream(String string, String[] stringArray) {
        Object object = this.createImage(string, "OutputStream", null, Integer.MIN_VALUE, 0, 0, stringArray);
        if (object instanceof String) {
            Logger.error((String)object);
            return null;
        }
        return (OutputStream)object;
    }

    public int calculateStruts(BitSet bitSet, BitSet bitSet2) {
        return this.modelSet.calculateStruts(bitSet == null ? this.getSelectionSet(false) : bitSet, bitSet2 == null ? this.getSelectionSet(false) : bitSet2);
    }

    public boolean getStrutsMultiple() {
        return this.global.strutsMultiple;
    }

    public int getStrutSpacingMinimum() {
        return this.global.strutSpacing;
    }

    public float getStrutLengthMaximum() {
        return this.global.strutLengthMaximum;
    }

    public float getStrutDefaultRadius() {
        return this.global.strutDefaultRadius;
    }

    public boolean getPreserveState() {
        return this.global.preserveState;
    }

    public boolean getDragSelected() {
        return this.global.dragSelected && !this.global.modelKitMode;
    }

    public float getLoadAtomDataTolerance() {
        return this.global.loadAtomDataTolerance;
    }

    public boolean getAllowGestures() {
        return this.global.allowGestures;
    }

    public boolean getLogGestures() {
        return this.global.logGestures;
    }

    public boolean allowMultiTouch() {
        return this.global.allowMultiTouch;
    }

    public boolean logCommands() {
        return this.global.logCommands;
    }

    public String getLogFile() {
        return this.logFile == null ? "" : this.logFile;
    }

    private String setLogFile(String string) {
        String string2 = null;
        if (this.logFilePath == null || string.indexOf("\\") >= 0 || string.indexOf("/") >= 0) {
            string = null;
        } else if (string.length() > 0) {
            if (!string.startsWith("JmolLog_")) {
                string = "JmolLog_" + string;
            }
            try {
                string2 = this.isApplet ? this.logFilePath + string : new File(this.logFilePath + string).getAbsolutePath();
            }
            catch (Exception exception) {
                string = null;
            }
        }
        if (string == null) {
            Logger.info(GT._("Cannot set log file path."));
        } else {
            if (string2 != null) {
                Logger.info(GT._("Setting log file to {0}", string2));
            }
            this.logFile = string2;
        }
        return string;
    }

    public void log(String string) {
        try {
            if (this.logFile == null || string == null) {
                return;
            }
            boolean bl = string.equals("$CLEAR$");
            if (string.indexOf("$NOW$") >= 0) {
                string = TextFormat.simpleReplace(string, "$NOW$", new Date().toString());
            }
            FileWriter fileWriter = new FileWriter(this.logFile, !bl);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            if (!bl) {
                bufferedWriter.write(string);
                bufferedWriter.write(10);
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            Logger.debug("cannot log " + string);
        }
    }

    boolean isKiosk() {
        return this.isKiosk;
    }

    public boolean hasFocus() {
        return this.haveDisplay && (this.isKiosk || this.display.hasFocus());
    }

    public void setFocus() {
        if (this.haveDisplay && !this.display.hasFocus()) {
            this.display.requestFocusInWindow();
        }
    }

    public MinimizerInterface getMinimizer(boolean bl) {
        if (this.minimizer == null && bl) {
            this.minimizer = (MinimizerInterface)Interface.getOptionInterface("minimize.Minimizer");
            this.minimizer.setProperty("viewer", this);
        }
        return this.minimizer;
    }

    void stopMinimization() {
        if (this.minimizer != null) {
            this.minimizer.setProperty("stop", null);
        }
    }

    void clearMinimization() {
        if (this.minimizer != null) {
            this.minimizer.setProperty("clear", null);
        }
    }

    public String getMinimizationInfo() {
        return this.minimizer == null ? "" : (String)this.minimizer.getProperty("log", 0);
    }

    public boolean useMinimizationThread() {
        return this.global.useMinimizationThread && !this.autoExit;
    }

    private void checkMinimization() {
        if (!this.global.monitorEnergy) {
            return;
        }
        this.minimize(0, 0.0f, this.getModelUndeletedAtomsBitSet(-1), null, 0.0f, false, true, false);
        this.echoMessage("Energy = " + this.getParameter("_minimizationEnergy"));
    }

    public void minimize(int n, float f, BitSet bitSet, BitSet bitSet2, float f2, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        BitSet bitSet3 = this.getModelUndeletedAtomsBitSet(this.getVisibleFramesBitSet());
        if (bitSet == null) {
            bitSet = this.getModelUndeletedAtomsBitSet(this.getVisibleFramesBitSet().length() - 1);
        } else {
            bitSet.and(bitSet3);
        }
        if (f2 <= 0.0f) {
            f2 = 5.0f;
        }
        BitSet bitSet4 = BitSetUtil.copy(bitSet2 == null ? this.selectionManager.getMotionFixedAtoms() : bitSet2);
        boolean bl5 = bl4 = bitSet4.cardinality() > 0;
        if (bl4) {
            bitSet.andNot(bitSet4);
        }
        BitSet bitSet5 = this.getAtomsWithin(f2, bitSet, true);
        bitSet5.andNot(bitSet);
        if (bl4) {
            bitSet4.and(bitSet5);
        } else {
            bitSet4 = bitSet5;
        }
        bitSet4.and(bitSet3);
        if (bl) {
            bitSet.or(this.addHydrogens(bitSet, bl3, bl2));
        }
        if (bitSet.cardinality() > 200) {
            Logger.error("Too many atoms for minimization (>200)");
            return;
        }
        try {
            if (!bl2) {
                Logger.info("Minimizing " + bitSet.cardinality() + " atoms");
            }
            this.getMinimizer(true).minimize(n, f, bitSet, bitSet4, bl4, bl2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Logger.error(exception.getMessage());
        }
    }

    public void setMotionFixedAtoms(BitSet bitSet) {
        this.selectionManager.setMotionFixedAtoms(bitSet);
    }

    public BitSet getMotionFixedAtoms() {
        return this.selectionManager.getMotionFixedAtoms();
    }

    boolean useArcBall() {
        return this.global.useArcBall;
    }

    void rotateArcBall(int n, int n2, float f) {
        this.transformManager.rotateArcBall(n, n2, f);
        this.refresh(2, this.statusManager.syncingMouse ? "Mouse: rotateArcBall " + n + " " + n2 + " " + f : "");
    }

    void getAtomicPropertyState(StringBuffer stringBuffer, byte by, BitSet bitSet, String string, float[] fArray) {
        this.modelSet.getAtomicPropertyState(stringBuffer, by, bitSet, string, fArray);
    }

    public Point3f[][] getCenterAndPoints(Vector vector, boolean bl) {
        return this.modelSet.getCenterAndPoints(vector, bl);
    }

    public int getSmallMoleculeMaxAtoms() {
        return this.global.smallMoleculeMaxAtoms;
    }

    public String streamFileData(String string, String string2, String string3, int n, Object[] objectArray) {
        String string4 = null;
        String[] stringArray = new String[1];
        OutputStream outputStream = this.getOutputStream(string, stringArray);
        if (outputStream == null) {
            return "";
        }
        if (string2.equals("PDB")) {
            OutputStringBuffer outputStringBuffer = new OutputStringBuffer(new BufferedOutputStream(outputStream));
            string4 = this.getPdbData(null, outputStringBuffer);
        } else if (string2.equals("FILE")) {
            string4 = this.writeCurrentFile(outputStream);
        } else if (string2.equals("PLOT")) {
            OutputStringBuffer outputStringBuffer = new OutputStringBuffer(new BufferedOutputStream(outputStream));
            string4 = this.modelSet.getPdbData(n, string3, this.getSelectionSet(false), objectArray, outputStringBuffer);
        }
        if (string4 != null) {
            string4 = "OK " + string4 + " " + stringArray[0];
        }
        try {
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string4;
    }

    public String getPdbData(int n, String string, Object[] objectArray) {
        return this.modelSet.getPdbData(n, string, this.getSelectionSet(false), objectArray, null);
    }

    public int getRepaintWait() {
        return this.global.repaintWaitMs;
    }

    public BitSet getGroupsWithin(int n, BitSet bitSet) {
        return this.modelSet.getGroupsWithin(n, bitSet);
    }

    public Object getExecutor() {
        if (this.executor != null || nProcessors < 2) {
            return this.executor;
        }
        try {
            this.executor = ParallelProcessor.getExecutor();
        }
        catch (Exception exception) {
            this.executor = null;
        }
        catch (Error error) {
            this.executor = null;
        }
        if (this.executor == null) {
            Logger.error("parallel processing is not available");
        }
        return this.executor;
    }

    public boolean eval(ScriptContext scriptContext, ShapeManager shapeManager) {
        this.displayLoadErrors = false;
        boolean bl = ScriptEvaluator.evaluateContext(this, scriptContext, shapeManager == null ? this.shapeManager : shapeManager);
        this.displayLoadErrors = true;
        return bl;
    }

    public Hashtable getShapeInfo() {
        return this.shapeManager.getShapeInfo();
    }

    public void togglePickingLabel(BitSet bitSet) {
        if (bitSet == null) {
            bitSet = this.getSelectionSet(false);
        }
        this.loadShape(5);
        this.shapeManager.setShapeProperty(5, "toggleLabel", null, bitSet);
    }

    public void loadShape(int n) {
        this.shapeManager.loadShape(n);
    }

    public void setShapeSize(int n, int n2, BitSet bitSet) {
        if (bitSet == null) {
            bitSet = this.getSelectionSet(false);
        }
        this.shapeManager.setShapeSize(n, n2, null, bitSet);
    }

    public void setShapeSize(int n, RadiusData radiusData, BitSet bitSet) {
        this.shapeManager.setShapeSize(n, 0, radiusData, bitSet);
    }

    public void setShapeProperty(int n, String string, Object object) {
        if (n < 0) {
            return;
        }
        this.shapeManager.setShapeProperty(n, string, object, null);
    }

    public Object getShapeProperty(int n, String string) {
        return this.shapeManager.getShapeProperty(n, string, Integer.MIN_VALUE);
    }

    public boolean getShapeProperty(int n, String string, Object[] objectArray) {
        return this.shapeManager.getShapeProperty(n, string, objectArray);
    }

    public Object getShapeProperty(int n, String string, int n2) {
        return this.shapeManager.getShapeProperty(n, string, n2);
    }

    private int getShapePropertyAsInt(int n, String string) {
        Object object = this.getShapeProperty(n, string);
        return object == null || !(object instanceof Integer) ? Integer.MIN_VALUE : (Integer)object;
    }

    public void setModelVisibility() {
        if (this.shapeManager == null) {
            return;
        }
        this.shapeManager.setModelVisibility();
    }

    public void resetShapes() {
        this.shapeManager.resetShapes();
    }

    public void setAtomLabel(String string, int n) {
        this.shapeManager.setAtomLabel(string, n);
    }

    public void deleteShapeAtoms(Object[] objectArray, BitSet bitSet) {
        this.shapeManager.deleteShapeAtoms(objectArray, bitSet);
    }

    public void getShapeState(StringBuffer stringBuffer, boolean bl) {
        this.shapeManager.getShapeState(stringBuffer, bl);
    }

    public void resetBioshapes(BitSet bitSet) {
        this.shapeManager.resetBioshapes(bitSet);
    }

    public float getAtomShapeValue(int n, Group group, int n2) {
        return this.shapeManager.getAtomShapeValue(n, group, n2);
    }

    public void mergeShapes(Shape[] shapeArray) {
        this.shapeManager.mergeShapes(shapeArray);
    }

    public ShapeManager getShapeManager() {
        return this.shapeManager;
    }

    public boolean setParallel(boolean bl) {
        this.isParallel = this.global.multiProcessor && bl;
        return this.isParallel;
    }

    public boolean isParallel() {
        return this.global.multiProcessor && this.isParallel;
    }

    public BitSet transformAtoms(boolean bl) {
        return this.shapeManager.transformAtoms(bl);
    }

    private void setAtomPickingOption(String string) {
        if (this.haveDisplay) {
            this.actionManager.setAtomPickingOption(string);
        }
    }

    private void setBondPickingOption(String string) {
        if (this.haveDisplay) {
            this.actionManager.setBondPickingOption(string);
        }
    }

    void undoAction(boolean bl, int n, int n2) {
        int n3 = n >= 0 ? (int)this.modelSet.atoms[n].modelIndex : this.modelSet.getModelCount() - 1;
        System.out.println(bl + " " + n2 + " undoAction " + this.modelSet.getModels()[n3].isModelkit());
        if (!this.modelSet.getModels()[n3].isModelkit()) {
            return;
        }
        if (!bl) {
            String string;
            this.stopMinimization();
            if (this.lastUndoRedo != 0 && this.lastUndoRedo != n2) {
                try {
                    if (n2 == -1) {
                        this.actionStates.add(0, this.actionStatesRedo.remove(0));
                    } else {
                        this.actionStatesRedo.add(0, this.actionStates.remove(0));
                    }
                }
                catch (Exception exception) {
                    System.out.println("oops");
                }
            }
            this.lastUndoRedo = n2;
            if (n2 == -1) {
                if (this.actionStatesRedo.size() == 0) {
                    return;
                }
                string = (String)this.actionStatesRedo.remove(0);
                this.actionStates.add(0, string);
            } else {
                if (this.actionStates.size() == 0) {
                    return;
                }
                string = (String)this.actionStates.remove(0);
                this.actionStatesRedo.add(0, string);
            }
            if (Logger.debugging) {
                this.log(string);
            }
            this.evalStringQuiet(string);
            return;
        }
        this.lastUndoRedo = 0;
        this.actionStatesRedo.clear();
        StringBuffer stringBuffer = new StringBuffer();
        if (n >= 0) {
            BitSet bitSet = this.getModelUndeletedAtomsBitSet(n3);
            this.modelSet.taint(bitSet, (byte)n2);
            stringBuffer.append(this.modelSet.getAtomicPropertyState(-1, null));
        } else {
            BitSet bitSet = this.getModelUndeletedAtomsBitSet(n3);
            stringBuffer.append("zap ");
            stringBuffer.append(Escape.escape(bitSet)).append(";");
            DataManager.getInlineData(stringBuffer, this.modelSet.getModelExtract(bitSet, false, true, false, false), true, null);
            stringBuffer.append("set refreshing false;").append(this.actionManager.getPickingState()).append(this.transformManager.getMoveToText(0.0f, false)).append("set refreshing true;");
        }
        this.actionStates.add(0, stringBuffer.toString());
        if (this.actionStates.size() == 100) {
            this.actionStates.removeElementAt(99);
        }
    }

    public void assignBond(int n, char c) {
        try {
            BitSet bitSet = this.modelSet.setBondOrder(n, c);
            if (bitSet == null || c == '0') {
                this.refresh(3, "setBondOrder");
            } else {
                this.addHydrogens(bitSet, false, true);
            }
        }
        catch (Exception exception) {
            Logger.error("assignBond failed");
        }
    }

    public void assignAtom(int n, Point3f point3f, String string) {
        if (string.equals("X")) {
            this.setRotateBondIndex(-1);
        }
        if (this.modelSet.atoms[n].modelIndex != this.modelSet.getModelCount() - 1) {
            return;
        }
        this.clearModelDependentObjects();
        if (point3f == null) {
            this.modelSet.assignAtom(n, string, true);
            this.modelSet.setAtomNamesAndNumbers(n, -1, null);
            this.refresh(3, "assignAtom");
            return;
        }
        Atom atom = this.modelSet.atoms[n];
        BitSet bitSet = BitSetUtil.setBit(n);
        Point3f[] point3fArray = new Point3f[]{point3f};
        Vector<Atom> vector = new Vector<Atom>();
        vector.add(atom);
        try {
            bitSet = this.addHydrogensInline(bitSet, vector, point3fArray);
            n = bitSet.nextSetBit(0);
            this.modelSet.assignAtom(n, string, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.modelSet.setAtomNamesAndNumbers(n, -1, null);
    }

    public void assignConnect(int n, int n2) {
        this.clearModelDependentObjects();
        float[][] fArrayArray = new float[][]{{n, n2}};
        this.modelSet.connect(fArrayArray);
        this.modelSet.assignAtom(n, ".", true);
        this.modelSet.assignAtom(n2, ".", true);
        this.refresh(3, "assignConnect");
    }

    void moveAtomWithHydrogens(int n, int n2, int n3, BitSet bitSet) {
        this.stopMinimization();
        Atom atom = this.modelSet.atoms[n];
        if (bitSet == null) {
            bitSet = BitSetUtil.setBit(n);
            Bond[] bondArray = atom.getBonds();
            if (bondArray != null) {
                for (int i = 0; i < bondArray.length; ++i) {
                    Atom atom2 = bondArray[i].getOtherAtom(atom);
                    if (atom2.getElementNumber() != 1) continue;
                    bitSet.set(atom2.index);
                }
            }
        }
        this.moveSelected(n2, n3, Integer.MIN_VALUE, Integer.MIN_VALUE, bitSet, true);
    }

    void appendLoadStates(StringBuffer stringBuffer) {
        this.modelSet.appendLoadStates(stringBuffer);
    }

    public static void getInlineData(StringBuffer stringBuffer, String string, boolean bl) {
        DataManager.getInlineData(stringBuffer, string, bl, null);
    }

    boolean isAtomPDB(int n) {
        return this.modelSet.isAtomPDB(n);
    }

    boolean isAtomAssignable(int n) {
        return this.modelSet.isAtomAssignable(n);
    }

    public void deleteMeasurement(int n) {
        this.setShapeProperty(6, "delete", new Integer(n));
    }

    boolean haveModelKit() {
        return this.modelSet.haveModelKit();
    }

    BitSet getModelKitStateBitSet(BitSet bitSet, BitSet bitSet2) {
        return this.modelSet.getModelKitStateBitset(bitSet, bitSet2);
    }

    public String getSmiles(int n, int n2, BitSet bitSet, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        JmolNode[] jmolNodeArray = this.getModelSet().atoms;
        if (bitSet == null) {
            if (n < 0 || n2 < 0) {
                bitSet = this.getSelectionSet(true);
            } else {
                if (bl) {
                    if (n > n2) {
                        int n3 = n;
                        n = n2;
                        n2 = n3;
                    }
                    n = jmolNodeArray[n].getGroup().firstAtomIndex;
                    n2 = ((Atom)jmolNodeArray[n2]).getGroup().lastAtomIndex;
                }
                bitSet = new BitSet();
                bitSet.set(n, n2 + 1);
            }
        }
        String string = bl4 ? Viewer.getJmolVersion() + " " + this.getModelName(this.getCurrentModelIndex()) : null;
        return this.getSmilesMatcher().getSmiles(jmolNodeArray, this.getAtomCount(), bitSet, bl, bl2, bl3, string);
    }

    public void connect(float[][] fArray) {
        this.modelSet.connect(fArray);
    }

    public String prompt(String string, String string2, String[] stringArray, boolean bl) {
        if (!bl) {
            return JOptionPane.showInputDialog(string, (Object)string2);
        }
        if (string2 != null) {
            stringArray = TextFormat.split(string2, "|");
        }
        int n = JOptionPane.showOptionDialog(null, string, "Jmol prompt", -1, 1, null, stringArray, stringArray[0]);
        return string2 != null ? stringArray[n] : "" + n;
    }

    String getMenuName(int n) {
        String string = "" + this.getModelNumberDotted(n);
        String string2 = this.getModelName(n);
        if (!string2.equals(string)) {
            string2 = string + ": " + string2;
        }
        if (string2.length() > 50) {
            string2 = string2.substring(0, 45) + "...";
        }
        return string2;
    }

    public void setStateScriptVersion(String string) {
        if (string != null) {
            try {
                String[] stringArray = Parser.getTokens(string.replace('.', ' ').replace('_', ' '));
                int n = Integer.valueOf(stringArray[0]);
                int n2 = Integer.valueOf(stringArray[1]);
                int n3 = Integer.valueOf(stringArray[2]);
                this.stateScriptVersionInt = n * 10000 + n2 * 100 + n3;
                this.global.legacyAutoBonding = this.stateScriptVersionInt < 110924;
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.global.legacyAutoBonding = false;
        this.stateScriptVersionInt = Integer.MAX_VALUE;
    }

    public boolean checkAutoBondLegacy() {
        return this.global.legacyAutoBonding;
    }
}

