/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import org.jmol.atomdata.RadiusData;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Group;
import org.jmol.modelset.ModelSet;
import org.jmol.util.Logger;
import org.jmol.util.Point3fi;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

public abstract class Shape {
    public static final float RADIUS_MAX = 4.0f;
    public Viewer viewer;
    public ModelSet modelSet;
    public Graphics3D g3d;
    public int shapeID;
    public int myVisibilityFlag;
    protected float translucentLevel;
    protected boolean translucentAllowed = true;
    public boolean isBioShape;
    protected Vector xmlProperties;

    public Viewer getViewer() {
        return this.viewer;
    }

    public final void initializeShape(Viewer viewer, Graphics3D graphics3D, ModelSet modelSet, int n) {
        this.viewer = viewer;
        this.g3d = graphics3D;
        this.shapeID = n;
        this.myVisibilityFlag = JmolConstants.getShapeVisibilityFlag(n);
        this.setModelSet(modelSet);
        this.initShape();
    }

    public void setModelSet(ModelSet modelSet) {
        this.modelSet = modelSet;
        this.initModelSet();
    }

    protected void initModelSet() {
    }

    public void initShape() {
    }

    public void merge(Shape shape) {
    }

    public void setShapeSize(int n, RadiusData radiusData, BitSet bitSet) {
        if (Logger.debuggingHigh) {
            this.setXmlProperty("size", radiusData == null ? new Integer(n) : radiusData, bitSet);
        }
        if (radiusData == null) {
            this.setSize(n, bitSet);
        } else {
            this.setSize(radiusData, bitSet);
        }
    }

    protected void setSize(int n, BitSet bitSet) {
    }

    protected void setSize(RadiusData radiusData, BitSet bitSet) {
    }

    public void setShapeProperty(String string, Object object, BitSet bitSet) {
        if (!this.setXmlProperty(string, object, bitSet)) {
            this.setProperty(string, object, bitSet == null ? this.viewer.getSelectionSet(false) : bitSet);
        }
    }

    private boolean setXmlProperty(String string, Object object, BitSet bitSet) {
        String string2 = JmolConstants.shapeClassBases[this.shapeID];
        if (Logger.debuggingHigh && this.shapeID != 32) {
            Logger.info(string2 + " setProperty: " + string + " = " + object);
        }
        return false;
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if (string == "setProperties") {
            Vector vector = (Vector)object;
            while (vector.size() > 0) {
                Object[] objectArray = (Object[])vector.remove(0);
                this.setShapeProperty(((String)objectArray[0]).intern(), objectArray[1], null);
            }
            return;
        }
        if (string == "translucentLevel") {
            this.translucentLevel = ((Float)object).floatValue();
            return;
        }
        if (string == "refreshTrajectories") {
            return;
        }
        Logger.warn("unassigned " + JmolConstants.shapeClassBases[this.shapeID] + " + shape setProperty:" + string + ":" + object);
    }

    public boolean getProperty(String string, Object[] objectArray) {
        return false;
    }

    public Object getProperty(String string, int n) {
        return null;
    }

    public int getIndexFromName(String string) {
        return -1;
    }

    public boolean wasClicked(int n, int n2) {
        return false;
    }

    public void findNearestAtomIndex(int n, int n2, Atom[] atomArray, BitSet bitSet) {
    }

    public void checkBoundsMinMax(Point3f point3f, Point3f point3f2) {
    }

    public void setModelClickability() {
    }

    public Point3fi checkObjectClicked(int n, int n2, int n3, BitSet bitSet) {
        return null;
    }

    public boolean checkObjectHovered(int n, int n2, BitSet bitSet) {
        return false;
    }

    public boolean checkObjectDragged(int n, int n2, int n3, int n4, int n5, BitSet bitSet) {
        return false;
    }

    protected int coordinateInRange(int n, int n2, Point3f point3f, int n3, Point3i point3i) {
        this.viewer.transformPoint(point3f, point3i);
        int n4 = (n - point3i.x) * (n - point3i.x) + (n2 - point3i.y) * (n2 - point3i.y);
        return n4 < n3 ? n4 : -1;
    }

    public short setColix(short s, byte by, int n) {
        return this.setColix(s, by, this.modelSet.atoms[n]);
    }

    protected short setColix(short s, byte by, Atom atom) {
        return s == 2 ? this.viewer.getColixAtomPalette(atom, by) : s;
    }

    protected short setColix(short s, byte by, Bond bond) {
        return s == 2 ? this.viewer.getColixBondPalette(bond, by) : s;
    }

    public Vector getShapeDetail() {
        return null;
    }

    public String getShapeState() {
        return null;
    }

    public void setVisibilityFlags(BitSet bitSet) {
    }

    public static void setStateInfo(Hashtable hashtable, int n, String string) {
        Shape.setStateInfo(hashtable, n, n, string);
    }

    public static void setStateInfo(Hashtable hashtable, int n, int n2, String string) {
        StateManager.setStateInfo(hashtable, n, n2, string);
    }

    public static String getShapeCommands(Hashtable hashtable, Hashtable hashtable2) {
        return StateManager.getCommands(hashtable, hashtable2);
    }

    public static String getShapeCommands(Hashtable hashtable, Hashtable hashtable2, String string) {
        return StateManager.getCommands(hashtable, hashtable2, string);
    }

    public static void appendCmd(StringBuffer stringBuffer, String string) {
        StateManager.appendCmd(stringBuffer, string);
    }

    public static String getFontCommand(String string, Font3D font3D) {
        if (font3D == null) {
            return "";
        }
        return "font " + string + " " + font3D.fontSizeNominal + " " + font3D.fontFace + " " + font3D.fontStyle;
    }

    public String getColorCommand(String string, short s) {
        return this.getColorCommand(string, (byte)-1, s);
    }

    public String getColorCommand(String string, byte by, short s) {
        if (by == -1 && s == 0) {
            return "";
        }
        return "color " + string + " " + Shape.encodeTransColor(by, s, this.translucentAllowed);
    }

    private static String encodeTransColor(byte by, short s, boolean bl) {
        if (by == -1 && s == 0) {
            return "";
        }
        return (bl ? Shape.getTranslucentLabel(s) + " " : "") + (by != -1 && !JmolConstants.isPaletteVariable(by) ? JmolConstants.getPaletteName(by) : Shape.encodeColor(s));
    }

    static String encodeColor(short s) {
        return Graphics3D.isColixColorInherited(s) ? "none" : Graphics3D.getHexCode(s);
    }

    private static String getTranslucentLabel(short s) {
        return Graphics3D.isColixTranslucent(s) ? "translucent " + Graphics3D.getColixTranslucencyLevel(s) : "opaque";
    }

    public static short getColix(short[] sArray, int n, Atom atom) {
        return Graphics3D.getColixInherited(sArray == null || n >= sArray.length ? (short)0 : sArray[n], atom.getColix());
    }

    public int getSize(int n) {
        return 0;
    }

    public int getSize(Group group) {
        return 0;
    }
}

