/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.modelset.Bond;
import org.jmol.script.Token;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.Parser;
import org.jmol.util.Quaternion;
import org.jmol.util.TextFormat;

public class ScriptVariable
extends Token {
    private static final ScriptVariable vT = new ScriptVariable(0x10000D, 1, "true");
    private static final ScriptVariable vF = new ScriptVariable(0x10000C, 0, "false");
    static final ScriptVariable vAll = new ScriptVariable(0x100003, "all");
    public int index = Integer.MAX_VALUE;
    private static final int FLAG_CANINCREMENT = 1;
    private static final int FLAG_LOCALVAR = 2;
    private int flags = 2;
    private String name;
    ScriptVariable[] objects;
    private static final Point3f pt0 = new Point3f();

    public ScriptVariable() {
        this.tok = 4;
        this.value = "";
    }

    public ScriptVariable(int n) {
        this.tok = n;
    }

    public ScriptVariable(int n, int n2, Object object) {
        super(n, n2, object);
    }

    public ScriptVariable(int n, Object object) {
        super(n, object);
    }

    public ScriptVariable(int n, int n2) {
        super(n, n2);
    }

    public ScriptVariable(BitSet bitSet, int n) {
        this.value = bitSet;
        this.index = n;
        this.tok = 10;
    }

    public ScriptVariable(Token token) {
        this.tok = token.tok;
        this.intValue = token.intValue;
        this.value = token.value;
        if (this.tok == 7) {
            this.objects = ((ScriptVariable)token).objects;
        }
    }

    public static String typeOf(ScriptVariable scriptVariable) {
        int n = scriptVariable == null ? 0 : scriptVariable.tok;
        switch (n) {
            case 0x10000C: 
            case 0x10000D: {
                return "boolean";
            }
            case 10: {
                return scriptVariable.value instanceof Bond.BondSet ? "bondset" : "bitset";
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                return astrType[n];
            }
        }
        return "?";
    }

    public static int sizeOf(Token token) {
        switch (token == null ? 0 : token.tok) {
            case 10: {
                return BitSetUtil.cardinalityOf(ScriptVariable.bsSelect(token));
            }
            case 0x10000C: 
            case 0x10000D: {
                return -1;
            }
            case 2: {
                return -2;
            }
            case 3: {
                return -4;
            }
            case 8: {
                return -8;
            }
            case 9: {
                return -16;
            }
            case 11: {
                return -32;
            }
            case 12: {
                return -64;
            }
            case 4: {
                return ((String)token.value).length();
            }
            case 7: {
                return token.intValue == Integer.MAX_VALUE ? ((String[])token.value).length : ScriptVariable.sizeOf(ScriptVariable.selectItem(token));
            }
            case 6: {
                return ((Hashtable)token.value).size();
            }
        }
        return 0;
    }

    public static ScriptVariable intVariable(int n) {
        return new ScriptVariable(2, n);
    }

    public static boolean isVariableType(Object object) {
        return object instanceof ScriptVariable || object instanceof BitSet || object instanceof Boolean || object instanceof Float || object instanceof Integer || object instanceof Point3f || object instanceof Vector3f || object instanceof Point4f || object instanceof Quaternion || object instanceof String || object instanceof Hashtable || object instanceof Vector || object instanceof double[] || object instanceof float[] || object instanceof Float[] || object instanceof int[] || object instanceof int[][] || object instanceof String[];
    }

    public static ScriptVariable getVariable(Object hashtable) {
        int n;
        Object object;
        if (hashtable == null) {
            return new ScriptVariable();
        }
        if (hashtable instanceof ScriptVariable) {
            return (ScriptVariable)((Object)hashtable);
        }
        if (hashtable instanceof Boolean) {
            return ScriptVariable.getBoolean((Boolean)((Object)hashtable));
        }
        if (hashtable instanceof Integer) {
            return new ScriptVariable(2, (int)((Integer)((Object)hashtable)));
        }
        if (hashtable instanceof Float) {
            return new ScriptVariable(3, hashtable);
        }
        if (hashtable instanceof String) {
            if ((hashtable = ScriptVariable.unescapePointOrBitsetAsVariable((String)((Object)hashtable))) instanceof ScriptVariable) {
                return (ScriptVariable)((Object)hashtable);
            }
            return new ScriptVariable(4, hashtable);
        }
        if (hashtable instanceof Point3f) {
            return new ScriptVariable(8, hashtable);
        }
        if (hashtable instanceof Vector3f) {
            return new ScriptVariable(8, new Point3f((Vector3f)((Object)hashtable)));
        }
        if (hashtable instanceof BitSet) {
            return new ScriptVariable(10, hashtable);
        }
        if (hashtable instanceof Point4f) {
            return new ScriptVariable(9, hashtable);
        }
        if (hashtable instanceof Quaternion) {
            return new ScriptVariable(9, ((Quaternion)((Object)hashtable)).toPoint4f());
        }
        if (hashtable instanceof Matrix3f) {
            return new ScriptVariable(11, hashtable);
        }
        if (hashtable instanceof Matrix4f) {
            return new ScriptVariable(12, hashtable);
        }
        if (hashtable instanceof Float[]) {
            return new ScriptVariable(13, hashtable);
        }
        if (hashtable instanceof Hashtable) {
            Hashtable hashtable2 = hashtable;
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                if (hashtable2.get(enumeration.nextElement()) instanceof ScriptVariable) continue;
                Hashtable<String, ScriptVariable> hashtable3 = new Hashtable<String, ScriptVariable>();
                enumeration = hashtable2.keys();
                while (enumeration.hasMoreElements()) {
                    String string;
                    Object v = hashtable2.get(string = (String)enumeration.nextElement());
                    hashtable3.put(string, ScriptVariable.getVariable(ScriptVariable.isVariableType(v) ? v : Escape.toReadable(string, v)));
                }
                hashtable = hashtable3;
                break;
            }
            return new ScriptVariable(6, hashtable);
        }
        ScriptVariable scriptVariable = null;
        ScriptVariable[] scriptVariableArray = null;
        if (hashtable instanceof ScriptVariable[]) {
            scriptVariableArray = (ScriptVariable[])hashtable;
            object = new String[scriptVariableArray.length];
            for (n = 0; n < scriptVariableArray.length; ++n) {
                object[n] = ScriptVariable.sValue(scriptVariableArray[n]);
            }
            scriptVariable = new ScriptVariable(7, object);
        } else if (hashtable instanceof String[]) {
            object = (String[])hashtable;
            scriptVariableArray = new ScriptVariable[((String[])object).length];
            n = ((String[])object).length;
            while (--n >= 0) {
                scriptVariableArray[n] = ScriptVariable.getVariable(object[n]);
            }
            scriptVariable = new ScriptVariable(7, object);
        }
        if (hashtable instanceof int[]) {
            object = (int[])hashtable;
            String[] stringArray = new String[((String[])object).length];
            scriptVariableArray = new ScriptVariable[((String[])object).length];
            int n2 = ((String[])object).length;
            while (--n2 >= 0) {
                scriptVariableArray[n2] = ScriptVariable.getVariable((int)object[n2]);
                stringArray[n2] = "" + (int)object[n2];
            }
            scriptVariable = new ScriptVariable(7, stringArray);
        } else if (hashtable instanceof int[][]) {
            object = (int[][])hashtable;
            String[] stringArray = new String[((String[])object).length];
            scriptVariableArray = new ScriptVariable[((String[])object).length];
            int n3 = ((String[])object).length;
            while (--n3 >= 0) {
                scriptVariableArray[n3] = ScriptVariable.getVariable(object[n3]);
                stringArray[n3] = "" + Escape.escape(object[n3]);
            }
            scriptVariable = new ScriptVariable(7, stringArray);
        } else if (hashtable instanceof float[]) {
            object = (float[])hashtable;
            String[] stringArray = new String[((String[])object).length];
            scriptVariableArray = new ScriptVariable[((String[])object).length];
            int n4 = ((Object)object).length;
            while (--n4 >= 0) {
                scriptVariableArray[n4] = ScriptVariable.getVariable(Float.valueOf((float)object[n4]));
                stringArray[n4] = "" + (float)object[n4];
            }
            scriptVariable = new ScriptVariable(7, stringArray);
        } else if (hashtable instanceof double[]) {
            object = (double[])hashtable;
            String[] stringArray = new String[((String[])object).length];
            scriptVariableArray = new ScriptVariable[((Object)object).length];
            int n5 = ((Object)object).length;
            while (--n5 >= 0) {
                scriptVariableArray[n5] = ScriptVariable.getVariable(Float.valueOf((float)object[n5]));
                stringArray[n5] = "" + (double)object[n5];
            }
            scriptVariable = new ScriptVariable(7, stringArray);
        } else if (hashtable instanceof Vector) {
            object = (Vector)((Object)hashtable);
            n = ((Vector)object).size();
            String[] stringArray = new String[n];
            scriptVariableArray = new ScriptVariable[n];
            for (int i = 0; i < n; ++i) {
                Object e = ((Vector)object).elementAt(i);
                stringArray[i] = e instanceof String ? (String)e : Escape.toReadable(e);
                scriptVariableArray[i] = ScriptVariable.getVariable(e);
            }
            scriptVariable = new ScriptVariable(7, stringArray);
        }
        if (scriptVariable != null) {
            scriptVariable.objects = scriptVariableArray;
            return scriptVariable;
        }
        Logger.error("ScriptVariable: unrecognized type for " + ((Object)hashtable).toString());
        return null;
    }

    public ScriptVariable set(ScriptVariable scriptVariable) {
        this.index = scriptVariable.index;
        this.intValue = scriptVariable.intValue;
        this.tok = scriptVariable.tok;
        switch (this.tok) {
            case 6: {
                this.value = new Hashtable((Hashtable)scriptVariable.value);
                break;
            }
            case 7: {
                int n = ((String[])scriptVariable.value).length;
                this.value = new String[n];
                System.arraycopy(scriptVariable.value, 0, this.value, 0, n);
                if (scriptVariable.objects == null) break;
                this.objects = new ScriptVariable[n];
                System.arraycopy(scriptVariable.objects, 0, this.objects, 0, n);
                break;
            }
            default: {
                this.value = scriptVariable.value;
            }
        }
        return this;
    }

    public ScriptVariable setName(String string) {
        this.name = string;
        this.flags |= 1;
        return this;
    }

    public ScriptVariable setGlobal() {
        this.flags &= 0xFFFFFFFD;
        return this;
    }

    public boolean canIncrement() {
        return ScriptVariable.tokAttr(this.flags, 1);
    }

    public boolean increment(int n) {
        if (!this.canIncrement()) {
            return false;
        }
        switch (this.tok) {
            case 2: {
                this.intValue += n;
                break;
            }
            case 3: {
                this.value = new Float(((Float)this.value).floatValue() + (float)n);
                break;
            }
            default: {
                this.value = ScriptVariable.nValue(this);
                if (this.value instanceof Integer) {
                    this.tok = 2;
                    this.intValue = (Integer)this.value;
                    break;
                }
                this.tok = 3;
            }
        }
        return true;
    }

    public boolean asBoolean() {
        return ScriptVariable.bValue(this);
    }

    public int asInt() {
        return ScriptVariable.iValue(this);
    }

    public float asFloat() {
        return ScriptVariable.fValue(this);
    }

    public String asString() {
        return ScriptVariable.sValue(this);
    }

    public Object getValAsObj() {
        return this.tok == 2 ? new Integer(this.intValue) : this.value;
    }

    public static Object oValue(ScriptVariable scriptVariable) {
        switch (scriptVariable == null ? 0 : scriptVariable.tok) {
            case 0x10000D: {
                return Boolean.TRUE;
            }
            case 0: 
            case 0x10000C: {
                return Boolean.FALSE;
            }
            case 2: {
                return new Integer(scriptVariable.intValue);
            }
        }
        return scriptVariable.value;
    }

    public static Object nValue(Token token) {
        int n;
        switch (token == null ? 0 : token.tok) {
            case 3: {
                return token.value;
            }
            case 2: {
                n = token.intValue;
                break;
            }
            case 4: {
                if (((String)token.value).indexOf(".") >= 0) {
                    return new Float(ScriptVariable.toFloat((String)token.value));
                }
                n = (int)ScriptVariable.toFloat((String)token.value);
                break;
            }
            default: {
                n = 0;
            }
        }
        return new Integer(n);
    }

    public static boolean bValue(Token token) {
        switch (token == null ? 0 : token.tok) {
            case 0x10000D: {
                return true;
            }
            case 0x10000C: {
                return false;
            }
            case 2: {
                return token.intValue != 0;
            }
            case 3: 
            case 4: 
            case 7: {
                return ScriptVariable.fValue(token) != 0.0f;
            }
            case 10: {
                return ScriptVariable.iValue(token) != 0;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                return Math.abs(ScriptVariable.fValue(token)) > 1.0E-4f;
            }
        }
        return false;
    }

    public static int iValue(Token token) {
        switch (token == null ? 0 : token.tok) {
            case 0x10000D: {
                return 1;
            }
            case 0x10000C: {
                return 0;
            }
            case 2: {
                return token.intValue;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                return (int)ScriptVariable.fValue(token);
            }
            case 10: {
                return BitSetUtil.cardinalityOf(ScriptVariable.bsSelect(token));
            }
        }
        return 0;
    }

    public static float fValue(Token token) {
        switch (token == null ? 0 : token.tok) {
            case 0x10000D: {
                return 1.0f;
            }
            case 0x10000C: {
                return 0.0f;
            }
            case 2: {
                return token.intValue;
            }
            case 3: {
                return ((Float)token.value).floatValue();
            }
            case 7: {
                int n = token.intValue;
                String[] stringArray = (String[])token.value;
                if (n == Integer.MAX_VALUE) {
                    return stringArray.length;
                }
            }
            case 4: {
                return ScriptVariable.toFloat(ScriptVariable.sValue(token));
            }
            case 10: {
                return ScriptVariable.iValue(token);
            }
            case 8: {
                return ((Point3f)token.value).distance(pt0);
            }
            case 9: {
                return Measure.distanceToPlane((Point4f)token.value, pt0);
            }
            case 11: {
                Point3f point3f = new Point3f();
                ((Matrix3f)token.value).transform(point3f);
                return point3f.distance(pt0);
            }
            case 12: {
                Point3f point3f = new Point3f();
                ((Matrix4f)token.value).transform(point3f);
                return point3f.distance(pt0);
            }
        }
        return 0.0f;
    }

    public static String sValue(Token token) {
        if (token == null) {
            return "";
        }
        switch (token.tok) {
            case 0x10000D: {
                return "true";
            }
            case 0x10000C: {
                return "false";
            }
            case 2: {
                return "" + token.intValue;
            }
            case 8: {
                return Escape.escape((Point3f)token.value);
            }
            case 9: {
                return Escape.escape((Point4f)token.value);
            }
            case 11: {
                return Escape.escape((Matrix3f)token.value);
            }
            case 12: {
                return Escape.escape((Matrix4f)token.value);
            }
            case 10: {
                return Escape.escape(ScriptVariable.bsSelect(token), !(token.value instanceof Bond.BondSet));
            }
            case 7: {
                String[] stringArray = (String[])token.value;
                int n = token.intValue;
                if (n <= 0) {
                    n = stringArray.length - n;
                }
                if (n != Integer.MAX_VALUE) {
                    return n < 1 || n > stringArray.length ? "" : stringArray[n - 1];
                }
                StringBuffer stringBuffer = new StringBuffer();
                for (n = 0; n < stringArray.length; ++n) {
                    stringBuffer.append(stringArray[n]).append("\n");
                }
                return stringBuffer.toString();
            }
            case 6: {
                StringBuffer stringBuffer = new StringBuffer();
                Hashtable hashtable = (Hashtable)token.value;
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    stringBuffer.append(string).append("\t:\t").append(ScriptVariable.sValue(ScriptVariable.getVariable(hashtable.get(string)))).append("\n");
                }
                return stringBuffer.toString();
            }
            case 4: {
                String string = (String)token.value;
                int n = token.intValue;
                if (n <= 0) {
                    n = string.length() - n;
                }
                if (n == Integer.MAX_VALUE) {
                    return string;
                }
                if (n < 1 || n > string.length()) {
                    return "";
                }
                return "" + string.charAt(n - 1);
            }
        }
        return "" + token.value;
    }

    private static float toFloat(String string) {
        if (string.equalsIgnoreCase("true")) {
            return 1.0f;
        }
        if (string.equalsIgnoreCase("false") || string.length() == 0) {
            return 0.0f;
        }
        return Parser.parseFloatStrict(string);
    }

    public static String[] concatList(ScriptVariable scriptVariable, ScriptVariable scriptVariable2) {
        int n;
        String[] stringArray = scriptVariable.tok == 7 ? (String[])scriptVariable.value : TextFormat.split(ScriptVariable.sValue(scriptVariable), "\n");
        String[] stringArray2 = scriptVariable2.tok == 7 ? (String[])scriptVariable2.value : TextFormat.split(ScriptVariable.sValue(scriptVariable2), "\n");
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        int n2 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            stringArray3[n2++] = stringArray[n];
        }
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray3[n2++] = stringArray2[n];
        }
        return stringArray3;
    }

    public static BitSet bsSelect(Token token) {
        token = ScriptVariable.selectItem(token, Integer.MIN_VALUE);
        return (BitSet)token.value;
    }

    public static BitSet bsSelect(ScriptVariable scriptVariable) {
        if (scriptVariable.index == Integer.MAX_VALUE) {
            scriptVariable = ScriptVariable.selectItem(scriptVariable);
        }
        return (BitSet)scriptVariable.value;
    }

    public static BitSet bsSelect(Token token, int n) {
        token = ScriptVariable.selectItem(token);
        token = ScriptVariable.selectItem(token, 1);
        token = ScriptVariable.selectItem(token, n);
        return (BitSet)token.value;
    }

    public static ScriptVariable selectItem(ScriptVariable scriptVariable) {
        if (scriptVariable.index != Integer.MAX_VALUE || scriptVariable.tok == 7 && scriptVariable.intValue == Integer.MAX_VALUE) {
            return scriptVariable;
        }
        return ScriptVariable.selectItem(scriptVariable, Integer.MIN_VALUE);
    }

    public static Token selectItem(Token token) {
        return ScriptVariable.selectItem(token, Integer.MIN_VALUE);
    }

    public static ScriptVariable selectItem(ScriptVariable scriptVariable, int n) {
        return (ScriptVariable)ScriptVariable.selectItem((Token)scriptVariable, n);
    }

    public static Token selectItem(Token token, int n) {
        switch (token.tok) {
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            default: {
                return token;
            }
        }
        BitSet bitSet = null;
        String[] stringArray = null;
        String string = null;
        int n2 = token.intValue;
        if (n2 == Integer.MAX_VALUE) {
            if (n == Integer.MIN_VALUE) {
                n = n2;
            }
            ScriptVariable scriptVariable = new ScriptVariable(token.tok, n, token.value);
            if (token.tok == 7) {
                scriptVariable.objects = ((ScriptVariable)token).objects;
            }
            return scriptVariable;
        }
        int n3 = 0;
        boolean bl = token instanceof ScriptVariable && ((ScriptVariable)token).index != Integer.MAX_VALUE;
        ScriptVariable scriptVariable = new ScriptVariable(token.tok, Integer.MAX_VALUE);
        switch (token.tok) {
            case 10: {
                if (token.value instanceof Bond.BondSet) {
                    scriptVariable.value = new Bond.BondSet((BitSet)token.value, ((Bond.BondSet)token.value).getAssociatedAtoms());
                    bitSet = (BitSet)scriptVariable.value;
                    n3 = BitSetUtil.cardinalityOf(bitSet);
                    break;
                }
                bitSet = BitSetUtil.copy((BitSet)token.value);
                n3 = bl ? 1 : BitSetUtil.cardinalityOf(bitSet);
                scriptVariable.value = bitSet;
                break;
            }
            case 7: {
                stringArray = (String[])token.value;
                n3 = stringArray.length;
                break;
            }
            case 4: {
                string = (String)token.value;
                n3 = string.length();
                break;
            }
            case 11: {
                n3 = -3;
                break;
            }
            case 12: {
                n3 = -4;
            }
        }
        if (n3 < 0) {
            n3 = -n3;
            if (n2 > 0 && Math.abs(n2) > n3) {
                int n4 = n2 % 10;
                int n5 = (n2 - n4) / 10;
                if (n4 > 0 && n4 <= n3 && n5 <= n3) {
                    if (token.tok == 11) {
                        return new ScriptVariable(3, new Float(((Matrix3f)token.value).getElement(n5 - 1, n4 - 1)));
                    }
                    return new ScriptVariable(3, new Float(((Matrix4f)token.value).getElement(n5 - 1, n4 - 1)));
                }
                return new ScriptVariable(4, "");
            }
            if (Math.abs(n2) > n3) {
                return new ScriptVariable(4, "");
            }
            float[] fArray = new float[n3];
            if (n3 == 3) {
                if (n2 < 0) {
                    ((Matrix3f)token.value).getColumn(-1 - n2, fArray);
                } else {
                    ((Matrix3f)token.value).getRow(n2 - 1, fArray);
                }
            } else if (n2 < 0) {
                ((Matrix4f)token.value).getColumn(-1 - n2, fArray);
            } else {
                ((Matrix4f)token.value).getRow(n2 - 1, fArray);
            }
            if (n == Integer.MIN_VALUE) {
                return ScriptVariable.getVariable(fArray);
            }
            if (n < 1 || n > n3) {
                return new ScriptVariable(4, "");
            }
            return ScriptVariable.getVariable(new Float(fArray[n - 1]));
        }
        if (n2 <= 0) {
            n2 = n3 + n2;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        if (n == 0) {
            n = n3;
        } else if (n < 0) {
            n = n3 + n;
        }
        if (n > n3) {
            n = n3;
        } else if (n < n2) {
            n = n2;
        }
        switch (token.tok) {
            case 10: {
                if (bl) {
                    if (n2 <= 1) break;
                    bitSet.clear();
                    break;
                }
                int n6 = 0;
                int n7 = bitSet.nextSetBit(0);
                while (n7 >= 0) {
                    if (++n6 < n2 || n6 > n) {
                        bitSet.clear(n7);
                    }
                    n7 = bitSet.nextSetBit(n7 + 1);
                }
                break;
            }
            case 4: {
                if (n2 < 1 || n2 > n3) {
                    scriptVariable.value = "";
                    break;
                }
                scriptVariable.value = string.substring(n2 - 1, n);
                break;
            }
            case 7: {
                if (n2 < 1 || n2 > n3 || n > n3) {
                    return new ScriptVariable(4, "");
                }
                if (n == n2) {
                    return ((ScriptVariable)token).objects[n2 - 1];
                }
                String[] stringArray2 = new String[n - n2 + 1];
                ScriptVariable[] scriptVariableArray = new ScriptVariable[n - n2 + 1];
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray2[i] = stringArray[i + n2 - 1];
                    scriptVariableArray[i] = new ScriptVariable(((ScriptVariable)token).objects[i + n2 - 1]);
                }
                scriptVariable.value = stringArray2;
            }
        }
        return scriptVariable;
    }

    public static ScriptVariable fromString(String string) {
        Object object = ScriptVariable.unescapePointOrBitsetAsVariable(string);
        if (!(object instanceof String)) {
            return (ScriptVariable)object;
        }
        String string2 = (String)object;
        if (string2.toLowerCase() == "true") {
            return ScriptVariable.getBoolean(true);
        }
        if (string2.toLowerCase() == "false") {
            return ScriptVariable.getBoolean(false);
        }
        float f = Parser.parseFloatStrict(string2);
        return Float.isNaN(f) ? new ScriptVariable(4, object) : (string2.indexOf(".") < 0 ? new ScriptVariable(2, (int)f) : new ScriptVariable(3, new Float(f)));
    }

    public boolean setSelectedValue(int n, ScriptVariable scriptVariable) {
        if (n == Integer.MAX_VALUE) {
            return false;
        }
        switch (this.tok) {
            case 11: 
            case 12: {
                String[] stringArray;
                int n2;
                int n3 = n2 = this.tok == 11 ? 3 : 4;
                if (n > 10) {
                    int n4 = n % 10;
                    int n5 = (n - n4) / 10;
                    if (n4 > 0 && n4 <= n2 && n5 <= n2) {
                        if (this.tok == 11) {
                            ((Matrix3f)this.value).setElement(n5 - 1, n4 - 1, ScriptVariable.fValue(scriptVariable));
                        } else {
                            ((Matrix4f)this.value).setElement(n5 - 1, n4 - 1, ScriptVariable.fValue(scriptVariable));
                        }
                        return true;
                    }
                }
                if (n != 0 && Math.abs(n) <= n2 && scriptVariable.value instanceof String[] && (stringArray = (String[])scriptVariable.value).length == n2) {
                    float[] fArray = new float[n2];
                    for (int i = 0; i < n2; ++i) {
                        fArray[i] = ScriptVariable.toFloat(stringArray[i]);
                    }
                    if (n > 0) {
                        if (this.tok == 11) {
                            ((Matrix3f)this.value).setRow(n - 1, fArray);
                        } else {
                            ((Matrix4f)this.value).setRow(n - 1, fArray);
                        }
                    } else if (this.tok == 11) {
                        ((Matrix3f)this.value).setColumn(-1 - n, fArray);
                    } else {
                        ((Matrix4f)this.value).setColumn(-1 - n, fArray);
                    }
                    return true;
                }
                return false;
            }
            case 4: {
                String string = (String)this.value;
                int n6 = string.length();
                if (n <= 0) {
                    n = n6 + n;
                }
                if (--n < 0) {
                    n = 0;
                }
                while (n >= string.length()) {
                    string = string + " ";
                }
                this.value = string.substring(0, n) + ScriptVariable.sValue(scriptVariable) + string.substring(n + 1);
                return true;
            }
            case 7: {
                int n7 = this.objects.length;
                if (n <= 0) {
                    n = n7 + n;
                }
                if (--n < 0) {
                    n = 0;
                }
                String[] stringArray = (String[])this.value;
                if (n7 <= n) {
                    int n8;
                    stringArray = ArrayUtil.ensureLength(stringArray, n + 1);
                    this.value = stringArray;
                    for (n8 = n7; n8 <= n; ++n8) {
                        stringArray[n8] = "";
                    }
                    this.objects = (ScriptVariable[])ArrayUtil.ensureLength(this.objects, n + 1);
                    for (n8 = n7; n8 <= n; ++n8) {
                        this.objects[n8] = ScriptVariable.getVariable("");
                    }
                }
                stringArray[n] = ScriptVariable.sValue(scriptVariable);
                this.objects[n] = scriptVariable;
                return true;
            }
        }
        return false;
    }

    public String escape() {
        switch (this.tok) {
            case 0x10000D: {
                return "true";
            }
            case 0x10000C: {
                return "false";
            }
            case 2: {
                return "" + this.intValue;
            }
            case 10: {
                return Escape.escape((BitSet)this.value, !(this.value instanceof Bond.BondSet));
            }
            case 7: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("[");
                for (int i = 0; i < this.objects.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(this.objects[i].escape());
                }
                stringBuffer.append("]");
                return stringBuffer.toString();
            }
            case 8: {
                return Escape.escape((Point3f)this.value);
            }
            case 9: {
                return Escape.escape((Point4f)this.value);
            }
            case 11: {
                return Escape.escape((Matrix3f)this.value);
            }
            case 12: {
                return Escape.escape((Matrix4f)this.value);
            }
        }
        return Escape.escape(this.value);
    }

    public static Object unescapePointOrBitsetAsVariable(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        Object object = Escape.unescapePointOrBitsetOrMatrixOrArray(string);
        if (object instanceof Point3f) {
            return new ScriptVariable(8, object);
        }
        if (object instanceof Point4f) {
            return new ScriptVariable(9, object);
        }
        if (object instanceof BitSet) {
            if (string.indexOf("[{") == 0) {
                object = new Bond.BondSet((BitSet)object);
            }
            return new ScriptVariable(10, object);
        }
        if (object instanceof Matrix3f) {
            return new ScriptVariable(11, object);
        }
        if (object instanceof Matrix4f) {
            return new ScriptVariable(12, object);
        }
        return string;
    }

    public static ScriptVariable getBoolean(boolean bl) {
        return new ScriptVariable(bl ? vT : vF);
    }

    public static Object sprintf(String string, ScriptVariable scriptVariable) {
        if (scriptVariable == null) {
            return string;
        }
        int[] nArray = (int[])(string.indexOf("d") >= 0 || string.indexOf("i") >= 0 ? new int[1] : null);
        float[] fArray = string.indexOf("f") >= 0 ? new float[1] : null;
        double[] dArray = string.indexOf("e") >= 0 ? new double[1] : null;
        boolean bl = string.indexOf("s") >= 0;
        boolean bl2 = string.indexOf("p") >= 0 && scriptVariable.tok == 8 || string.indexOf("q") >= 0 && scriptVariable.tok == 9;
        Object[] objectArray = new Object[]{nArray, fArray, dArray, null, null};
        if (scriptVariable.tok != 7) {
            return ScriptVariable.sprintf(string, scriptVariable, objectArray, nArray, fArray, dArray, bl, bl2);
        }
        String[] stringArray = (String[])scriptVariable.value;
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = string;
            stringArray2[i] = ScriptVariable.sprintf(string2, ScriptVariable.fromString(stringArray[i]), objectArray, nArray, fArray, dArray, bl, bl2);
        }
        return stringArray2;
    }

    private static String sprintf(String string, ScriptVariable scriptVariable, Object[] objectArray, int[] nArray, float[] fArray, double[] dArray, boolean bl, boolean bl2) {
        if (nArray != null) {
            nArray[0] = ScriptVariable.iValue(scriptVariable);
        }
        if (fArray != null) {
            fArray[0] = ScriptVariable.fValue(scriptVariable);
        }
        if (dArray != null) {
            dArray[0] = ScriptVariable.fValue(scriptVariable);
        }
        if (bl) {
            objectArray[3] = ScriptVariable.sValue(scriptVariable);
        }
        if (bl2) {
            objectArray[4] = scriptVariable.value;
        }
        return TextFormat.sprintf(string, objectArray);
    }

    public static String sprintf(ScriptVariable[] scriptVariableArray) {
        switch (scriptVariableArray.length) {
            case 0: {
                return "";
            }
            case 1: {
                return ScriptVariable.sValue(scriptVariableArray[0]);
            }
        }
        String[] stringArray = TextFormat.split(TextFormat.simpleReplace(ScriptVariable.sValue(scriptVariableArray[0]), "%%", "\u0001"), '%');
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            Object object = ScriptVariable.sprintf(TextFormat.formatCheck("%" + stringArray[i]), i < scriptVariableArray.length ? scriptVariableArray[i] : null);
            if (object instanceof String[]) {
                String[] stringArray2 = (String[])object;
                for (int j = 0; j < stringArray2.length; ++j) {
                    stringBuffer.append(stringArray2[j]).append("\n");
                }
                continue;
            }
            stringBuffer.append(object);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return super.toString() + "[" + this.name + "] index =" + this.index + " hashcode=" + this.hashCode();
    }

    public static BitSet getBitSet(ScriptVariable scriptVariable, boolean bl) {
        switch (scriptVariable.tok) {
            case 10: {
                return ScriptVariable.bsSelect(scriptVariable);
            }
            case 7: {
                return Escape.unEscapeBitSetArray((String[])scriptVariable.value, bl);
            }
        }
        return bl ? null : new BitSet();
    }

    public static boolean areEqual(ScriptVariable scriptVariable, ScriptVariable scriptVariable2) {
        if (scriptVariable.tok == 4 && scriptVariable2.tok == 4) {
            return ScriptVariable.sValue(scriptVariable).equalsIgnoreCase(ScriptVariable.sValue(scriptVariable2));
        }
        if (scriptVariable.tok == 8 && scriptVariable2.tok == 8) {
            return (double)((Point3f)scriptVariable.value).distance((Point3f)scriptVariable2.value) < 1.0E-6;
        }
        if (scriptVariable.tok == 9 && scriptVariable2.tok == 9) {
            return (double)((Point4f)scriptVariable.value).distance((Point4f)scriptVariable2.value) < 1.0E-6;
        }
        return (double)Math.abs(ScriptVariable.fValue(scriptVariable) - ScriptVariable.fValue(scriptVariable2)) < 1.0E-6;
    }

    public static ScriptVariable copyVar(ScriptVariable scriptVariable) {
        String[] stringArray;
        ScriptVariable scriptVariable2 = new ScriptVariable(scriptVariable.tok, scriptVariable.intValue, scriptVariable.value);
        if (scriptVariable.objects == null) {
            return scriptVariable2;
        }
        scriptVariable2.objects = new ScriptVariable[scriptVariable.objects.length];
        scriptVariable2.value = stringArray = new String[scriptVariable2.objects.length];
        int n = scriptVariable2.objects.length;
        while (--n >= 0) {
            scriptVariable2.objects[n] = ScriptVariable.copyVar(scriptVariable.objects[n]);
            stringArray[n] = ((String[])scriptVariable.value)[n];
        }
        return scriptVariable2;
    }

    public ScriptVariable sortOrReverse(boolean bl) {
        int n;
        if (this.tok != 7 || this.objects.length < 2) {
            return this;
        }
        ScriptVariable scriptVariable = ScriptVariable.copyVar(this);
        if (bl) {
            int n2 = scriptVariable.objects.length;
            for (n = 0; n < n2; ++n) {
                ScriptVariable scriptVariable2 = scriptVariable.objects[n];
                scriptVariable.objects[n] = scriptVariable.objects[--n2];
                scriptVariable.objects[n2] = scriptVariable2;
            }
        } else {
            Arrays.sort(scriptVariable.objects, new Sort());
        }
        String[] stringArray = (String[])scriptVariable.value;
        n = scriptVariable.objects.length;
        while (--n >= 0) {
            stringArray[n] = ScriptVariable.sValue(scriptVariable.objects[n]);
        }
        return scriptVariable;
    }

    public void toArray() {
        String[] stringArray;
        int n;
        Matrix3f matrix3f = null;
        Matrix4f matrix4f = null;
        switch (this.tok) {
            case 11: {
                matrix3f = (Matrix3f)this.value;
                n = 3;
                break;
            }
            case 12: {
                matrix4f = (Matrix4f)this.value;
                n = 4;
                break;
            }
            default: {
                return;
            }
        }
        this.tok = 7;
        this.objects = new ScriptVariable[n];
        this.value = stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            float[] fArray = new float[n];
            if (matrix3f == null) {
                matrix4f.getRow(i, fArray);
            } else {
                matrix3f.getRow(i, fArray);
            }
            this.objects[i] = ScriptVariable.getVariable(fArray);
            stringArray[i] = ScriptVariable.sValue(this.objects[i]);
        }
    }

    public ScriptVariable updateValue() {
        if (this.tok == 7) {
            String[] stringArray;
            this.value = stringArray = new String[this.objects.length];
            for (int i = 0; i < this.objects.length; ++i) {
                stringArray[i] = ScriptVariable.sValue(this.objects[i].updateValue());
            }
        }
        return this;
    }

    protected class Sort
    implements Comparator {
        protected Sort() {
        }

        public int compare(Object object, Object object2) {
            ScriptVariable scriptVariable = (ScriptVariable)object;
            ScriptVariable scriptVariable2 = (ScriptVariable)object2;
            if (scriptVariable.tok != scriptVariable2.tok) {
                return 0;
            }
            switch (scriptVariable.tok) {
                case 4: {
                    return ScriptVariable.sValue(scriptVariable2).compareTo(ScriptVariable.sValue(scriptVariable));
                }
                case 7: {
                    if (scriptVariable.objects.length != scriptVariable2.objects.length || scriptVariable.objects.length < 1) {
                        return 0;
                    }
                    return this.compare(scriptVariable.objects[0], scriptVariable2.objects[0]);
                }
            }
            float f = ScriptVariable.fValue(scriptVariable);
            float f2 = ScriptVariable.fValue(scriptVariable2);
            return f < f2 ? -1 : (f > f2 ? 1 : 0);
        }
    }
}

