/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.popup;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.jmol.api.JmolViewer;
import org.jmol.popup.PopupResource;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;

public class SimplePopup {
    protected static final boolean dumpList = false;
    protected JmolViewer viewer;
    protected Component display;
    protected MenuItemListener mil;
    protected CheckboxMenuItemListener cmil;
    protected boolean asPopup = true;
    protected Properties menuText = new Properties();
    protected String nullModelSetName;
    protected String modelSetName;
    protected String modelSetFileName;
    protected String modelSetRoot;
    protected Hashtable modelSetInfo;
    protected Hashtable modelInfo;
    protected JPopupMenu frankPopup;
    protected Hashtable htMenus = new Hashtable();
    protected Vector NotPDB = new Vector();
    protected Vector PDBOnly = new Vector();
    protected Vector UnitcellOnly = new Vector();
    protected Vector SingleModelOnly = new Vector();
    protected Vector FramesOnly = new Vector();
    protected Vector VibrationOnly = new Vector();
    protected Vector SymmetryOnly = new Vector();
    protected Vector SignedOnly = new Vector();
    protected Vector AppletOnly = new Vector();
    protected Vector ChargesOnly = new Vector();
    protected Vector TemperatureOnly = new Vector();
    protected boolean isPDB;
    protected boolean isSymmetry;
    protected boolean isUnitCell;
    protected boolean isMultiFrame;
    protected boolean isLastFrame;
    protected boolean isMultiConfiguration;
    protected boolean isVibration;
    protected boolean isApplet;
    protected boolean isSigned;
    protected boolean isZapped;
    protected boolean haveCharges;
    protected boolean haveBFactors;
    protected String altlocs;
    protected int modelIndex;
    protected int modelCount;
    protected int atomCount;
    protected JPopupMenu swingPopup;
    private boolean isHorizontal = false;
    private boolean allowSignedFeatures;
    protected int thisx;
    protected int thisy;
    static final int UPDATE_ALL = 0;
    static final int UPDATE_CONFIG = 1;
    static final int UPDATE_SHOW = 2;
    int updateMode;
    private ButtonGroup group;
    protected Hashtable htCheckbox = new Hashtable();
    String currentMenuItemId = null;

    SimplePopup(JmolViewer jmolViewer) {
        this.viewer = jmolViewer;
        this.asPopup = true;
        this.display = jmolViewer.getDisplay();
        this.mil = new MenuItemListener();
        this.cmil = new CheckboxMenuItemListener();
    }

    public SimplePopup(JmolViewer jmolViewer, String string, PopupResource popupResource, boolean bl) {
        this(jmolViewer);
        this.isHorizontal = bl;
        this.swingPopup = new JPopupMenu(string);
        this.build(string, this.swingPopup, popupResource);
    }

    protected void build(String string, Object object, PopupResource popupResource) {
        if (this.isHorizontal && object instanceof JPopupMenu) {
            JPopupMenu jPopupMenu = (JPopupMenu)object;
            GridLayout gridLayout = new GridLayout(3, 4);
            jPopupMenu.setLayout(gridLayout);
        }
        this.htMenus.put(string, object);
        this.allowSignedFeatures = !this.viewer.isApplet() || this.viewer.getBooleanProperty("_signedApplet");
        this.addMenuItems("", string, object, popupResource);
    }

    public void show(int n, int n2) {
        this.show(n, n2, true);
    }

    protected void updateForShow() {
    }

    public void show(int n, int n2, boolean bl) {
        this.thisx = n;
        this.thisy = n2;
        this.updateForShow();
        Enumeration enumeration = this.htCheckbox.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = this.htCheckbox.get(string);
            String string2 = string.substring(0, string.indexOf(":"));
            boolean bl2 = this.viewer.getBooleanProperty(string2);
            this.setCheckBoxState(v, bl2);
        }
        this.showPopupMenu(this.thisx, this.thisy);
    }

    protected static void addCurrentItem(StringBuffer stringBuffer, char c, int n, String string, String string2, String string3, String string4) {
        stringBuffer.append(c).append(n).append('\t').append(string);
        if (string2 == null) {
            stringBuffer.append(".\n");
            return;
        }
        stringBuffer.append("\t").append(string2).append("\t").append(string3 == null || string3.length() == 0 ? "-" : string3).append("\t").append(string4).append("\n");
    }

    protected String getMenuText(String string) {
        String string2 = this.menuText.getProperty(string);
        return string2 == null ? string : string2;
    }

    boolean checkBoolean(Hashtable hashtable, String string) {
        Object var3_3 = hashtable == null ? null : hashtable.get(string);
        return var3_3 != null && (!(var3_3 instanceof Boolean) || (Boolean)var3_3 != false);
    }

    protected void getViewerData() {
        this.isApplet = this.viewer.isApplet();
        this.isSigned = this.viewer.getBooleanProperty("_signedApplet");
        this.modelSetName = this.viewer.getModelSetName();
        this.modelSetFileName = this.viewer.getModelSetFileName();
        int n = this.modelSetFileName.lastIndexOf(".");
        this.isZapped = "zapped".equals(this.modelSetName);
        if (this.isZapped || "string".equals(this.modelSetFileName) || "files".equals(this.modelSetFileName) || "string[]".equals(this.modelSetFileName)) {
            this.modelSetFileName = "";
        }
        this.modelSetRoot = this.modelSetFileName.substring(0, n < 0 ? this.modelSetFileName.length() : n);
        if (this.modelSetRoot.length() == 0) {
            this.modelSetRoot = "Jmol";
        }
        this.modelIndex = this.viewer.getDisplayModelIndex();
        this.modelCount = this.viewer.getModelCount();
        this.atomCount = this.viewer.getAtomCountInModel(this.modelIndex);
        this.modelSetInfo = this.viewer.getModelSetAuxiliaryInfo();
        this.modelInfo = this.viewer.getModelAuxiliaryInfo(this.modelIndex);
        if (this.modelInfo == null) {
            this.modelInfo = new Hashtable();
        }
        this.isPDB = this.checkBoolean(this.modelSetInfo, "isPDB");
        this.isSymmetry = this.checkBoolean(this.modelInfo, "hasSymmetry");
        this.isUnitCell = this.checkBoolean(this.modelInfo, "notionalUnitcell");
        this.isMultiFrame = this.modelCount > 1;
        this.isLastFrame = this.modelIndex == this.modelCount - 1;
        this.altlocs = this.viewer.getAltLocListInModel(this.modelIndex);
        this.isMultiConfiguration = this.altlocs.length() > 0;
        this.isVibration = this.viewer.modelHasVibrationVectors(this.modelIndex);
        this.haveCharges = this.viewer.havePartialCharges();
        this.haveBFactors = this.viewer.getBooleanProperty("haveBFactors");
    }

    void updateFileTypeDependentMenus() {
        int n;
        for (n = 0; n < this.NotPDB.size(); ++n) {
            this.enableMenu(this.NotPDB.get(n), !this.isPDB);
        }
        for (n = 0; n < this.PDBOnly.size(); ++n) {
            this.enableMenu(this.PDBOnly.get(n), this.isPDB);
        }
        for (n = 0; n < this.UnitcellOnly.size(); ++n) {
            this.enableMenu(this.UnitcellOnly.get(n), this.isUnitCell);
        }
        for (n = 0; n < this.SingleModelOnly.size(); ++n) {
            this.enableMenu(this.SingleModelOnly.get(n), this.isLastFrame);
        }
        for (n = 0; n < this.FramesOnly.size(); ++n) {
            this.enableMenu(this.FramesOnly.get(n), this.isMultiFrame);
        }
        for (n = 0; n < this.VibrationOnly.size(); ++n) {
            this.enableMenu(this.VibrationOnly.get(n), this.isVibration);
        }
        for (n = 0; n < this.SymmetryOnly.size(); ++n) {
            this.enableMenu(this.SymmetryOnly.get(n), this.isSymmetry && this.isUnitCell);
        }
        for (n = 0; n < this.SignedOnly.size(); ++n) {
            this.enableMenu(this.SignedOnly.get(n), this.isSigned || !this.isApplet);
        }
        for (n = 0; n < this.AppletOnly.size(); ++n) {
            this.enableMenu(this.AppletOnly.get(n), this.isApplet);
        }
        for (n = 0; n < this.ChargesOnly.size(); ++n) {
            this.enableMenu(this.ChargesOnly.get(n), this.haveCharges);
        }
        for (n = 0; n < this.TemperatureOnly.size(); ++n) {
            this.enableMenu(this.TemperatureOnly.get(n), this.haveBFactors);
        }
    }

    protected void addMenuItems(String string, String string2, Object object, PopupResource popupResource) {
        String string3;
        Object object2;
        String string4 = string + "." + string2;
        String string5 = popupResource.getStructure(string2);
        if (string5 == null) {
            this.addMenuItem(object, "#" + string2, "", "");
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string5);
        while (string5.indexOf("@") >= 0) {
            object2 = "";
            while (stringTokenizer.hasMoreTokens()) {
                object2 = (String)object2 + " " + ((string3 = stringTokenizer.nextToken()).startsWith("@") ? popupResource.getStructure(string3) : string3);
            }
            string5 = ((String)object2).substring(1);
            stringTokenizer = new StringTokenizer(string5);
        }
        while (stringTokenizer.hasMoreTokens()) {
            Object object3;
            object2 = null;
            String string6 = "";
            string3 = stringTokenizer.nextToken();
            String string7 = popupResource.getWord(string3);
            boolean bl = false;
            if (string3.indexOf("Menu") >= 0) {
                if (string3.indexOf("more") < 0) {
                    this.group = null;
                }
                object3 = this.newMenu(string7, string4 + "." + string3);
                this.addMenuSubMenu(object, object3);
                this.htMenus.put(string3, object3);
                if (string3.indexOf("Computed") < 0) {
                    this.addMenuItems(string4, string3, object3, popupResource);
                }
                this.checkSpecialMenu(string3, object3, string7);
                object2 = object3;
            } else {
                if ("-".equals(string3)) {
                    this.addMenuSeparator(object);
                    continue;
                }
                if (string3.endsWith("Checkbox") || (bl = string3.endsWith("CB") || string3.endsWith("RD"))) {
                    boolean bl2;
                    string6 = popupResource.getStructure(string3);
                    object3 = string3.substring(0, string3.length() - (!bl ? 8 : 2));
                    boolean bl3 = bl2 = bl && string3.endsWith("RD");
                    if (string6 == null || string6.length() == 0 && !bl2) {
                        string6 = "set " + (String)object3 + " T/F";
                    }
                    object2 = this.addCheckboxMenuItem(object, string7, (String)object3 + ":" + string6, string4 + "." + string3, bl2);
                    if (bl2) {
                        if (this.group == null) {
                            this.group = new ButtonGroup();
                        }
                        this.group.add((JMenuItem)object2);
                    }
                } else {
                    string6 = popupResource.getStructure(string3);
                    if (string6 == null) {
                        string6 = string3;
                    }
                    object2 = this.addMenuItem(object, string7, string6, string4 + "." + string3);
                }
            }
            if (!this.allowSignedFeatures && string3.startsWith("SIGNED")) {
                this.enableMenu(object2, false);
            }
            if (string3.indexOf("VARIABLE") >= 0) {
                this.htMenus.put(string3, object2);
            }
            if (string3.indexOf("!PDB") >= 0) {
                this.NotPDB.add(object2);
            } else if (string3.indexOf("PDB") >= 0) {
                this.PDBOnly.add(object2);
            }
            if (string3.indexOf("URL") >= 0) {
                this.AppletOnly.add(object2);
            } else if (string3.indexOf("CHARGE") >= 0) {
                this.ChargesOnly.add(object2);
            } else if (string3.indexOf("BFACTORS") >= 0) {
                this.TemperatureOnly.add(object2);
            } else if (string3.indexOf("UNITCELL") >= 0) {
                this.UnitcellOnly.add(object2);
            }
            if (string3.indexOf("!FRAMES") >= 0) {
                this.SingleModelOnly.add(object2);
            } else if (string3.indexOf("FRAMES") >= 0) {
                this.FramesOnly.add(object2);
            }
            if (string3.indexOf("VIBRATION") >= 0) {
                this.VibrationOnly.add(object2);
            } else if (string3.indexOf("SYMMETRY") >= 0) {
                this.SymmetryOnly.add(object2);
            }
            if (!string3.startsWith("SIGNED")) continue;
            this.SignedOnly.add(object2);
        }
    }

    protected void checkSpecialMenu(String string, Object object, String string2) {
    }

    void rememberCheckbox(String string, Object object) {
        this.htCheckbox.put(string + "::" + this.htCheckbox.size(), object);
    }

    protected void setCheckBoxValue(JMenuItem jMenuItem, String string, boolean bl) {
        if (string.indexOf("##") < 0) {
            int n = string.indexOf(":");
            if (n < 0) {
                Logger.error((String)("check box " + jMenuItem.getName() + " IS " + string));
                return;
            }
            String string2 = string.substring(0, n);
            if (this.viewer.getBooleanProperty(string2) == bl) {
                return;
            }
            if (string2.endsWith("P!")) {
                if (string2.indexOf("??") >= 0) {
                    string = this.setCheckBoxOption(jMenuItem, string2, string);
                } else {
                    if (string == null) {
                        return;
                    }
                    if (!bl) {
                        return;
                    }
                    string = "set picking " + string2.substring(0, string2.length() - 2);
                }
            } else {
                if ((n = (string = string.substring(n + 1)).indexOf("|")) >= 0) {
                    string = (bl ? string.substring(0, n) : string.substring(n + 1)).trim();
                }
                string = TextFormat.simpleReplace((String)string, (String)"T/F", (String)(bl ? " TRUE" : " FALSE"));
            }
        }
        this.viewer.evalStringQuiet(string);
    }

    protected String setCheckBoxOption(JMenuItem jMenuItem, String string, String string2) {
        return null;
    }

    protected String fixScript(String string, String string2) {
        if (string2 == "" || string.endsWith("Checkbox")) {
            return string2;
        }
        if (string2.indexOf("SELECT") == 0) {
            return "select thisModel and (" + string2.substring(6) + ")";
        }
        int n = string.lastIndexOf("[");
        if (n >= 0) {
            if ((n = (string = string.substring(n + 1)).indexOf("]")) >= 0) {
                string = string.substring(0, n);
            }
            string = string.replace('_', ' ');
            if (string2.indexOf("[]") < 0) {
                string2 = "[] " + string2;
            }
            return TextFormat.simpleReplace((String)string2, (String)"[]", (String)string);
        }
        if (string2.indexOf("?FILEROOT?") >= 0) {
            string2 = TextFormat.simpleReplace((String)string2, (String)"FILEROOT?", (String)this.modelSetRoot);
        } else if (string2.indexOf("?FILE?") >= 0) {
            string2 = TextFormat.simpleReplace((String)string2, (String)"FILE?", (String)this.modelSetFileName);
        } else if (string2.indexOf("?PdbId?") >= 0) {
            string2 = TextFormat.simpleReplace((String)string2, (String)"PdbId?", (String)"=xxxx");
        }
        return string2;
    }

    public void checkMenuClick(Object object, String string) {
        this.restorePopupMenu();
        if (string == null || string.length() == 0) {
            return;
        }
        if (string.equals("MAIN")) {
            this.show(this.thisx, this.thisy);
            return;
        }
        String string2 = this.getId(object);
        if (string2 != null) {
            string = this.fixScript(string2, string);
            this.currentMenuItemId = string2;
        }
        this.viewer.evalStringQuiet(string);
    }

    void restorePopupMenu() {
    }

    Object addMenuItem(Object object, String string) {
        return this.addMenuItem(object, string, "", null);
    }

    Object addCheckboxMenuItem(Object object, String string, String string2, String string3, boolean bl) {
        Object object2 = this.addCheckboxMenuItem(object, string, string2, string3, false, bl);
        this.rememberCheckbox(string2, object2);
        return object2;
    }

    protected void showPopupMenu(int n, int n2) {
        if (this.display == null) {
            return;
        }
        try {
            this.swingPopup.show(this.display, n, n2);
        }
        catch (Exception exception) {
            Logger.error((String)("popup error: " + exception.getMessage()));
        }
    }

    void addToMenu(Object object, JComponent jComponent) {
        if (object instanceof JPopupMenu) {
            ((JPopupMenu)object).add(jComponent);
        } else if (object instanceof JMenu) {
            ((JMenu)object).add(jComponent);
        } else {
            Logger.warn((String)("cannot add object to menu: " + object));
        }
    }

    void addMenuSeparator(Object object) {
        if (object instanceof JPopupMenu) {
            ((JPopupMenu)object).addSeparator();
        } else {
            ((JMenu)object).addSeparator();
        }
    }

    Object addMenuItem(Object object, String string, String string2, String string3) {
        JMenuItem jMenuItem = new JMenuItem(string);
        this.updateButton(jMenuItem, string, string2);
        jMenuItem.addActionListener(this.mil);
        jMenuItem.setName(string3 == null ? ((Component)object).getName() + "." : string3);
        this.addToMenu(object, jMenuItem);
        return jMenuItem;
    }

    protected void setLabel(Object object, String string) {
        if (object instanceof JMenuItem) {
            ((JMenuItem)object).setText(string);
        } else {
            ((JMenu)object).setText(string);
        }
    }

    String getId(Object object) {
        return ((Component)object).getName();
    }

    void setCheckBoxValue(Object object) {
        JMenuItem jMenuItem = (JMenuItem)object;
        this.setCheckBoxValue(jMenuItem, jMenuItem.getActionCommand(), jMenuItem.isSelected());
    }

    void setCheckBoxState(Object object, boolean bl) {
        if (object instanceof JCheckBoxMenuItem) {
            ((JCheckBoxMenuItem)object).setState(bl);
        } else {
            ((JRadioButtonMenuItem)object).setArmed(bl);
        }
        ((JMenuItem)object).setSelected(bl);
    }

    protected ImageIcon getIcon(String string) {
        return null;
    }

    void updateButton(AbstractButton abstractButton, String string, String string2) {
        ImageIcon imageIcon = null;
        if (string.startsWith("<")) {
            int n = string.indexOf(">");
            imageIcon = this.getIcon(string.substring(1, n));
            string = string.substring(n + 1);
        }
        if (imageIcon != null) {
            abstractButton.setIcon(imageIcon);
        }
        if (string != null) {
            abstractButton.setText(string);
        }
        if (string2 != null) {
            abstractButton.setActionCommand(string2);
        }
    }

    Object addCheckboxMenuItem(Object object, String string, String string2, String string3, boolean bl, boolean bl2) {
        JMenuItem jMenuItem;
        if (bl2) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
            jMenuItem = jRadioButtonMenuItem;
            jRadioButtonMenuItem.setArmed(bl);
        } else {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
            jMenuItem = jCheckBoxMenuItem;
            jCheckBoxMenuItem.setState(bl);
        }
        jMenuItem.setSelected(bl);
        jMenuItem.addItemListener(this.cmil);
        jMenuItem.setActionCommand(string2);
        this.updateButton(jMenuItem, string, string2);
        jMenuItem.setName(string3 == null ? ((Component)object).getName() + "." : string3);
        this.addToMenu(object, jMenuItem);
        return jMenuItem;
    }

    Object cloneMenu(Object object) {
        return null;
    }

    void addMenuSubMenu(Object object, Object object2) {
        this.addToMenu(object, (JMenu)object2);
    }

    Object newMenu(String string, String string2) {
        JMenu jMenu = new JMenu(string);
        this.updateButton(jMenu, string, null);
        jMenu.setName(string2);
        jMenu.setAutoscrolls(true);
        return jMenu;
    }

    void setAutoscrolls(Object object) {
        ((JMenu)object).setAutoscrolls(true);
    }

    void renameMenu(Object object, String string) {
        ((JMenu)object).setText(string);
    }

    int getMenuItemCount(Object object) {
        return ((JMenu)object).getItemCount();
    }

    void removeMenuItem(Object object, int n) {
        ((JMenu)object).remove(n);
    }

    void removeAll(Object object) {
        ((JMenu)object).removeAll();
    }

    void enableMenu(Object object, boolean bl) {
        if (object instanceof JMenuItem) {
            this.enableMenuItem(object, bl);
            return;
        }
        try {
            ((JMenu)object).setEnabled(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void enableMenuItem(Object object, boolean bl) {
        try {
            ((JMenuItem)object).setEnabled(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class CheckboxMenuItemListener
    implements ItemListener {
        CheckboxMenuItemListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            SimplePopup.this.restorePopupMenu();
            SimplePopup.this.setCheckBoxValue(itemEvent.getSource());
            String string = SimplePopup.this.getId(itemEvent.getSource());
            if (string != null) {
                SimplePopup.this.currentMenuItemId = string;
            }
        }
    }

    class MenuItemListener
    implements ActionListener {
        MenuItemListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimplePopup.this.checkMenuClick(actionEvent.getSource(), actionEvent.getActionCommand());
        }
    }
}

