/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.List;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.PhosphorusMonomer;
import org.jmol.util.Quaternion;
import org.jmol.viewer.JmolConstants;

public class NucleicMonomer
extends PhosphorusMonomer {
    static final byte C6 = 1;
    private static final byte O2Pr = 2;
    private static final byte C5 = 3;
    private static final byte N1 = 4;
    private static final byte C2 = 5;
    private static final byte N3 = 6;
    private static final byte C4 = 7;
    private static final byte O2 = 8;
    private static final byte N7 = 9;
    private static final byte C8 = 10;
    private static final byte N9 = 11;
    private static final byte O4 = 12;
    private static final byte O6 = 13;
    private static final byte N4 = 14;
    private static final byte NP = 15;
    private static final byte N6 = 16;
    private static final byte N2 = 17;
    private static final byte H5T = 18;
    private static final byte O5Pr = 19;
    private static final byte H3T = 20;
    private static final byte O3Pr = 21;
    private static final byte C3Pr = 22;
    private static final byte O1P = 23;
    private static final byte O2P = 24;
    private static final byte C1P = 25;
    private static final byte C4P = 26;
    static final byte[] interestingNucleicAtomIDs = new byte[]{-14, 37, -80, 36, 32, 33, 34, 35, -39, -40, -41, -42, -48, -47, -43, -14, -45, -44, -73, -7, -89, 10, 9, -75, -77, -13, -9};
    private boolean hasRnaO2Prime;
    private static final byte[] ring6OffsetIndexes = new byte[]{3, 1, 4, 5, 6, 7};
    private static final byte[] ring5OffsetIndexes = new byte[]{3, 9, 10, 11, 7};
    private static final byte[] heavyAtomIndexes = new byte[]{3, 1, 4, 5, 6, 7, 11, 10, 9, 16, 14, 8, 12, 17, 13};
    Point3f baseCenter;

    public static Monomer validateAndAllocate(Chain chain, String string, int n, int n2, int n3, int[] nArray) {
        byte[] byArray = NucleicMonomer.scanForOffsets(n2, nArray, interestingNucleicAtomIDs);
        if (byArray == null) {
            return null;
        }
        if (!NucleicMonomer.checkOptional(byArray, (byte)19, n2, nArray[73])) {
            return null;
        }
        NucleicMonomer.checkOptional(byArray, (byte)20, n2, nArray[89]);
        NucleicMonomer.checkOptional(byArray, (byte)18, n2, nArray[90]);
        NucleicMonomer.checkOptional(byArray, (byte)23, n2, nArray[75]);
        NucleicMonomer.checkOptional(byArray, (byte)24, n2, nArray[77]);
        NucleicMonomer nucleicMonomer = new NucleicMonomer(chain, string, n, n2, n3, byArray);
        return nucleicMonomer;
    }

    NucleicMonomer(Chain chain, String string, int n, int n2, int n3, byte[] byArray) {
        super(chain, string, n, n2, n3, byArray);
        if (byArray[15] == -1 && (byArray[0] = byArray[18]) == -1) {
            byArray[0] = byArray[19];
            this.leadAtomIndex = n2 + (byArray[0] & 0xFF);
        }
        this.hasRnaO2Prime = byArray[2] != -1;
        this.isPyrimidine = byArray[8] != -1;
        this.isPurine = byArray[9] != -1 && byArray[10] != -1 && byArray[11] != -1;
    }

    public boolean isNucleicMonomer() {
        return true;
    }

    public boolean isDna() {
        return !this.hasRnaO2Prime;
    }

    public boolean isRna() {
        return this.hasRnaO2Prime;
    }

    public boolean isPurine() {
        return this.isPurine;
    }

    public boolean isPyrimidine() {
        return this.isPyrimidine;
    }

    public boolean isGuanine() {
        return this.offsets[17] != -1;
    }

    public byte getProteinStructureType() {
        return this.hasRnaO2Prime ? (byte)5 : 4;
    }

    Atom getC1P() {
        return this.getAtomFromOffsetIndex(25);
    }

    Atom getC2() {
        return this.getAtomFromOffsetIndex(5);
    }

    Atom getC4P() {
        return this.getAtomFromOffsetIndex(26);
    }

    Atom getN1() {
        return this.getAtomFromOffsetIndex(4);
    }

    Atom getN3() {
        return this.getAtomFromOffsetIndex(6);
    }

    Atom getN2() {
        return this.getAtomFromOffsetIndex(17);
    }

    Atom getN4() {
        return this.getAtomFromOffsetIndex(14);
    }

    Atom getN6() {
        return this.getAtomFromOffsetIndex(16);
    }

    Atom getO2() {
        return this.getAtomFromOffsetIndex(8);
    }

    Atom getO4() {
        return this.getAtomFromOffsetIndex(12);
    }

    Atom getO6() {
        return this.getAtomFromOffsetIndex(13);
    }

    Atom getTerminatorAtom() {
        return this.getAtomFromOffsetIndex(this.offsets[20] != -1 ? 20 : 21);
    }

    public void getBaseRing6Points(Point3f[] point3fArray) {
        int n = 6;
        while (--n >= 0) {
            point3fArray[n] = this.getAtomFromOffsetIndex(ring6OffsetIndexes[n]);
        }
    }

    public boolean maybeGetBaseRing5Points(Point3f[] point3fArray) {
        if (this.isPurine) {
            int n = 5;
            while (--n >= 0) {
                point3fArray[n] = this.getAtomFromOffsetIndex(ring5OffsetIndexes[n]);
            }
        }
        return this.isPurine;
    }

    boolean isConnectedAfter(Monomer monomer) {
        if (monomer == null) {
            return true;
        }
        Atom atom = this.getAtomFromOffsetIndex(15);
        if (atom == null) {
            return false;
        }
        if (!(monomer instanceof NucleicMonomer)) {
            return false;
        }
        NucleicMonomer nucleicMonomer = (NucleicMonomer)monomer;
        if (nucleicMonomer.getAtomFromOffsetIndex(21).isBonded(atom)) {
            return true;
        }
        return super.isConnectedAfter(monomer);
    }

    public void findNearestAtomIndex(int n, int n2, Atom[] atomArray, short s, short s2) {
        int n3;
        Atom atom = atomArray[0];
        Atom atom2 = this.getLeadAtom();
        Atom atom3 = this.getAtomFromOffsetIndex(19);
        Atom atom4 = this.getAtomFromOffsetIndex(22);
        int n4 = s / 2;
        if (n4 < 1900) {
            n4 = 1900;
        }
        if ((n3 = this.scaleToScreen(atom2.screenZ, n4)) < 4) {
            n3 = 4;
        }
        if (this.isCursorOnTopOf(atom2, n, n2, n3, atom) || this.isCursorOnTopOf(atom3, n, n2, n3, atom) || this.isCursorOnTopOf(atom4, n, n2, n3, atom)) {
            atomArray[0] = atom2;
        }
    }

    public void setModelClickability() {
        Atom atom;
        if (this.isAtomHidden(this.leadAtomIndex)) {
            return;
        }
        int n = 6;
        while (--n >= 0) {
            atom = this.getAtomFromOffsetIndex(ring6OffsetIndexes[n]);
            atom.setClickable(JmolConstants.CARTOON_VISIBILITY_FLAG);
        }
        if (this.isPurine) {
            n = 4;
            while (--n >= 1) {
                atom = this.getAtomFromOffsetIndex(ring5OffsetIndexes[n]);
                atom.setClickable(JmolConstants.CARTOON_VISIBILITY_FLAG);
            }
        }
    }

    Atom getN0() {
        return this.getAtomFromOffsetIndex(this.isPurine ? 11 : 4);
    }

    public Object getHelixData(int n, char c, int n2) {
        return this.getHelixData2(n, c, n2);
    }

    Point3f getQuaternionFrameCenter(char c) {
        switch (c) {
            case 'a': 
            case 'b': 
            case 'p': 
            case 'x': {
                return this.getP();
            }
            case 'c': {
                if (this.baseCenter == null) {
                    int n = 0;
                    this.baseCenter = new Point3f();
                    for (int i = 0; i < heavyAtomIndexes.length; ++i) {
                        Atom atom = this.getAtomFromOffsetIndex(heavyAtomIndexes[i]);
                        if (atom == null) continue;
                        this.baseCenter.add((Tuple3f)atom);
                        ++n;
                    }
                    this.baseCenter.scale(1.0f / (float)n);
                }
                return this.baseCenter;
            }
        }
        return this.getN0();
    }

    public Quaternion getQuaternion(char c) {
        Atom atom;
        Atom atom2;
        Atom atom3;
        Atom atom4 = null;
        Atom atom5 = null;
        boolean bl = false;
        boolean bl2 = false;
        switch (c) {
            case 'a': {
                atom3 = this.getP();
                if (this.monomerIndex == 0 || atom3 == null) {
                    return null;
                }
                bl = true;
                atom4 = ((NucleicMonomer)this.bioPolymer.monomers[this.monomerIndex - 1]).getC4P();
                atom5 = this.getC4P();
                break;
            }
            case 'x': {
                atom3 = this.getP();
                if (this.monomerIndex == this.bioPolymer.monomerCount - 1 || atom3 == null) {
                    return null;
                }
                atom4 = ((NucleicMonomer)this.bioPolymer.monomers[this.monomerIndex + 1]).getP();
                atom5 = this.getC4P();
                break;
            }
            case 'b': {
                return super.getQuaternion(c);
            }
            case 'c': 
            case 'n': {
                atom3 = this.getN0();
                if (atom3 == null) {
                    return null;
                }
                bl = true;
                bl2 = true;
                atom4 = this.getAtomFromOffsetIndex(5);
                atom5 = this.getAtomFromOffsetIndex(25);
                break;
            }
            case 'p': {
                atom3 = this.getP();
                if (atom3 == null) {
                    return null;
                }
                atom2 = this.getAtomFromOffsetIndex(23);
                atom = this.getAtomFromOffsetIndex(24);
                Bond[] bondArray = atom3.getBonds();
                if (bondArray == null) {
                    return null;
                }
                Group group = atom3.getGroup();
                for (int i = 0; i < bondArray.length; ++i) {
                    Atom atom6 = bondArray[i].getOtherAtom(atom3);
                    if (atom2 != null && atom6.index == atom2.index || atom != null && atom6.index == atom.index) continue;
                    if (atom6.getGroup() == group) {
                        atom5 = atom6;
                        continue;
                    }
                    atom4 = atom6;
                }
                break;
            }
            case 'q': {
                return null;
            }
            default: {
                atom3 = this.getN0();
                if (atom3 == null) {
                    return null;
                }
                if (this.isPurine) {
                    atom4 = this.getAtomFromOffsetIndex(5);
                    atom5 = this.getAtomFromOffsetIndex(9);
                    break;
                }
                atom4 = this.getAtomFromOffsetIndex(6);
                atom5 = this.getAtomFromOffsetIndex(1);
            }
        }
        if (atom4 == null || atom5 == null) {
            return null;
        }
        atom2 = new Vector3f((Tuple3f)atom4);
        atom2.sub((Tuple3f)atom3);
        atom = new Vector3f((Tuple3f)atom5);
        atom.sub((Tuple3f)atom3);
        if (bl2) {
            atom.scale(-1.0f);
        }
        return Quaternion.getQuaternionFrame((Vector3f)atom2, (Vector3f)atom, null, (boolean)bl);
    }

    public boolean isCrossLinked(Group group) {
        if (!(group instanceof NucleicMonomer) || this.isPurine == group.isPurine()) {
            return false;
        }
        NucleicMonomer nucleicMonomer = this.isPurine ? (NucleicMonomer)group : this;
        NucleicMonomer nucleicMonomer2 = this.isPurine ? this : (NucleicMonomer)group;
        Atom atom = nucleicMonomer2.getN1();
        Atom atom2 = nucleicMonomer.getN3();
        return atom.isBonded(atom2);
    }

    public boolean getCrossLinkLeadAtomIndexes(List list) {
        Atom atom = this.isPurine ? this.getN1() : this.getN3();
        Bond[] bondArray = atom.getBonds();
        if (bondArray == null) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < bondArray.length; ++i) {
            Atom atom2;
            Group group;
            if (!bondArray[i].isHydrogen() || !((group = (atom2 = bondArray[i].getOtherAtom(atom)).getGroup()) instanceof NucleicMonomer)) continue;
            NucleicMonomer nucleicMonomer = (NucleicMonomer)group;
            if ((this.isPurine ? nucleicMonomer.getN3() : nucleicMonomer.getN1()) != atom2) continue;
            if (list == null) {
                return true;
            }
            list.add(nucleicMonomer.leadAtomIndex);
            bl = true;
        }
        return bl;
    }

    public boolean getEdgePoints(Point3f[] point3fArray) {
        point3fArray[0] = this.getLeadAtom();
        point3fArray[1] = this.getC4P();
        point3fArray[2] = point3fArray[5] = this.getC1P();
        switch (this.getGroup1()) {
            case 'C': {
                point3fArray[3] = this.getO2();
                point3fArray[4] = this.getN4();
                return true;
            }
            case 'A': {
                point3fArray[3] = this.getC2();
                point3fArray[4] = this.getN6();
                return true;
            }
            case 'G': 
            case 'I': {
                point3fArray[3] = this.getC2();
                point3fArray[4] = this.getO6();
                return true;
            }
            case 'T': 
            case 'U': {
                point3fArray[3] = this.getO2();
                point3fArray[4] = this.getO4();
                return true;
            }
        }
        return false;
    }
}

