/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Matrix3f;
import org.jmol.script.ScriptEvaluator;
import org.jmol.script.ScriptVariable;
import org.jmol.script.Token;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Viewer;

public class PropertyManager {
    private static final String atomExpression = "<atom selection>";
    private static final String[] propertyTypes = new String[]{"appletInfo", "", "", "fileName", "", "", "fileHeader", "", "", "fileContents", "<pathname>", "", "fileContents", "", "", "animationInfo", "", "", "modelInfo", "<atom selection>", "(*)", "X -vibrationInfo", "", "", "shapeInfo", "", "", "measurementInfo", "", "", "centerInfo", "", "", "orientationInfo", "", "", "transformInfo", "", "", "atomList", "<atom selection>", "(visible)", "atomInfo", "<atom selection>", "(visible)", "bondInfo", "<atom selection>", "(visible)", "chainInfo", "<atom selection>", "(visible)", "polymerInfo", "<atom selection>", "(visible)", "moleculeInfo", "<atom selection>", "(visible)", "stateInfo", "<state type>", "all", "extractModel", "<atom selection>", "(visible)", "jmolStatus", "statusNameList", "", "jmolViewer", "", "", "messageQueue", "", "", "auxiliaryInfo", "<atom selection>", "*", "boundBoxInfo", "", "", "dataInfo", "<data type>", "types", "image", "", "", "evaluate", "<expression>", "", "menu", "<type>", "current", "minimizationInfo", "", "", "PointGroupInfo", "<atom selection>", "(visible)", "FileInfo", "<type>", "", "errorMessage", "", "", "mouseInfo", "", ""};
    private static final int PROP_APPLET_INFO = 0;
    private static final int PROP_FILENAME = 1;
    private static final int PROP_FILEHEADER = 2;
    public static final int PROP_FILECONTENTS_PATH = 3;
    private static final int PROP_FILECONTENTS = 4;
    private static final int PROP_ANIMATION_INFO = 5;
    private static final int PROP_MODEL_INFO = 6;
    private static final int PROP_SHAPE_INFO = 8;
    private static final int PROP_MEASUREMENT_INFO = 9;
    private static final int PROP_CENTER_INFO = 10;
    private static final int PROP_ORIENTATION_INFO = 11;
    private static final int PROP_TRANSFORM_INFO = 12;
    private static final int PROP_ATOM_LIST = 13;
    private static final int PROP_ATOM_INFO = 14;
    private static final int PROP_BOND_INFO = 15;
    private static final int PROP_CHAIN_INFO = 16;
    private static final int PROP_POLYMER_INFO = 17;
    private static final int PROP_MOLECULE_INFO = 18;
    private static final int PROP_STATE_INFO = 19;
    private static final int PROP_EXTRACT_MODEL = 20;
    private static final int PROP_JMOL_STATUS = 21;
    private static final int PROP_JMOL_VIEWER = 22;
    private static final int PROP_MESSAGE_QUEUE = 23;
    private static final int PROP_AUXILIARY_INFO = 24;
    private static final int PROP_BOUNDBOX_INFO = 25;
    private static final int PROP_DATA_INFO = 26;
    private static final int PROP_IMAGE = 27;
    private static final int PROP_EVALUATE = 28;
    private static final int PROP_MENU = 29;
    private static final int PROP_MINIMIZATION_INFO = 30;
    private static final int PROP_POINTGROUP_INFO = 31;
    private static final int PROP_FILE_INFO = 32;
    private static final int PROP_ERROR_MESSAGE = 33;
    private static final int PROP_MOUSE_INFO = 34;
    private static final int PROP_COUNT = 35;
    private static final String[] readableTypes = new String[]{"", "stateinfo", "extractmodel", "filecontents", "fileheader", "image", "menu"};

    public static int getPropertyNumber(String string) {
        if (string == null) {
            return -1;
        }
        for (int i = 0; i < 35; ++i) {
            if (!string.equalsIgnoreCase(PropertyManager.getPropertyName(i))) continue;
            return i;
        }
        return -1;
    }

    public static String getDefaultParam(int n) {
        if (n < 0) {
            return "";
        }
        return propertyTypes[n * 3 + 2];
    }

    public static boolean acceptsStringParameter(String string) {
        int n = PropertyManager.getPropertyNumber(string);
        String string2 = PropertyManager.getParamType(n);
        return string2.length() > 0 && string2 != atomExpression;
    }

    public static Object getProperty(Viewer viewer, String string, String string2, Object object) {
        if (propertyTypes.length != 105) {
            Logger.warn("propertyTypes is not the right length: " + propertyTypes.length + " != " + 105);
        }
        Object object2 = string2.indexOf(".") >= 0 || string2.indexOf("[") >= 0 ? PropertyManager.getModelProperty(viewer, string2, object) : PropertyManager.getPropertyAsObject(viewer, string2, object, string);
        if (string == null) {
            return object2;
        }
        boolean bl = string.equalsIgnoreCase("readable");
        if (bl) {
            String string3 = string = PropertyManager.isReadableAsString(string2) ? "String" : "JSON";
        }
        if (string.equalsIgnoreCase("String")) {
            return object2 == null ? "" : object2.toString();
        }
        if (bl) {
            return Escape.toReadable(string2, object2);
        }
        if (string.equalsIgnoreCase("JSON")) {
            return "{" + Escape.toJSON(string2, object2) + "}";
        }
        return object2;
    }

    static Object getModelProperty(Viewer viewer, String string, Object object) {
        string = string.replace(']', ' ').replace('[', ' ').replace('.', ' ');
        string = TextFormat.simpleReplace(string, "  ", " ");
        String[] stringArray = TextFormat.split(TextFormat.trim(string, " "), " ");
        ScriptVariable[] scriptVariableArray = new ScriptVariable[stringArray.length];
        string = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            int n = Parser.parseInt(stringArray[i]);
            scriptVariableArray[i] = n != Integer.MIN_VALUE ? new ScriptVariable(2, n) : new ScriptVariable(4, stringArray[i]);
        }
        return PropertyManager.extractProperty(PropertyManager.getProperty(viewer, null, string, object), scriptVariableArray, 1);
    }

    public static Object extractProperty(Object object, ScriptVariable[] scriptVariableArray, int n) {
        if (n >= scriptVariableArray.length) {
            return object;
        }
        ScriptVariable scriptVariable = scriptVariableArray[n++];
        switch (scriptVariable.tok) {
            case 2: {
                int n2 = ScriptVariable.iValue(scriptVariable) - 1;
                if (object instanceof Vector) {
                    Vector vector = (Vector)object;
                    if (n2 < 0) {
                        n2 += vector.size();
                    }
                    if (n2 >= 0 && n2 < vector.size()) {
                        return PropertyManager.extractProperty(vector.elementAt(n2), scriptVariableArray, n);
                    }
                    return "";
                }
                if (object instanceof String[]) {
                    String[] stringArray = (String[])object;
                    if (n2 < 0) {
                        n2 += stringArray.length;
                    }
                    if (n2 >= 0 && n2 < stringArray.length) {
                        return stringArray[n2];
                    }
                    return "";
                }
                if (object instanceof Matrix3f) {
                    Matrix3f matrix3f = (Matrix3f)object;
                    float[][] fArrayArray = new float[][]{{matrix3f.m00, matrix3f.m01, matrix3f.m02}, {matrix3f.m10, matrix3f.m11, matrix3f.m12}, {matrix3f.m20, matrix3f.m21, matrix3f.m22}};
                    if (n2 < 0) {
                        n2 += 3;
                    }
                    if (n2 >= 0 && n2 < 3) {
                        return PropertyManager.extractProperty(fArrayArray, scriptVariableArray, --n);
                    }
                    return "";
                }
                if (object instanceof float[]) {
                    float[] fArray = (float[])object;
                    if (n2 < 0) {
                        n2 += fArray.length;
                    }
                    if (n2 >= 0 && n2 < fArray.length) {
                        return new Float(fArray[n2]);
                    }
                    return "";
                }
                if (object instanceof int[]) {
                    int[] nArray = (int[])object;
                    if (n2 < 0) {
                        n2 += nArray.length;
                    }
                    if (n2 >= 0 && n2 < nArray.length) {
                        return new Integer(nArray[n2]);
                    }
                    return "";
                }
                if (object instanceof float[][]) {
                    float[][] fArray = (float[][])object;
                    if (n2 < 0) {
                        n2 += fArray.length;
                    }
                    if (n2 >= 0 && n2 < fArray.length) {
                        return PropertyManager.extractProperty(fArray[n2], scriptVariableArray, n);
                    }
                    return "";
                }
                if (object instanceof int[][]) {
                    int[][] nArray = (int[][])object;
                    if (n2 < 0) {
                        n2 += nArray.length;
                    }
                    if (n2 >= 0 && n2 < nArray.length) {
                        return PropertyManager.extractProperty(nArray[n2], scriptVariableArray, n);
                    }
                    return "";
                }
                if (!(object instanceof Object[])) break;
                Object[] objectArray = (Object[])object;
                if (n2 < 0) {
                    n2 += objectArray.length;
                }
                if (n2 >= 0 && n2 < objectArray.length) {
                    return objectArray[n2];
                }
                return "";
            }
            case 4: {
                String string = ScriptVariable.sValue(scriptVariable);
                if (!(object instanceof Hashtable)) break;
                Hashtable hashtable = (Hashtable)object;
                if (string.equalsIgnoreCase("keys")) {
                    Vector vector = new Vector();
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        vector.addElement(enumeration.nextElement());
                    }
                    return PropertyManager.extractProperty(vector, scriptVariableArray, n);
                }
                if (!hashtable.containsKey(string)) {
                    Enumeration enumeration = hashtable.keys();
                    String string2 = "";
                    while (enumeration.hasMoreElements()) {
                        string2 = (String)enumeration.nextElement();
                        if (!string2.equalsIgnoreCase(string)) continue;
                        string = string2;
                        break;
                    }
                }
                if (hashtable.containsKey(string)) {
                    return PropertyManager.extractProperty(hashtable.get(string), scriptVariableArray, n);
                }
                return "";
            }
        }
        return object;
    }

    private static String getPropertyName(int n) {
        if (n < 0) {
            return "";
        }
        return propertyTypes[n * 3];
    }

    private static String getParamType(int n) {
        if (n < 0) {
            return "";
        }
        return propertyTypes[n * 3 + 1];
    }

    private static boolean isReadableAsString(String string) {
        int n = readableTypes.length;
        while (--n >= 0) {
            if (!string.equalsIgnoreCase(readableTypes[n])) continue;
            return true;
        }
        return false;
    }

    private static Object getPropertyAsObject(Viewer viewer, String string, Object object, String string2) {
        if (string.equals("tokenList")) {
            return Token.getTokensLike((String)object);
        }
        int n = PropertyManager.getPropertyNumber(string);
        boolean bl = object != null && object.toString().length() > 0;
        Object object2 = bl ? object : PropertyManager.getDefaultParam(n);
        switch (n) {
            case 0: {
                return viewer.getAppletInfo();
            }
            case 5: {
                return viewer.getAnimationInfo();
            }
            case 13: {
                return viewer.getAtomBitSetVector(object2);
            }
            case 14: {
                return viewer.getAllAtomInfo(object2);
            }
            case 24: {
                return viewer.getAuxiliaryInfo(object2);
            }
            case 15: {
                return viewer.getAllBondInfo(object2);
            }
            case 25: {
                return viewer.getBoundBoxInfo();
            }
            case 10: {
                return viewer.getRotationCenter();
            }
            case 16: {
                return viewer.getAllChainInfo(object2);
            }
            case 20: {
                return viewer.getModelExtract(object2, true, false, false);
            }
            case 1: {
                return viewer.getFullPathName();
            }
            case 2: {
                return viewer.getFileHeader();
            }
            case 3: 
            case 4: {
                if (bl) {
                    return viewer.getFileAsString(object2.toString());
                }
                return viewer.getCurrentFileAsString();
            }
            case 21: {
                return viewer.getStatusChanged(object2.toString());
            }
            case 22: {
                return viewer;
            }
            case 9: {
                return viewer.getMeasurementInfo();
            }
            case 29: {
                return viewer.getMenu(object2.toString());
            }
            case 23: {
                return viewer.getMessageQueue();
            }
            case 30: {
                return viewer.getMinimizationInfo();
            }
            case 6: {
                return viewer.getModelInfo(object2);
            }
            case 18: {
                return viewer.getMoleculeInfo(object2);
            }
            case 11: {
                return viewer.getOrientationInfo();
            }
            case 17: {
                return viewer.getAllPolymerInfo(object2);
            }
            case 8: {
                return viewer.getShapeInfo();
            }
            case 19: {
                return viewer.getStateInfo(object2.toString());
            }
            case 31: {
                return viewer.getPointGroupInfo(object2);
            }
            case 32: {
                return PropertyManager.getFileInfo(viewer.getFileData(), object2.toString());
            }
            case 33: {
                return viewer.getErrorMessageUntranslated();
            }
            case 12: {
                return viewer.getMatrixRotate();
            }
            case 26: {
                return viewer.getData(object2.toString());
            }
            case 34: {
                return viewer.getMouseInfo();
            }
            case 28: {
                return ScriptEvaluator.evaluateExpression(viewer, object2.toString());
            }
            case 27: {
                return viewer.getImageAs(string2 == null ? "JPEG" : "JPG64", -1, -1, -1, null, null);
            }
        }
        String string3 = "getProperty ERROR\n" + string + "?\nOptions include:\n";
        for (int i = 0; i < 35; ++i) {
            String string4 = PropertyManager.getParamType(i);
            String string5 = PropertyManager.getDefaultParam(i);
            String string6 = PropertyManager.getPropertyName(i);
            if (string6.charAt(0) == 'X') continue;
            string3 = string3 + "\n getProperty " + string6 + (string4 != "" ? " " + string4 + (string5 != "" ? " #default: " + string5 : "") : "");
        }
        return string3;
    }

    static Object getFileInfo(Object object, String string) {
        boolean bl;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (object == null) {
            return hashtable;
        }
        boolean bl2 = bl = string != null && string.length() > 0;
        if (object instanceof Hashtable) {
            return bl ? ((Hashtable)object).get(string) : object;
        }
        String[] stringArray = TextFormat.split((String)object, '\n');
        String string2 = "";
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            string = string.toUpperCase();
        }
        String string3 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if (string4.length() < 12) continue;
            string3 = string4.substring(0, 6).trim();
            String string5 = string4.substring(7, 10).trim();
            if (string3.equals("REMARK")) {
                string3 = string3 + string5;
            }
            if (!string3.equals(string2)) {
                if (bl && string2.equals(string)) {
                    return stringBuffer.toString();
                }
                if (stringBuffer != null && !bl) {
                    hashtable.put(string2, stringBuffer.toString());
                    stringBuffer = new StringBuffer();
                }
                string2 = string3;
            }
            if (bl && !string3.equals(string)) continue;
            stringBuffer.append(string4.substring(10).trim()).append('\n');
        }
        if (stringBuffer != null && !bl) {
            hashtable.put(string2, stringBuffer.toString());
        }
        if (bl) {
            return string3.equals(string) ? stringBuffer.toString() : "";
        }
        return hashtable;
    }
}

