/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.BitSet;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.BoxInfo;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Measure;

public class MeshSurface {
    protected static final int SEED_COUNT = 25;
    public boolean haveQuads;
    public short colix;
    public boolean isColorSolid = true;
    public int vertexCount;
    public Point3f[] vertices;
    public Point3f[] offsetVertices;
    public short[] vertexColixes;
    public int polygonCount;
    public int[][] polygonIndexes;
    public short[] polygonColixes;
    public Vector3f[] vertexNormals;
    public BitSet bsFaces;
    public Point3f ptOffset;
    public float scale3d;
    public float[] vertexValues;
    public BitSet[] surfaceSet;
    public int[] vertexSets;
    public int nSets = 0;
    private int lastColor;
    private short lastColix;
    protected int iA;
    protected int iB;
    protected int iC;

    public void setColix(short s) {
        this.colix = s;
    }

    public int addVertexCopy(Point3f point3f) {
        if (this.vertexCount == 0) {
            this.vertices = new Point3f[25];
        } else if (this.vertexCount == this.vertices.length) {
            this.vertices = (Point3f[])ArrayUtil.doubleLength(this.vertices);
        }
        this.vertices[this.vertexCount] = new Point3f(point3f);
        return this.vertexCount++;
    }

    public void addTriangle(int n, int n2, int n3) {
        this.addPolygon(new int[]{n, n2, n3});
    }

    public void addQuad(int n, int n2, int n3, int n4) {
        this.haveQuads = true;
        this.addPolygon(new int[]{n, n2, n3, n4});
    }

    protected int addPolygon(int[] nArray) {
        int n = this.polygonCount;
        if (this.polygonCount == 0) {
            this.polygonIndexes = new int[25][];
        } else if (this.polygonCount == this.polygonIndexes.length) {
            this.polygonIndexes = (int[][])ArrayUtil.doubleLength(this.polygonIndexes);
        }
        this.polygonIndexes[this.polygonCount++] = nArray;
        return n;
    }

    public void setPolygonCount(int n) {
        this.polygonCount = n;
        if (n < 0) {
            return;
        }
        if (this.polygonIndexes == null || n > this.polygonIndexes.length) {
            this.polygonIndexes = new int[n][];
        }
    }

    public int addVertexCopy(Point3f point3f, float f) {
        if (this.vertexCount == 0) {
            this.vertexValues = new float[25];
        } else if (this.vertexCount >= this.vertexValues.length) {
            this.vertexValues = ArrayUtil.doubleLength(this.vertexValues);
        }
        this.vertexValues[this.vertexCount] = f;
        return this.addVertexCopy(point3f);
    }

    public int addTriangleCheck(int n, int n2, int n3, int n4, int n5, int n6) {
        return this.vertices == null || this.vertexValues != null && (Float.isNaN(this.vertexValues[n]) || Float.isNaN(this.vertexValues[n2]) || Float.isNaN(this.vertexValues[n3])) || Float.isNaN(this.vertices[n].x) || Float.isNaN(this.vertices[n2].x) || Float.isNaN(this.vertices[n3].x) ? -1 : this.addPolygon(new int[]{n, n2, n3, n4, n5}, n6);
    }

    private int addPolygon(int[] nArray, int n) {
        if (n != 0) {
            short s;
            if (this.polygonColixes == null || this.polygonCount == 0) {
                this.lastColor = 0;
            }
            if (n == this.lastColor) {
                s = this.lastColix;
            } else {
                this.lastColor = n;
                s = this.lastColix = Graphics3D.getColix(this.lastColor);
            }
            short s2 = s;
            this.setPolygonColix(this.polygonCount, s2);
        }
        return this.addPolygon(nArray);
    }

    private void setPolygonColix(int n, short s) {
        if (this.polygonColixes == null) {
            this.polygonColixes = new short[25];
        } else if (n == this.polygonColixes.length) {
            this.polygonColixes = ArrayUtil.doubleLength(this.polygonColixes);
        }
        this.polygonColixes[n] = s;
    }

    public void invalidatePolygons() {
        int n = this.polygonCount;
        while (--n >= 0) {
            if (this.setABC(n)) continue;
            this.polygonIndexes[n] = null;
        }
    }

    protected boolean setABC(int n) {
        int[] nArray = this.polygonIndexes[n];
        return nArray != null && !Float.isNaN(this.vertexValues[this.iA = nArray[0]]) && !Float.isNaN(this.vertexValues[this.iB = nArray[1]]) && !Float.isNaN(this.vertexValues[this.iC = nArray[2]]);
    }

    public void slabPolygons(Object object, boolean bl) {
        if (object instanceof Point4f) {
            this.getIntersection((Point4f)object, null, bl);
            return;
        }
        if (object instanceof Point3f[]) {
            Point4f[] point4fArray = BoxInfo.getFacesFromCriticalPoints((Point3f[])object);
            for (int i = 0; i < point4fArray.length; ++i) {
                this.getIntersection(point4fArray[i], null, bl);
            }
            return;
        }
    }

    public boolean getIntersection(Point4f point4f, Vector vector, boolean bl) {
        int n;
        int n2;
        Object object;
        Object object2;
        boolean bl2 = vector == null;
        Vector<int[]> vector2 = bl ? new Vector<int[]>() : null;
        int n3 = this.polygonIndexes.length;
        block16: while (--n3 >= 0) {
            if (!this.setABC(n3)) continue;
            Point3f point3f = this.vertices[this.iA];
            float f = Measure.distanceToPlane(point4f, point3f);
            Point3f point3f2 = this.vertices[this.iB];
            object2 = point3f2;
            float f2 = Measure.distanceToPlane(point4f, point3f2);
            object = this.vertices[this.iC];
            float f3 = Measure.distanceToPlane(point4f, (Point3f)object);
            int n4 = (f < 0.0f ? 1 : 0) + (f2 < 0.0f ? 2 : 0) + (f3 < 0.0f ? 4 : 0);
            int n5 = (f >= 0.0f ? 1 : 0) + (f2 >= 0.0f ? 2 : 0) + (f3 >= 0.0f ? 4 : 0);
            Point3f[] point3fArray = null;
            switch (n4) {
                case 0: 
                case 7: {
                    break;
                }
                case 1: 
                case 6: {
                    point3fArray = new Point3f[]{MeshSurface.interpolatePoint(point3f, (Point3f)object2, -f, f2), MeshSurface.interpolatePoint(point3f, (Point3f)object, -f, f3)};
                    break;
                }
                case 2: 
                case 5: {
                    point3fArray = new Point3f[]{MeshSurface.interpolatePoint((Point3f)object2, point3f, -f2, f), MeshSurface.interpolatePoint((Point3f)object2, (Point3f)object, -f2, f3)};
                    break;
                }
                case 3: 
                case 4: {
                    point3fArray = new Point3f[]{MeshSurface.interpolatePoint((Point3f)object, point3f, -f3, f), MeshSurface.interpolatePoint((Point3f)object, (Point3f)object2, -f3, f2)};
                }
            }
            if (bl2) {
                n2 = 0;
                n = 0;
                switch (n5) {
                    case 0: {
                        continue block16;
                    }
                    case 7: {
                        break;
                    }
                    case 1: {
                        n = this.addVertexCopy((Point3f)point3fArray[1], this.vertexValues[this.iA]);
                        n2 = this.addVertexCopy(point3fArray[0], this.vertexValues[this.iA]);
                        this.addTriangleCheck(n2, this.iB, this.iC, 0, 0, 0);
                        this.addTriangleCheck(n2, this.iC, n, 0, 0, 0);
                        break;
                    }
                    case 2: {
                        n = this.addVertexCopy((Point3f)point3fArray[0], this.vertexValues[this.iB]);
                        n2 = this.addVertexCopy(point3fArray[1], this.vertexValues[this.iB]);
                        this.addTriangleCheck(this.iA, n, this.iC, 0, 0, 0);
                        this.addTriangleCheck(n, n2, this.iC, 0, 0, 0);
                        break;
                    }
                    case 3: {
                        n = this.addVertexCopy((Point3f)point3fArray[0], this.vertexValues[this.iA]);
                        n2 = this.addVertexCopy(point3fArray[1], this.vertexValues[this.iB]);
                        this.addTriangleCheck(n2, this.iC, n, 0, 0, 0);
                        break;
                    }
                    case 4: {
                        n = this.addVertexCopy((Point3f)point3fArray[1], this.vertexValues[this.iC]);
                        n2 = this.addVertexCopy(point3fArray[0], this.vertexValues[this.iC]);
                        this.addTriangleCheck(this.iA, this.iB, n2, 0, 0, 0);
                        this.addTriangleCheck(n2, this.iB, n, 0, 0, 0);
                        break;
                    }
                    case 5: {
                        n = this.addVertexCopy((Point3f)point3fArray[1], this.vertexValues[this.iC]);
                        n2 = this.addVertexCopy(point3fArray[0], this.vertexValues[this.iA]);
                        this.addTriangleCheck(n2, this.iB, n, 0, 0, 0);
                        break;
                    }
                    case 6: {
                        n = this.addVertexCopy((Point3f)point3fArray[0], this.vertexValues[this.iB]);
                        n2 = this.addVertexCopy(point3fArray[1], this.vertexValues[this.iC]);
                        this.addTriangleCheck(this.iA, n, n2, 0, 0, 0);
                    }
                }
                this.polygonIndexes[n3] = null;
                if (!bl || n <= 0) continue;
                vector2.add(new int[]{n, n2});
                continue;
            }
            if (point3fArray == null) continue;
            vector.add(point3fArray);
        }
        if (bl && vector2.size() > 0) {
            Point3f point3f = new Point3f();
            int n6 = vector2.size();
            while (--n6 >= 0) {
                object2 = (int[])vector2.get(n6);
                point3f.add(this.vertices[object2[0]]);
                point3f.add(this.vertices[object2[1]]);
            }
            point3f.scale(0.5f / (float)vector2.size());
            n6 = this.addVertexCopy(point3f);
            int n7 = vector2.size();
            while (--n7 >= 0) {
                object = (int[])vector2.get(n7);
                n = this.addVertexCopy(this.vertices[object[0]], this.vertexValues[object[0]]);
                n2 = this.addVertexCopy(this.vertices[object[1]], this.vertexValues[object[1]]);
                this.addTriangleCheck(n, n6, n2, 0, 0, 0);
            }
        }
        return false;
    }

    private static Point3f interpolatePoint(Point3f point3f, Point3f point3f2, float f, float f2) {
        float f3 = f / (f + f2);
        if ((double)f3 < 1.0E-4) {
            f3 = 0.0f;
        } else if ((double)f3 > 0.9999) {
            f3 = 1.0f;
        }
        return new Point3f(point3f.x + (point3f2.x - point3f.x) * f3, point3f.y + (point3f2.y - point3f.y) * f3, point3f.z + (point3f2.z - point3f.z) * f3);
    }
}

