/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.shape.Mesh;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.viewer.Viewer;

public class IsosurfaceMesh
extends Mesh {
    JvxlData jvxlData = new JvxlData();
    int vertexIncrement = 1;
    int firstRealVertex = -1;
    int dataType;
    boolean hasGridPoints;
    Object calculatedArea;
    Object calculatedVolume;
    public boolean isSolvent;
    Hashtable assocGridPointMap;
    Hashtable assocGridPointNormals;
    int thisSet = -1;
    Point3f[] centers;
    float[] contourValues;
    short[] contourColixes;

    IsosurfaceMesh(String string, Graphics3D graphics3D, short s, int n) {
        super(string, graphics3D, s, n);
        this.checkByteCount = 2;
        this.jvxlData.version = Viewer.getJmolVersion();
    }

    void clear(String string, boolean bl) {
        super.clear(string);
        this.nSets = 0;
        this.thisSet = -1;
        this.vertexIncrement = 1;
        this.firstRealVertex = -1;
        this.hasGridPoints = bl;
        this.showPoints = bl;
        this.jvxlData.jvxlSurfaceData = "";
        this.jvxlData.jvxlEdgeData = "";
        this.jvxlData.jvxlColorData = "";
        this.jvxlData.jvxlVolumeDataXml = "";
        this.isColorSolid = true;
        this.vertexColixes = null;
        this.vertexValues = null;
        this.polygonColixes = null;
        this.jvxlData.contourValues = null;
        this.jvxlData.contourValuesUsed = null;
        this.jvxlData.contourColixes = null;
        this.jvxlData.contourColors = null;
        this.assocGridPointMap = null;
        this.assocGridPointNormals = null;
        this.vertexSets = null;
        this.centers = null;
        this.jvxlData.vContours = null;
        this.jvxlData.colorDensity = false;
        this.surfaceSet = null;
    }

    void allocVertexColixes() {
        if (this.vertexColixes == null) {
            this.vertexColixes = new short[this.vertexCount];
            int n = this.vertexCount;
            while (--n >= 0) {
                this.vertexColixes[n] = this.colix;
            }
        }
        this.isColorSolid = false;
    }

    int addVertexCopy(Point3f point3f, float f, int n, boolean bl) {
        int n2 = this.addVertexCopy(point3f, f);
        switch (n) {
            case -1: {
                if (this.firstRealVertex >= 0) break;
                this.firstRealVertex = n2;
                break;
            }
            case -2: {
                this.hasGridPoints = true;
                break;
            }
            case -3: {
                this.vertexIncrement = 3;
                break;
            }
            default: {
                if (this.firstRealVertex < 0) {
                    this.firstRealVertex = n2;
                }
                if (!bl) break;
                if (this.assocGridPointMap == null) {
                    this.assocGridPointMap = new Hashtable();
                    this.assocGridPointNormals = new Hashtable();
                }
                Integer n3 = new Integer(n);
                this.assocGridPointMap.put(new Integer(n2), n3);
                if (this.assocGridPointNormals.containsKey(n3)) break;
                this.assocGridPointNormals.put(n3, new Vector3f(0.0f, 0.0f, 0.0f));
            }
        }
        return n2;
    }

    public void setTranslucent(boolean bl, float f) {
        super.setTranslucent(bl, f);
        if (this.vertexColixes != null) {
            int n = this.vertexCount;
            while (--n >= 0) {
                this.vertexColixes[n] = Graphics3D.getColixTranslucent(this.vertexColixes[n], bl, f);
            }
        }
    }

    Object calculateArea() {
        if (this.calculatedArea != null) {
            return this.calculatedArea;
        }
        boolean bl = this.nSets == 0 || this.thisSet >= 0;
        int n = bl ? 1 : this.nSets;
        double[] dArray = new double[n];
        int n2 = this.polygonCount;
        while (--n2 >= 0) {
            int n3;
            if (!this.setABC(n2)) continue;
            int n4 = n3 = this.nSets == 0 ? 0 : this.vertexSets[this.iA];
            if (this.thisSet >= 0 && n3 != this.thisSet) continue;
            this.vAB.sub(this.vertices[this.iB], this.vertices[this.iA]);
            this.vAC.sub(this.vertices[this.iC], this.vertices[this.iA]);
            this.vTemp.cross(this.vAB, this.vAC);
            int n5 = bl ? 0 : n3;
            dArray[n5] = dArray[n5] + (double)this.vTemp.length();
        }
        n2 = 0;
        while (n2 < n) {
            int n6 = n2++;
            dArray[n6] = dArray[n6] / 2.0;
        }
        if (bl) {
            this.calculatedArea = new Float(dArray[0]);
            return this.calculatedArea;
        }
        this.calculatedArea = dArray;
        return dArray;
    }

    Object calculateVolume() {
        if (this.calculatedVolume != null) {
            return this.calculatedVolume;
        }
        boolean bl = this.nSets == 0 || this.thisSet >= 0;
        int n = bl ? 1 : this.nSets;
        double[] dArray = new double[n];
        int n2 = this.polygonCount;
        while (--n2 >= 0) {
            int n3;
            if (!this.setABC(n2)) continue;
            int n4 = n3 = this.nSets == 0 ? 0 : this.vertexSets[this.iA];
            if (this.thisSet >= 0 && n3 != this.thisSet) continue;
            this.vAB.set(this.vertices[this.iB]);
            this.vAC.set(this.vertices[this.iC]);
            this.vTemp.cross(this.vAB, this.vAC);
            this.vAC.set(this.vertices[this.iA]);
            int n5 = bl ? 0 : n3;
            dArray[n5] = dArray[n5] + (double)this.vAC.dot(this.vTemp);
        }
        n2 = 0;
        while (n2 < n) {
            int n6 = n2++;
            dArray[n6] = dArray[n6] / 6.0;
        }
        if (bl) {
            this.calculatedVolume = new Float(dArray[0]);
            return this.calculatedVolume;
        }
        this.calculatedVolume = dArray;
        return dArray;
    }

    protected void sumVertexNormals(Point3f[] point3fArray, Vector3f[] vector3fArray) {
        super.sumVertexNormals(point3fArray, vector3fArray);
        if (this.assocGridPointMap != null) {
            Integer n;
            Enumeration enumeration = this.assocGridPointMap.keys();
            while (enumeration.hasMoreElements()) {
                n = (Integer)enumeration.nextElement();
                ((Vector3f)this.assocGridPointNormals.get(this.assocGridPointMap.get(n))).add(vector3fArray[n]);
            }
            enumeration = this.assocGridPointMap.keys();
            while (enumeration.hasMoreElements()) {
                n = (Integer)enumeration.nextElement();
                vector3fArray[n.intValue()] = (Vector3f)this.assocGridPointNormals.get(this.assocGridPointMap.get(n));
            }
        }
    }

    Point3f[] getCenters() {
        if (this.centers != null) {
            return this.centers;
        }
        this.centers = new Point3f[this.polygonCount];
        for (int i = 0; i < this.polygonCount; ++i) {
            int[] nArray = this.polygonIndexes[i];
            if (nArray == null) continue;
            Point3f point3f = this.centers[i] = new Point3f();
            point3f.add(this.vertices[nArray[0]]);
            point3f.add(this.vertices[nArray[1]]);
            point3f.add(this.vertices[nArray[2]]);
            point3f.scale(0.33333334f);
        }
        return this.centers;
    }

    Point4f getFacePlane(int n, Vector3f vector3f) {
        return Measure.getPlaneThroughPoints(this.vertices[this.polygonIndexes[n][0]], this.vertices[this.polygonIndexes[n][1]], this.vertices[this.polygonIndexes[n][2]], vector3f, this.vAB, this.vAC);
    }

    Vector[] getContours() {
        int n;
        Vector[] vectorArray;
        int n2 = this.jvxlData.nContours;
        if (n2 == 0 || this.polygonIndexes == null) {
            return null;
        }
        boolean bl = this.havePlanarContours = this.jvxlData.jvxlPlane != null;
        if (this.havePlanarContours) {
            return null;
        }
        if (n2 < 0) {
            n2 = -1 - n2;
        }
        if ((vectorArray = this.jvxlData.vContours) != null) {
            for (int i = 0; i < n2; ++i) {
                if (vectorArray[i].size() > 6) {
                    return this.jvxlData.vContours;
                }
                JvxlCoder.set3dContourVector(vectorArray[i], this.polygonIndexes, this.vertices);
            }
            return this.jvxlData.vContours;
        }
        vectorArray = new Vector[n2];
        for (n = 0; n < n2; ++n) {
            vectorArray[n] = new Vector();
        }
        if (this.jvxlData.contourValuesUsed == null) {
            float f = (this.jvxlData.valueMappedToBlue - this.jvxlData.valueMappedToRed) / (float)(n2 + 1);
            for (int i = 0; i < n2; ++i) {
                float f2 = this.jvxlData.valueMappedToRed + (float)(i + 1) * f;
                this.get3dContour(vectorArray[i], f2, this.jvxlData.contourColixes[i]);
            }
            Logger.info(n2 + " contour lines; separation = " + f);
        } else {
            for (n = 0; n < n2; ++n) {
                float f = this.jvxlData.contourValuesUsed[n];
                this.get3dContour(vectorArray[n], f, this.jvxlData.contourColixes[n]);
            }
        }
        this.jvxlData.contourColixes = new short[n2];
        this.jvxlData.contourValues = new float[n2];
        for (int i = 0; i < n2; ++i) {
            this.jvxlData.contourValues[i] = ((Float)vectorArray[i].get(2)).floatValue();
            this.jvxlData.contourColixes[i] = ((short[])vectorArray[i].get(3))[0];
        }
        this.jvxlData.vContours = vectorArray;
        return vectorArray;
    }

    private void get3dContour(Vector vector, float f, short s) {
        BitSet bitSet = new BitSet(this.polygonCount);
        StringBuffer stringBuffer = new StringBuffer();
        int n = Graphics3D.getArgb(s);
        IsosurfaceMesh.setContourVector(vector, this.polygonCount, bitSet, f, s, n, stringBuffer);
        for (int i = 0; i < this.polygonCount; ++i) {
            if (!this.setABC(i)) continue;
            IsosurfaceMesh.addContourPoints(vector, bitSet, i, stringBuffer, this.vertices, this.vertexValues, this.iA, this.iB, this.iC, f);
        }
    }

    public static void setContourVector(Vector vector, int n, BitSet bitSet, float f, short s, int n2, StringBuffer stringBuffer) {
        vector.add(0, new Integer(n));
        vector.add(1, bitSet);
        vector.add(2, new Float(f));
        vector.add(3, new short[]{s});
        vector.add(4, new int[]{n2});
        vector.add(5, stringBuffer);
    }

    public static void addContourPoints(Vector vector, BitSet bitSet, int n, StringBuffer stringBuffer, Point3f[] point3fArray, float[] fArray, int n2, int n3, int n4, float f) {
        float f2;
        Point3f point3f = null;
        Point3f point3f2 = null;
        int n5 = 0;
        float f3 = IsosurfaceMesh.checkPt(fArray, n2, n3, f);
        if (!Float.isNaN(f3)) {
            point3f = IsosurfaceMesh.getContourPoint(point3fArray, n2, n3, f3);
            n5 |= 1;
        }
        float f4 = f2 = f3 == 1.0f ? Float.NaN : IsosurfaceMesh.checkPt(fArray, n3, n4, f);
        if (!Float.isNaN(f2)) {
            point3f2 = IsosurfaceMesh.getContourPoint(point3fArray, n3, n4, f2);
            if (n5 == 0) {
                point3f = point3f2;
                f3 = f2;
            }
            n5 |= 2;
        }
        switch (n5) {
            case 0: {
                return;
            }
            case 1: {
                if (f3 == 0.0f) {
                    return;
                }
            }
            case 2: {
                float f5 = f2 = f2 == 1.0f ? Float.NaN : IsosurfaceMesh.checkPt(fArray, n4, n2, f);
                if (Float.isNaN(f2)) break;
                point3f2 = IsosurfaceMesh.getContourPoint(point3fArray, n4, n2, f2);
                n5 |= 4;
            }
        }
        switch (n5) {
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                return;
            }
        }
        bitSet.set(n);
        JvxlCoder.appendContourTriangleIntersection(n5, f3, f2, stringBuffer);
        vector.add(point3f);
        vector.add(point3f2);
    }

    private static float checkPt(float[] fArray, int n, int n2, float f) {
        float f2;
        float f3 = fArray[n];
        return f == f3 ? 0.0f : (f == (f2 = fArray[n2]) ? 1.0f : (f3 < f == f < f2 ? (f - f3) / (f2 - f3) : Float.NaN));
    }

    private static Point3f getContourPoint(Point3f[] point3fArray, int n, int n2, float f) {
        Point3f point3f = new Point3f();
        point3f.set(point3fArray[n2]);
        point3f.sub(point3fArray[n]);
        point3f.scale(f);
        point3f.add(point3fArray[n]);
        return point3f;
    }

    public void setDiscreteColixes(float[] fArray, short[] sArray) {
        if (fArray != null) {
            this.jvxlData.contourValues = fArray;
        }
        if (fArray == null || fArray.length == 0) {
            this.jvxlData.contourValues = this.jvxlData.contourValuesUsed;
            fArray = this.jvxlData.contourValuesUsed;
        }
        if (sArray == null && this.jvxlData.contourColixes != null) {
            sArray = this.jvxlData.contourColixes;
        } else {
            this.jvxlData.contourColixes = sArray;
            this.jvxlData.contourColors = Graphics3D.getHexCodes(sArray);
        }
        if (this.vertices == null || this.vertexValues == null || fArray == null) {
            return;
        }
        int n = fArray.length;
        float f = fArray[n - 1];
        this.colorCommand = null;
        boolean bl = sArray != null && sArray.length > 0;
        boolean bl2 = this.isColorSolid = bl && this.jvxlData.jvxlPlane != null;
        if (this.jvxlData.vContours != null) {
            if (bl) {
                for (int i = 0; i < this.jvxlData.vContours.length; ++i) {
                    short s;
                    ((short[])this.jvxlData.vContours[i].get((int)3))[0] = s = sArray[i % sArray.length];
                    ((int[])this.jvxlData.vContours[i].get((int)4))[0] = Graphics3D.getArgb(s);
                }
            }
            return;
        }
        short s = 0;
        this.polygonColixes = new short[this.polygonCount];
        block1: for (int i = 0; i < this.polygonCount; ++i) {
            int[] nArray = this.polygonIndexes[i];
            if (nArray == null) continue;
            this.polygonColixes[i] = s;
            float f2 = (this.vertexValues[nArray[0]] + this.vertexValues[nArray[1]] + this.vertexValues[nArray[2]]) / 3.0f;
            int n2 = n;
            while (--n2 >= 0) {
                if (!(f2 >= fArray[n2]) || !(f2 < f)) continue;
                this.polygonColixes[i] = bl ? sArray[n2 % sArray.length] : (short)0;
                continue block1;
            }
        }
    }

    Hashtable getContourList(Viewer viewer) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("values", this.jvxlData.contourValuesUsed == null ? this.jvxlData.contourValues : this.jvxlData.contourValuesUsed);
        Vector<Point3f> vector = new Vector<Point3f>();
        if (this.jvxlData.contourColixes != null) {
            for (int i = 0; i < this.jvxlData.contourColixes.length; ++i) {
                vector.add(Graphics3D.colorPointFromInt2(Graphics3D.getArgb(this.jvxlData.contourColixes[i])));
            }
            hashtable.put("colors", vector);
        }
        return hashtable;
    }
}

