/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.api.SymmetryInterface;
import org.jmol.g3d.Graphics3D;
import org.jmol.shape.Mesh;
import org.jmol.shape.MeshCollection;
import org.jmol.shape.ShapeRenderer;

public abstract class MeshRenderer
extends ShapeRenderer {
    protected float imageFontScaling;
    protected float scalePixelsPerMicron;
    protected Point3f[] vertices;
    protected short[] normixes;
    protected Point3i[] screens;
    protected Vector3f[] transformedVectors;
    protected int vertexCount;
    protected boolean frontOnly;
    protected boolean antialias;
    protected Mesh mesh;
    protected int diameter;
    protected float width;
    protected boolean isTranslucent;
    protected Point4f thePlane;
    protected Point3f latticeOffset = new Point3f();
    protected final Point3f pt1f = new Point3f();
    protected final Point3f pt2f = new Point3f();
    protected final Point3i pt1i = new Point3i();
    protected final Point3i pt2i = new Point3i();
    protected final Point3i pt3i = new Point3i();
    protected BitSet bsFaces = new BitSet();

    protected void render() {
        this.antialias = this.g3d.isAntialiased();
        MeshCollection meshCollection = (MeshCollection)this.shape;
        int n = meshCollection.meshCount;
        while (--n >= 0) {
            this.render1(meshCollection.meshes[n]);
        }
    }

    public boolean render1(Mesh mesh) {
        this.mesh = mesh;
        if (!this.setVariables()) {
            return false;
        }
        if (!this.g3d.setColix(this.colix) && !mesh.showContourLines) {
            return mesh.title != null;
        }
        this.latticeOffset.set(0.0f, 0.0f, 0.0f);
        int n = this.vertexCount;
        while (--n >= 0) {
            this.viewer.transformPoint(this.vertices[n], this.screens[n]);
        }
        this.render2(this.exportType != 0);
        if (mesh.lattice == null || mesh.modelIndex < 0) {
            this.render2(this.exportType != 0);
        } else {
            SymmetryInterface symmetryInterface = this.viewer.getModelUnitCell(mesh.modelIndex);
            if (symmetryInterface != null) {
                Point3f point3f = new Point3f();
                Point3i point3i = new Point3i();
                Point3i point3i2 = new Point3i((int)mesh.lattice.x, (int)mesh.lattice.y, (int)mesh.lattice.z);
                symmetryInterface.setMinMaxLatticeParameters(point3i, point3i2);
                for (int i = point3i.x; i < point3i2.x; ++i) {
                    for (int j = point3i.y; j < point3i2.y; ++j) {
                        for (int k = point3i.z; k < point3i2.z; ++k) {
                            this.latticeOffset.set(i, j, k);
                            symmetryInterface.toCartesian(this.latticeOffset, false);
                            int n2 = this.vertexCount;
                            while (--n2 >= 0) {
                                point3f.set(this.vertices[n2]);
                                point3f.add(this.latticeOffset);
                                this.viewer.transformPoint(point3f, this.screens[n2]);
                            }
                            this.render2(this.exportType != 0);
                        }
                    }
                }
            }
        }
        if (this.screens != null) {
            this.viewer.freeTempScreens(this.screens);
        }
        return true;
    }

    private boolean setVariables() {
        this.vertices = this.mesh.ptOffset == null && this.mesh.scale3d == 0.0f ? this.mesh.vertices : this.mesh.getOffsetVertices(this.thePlane);
        this.colix = this.mesh.colix;
        if (this.mesh.visibilityFlags == 0) {
            return false;
        }
        if (this.mesh.lineData == null) {
            this.vertexCount = this.mesh.vertexCount;
            if (this.vertexCount == 0 || !this.mesh.colorDensity && this.mesh.polygonCount == 0) {
                return false;
            }
            this.normixes = this.mesh.normixes;
            if (this.normixes == null || this.vertices == null) {
                return false;
            }
            this.frontOnly = !this.viewer.getSlabEnabled() && this.mesh.frontOnly && !this.mesh.isTwoSided;
            this.screens = this.viewer.allocTempScreens(this.vertexCount);
            this.transformedVectors = this.g3d.getTransformedVertexVectors();
        }
        this.isTranslucent = Graphics3D.isColixTranslucent(this.mesh.colix);
        return true;
    }

    protected boolean isPolygonDisplayable(int n) {
        return true;
    }

    protected void render2(boolean bl) {
        if (!this.g3d.setColix(this.colix)) {
            return;
        }
        if (this.mesh.showPoints) {
            this.renderPoints();
        }
        if (this.mesh.drawTriangles) {
            this.renderTriangles(false, this.mesh.showTriangles, false);
        }
        if (this.mesh.fillTriangles) {
            this.renderTriangles(true, this.mesh.showTriangles, bl);
        }
    }

    protected void renderPoints() {
        if (this.mesh.isPolygonSet) {
            int[][] nArray = this.mesh.polygonIndexes;
            BitSet bitSet = new BitSet();
            int n = this.mesh.polygonCount;
            while (--n >= 0) {
                int[] nArray2 = nArray[n];
                if (this.frontOnly && this.transformedVectors[this.normixes[n]].z < 0.0f) continue;
                int n2 = nArray2.length - 1;
                while (--n2 >= 0) {
                    int n3 = nArray2[n2];
                    if (bitSet.get(n3)) continue;
                    bitSet.set(n3);
                    this.g3d.fillSphere(4, this.screens[n3]);
                }
            }
            return;
        }
        int n = this.vertexCount;
        while (--n >= 0) {
            if (this.frontOnly && this.transformedVectors[this.normixes[n]].z < 0.0f) continue;
            this.g3d.fillSphere(4, this.screens[n]);
        }
    }

    protected void renderTriangles(boolean bl, boolean bl2, boolean bl3) {
        int[][] nArray = this.mesh.polygonIndexes;
        this.colix = this.mesh.colix;
        this.g3d.setColix(this.colix);
        if (bl3) {
            if (this.frontOnly && bl) {
                this.frontOnly = false;
            }
            this.bsFaces.clear();
        }
        int n = this.mesh.polygonCount;
        while (--n >= 0) {
            int n2;
            short s;
            if (!this.isPolygonDisplayable(n)) continue;
            int[] nArray2 = nArray[n];
            int n3 = nArray2[0];
            int n4 = nArray2[1];
            int n5 = nArray2[2];
            if (n4 == n5) {
                this.drawLine(n3, n4, bl, this.vertices[n3], this.vertices[n4], this.screens[n3], this.screens[n4]);
                continue;
            }
            if (this.mesh.isPolygonSet) {
                s = this.normixes[n];
                if (!this.g3d.isDirectedTowardsCamera(s)) continue;
                if (bl) {
                    if (this.exportType != 0) {
                        this.g3d.fillTriangle(this.screens[n5], this.colix, s, this.screens[n4], this.colix, s, this.screens[n3], this.colix, s);
                        continue;
                    }
                    if (bl2) {
                        this.g3d.fillTriangle(this.screens[n3], this.colix, s, this.screens[n4], this.colix, s, this.screens[n5], this.colix, s, 0.1f);
                        continue;
                    }
                    this.g3d.fillTriangle(this.screens[n3], this.colix, s, this.screens[n4], this.colix, s, this.screens[n5], this.colix, s);
                    continue;
                }
                n2 = nArray2[3];
                if ((n2 & 1) == 1) {
                    this.drawLine(n3, n4, true, this.vertices[n3], this.vertices[n4], this.screens[n3], this.screens[n4]);
                }
                if ((n2 & 2) == 2) {
                    this.drawLine(n4, n5, true, this.vertices[n4], this.vertices[n5], this.screens[n4], this.screens[n5]);
                }
                if ((n2 & 4) != 4) continue;
                this.drawLine(n3, n5, true, this.vertices[n3], this.vertices[n5], this.screens[n3], this.screens[n5]);
                continue;
            }
            n2 = 7;
            if (this.frontOnly) {
                if (this.transformedVectors[this.normixes[n3]].z < 0.0f) {
                    n2 ^= 1;
                }
                if (this.transformedVectors[this.normixes[n4]].z >= 0.0f) {
                    n2 ^= 2;
                }
                if (this.transformedVectors[this.normixes[n5]].z >= 0.0f) {
                    n2 ^= 4;
                }
            }
            if (bl && n2 != 7) continue;
            switch (nArray2.length) {
                case 3: {
                    if (bl) {
                        if (bl3) {
                            this.bsFaces.set(n);
                            break;
                        }
                        if (bl2) {
                            this.g3d.fillTriangle(this.screens[n3], this.colix, this.normixes[n3], this.screens[n4], this.colix, this.normixes[n4], this.screens[n5], this.colix, this.normixes[n5], 0.1f);
                            break;
                        }
                        this.g3d.fillTriangle(this.screens[n3], this.colix, this.normixes[n3], this.screens[n4], this.colix, this.normixes[n4], this.screens[n5], this.colix, this.normixes[n5]);
                        break;
                    }
                    this.g3d.drawTriangle(this.screens[n3], this.screens[n4], this.screens[n5], n2);
                    break;
                }
                case 4: {
                    s = nArray2[3];
                    if (bl) {
                        if (bl3) {
                            this.bsFaces.set(n);
                            break;
                        }
                        this.g3d.fillQuadrilateral(this.screens[n3], this.colix, this.normixes[n3], this.screens[n4], this.colix, this.normixes[n4], this.screens[n5], this.colix, this.normixes[n5], this.screens[s], this.colix, this.normixes[s]);
                        break;
                    }
                    this.g3d.drawQuadrilateral(this.colix, this.screens[n3], this.screens[n4], this.screens[n5], this.screens[s]);
                }
            }
        }
        if (bl3) {
            this.exportSurface();
        }
    }

    protected void drawLine(int n, int n2, boolean bl, Point3f point3f, Point3f point3f2, Point3i point3i, Point3i point3i2) {
        byte by;
        byte by2 = n != n2 && !bl ? (byte)0 : (by = this.width < 0.0f || (double)this.width == -0.0 || n != n2 && this.isTranslucent ? (byte)2 : 3);
        if (this.width == 0.0f) {
            if (this.diameter == 0) {
                int n3 = this.mesh.diameter > 0 ? this.mesh.diameter : (this.diameter = n == n2 ? 7 : 3);
            }
            if (this.exportType == 1) {
                this.pt1f.set(point3f);
                this.pt1f.add(point3f2);
                this.pt1f.scale(0.5f);
                this.viewer.transformPoint(this.pt1f, this.pt1i);
                this.diameter = (int)(this.viewer.unscaleToScreen(this.pt1i.z, this.diameter) * 1000.0f);
            }
            if (n == n2) {
                this.g3d.fillSphere(this.diameter, point3i);
            } else {
                this.g3d.fillCylinder(by, this.diameter, point3i, point3i2);
            }
        } else {
            this.pt1f.set(point3f);
            this.pt1f.add(point3f2);
            this.pt1f.scale(0.5f);
            this.viewer.transformPoint(this.pt1f, this.pt1i);
            int n4 = (int)(Math.abs(this.width) * 1000.0f);
            int n5 = this.diameter = this.exportType == 1 ? n4 : (int)this.viewer.scaleToScreen(this.pt1i.z, n4);
            if (this.diameter == 0) {
                this.diameter = 1;
            }
            this.viewer.transformPoint(point3f, this.pt1f);
            this.viewer.transformPoint(point3f2, this.pt2f);
            this.g3d.fillCylinderBits(by, this.diameter, this.pt1f, this.pt2f);
        }
    }

    protected void exportSurface() {
        this.mesh.vertexNormals = this.mesh.getNormals(this.vertices, null);
        this.mesh.bsFaces = this.bsFaces;
        this.g3d.drawSurface(this.mesh, this.mesh.offsetVertices, this.latticeOffset);
        this.mesh.vertexNormals = null;
        this.mesh.bsFaces = null;
    }
}

