/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.console;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.jmol.api.JmolScriptEditorInterface;
import org.jmol.api.JmolViewer;
import org.jmol.console.ScriptEditor;
import org.jmol.i18n.GT;
import org.jmol.script.ScriptCompiler;
import org.jmol.script.Token;
import org.jmol.util.ArrayUtil;
import org.jmol.util.TextFormat;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public abstract class JmolConsole
extends JDialog
implements ActionListener,
WindowListener {
    public JmolViewer viewer;
    protected Component display;
    protected ScriptEditor scriptEditor;
    protected JButton editButton;
    protected JButton runButton;
    protected JButton historyButton;
    protected JButton stateButton;
    public int nTab = 0;
    private String incompleteCmd;

    void setScriptEditor(ScriptEditor scriptEditor) {
        this.scriptEditor = scriptEditor;
    }

    public JmolScriptEditorInterface getScriptEditor() {
        return this.scriptEditor == null ? (this.scriptEditor = new ScriptEditor(this.viewer, this.display instanceof JFrame ? (JFrame)this.display : null, this)) : this.scriptEditor;
    }

    JmolViewer getViewer() {
        return this.viewer;
    }

    public JmolConsole() {
    }

    public JmolConsole(JmolViewer jmolViewer, JFrame jFrame) {
        super(jFrame, JmolConsole.getTitleText(), false);
        this.viewer = jmolViewer;
        this.display = jFrame;
    }

    protected abstract void clearContent(String var1);

    protected abstract void execute(String var1);

    protected static String getTitleText() {
        return GT._("Jmol Script Console") + " " + Viewer.getJmolVersion();
    }

    protected String completeCommand(String string) {
        String string2;
        if (string.length() == 0) {
            return null;
        }
        this.incompleteCmd = string2 = this.nTab <= 0 || this.incompleteCmd == null ? string : this.incompleteCmd;
        String[] stringArray = ScriptCompiler.splitCommandLine(string);
        if (stringArray == null) {
            return null;
        }
        boolean bl = stringArray[2] == null;
        String string3 = stringArray[bl ? 1 : 2];
        if (string3.length() == 0) {
            return null;
        }
        stringArray = ScriptCompiler.splitCommandLine(string2);
        String string4 = null;
        if (!(bl || string3.charAt(0) != '\"' && string3.charAt(0) != '\'')) {
            char c = string3.charAt(0);
            string3 = TextFormat.trim(string3, "\"'");
            String string5 = TextFormat.trim(stringArray[2], "\"'");
            string4 = this.nextFileName(string5, this.nTab);
            if (string4 != null) {
                string4 = stringArray[0] + stringArray[1] + c + (string4 == null ? string3 : string4) + c;
            }
        } else {
            if (!bl) {
                string3 = stringArray[1];
            }
            string4 = Token.completeCommand(null, stringArray[1].equalsIgnoreCase("set "), bl, bl ? stringArray[1] : stringArray[2], this.nTab);
            string4 = stringArray[0] + (string4 == null ? string3 : (bl ? string4 : stringArray[1] + string4));
        }
        return string4 == null || string4.equals(string2) ? null : string4;
    }

    private String nextFileName(String string, int n) {
        Object object;
        String string2 = FileManager.getLocalPathForWritingFile(this.viewer, string);
        String string3 = string2.substring(0, string2.lastIndexOf("/") + 1);
        if (string2.startsWith("file:/")) {
            string2 = string2.substring(6);
        }
        if (string2.indexOf("/") >= 0) {
            if (string3.equals(string2)) {
                string = "";
            } else {
                object = new File(string2);
                string2 = ((File)object).getParent();
                string = ((File)object).getName();
            }
        }
        object = new FileChecker(string);
        try {
            new File(string2).list((FilenameFilter)object);
            return string3 + ((FileChecker)object).getFile(n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.runButton) {
            this.execute(null);
        } else if (object == this.editButton) {
            this.viewer.getProperty("DATA_API", "scriptEditor", null);
        } else if (object == this.historyButton) {
            this.clearContent(this.viewer.getSetHistory(Integer.MAX_VALUE));
        } else if (object == this.stateButton) {
            this.clearContent(this.viewer.getStateInfo());
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    static {
        System.out.println("JmolConsole is initializing");
    }

    protected class FileChecker
    implements FilenameFilter {
        private String stub;
        private Vector v = new Vector();

        protected FileChecker(String string) {
            this.stub = string.toLowerCase();
        }

        public boolean accept(File file, String string) {
            if (!string.toLowerCase().startsWith(this.stub)) {
                return false;
            }
            this.v.add(string);
            return true;
        }

        protected String getFile(int n) {
            return ArrayUtil.sortedItem(this.v, n);
        }
    }
}

