/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cifpdb;

import java.util.Hashtable;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolLineReader;
import org.jmol.util.CifDataReader;
import org.jmol.util.Logger;

public class CifReader
extends AtomSetCollectionReader
implements JmolLineReader {
    private CifDataReader tokenizer = new CifDataReader(this);
    private String thisDataSetName = "";
    private String chemicalName = "";
    private String thisStructuralFormula = "";
    private String thisFormula = "";
    private boolean iHaveDesiredModel;
    private boolean isPDB = false;
    private Hashtable htHetero;
    public static final String[] cellParamNames = new String[]{"_cell_length_a", "_cell_length_b", "_cell_length_c", "_cell_angle_alpha", "_cell_angle_beta", "_cell_angle_gamma"};
    private static final String[] TransformFields = new String[]{"x[1][1]", "x[1][2]", "x[1][3]", "r[1]", "x[2][1]", "x[2][2]", "x[2][3]", "r[2]", "x[3][1]", "x[3][2]", "x[3][3]", "r[3]"};
    private String key;
    private String data;
    private Hashtable atomTypes;
    private static final byte ATOM_TYPE_SYMBOL = 0;
    private static final byte ATOM_TYPE_OXIDATION_NUMBER = 1;
    private static final String[] atomTypeFields = new String[]{"_atom_type_symbol", "_atom_type_oxidation_number"};
    private static final byte NONE = -1;
    private static final byte TYPE_SYMBOL = 0;
    private static final byte LABEL = 1;
    private static final byte AUTH_ATOM = 2;
    private static final byte FRACT_X = 3;
    private static final byte FRACT_Y = 4;
    private static final byte FRACT_Z = 5;
    private static final byte CARTN_X = 6;
    private static final byte CARTN_Y = 7;
    private static final byte CARTN_Z = 8;
    private static final byte OCCUPANCY = 9;
    private static final byte B_ISO = 10;
    private static final byte COMP_ID = 11;
    private static final byte ASYM_ID = 12;
    private static final byte SEQ_ID = 13;
    private static final byte INS_CODE = 14;
    private static final byte ALT_ID = 15;
    private static final byte GROUP_PDB = 16;
    private static final byte MODEL_NO = 17;
    private static final byte DUMMY_ATOM = 18;
    private static final byte DISORDER_GROUP = 19;
    private static final byte ANISO_LABEL = 20;
    private static final byte ANISO_MMCIF_ID = 21;
    private static final byte ANISO_U11 = 22;
    private static final byte ANISO_U22 = 23;
    private static final byte ANISO_U33 = 24;
    private static final byte ANISO_U12 = 25;
    private static final byte ANISO_U13 = 26;
    private static final byte ANISO_U23 = 27;
    private static final byte ANISO_MMCIF_U11 = 28;
    private static final byte ANISO_MMCIF_U22 = 29;
    private static final byte ANISO_MMCIF_U33 = 30;
    private static final byte ANISO_MMCIF_U12 = 31;
    private static final byte ANISO_MMCIF_U13 = 32;
    private static final byte ANISO_MMCIF_U23 = 33;
    private static final byte U_ISO_OR_EQUIV = 34;
    private static final byte ANISO_B11 = 35;
    private static final byte ANISO_B22 = 36;
    private static final byte ANISO_B33 = 37;
    private static final byte ANISO_B12 = 38;
    private static final byte ANISO_B13 = 39;
    private static final byte ANISO_B23 = 40;
    private static final byte ANISO_Beta_11 = 41;
    private static final byte ANISO_Beta_22 = 42;
    private static final byte ANISO_Beta_33 = 43;
    private static final byte ANISO_Beta_12 = 44;
    private static final byte ANISO_Beta_13 = 45;
    private static final byte ANISO_Beta_23 = 46;
    private static final byte ADP_TYPE = 47;
    private static final String[] atomFields = new String[]{"_atom_site_type_symbol", "_atom_site_label", "_atom_site_auth_atom_id", "_atom_site_fract_x", "_atom_site_fract_y", "_atom_site_fract_z", "_atom_site_Cartn_x", "_atom_site_Cartn_y", "_atom_site_Cartn_z", "_atom_site_occupancy", "_atom_site_b_iso_or_equiv", "_atom_site_auth_comp_id", "_atom_site_auth_asym_id", "_atom_site_auth_seq_id", "_atom_site_pdbx_PDB_ins_code", "_atom_site_label_alt_id", "_atom_site_group_PDB", "_atom_site_pdbx_PDB_model_num", "_atom_site_calc_flag", "_atom_site_disorder_group", "_atom_site_aniso_label", "_atom_site_anisotrop_id", "_atom_site_aniso_U_11", "_atom_site_aniso_U_22", "_atom_site_aniso_U_33", "_atom_site_aniso_U_12", "_atom_site_aniso_U_13", "_atom_site_aniso_U_23", "_atom_site_anisotrop_U[1][1]", "_atom_site_anisotrop_U[2][2]", "_atom_site_anisotrop_U[3][3]", "_atom_site_anisotrop_U[1][2]", "_atom_site_anisotrop_U[1][3]", "_atom_site_anisotrop_U[2][3]", "_atom_site_U_iso_or_equiv", "_atom_site_aniso_B_11", "_atom_site_aniso_B_22", "_atom_site_aniso_B_33", "_atom_site_aniso_B_12", "_atom_site_aniso_B_13", "_atom_site_aniso_B_23", "_atom_site_aniso_Beta_11", "_atom_site_aniso_Beta_22", "_atom_site_aniso_Beta_33", "_atom_site_aniso_Beta_12", "_atom_site_aniso_Beta_13", "_atom_site_aniso_Beta_23", "_atom_site_adp_type"};
    private static final byte GEOM_BOND_ATOM_SITE_LABEL_1 = 0;
    private static final byte GEOM_BOND_ATOM_SITE_LABEL_2 = 1;
    private static final byte GEOM_BOND_SITE_SYMMETRY_2 = 2;
    private static final String[] geomBondFields = new String[]{"_geom_bond_atom_site_label_1", "_geom_bond_atom_site_label_2"};
    private static final byte NONPOLY_ENTITY_ID = 0;
    private static final byte NONPOLY_NAME = 1;
    private static final byte NONPOLY_COMP_ID = 2;
    private static final String[] nonpolyFields = new String[]{"_pdbx_entity_nonpoly_entity_id", "_pdbx_entity_nonpoly_name", "_pdbx_entity_nonpoly_comp_id"};
    private String[] hetatmData;
    private static final byte CHEM_COMP_ID = 0;
    private static final byte CHEM_COMP_NAME = 1;
    private static final String[] chemCompFields = new String[]{"_chem_comp_id", "_chem_comp_name"};
    private static final byte CONF_TYPE_ID = 0;
    private static final byte BEG_ASYM_ID = 1;
    private static final byte BEG_SEQ_ID = 2;
    private static final byte BEG_INS_CODE = 3;
    private static final byte END_ASYM_ID = 4;
    private static final byte END_SEQ_ID = 5;
    private static final byte END_INS_CODE = 6;
    private static final byte STRUCT_ID = 7;
    private static final byte SERIAL_NO = 8;
    private static final byte HELIX_CLASS = 9;
    private static final String[] structConfFields = new String[]{"_struct_conf_conf_type_id", "_struct_conf_beg_auth_asym_id", "_struct_conf_beg_auth_seq_id", "_struct_conf_pdbx_beg_PDB_ins_code", "_struct_conf_end_auth_asym_id", "_struct_conf_end_auth_seq_id", "_struct_conf_pdbx_end_PDB_ins_code", "_struct_conf_id", "_struct_conf_pdbx_PDB_helix_id", "_struct_conf_pdbx_PDB_helix_class"};
    private static final byte SHEET_ID = 0;
    private static final byte STRAND_ID = 7;
    private static final String[] structSheetRangeFields = new String[]{"_struct_sheet_range_sheet_id", "_struct_sheet_range_beg_auth_asym_id", "_struct_sheet_range_beg_auth_seq_id", "_struct_sheet_range_pdbx_beg_PDB_ins_code", "_struct_sheet_range_end_auth_asym_id", "_struct_sheet_range_end_auth_seq_id", "_struct_sheet_range_pdbx_end_PDB_ins_code", "_struct_sheet_range_id"};
    private static final byte SITE_ID = 0;
    private static final byte SITE_COMP_ID = 1;
    private static final byte SITE_ASYM_ID = 2;
    private static final byte SITE_SEQ_ID = 3;
    private static final byte SITE_INS_CODE = 4;
    private static final String[] structSiteRangeFields = new String[]{"_struct_site_gen_site_id", "_struct_site_gen_auth_comp_id", "_struct_site_gen_auth_asym_id", "_struct_site_gen_auth_seq_id", "_struct_site_gen_label_alt_id"};
    private Hashtable htSites;
    private static final byte SYMOP_XYZ = 0;
    private static final byte SYM_EQUIV_XYZ = 1;
    private static final String[] symmetryOperationsFields = new String[]{"_space_group_symop_operation_xyz", "_symmetry_equiv_pos_as_xyz"};
    String field;
    private char firstChar;
    private int[] propertyOf = new int[100];
    private byte[] fieldOf = new byte[atomFields.length];
    private int propertyCount;

    public void initializeReader() throws Exception {
        int n = 0;
        this.line = "";
        boolean bl = false;
        while ((this.key = this.tokenizer.peekToken()) != null) {
            if (this.key.startsWith("data_")) {
                if (this.iHaveDesiredModel) break;
                boolean bl2 = bl = !this.doGetModel(++this.modelNumber);
                if (bl) {
                    this.tokenizer.getTokenPeeked();
                    continue;
                }
                this.chemicalName = "";
                this.thisStructuralFormula = "";
                this.thisFormula = "";
                if (n == this.atomSetCollection.getAtomCount()) {
                    this.atomSetCollection.removeAtomSet();
                } else {
                    this.applySymmetryAndSetTrajectory();
                }
                this.processDataParameter();
                this.iHaveDesiredModel = this.isLastModel(this.modelNumber);
                n = this.atomSetCollection.getAtomCount();
                continue;
            }
            if (this.key.startsWith("loop_")) {
                if (bl) {
                    this.tokenizer.getTokenPeeked();
                    this.skipLoop();
                    continue;
                }
                this.processLoopBlock();
                continue;
            }
            if (this.key.indexOf("_") != 0) {
                Logger.warn("CIF ERROR ? should be an underscore: " + this.key);
                this.tokenizer.getTokenPeeked();
            } else if (!this.getData()) continue;
            if (bl) continue;
            this.key = this.key.replace('.', '_');
            if (this.key.startsWith("_chemical_name")) {
                this.processChemicalInfo("name");
                continue;
            }
            if (this.key.startsWith("_chemical_formula_structural")) {
                this.processChemicalInfo("structuralFormula");
                continue;
            }
            if (this.key.startsWith("_chemical_formula_sum")) {
                this.processChemicalInfo("formula");
                continue;
            }
            if (this.key.startsWith("_cell_")) {
                this.processCellParameter();
                continue;
            }
            if (this.key.startsWith("_symmetry_space_group_name_H-M") || this.key.startsWith("_symmetry_space_group_name_Hall")) {
                this.processSymmetrySpaceGroupName();
                continue;
            }
            if (this.key.startsWith("_atom_sites_fract_tran")) {
                this.processUnitCellTransformMatrix();
                continue;
            }
            if (!this.key.startsWith("_pdbx_entity_nonpoly")) continue;
            this.processNonpolyData();
        }
        if (this.atomSetCollection.getAtomCount() == n) {
            this.atomSetCollection.removeAtomSet();
        } else {
            this.applySymmetryAndSetTrajectory();
        }
        if (this.htSites != null) {
            this.addSites(this.htSites);
        }
        this.atomSetCollection.setCollectionName("<collection of " + this.atomSetCollection.getAtomSetCount() + " models>");
        this.continuing = false;
    }

    protected void finalizeReader() throws Exception {
        super.finalizeReader();
        String string = this.tokenizer.getFileHeader();
        if (string.length() > 0) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("fileHeader", string);
        }
    }

    public void applySymmetryAndSetTrajectory() throws Exception {
        this.atomSetCollection.setCheckSpecial(!this.isPDB);
        super.applySymmetryAndSetTrajectory();
    }

    private void processDataParameter() {
        this.tokenizer.getTokenPeeked();
        String string = this.thisDataSetName = this.key.length() < 6 ? "" : this.key.substring(5);
        if (this.thisDataSetName.length() > 0) {
            if (this.atomSetCollection.getCurrentAtomSetIndex() >= 0) {
                this.atomSetCollection.newAtomSet();
            } else {
                this.atomSetCollection.setCollectionName(this.thisDataSetName);
            }
        }
        Logger.debug(this.key);
    }

    private void processChemicalInfo(String string) throws Exception {
        if (string.equals("name")) {
            this.chemicalName = this.data = this.tokenizer.fullTrim(this.data);
        } else if (string.equals("structuralFormula")) {
            this.thisStructuralFormula = this.data = this.tokenizer.fullTrim(this.data);
        } else if (string.equals("formula")) {
            this.thisFormula = this.data = this.tokenizer.fullTrim(this.data);
        }
        if (Logger.debugging) {
            Logger.debug(string + " = " + this.data);
        }
    }

    private void processSymmetrySpaceGroupName() throws Exception {
        this.setSpaceGroupName(this.data);
    }

    private void processCellParameter() throws Exception {
        int n = cellParamNames.length;
        while (--n >= 0) {
            if (!CifReader.isMatch(this.key, cellParamNames[n])) continue;
            this.setUnitCellItem(n, this.parseFloat(this.data));
            return;
        }
    }

    private void processUnitCellTransformMatrix() throws Exception {
        float f = this.parseFloat(this.data);
        if (Float.isNaN(f)) {
            return;
        }
        for (int i = 0; i < TransformFields.length; ++i) {
            if (this.key.indexOf(TransformFields[i]) < 0) continue;
            this.setUnitCellItem(6 + i, f);
            return;
        }
    }

    private boolean getData() throws Exception {
        this.key = this.tokenizer.getTokenPeeked();
        this.data = this.tokenizer.getNextToken();
        if (Logger.debugging) {
            Logger.debug(this.key + " " + this.data);
        }
        if (this.data == null) {
            Logger.warn("CIF ERROR ? end of file; data missing: " + this.key);
            return false;
        }
        return this.data.length() == 0 || this.data.charAt(0) != '\u0000';
    }

    private void processLoopBlock() throws Exception {
        this.tokenizer.getTokenPeeked();
        String string = this.tokenizer.peekToken();
        if (string == null) {
            return;
        }
        if (string.startsWith("_atom_site_") || string.startsWith("_atom_site.")) {
            if (!this.processAtomSiteLoopBlock()) {
                return;
            }
            this.atomSetCollection.setAtomSetName(this.thisDataSetName);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("chemicalName", this.chemicalName);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("structuralFormula", this.thisStructuralFormula);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("formula", this.thisFormula);
            return;
        }
        if (string.startsWith("_atom_type")) {
            this.processAtomTypeLoopBlock();
            return;
        }
        if (string.startsWith("_geom_bond")) {
            if (this.doApplySymmetry && !this.applySymmetryToBonds) {
                this.skipLoop();
            } else {
                this.processGeomBondLoopBlock();
            }
            return;
        }
        if (string.startsWith("_pdbx_entity_nonpoly")) {
            this.processNonpolyLoopBlock();
            return;
        }
        if (string.startsWith("_chem_comp")) {
            this.processChemCompLoopBlock();
            return;
        }
        if (string.startsWith("_struct_conf") && !string.startsWith("_struct_conf_type")) {
            this.processStructConfLoopBlock();
            return;
        }
        if (string.startsWith("_struct_sheet_range")) {
            this.processStructSheetRangeLoopBlock();
            return;
        }
        if (string.startsWith("_symmetry_equiv_pos") || string.startsWith("_space_group_symop")) {
            if (this.ignoreFileSymmetryOperators) {
                Logger.warn("ignoring file-based symmetry operators");
                this.skipLoop();
            } else {
                this.processSymmetryOperationsLoopBlock();
            }
            return;
        }
        if (string.startsWith("_struct_site")) {
            this.processStructSiteBlock();
            return;
        }
        this.skipLoop();
    }

    private void processAtomTypeLoopBlock() throws Exception {
        this.parseLoopParameters(atomTypeFields);
        int n = this.propertyCount;
        while (--n >= 0) {
            if (this.fieldOf[n] != -1) continue;
            this.skipLoop();
            return;
        }
        while (this.tokenizer.getData()) {
            String string = null;
            float f = Float.NaN;
            block7: for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case -1: {
                        continue block7;
                    }
                    case 0: {
                        string = this.field;
                        continue block7;
                    }
                    case 1: {
                        f = this.parseFloat(this.field);
                    }
                }
            }
            if (string == null || Float.isNaN(f)) continue;
            if (this.atomTypes == null) {
                this.atomTypes = new Hashtable();
            }
            this.atomTypes.put(string, new Float(f));
        }
    }

    boolean processAtomSiteLoopBlock() throws Exception {
        int n = -1;
        boolean bl = false;
        this.parseLoopParameters(atomFields);
        if (this.fieldOf[6] != -1) {
            this.setFractionalCoordinates(false);
            this.disableField(3);
            this.disableField(4);
            this.disableField(5);
        } else if (this.fieldOf[3] != -1) {
            this.setFractionalCoordinates(true);
            this.disableField(6);
            this.disableField(7);
            this.disableField(8);
        } else if (this.fieldOf[20] != -1) {
            bl = true;
        } else if (this.fieldOf[21] != -1) {
            bl = true;
        } else {
            this.skipLoop();
            return false;
        }
        int n2 = 0;
        while (this.tokenizer.getData()) {
            Atom atom = new Atom();
            block26: for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case -1: {
                        continue block26;
                    }
                    case 0: {
                        char c;
                        String string = this.field.length() < 2 ? this.field : (Atom.isValidElementSymbol(this.firstChar, c = Character.toLowerCase(this.field.charAt(1))) ? "" + this.firstChar + c : "" + this.firstChar);
                        atom.elementSymbol = string;
                        if (this.atomTypes == null || !this.atomTypes.containsKey(this.field)) continue block26;
                        float f = ((Float)this.atomTypes.get(this.field)).floatValue();
                        atom.formalCharge = (int)((double)f + (f < 0.0f ? -0.5 : 0.5));
                        if (!((double)Math.abs((float)atom.formalCharge - f) > 0.1) || !Logger.debugging) continue block26;
                        Logger.debug("CIF charge on " + this.field + " was " + f + "; rounded to " + atom.formalCharge);
                        continue block26;
                    }
                    case 1: 
                    case 2: {
                        atom.atomName = this.field;
                        continue block26;
                    }
                    case 3: 
                    case 6: {
                        atom.x = this.parseFloat(this.field);
                        continue block26;
                    }
                    case 4: 
                    case 7: {
                        atom.y = this.parseFloat(this.field);
                        continue block26;
                    }
                    case 5: 
                    case 8: {
                        atom.z = this.parseFloat(this.field);
                        continue block26;
                    }
                    case 9: {
                        float f = this.parseFloat(this.field);
                        if (Float.isNaN(f)) continue block26;
                        atom.occupancy = (int)(f * 100.0f);
                        continue block26;
                    }
                    case 10: {
                        atom.bfactor = this.parseFloat(this.field) * (this.isPDB ? 1.0f : 100.0f);
                        continue block26;
                    }
                    case 11: {
                        atom.group3 = this.field;
                        continue block26;
                    }
                    case 12: {
                        if (this.field.length() > 1) {
                            Logger.warn("Don't know how to deal with chains more than 1 char: " + this.field);
                        }
                        atom.chainID = this.firstChar;
                        continue block26;
                    }
                    case 13: {
                        atom.sequenceNumber = this.parseInt(this.field);
                        continue block26;
                    }
                    case 14: {
                        atom.insertionCode = this.firstChar;
                        continue block26;
                    }
                    case 15: {
                        atom.alternateLocationID = this.firstChar;
                        continue block26;
                    }
                    case 19: {
                        if (this.firstChar == '-' && this.field.length() > 1) {
                            atom.alternateLocationID = this.field.charAt(1);
                            atom.ignoreSymmetry = true;
                            continue block26;
                        }
                        atom.alternateLocationID = this.firstChar;
                        continue block26;
                    }
                    case 16: {
                        this.isPDB = true;
                        if (!"HETATM".equals(this.field)) continue block26;
                        atom.isHetero = true;
                        continue block26;
                    }
                    case 17: {
                        int n3 = this.parseInt(this.field);
                        if (n3 == n) continue block26;
                        this.atomSetCollection.newAtomSet();
                        n = n3;
                        continue block26;
                    }
                    case 18: {
                        if (!"dum".equals(this.field)) continue block26;
                        atom.x = Float.NaN;
                        continue block26;
                    }
                    case 47: {
                        int n4;
                        if (!this.field.equalsIgnoreCase("Uiso") || (n4 = this.fieldOf[34]) == -1) continue block26;
                        float[] fArray = this.atomSetCollection.getAnisoBorU(atom);
                        if (fArray == null) {
                            fArray = new float[8];
                            this.atomSetCollection.setAnisoBorU(atom, fArray, 8);
                        }
                        fArray[7] = this.parseFloat(this.tokenizer.loopData[n4]);
                        continue block26;
                    }
                    case 20: {
                        n2 = this.atomSetCollection.getAtomNameIndex(this.field);
                        if (n2 < 0) {
                            return false;
                        }
                        atom = this.atomSetCollection.getAtom(n2);
                        continue block26;
                    }
                    case 21: {
                        atom = this.atomSetCollection.getAtom(n2++);
                        continue block26;
                    }
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: {
                        float[] fArray = this.atomSetCollection.getAnisoBorU(atom);
                        if (fArray == null) {
                            fArray = new float[8];
                            this.atomSetCollection.setAnisoBorU(atom, fArray, 8);
                        }
                        int n4 = (this.propertyOf[i] - 22) % 6;
                        fArray[n4] = this.parseFloat(this.field);
                        continue block26;
                    }
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        float[] fArray = this.atomSetCollection.getAnisoBorU(atom);
                        if (fArray == null) {
                            fArray = new float[8];
                            this.atomSetCollection.setAnisoBorU(atom, fArray, 4);
                        }
                        int n5 = (this.propertyOf[i] - 35) % 6;
                        fArray[n5] = this.parseFloat(this.field);
                        continue block26;
                    }
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: {
                        float[] fArray = this.atomSetCollection.getAnisoBorU(atom);
                        if (fArray == null) {
                            fArray = new float[8];
                            this.atomSetCollection.setAnisoBorU(atom, fArray, 0);
                        }
                        int n6 = (this.propertyOf[i] - 41) % 6;
                        fArray[n6] = this.parseFloat(this.field);
                    }
                }
            }
            if (Float.isNaN(atom.x) || Float.isNaN(atom.y) || Float.isNaN(atom.z)) {
                Logger.warn("atom " + atom.atomName + " has invalid/unknown coordinates");
                continue;
            }
            if (bl || !this.filterAtom(atom)) continue;
            this.setAtomCoord(atom);
            this.atomSetCollection.addAtomWithMappedName(atom);
            if (!atom.isHetero || this.htHetero == null) continue;
            this.atomSetCollection.setAtomSetAuxiliaryInfo("hetNames", this.htHetero);
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("hetNames", this.htHetero);
            this.htHetero = null;
        }
        if (this.isPDB) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("isPDB", Boolean.TRUE);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("isPDB", Boolean.TRUE);
        }
        this.atomSetCollection.setAtomSetAuxiliaryInfo("isCIF", Boolean.TRUE);
        return true;
    }

    private void processGeomBondLoopBlock() throws Exception {
        this.parseLoopParameters(geomBondFields);
        int n = this.propertyCount;
        while (--n >= 0) {
            if (this.fieldOf[n] != -1) continue;
            Logger.warn("?que? missing _geom_bond property:" + n);
            this.skipLoop();
            return;
        }
        while (this.tokenizer.getData()) {
            n = -1;
            int n2 = -1;
            block7: for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case -1: {
                        continue block7;
                    }
                    case 0: {
                        n = this.atomSetCollection.getAtomNameIndex(this.field);
                        continue block7;
                    }
                    case 1: {
                        n2 = this.atomSetCollection.getAtomNameIndex(this.field);
                        continue block7;
                    }
                }
            }
            if (n < 0 || n2 < 0) continue;
            Bond bond = new Bond();
            bond.atomIndex1 = n;
            bond.atomIndex2 = n2;
            this.atomSetCollection.addBond(bond);
        }
    }

    private void processNonpolyData() {
        if (this.hetatmData == null) {
            this.hetatmData = new String[3];
        }
        int n = nonpolyFields.length;
        while (--n >= 0) {
            if (!CifReader.isMatch(this.key, nonpolyFields[n])) continue;
            this.hetatmData[n] = this.data;
            break;
        }
        if (this.hetatmData[1] == null || this.hetatmData[2] == null) {
            return;
        }
        this.addHetero(this.hetatmData[2], this.hetatmData[1]);
        this.hetatmData = null;
    }

    private void processChemCompLoopBlock() throws Exception {
        this.parseLoopParameters(chemCompFields);
        while (this.tokenizer.getData()) {
            String string = null;
            String string2 = null;
            block6: for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case -1: {
                        continue block6;
                    }
                    case 0: {
                        string = this.field;
                        continue block6;
                    }
                    case 1: {
                        string2 = this.field;
                    }
                }
            }
            if (string == null || string2 == null) {
                return;
            }
            this.addHetero(string, string2);
        }
    }

    private void processNonpolyLoopBlock() throws Exception {
        this.parseLoopParameters(nonpolyFields);
        while (this.tokenizer.getData()) {
            String string = null;
            String string2 = null;
            block6: for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case -1: 
                    case 0: {
                        continue block6;
                    }
                    case 2: {
                        string = this.field;
                        continue block6;
                    }
                    case 1: {
                        string2 = this.field;
                    }
                }
            }
            if (string == null || string2 == null) {
                return;
            }
            this.addHetero(string, string2);
        }
    }

    private void addHetero(String string, String string2) {
        if (!JmolAdapter.isHetero(string)) {
            return;
        }
        if (this.htHetero == null) {
            this.htHetero = new Hashtable();
        }
        this.htHetero.put(string, string2);
        if (Logger.debugging) {
            Logger.debug("hetero: " + string + " = " + string2);
        }
    }

    private void processStructConfLoopBlock() throws Exception {
        this.parseLoopParameters(structConfFields);
        int n = this.propertyCount;
        while (--n >= 0) {
            if (this.fieldOf[n] != -1) continue;
            Logger.warn("?que? missing _struct_conf property:" + n);
            this.skipLoop();
            return;
        }
        while (this.tokenizer.getData()) {
            Structure structure = new Structure(3);
            block15: for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case -1: {
                        continue block15;
                    }
                    case 0: {
                        if (this.field.startsWith("TURN")) {
                            structure.substructureType = 1;
                            structure.structureType = 1;
                            continue block15;
                        }
                        if (this.field.startsWith("HELX")) continue block15;
                        structure.substructureType = 0;
                        structure.structureType = 0;
                        continue block15;
                    }
                    case 1: {
                        structure.startChainID = this.firstChar;
                        continue block15;
                    }
                    case 2: {
                        structure.startSequenceNumber = this.parseInt(this.field);
                        continue block15;
                    }
                    case 3: {
                        structure.startInsertionCode = this.firstChar;
                        continue block15;
                    }
                    case 4: {
                        structure.endChainID = this.firstChar;
                        continue block15;
                    }
                    case 5: {
                        structure.endSequenceNumber = this.parseInt(this.field);
                        continue block15;
                    }
                    case 9: {
                        structure.substructureType = Structure.getHelixType(this.parseInt(this.field));
                        continue block15;
                    }
                    case 6: {
                        structure.endInsertionCode = this.firstChar;
                        continue block15;
                    }
                    case 7: {
                        structure.structureID = this.field;
                        continue block15;
                    }
                    case 8: {
                        structure.serialID = this.parseInt(this.field);
                    }
                }
            }
            this.atomSetCollection.addStructure(structure);
        }
    }

    private void processStructSheetRangeLoopBlock() throws Exception {
        this.parseLoopParameters(structSheetRangeFields);
        int n = this.propertyCount;
        while (--n >= 0) {
            if (this.fieldOf[n] != -1) continue;
            Logger.warn("?que? missing _struct_conf property:" + n);
            this.skipLoop();
            return;
        }
        while (this.tokenizer.getData()) {
            Structure structure = new Structure(2);
            block12: for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case 1: {
                        structure.startChainID = this.firstChar;
                        continue block12;
                    }
                    case 2: {
                        structure.startSequenceNumber = this.parseInt(this.field);
                        continue block12;
                    }
                    case 3: {
                        structure.startInsertionCode = this.firstChar;
                        continue block12;
                    }
                    case 4: {
                        structure.endChainID = this.firstChar;
                        continue block12;
                    }
                    case 5: {
                        structure.endSequenceNumber = this.parseInt(this.field);
                        continue block12;
                    }
                    case 6: {
                        structure.endInsertionCode = this.firstChar;
                        continue block12;
                    }
                    case 0: {
                        structure.strandCount = 1;
                        structure.structureID = this.field;
                        continue block12;
                    }
                    case 7: {
                        structure.serialID = this.parseInt(this.field);
                    }
                }
            }
            this.atomSetCollection.addStructure(structure);
        }
    }

    private void processStructSiteBlock() throws Exception {
        this.parseLoopParameters(structSiteRangeFields);
        int n = 3;
        while (--n >= 0) {
            if (this.fieldOf[n] != -1) continue;
            Logger.warn("?que? missing _struct_site property:" + n);
            this.skipLoop();
            return;
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        Hashtable<String, String> hashtable = null;
        this.htSites = new Hashtable();
        while (this.tokenizer.getData()) {
            for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case 0: {
                        if (string6 != "") {
                            String string7 = (String)hashtable.get("groups");
                            string7 = string7 + (string7.length() == 0 ? "" : ",") + string6;
                            string6 = "";
                            hashtable.put("groups", string7);
                        }
                        if ((hashtable = (Hashtable)this.htSites.get(string = this.field)) == null) {
                            hashtable = new Hashtable<String, String>();
                            hashtable.put("groups", "");
                            this.htSites.put(string, hashtable);
                        }
                        string2 = "";
                        string3 = "";
                        string4 = "";
                        string5 = "";
                        break;
                    }
                    case 1: {
                        string5 = this.field;
                        break;
                    }
                    case 2: {
                        string4 = this.field;
                        break;
                    }
                    case 3: {
                        string2 = this.field;
                        break;
                    }
                    case 4: {
                        string3 = this.field;
                    }
                }
                if (string2 == "" || string5 == "") continue;
                string6 = "[" + string5 + "]" + string2 + (string3.length() > 0 ? "^" + string3 : "") + (string4.length() > 0 ? ":" + string4 : "");
            }
        }
        if (string6 != "") {
            String string8 = (String)hashtable.get("groups");
            string8 = string8 + (string8.length() == 0 ? "" : ",") + string6;
            string6 = "";
            hashtable.put("groups", string8);
        }
    }

    private void processSymmetryOperationsLoopBlock() throws Exception {
        this.parseLoopParameters(symmetryOperationsFields);
        int n = 0;
        int n2 = this.propertyCount;
        while (--n2 >= 0) {
            if (this.fieldOf[n2] == -1) continue;
            ++n;
        }
        if (n != 1) {
            Logger.warn("?que? _symmetry_equiv or _space_group_symop property not found");
            this.skipLoop();
            return;
        }
        while (this.tokenizer.getData()) {
            for (n2 = 0; n2 < this.tokenizer.fieldCount; ++n2) {
                switch (this.fieldProperty(n2)) {
                    case 0: 
                    case 1: {
                        this.setSymmetryOperator(this.field);
                    }
                }
            }
        }
    }

    private int fieldProperty(int n) {
        this.field = this.tokenizer.loopData[n];
        return this.field.length() > 0 && (this.firstChar = this.field.charAt(0)) != '\u0000' ? this.propertyOf[n] : -1;
    }

    private void parseLoopParameters(String[] stringArray) throws Exception {
        this.tokenizer.fieldCount = 0;
        int n = stringArray.length;
        while (--n >= 0) {
            this.fieldOf[n] = -1;
        }
        this.propertyCount = stringArray.length;
        while (true) {
            String string;
            if ((string = this.tokenizer.peekToken()) == null) {
                this.tokenizer.fieldCount = 0;
                break;
            }
            if (string.charAt(0) != '_') break;
            this.tokenizer.getTokenPeeked();
            this.propertyOf[this.tokenizer.fieldCount] = -1;
            int n2 = stringArray.length;
            while (--n2 >= 0) {
                if (!CifReader.isMatch(string, stringArray[n2])) continue;
                this.propertyOf[this.tokenizer.fieldCount] = n2;
                this.fieldOf[n2] = (byte)this.tokenizer.fieldCount;
                break;
            }
            ++this.tokenizer.fieldCount;
        }
        if (this.tokenizer.fieldCount > 0) {
            this.tokenizer.loopData = new String[this.tokenizer.fieldCount];
        }
    }

    public String readLine() throws Exception {
        super.readLine();
        if (this.line.indexOf("#jmolscript:") >= 0) {
            this.checkLineForScript();
        }
        return this.line;
    }

    private void disableField(int n) {
        byte by = this.fieldOf[n];
        if (by != -1) {
            this.propertyOf[by] = -1;
        }
    }

    private void skipLoop() throws Exception {
        String string;
        while ((string = this.tokenizer.peekToken()) != null && string.charAt(0) == '_') {
            string = this.tokenizer.getTokenPeeked();
        }
        while (this.tokenizer.getNextDataToken() != null) {
        }
    }

    private static boolean isMatch(String string, String string2) {
        int n = string.length();
        if (string2.length() != n) {
            return false;
        }
        int n2 = n;
        while (--n2 >= 0) {
            char c;
            char c2 = string.charAt(n2);
            if (c2 == (c = string2.charAt(n2)) || (c2 == '_' || c2 == '.') && (c == '_' || c == '.')) continue;
            if (c2 <= 'Z' && c2 >= 'A') {
                c2 = (char)(c2 + 32);
            } else if (c <= 'Z' && c >= 'A') {
                c = (char)(c + 32);
            }
            if (c2 == c) continue;
            return false;
        }
        return true;
    }
}

