/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.minimize.Minimizer;
import org.jmol.minimize.forcefield.CalculationsUFF;
import org.jmol.minimize.forcefield.FFParam;
import org.jmol.minimize.forcefield.ForceField;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

public class ForceFieldUFF
extends ForceField {
    public void setModel(Minimizer minimizer) {
        super.setModel(minimizer);
        this.calc = new CalculationsUFF(this, minimizer.minAtoms, minimizer.minBonds, minimizer.angles, minimizer.torsions, minimizer.partialCharges, minimizer.constraints);
    }

    protected Hashtable getFFParameters() {
        Hashtable<String, FFParam> hashtable = new Hashtable<String, FFParam>();
        URL uRL = null;
        String string = "UFF.txt";
        BufferedReader bufferedReader = null;
        try {
            String string2;
            uRL = this.getClass().getResource(string);
            if (uRL == null) {
                System.err.println("Couldn't find file: " + string);
                throw new NullPointerException();
            }
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)uRL.getContent()));
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray = Parser.getTokens((String)string2);
                if (stringArray.length < 13) continue;
                if (Logger.debugging) {
                    Logger.info((String)string2);
                }
                if (!string2.substring(0, 5).equals("param")) continue;
                FFParam fFParam = new FFParam();
                hashtable.put(stringArray[1], fFParam);
                fFParam.dVal = new double[11];
                fFParam.sVal = new String[1];
                fFParam.sVal[0] = stringArray[1];
                fFParam.dVal[0] = Parser.parseFloat((String)stringArray[2]);
                fFParam.dVal[1] = (double)Parser.parseFloat((String)stringArray[3]) * (Math.PI / 180);
                fFParam.dVal[2] = Parser.parseFloat((String)stringArray[4]);
                fFParam.dVal[3] = Parser.parseFloat((String)stringArray[5]);
                fFParam.dVal[4] = Parser.parseFloat((String)stringArray[6]);
                fFParam.dVal[5] = Parser.parseFloat((String)stringArray[7]);
                fFParam.dVal[6] = Parser.parseFloat((String)stringArray[8]);
                fFParam.dVal[7] = Parser.parseFloat((String)stringArray[9]);
                fFParam.dVal[8] = Parser.parseFloat((String)stringArray[10]);
                fFParam.dVal[9] = Parser.parseFloat((String)stringArray[11]);
                fFParam.dVal[10] = Parser.parseFloat((String)stringArray[12]);
                fFParam.iVal = new int[1];
                int n = stringArray[1].length() > 2 ? (int)stringArray[1].charAt(2) : 49;
                switch (n) {
                    case 82: {
                        n = 50;
                        break;
                    }
                    default: {
                        n = 49;
                    }
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                }
                fFParam.iVal[0] = n - 48;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception.getMessage() + " in getResource " + string);
            try {
                bufferedReader.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return null;
        }
        Logger.info((String)(hashtable.size() + " atom types read from " + string));
        return hashtable;
    }

    public Vector getAtomTypes() {
        Vector<String[]> vector = new Vector<String[]>();
        URL uRL = null;
        String string = "UFF.txt";
        try {
            String string2;
            uRL = this.getClass().getResource(string);
            if (uRL == null) {
                System.err.println("Couldn't find file: " + string);
                throw new NullPointerException();
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)uRL.getContent()));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.length() <= 4 || !string2.substring(0, 4).equals("atom")) continue;
                String[] stringArray = Parser.getTokens((String)string2);
                String[] stringArray2 = new String[]{stringArray[1], stringArray[2]};
                vector.addElement(stringArray2);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception.getMessage() + " in getResource " + string);
        }
        Logger.info((String)(vector.size() + " force field parameters read"));
        return vector.size() > 0 ? vector : null;
    }
}

