/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.multitouch.sparshui;

import com.sparshui.common.Location;
import com.sparshui.common.messages.events.DragEvent;
import com.sparshui.common.messages.events.RotateEvent;
import com.sparshui.common.messages.events.ZoomEvent;
import com.sparshui.gestures.Gesture;
import com.sparshui.server.TouchPoint;
import java.util.Vector;
import javax.vecmath.Vector3f;
import org.jmol.util.Logger;

public class TwoPointGesture
implements Gesture {
    private int _myType = 9;
    protected Location _offset = null;
    protected Location _offsetCentroid = null;
    private Vector _traces1 = new Vector();
    private Vector _traces2 = new Vector();
    private int _id1 = -1;
    private int _id2 = -1;
    private int _nTraces = 0;
    private float _scale;
    private float _rotation;
    private long time;

    public String getName() {
        return "TwoPointGesture";
    }

    public int getGestureType() {
        return this._myType;
    }

    public Vector processChange(Vector vector, TouchPoint touchPoint) {
        return this.processChangeSync(vector, touchPoint);
    }

    private synchronized Vector processChangeSync(Vector vector, TouchPoint touchPoint) {
        Vector vector2 = null;
        this.time = touchPoint.getTime();
        switch (touchPoint.getState()) {
            case 0: {
                vector2 = this.processBirth(touchPoint);
                break;
            }
            case 2: {
                vector2 = this.processMove(touchPoint);
                break;
            }
            case 1: {
                vector2 = this.processDeath(touchPoint);
            }
        }
        return vector2 != null ? vector2 : new Vector();
    }

    protected Vector processBirth(TouchPoint touchPoint) {
        Location location = touchPoint.getLocation();
        int n = touchPoint.getID();
        switch (this._nTraces) {
            case 0: {
                this._traces1.clear();
                this._traces1.add(Location.pixelLocation((Location)location));
                this._id1 = n;
                this._nTraces = 1;
                break;
            }
            case 1: {
                this._traces2.clear();
                this._traces2.add(Location.pixelLocation((Location)location));
                this._id2 = n;
                Object e = this._traces1.lastElement();
                this._traces1.clear();
                this._traces1.add(e);
                this._nTraces = 2;
                break;
            }
            default: {
                Logger.error("TwoPointGesture birth ignored!");
            }
        }
        return null;
    }

    protected Vector processDeath(TouchPoint touchPoint) {
        int n = touchPoint.getID();
        switch (this._nTraces) {
            case 0: {
                Logger.error("TwoPointGesture death -- no traces! " + n);
                break;
            }
            case 1: {
                this._nTraces = 0;
                break;
            }
            case 2: {
                if (n == this._id1) {
                    this._id1 = this._id2;
                    Vector vector = this._traces1;
                    this._traces1 = this._traces2;
                    this._traces2 = vector;
                    this._traces2.clear();
                    this._id2 = -1;
                    this._nTraces = 1;
                    break;
                }
                if (n == this._id2) {
                    this._traces2.clear();
                    this._id2 = -1;
                    this._nTraces = 1;
                    break;
                }
                this._nTraces = 0;
            }
        }
        if (this._nTraces == 0) {
            this._traces1.clear();
            this._traces2.clear();
            this._id2 = -1;
            this._id1 = -1;
        }
        this._offsetCentroid = null;
        this._myType = 9;
        return null;
    }

    protected Vector processMove(TouchPoint touchPoint) {
        Vector<ZoomEvent> vector = new Vector<ZoomEvent>();
        if (!this.updateLocations(touchPoint)) {
            return vector;
        }
        if (this._myType == 9) {
            this.checkType();
        }
        Location location = Location.screenLocation((Location)this._offsetCentroid);
        if (this._myType == 9 || !this.updateParameters()) {
            return vector;
        }
        Location location2 = Location.screenLocation((Location)this._offsetCentroid);
        ZoomEvent zoomEvent = null;
        switch (this._myType) {
            case 5: {
                zoomEvent = new ZoomEvent(this._scale, location2, this.time);
                break;
            }
            case 2: {
                zoomEvent = new RotateEvent(this._rotation, location2, this.time);
                break;
            }
            case 1: {
                if (location == null) break;
                Vector3f vector3f = location.getVector(location2);
                zoomEvent = new DragEvent(vector3f.x, vector3f.y, 2, this.time);
            }
        }
        if (zoomEvent != null) {
            vector.add(zoomEvent);
        }
        return vector;
    }

    private boolean updateLocations(TouchPoint touchPoint) {
        Location location = Location.pixelLocation((Location)touchPoint.getLocation());
        int n = touchPoint.getID();
        if (n == this._id1) {
            if (this._traces1.size() > 2) {
                while (this._traces1.size() > 2) {
                    this._traces1.removeElementAt(0);
                }
            }
            this._traces1.add(location);
        } else if (n == this._id2) {
            if (this._traces2.size() > 2) {
                while (this._traces2.size() > 2) {
                    this._traces2.removeElementAt(0);
                }
            }
            this._traces2.add(location);
        } else {
            Logger.error("TwoPointGesture updateLocation error: no trace with id " + n);
            return false;
        }
        return this._nTraces == 2 && this._traces1.size() == 3 && this._traces2.size() == 3;
    }

    private void checkType() {
        Location location = (Location)this._traces1.firstElement();
        Location location2 = (Location)this._traces1.lastElement();
        Vector3f vector3f = location.getVector(location2);
        float f = vector3f.length();
        Location location3 = (Location)this._traces2.firstElement();
        Location location4 = (Location)this._traces2.lastElement();
        Vector3f vector3f2 = location3.getVector(location4);
        float f2 = vector3f2.length();
        if (f < 3.0f || f2 < 3.0f) {
            return;
        }
        vector3f.normalize();
        vector3f2.normalize();
        float f3 = vector3f.dot(vector3f2);
        if ((double)f3 > 0.8) {
            this._myType = 1;
        } else if ((double)f3 < -0.8) {
            this._myType = 5;
        }
    }

    private boolean updateParameters() {
        Location location = (Location)this._traces1.firstElement();
        Location location2 = (Location)this._traces2.firstElement();
        Location location3 = (Location)this._traces1.lastElement();
        Location location4 = (Location)this._traces2.lastElement();
        float f = location.getDistance(location3);
        float f2 = location2.getDistance(location4);
        float f3 = location3.getDistance(location4);
        if (f < 2.0f && f2 < 2.0f) {
            return false;
        }
        Vector3f vector3f = location.getVector(location2);
        float f4 = vector3f.length();
        vector3f.normalize();
        switch (this._myType) {
            case 2: {
                Vector3f vector3f2;
                Vector3f vector3f3;
                this._offsetCentroid = Location.getCenter((Location)location, (Location)location2);
                if (f2 < 2.0f) {
                    vector3f3 = location2.getVector(location);
                    vector3f2 = location2.getVector(location3);
                } else {
                    vector3f3 = location.getVector(location2);
                    vector3f2 = location.getVector(location4);
                }
                vector3f3.cross(vector3f3, vector3f2);
                this._rotation = vector3f3.z < 0.0f ? 1 : -1;
                return true;
            }
            case 5: {
                if (Math.abs(f3 - f4) < 2.0f) {
                    return false;
                }
                this._scale = f3 < f4 ? -1 : 1;
                this._offsetCentroid = Location.getCentroid((Location)location, (Location)location2, (float)(f / (f + f2)));
                return true;
            }
            case 1: {
                this._offsetCentroid = Location.getCenter((Location)location3, (Location)location4);
                return true;
            }
        }
        return false;
    }
}

