/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.Resolver;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolFileReaderInterface;
import org.jmol.util.CompoundDocument;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.util.ZipUtil;

public class SmarterJmolAdapter
extends JmolAdapter {
    public static final String PATH_KEY = ".PATH";
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");

    public SmarterJmolAdapter() {
        super("SmarterJmolAdapter");
    }

    public String getFileTypeName(Object object) {
        if (object instanceof AtomSetCollection) {
            return ((AtomSetCollection)object).getFileTypeName();
        }
        if (object instanceof BufferedReader) {
            return Resolver.getFileType((BufferedReader)object);
        }
        return null;
    }

    public Object getAtomSetCollectionReader(String string, String string2, BufferedReader bufferedReader, Hashtable hashtable) {
        try {
            Object object = Resolver.getAtomCollectionReader(string, string2, bufferedReader, hashtable, -1);
            if (object instanceof String) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            } else {
                ((AtomSetCollectionReader)object).setup(string, hashtable, bufferedReader);
            }
            return object;
        }
        catch (Throwable throwable) {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            bufferedReader = null;
            Logger.error(null, throwable);
            return "" + throwable;
        }
    }

    public Object getAtomSetCollection(Object object) {
        BufferedReader bufferedReader = null;
        try {
            AtomSetCollectionReader atomSetCollectionReader = (AtomSetCollectionReader)object;
            bufferedReader = atomSetCollectionReader.reader;
            Object object2 = atomSetCollectionReader.readData();
            if (!(object2 instanceof AtomSetCollection)) {
                return object2;
            }
            AtomSetCollection atomSetCollection = (AtomSetCollection)object2;
            if (atomSetCollection.errorMessage != null) {
                return atomSetCollection.errorMessage;
            }
            return atomSetCollection;
        }
        catch (Throwable throwable) {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            bufferedReader = null;
            Logger.error(null, throwable);
            return "" + throwable;
        }
    }

    public Object getAtomSetCollectionReaders(JmolFileReaderInterface jmolFileReaderInterface, String[] stringArray, String[] stringArray2, Hashtable hashtable, boolean bl) {
        int n = stringArray.length;
        AtomSetCollectionReader[] atomSetCollectionReaderArray = bl ? new AtomSetCollectionReader[n] : null;
        AtomSetCollection[] atomSetCollectionArray = bl ? null : new AtomSetCollection[n];
        for (int i = 0; i < n; ++i) {
            try {
                Object object = jmolFileReaderInterface.getBufferedReader(i);
                if (!(object instanceof BufferedReader)) {
                    return object;
                }
                Object object2 = Resolver.getAtomCollectionReader(stringArray[i], stringArray2 == null ? null : stringArray2[i], (BufferedReader)object, hashtable, i);
                if (!(object2 instanceof AtomSetCollectionReader)) {
                    return object2;
                }
                AtomSetCollectionReader atomSetCollectionReader = (AtomSetCollectionReader)object2;
                atomSetCollectionReader.setup(stringArray[i], hashtable, (BufferedReader)object);
                if (bl) {
                    atomSetCollectionReaderArray[i] = atomSetCollectionReader;
                    continue;
                }
                object2 = atomSetCollectionReader.readData();
                if (!(object2 instanceof AtomSetCollection)) {
                    return object2;
                }
                atomSetCollectionArray[i] = (AtomSetCollection)object2;
                if (atomSetCollectionArray[i].errorMessage == null) continue;
                return atomSetCollectionArray[i].errorMessage;
            }
            catch (Throwable throwable) {
                Logger.error(null, throwable);
                return "" + throwable;
            }
        }
        if (bl) {
            return atomSetCollectionReaderArray;
        }
        return this.getAtomSetCollectionFromSet(atomSetCollectionReaderArray, atomSetCollectionArray, hashtable);
    }

    public Object getAtomSetCollectionFromSet(Object object, Object object2, Hashtable hashtable) {
        AtomSetCollection[] atomSetCollectionArray;
        AtomSetCollectionReader[] atomSetCollectionReaderArray = (AtomSetCollectionReader[])object;
        AtomSetCollection[] atomSetCollectionArray2 = atomSetCollectionArray = object2 == null ? new AtomSetCollection[atomSetCollectionReaderArray.length] : (AtomSetCollection[])object2;
        if (object2 == null) {
            for (int i = 0; i < atomSetCollectionReaderArray.length; ++i) {
                try {
                    Object object3 = atomSetCollectionReaderArray[i].readData();
                    if (!(object3 instanceof AtomSetCollection)) {
                        return object3;
                    }
                    atomSetCollectionArray[i] = (AtomSetCollection)object3;
                    if (atomSetCollectionArray[i].errorMessage == null) continue;
                    return atomSetCollectionArray[i].errorMessage;
                }
                catch (Throwable throwable) {
                    Logger.error(null, throwable);
                    return "" + throwable;
                }
            }
        }
        if (hashtable.containsKey("trajectorySteps")) {
            atomSetCollectionArray[0].finalizeTrajectory((Vector)hashtable.get("trajectorySteps"));
            return atomSetCollectionArray[0];
        }
        AtomSetCollection atomSetCollection = new AtomSetCollection(atomSetCollectionArray);
        return atomSetCollection.errorMessage == null ? atomSetCollection : atomSetCollection.errorMessage;
    }

    public Object getAtomSetCollectionOrBufferedReaderFromZip(InputStream inputStream, String string, String[] stringArray, Hashtable hashtable, boolean bl) {
        return SmarterJmolAdapter.staticGetAtomSetCollectionOrBufferedReaderFromZip(inputStream, string, stringArray, hashtable, 1, bl);
    }

    private static Object staticGetAtomSetCollectionOrBufferedReaderFromZip(InputStream inputStream, String string, String[] stringArray, Hashtable hashtable, int n, boolean bl) {
        boolean bl2;
        boolean bl3;
        String string2;
        String string3;
        String[] stringArray2;
        boolean bl4 = n == 1;
        String[] stringArray3 = stringArray2 = hashtable == null ? null : (String[])hashtable.get("subFileList");
        if (stringArray2 == null) {
            stringArray2 = Resolver.checkSpecialInZip(stringArray);
        }
        String string4 = string3 = stringArray2 == null || n >= stringArray2.length ? null : stringArray2[n];
        if (string3 != null && (string3.startsWith("/") || string3.startsWith("\\"))) {
            string3 = string3.substring(1);
        }
        int n2 = 0;
        if (string3 == null && hashtable != null && hashtable.containsKey("modelNumber") && (n2 = ((Integer)hashtable.get("modelNumber")).intValue()) > 0 && bl4) {
            hashtable.remove("modelNumber");
        }
        String string5 = string2 = hashtable == null ? null : (String)hashtable.get("manifest");
        if (string2 == null) {
            string2 = stringArray.length > 0 ? stringArray[0] : "";
        }
        boolean bl5 = bl3 = string2.length() > 0;
        if (bl3) {
            if (Logger.debugging) {
                Logger.info("manifest for  " + string + ":\n" + string2);
            }
            string2 = '|' + string2.replace('\r', '|').replace('\n', '|') + '|';
        }
        boolean bl6 = string2.indexOf("IGNORE_ERRORS") >= 0;
        boolean bl7 = string2.indexOf("IGNORE_MANIFEST") >= 0;
        boolean bl8 = bl2 = string2.indexOf("EXCEPT_FILES") >= 0;
        if (bl7 || string3 != null) {
            bl3 = false;
        }
        Vector<Object> vector = new Vector<Object>();
        Hashtable<String[], Object> hashtable2 = bl3 ? new Hashtable<String[], Object>() : null;
        boolean bl9 = false;
        Object object = Resolver.checkSpecialData(inputStream, stringArray);
        if (object instanceof String) {
            return (String)object;
        }
        StringBuffer stringBuffer = object;
        try {
            Object object2;
            Object object3;
            ZipEntry zipEntry;
            if (stringBuffer != null) {
                BufferedReader bufferedReader = new BufferedReader(new StringReader(stringBuffer.toString()));
                if (bl) {
                    return bufferedReader;
                }
                object = Resolver.getAtomCollectionReader(string, null, bufferedReader, hashtable, -1);
                if (!(object instanceof AtomSetCollectionReader)) {
                    return object;
                }
                ((AtomSetCollectionReader)object).setup(string, hashtable, bufferedReader);
                object = ((AtomSetCollectionReader)object).readData();
                if (object instanceof AtomSetCollection) {
                    AtomSetCollection atomSetCollection = (AtomSetCollection)object;
                    if (atomSetCollection.errorMessage != null) {
                        if (bl6) {
                            return null;
                        }
                        return atomSetCollection.errorMessage;
                    }
                    return atomSetCollection;
                }
                if (bl6) {
                    return null;
                }
                return "unknown reader error";
            }
            ZipInputStream zipInputStream = ZipUtil.getStream(inputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null && (n2 <= 0 || vector.size() < n2)) {
                Object object4;
                String[] stringArray4;
                if (zipEntry.isDirectory()) continue;
                object3 = zipEntry.getName();
                if (string3 != null && !object3.equals(string3) || ZipUtil.isJmolManifest((String)object3) || bl3 && bl2 == string2.indexOf("|" + (String)object3 + "|") >= 0) continue;
                byte[] byArray = ZipUtil.getZipEntryAsBytes(zipInputStream);
                if (ZipUtil.isZipFile(byArray)) {
                    object2 = new BufferedInputStream(new ByteArrayInputStream(byArray));
                    stringArray4 = ZipUtil.getZipDirectoryAndClose((InputStream)object2, true);
                    object2 = new BufferedInputStream(new ByteArrayInputStream(byArray));
                    object4 = SmarterJmolAdapter.staticGetAtomSetCollectionOrBufferedReaderFromZip((InputStream)object2, string + "|" + (String)object3, stringArray4, hashtable, ++n, bl);
                    if (object4 instanceof String) {
                        if (bl6) continue;
                        return object4;
                    }
                    if (object4 instanceof AtomSetCollection || object4 instanceof Vector) {
                        if (bl3 && !bl2) {
                            hashtable2.put((String[])object3, object4);
                            continue;
                        }
                        vector.addElement(object4);
                        continue;
                    }
                    if (object4 instanceof BufferedReader) {
                        if (bl4) {
                            zipInputStream.close();
                        }
                        return object4;
                    }
                    if (bl6) continue;
                    zipInputStream.close();
                    return "unknown zip reader error";
                }
                object2 = CompoundDocument.isCompoundDocument(byArray) ? new CompoundDocument(new BufferedInputStream(new ByteArrayInputStream(byArray))).getAllData("Molecule").toString() : (ZipUtil.isGzip(byArray) ? ZipUtil.getGzippedBytesAsString(byArray) : new String(byArray));
                stringArray4 = new BufferedReader(new StringReader((String)object2));
                if (bl) {
                    if (bl4) {
                        zipInputStream.close();
                    }
                    return stringArray4;
                }
                object = Resolver.getAtomCollectionReader(string + "|" + zipEntry.getName(), null, (BufferedReader)stringArray4, hashtable, -1);
                if (object instanceof AtomSetCollectionReader) {
                    ((AtomSetCollectionReader)object).setup(string, hashtable, (BufferedReader)stringArray4);
                    object = ((AtomSetCollectionReader)object).readData();
                }
                if (!(object instanceof AtomSetCollection)) {
                    if (bl6) continue;
                    zipInputStream.close();
                    return "" + object;
                }
                if (bl3 && !bl2) {
                    hashtable2.put((String[])object3, object);
                } else {
                    vector.addElement(object);
                }
                object4 = (AtomSetCollection)object;
                if (((AtomSetCollection)object4).errorMessage == null || bl6) continue;
                zipInputStream.close();
                return ((AtomSetCollection)object4).errorMessage;
            }
            if (bl4) {
                zipInputStream.close();
            }
            if (bl3 && !bl2) {
                object3 = TextFormat.split(string2, '|');
                for (int i = 0; i < ((String[])object3).length; ++i) {
                    object2 = object3[i];
                    if (((String)object2).length() == 0 || ((String)object2).indexOf("#") == 0) continue;
                    if (hashtable2.containsKey(object2)) {
                        vector.add(hashtable2.get(object2));
                        continue;
                    }
                    if (!Logger.debugging) continue;
                    Logger.info("manifested file " + (String)object2 + " was not found in " + string);
                }
            }
            if (!bl4) {
                return vector;
            }
            object3 = new AtomSetCollection(vector);
            if (object3.errorMessage != null) {
                if (bl6) {
                    return null;
                }
                return object3.errorMessage;
            }
            if (bl9) {
                n2 = 1;
            }
            if (n2 > 0 && n2 <= vector.size()) {
                return vector.elementAt(n2 - 1);
            }
            return object3;
        }
        catch (Exception exception) {
            if (bl6) {
                return null;
            }
            Logger.error(null, exception);
            return "" + exception;
        }
        catch (Error error) {
            Logger.error(null, error);
            return "" + error;
        }
    }

    public Object getAtomSetCollectionFromDOM(Object object, Hashtable hashtable) {
        try {
            Object object2 = Resolver.DOMResolve(object, hashtable);
            if (!(object2 instanceof AtomSetCollectionReader)) {
                return object2;
            }
            AtomSetCollectionReader atomSetCollectionReader = (AtomSetCollectionReader)object2;
            atomSetCollectionReader.setup("DOM node", hashtable, null);
            object2 = atomSetCollectionReader.readData(object);
            if (!(object2 instanceof AtomSetCollection)) {
                return object2;
            }
            AtomSetCollection atomSetCollection = (AtomSetCollection)object2;
            if (atomSetCollection.errorMessage != null) {
                return atomSetCollection.errorMessage;
            }
            return atomSetCollection;
        }
        catch (Throwable throwable) {
            Logger.error(null, throwable);
            return "" + throwable;
        }
    }

    public String[] specialLoad(String string, String string2) {
        return Resolver.specialLoad(string, string2);
    }

    public void finish(Object object) {
        ((AtomSetCollection)object).finish();
    }

    public String getAtomSetCollectionName(Object object) {
        return ((AtomSetCollection)object).getCollectionName();
    }

    public Hashtable getAtomSetCollectionAuxiliaryInfo(Object object) {
        return ((AtomSetCollection)object).getAtomSetCollectionAuxiliaryInfo();
    }

    public int getAtomSetCount(Object object) {
        return ((AtomSetCollection)object).getAtomSetCount();
    }

    public int getAtomSetNumber(Object object, int n) {
        return ((AtomSetCollection)object).getAtomSetNumber(n);
    }

    public String getAtomSetName(Object object, int n) {
        return ((AtomSetCollection)object).getAtomSetName(n);
    }

    public Hashtable getAtomSetAuxiliaryInfo(Object object, int n) {
        return ((AtomSetCollection)object).getAtomSetAuxiliaryInfo(n);
    }

    public int getAtomCount(Object object) {
        return ((AtomSetCollection)object).getAtomCount();
    }

    public boolean coordinatesAreFractional(Object object) {
        return ((AtomSetCollection)object).coordinatesAreFractional;
    }

    public float[] getNotionalUnitcell(Object object) {
        return ((AtomSetCollection)object).notionalUnitCell;
    }

    public float[] getPdbScaleMatrix(Object object) {
        float[] fArray = ((AtomSetCollection)object).notionalUnitCell;
        if (fArray.length < 22) {
            return null;
        }
        float[] fArray2 = new float[16];
        for (int i = 0; i < 16; ++i) {
            fArray2[i] = fArray[6 + i];
        }
        return fArray2;
    }

    public float[] getPdbScaleTranslate(Object object) {
        float[] fArray = ((AtomSetCollection)object).notionalUnitCell;
        if (fArray.length < 22) {
            return null;
        }
        float[] fArray2 = new float[]{fArray[9], fArray[13], fArray[17]};
        return fArray2;
    }

    public JmolAdapter.AtomIterator getAtomIterator(Object object) {
        return new AtomIterator((AtomSetCollection)object);
    }

    public JmolAdapter.BondIterator getBondIterator(Object object) {
        return new BondIterator((AtomSetCollection)object);
    }

    public JmolAdapter.StructureIterator getStructureIterator(Object object) {
        return ((AtomSetCollection)object).getStructureCount() == 0 ? null : new StructureIterator((AtomSetCollection)object);
    }

    public class StructureIterator
    extends JmolAdapter.StructureIterator {
        private int structureCount;
        private Structure[] structures;
        private Structure structure;
        private int istructure;

        StructureIterator(AtomSetCollection atomSetCollection) {
            super(SmarterJmolAdapter.this);
            this.structureCount = atomSetCollection.getStructureCount();
            this.structures = atomSetCollection.getStructures();
            this.istructure = 0;
        }

        public boolean hasNext() {
            if (this.istructure == this.structureCount) {
                return false;
            }
            this.structure = this.structures[this.istructure++];
            return true;
        }

        public int getModelIndex() {
            return this.structure.modelIndex;
        }

        public int getStructureType() {
            return this.structure.structureType;
        }

        public int getSubstructureType() {
            return this.structure.substructureType;
        }

        public String getStructureID() {
            return this.structure.structureID;
        }

        public int getSerialID() {
            return this.structure.serialID;
        }

        public char getStartChainID() {
            return JmolAdapter.canonizeChainID(this.structure.startChainID);
        }

        public int getStartSequenceNumber() {
            return this.structure.startSequenceNumber;
        }

        public char getStartInsertionCode() {
            return JmolAdapter.canonizeInsertionCode(this.structure.startInsertionCode);
        }

        public char getEndChainID() {
            return JmolAdapter.canonizeChainID(this.structure.endChainID);
        }

        public int getEndSequenceNumber() {
            return this.structure.endSequenceNumber;
        }

        public char getEndInsertionCode() {
            return this.structure.endInsertionCode;
        }

        public int getStrandCount() {
            return this.structure.strandCount;
        }
    }

    class BondIterator
    extends JmolAdapter.BondIterator {
        private Bond[] bonds;
        private int ibond;
        private Bond bond;
        private int bondCount;

        BondIterator(AtomSetCollection atomSetCollection) {
            super(SmarterJmolAdapter.this);
            this.bonds = atomSetCollection.getBonds();
            this.bondCount = atomSetCollection.getBondCount();
            this.ibond = 0;
        }

        public boolean hasNext() {
            if (this.ibond == this.bondCount) {
                return false;
            }
            this.bond = this.bonds[this.ibond++];
            return true;
        }

        public Object getAtomUniqueID1() {
            return new Integer(this.bond.atomIndex1);
        }

        public Object getAtomUniqueID2() {
            return new Integer(this.bond.atomIndex2);
        }

        public int getEncodedOrder() {
            return this.bond.order;
        }
    }

    class AtomIterator
    extends JmolAdapter.AtomIterator {
        private int iatom;
        private Atom atom;
        private int atomCount;
        private Atom[] atoms;

        AtomIterator(AtomSetCollection atomSetCollection) {
            super(SmarterJmolAdapter.this);
            this.atomCount = atomSetCollection.getAtomCount();
            this.atoms = atomSetCollection.getAtoms();
            this.iatom = 0;
        }

        public boolean hasNext() {
            if (this.iatom == this.atomCount) {
                return false;
            }
            this.atom = this.atoms[this.iatom];
            this.atoms[this.iatom++] = null;
            return true;
        }

        public int getAtomSetIndex() {
            return this.atom.atomSetIndex;
        }

        public BitSet getAtomSymmetry() {
            return this.atom.bsSymmetry;
        }

        public int getAtomSite() {
            return this.atom.atomSite + 1;
        }

        public Object getUniqueID() {
            return new Integer(this.atom.atomIndex);
        }

        public String getElementSymbol() {
            return this.atom.getElementSymbol();
        }

        public short getElementNumber() {
            return this.atom.elementNumber > 0 ? this.atom.elementNumber : JmolAdapter.getElementNumber(this.atom.getElementSymbol());
        }

        public String getAtomName() {
            return this.atom.atomName;
        }

        public int getFormalCharge() {
            return this.atom.formalCharge;
        }

        public float getPartialCharge() {
            return this.atom.partialCharge;
        }

        public Object[] getEllipsoid() {
            return this.atom.ellipsoid;
        }

        public float getRadius() {
            return this.atom.radius;
        }

        public float getX() {
            return this.atom.x;
        }

        public float getY() {
            return this.atom.y;
        }

        public float getZ() {
            return this.atom.z;
        }

        public float getVectorX() {
            return this.atom.vectorX;
        }

        public float getVectorY() {
            return this.atom.vectorY;
        }

        public float getVectorZ() {
            return this.atom.vectorZ;
        }

        public float getBfactor() {
            return Float.isNaN(this.atom.bfactor) && this.atom.anisoBorU != null ? this.atom.anisoBorU[7] * 100.0f : this.atom.bfactor;
        }

        public int getOccupancy() {
            return this.atom.occupancy;
        }

        public boolean getIsHetero() {
            return this.atom.isHetero;
        }

        public int getAtomSerial() {
            return this.atom.atomSerial;
        }

        public char getChainID() {
            return JmolAdapter.canonizeChainID(this.atom.chainID);
        }

        public char getAlternateLocationID() {
            return JmolAdapter.canonizeAlternateLocationID(this.atom.alternateLocationID);
        }

        public String getGroup3() {
            return this.atom.group3;
        }

        public int getSequenceNumber() {
            return this.atom.sequenceNumber;
        }

        public char getInsertionCode() {
            return JmolAdapter.canonizeInsertionCode(this.atom.insertionCode);
        }
    }
}

