/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.Vector;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.shape.MeshRenderer;
import org.jmol.shapespecial.Draw;
import org.jmol.shapespecial.DrawMesh;

public class DrawRenderer
extends MeshRenderer {
    private int drawType;
    private DrawMesh dmesh;
    private Point3f[] controlHermites;
    private final Point3f vpt0 = new Point3f();
    private final Point3f vpt1 = new Point3f();
    private final Point3f vpt2 = new Point3f();
    private final Vector3f vTemp = new Vector3f();
    private final Vector3f vTemp2 = new Vector3f();
    private final Point3f pt0f = new Point3f();
    private final Point3i pt0i = new Point3i();

    protected void render() {
        this.imageFontScaling = this.viewer.getImageFontScaling();
        Draw draw = (Draw)this.shape;
        int n = draw.meshCount;
        while (--n >= 0) {
            this.dmesh = (DrawMesh)draw.meshes[n];
            if (!this.render1(this.dmesh)) continue;
            this.renderInfo();
        }
    }

    protected boolean isPolygonDisplayable(int n) {
        return Draw.isPolygonDisplayable(this.dmesh, n) && (this.dmesh.modelFlags == null || this.dmesh.bsMeshesVisible.get(n));
    }

    protected void render2(boolean bl) {
        int n;
        int n2;
        boolean bl2;
        this.drawType = this.dmesh.drawType;
        this.diameter = this.dmesh.diameter;
        this.width = this.dmesh.width;
        if (this.mesh.lineData != null) {
            this.drawLineData(this.mesh.lineData);
            return;
        }
        boolean bl3 = this.viewer.getPickingMode() == 4;
        int n3 = this.vertexCount;
        boolean bl4 = (this.drawType == 17 || this.drawType == 15 || this.drawType == 19) && this.vertexCount >= 2;
        boolean bl5 = bl2 = this.drawType == 20;
        if (this.width > 0.0f && bl4) {
            this.pt1f.set(0.0f, 0.0f, 0.0f);
            n2 = this.drawType == 19 ? 2 : this.vertexCount;
            for (n = 0; n < n2; ++n) {
                this.pt1f.add((Tuple3f)this.vertices[n]);
            }
            this.pt1f.scale(1.0f / (float)n2);
            this.viewer.transformPoint(this.pt1f, this.pt1i);
            this.diameter = this.viewer.scaleToScreen(this.pt1i.z, (int)(this.width * 1000.0f));
            if (this.diameter == 0) {
                this.diameter = 1;
            }
        }
        if (this.dmesh.isVector && this.dmesh.haveXyPoints) {
            n2 = 0;
            for (n = 0; n < 2; ++n) {
                if (this.vertices[n].z != Float.MAX_VALUE && this.vertices[n].z != -3.4028235E38f) continue;
                n2 += n + 1;
            }
            if (--n2 < 2) {
                this.renderXyArrow(n2);
                return;
            }
        }
        n2 = 5;
        switch (this.drawType) {
            default: {
                super.render2(false);
                break;
            }
            case 18: {
                if (this.dmesh.scale > 0.0f) {
                    this.width *= this.dmesh.scale;
                }
                super.render2(false);
                break;
            }
            case 16: {
                this.viewer.transformPoint(this.vertices[0], this.pt1i);
                if (this.diameter == 0 && this.width == 0.0f) {
                    this.width = 1.0f;
                }
                if (this.dmesh.scale > 0.0f) {
                    this.width *= this.dmesh.scale;
                }
                if (this.width > 0.0f) {
                    this.diameter = this.viewer.scaleToScreen(this.pt1i.z, (int)(this.width * 1000.0f));
                }
                if (this.diameter <= 0 || !this.mesh.drawTriangles && !this.mesh.fillTriangles) break;
                this.g3d.drawFilledCircle(this.colix, this.mesh.fillTriangles ? this.colix : (short)0, this.diameter, this.pt1i.x, this.pt1i.y, this.pt1i.z);
                break;
            }
            case 17: 
            case 20: {
                break;
            }
            case 19: {
                int n4;
                float f;
                float f2 = this.vertexCount > 3 ? this.vertices[3].x : 0.0f;
                float f3 = f = this.vertexCount > 3 ? this.vertices[3].y : 360.0f;
                if (f == 0.0f) {
                    return;
                }
                float f4 = this.vertexCount > 3 ? this.vertices[3].z : 0.0f;
                this.vTemp.set((Tuple3f)this.vertices[1]);
                this.vTemp.sub((Tuple3f)this.vertices[0]);
                this.pt1f.scaleAdd(f4, (Tuple3f)this.vTemp, (Tuple3f)this.vertices[0]);
                Matrix3f matrix3f = new Matrix3f();
                matrix3f.set(new AxisAngle4f(this.vTemp, (float)((double)f2 * Math.PI / 180.0)));
                if (this.vertexCount > 2) {
                    this.vTemp2.set((Tuple3f)this.vertices[2]);
                } else {
                    this.vTemp2.set((Tuple3f)Draw.randomPoint());
                }
                this.vTemp2.sub((Tuple3f)this.vertices[0]);
                this.vTemp2.cross(this.vTemp, this.vTemp2);
                this.vTemp2.cross(this.vTemp2, this.vTemp);
                this.vTemp2.normalize();
                this.vTemp2.scale(this.dmesh.scale / 2.0f);
                matrix3f.transform((Tuple3f)this.vTemp2);
                float f5 = f / 5.0f;
                while (Math.abs(f5) > 5.0f) {
                    f5 /= 2.0f;
                }
                n3 = (int)(f / f5 + 0.5f) + 1;
                while (n3 < 10) {
                    n3 = (int)(f / (f5 /= 2.0f) + 0.5f) + 1;
                }
                matrix3f.set(new AxisAngle4f(this.vTemp, (float)((double)f5 * Math.PI / 180.0)));
                this.screens = this.viewer.allocTempScreens(n3);
                int n5 = n3 - (this.dmesh.scale < 2.0f ? 3 : 3);
                for (n4 = 0; n4 < n3; ++n4) {
                    if (n4 == n5) {
                        this.vpt0.set((Tuple3f)this.vpt1);
                    }
                    this.vpt1.scaleAdd(1.0f, (Tuple3f)this.vTemp2, (Tuple3f)this.pt1f);
                    if (n4 == 0) {
                        this.vpt2.set((Tuple3f)this.vpt1);
                    }
                    this.viewer.transformPoint(this.vpt1, this.screens[n4]);
                    matrix3f.transform((Tuple3f)this.vTemp2);
                }
                if (this.dmesh.isVector && !this.dmesh.nohead) {
                    this.renderArrowHead(this.vpt0, this.vpt1, 0.3f, false, false);
                    this.viewer.transformPoint(this.pt1f, this.screens[n3 - 1]);
                }
                this.pt1f.set((Tuple3f)this.vpt2);
                break;
            }
            case 15: {
                if (this.vertexCount == 2) {
                    this.renderArrowHead(this.vertices[0], this.vertices[1], 0.0f, false, true);
                    return;
                }
                int n4 = 5;
                if (this.controlHermites == null || this.controlHermites.length < n4 + 1) {
                    this.controlHermites = new Point3f[n4 + 1];
                }
                Graphics3D.getHermiteList((int)n2, (Tuple3f)this.vertices[this.vertexCount - 3], (Tuple3f)this.vertices[this.vertexCount - 2], (Tuple3f)this.vertices[this.vertexCount - 1], (Tuple3f)this.vertices[this.vertexCount - 1], (Tuple3f)this.vertices[this.vertexCount - 1], (Tuple3f[])this.controlHermites, (int)0, (int)n4);
                this.renderArrowHead(this.controlHermites[n4 - 2], this.controlHermites[n4 - 1], 0.0f, false, false);
            }
        }
        if (this.diameter == 0) {
            this.diameter = 3;
        }
        if (bl4) {
            int n6 = 0;
            int n7 = 0;
            while (n6 < n3 - 1) {
                this.g3d.fillHermite(n2, this.diameter, this.diameter, this.diameter, this.screens[n7], this.screens[n6], this.screens[n6 + 1], this.screens[n6 + (n6 == n3 - 2 ? 1 : 2)]);
                n7 = n6++;
            }
        } else if (bl2) {
            for (int i = 0; i < n3 - 1; ++i) {
                this.drawLine(i, i + 1, true, this.vertices[i], this.vertices[i + 1], this.screens[i], this.screens[i + 1]);
            }
        }
        if (bl3 && !bl) {
            this.renderHandles();
        }
    }

    private void drawLineData(Vector vector) {
        if (this.diameter == 0) {
            this.diameter = 3;
        }
        int n = vector.size();
        while (--n >= 0) {
            Point3f[] point3fArray = (Point3f[])vector.get(n);
            this.viewer.transformPoint(point3fArray[0], this.pt1i);
            this.viewer.transformPoint(point3fArray[1], this.pt2i);
            this.drawLine(-1, -2, true, point3fArray[0], point3fArray[1], this.pt1i, this.pt2i);
        }
    }

    private void renderXyArrow(int n) {
        int n2 = 1 - n;
        Point3f[] point3fArray = new Point3f[2];
        point3fArray[n2] = this.vpt1;
        point3fArray[n] = this.vpt0;
        this.vpt0.set((float)this.screens[n].x, (float)this.screens[n].y, (float)this.screens[n].z);
        this.viewer.rotatePoint(this.vertices[n2], this.vpt1);
        this.vpt1.z *= -1.0f;
        float f = this.viewer.getScreenDim();
        float f2 = f / 20.0f;
        this.vpt1.scaleAdd(this.dmesh.scale * f2, (Tuple3f)this.vpt1, (Tuple3f)this.vpt0);
        if (this.diameter == 0) {
            this.diameter = 1;
        }
        this.pt1i.set((int)this.vpt0.x, (int)this.vpt0.y, (int)this.vpt0.z);
        this.pt2i.set((int)this.vpt1.x, (int)this.vpt1.y, (int)this.vpt1.z);
        if (this.diameter < 0) {
            this.g3d.drawDottedLine(this.pt1i, this.pt2i);
        } else {
            this.g3d.fillCylinder((byte)2, this.diameter, this.pt1i, this.pt2i);
        }
        this.renderArrowHead(this.vpt0, this.vpt1, 0.0f, true, false);
    }

    private void renderArrowHead(Point3f point3f, Point3f point3f2, float f, boolean bl, boolean bl2) {
        int n;
        if (this.dmesh.nohead) {
            return;
        }
        float f2 = this.dmesh.drawArrowScale;
        if (f2 == 0.0f) {
            f2 = this.viewer.getDefaultDrawArrowScale();
        }
        if (f2 <= 0.0f) {
            f2 = 0.5f;
        }
        if (bl) {
            f2 *= 40.0f;
        }
        if (f > 0.0f) {
            f2 *= f;
        }
        this.pt0f.set((Tuple3f)point3f);
        this.pt2f.set((Tuple3f)point3f2);
        float f3 = this.pt0f.distance(this.pt2f);
        if (f3 == 0.0f) {
            return;
        }
        this.vTemp.set((Tuple3f)this.pt2f);
        this.vTemp.sub((Tuple3f)this.pt0f);
        this.vTemp.normalize();
        this.vTemp.scale(f2 / 5.0f);
        if (!bl2) {
            this.pt2f.add((Tuple3f)this.vTemp);
        }
        this.vTemp.scale(5.0f);
        this.pt1f.set((Tuple3f)this.pt2f);
        this.pt1f.sub((Tuple3f)this.vTemp);
        if (bl) {
            this.pt1i.set((int)this.pt1f.x, (int)this.pt1f.y, (int)this.pt1f.z);
            this.pt2i.set((int)this.pt2f.x, (int)this.pt2f.y, (int)this.pt2f.z);
        } else {
            this.viewer.transformPoint(this.pt2f, this.pt2i);
            this.viewer.transformPoint(this.pt1f, this.pt1i);
            this.viewer.transformPoint(this.pt0f, this.pt0i);
        }
        if (this.pt2i.z == 1 || this.pt1i.z == 1) {
            return;
        }
        if (this.diameter > 0) {
            n = this.diameter * 3;
        } else {
            this.vTemp.set((float)(this.pt2i.x - this.pt1i.x), (float)(this.pt2i.y - this.pt1i.y), (float)(this.pt2i.z - this.pt1i.z));
            n = (int)((double)this.vTemp.length() * 0.5);
            this.diameter = n / 5;
        }
        if (this.diameter < 1) {
            this.diameter = 1;
        }
        if (n > 2) {
            this.g3d.fillConeScreen((byte)2, n, this.pt1i, this.pt2i);
        }
        if (bl2) {
            this.g3d.fillCylinderScreen((byte)4, this.diameter, this.pt0i, this.pt1i);
        }
    }

    private void renderHandles() {
        int n = (int)(10.0f * this.imageFontScaling);
        switch (this.drawType) {
            case 0: 
            case 3: {
                return;
            }
        }
        short s = Graphics3D.getColixTranslucent((short)23, (boolean)true, (float)0.5f);
        int n2 = this.dmesh.polygonCount;
        while (--n2 >= 0) {
            int[] nArray;
            if (!this.isPolygonDisplayable(n2) || (nArray = this.dmesh.polygonIndexes[n2]) == null) continue;
            int n3 = nArray.length;
            while (--n3 >= 0) {
                int n4 = nArray[n3];
                this.g3d.drawFilledCircle((short)23, s, n, this.screens[n4].x, this.screens[n4].y, this.screens[n4].z);
            }
            break block3;
        }
    }

    private void renderInfo() {
        if (this.mesh.title == null || this.viewer.getDrawHover() || !this.g3d.setColix(this.viewer.getColixBackgroundContrast())) {
            return;
        }
        int n = this.dmesh.polygonCount;
        while (--n >= 0) {
            if (!this.isPolygonDisplayable(n)) continue;
            byte by = this.g3d.getFontFid(14.0f * this.imageFontScaling);
            this.g3d.setFont(by);
            String string = this.mesh.title[n < this.mesh.title.length ? n : this.mesh.title.length - 1];
            int n2 = 0;
            if (string.length() > 1 && string.charAt(0) == '>') {
                n2 = this.dmesh.polygonIndexes[n].length - 1;
                string = string.substring(1);
                if (this.drawType == 19) {
                    this.pt1f.set((Tuple3f)this.pt2f);
                }
            }
            if (this.drawType != 19) {
                this.pt1f.set((Tuple3f)this.vertices[this.dmesh.polygonIndexes[n][n2]]);
            }
            this.viewer.transformPoint(this.pt1f, this.pt1i);
            int n3 = (int)(5.0f * this.imageFontScaling);
            this.g3d.drawString(string, null, this.pt1i.x + n3, this.pt1i.y - n3, this.pt1i.z, this.pt1i.z);
            break;
        }
    }
}

