/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.multitouch.sparshui;

import com.sparshui.common.messages.events.TouchEvent;
import com.sparshui.gestures.Gesture;
import com.sparshui.server.TouchPoint;
import java.util.Vector;
import org.jmol.util.Logger;

public class SinglePointGesture
implements Gesture {
    private static final long MAXIMUM_CLICK_TIME = 200L;
    private int _nCurrent;
    private int _nMoves;
    private int _myId;
    private TouchPoint _birth;

    public String getName() {
        return "SinglePointGesture";
    }

    public int getGestureType() {
        return 4;
    }

    public Vector processChange(Vector vector, TouchPoint touchPoint) {
        Vector<TouchEvent> vector2 = new Vector<TouchEvent>();
        int n = vector.size();
        if (Logger.debugging) {
            Logger.info((String)("\nSinglePointGesture " + this._myId + " nPoints: " + n));
        }
        if (n > 1) {
            if (this._myId != Integer.MAX_VALUE) {
                this._myId = Integer.MAX_VALUE;
                this._nMoves = 1000;
                this._nCurrent = 0;
                vector2.add(new TouchEvent());
            }
            return vector2;
        }
        int n2 = touchPoint.getID();
        if (Logger.debugging) {
            Logger.info((String)("\nSinglePointGesture id=" + n2 + " state=" + touchPoint.getState() + " ncurrent=" + this._nCurrent + " nMoves=" + this._nMoves));
        }
        switch (touchPoint.getState()) {
            case 0: {
                this._myId = n2;
                this._birth = new TouchPoint(touchPoint);
                this._nCurrent = 1;
                this._nMoves = 0;
                break;
            }
            case 2: {
                if (n2 != this._myId) {
                    return vector2;
                }
                switch (++this._nMoves) {
                    case 2: {
                        if (!this.checkClick(touchPoint, vector2, false)) break;
                        return vector2;
                    }
                }
                break;
            }
            case 1: {
                if (n2 != this._myId) {
                    return vector2;
                }
                this._nCurrent = 0;
                if (this._nMoves >= 2 || !this.checkClick(touchPoint, vector2, true)) break;
                return vector2;
            }
        }
        vector2.add(new TouchEvent(touchPoint));
        return vector2;
    }

    private boolean checkClick(TouchPoint touchPoint, Vector vector, boolean bl) {
        boolean bl2;
        long l = touchPoint.getTime() - this._birth.getTime();
        boolean bl3 = bl2 = bl && l < 200L;
        if (l < 500L && !bl2) {
            return false;
        }
        this._nMoves += 2;
        TouchPoint touchPoint2 = new TouchPoint(this._birth);
        touchPoint2.setState(1);
        vector.add(new TouchEvent(touchPoint2));
        touchPoint2.setState(3);
        vector.add(new TouchEvent(touchPoint2));
        if (bl2) {
            return true;
        }
        touchPoint2.setState(0);
        vector.add(new TouchEvent(touchPoint2));
        if (!bl) {
            return true;
        }
        touchPoint2.setState(1);
        vector.add(new TouchEvent(touchPoint2));
        touchPoint2.setState(3);
        vector.add(new TouchEvent(touchPoint2));
        return true;
    }
}

