/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.api.JmolEdge;
import org.jmol.api.JmolMolecule;
import org.jmol.api.JmolNode;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesParser;
import org.jmol.smiles.SmilesSearch;
import org.jmol.util.Elements;
import org.jmol.util.Logger;

public class SmilesGenerator {
    private JmolNode[] atoms;
    private int atomCount;
    private BitSet bsSelected;
    private BitSet bsAromatic;
    private StringBuffer ringSets;
    private SmilesSearch.VTemp vTemp = new SmilesSearch.VTemp();
    private int nPairs;
    private BitSet bsBondsUp = new BitSet();
    private BitSet bsBondsDn = new BitSet();
    private BitSet bsToDo;
    private JmolNode prevAtom;
    private JmolNode[] prevSp2Atoms;
    private Hashtable htRingsSequence = new Hashtable();
    private Hashtable htRings = new Hashtable();
    private BitSet bsIncludingH;

    String getSmiles(JmolNode[] jmolNodeArray, int n, BitSet bitSet) throws InvalidSmilesException {
        int n2 = bitSet.nextSetBit(0);
        if (n2 < 0) {
            return "";
        }
        this.atoms = jmolNodeArray;
        this.atomCount = n;
        this.bsSelected = bitSet = (BitSet)bitSet.clone();
        return this.getSmilesComponent(jmolNodeArray[n2], bitSet, false);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    String getBioSmiles(JmolNode[] var1_1, int var2_2, BitSet var3_3, boolean var4_4, boolean var5_5, String var6_6) throws InvalidSmilesException {
        this.atoms = var1_1;
        this.atomCount = var2_2;
        var7_7 = new StringBuffer();
        var8_8 = (BitSet)var3_3.clone();
        if (var6_6 != null) {
            var7_7.append("//* Jmol bioSMILES ").append(var6_6.replace('*', '_')).append(" *//");
        }
        var9_9 = "\n";
        var10_10 = new BitSet();
        var11_11 = null;
        var13_12 = new Vector<E>();
        try {
            var14_13 = 0;
            var15_15 = var8_8.nextSetBit(0);
            while (var15_15 >= 0) {
                var16_17 = var1_1[var15_15];
                var17_18 = var16_17.getGroup1('?');
                var18_19 = var16_17.getGroupType();
                var19_20 = var17_18.equals("?");
                if (var9_9 == null) ** GOTO lbl49
                if (var7_7.length() > 0) {
                    var7_7.append(var9_9);
                }
                var9_9 = null;
                var14_13 = 0;
                if (var18_19.length() <= 0) {
                    var12_16 = this.getSmilesComponent(var16_17, var8_8, true);
                    if (var12_16.equals(var11_11)) {
                        var9_9 = "";
                    } else {
                        var11_11 = var12_16;
                        var18_19 = var16_17.getGroup3(true);
                        if (var18_19 != null) {
                            var7_7.append("//* ").append(var18_19).append(" *//");
                        }
                        var7_7.append(var12_16);
                        var9_9 = ".\n";
                    }
                } else {
                    var20_21 = var16_17.getChainID();
                    if (var20_21 != '\u0000') {
                        var12_16 = "//* chain " + var20_21 + " " + var18_19 + " " + var16_17.getResno() + " *// ";
                        var14_13 = var12_16.length();
                        var7_7.append(var12_16);
                    }
                    var7_7.append("~").append(var18_19.charAt(0)).append("~");
                    ++var14_13;
lbl49:
                    // 2 sources

                    if (var14_13 >= 75) {
                        var7_7.append("\n  ");
                        var14_13 = 2;
                    }
                    if (var19_20) {
                        this.addBracketedBioName(var7_7, var16_17, var18_19.length() > 0 ? ".0" : null);
                    } else {
                        var7_7.append(var17_18);
                    }
                    ++var14_13;
                    var20_21 = var16_17.getOffsetResidueAtom("0", 0);
                    if (var5_5) {
                        var16_17.getCrossLinkLeadAtomIndexes(var13_12);
                        for (var21_22 = 0; var21_22 < var13_12.size(); ++var21_22) {
                            var7_7.append(":");
                            var12_16 = this.getRingCache(var20_21, (Integer)var13_12.get(var21_22), this.htRingsSequence);
                            var7_7.append(var12_16);
                            var14_13 += 1 + var12_16.length();
                        }
                        var13_12.clear();
                    }
                    var16_17.setGroupBits(var10_10);
                    var8_8.andNot(var10_10);
                    var21_22 = var16_17.getOffsetResidueAtom("0", 1);
                    if (var21_22 < 0 || !var8_8.get(var21_22)) {
                        var7_7.append(" //* ").append(var16_17.getResno()).append(" *//");
                        if (var21_22 < 0 && (var21_22 = var8_8.nextSetBit(var15_15 + 1)) < 0) break;
                        if (var14_13 > 0) {
                            var9_9 = ".\n";
                        }
                    }
                    var15_15 = var21_22 - 1;
                }
                var15_15 = var8_8.nextSetBit(var15_15 + 1);
            }
        }
        catch (Exception var14_14) {
            var14_14.printStackTrace();
            return "";
        }
        if (!var4_4 && !this.htRingsSequence.isEmpty()) {
            this.dumpRingKeys(var7_7, this.htRingsSequence);
            throw new InvalidSmilesException("//* ?ring error? *//");
        }
        var12_16 = var7_7.toString();
        if (var12_16.endsWith(".\n")) {
            var12_16 = var12_16.substring(0, var12_16.length() - 2);
        }
        return var12_16;
    }

    private void addBracketedBioName(StringBuffer stringBuffer, JmolNode jmolNode, String string) {
        stringBuffer.append("[");
        if (string != null) {
            char c = jmolNode.getChainID();
            stringBuffer.append(jmolNode.getGroup3(false));
            if (!string.equals(".0")) {
                stringBuffer.append(string).append("#").append(jmolNode.getElementNumber());
            }
            stringBuffer.append("//* ").append(jmolNode.getResno());
            if (c != '\u0000') {
                stringBuffer.append(":").append(c);
            }
            stringBuffer.append(" *//");
        } else {
            stringBuffer.append(Elements.elementNameFromNumber((int)jmolNode.getElementNumber()));
        }
        stringBuffer.append("]");
    }

    private String getSmilesComponent(JmolNode jmolNode, BitSet bitSet, boolean bl) throws InvalidSmilesException {
        Object object;
        if (jmolNode.getElementNumber() == 1 && jmolNode.getEdges().length > 0) {
            jmolNode = this.atoms[jmolNode.getBondedAtomIndex(0)];
        }
        this.bsSelected = JmolMolecule.getBranchBitSet((JmolNode[])this.atoms, (BitSet)((BitSet)bitSet.clone()), (int)jmolNode.getIndex(), (int)-1, (boolean)true, (boolean)false);
        bitSet.andNot(this.bsSelected);
        this.bsIncludingH = (BitSet)this.bsSelected.clone();
        int n = this.bsSelected.nextSetBit(0);
        while (n >= 0) {
            object = this.atoms[n];
            if (object.getElementNumber() == 1 && object.getIsotopeNumber() == 0) {
                this.bsSelected.clear(n);
            }
            n = this.bsSelected.nextSetBit(n + 1);
        }
        if (this.bsSelected.cardinality() > 2) {
            SmilesSearch smilesSearch = null;
            smilesSearch = SmilesParser.getMolecule("A[=&@]A", true);
            smilesSearch.jmolAtoms = this.atoms;
            smilesSearch.setSelected(this.bsSelected);
            smilesSearch.jmolAtomCount = this.atomCount;
            smilesSearch.ringDataMax = 7;
            smilesSearch.setRingData(null);
            this.bsAromatic = smilesSearch.bsAromatic;
            this.ringSets = smilesSearch.ringSets;
            this.setBondDirections();
        } else {
            this.bsAromatic = new BitSet();
        }
        this.bsToDo = (BitSet)this.bsSelected.clone();
        StringBuffer stringBuffer = new StringBuffer();
        while ((jmolNode = this.getSmiles(stringBuffer, jmolNode, bl)) != null) {
        }
        while (this.bsToDo.cardinality() > 0 || !this.htRings.isEmpty()) {
            object = this.htRings.keys();
            if (object.hasMoreElements()) {
                jmolNode = this.atoms[(Integer)((Object[])this.htRings.get(object.nextElement()))[1]];
                if (!this.bsToDo.get(jmolNode.getIndex())) {
                    break;
                }
            } else {
                jmolNode = this.atoms[this.bsToDo.nextSetBit(0)];
            }
            stringBuffer.append(".");
            this.prevSp2Atoms = null;
            this.prevAtom = null;
            while ((jmolNode = this.getSmiles(stringBuffer, jmolNode, bl)) != null) {
            }
        }
        if (!this.htRings.isEmpty()) {
            this.dumpRingKeys(stringBuffer, this.htRings);
            throw new InvalidSmilesException("//* ?ring error? *//\n" + stringBuffer);
        }
        return stringBuffer.toString();
    }

    private char getBondStereochemistry(JmolEdge jmolEdge, JmolNode jmolNode) {
        boolean bl;
        if (jmolEdge == null) {
            return '\u0000';
        }
        int n = jmolEdge.getIndex();
        boolean bl2 = bl = jmolNode == null || jmolEdge.getAtomIndex1() == jmolNode.getIndex();
        return (char)(this.bsBondsUp.get(n) ? (bl ? 47 : 92) : (this.bsBondsDn.get(n) ? (bl ? 92 : 47) : 0));
    }

    private void setBondDirections() {
        BitSet bitSet = new BitSet();
        JmolEdge[][] jmolEdgeArray = new JmolEdge[2][3];
        int n = this.bsSelected.nextSetBit(0);
        while (n >= 0) {
            JmolNode jmolNode = this.atoms[n];
            JmolEdge[] jmolEdgeArray2 = jmolNode.getEdges();
            for (int i = 0; i < jmolEdgeArray2.length; ++i) {
                char c;
                JmolEdge jmolEdge = jmolEdgeArray2[i];
                int n2 = jmolEdge.getIndex();
                if (bitSet.get(n2)) continue;
                JmolNode jmolNode2 = jmolEdge.getOtherAtom(jmolNode);
                if (jmolEdge.getCovalentOrder() != 2 || SmilesSearch.isRingBond(this.ringSets, n, jmolNode2.getIndex())) continue;
                bitSet.set(n2);
                JmolEdge jmolEdge2 = null;
                JmolNode jmolNode3 = null;
                char c2 = '\u0000';
                JmolNode[] jmolNodeArray = new JmolNode[]{jmolNode, jmolNode2};
                if (Logger.debugging) {
                    Logger.debug((String)(jmolNode + " == " + jmolNode2));
                }
                int n3 = 1;
                for (c = '\u0000'; c < '\u0002' && n3 > 0 && n3 < 3; ++c) {
                    n3 = 0;
                    JmolNode jmolNode4 = jmolNodeArray[c];
                    JmolEdge[] jmolEdgeArray3 = jmolNode4.getEdges();
                    for (int j = 0; j < jmolEdgeArray3.length; ++j) {
                        if (jmolEdgeArray3[j].getCovalentOrder() != 1) continue;
                        jmolEdgeArray[c][n3++] = jmolEdgeArray3[j];
                        if (this.getBondStereochemistry(jmolEdgeArray3[j], jmolNode4) == '\u0000') continue;
                        jmolEdge2 = jmolEdgeArray3[j];
                        c2 = c;
                    }
                }
                if (n3 == 3 || n3 == 0) continue;
                if (jmolEdge2 == null) {
                    c2 = '\u0000';
                    jmolEdge2 = jmolEdgeArray[c2][0];
                    this.bsBondsUp.set(jmolEdge2.getIndex());
                }
                c = this.getBondStereochemistry(jmolEdge2, jmolNodeArray[c2]);
                jmolNode3 = jmolEdge2.getOtherAtom(jmolNodeArray[c2]);
                for (int j = 0; j < 2; ++j) {
                    for (int k = 0; k < 2; ++k) {
                        JmolEdge jmolEdge3 = jmolEdgeArray[j][k];
                        if (jmolEdge3 == null || jmolEdge3 == jmolEdge2) continue;
                        int n4 = jmolEdge3.getIndex();
                        JmolNode jmolNode5 = jmolEdge3.getOtherAtom(jmolNodeArray[j]);
                        char c3 = this.getBondStereochemistry(jmolEdge3, jmolNodeArray[j]);
                        boolean bl = SmilesSearch.isDiaxial(jmolNodeArray[c2], jmolNodeArray[j], jmolNode3, jmolNode5, this.vTemp, 0.0f);
                        if (c3 == '\u0000' || c3 != c == bl) {
                            boolean bl2 = c == '\\' && bl || c == '/' && !bl;
                            if (bl2 == (jmolEdge3.getAtomIndex1() != jmolNode5.getIndex())) {
                                this.bsBondsUp.set(n4);
                            } else {
                                this.bsBondsDn.set(n4);
                            }
                        } else {
                            Logger.error((String)"BOND STEREOCHEMISTRY ERROR");
                        }
                        if (!Logger.debugging) continue;
                        Logger.debug((String)(this.getBondStereochemistry(jmolEdge2, jmolNodeArray[0]) + " " + jmolNode3.getIndex() + " " + jmolNode5.getIndex() + " " + this.getBondStereochemistry(jmolEdge3, jmolNodeArray[j])));
                    }
                }
            }
            n = this.bsSelected.nextSetBit(n + 1);
        }
    }

    private JmolNode getSmiles(StringBuffer stringBuffer, JmolNode jmolNode, boolean bl) {
        Object object;
        StringBuffer stringBuffer2;
        JmolNode jmolNode2;
        int n;
        int n2;
        char c;
        int n3;
        BitSet bitSet;
        int n4 = jmolNode.getIndex();
        if (!this.bsToDo.get(n4)) {
            return null;
        }
        this.bsToDo.clear(n4);
        boolean bl2 = !this.bsSelected.get(n4);
        int n5 = this.prevAtom == null ? -1 : this.prevAtom.getIndex();
        boolean bl3 = this.bsAromatic.get(n4);
        boolean bl4 = this.prevSp2Atoms != null;
        JmolNode[] jmolNodeArray = this.prevSp2Atoms;
        int n6 = 0;
        short s = jmolNode.getElementNumber();
        int n7 = 0;
        Vector<JmolEdge> vector = new Vector<JmolEdge>();
        JmolEdge jmolEdge = null;
        JmolEdge jmolEdge2 = null;
        JmolEdge[] jmolEdgeArray = jmolNode.getEdges();
        BitSet bitSet2 = null;
        int n8 = bl3 ? 10 : 0;
        JmolNode[] jmolNodeArray2 = new JmolNode[7];
        if (Logger.debugging) {
            Logger.debug((String)stringBuffer.toString());
        }
        if (jmolEdgeArray != null) {
            int n9 = jmolEdgeArray.length;
            while (--n9 >= 0) {
                boolean bl5;
                JmolEdge jmolEdge3 = jmolEdgeArray[n9];
                if (!jmolEdge3.isCovalent()) continue;
                bitSet = jmolEdgeArray[n9].getOtherAtom(jmolNode);
                n3 = bitSet.getIndex();
                if (n3 == n5) {
                    jmolEdge2 = jmolEdgeArray[n9];
                    continue;
                }
                boolean bl6 = bl5 = bitSet.getElementNumber() == 1 && bitSet.getIsotopeNumber() == 0;
                if (!this.bsIncludingH.get(n3)) {
                    if (bl5 || !bl || !this.bsSelected.get(n4)) continue;
                    this.bsToDo.set(n3);
                }
                if (bl5) {
                    bitSet2 = bitSet;
                    if (++n7 <= 1) continue;
                    n8 = 10;
                    continue;
                }
                vector.add(jmolEdgeArray[n9]);
            }
        }
        String string = null;
        if (jmolNodeArray == null) {
            jmolNodeArray = new JmolNode[5];
        }
        if (jmolEdge2 != null) {
            string = SmilesBond.getBondOrderString(jmolEdge2.getCovalentOrder());
            if (this.prevSp2Atoms == null) {
                jmolNodeArray[n6++] = this.prevAtom;
            } else {
                n6 = 2;
            }
        }
        n6 += n7;
        char c2 = '\u0000';
        bitSet = new BitSet();
        for (n3 = 0; n3 < vector.size(); ++n3) {
            JmolEdge jmolEdge4 = (JmolEdge)vector.get(n3);
            JmolNode jmolNode3 = jmolEdge4.getOtherAtom(jmolNode);
            c = jmolNode3.getCovalentBondCount() - jmolNode3.getCovalentHydrogenCount();
            int n10 = jmolEdge4.getCovalentOrder();
            if (n10 == 1 && c == '\u0001' && n3 < vector.size() - (jmolEdge == null ? 1 : 0)) {
                bitSet.set(jmolEdge4.getIndex());
                continue;
            }
            if (n10 <= 1 && c <= c2 || this.htRings.containsKey(SmilesGenerator.getRingKey(jmolNode3.getIndex(), n4))) continue;
            c2 = n10 > 1 ? 1000 + n10 : c;
            jmolEdge = jmolEdge4;
        }
        JmolNode jmolNode4 = jmolEdge == null ? null : jmolEdge.getOtherAtom(jmolNode);
        int n11 = n2 = jmolEdge == null ? 0 : jmolEdge.getCovalentOrder();
        if (n8 < 7 && jmolEdge2 != null) {
            if (jmolEdge2.getCovalentOrder() == 2 && n2 == 2 && this.prevSp2Atoms != null && this.prevSp2Atoms[1] != null) {
                jmolNodeArray2[n8++] = this.prevSp2Atoms[0];
                jmolNodeArray2[n8++] = this.prevSp2Atoms[1];
            } else {
                jmolNodeArray2[n8++] = this.prevAtom;
            }
        }
        if (n8 < 7 && n7 == 1) {
            jmolNodeArray2[n8++] = bitSet2;
        }
        boolean bl7 = n2 == 1 && this.prevSp2Atoms == null;
        c = this.getBondStereochemistry(jmolEdge2, this.prevAtom);
        StringBuffer stringBuffer3 = new StringBuffer();
        for (n = 0; n < vector.size(); ++n) {
            JmolEdge jmolEdge5 = (JmolEdge)vector.get(n);
            if (!bitSet.get(jmolEdge5.getIndex())) continue;
            jmolNode2 = jmolEdge5.getOtherAtom(jmolNode);
            stringBuffer2 = new StringBuffer();
            stringBuffer2.append("(");
            this.prevAtom = jmolNode;
            this.prevSp2Atoms = null;
            object = jmolEdge;
            this.getSmiles(stringBuffer2, jmolNode2, bl);
            jmolEdge = object;
            stringBuffer2.append(")");
            if (stringBuffer3.indexOf(stringBuffer2.toString()) >= 0) {
                n8 = 10;
            }
            stringBuffer3.append(stringBuffer2);
            vector.remove(n--);
            if (n8 < 7) {
                jmolNodeArray2[n8++] = jmolNode2;
            }
            if (n6 >= 5) continue;
            jmolNodeArray[n6++] = jmolNode2;
        }
        int n12 = n = n2 == 2 ? jmolNode4.getIndex() : -1;
        if (n7 > 1 || bl3 || n < 0 || SmilesSearch.isRingBond(this.ringSets, n4, n)) {
            n6 = -1;
        }
        if (n6 < 0) {
            jmolNodeArray = null;
        }
        if (string != null || c != '\u0000') {
            if (c != '\u0000') {
                string = "" + c;
            }
            stringBuffer.append(string);
        }
        int n13 = vector.size();
        while (--n13 >= 0) {
            jmolNode2 = (JmolEdge)vector.get(n13);
            if (jmolNode2 == jmolEdge) continue;
            stringBuffer2 = jmolNode2.getOtherAtom(jmolNode);
            object = this.getRingCache(n4, stringBuffer2.getIndex(), this.htRings);
            string = SmilesBond.getBondOrderString(jmolNode2.getOrder());
            if (!bl7 && (c = this.getBondStereochemistry((JmolEdge)jmolNode2, jmolNode)) != '\u0000') {
                string = "" + c;
            }
            stringBuffer3.append(string);
            stringBuffer3.append((String)object);
            if (n8 < 7) {
                jmolNodeArray2[n8++] = stringBuffer2;
            }
            if (jmolNodeArray == null || n6 >= 5) continue;
            jmolNodeArray[n6++] = stringBuffer2;
        }
        if (bl4 && n8 == 2 && n2 == 2 && jmolNode4.getCovalentBondCount() == 3) {
            jmolEdgeArray = jmolNode4.getEdges();
            for (n13 = 0; n13 < jmolEdgeArray.length; ++n13) {
                if (!jmolEdgeArray[n13].isCovalent() || jmolNode4.getBondedAtomIndex(n13) == n4) continue;
                jmolNodeArray2[n8++] = this.atoms[jmolNode4.getBondedAtomIndex(n13)];
            }
            n6 = 0;
        } else if (jmolNode4 != null && n8 < 7) {
            jmolNodeArray2[n8++] = jmolNode4;
        }
        n13 = jmolNode.getValence();
        int n14 = jmolNode.getFormalCharge();
        short s2 = jmolNode.getIsotopeNumber();
        object = jmolNode.getAtomName();
        String string2 = jmolNode.getGroupType();
        if (bl2 && string2.length() != 0 && ((String)object).length() != 0) {
            this.addBracketedBioName(stringBuffer, jmolNode, "." + (String)object);
        } else {
            stringBuffer.append(SmilesAtom.getAtomLabel(s, s2, n13, n14, n7, bl3, this.checkStereoPairs(jmolNode, n4, jmolNodeArray2, n8)));
        }
        stringBuffer.append(stringBuffer3);
        if (jmolEdge == null) {
            return null;
        }
        if (n2 == 2 && (n6 == 1 || n6 == 2)) {
            if (jmolNodeArray[0] == null) {
                jmolNodeArray[0] = jmolNode;
            }
            if (jmolNodeArray[1] == null) {
                jmolNodeArray[1] = jmolNode;
            }
        } else {
            jmolNodeArray = null;
            n6 = 0;
        }
        this.prevSp2Atoms = jmolNodeArray;
        this.prevAtom = jmolNode;
        return jmolNode4;
    }

    private String checkStereoPairs(JmolNode jmolNode, int n, JmolNode[] jmolNodeArray, int n2) {
        if (n2 == 4 && jmolNode.getElementNumber() == 6) {
            String string = "";
            for (int i = 0; i < 4; ++i) {
                int n3;
                short s = jmolNodeArray[i].getAtomicAndIsotopeNumber();
                int n4 = jmolNodeArray[i].getCovalentBondCount();
                if (s != 6 && n4 > 1) continue;
                int n5 = n3 = s == 6 ? jmolNodeArray[i].getCovalentHydrogenCount() : 0;
                if (n3 > 0 && (n4 != 4 || n3 != 3)) continue;
                String string2 = ";" + s + "/" + n3 + "/" + n4 + ",";
                if (string.indexOf(string2) >= 0) {
                    if (n3 == 3) {
                        int n6 = 0;
                        for (int j = 0; j < n4 && n6 < 3; ++j) {
                            int n7 = jmolNodeArray[i].getBondedAtomIndex(j);
                            if (n7 == n) continue;
                            n6 += this.atoms[n7].getAtomicAndIsotopeNumber();
                        }
                        if (n6 > 3) continue;
                    }
                    n2 = 10;
                    break;
                }
                string = string + string2;
            }
        }
        return n2 > 6 ? "" : SmilesSearch.getStereoFlag(jmolNode, jmolNodeArray, n2, this.vTemp);
    }

    private String getRingCache(int n, int n2, Hashtable hashtable) {
        String string;
        String string2 = SmilesGenerator.getRingKey(n, n2);
        Object[] objectArray = (Object[])hashtable.get(string2);
        String string3 = string = objectArray == null ? null : (String)objectArray[0];
        if (string == null) {
            Object[] objectArray2 = new Object[2];
            string = SmilesParser.getRingPointer(++this.nPairs);
            objectArray2[0] = string;
            objectArray2[1] = new Integer(n2);
            hashtable.put(string2, objectArray2);
            if (Logger.debugging) {
                Logger.info((String)("adding for " + n + " ring key " + this.nPairs + ": " + string2));
            }
        } else {
            hashtable.remove(string2);
            if (Logger.debugging) {
                Logger.info((String)("using ring key " + string2));
            }
        }
        return string;
    }

    private void dumpRingKeys(StringBuffer stringBuffer, Hashtable hashtable) {
        Logger.info((String)(stringBuffer.toString() + "\n\n"));
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Logger.info((String)("unmatched ring key: " + enumeration.nextElement()));
        }
    }

    protected static String getRingKey(int n, int n2) {
        return Math.min(n, n2) + "_" + Math.max(n, n2);
    }
}

