/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Group;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.Polymer;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.AminoPolymer;
import org.jmol.modelsetbio.CarbohydrateMonomer;
import org.jmol.modelsetbio.CarbohydratePolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.modelsetbio.NucleicPolymer;
import org.jmol.modelsetbio.PhosphorusMonomer;
import org.jmol.modelsetbio.PhosphorusPolymer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.OutputStringBuffer;
import org.jmol.util.Quaternion;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Viewer;

public abstract class BioPolymer
extends Polymer {
    Monomer[] monomers;
    private boolean invalidLead;
    protected boolean invalidControl = false;
    protected float sheetSmoothing;
    protected boolean hasWingPoints;
    private final Vector3f unitVectorX = new Vector3f(1.0f, 0.0f, 0.0f);
    private int selectedMonomerCount;
    BitSet bsSelectedMonomers;
    public boolean haveParameters;
    private static final String[] qColor = new String[]{"yellow", "orange", "purple"};

    public Group[] getGroups() {
        return this.monomers;
    }

    BioPolymer(Monomer[] monomerArray) {
        this.monomers = monomerArray;
        int n = this.monomerCount = monomerArray.length;
        while (--n >= 0) {
            monomerArray[n].setBioPolymer(this, n);
        }
        this.model = monomerArray[0].getModel();
    }

    public void getRange(BitSet bitSet) {
        if (this.monomerCount == 0) {
            return;
        }
        bitSet.set(this.monomers[0].getFirstAtomIndex(), this.monomers[this.monomerCount - 1].getLastAtomIndex() + 1);
    }

    static BioPolymer allocateBioPolymer(Group[] groupArray, int n, boolean bl) {
        Group group;
        Object object = null;
        int n2 = 0;
        for (int i = n; i < groupArray.length && (group = groupArray[i]) instanceof Monomer; ++i) {
            Monomer monomer = (Monomer)group;
            if (monomer.bioPolymer != null || object != null && object.getClass() != ((Object)((Object)monomer)).getClass() || bl && !monomer.isConnectedAfter((Monomer)((Object)object))) break;
            object = monomer;
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        Monomer[] monomerArray = new Monomer[n2];
        for (int i = 0; i < n2; ++i) {
            monomerArray[i] = (Monomer)groupArray[n + i];
        }
        if (object instanceof AminoMonomer) {
            return new AminoPolymer(monomerArray);
        }
        if (object instanceof AlphaMonomer) {
            return new AlphaPolymer(monomerArray);
        }
        if (object instanceof NucleicMonomer) {
            return new NucleicPolymer(monomerArray);
        }
        if (object instanceof PhosphorusMonomer) {
            return new PhosphorusPolymer(monomerArray);
        }
        if (object instanceof CarbohydrateMonomer) {
            return new CarbohydratePolymer(monomerArray);
        }
        Logger.error((String)("Polymer.allocatePolymer() ... no matching polymer for monomor " + object));
        throw new NullPointerException();
    }

    public void clearStructures() {
        for (int i = 0; i < this.monomerCount; ++i) {
            this.monomers[i].setStructure(null);
        }
    }

    void removeProteinStructure(int n, int n2) {
        Monomer monomer = this.monomers[n];
        byte by = monomer.getProteinStructureType();
        int n3 = -1;
        int n4 = 0;
        for (int i = n; n4 < n2 && i < this.monomerCount; ++n4, ++i) {
            this.monomers[i].setStructure(null);
            n3 = this.monomers[i].setProteinStructureType(by, n3);
        }
    }

    public int[] getLeadAtomIndices() {
        if (this.leadAtomIndices == null) {
            this.leadAtomIndices = new int[this.monomerCount];
            this.invalidLead = true;
        }
        if (this.invalidLead) {
            int n = this.monomerCount;
            while (--n >= 0) {
                this.leadAtomIndices[n] = this.monomers[n].leadAtomIndex;
            }
            this.invalidLead = false;
        }
        return this.leadAtomIndices;
    }

    int getIndex(char c, int n) {
        int n2 = this.monomerCount;
        while (--n2 >= 0 && (this.monomers[n2].getChainID() != c || this.monomers[n2].getSeqcode() != n)) {
        }
        return n2;
    }

    final Point3f getLeadPoint(int n) {
        return this.monomers[n].getLeadAtom();
    }

    final Point3f getInitiatorPoint() {
        return this.monomers[0].getInitiatorAtom();
    }

    final Point3f getTerminatorPoint() {
        return this.monomers[this.monomerCount - 1].getTerminatorAtom();
    }

    void getLeadMidPoint(int n, Point3f point3f) {
        if (n == this.monomerCount) {
            --n;
        } else if (n > 0) {
            point3f.set((Tuple3f)this.getLeadPoint(n));
            point3f.add((Tuple3f)this.getLeadPoint(n - 1));
            point3f.scale(0.5f);
            return;
        }
        point3f.set((Tuple3f)this.getLeadPoint(n));
    }

    void getLeadPoint(int n, Point3f point3f) {
        if (n == this.monomerCount) {
            --n;
        }
        point3f.set((Tuple3f)this.getLeadPoint(n));
    }

    final Point3f getWingPoint(int n) {
        return this.monomers[n].getWingAtom();
    }

    public void getConformation(BitSet bitSet, int n) {
        Atom[] atomArray = this.model.getModelSet().atoms;
        int n2 = this.monomerCount;
        while (--n2 >= 0) {
            this.monomers[n2].getConformation(atomArray, bitSet, n);
        }
        this.recalculateLeadMidpointsAndWingVectors();
    }

    public void setConformation(BitSet bitSet) {
        Atom[] atomArray = this.model.getModelSet().atoms;
        int n = this.monomerCount;
        while (--n >= 0) {
            this.monomers[n].updateOffsetsForAlternativeLocations(atomArray, bitSet);
        }
        this.recalculateLeadMidpointsAndWingVectors();
    }

    public void recalculateLeadMidpointsAndWingVectors() {
        this.invalidControl = true;
        this.invalidLead = true;
        this.getLeadAtomIndices();
        this.resetHydrogenPoints();
        this.calcLeadMidpointsAndWingVectors();
    }

    protected void resetHydrogenPoints() {
    }

    public Point3f[] getLeadMidpoints() {
        if (this.leadMidpoints == null) {
            this.calcLeadMidpointsAndWingVectors();
        }
        return this.leadMidpoints;
    }

    Point3f[] getLeadPoints() {
        if (this.leadPoints == null) {
            this.calcLeadMidpointsAndWingVectors();
        }
        return this.leadPoints;
    }

    public Point3f[] getControlPoints(boolean bl, float f, boolean bl2) {
        if (bl2) {
            this.invalidControl = true;
        }
        return !bl ? this.leadMidpoints : (f == 0.0f ? this.leadPoints : this.getControlPoints(f));
    }

    protected Point3f[] getControlPoints(float f) {
        if (!this.invalidControl && f == this.sheetSmoothing) {
            return this.controlPoints;
        }
        this.getLeadPoints();
        Vector3f vector3f = new Vector3f();
        if (this.controlPoints == null) {
            this.controlPoints = new Point3f[this.monomerCount + 1];
        }
        if (!Float.isNaN(f)) {
            this.sheetSmoothing = f;
        }
        for (int i = 0; i < this.monomerCount; ++i) {
            this.controlPoints[i] = this.getControlPoint(i, vector3f);
        }
        this.controlPoints[this.monomerCount] = this.controlPoints[this.monomerCount - 1];
        this.invalidControl = false;
        return this.controlPoints;
    }

    protected Point3f getControlPoint(int n, Vector3f vector3f) {
        return this.leadPoints[n];
    }

    public final Vector3f[] getWingVectors() {
        if (this.leadMidpoints == null) {
            this.calcLeadMidpointsAndWingVectors();
        }
        return this.wingVectors;
    }

    private final void calcLeadMidpointsAndWingVectors() {
        Point3f point3f;
        if (this.leadMidpoints == null) {
            this.leadMidpoints = new Point3f[this.monomerCount + 1];
            this.leadPoints = new Point3f[this.monomerCount + 1];
            this.wingVectors = new Vector3f[this.monomerCount + 1];
            this.sheetSmoothing = Float.MIN_VALUE;
        }
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Vector3f vector3f4 = new Vector3f();
        this.leadMidpoints[0] = this.getInitiatorPoint();
        this.leadPoints[0] = point3f = this.getLeadPoint(0);
        Vector3f vector3f5 = null;
        for (int i = 1; i < this.monomerCount; ++i) {
            Point3f point3f2 = point3f;
            this.leadPoints[i] = point3f = this.getLeadPoint(i);
            Point3f point3f3 = new Point3f(point3f);
            point3f3.add((Tuple3f)point3f2);
            point3f3.scale(0.5f);
            this.leadMidpoints[i] = point3f3;
            if (!this.hasWingPoints) continue;
            vector3f.sub((Tuple3f)point3f, (Tuple3f)point3f2);
            vector3f2.sub((Tuple3f)point3f2, (Tuple3f)this.getWingPoint(i - 1));
            vector3f3.cross(vector3f, vector3f2);
            vector3f4.cross(vector3f, vector3f3);
            vector3f4.normalize();
            if (vector3f5 != null && (double)vector3f5.angle(vector3f4) > 1.5707963267948966) {
                vector3f4.scale(-1.0f);
            }
            vector3f5 = this.wingVectors[i] = new Vector3f(vector3f4);
        }
        this.leadPoints[this.monomerCount] = this.leadMidpoints[this.monomerCount] = this.getTerminatorPoint();
        if (!this.hasWingPoints) {
            if (this.monomerCount < 3) {
                this.wingVectors[1] = this.unitVectorX;
            } else {
                Vector3f vector3f6 = null;
                for (int i = 1; i < this.monomerCount; ++i) {
                    vector3f.sub((Tuple3f)this.leadMidpoints[i], (Tuple3f)this.leadPoints[i]);
                    vector3f2.sub((Tuple3f)this.leadPoints[i], (Tuple3f)this.leadMidpoints[i + 1]);
                    vector3f3.cross(vector3f, vector3f2);
                    vector3f3.normalize();
                    if (vector3f6 != null && (double)vector3f6.angle(vector3f3) > 1.5707963267948966) {
                        vector3f3.scale(-1.0f);
                    }
                    vector3f6 = this.wingVectors[i] = new Vector3f(vector3f3);
                }
            }
        }
        this.wingVectors[0] = this.wingVectors[1];
        this.wingVectors[this.monomerCount] = this.wingVectors[this.monomerCount - 1];
    }

    public void findNearestAtomIndex(int n, int n2, Atom[] atomArray, short[] sArray, int n3, BitSet bitSet) {
        int n4 = this.monomerCount;
        while (--n4 >= 0) {
            Atom atom;
            if ((this.monomers[n4].shapeVisibilityFlags & n3) == 0 || !(atom = this.monomers[n4].getLeadAtom()).isVisible(0) || bitSet != null && bitSet.get(atom.index) || sArray[n4] <= 0 && sArray[n4 + 1] <= 0) continue;
            this.monomers[n4].findNearestAtomIndex(n, n2, atomArray, sArray[n4], sArray[n4 + 1]);
        }
    }

    int getSelectedMonomerCount() {
        return this.selectedMonomerCount;
    }

    public void calcSelectedMonomersCount(BitSet bitSet) {
        this.selectedMonomerCount = 0;
        if (this.bsSelectedMonomers == null) {
            this.bsSelectedMonomers = new BitSet();
        }
        this.bsSelectedMonomers.clear();
        for (int i = 0; i < this.monomerCount; ++i) {
            if (!this.monomers[i].isSelected(bitSet)) continue;
            ++this.selectedMonomerCount;
            this.bsSelectedMonomers.set(i);
        }
    }

    boolean isMonomerSelected(int n) {
        return n >= 0 && this.bsSelectedMonomers.get(n);
    }

    public int getPolymerPointsAndVectors(int n, BitSet bitSet, List list, boolean bl, float f) {
        Point3f[] point3fArray = this.getControlPoints(bl, f, false);
        Vector3f[] vector3fArray = this.getWingVectors();
        int n2 = this.monomerCount;
        for (int i = 0; i < n2; ++i) {
            if (bitSet.get(this.monomers[i].leadAtomIndex)) {
                list.add(new Point3f[]{point3fArray[i], new Point3f((Tuple3f)vector3fArray[i])});
                n = i;
                continue;
            }
            if (n == 0x7FFFFFFE) continue;
            list.add(new Point3f[]{point3fArray[i], new Point3f((Tuple3f)vector3fArray[i])});
            n = 0x7FFFFFFE;
        }
        if (n + 1 < n2) {
            list.add(new Point3f[]{point3fArray[n + 1], new Point3f((Tuple3f)vector3fArray[n + 1])});
        }
        return n;
    }

    public String getSequence() {
        char[] cArray = new char[this.monomerCount];
        for (int i = 0; i < this.monomerCount; ++i) {
            cArray[i] = this.monomers[i].getGroup1();
        }
        return String.valueOf(cArray);
    }

    public Map getPolymerInfo(BitSet bitSet) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        ArrayList<Map> arrayList = new ArrayList<Map>();
        ArrayList<Hashtable<String, Integer>> arrayList2 = null;
        ProteinStructure proteinStructure = null;
        int n = 0;
        for (int i = 0; i < this.monomerCount; ++i) {
            if (!bitSet.get(this.monomers[i].leadAtomIndex)) continue;
            Map map = this.monomers[i].getMyInfo();
            map.put("monomerIndex", i);
            arrayList.add(map);
            ProteinStructure proteinStructure2 = this.getProteinStructure(i);
            if (proteinStructure2 == null || proteinStructure2 == proteinStructure) continue;
            Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
            proteinStructure = proteinStructure2;
            proteinStructure.getInfo(hashtable2);
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<Hashtable<String, Integer>>();
            }
            hashtable2.put("index", n++);
            arrayList2.add(hashtable2);
        }
        if (arrayList.size() > 0) {
            hashtable.put("sequence", this.getSequence());
            hashtable.put("monomers", arrayList);
            if (arrayList2 != null) {
                hashtable.put("structures", arrayList2);
            }
        }
        return hashtable;
    }

    public void getPolymerSequenceAtoms(int n, int n2, BitSet bitSet, BitSet bitSet2) {
        int n3 = n + n2;
        for (int i = n; i < this.monomerCount && i < n3; ++i) {
            this.monomers[i].getMonomerSequenceAtoms(bitSet, bitSet2);
        }
    }

    public ProteinStructure getProteinStructure(int n) {
        return this.monomers[n].getProteinStructure();
    }

    public boolean calcParameters() {
        this.haveParameters = true;
        return this.calcEtaThetaAngles() || this.calcPhiPsiAngles();
    }

    protected boolean calcEtaThetaAngles() {
        return false;
    }

    protected boolean calcPhiPsiAngles() {
        return false;
    }

    public static final void getPdbData(Viewer viewer, BioPolymer bioPolymer, char c, char c2, int n, int n2, boolean bl, BitSet bitSet, OutputStringBuffer outputStringBuffer, StringBuffer stringBuffer, BitSet bitSet2, boolean bl2, boolean bl3, BitSet bitSet3) {
        boolean bl4;
        boolean bl5;
        boolean bl6;
        boolean bl7 = c2 == 'C' || c2 == 'P';
        boolean bl8 = bl6 = c == 'R' || c == 'S' && bl7;
        if (bl6 && !bioPolymer.calcPhiPsiAngles()) {
            return;
        }
        boolean bl9 = bioPolymer instanceof AminoPolymer;
        boolean bl10 = c == 'r';
        boolean bl11 = bl5 = !bl6 && c == 'S';
        if (n2 == 2 && bl10) {
            c = (char)119;
        }
        if (bl5) {
            n2 = 2;
        }
        boolean bl12 = c == 'S';
        boolean bl13 = bl4 = "rcpCP".indexOf(c2) >= 0;
        if (Logger.debugging && (bl5 || bl7)) {
            Logger.debug((String)("For straightness calculation: useQuaternionStraightness = " + bl12 + " and quaternionFrame = " + c2));
        }
        if (bl2 && !bl) {
            outputStringBuffer.append("REMARK   6    AT GRP CH RESNO  ");
            switch (c) {
                default: {
                    outputStringBuffer.append("x*10___ y*10___ z*10___      w*10__       ");
                    break;
                }
                case 'x': {
                    outputStringBuffer.append("y*10___ z*10___ w*10___      x*10__       ");
                    break;
                }
                case 'y': {
                    outputStringBuffer.append("z*10___ w*10___ x*10___      y*10__       ");
                    break;
                }
                case 'z': {
                    outputStringBuffer.append("w*10___ x*10___ y*10___      z*10__       ");
                    break;
                }
                case 'R': {
                    if (bl4) {
                        outputStringBuffer.append("phi____ psi____ theta         Straightness");
                        break;
                    }
                    outputStringBuffer.append("phi____ psi____ omega-180    PartialCharge");
                }
            }
            outputStringBuffer.append("    Sym   q0_______ q1_______ q2_______ q3_______");
            outputStringBuffer.append("  theta_  aaX_______ aaY_______ aaZ_______");
            if (c != 'R') {
                outputStringBuffer.append("  centerX___ centerY___ centerZ___");
            }
            if (c2 == 'n') {
                outputStringBuffer.append("  NHX_______ NHY_______ NHZ_______");
            }
            outputStringBuffer.append("\n\n");
        }
        float f = c == 'R' ? 1.0f : 10.0f;
        bl3 = false;
        int n3 = 0;
        while (n3 < (bl3 ? 2 : 1)) {
            for (int i = 0; i < (n < 1 ? 1 : n); ++i) {
                BioPolymer.getData(viewer, i, n, bioPolymer, c, c2, n2, bitSet, bitSet2, bitSet3, bl, bl6, bl7, bl12, bl4, bl5, f, bl9, bl10, outputStringBuffer, stringBuffer);
            }
            ++n3;
            f *= -1.0f;
        }
    }

    private static void getData(Viewer viewer, int n, int n2, BioPolymer bioPolymer, char c, char c2, int n3, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, float f, boolean bl7, boolean bl8, OutputStringBuffer outputStringBuffer, StringBuffer stringBuffer) {
        String string = n3 > 0 ? "dq" + (n3 == 2 ? "2" : "") : "q";
        Atom atom = null;
        Quaternion quaternion = null;
        Quaternion quaternion2 = null;
        Quaternion quaternion3 = null;
        Quaternion quaternion4 = null;
        Atom atom2 = null;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        String string2 = "";
        float f6 = Float.NaN;
        float f7 = Float.NaN;
        int n4 = n2 <= 1 ? 1 : n2;
        for (int i = n; i < bioPolymer.monomerCount; i += n4) {
            Quaternion quaternion5;
            AminoMonomer aminoMonomer;
            Monomer monomer = bioPolymer.monomers[i];
            if (bitSet != null && !bitSet.get(monomer.leadAtomIndex)) continue;
            Atom atom3 = monomer.getLeadAtom();
            String string3 = monomer.getUniqueID();
            if (bl2) {
                float f8;
                if (c == 'S') {
                    monomer.setGroupParameter(1112539144, Float.NaN);
                }
                f2 = monomer.getGroupParameter(1112539142);
                f3 = monomer.getGroupParameter(1112539143);
                f4 = monomer.getGroupParameter(1112539141);
                if (f4 < -90.0f) {
                    f4 += 360.0f;
                }
                if (Float.isNaN(f2) || Float.isNaN(f3) || Float.isNaN(f4 -= 180.0f)) {
                    if (bitSet == null) continue;
                    bitSet.clear(atom3.getIndex());
                    continue;
                }
                float f9 = bl5 ? bioPolymer.calculateRamachandranHelixAngle(i, c2) : 0.0f;
                float f10 = f8 = bl3 || bl5 ? BioPolymer.getStraightness((float)Math.cos((double)(f9 / 2.0f / 180.0f) * Math.PI)) : 0.0f;
                if (c == 'S') {
                    monomer.setGroupParameter(1112539144, f8);
                    continue;
                }
                if (bl) {
                    if (bitSet2 != null && !bitSet2.get(atom3.getIndex())) continue;
                    aminoMonomer = (AminoMonomer)monomer;
                    outputStringBuffer.append("draw phi" + string3 + " ARROW ARC ").append(Escape.escape((Tuple3f)aminoMonomer.getNitrogenAtom())).append(Escape.escape((Tuple3f)atom3)).append(Escape.escape((Tuple3f)aminoMonomer.getCarbonylCarbonAtom())).append("{" + -f2 + " " + f2 + " 0.5} \"phi = " + (int)f2 + "\"").append(" color ").append(qColor[2]).append('\n');
                    outputStringBuffer.append("draw psi" + string3 + " ARROW ARC ").append(Escape.escape((Tuple3f)atom3)).append(Escape.escape((Tuple3f)aminoMonomer.getCarbonylCarbonAtom())).append(Escape.escape((Tuple3f)aminoMonomer.getNitrogenAtom())).append("{0 " + f3 + " 0.5} \"psi = " + (int)f3 + "\"").append(" color ").append(qColor[1]).append('\n');
                    outputStringBuffer.append("draw planeNCC" + string3 + " ").append(Escape.escape((Tuple3f)aminoMonomer.getNitrogenAtom())).append(Escape.escape((Tuple3f)atom3)).append(Escape.escape((Tuple3f)aminoMonomer.getCarbonylCarbonAtom())).append(" color ").append(qColor[0]).append('\n');
                    outputStringBuffer.append("draw planeCNC" + string3 + " ").append(Escape.escape((Tuple3f)((AminoMonomer)bioPolymer.monomers[i - 1]).getCarbonylCarbonAtom())).append(Escape.escape((Tuple3f)aminoMonomer.getNitrogenAtom())).append(Escape.escape((Tuple3f)atom3)).append(" color ").append(qColor[1]).append('\n');
                    outputStringBuffer.append("draw planeCCN" + string3 + " ").append(Escape.escape((Tuple3f)atom3)).append(Escape.escape((Tuple3f)aminoMonomer.getCarbonylCarbonAtom())).append(Escape.escape((Tuple3f)((AminoMonomer)bioPolymer.monomers[i + 1]).getNitrogenAtom())).append(" color ").append(qColor[2]).append('\n');
                    continue;
                }
                if (Float.isNaN(f9)) {
                    string2 = "";
                    if (bl5) {
                        continue;
                    }
                } else {
                    quaternion5 = new Quaternion((Tuple3f)new Point3f(1.0f, 0.0f, 0.0f), f9);
                    string2 = quaternion5.getInfo();
                    if (bl5) {
                        f4 = f9;
                        f5 = f8;
                    } else {
                        f5 = atom3.getPartialCharge();
                    }
                }
            } else {
                quaternion5 = monomer.getQuaternion(c2);
                if (quaternion5 != null) {
                    quaternion5.setRef(quaternion4);
                    quaternion4 = new Quaternion(quaternion5);
                }
                if (n3 == 2) {
                    monomer.setGroupParameter(1112539144, Float.NaN);
                }
                if (quaternion5 == null) {
                    quaternion = null;
                    quaternion4 = null;
                } else if (n3 > 0) {
                    Atom atom4 = atom3;
                    Quaternion quaternion6 = quaternion5;
                    if (quaternion == null) {
                        quaternion5 = null;
                        quaternion3 = null;
                    } else {
                        quaternion2 = bl8 ? quaternion.leftDifference(quaternion5) : quaternion5.rightDifference(quaternion);
                        if (n3 == 1) {
                            quaternion5 = quaternion2;
                        } else if (quaternion3 == null) {
                            quaternion5 = null;
                        } else {
                            quaternion5 = quaternion2.rightDifference(quaternion3);
                            f6 = BioPolymer.getQuaternionStraightness(string3, quaternion3, quaternion2);
                            f7 = BioPolymer.get3DStraightness(string3, quaternion3, quaternion2);
                            atom.getGroup().setGroupParameter(1112539144, bl4 ? f6 : f7);
                        }
                        quaternion3 = quaternion2;
                    }
                    atom = atom4;
                    quaternion = quaternion6;
                }
                if (quaternion5 == null) {
                    atom2 = null;
                    continue;
                }
                switch (c) {
                    default: {
                        f2 = quaternion5.q1;
                        f3 = quaternion5.q2;
                        f4 = quaternion5.q3;
                        f5 = quaternion5.q0;
                        break;
                    }
                    case 'x': {
                        f2 = quaternion5.q0;
                        f3 = quaternion5.q1;
                        f4 = quaternion5.q2;
                        f5 = quaternion5.q3;
                        break;
                    }
                    case 'y': {
                        f2 = quaternion5.q3;
                        f3 = quaternion5.q0;
                        f4 = quaternion5.q1;
                        f5 = quaternion5.q2;
                        break;
                    }
                    case 'z': {
                        f2 = quaternion5.q2;
                        f3 = quaternion5.q3;
                        f4 = quaternion5.q0;
                        f5 = quaternion5.q1;
                    }
                }
                Point3f point3f = monomer.getQuaternionFrameCenter(c2);
                if (point3f == null) {
                    point3f = new Point3f();
                }
                if (bl) {
                    if (bitSet2 != null && !bitSet2.get(atom3.getIndex())) continue;
                    int n5 = (int)(Math.acos(f5) * 360.0 / Math.PI);
                    if (n3 == 0) {
                        outputStringBuffer.append(quaternion5.draw(string, string3, point3f, 1.0f));
                        if (c2 == 'n' && bl7 && (aminoMonomer = ((AminoMonomer)monomer).getNitrogenHydrogenPoint()) != null) {
                            outputStringBuffer.append("draw " + string + "nh" + string3 + " width 0.1 " + Escape.escape((Tuple3f)aminoMonomer) + "\n");
                        }
                    }
                    if (n3 == 1) {
                        outputStringBuffer.append((String)monomer.getHelixData(135184, c2, n2)).append('\n');
                        continue;
                    }
                    outputStringBuffer.append("draw " + string + "a" + string3 + " VECTOR " + Escape.escape((Tuple3f)point3f) + " {" + f2 * 2.0f + "," + f3 * 2.0f + "," + f4 * 2.0f + "}" + " \">" + n5 + "\"").append(" color ").append(qColor[n3]).append('\n');
                    continue;
                }
                string2 = quaternion5.getInfo() + TextFormat.sprintf((String)"  %10.5p %10.5p %10.5p", (Object[])new Object[]{point3f});
                if (c2 == 'n' && bl7) {
                    string2 = string2 + TextFormat.sprintf((String)"  %10.5p %10.5p %10.5p", (Object[])new Object[]{((AminoMonomer)monomer).getNitrogenHydrogenPoint()});
                } else if (n3 == 2 && !Float.isNaN(f6)) {
                    string2 = string2 + TextFormat.sprintf((String)" %10.5f %10.5f", (Object[])new Object[]{new float[]{f6, f7}});
                }
            }
            if (outputStringBuffer == null) continue;
            bitSet3.set(((Monomer)atom3.getGroup()).leadAtomIndex);
            outputStringBuffer.append(LabelToken.formatLabel((Viewer)viewer, (Atom)atom3, (String)"ATOM  %5i %4a%1A%3n %1c%4R%1E   "));
            outputStringBuffer.append(TextFormat.sprintf((String)"%8.2f%8.2f%8.2f      %6.3f          %2s    %s\n", (Object[])new Object[]{atom3.getElementSymbol(false).toUpperCase(), string2, new float[]{f2 * f, f3 * f, f4 * f, f5 * f}}));
            if (atom2 != null && atom2.getPolymerIndexInModel() == atom3.getPolymerIndexInModel()) {
                stringBuffer.append("CONECT").append(TextFormat.formatString((String)"%5i", (String)"i", (int)atom2.getAtomNumber())).append(TextFormat.formatString((String)"%5i", (String)"i", (int)atom3.getAtomNumber())).append('\n');
            }
            atom2 = atom3;
        }
    }

    protected float calculateRamachandranHelixAngle(int n, char c) {
        return Float.NaN;
    }

    private static float get3DStraightness(String string, Quaternion quaternion, Quaternion quaternion2) {
        return quaternion.getNormal().dot(quaternion2.getNormal());
    }

    private static float getQuaternionStraightness(String string, Quaternion quaternion, Quaternion quaternion2) {
        return BioPolymer.getStraightness(quaternion.dot(quaternion2));
    }

    private static float getStraightness(float f) {
        return (float)(1.0 - 2.0 * Math.acos(Math.abs(f)) / Math.PI);
    }

    public boolean isDna() {
        return this.monomerCount > 0 && this.monomers[0].isDna();
    }

    public boolean isRna() {
        return this.monomerCount > 0 && this.monomers[0].isRna();
    }

    public void getRangeGroups(int n, BitSet bitSet, BitSet bitSet2) {
        int n2;
        BitSet bitSet3 = new BitSet();
        for (n2 = 0; n2 < this.monomerCount; ++n2) {
            int n3 = bitSet.nextSetBit(this.monomers[n2].getFirstAtomIndex());
            if (n3 < 0 || n3 > this.monomers[n2].getLastAtomIndex()) continue;
            bitSet3.set(Math.max(0, n2 - n), n2 + n + 1);
            n2 += n - 1;
        }
        n2 = bitSet3.nextSetBit(0);
        while (n2 >= 0 && n2 < this.monomerCount) {
            bitSet2.set(this.monomers[n2].getFirstAtomIndex(), this.monomers[n2].getLastAtomIndex() + 1);
            n2 = bitSet3.nextSetBit(n2 + 1);
        }
    }

    public String calculateStructures(Polymer[] polymerArray, int n, List list, boolean bl, boolean bl2, boolean bl3) {
        return AminoPolymer.calculateStructuresDssp(polymerArray, n, list, bl, bl2, bl3);
    }
}

