/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple3i;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.shape.MeshRenderer;
import org.jmol.shapesurface.Isosurface;
import org.jmol.shapesurface.IsosurfaceMesh;

public class IsosurfaceRenderer
extends MeshRenderer {
    private boolean iShowNormals;
    protected boolean iHideBackground;
    protected boolean isBicolorMap;
    protected short backgroundColix;
    protected int nError = 0;
    protected float[] vertexValues;
    protected IsosurfaceMesh imesh;
    private final Point3f ptTemp = new Point3f();
    private final Point3i ptTempi = new Point3i();

    protected void initRenderer() {
        super.initRenderer();
    }

    protected void render() {
        this.iShowNormals = this.viewer.getTestFlag4();
        Isosurface isosurface = (Isosurface)this.shape;
        int n = this.viewer.getNavigationMode() ? this.g3d.getSlab() : Integer.MAX_VALUE;
        int n2 = isosurface.meshCount;
        while (--n2 >= 0) {
            this.imesh = (IsosurfaceMesh)isosurface.meshes[n2];
            this.g3d.setTranslucentCoverOnly(this.imesh.frontOnly);
            this.thePlane = this.imesh.jvxlData.jvxlPlane;
            if (n != Integer.MAX_VALUE && this.imesh.isSolvent) {
                this.g3d.setSlab((int)this.viewer.getNavigationOffset().z);
                this.render1(this.imesh);
                this.g3d.setSlab(n);
            } else {
                this.render1(this.imesh);
            }
            this.g3d.setTranslucentCoverOnly(false);
        }
    }

    protected void render2(boolean bl) {
        if (this.imesh.jvxlData.colorDensity) {
            this.renderPoints();
            return;
        }
        switch (this.imesh.dataType) {
            case 70: {
                this.renderLonePair(false);
                return;
            }
            case 71: {
                this.renderLonePair(true);
                return;
            }
        }
        this.isBicolorMap = this.imesh.jvxlData.isBicolorMap;
        super.render2(bl);
        if (!this.g3d.setColix((short)4)) {
            return;
        }
        if (this.imesh.showContourLines) {
            this.renderContourLines();
        }
    }

    private void renderLonePair(boolean bl) {
        this.pt2f.set((Tuple3f)this.imesh.vertices[1]);
        this.viewer.transformPoint(this.pt2f, this.pt2f);
        short s = this.viewer.scaleToScreen((int)this.pt2f.z, 100);
        if (s < 1) {
            s = 1;
        }
        if (!bl) {
            Vector3f vector3f = new Vector3f();
            Vector3f vector3f2 = new Vector3f();
            this.pt1f.set((Tuple3f)this.imesh.vertices[0]);
            this.viewer.transformPoint(this.pt1f, this.pt1f);
            vector3f.sub((Tuple3f)this.pt2f, (Tuple3f)this.pt1f);
            vector3f2.set(vector3f.x, vector3f.y, vector3f.z + 1.0f);
            vector3f2.cross(vector3f2, vector3f);
            vector3f2.normalize();
            float f = this.viewer.scaleToScreen((int)this.pt1f.z, 100);
            vector3f2.scale(f);
            this.pt1f.set((Tuple3f)this.pt2f);
            this.pt1f.add((Tuple3f)vector3f2);
            this.pt2f.sub((Tuple3f)vector3f2);
            this.screens[0].set((int)this.pt1f.x, (int)this.pt1f.y, (int)this.pt1f.z);
            this.g3d.fillSphere((int)s, this.screens[0]);
        }
        this.screens[1].set((int)this.pt2f.x, (int)this.pt2f.y, (int)this.pt2f.z);
        this.g3d.fillSphere((int)s, this.screens[1]);
    }

    private void renderContourLines() {
        Vector[] vectorArray = this.imesh.getContours();
        if (vectorArray == null) {
            return;
        }
        int n = vectorArray.length;
        block0: while (--n >= 0) {
            Vector vector = vectorArray[n];
            if (vector.size() < 6) continue;
            short s = this.colix = this.imesh.meshColix == 0 ? ((short[])vector.get(3))[0] : this.imesh.meshColix;
            if (!this.g3d.setColix(this.colix)) {
                return;
            }
            int n2 = vector.size() - 1;
            for (int i = 6; i < n2; ++i) {
                Point3f point3f = (Point3f)vector.get(i);
                Point3f point3f2 = (Point3f)vector.get(++i);
                this.viewer.transformPoint(point3f, this.pt1i);
                this.viewer.transformPoint(point3f2, this.pt2i);
                if (Float.isNaN(point3f.x) || Float.isNaN(point3f2.x)) continue block0;
                this.pt1i.z -= 2;
                this.pt2i.z -= 2;
                this.g3d.drawLine(this.pt1i, this.pt2i);
            }
        }
    }

    protected void renderPoints() {
        int n;
        int n2;
        int n3 = this.imesh.vertexIncrement;
        int n4 = this.viewer.getScreenDim() / 100;
        boolean bl = this.viewer.getTestFlag3();
        int n5 = bl ? this.viewer.getScreenWidth() / 2 : 0;
        int n6 = n2 = bl ? this.viewer.getScreenHeight() / 2 : 0;
        if (bl) {
            this.g3d.setFont(this.g3d.getFontFid("Monospaced", 24.0f));
        }
        int n7 = n = !this.imesh.hasGridPoints || this.imesh.firstRealVertex < 0 ? 0 : this.imesh.firstRealVertex;
        while (n < this.vertexCount) {
            if (!(this.vertexValues != null && Float.isNaN(this.vertexValues[n]) || this.frontOnly && this.transformedVectors[this.normixes[n]].z < 0.0f || this.imesh.vertexColixes != null && !this.g3d.setColix(this.imesh.vertexColixes[n]))) {
                if (bl && this.screens[n].z > 10 && Math.abs(this.screens[n].x - n5) < 50 && Math.abs(this.screens[n].y - n2) < 50) {
                    String string = n + (this.imesh.isColorSolid ? "" : " " + this.imesh.vertexValues[n]);
                    this.g3d.drawStringNoSlab(string, null, this.screens[n].x, this.screens[n].y, this.screens[n].z);
                }
                this.g3d.fillSphere(n4, this.screens[n]);
            }
            n += n3;
        }
        if (n3 != 3) {
            return;
        }
        this.g3d.setColix(this.isTranslucent ? Graphics3D.getColixTranslucent((short)12, (boolean)true, (float)0.5f) : (short)12);
        for (n = 1; n < this.vertexCount; n += 3) {
            this.g3d.fillCylinder((byte)3, n4 / 4, this.screens[n], this.screens[n + 1]);
        }
        this.g3d.setColix(this.isTranslucent ? Graphics3D.getColixTranslucent((short)21, (boolean)true, (float)0.5f) : (short)21);
        for (n = 1; n < this.vertexCount; n += 3) {
            this.g3d.fillSphere(n4, this.screens[n]);
        }
        this.g3d.setColix(this.isTranslucent ? Graphics3D.getColixTranslucent((short)7, (boolean)true, (float)0.5f) : (short)7);
        for (n = 2; n < this.vertexCount; n += 3) {
            this.g3d.fillSphere(n4, this.screens[n]);
        }
    }

    protected void renderTriangles(boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        int[][] nArray = this.imesh.polygonIndexes;
        this.colix = !bl && this.imesh.meshColix != 0 ? this.imesh.meshColix : this.imesh.colix;
        short[] sArray = (short[])(!bl && this.imesh.meshColix != 0 ? null : this.imesh.vertexColixes);
        this.g3d.setColix(this.colix);
        boolean bl5 = bl3;
        if (bl5) {
            if (this.frontOnly && bl) {
                this.frontOnly = false;
            }
            this.bsFaces.clear();
        }
        if (this.exportType == 1) {
            this.frontOnly = false;
        }
        boolean bl6 = sArray == null || this.imesh.isColorSolid;
        boolean bl7 = sArray == null || !bl && this.imesh.meshColix != 0;
        boolean bl8 = this.imesh.jvxlData.jvxlPlane != null;
        short s = this.colix;
        if (bl8 && !bl6 && !bl && this.imesh.fillTriangles) {
            bl6 = true;
            s = 4;
        }
        boolean bl9 = bl4 = bl6 && this.imesh.polygonColixes != null;
        if (bl4 && !bl && this.imesh.fillTriangles) {
            bl4 = false;
        }
        short[] sArray2 = this.imesh.jvxlData.contourColixes;
        int n = this.imesh.polygonCount;
        while (--n >= 0) {
            short s2;
            short s3;
            short s4;
            int[] nArray2 = nArray[n];
            if (nArray2 == null) continue;
            int n2 = nArray2[0];
            int n3 = nArray2[1];
            int n4 = nArray2[2];
            if (this.imesh.thisSet >= 0 && this.imesh.vertexSets[n2] != this.imesh.thisSet) continue;
            short s5 = this.normixes[n2];
            short s6 = this.normixes[n3];
            short s7 = this.normixes[n4];
            int n5 = 7;
            if (this.frontOnly) {
                if (this.transformedVectors[s5].z < 0.0f) {
                    n5 ^= 1;
                }
                if (this.transformedVectors[s6].z < 0.0f) {
                    n5 ^= 2;
                }
                if (this.transformedVectors[s7].z < 0.0f) {
                    n5 ^= 4;
                }
            }
            if (bl && n5 == 0) continue;
            if (bl6) {
                if (bl4 && n < this.imesh.polygonColixes.length) {
                    short s8 = this.imesh.polygonColixes[n];
                    if (s8 == 0) continue;
                    s = s8;
                }
                s3 = s4 = s;
                s2 = s4;
            } else {
                s2 = sArray[n2];
                s3 = sArray[n3];
                s4 = sArray[n4];
                if (this.isBicolorMap && (s2 != s3 || s3 != s4)) continue;
            }
            if (bl) {
                if (bl5) {
                    this.bsFaces.set(n);
                    continue;
                }
                if (bl2) {
                    this.g3d.fillTriangle(this.screens[n2], s2, s5, this.screens[n3], s3, s6, this.screens[n4], s4, s7, 0.1f);
                } else {
                    this.g3d.fillTriangle(this.screens[n2], s2, s5, this.screens[n3], s3, s6, this.screens[n4], s4, s7);
                }
                if (!this.iShowNormals) continue;
                this.renderNormals();
                continue;
            }
            n5 &= nArray2[3];
            if (bl2) {
                n5 = 7;
            }
            if (n5 == 0) continue;
            this.pt1i.set((Tuple3i)this.screens[n2]);
            this.pt2i.set((Tuple3i)this.screens[n3]);
            this.pt3i.set((Tuple3i)this.screens[n4]);
            this.pt1i.z -= 2;
            this.pt2i.z -= 2;
            this.pt3i.z -= 2;
            if (!bl7) {
                if (bl4) {
                    this.g3d.setColix(this.mesh.fillTriangles ? (short)4 : sArray2[nArray2[4] % sArray2.length]);
                } else {
                    this.g3d.drawTriangle(this.pt1i, s2, this.pt2i, s3, this.pt3i, s4, n5);
                    continue;
                }
            }
            this.g3d.drawTriangle(this.pt1i, this.pt2i, this.pt3i, n5);
        }
        if (bl5) {
            this.exportSurface();
        }
    }

    private void renderNormals() {
        if (!this.g3d.setColix((short)8)) {
            return;
        }
        this.g3d.setFont(this.g3d.getFontFid("Monospaced", 24.0f));
        int n = this.vertexCount;
        while (--n >= 0) {
            if (this.vertexValues == null || Float.isNaN(this.vertexValues[n])) continue;
            this.ptTemp.set((Tuple3f)this.mesh.vertices[n]);
            short s = this.mesh.normixes[n];
            if (s < 0) continue;
            this.ptTemp.add((Tuple3f)Graphics3D.getNormixVector((short)s));
            this.viewer.transformPoint(this.ptTemp, this.ptTempi);
            this.g3d.drawLine(this.screens[n], this.ptTempi);
            this.g3d.drawStringNoSlab("" + s, null, this.ptTempi.x, this.ptTempi.y, this.ptTempi.z);
        }
    }
}

