/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.api.VolumeDataInterface;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.TextFormat;

public class AtomSetCollection {
    private String fileTypeName;
    private String collectionName;
    private Hashtable atomSetCollectionAuxiliaryInfo = new Hashtable();
    private static final String[] globalBooleans = new String[]{"someModelsHaveFractionalCoordinates", "someModelsHaveSymmetry", "someModelsHaveUnitcells", "isPDB"};
    private static final int GLOBAL_FRACTCOORD = 0;
    private static final int GLOBAL_SYMMETRY = 1;
    private static final int GLOBAL_latticeCells = 2;
    public static final String[] notionalUnitcellTags = new String[]{"a", "b", "c", "alpha", "beta", "gamma"};
    private int atomCount;
    private Atom[] atoms = new Atom[256];
    private int bondCount;
    private Bond[] bonds = new Bond[256];
    private int structureCount;
    private Structure[] structures = new Structure[16];
    private int atomSetCount;
    private int currentAtomSetIndex = -1;
    private int[] atomSetNumbers = new int[16];
    private int[] atomSetAtomCounts = new int[16];
    private int[] atomSetBondCounts = new int[16];
    private Hashtable[] atomSetAuxiliaryInfo = new Hashtable[16];
    private int[] latticeCells;
    public String errorMessage;
    boolean coordinatesAreFractional;
    private boolean isTrajectory;
    private int trajectoryStepCount = 0;
    private Point3f[] trajectoryStep;
    private Vector trajectorySteps;
    boolean doFixPeriodic;
    float[] notionalUnitCell = new float[6];
    private boolean allowMultiple;
    Vector vConnect;
    int connectNextAtomIndex = 0;
    int connectNextAtomSet = 0;
    int[] connectLast;
    float symmetryRange;
    SymmetryInterface symmetry;
    boolean haveUnitCell = false;
    boolean doNormalize = true;
    boolean doPackUnitCell = false;
    private float rminx;
    private float rminy;
    private float rminz;
    private float rmaxx;
    private float rmaxy;
    private float rmaxz;
    private final Point3f ptOffset = new Point3f();
    private Point3f unitCellOffset;
    private Point3i minXYZ;
    private Point3i maxXYZ;
    private boolean needEllipsoids;
    Point3f[] cartesians;
    int bondCount0;
    int bondIndex0;
    boolean applySymmetryToBonds = false;
    boolean checkSpecial = true;
    private final Point3f ptTemp = new Point3f();
    private final Point3f ptTemp1 = new Point3f();
    private final Point3f ptTemp2 = new Point3f();
    Hashtable atomSymbolicMap = new Hashtable();
    boolean haveMappedSerials;
    VolumeDataInterface vd;

    public String getFileTypeName() {
        return this.fileTypeName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String string) {
        if (string != null) {
            if ((string = string.trim()).length() == 0) {
                return;
            }
            this.collectionName = string;
        }
    }

    public Hashtable getAtomSetCollectionAuxiliaryInfo() {
        return this.atomSetCollectionAuxiliaryInfo;
    }

    public int getAtomCount() {
        return this.atomCount;
    }

    public Atom[] getAtoms() {
        return this.atoms;
    }

    public Atom getAtom(int n) {
        return this.atoms[n];
    }

    public int getBondCount() {
        return this.bondCount;
    }

    public Bond[] getBonds() {
        return this.bonds;
    }

    public Bond getBond(int n) {
        return this.bonds[n];
    }

    public int getStructureCount() {
        return this.structureCount;
    }

    public Structure[] getStructures() {
        return this.structures;
    }

    public int getAtomSetCount() {
        return this.atomSetCount;
    }

    public int getCurrentAtomSetIndex() {
        return this.currentAtomSetIndex;
    }

    public void setCurrentAtomSetIndex(int n) {
        this.currentAtomSetIndex = n;
    }

    public void setDoFixPeriodic() {
        this.doFixPeriodic = true;
    }

    public AtomSetCollection(String string, AtomSetCollectionReader atomSetCollectionReader) {
        this.fileTypeName = string;
        this.allowMultiple = atomSetCollectionReader == null || atomSetCollectionReader.desiredVibrationNumber < 0;
        Properties properties = new Properties();
        properties.put("PATH_KEY", ".PATH");
        properties.put("PATH_SEPARATOR", SmarterJmolAdapter.PATH_SEPARATOR);
        this.setAtomSetCollectionAuxiliaryInfo("properties", properties);
    }

    public AtomSetCollection(AtomSetCollection[] atomSetCollectionArray) {
        this("Array", null);
        this.setAtomSetCollectionAuxiliaryInfo("isMultiFile", Boolean.TRUE);
        for (int i = 0; i < atomSetCollectionArray.length; ++i) {
            this.appendAtomSetCollection(i, atomSetCollectionArray[i]);
        }
    }

    public AtomSetCollection(Vector vector) {
        this("Array", null);
        this.setAtomSetCollectionAuxiliaryInfo("isMultiFile", Boolean.TRUE);
        this.appendAtomSetCollection(vector);
    }

    private void appendAtomSetCollection(Vector vector) {
        int n = vector.size();
        if (n == 0) {
            this.errorMessage = "No file found!";
            return;
        }
        for (int i = 0; i < n; ++i) {
            Object e = vector.elementAt(i);
            if (e instanceof Vector) {
                this.appendAtomSetCollection((Vector)e);
                continue;
            }
            this.appendAtomSetCollection(i, (AtomSetCollection)e);
        }
    }

    public void setTrajectory() {
        if (!this.isTrajectory) {
            this.trajectorySteps = new Vector();
        }
        this.isTrajectory = true;
        this.addTrajectoryStep();
    }

    protected void appendAtomSetCollection(int n, AtomSetCollection atomSetCollection) {
        int n2;
        int n3 = this.atomCount;
        int n4 = 0;
        this.setAtomSetCollectionAuxiliaryInfo("loadState", atomSetCollection.getAtomSetCollectionAuxiliaryInfo("loadState"));
        for (n2 = 0; n2 < atomSetCollection.atomSetCount; ++n2) {
            int n5;
            this.newAtomSet();
            this.atomSetAuxiliaryInfo[this.currentAtomSetIndex] = atomSetCollection.atomSetAuxiliaryInfo[n2];
            this.setAtomSetAuxiliaryInfo("title", atomSetCollection.collectionName);
            this.setAtomSetName(atomSetCollection.getAtomSetName(n2));
            for (n5 = 0; n5 < atomSetCollection.atomSetAtomCounts[n2]; ++n5) {
                try {
                    this.newCloneAtom(atomSetCollection.atoms[n4]);
                }
                catch (Exception exception) {
                    this.errorMessage = "appendAtomCollection error: " + exception;
                }
                ++n4;
            }
            for (n5 = 0; n5 < atomSetCollection.structureCount; ++n5) {
                if (atomSetCollection.structures[n5].modelIndex != n2 && atomSetCollection.structures[n5].modelIndex != -1) continue;
                this.addStructure(atomSetCollection.structures[n5]);
            }
            this.atomSetNumbers[this.currentAtomSetIndex] = (n + 1) * 1000000 + atomSetCollection.atomSetNumbers[n2];
        }
        for (n2 = 0; n2 < atomSetCollection.bondCount; ++n2) {
            Bond bond = atomSetCollection.bonds[n2];
            this.addNewBond(bond.atomIndex1 + n3, bond.atomIndex2 + n3, bond.order);
        }
        n2 = globalBooleans.length;
        while (--n2 >= 0) {
            if (!Boolean.TRUE.equals(atomSetCollection.getAtomSetCollectionAuxiliaryInfo(globalBooleans[n2]))) continue;
            this.setGlobalBoolean(n2);
        }
    }

    void setNoAutoBond() {
        this.setAtomSetCollectionAuxiliaryInfo("noAutoBond", Boolean.TRUE);
    }

    void finish() {
        this.atoms = null;
        this.atomSetAtomCounts = new int[16];
        this.atomSetAuxiliaryInfo = new Hashtable[16];
        this.atomSetCollectionAuxiliaryInfo = new Hashtable();
        this.atomSetCount = 0;
        this.atomSetNumbers = new int[16];
        this.atomSymbolicMap = new Hashtable();
        this.bonds = null;
        this.cartesians = null;
        this.connectLast = null;
        this.currentAtomSetIndex = -1;
        this.latticeCells = null;
        this.notionalUnitCell = null;
        this.symmetry = null;
        this.structures = new Structure[16];
        this.structureCount = 0;
        this.trajectoryStep = null;
        this.trajectorySteps = null;
        this.vConnect = null;
        this.vd = null;
    }

    void freeze() {
        if (this.isTrajectory) {
            this.finalizeTrajectory(true);
        }
        this.getAltLocLists();
        this.getInsertionLists();
        for (int i = 0; i < this.atomSetCount; ++i) {
            this.setAtomSetAuxiliaryInfo("initialAtomCount", new Integer(this.atomSetAtomCounts[i]), i);
            this.setAtomSetAuxiliaryInfo("initialBondCount", new Integer(this.atomSetBondCounts[i]), i);
        }
    }

    public void discardPreviousAtoms() {
        int n = this.atomCount;
        while (--n >= 0) {
            this.atoms[n] = null;
        }
        this.atomCount = 0;
        this.clearSymbolicMap();
        this.atomSetCount = 0;
        this.currentAtomSetIndex = -1;
        n = this.atomSetAuxiliaryInfo.length;
        while (--n >= 0) {
            this.atomSetAtomCounts[n] = 0;
            this.atomSetBondCounts[n] = 0;
            this.atomSetAuxiliaryInfo[n] = null;
        }
    }

    public void removeAtomSet() {
        if (this.currentAtomSetIndex < 0) {
            return;
        }
        --this.currentAtomSetIndex;
        --this.atomSetCount;
    }

    Atom newCloneAtom(Atom atom) throws Exception {
        Atom atom2 = atom.cloneAtom();
        this.addAtom(atom2);
        return atom2;
    }

    public void cloneFirstAtomSet() throws Exception {
        if (!this.allowMultiple) {
            return;
        }
        this.newAtomSet();
        int n = this.atomSetAtomCounts[0];
        for (int i = 0; i < n; ++i) {
            this.newCloneAtom(this.atoms[i]);
        }
    }

    public void cloneFirstAtomSetWithBonds(int n) throws Exception {
        if (!this.allowMultiple) {
            return;
        }
        this.cloneFirstAtomSet();
        int n2 = this.atomSetAtomCounts[0];
        for (int i = 0; i < n; ++i) {
            Bond bond = this.bonds[this.bondCount - n];
            this.addNewBond(bond.atomIndex1 + n2, bond.atomIndex2 + n2, bond.order);
        }
    }

    public void cloneLastAtomSet() throws Exception {
        this.cloneLastAtomSet(-1);
    }

    public void cloneLastAtomSet(int n) throws Exception {
        if (!this.allowMultiple) {
            return;
        }
        int n2 = n > 0 ? n : this.getLastAtomSetAtomCount();
        int n3 = this.getLastAtomSetAtomIndex();
        this.newAtomSet();
        while (--n2 >= 0) {
            this.newCloneAtom(this.atoms[n3]);
            ++n3;
        }
    }

    public int getFirstAtomSetAtomCount() {
        return this.atomSetAtomCounts[0];
    }

    public int getLastAtomSetAtomCount() {
        return this.atomSetAtomCounts[this.currentAtomSetIndex];
    }

    public int getLastAtomSetAtomIndex() {
        return this.atomCount - this.atomSetAtomCounts[this.currentAtomSetIndex];
    }

    public Atom addNewAtom() {
        Atom atom = new Atom();
        this.addAtom(atom);
        return atom;
    }

    public void addAtom(Atom atom) {
        if (this.atomCount == this.atoms.length) {
            this.atoms = this.atomCount > 200000 ? (Atom[])ArrayUtil.ensureLength(this.atoms, this.atomCount + 50000) : (Atom[])ArrayUtil.doubleLength(this.atoms);
        }
        atom.atomIndex = this.atomCount;
        this.atoms[this.atomCount++] = atom;
        if (this.atomSetCount == 0) {
            this.newAtomSet();
        }
        atom.atomSetIndex = this.currentAtomSetIndex;
        int n = this.currentAtomSetIndex;
        int n2 = this.atomSetAtomCounts[n];
        this.atomSetAtomCounts[n] = n2 + 1;
        atom.atomSite = n2;
    }

    public void addAtomWithMappedName(Atom atom) {
        this.addAtom(atom);
        this.mapMostRecentAtomName();
    }

    public void addAtomWithMappedSerialNumber(Atom atom) {
        this.addAtom(atom);
        this.mapMostRecentAtomSerialNumber();
    }

    public Bond addNewBond(int n, int n2) {
        return this.addNewBond(n, n2, 1);
    }

    Bond addNewBond(String string, String string2) {
        return this.addNewBond(string, string2, 1);
    }

    public Bond addNewBond(int n, int n2, int n3) {
        if (n < 0 || n >= this.atomCount || n2 < 0 || n2 >= this.atomCount) {
            return null;
        }
        Bond bond = new Bond(n, n2, n3);
        this.addBond(bond);
        return bond;
    }

    public Bond addNewBond(String string, String string2, int n) {
        return this.addNewBond(this.getAtomNameIndex(string), this.getAtomNameIndex(string2), n);
    }

    public Bond addNewBondWithMappedSerialNumbers(int n, int n2, int n3) {
        return this.addNewBond(this.getAtomSerialNumberIndex(n), this.getAtomSerialNumberIndex(n2), n3);
    }

    public void addConnection(int[] nArray) {
        if (this.vConnect == null) {
            this.connectLast = null;
            this.vConnect = new Vector();
        }
        if (this.connectLast != null && nArray[0] == this.connectLast[0] && nArray[1] == this.connectLast[1] && nArray[2] != 2048) {
            this.connectLast[2] = this.connectLast[2] + 1;
            return;
        }
        this.connectLast = nArray;
        this.vConnect.addElement(nArray);
    }

    public void connectAll(int n) {
        if (this.vConnect == null) {
            return;
        }
        int n2 = this.connectNextAtomIndex;
        for (int i = this.connectNextAtomSet; i < this.atomSetCount; ++i) {
            this.setAtomSetCollectionAuxiliaryInfo("someModelsHaveCONECT", Boolean.TRUE);
            this.setAtomSetAuxiliaryInfo("PDB_CONECT_firstAtom_count_max", new int[]{n2, this.atomSetAtomCounts[i], n}, i);
            this.setAtomSetAuxiliaryInfo("PDB_CONECT_bonds", this.vConnect, i);
            n2 += this.atomSetAtomCounts[i];
        }
        this.vConnect = null;
        this.connectNextAtomSet = this.currentAtomSetIndex + 1;
        this.connectNextAtomIndex = n2;
    }

    public void addBond(Bond bond) {
        if (this.trajectoryStepCount > 0) {
            return;
        }
        if (bond.atomIndex1 < 0 || bond.atomIndex2 < 0 || bond.order < 0 || this.atoms[bond.atomIndex1].atomSetIndex != this.atoms[bond.atomIndex2].atomSetIndex) {
            if (Logger.debugging) {
                Logger.debug(">>>>>>BAD BOND:" + bond.atomIndex1 + "-" + bond.atomIndex2 + " order=" + bond.order);
            }
            return;
        }
        if (this.bondCount == this.bonds.length) {
            this.bonds = (Bond[])ArrayUtil.setLength(this.bonds, this.bondCount + 1024);
        }
        this.bonds[this.bondCount++] = bond;
        int n = this.currentAtomSetIndex;
        this.atomSetBondCounts[n] = this.atomSetBondCounts[n] + 1;
    }

    public void addStructure(Structure structure) {
        if (this.structureCount == this.structures.length) {
            this.structures = (Structure[])ArrayUtil.setLength(this.structures, this.structureCount + 32);
        }
        structure.modelIndex = this.currentAtomSetIndex;
        this.structures[this.structureCount++] = structure;
        if (structure.strandCount >= 1) {
            int n = this.structureCount;
            n = this.structureCount;
            while (--n >= 0 && this.structures[n].modelIndex == this.currentAtomSetIndex && this.structures[n].structureID.equals(structure.structureID)) {
            }
            int n2 = this.structureCount - ++n;
            while (n < this.structureCount) {
                this.structures[n].strandCount = n2;
                ++n;
            }
        }
    }

    public void addVibrationVector(int n, float f, float f2, float f3, boolean bl) {
        if (!bl) {
            this.addVibrationVector(n, f, f2, f3);
            return;
        }
        int n2 = this.atoms[n].atomSite;
        int n3 = this.atoms[n].atomSetIndex;
        for (int i = n; i < this.atomCount && this.atoms[i].atomSetIndex == n3; ++i) {
            if (this.atoms[i].atomSite != n2) continue;
            this.addVibrationVector(i, f, f2, f3);
        }
    }

    public void addVibrationVector(int n, float f, float f2, float f3) {
        if (!this.allowMultiple) {
            n %= this.atomCount;
        }
        Atom atom = this.atoms[n];
        atom.vectorX = f;
        atom.vectorY = f2;
        atom.vectorZ = f3;
    }

    void setAtomSetSpaceGroupName(String string) {
        this.setAtomSetAuxiliaryInfo("spaceGroup", string + "");
    }

    void setCoordinatesAreFractional(boolean bl) {
        this.coordinatesAreFractional = bl;
        this.setAtomSetAuxiliaryInfo("coordinatesAreFractional", bl);
        if (bl) {
            this.setGlobalBoolean(0);
        }
    }

    void setSymmetryRange(float f) {
        this.symmetryRange = f;
        this.setAtomSetCollectionAuxiliaryInfo("symmetryRange", new Float(f));
    }

    void setLatticeCells(int[] nArray, boolean bl, boolean bl2) {
        this.latticeCells = nArray;
        boolean bl3 = nArray[0] <= 555 && nArray[1] >= 555 && (nArray[2] == 0 || nArray[2] == 1 || nArray[2] == -1);
        this.doNormalize = nArray[0] != 0 && (!bl3 || nArray[2] == 1);
        this.applySymmetryToBonds = bl;
        this.doPackUnitCell = bl2;
    }

    private SymmetryInterface getSymmetry() {
        if (this.symmetry == null) {
            this.symmetry = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
        }
        return this.symmetry;
    }

    public void setNotionalUnitCell(float[] fArray, Matrix3f matrix3f, Point3f point3f) {
        this.notionalUnitCell = new float[fArray.length];
        this.unitCellOffset = point3f;
        for (int i = 0; i < fArray.length; ++i) {
            this.notionalUnitCell[i] = fArray[i];
        }
        this.haveUnitCell = true;
        this.setAtomSetAuxiliaryInfo("notionalUnitcell", this.notionalUnitCell);
        this.setGlobalBoolean(2);
        this.getSymmetry().setUnitCell(this.notionalUnitCell);
        if (point3f != null) {
            this.symmetry.setUnitCellOffset(point3f);
            this.setAtomSetAuxiliaryInfo("unitCellOffset", point3f);
        }
        if (matrix3f != null) {
            this.symmetry.setUnitCellOrientation(matrix3f);
            this.setAtomSetAuxiliaryInfo("matUnitCellOrientation", matrix3f);
        }
    }

    void setGlobalBoolean(int n) {
        this.setAtomSetCollectionAuxiliaryInfo(globalBooleans[n], Boolean.TRUE);
    }

    boolean addSpaceGroupOperation(String string) {
        this.getSymmetry().setSpaceGroup(this.doNormalize);
        return this.symmetry.addSpaceGroupOperation(string, 0) >= 0;
    }

    public void setLatticeParameter(int n) {
        this.getSymmetry().setSpaceGroup(this.doNormalize);
        this.symmetry.setLattice(n);
    }

    void applySymmetry() throws Exception {
        this.applySymmetry(this.latticeCells[0], this.latticeCells[1], Math.abs(this.latticeCells[2]));
    }

    void applySymmetry(SymmetryInterface symmetryInterface) throws Exception {
        this.getSymmetry().setSpaceGroup(symmetryInterface);
        this.applySymmetry(this.latticeCells[0], this.latticeCells[1], Math.abs(this.latticeCells[2]));
    }

    private void applySymmetry(int n, int n2, int n3) throws Exception {
        if (this.coordinatesAreFractional && this.getSymmetry().haveSpaceGroup()) {
            this.applyAllSymmetry(n, n2, n3);
        }
    }

    private void setSymmetryMinMax(Point3f point3f) {
        if (this.rminx > point3f.x) {
            this.rminx = point3f.x;
        }
        if (this.rminy > point3f.y) {
            this.rminy = point3f.y;
        }
        if (this.rminz > point3f.z) {
            this.rminz = point3f.z;
        }
        if (this.rmaxx < point3f.x) {
            this.rmaxx = point3f.x;
        }
        if (this.rmaxy < point3f.y) {
            this.rmaxy = point3f.y;
        }
        if (this.rmaxz < point3f.z) {
            this.rmaxz = point3f.z;
        }
    }

    private boolean isInSymmetryRange(Point3f point3f) {
        return point3f.x >= this.rminx && point3f.y >= this.rminy && point3f.z >= this.rminz && point3f.x <= this.rmaxx && point3f.y <= this.rmaxy && point3f.z <= this.rmaxz;
    }

    private static boolean isWithinCell(Point3f point3f, int n, int n2, int n3, int n4, int n5, int n6) {
        float f = 0.02f;
        return point3f.x > (float)n - f && point3f.x < (float)n2 + f && point3f.y > (float)n3 - f && point3f.y < (float)n4 + f && point3f.z > (float)n5 - f && point3f.z < (float)n6 + f;
    }

    public void setAnisoBorU(Atom atom, float[] fArray, int n) {
        this.needEllipsoids = true;
        atom.anisoBorU = fArray;
        fArray[6] = n;
    }

    public float[] getAnisoBorU(Atom atom) {
        return atom.anisoBorU;
    }

    private void applyAllSymmetry(int n, int n2, int n3) throws Exception {
        int n4;
        int n5;
        int n6;
        boolean bl;
        int n7;
        int n8;
        int n9 = this.getLastAtomSetAtomCount();
        int n10 = this.getLastAtomSetAtomIndex();
        if (this.needEllipsoids) {
            for (n8 = n10; n8 < this.atomCount; ++n8) {
                this.atoms[n8].ellipsoid = this.symmetry.getEllipsoid(this.atoms[n8].anisoBorU);
            }
        }
        this.bondCount0 = this.bondCount;
        this.symmetry.setFinalOperations(this.atoms, n10, n9, this.doNormalize);
        n8 = this.symmetry.getSpaceGroupOperationCount();
        this.minXYZ = new Point3i();
        this.maxXYZ = new Point3i(n, n2, n3);
        this.getSymmetry().setMinMaxLatticeParameters(this.minXYZ, this.maxXYZ);
        if (this.doPackUnitCell || this.symmetryRange != 0.0f && this.maxXYZ.x - this.minXYZ.x == 1 && this.maxXYZ.y - this.minXYZ.y == 1 && this.maxXYZ.z - this.minXYZ.z == 1) {
            switch ((int)this.getSymmetry().getUnitCellAsArray(6)) {
                case 3: {
                    --this.minXYZ.z;
                    ++this.maxXYZ.z;
                }
                case 2: {
                    --this.minXYZ.y;
                    ++this.maxXYZ.y;
                }
                case 1: {
                    --this.minXYZ.x;
                    ++this.maxXYZ.x;
                }
            }
        }
        int n11 = (this.maxXYZ.x - this.minXYZ.x) * (this.maxXYZ.y - this.minXYZ.y) * (this.maxXYZ.z - this.minXYZ.z);
        int n12 = this.checkSpecial ? n9 * n8 * n11 : (this.symmetryRange > 0.0f ? n9 * n8 : (this.symmetryRange < 0.0f ? 1 : 1));
        this.cartesians = new Point3f[n12];
        for (n7 = 0; n7 < n9; ++n7) {
            this.atoms[n7 + n10].bsSymmetry = new BitSet(n8 * (n11 + 1));
        }
        n7 = 0;
        int[] nArray = new int[n11];
        int n13 = 0;
        int n14 = 0;
        float f = Math.abs(this.symmetryRange);
        boolean bl2 = this.symmetryRange != 0.0f;
        boolean bl3 = this.symmetryRange < 0.0f;
        boolean bl4 = bl = this.symmetryRange > 0.0f;
        if (bl2) {
            this.rminx = Float.MAX_VALUE;
            this.rminy = Float.MAX_VALUE;
            this.rminz = Float.MAX_VALUE;
            this.rmaxx = -3.4028235E38f;
            this.rmaxy = -3.4028235E38f;
            this.rmaxz = -3.4028235E38f;
        }
        Matrix4f matrix4f = this.symmetry.getSpaceGroupOperation(0);
        if (this.doPackUnitCell) {
            this.ptOffset.set(0.0f, 0.0f, 0.0f);
        }
        for (n6 = this.minXYZ.x; n6 < this.maxXYZ.x; ++n6) {
            for (n5 = this.minXYZ.y; n5 < this.maxXYZ.y; ++n5) {
                for (n4 = this.minXYZ.z; n4 < this.maxXYZ.z; ++n4) {
                    nArray[n13++] = 555 + n6 * 100 + n5 * 10 + n4;
                    if (n6 != 0 || n5 != 0 || n4 != 0 || this.cartesians.length == 0) continue;
                    for (n7 = 0; n7 < n9; ++n7) {
                        Atom atom = this.atoms[n10 + n7];
                        Point3f point3f = new Point3f(atom);
                        matrix4f.transform(point3f);
                        this.symmetry.toCartesian(point3f, false);
                        if (this.doPackUnitCell) {
                            this.symmetry.toUnitCell(point3f, this.ptOffset);
                            atom.set(point3f);
                            this.symmetry.toFractional(atom, false);
                        }
                        atom.bsSymmetry.set(n13 * n8);
                        atom.bsSymmetry.set(0);
                        if (bl2) {
                            this.setSymmetryMinMax(point3f);
                        }
                        if (n7 >= n12) continue;
                        this.cartesians[n7] = point3f;
                    }
                    if (bl3) {
                        this.rminx -= f;
                        this.rminy -= f;
                        this.rminz -= f;
                        this.rmaxx += f;
                        this.rmaxy += f;
                        this.rmaxz += f;
                    }
                    n14 = n7 = this.symmetryAddAtoms(n10, n9, 0, 0, 0, 0, n7, n13 * n8);
                }
            }
        }
        if (bl) {
            this.rminx -= f;
            this.rminy -= f;
            this.rminz -= f;
            this.rmaxx += f;
            this.rmaxy += f;
            this.rmaxz += f;
        }
        n13 = 0;
        for (n6 = this.minXYZ.x; n6 < this.maxXYZ.x; ++n6) {
            for (n5 = this.minXYZ.y; n5 < this.maxXYZ.y; ++n5) {
                for (n4 = this.minXYZ.z; n4 < this.maxXYZ.z; ++n4) {
                    ++n13;
                    if (n6 == 0 && n5 == 0 && n4 == 0) continue;
                    n7 = this.symmetryAddAtoms(n10, n9, n6, n5, n4, n14, n7, n13 * n8);
                }
            }
        }
        if (n13 * n9 == this.atomCount - n10) {
            this.appendAtomProperties(n13);
        }
        this.setSymmetryOps();
        this.setAtomSetAuxiliaryInfo("presymmetryAtomIndex", new Integer(n10));
        this.setAtomSetAuxiliaryInfo("presymmetryAtomCount", new Integer(n9));
        this.setAtomSetAuxiliaryInfo("latticeDesignation", this.symmetry.getLatticeDesignation());
        this.setAtomSetAuxiliaryInfo("unitCellRange", nArray);
        this.symmetry.setSpaceGroup(null);
        this.notionalUnitCell = new float[6];
        this.coordinatesAreFractional = false;
        this.setAtomSetAuxiliaryInfo("hasSymmetry", Boolean.TRUE);
        this.setGlobalBoolean(1);
    }

    private void setSymmetryOps() {
        int n = this.symmetry.getSpaceGroupOperationCount();
        if (n > 0) {
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = "" + this.symmetry.getSpaceGroupXyz(i, this.doNormalize);
            }
            this.setAtomSetAuxiliaryInfo("symmetryOperations", stringArray);
        }
        this.setAtomSetAuxiliaryInfo("symmetryCount", new Integer(n));
    }

    public void setCheckSpecial(boolean bl) {
        this.checkSpecial = bl;
    }

    private int symmetryAddAtoms(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws Exception {
        boolean bl;
        int[] nArray;
        boolean bl2 = n6 == 0;
        boolean bl3 = this.bondCount0 > this.bondIndex0 && this.applySymmetryToBonds;
        int[] nArray2 = nArray = bl3 ? new int[n2] : null;
        if (this.doPackUnitCell) {
            this.ptOffset.set(n3, n4, n5);
        }
        float f = this.symmetryRange * this.symmetryRange;
        boolean bl4 = this.symmetryRange < 0.0f;
        boolean bl5 = this.symmetryRange > 0.0f;
        boolean bl6 = bl2 && bl5;
        boolean bl7 = bl4 || (bl5 &= !bl2);
        boolean bl8 = this.checkSpecial || bl7;
        boolean bl9 = bl = this.checkSpecial || bl6;
        if (bl4) {
            n6 = n2;
        }
        int n9 = this.symmetry.getSpaceGroupOperationCount();
        int n10 = n + n2;
        Point3f point3f = new Point3f();
        for (int i = 0; i < n9; ++i) {
            Object object;
            int n11;
            if (bl2 && this.symmetry.getSpaceGroupXyz(i, true).equals("x,y,z")) continue;
            int n12 = this.checkSpecial ? n7 : (bl5 ? n6 : 0);
            for (n11 = n; n11 < n10; ++n11) {
                this.symmetry.newSpaceGroupPoint(i, this.atoms[n11], point3f, n3, n4, n5);
                object = null;
                Point3f point3f2 = new Point3f(point3f);
                this.symmetry.toCartesian(point3f2, false);
                if (this.doPackUnitCell) {
                    this.symmetry.toUnitCell(point3f2, this.ptOffset);
                    point3f.set(point3f2);
                    this.symmetry.toFractional(point3f, false);
                    if (!AtomSetCollection.isWithinCell(point3f, this.minXYZ.x + 1, this.maxXYZ.x - 1, this.minXYZ.y + 1, this.maxXYZ.y - 1, this.minXYZ.z + 1, this.maxXYZ.z - 1)) continue;
                }
                if (bl6) {
                    this.setSymmetryMinMax(point3f2);
                }
                if (bl8) {
                    float f2 = Float.MAX_VALUE;
                    if (bl7 && !this.isInSymmetryRange(point3f2)) continue;
                    int n13 = n12;
                    while (--n13 >= 0) {
                        float f3 = point3f2.distanceSquared(this.cartesians[n13]);
                        if (this.checkSpecial && (double)f3 < 1.0E-4) {
                            object = this.atoms[n + n13];
                            break;
                        }
                        if (!bl5 || n13 >= n6 || !(f3 < f2)) continue;
                        f2 = f3;
                    }
                    if (bl5 && f2 > f) continue;
                }
                int n14 = this.atoms[n11].atomSite;
                if (object != null) {
                    if (bl3) {
                        nArray[n14] = ((Atom)object).atomIndex;
                    }
                    ((Atom)object).bsSymmetry.set(n8 + i);
                    ((Atom)object).bsSymmetry.set(i);
                    continue;
                }
                if (bl3) {
                    nArray[n14] = this.atomCount;
                }
                Atom atom = this.newCloneAtom(this.atoms[n11]);
                atom.set(point3f);
                atom.atomSite = n14;
                atom.bsSymmetry = BitSetUtil.setBit(n8 + i);
                atom.bsSymmetry.set(i);
                if (bl) {
                    this.cartesians[n7++] = point3f2;
                }
                if (this.atoms[n11].ellipsoid == null) continue;
                Object object2 = this.atoms[n11].ellipsoid[0];
                Object object3 = this.atoms[n11].ellipsoid[1];
                if (object2 != null) {
                    if (bl) {
                        this.ptTemp.set(this.cartesians[n11 - n]);
                    } else {
                        this.ptTemp.set(this.atoms[n11]);
                        this.symmetry.toCartesian(this.ptTemp, false);
                    }
                    object2 = this.symmetry.rotateEllipsoid(i, this.ptTemp, (Vector3f[])object2, this.ptTemp1, this.ptTemp2);
                }
                atom.ellipsoid = new Object[]{object2, object3};
            }
            if (!bl3) continue;
            for (n11 = this.bondIndex0; n11 < this.bondCount0; ++n11) {
                object = this.bonds[n11];
                int n15 = nArray[this.atoms[((Bond)object).atomIndex1].atomSite];
                int n16 = nArray[this.atoms[((Bond)object).atomIndex2].atomSite];
                if (n15 < n10 && n16 < n10) continue;
                this.addNewBond(n15, n16, ((Bond)object).order);
            }
        }
        return n7;
    }

    public void applySymmetry(Vector vector, float[] fArray, boolean bl, String string) {
        int n;
        if (this.latticeCells != null && this.latticeCells[0] != 0) {
            Logger.error("Cannot apply biomolecule when lattice cells are indicated");
            return;
        }
        this.doNormalize = false;
        this.symmetry = null;
        this.getSymmetry();
        this.setNotionalUnitCell(fArray, null, this.unitCellOffset);
        this.getSymmetry().setSpaceGroup(this.doNormalize);
        this.addSpaceGroupOperation("x,y,z");
        this.setAtomSetSpaceGroupName("biomolecule");
        int n2 = vector.size();
        this.applySymmetryToBonds = bl;
        this.bondCount0 = this.bondCount;
        boolean bl2 = this.bondCount0 > this.bondIndex0 && bl;
        int[] nArray = bl2 ? new int[this.atomCount] : null;
        int n3 = this.getLastAtomSetAtomIndex();
        int n4 = this.atomCount;
        if (string.indexOf("#<") >= 0) {
            n2 = Math.min(n2, Parser.parseInt(string.substring(string.indexOf("#<") + 2)) - 1);
            string = TextFormat.simpleReplace(string, "#<", "_<");
        }
        for (n = n3; n < n4; ++n) {
            this.atoms[n].bsSymmetry = BitSetUtil.setBit(0);
        }
        for (n = 1; n < n2; ++n) {
            if (string.indexOf("!#") >= 0 ? string.toUpperCase().indexOf("!#" + (n + 1) + ";") >= 0 : string.indexOf("#") >= 0 && string.toUpperCase().indexOf("#" + (n + 1) + ";") < 0) continue;
            Matrix4f matrix4f = (Matrix4f)vector.get(n);
            for (int i = n3; i < n4; ++i) {
                try {
                    int n5 = this.atoms[i].atomSite;
                    if (bl2) {
                        nArray[n5] = this.atomCount;
                    }
                    Atom atom = this.newCloneAtom(this.atoms[i]);
                    atom.atomSite = n5;
                    matrix4f.transform(atom);
                    atom.bsSymmetry = BitSetUtil.setBit(n);
                    if (!bl2) continue;
                    for (int j = this.bondIndex0; j < this.bondCount0; ++j) {
                        Bond bond = this.bonds[j];
                        int n6 = nArray[this.atoms[bond.atomIndex1].atomSite];
                        int n7 = nArray[this.atoms[bond.atomIndex2].atomSite];
                        if (n6 < n4 && n7 < n4) continue;
                        this.addNewBond(n6, n7, bond.order);
                    }
                    continue;
                }
                catch (Exception exception) {
                    this.errorMessage = "appendAtomCollection error: " + exception;
                }
            }
            matrix4f.m03 /= fArray[0];
            matrix4f.m13 /= fArray[1];
            matrix4f.m23 /= fArray[2];
            if (this.symmetry != null && n > 0) {
                this.symmetry.addSpaceGroupOperation(matrix4f);
            }
            System.out.println("biomt " + n + " " + this.atomCount);
        }
        n = n4 - n3;
        this.setAtomSetAuxiliaryInfo("presymmetryAtomIndex", new Integer(n3));
        this.setAtomSetAuxiliaryInfo("presymmetryAtomCount", new Integer(n));
        this.setAtomSetAuxiliaryInfo("biosymmetryCount", new Integer(n2));
        if (this.symmetry != null) {
            this.symmetry.setFinalOperations(this.atoms, n3, n, this.doNormalize);
            this.setSymmetryOps();
        }
        this.symmetry = null;
        fArray = new float[6];
        this.coordinatesAreFractional = false;
        this.setAtomSetAuxiliaryInfo("hasSymmetry", Boolean.TRUE);
        this.setGlobalBoolean(1);
    }

    void mapMostRecentAtomName() {
        if (this.atomCount > 0) {
            int n = this.atomCount - 1;
            String string = this.atoms[n].atomName;
            if (string != null) {
                this.atomSymbolicMap.put(string, new Integer(n));
            }
        }
    }

    public void clearSymbolicMap() {
        this.atomSymbolicMap.clear();
        this.haveMappedSerials = false;
    }

    void mapMostRecentAtomSerialNumber() {
        if (this.atomCount == 0) {
            return;
        }
        int n = this.atomCount - 1;
        int n2 = this.atoms[n].atomSerial;
        if (n2 != Integer.MIN_VALUE) {
            this.atomSymbolicMap.put(new Integer(n2), new Integer(n));
        }
        this.haveMappedSerials = true;
    }

    public void createAtomSerialMap() {
        if (this.haveMappedSerials || this.currentAtomSetIndex < 0) {
            return;
        }
        for (int i = this.getLastAtomSetAtomCount(); i < this.atomCount; ++i) {
            int n = this.atoms[i].atomSerial;
            if (n == Integer.MIN_VALUE) continue;
            this.atomSymbolicMap.put(new Integer(n), new Integer(i));
        }
        this.haveMappedSerials = true;
    }

    void mapAtomName(String string, int n) {
        this.atomSymbolicMap.put(string, new Integer(n));
    }

    public int getAtomNameIndex(String string) {
        int n = -1;
        Object v = this.atomSymbolicMap.get(string);
        if (v != null) {
            n = (Integer)v;
        }
        return n;
    }

    public int getAtomSerialNumberIndex(int n) {
        int n2 = -1;
        Object v = this.atomSymbolicMap.get(new Integer(n));
        if (v != null) {
            n2 = (Integer)v;
        }
        return n2;
    }

    public void setAtomSetCollectionAuxiliaryInfo(String string, Object object) {
        this.atomSetCollectionAuxiliaryInfo.put(string, object);
    }

    public boolean setAtomSetCollectionPartialCharges(String string) {
        if (!this.atomSetCollectionAuxiliaryInfo.containsKey(string)) {
            return false;
        }
        Vector vector = (Vector)this.atomSetCollectionAuxiliaryInfo.get(string);
        int n = vector.size();
        while (--n >= 0) {
            this.atoms[n].partialCharge = ((Float)vector.get(n)).floatValue();
        }
        return true;
    }

    public void mapPartialCharge(String string, float f) {
        this.atoms[this.getAtomNameIndex((String)string)].partialCharge = f;
    }

    public Object getAtomSetCollectionAuxiliaryInfo(String string) {
        return this.atomSetCollectionAuxiliaryInfo.get(string);
    }

    private void addTrajectoryStep() {
        this.trajectoryStep = new Point3f[this.atomCount];
        Point3f[] point3fArray = this.trajectoryStepCount == 0 ? null : (Point3f[])this.trajectorySteps.get(this.trajectoryStepCount - 1);
        for (int i = 0; i < this.atomCount; ++i) {
            Point3f point3f = new Point3f(this.atoms[i]);
            if (this.doFixPeriodic && point3fArray != null) {
                point3f = this.fixPeriodic(point3f, point3fArray[i]);
            }
            this.trajectoryStep[i] = point3f;
        }
        this.trajectorySteps.addElement(this.trajectoryStep);
        ++this.trajectoryStepCount;
    }

    private Point3f fixPeriodic(Point3f point3f, Point3f point3f2) {
        point3f.x = this.fixPoint(point3f.x, point3f2.x);
        point3f.y = this.fixPoint(point3f.y, point3f2.y);
        point3f.z = this.fixPoint(point3f.z, point3f2.z);
        return point3f;
    }

    private float fixPoint(float f, float f2) {
        while ((double)(f - f2) > 0.9) {
            f -= 1.0f;
        }
        while ((double)(f - f2) < -0.9) {
            f += 1.0f;
        }
        return f;
    }

    void finalizeTrajectory(Vector vector) {
        this.trajectorySteps = vector;
        this.trajectoryStepCount = vector.size();
        this.finalizeTrajectory(false);
    }

    private void finalizeTrajectory(boolean bl) {
        if (this.trajectoryStepCount == 0) {
            return;
        }
        Point3f[] point3fArray = (Point3f[])this.trajectorySteps.get(0);
        for (int i = 0; i < this.atomCount; ++i) {
            this.atoms[i].set(point3fArray[i]);
        }
        this.setAtomSetCollectionAuxiliaryInfo("trajectorySteps", this.trajectorySteps);
    }

    public void newAtomSet() {
        if (!this.allowMultiple && this.currentAtomSetIndex >= 0) {
            this.discardPreviousAtoms();
        }
        this.bondIndex0 = this.bondCount;
        if (this.isTrajectory) {
            this.discardPreviousAtoms();
        }
        this.currentAtomSetIndex = this.atomSetCount++;
        if (this.atomSetCount > this.atomSetNumbers.length) {
            this.atomSetAtomCounts = ArrayUtil.doubleLength(this.atomSetAtomCounts);
            this.atomSetBondCounts = ArrayUtil.doubleLength(this.atomSetBondCounts);
            this.atomSetAuxiliaryInfo = (Hashtable[])ArrayUtil.doubleLength(this.atomSetAuxiliaryInfo);
        }
        if (this.atomSetCount + this.trajectoryStepCount > this.atomSetNumbers.length) {
            this.atomSetNumbers = ArrayUtil.doubleLength(this.atomSetNumbers);
        }
        if (this.isTrajectory) {
            this.atomSetNumbers[this.currentAtomSetIndex + this.trajectoryStepCount] = this.atomSetCount + this.trajectoryStepCount;
        } else {
            this.atomSetNumbers[this.currentAtomSetIndex] = this.atomSetCount;
        }
        this.atomSymbolicMap.clear();
        this.setAtomSetAuxiliaryInfo("title", this.collectionName);
    }

    public void setAtomSetName(String string) {
        this.setAtomSetAuxiliaryInfo("name", string, this.currentAtomSetIndex);
        if (!this.allowMultiple) {
            this.setCollectionName(string);
        }
    }

    public void setAtomSetNames(String string, int n) {
        for (int i = this.currentAtomSetIndex; --n >= 0 && i >= 0; --i) {
            this.setAtomSetAuxiliaryInfo("name", string, i);
        }
    }

    public void setAtomSetNumber(int n) {
        if (this.isTrajectory) {
            this.atomSetNumbers[this.currentAtomSetIndex + this.trajectoryStepCount] = n;
        } else {
            this.atomSetNumbers[this.currentAtomSetIndex] = n;
        }
    }

    public void setAtomSetProperty(String string, String string2) {
        this.setAtomSetProperty(string, string2, this.currentAtomSetIndex);
    }

    public void setAtomSetProperty(String string, String string2, int n) {
        Properties properties = (Properties)this.getAtomSetAuxiliaryInfo(n, "modelProperties");
        if (properties == null) {
            properties = new Properties();
            this.setAtomSetAuxiliaryInfo("modelProperties", properties, n);
        }
        properties.put(string, string2);
    }

    public void setAtomSetAuxiliaryProperty(String string, String string2) {
        Hashtable<String, String> hashtable;
        if (!string2.endsWith("\n")) {
            string2 = string2 + "\n";
        }
        if ((hashtable = (Hashtable<String, String>)this.getAtomSetAuxiliaryInfo(this.currentAtomSetIndex, "atomProperties")) == null) {
            hashtable = new Hashtable<String, String>();
            this.setAtomSetAuxiliaryInfo("atomProperties", hashtable);
        }
        hashtable.put(string, string2);
    }

    private void appendAtomProperties(int n) {
        Hashtable hashtable = (Hashtable)this.getAtomSetAuxiliaryInfo(this.currentAtomSetIndex, "atomProperties");
        if (hashtable == null) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = n;
            while (--n2 >= 0) {
                stringBuffer.append(string2);
            }
            hashtable.put(string, stringBuffer.toString());
        }
    }

    public void setAtomSetAuxiliaryInfo(String string, Object object) {
        this.setAtomSetAuxiliaryInfo(string, object, this.currentAtomSetIndex);
    }

    boolean setAtomSetPartialCharges(String string) {
        if (!this.atomSetAuxiliaryInfo[this.currentAtomSetIndex].containsKey(string)) {
            return false;
        }
        Vector vector = (Vector)this.getAtomSetAuxiliaryInfo(this.currentAtomSetIndex, string);
        int n = vector.size();
        while (--n >= 0) {
            this.atoms[n].partialCharge = ((Float)vector.get(n)).floatValue();
        }
        return true;
    }

    Object getAtomSetAuxiliaryInfo(int n, String string) {
        return this.atomSetAuxiliaryInfo[n].get(string);
    }

    void setAtomSetAuxiliaryInfo(String string, Object object, int n) {
        if (n < 0) {
            return;
        }
        if (this.atomSetAuxiliaryInfo[n] == null) {
            this.atomSetAuxiliaryInfo[n] = new Hashtable();
        }
        if (object == null) {
            return;
        }
        this.atomSetAuxiliaryInfo[n].put(string, object);
    }

    public void setAtomSetProperties(String string, String string2, int n) {
        for (int i = this.currentAtomSetIndex; --n >= 0 && i >= 0; --i) {
            this.setAtomSetProperty(string, string2, i);
        }
    }

    public void cloneLastAtomSetProperties() {
        this.cloneAtomSetProperties(this.currentAtomSetIndex - 1);
    }

    void cloneAtomSetProperties(int n) {
        Properties properties = (Properties)this.getAtomSetAuxiliaryInfo(n, "modelProperties");
        if (properties != null) {
            this.setAtomSetAuxiliaryInfo("modelProperties", properties.clone(), this.currentAtomSetIndex);
        }
    }

    int getAtomSetNumber(int n) {
        return this.atomSetNumbers[n >= this.atomSetCount ? 0 : n];
    }

    String getAtomSetName(int n) {
        if (n >= this.atomSetCount) {
            n = this.atomSetCount - 1;
        }
        return (String)this.getAtomSetAuxiliaryInfo(n, "name");
    }

    Hashtable getAtomSetAuxiliaryInfo(int n) {
        if (n >= this.atomSetCount) {
            n = this.atomSetCount - 1;
        }
        return this.atomSetAuxiliaryInfo[n];
    }

    boolean hasAlternateLocations() {
        int n = this.atomCount;
        while (--n >= 0) {
            if (this.atoms[n].alternateLocationID == '\u0000') continue;
            return true;
        }
        return false;
    }

    void getAltLocLists() {
        int n;
        if (!this.hasAlternateLocations()) {
            return;
        }
        String[] stringArray = new String[this.atomSetCount];
        for (n = 0; n < this.atomSetCount; ++n) {
            stringArray[n] = "";
        }
        for (n = 0; n < this.atomCount; ++n) {
            char c = this.atoms[n].alternateLocationID;
            if (c == '\u0000' || stringArray[this.atoms[n].atomSetIndex].indexOf(c) >= 0) continue;
            int n2 = this.atoms[n].atomSetIndex;
            stringArray[n2] = stringArray[n2] + c;
        }
        for (n = 0; n < this.atomSetCount; ++n) {
            if (stringArray[n].length() <= 0) continue;
            this.setAtomSetAuxiliaryInfo("altLocs", stringArray[n], n);
        }
    }

    boolean hasInsertions() {
        int n = this.atomCount;
        while (--n >= 0) {
            if (this.atoms[n].insertionCode == '\u0000') continue;
            return true;
        }
        return false;
    }

    void getInsertionLists() {
        int n;
        if (!this.hasInsertions()) {
            return;
        }
        String[] stringArray = new String[this.atomSetCount];
        for (n = 0; n < this.atomSetCount; ++n) {
            stringArray[n] = "";
        }
        for (n = 0; n < this.atomCount; ++n) {
            char c = this.atoms[n].insertionCode;
            if (c == '\u0000' || stringArray[this.atoms[n].atomSetIndex].indexOf(c) >= 0) continue;
            int n2 = this.atoms[n].atomSetIndex;
            stringArray[n2] = stringArray[n2] + c;
        }
        for (n = 0; n < this.atomSetCount; ++n) {
            if (stringArray[n].length() <= 0) continue;
            this.setAtomSetAuxiliaryInfo("insertionCodes", stringArray[n], n);
        }
    }

    public void newVolumeData() {
        this.vd = (VolumeDataInterface)Interface.getOptionInterface("jvxl.data.VolumeData");
    }

    public void setVoxelCounts(int n, int n2, int n3) {
        this.vd.setVoxelCounts(n, n2, n3);
    }

    public void setVolumetricVector(int n, float f, float f2, float f3) {
        this.vd.setVolumetricVector(n, f, f2, f3);
    }

    public void setVolumetricOrigin(float f, float f2, float f3) {
        this.vd.setVolumetricOrigin(f, f2, f3);
    }

    public void setVoxelData(float[][][] fArray) {
        this.vd.setVoxelData(fArray);
    }

    public Object getVolumeData() {
        VolumeDataInterface volumeDataInterface = this.vd;
        this.vd = null;
        return volumeDataInterface;
    }

    public Properties setAtomNames(Properties properties) {
        if (properties == null) {
            return null;
        }
        for (int i = 0; i < this.atomCount; ++i) {
            String string = properties.getProperty(this.atoms[i].atomName);
            if (string == null) continue;
            this.atoms[i].atomName = string;
        }
        return null;
    }

    public void setAtomSetEnergy(String string, float f) {
        if (this.currentAtomSetIndex < 0) {
            return;
        }
        this.setAtomSetAuxiliaryInfo("EnergyString", string);
        this.setAtomSetAuxiliaryInfo("Energy", new Float(f));
        this.setAtomSetProperty("Energy", "" + f);
    }

    public void setAtomSetFrequency(String string, String string2, String string3, String string4) {
        string3 = string3 + " " + (string4 == null ? "cm^-1" : string4);
        this.setAtomSetName((string2 == null ? "" : string2 + " ") + string3);
        this.setAtomSetProperty("Frequency", string3);
        if (string2 != null) {
            this.setAtomSetProperty("FrequencyLabel", string2);
        }
        this.setAtomSetProperty(".PATH", (string == null ? "" : string + SmarterJmolAdapter.PATH_SEPARATOR + "Frequencies") + "Frequencies");
    }
}

