/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import java.util.BitSet;
import java.util.Vector;
import org.jmol.api.JmolNode;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.SmilesGenerator;
import org.jmol.smiles.SmilesParser;
import org.jmol.smiles.SmilesSearch;

public class SmilesMatcher
implements SmilesMatcherInterface {
    private static final int MODE_BITSET = 1;
    private static final int MODE_ARRAY = 2;
    private static final int MODE_MAP = 3;

    public String getLastException() {
        return InvalidSmilesException.getLastError();
    }

    public String getMolecularFormula(String string, boolean bl) {
        InvalidSmilesException.setLastError(null);
        try {
            SmilesSearch smilesSearch = SmilesParser.getMolecule(string, bl);
            smilesSearch.createTopoMap(null);
            smilesSearch.nodes = smilesSearch.jmolAtoms;
            return smilesSearch.getMolecularFormula(!bl);
        }
        catch (InvalidSmilesException invalidSmilesException) {
            if (InvalidSmilesException.getLastError() == null) {
                InvalidSmilesException.setLastError(invalidSmilesException.getMessage());
            }
            return null;
        }
    }

    public String getSmiles(JmolNode[] jmolNodeArray, int n, BitSet bitSet, boolean bl, boolean bl2, boolean bl3, String string) {
        InvalidSmilesException.setLastError(null);
        try {
            if (bl) {
                return new SmilesGenerator().getBioSmiles(jmolNodeArray, n, bitSet, bl2, bl3, string);
            }
            return new SmilesGenerator().getSmiles(jmolNodeArray, n, bitSet);
        }
        catch (InvalidSmilesException invalidSmilesException) {
            if (InvalidSmilesException.getLastError() == null) {
                InvalidSmilesException.setLastError(invalidSmilesException.getMessage());
            }
            return null;
        }
    }

    public int areEqual(String string, String string2) {
        BitSet[] bitSetArray = this.find(string, string2, false, false);
        return bitSetArray == null ? -1 : bitSetArray.length;
    }

    public boolean areEqual(String string, SmilesSearch smilesSearch) {
        BitSet[] bitSetArray = this.find(string, smilesSearch, false, true, true);
        return bitSetArray != null && bitSetArray.length == 1;
    }

    public BitSet[] find(String string, String string2, boolean bl, boolean bl2) {
        InvalidSmilesException.setLastError(null);
        try {
            SmilesSearch smilesSearch = SmilesParser.getMolecule(string2, false);
            return this.find(string, smilesSearch, bl, !bl, bl2);
        }
        catch (Exception exception) {
            if (InvalidSmilesException.getLastError() == null) {
                InvalidSmilesException.setLastError(exception.getMessage());
            }
            exception.printStackTrace();
            return null;
        }
    }

    public BitSet getSubstructureSet(String string, JmolNode[] jmolNodeArray, int n, BitSet bitSet, boolean bl, boolean bl2) {
        return (BitSet)this.match(string, jmolNodeArray, n, bitSet, null, bl, false, bl2, 1);
    }

    public BitSet[] getSubstructureSetArray(String string, JmolNode[] jmolNodeArray, int n, BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2) {
        return (BitSet[])this.match(string, jmolNodeArray, n, bitSet, bitSet2, bl, false, bl2, 2);
    }

    public int[][] getCorrelationMaps(String string, JmolNode[] jmolNodeArray, int n, BitSet bitSet, boolean bl, boolean bl2) {
        return (int[][])this.match(string, jmolNodeArray, n, bitSet, null, bl, false, bl2, 3);
    }

    private BitSet[] find(String string, SmilesSearch smilesSearch, boolean bl, boolean bl2, boolean bl3) {
        BitSet bitSet = new BitSet();
        smilesSearch.createTopoMap(bitSet);
        return (BitSet[])this.match(string, smilesSearch.jmolAtoms, -smilesSearch.jmolAtoms.length, null, bitSet, bl, bl2, bl3, 2);
    }

    private Object match(String string, JmolNode[] jmolNodeArray, int n, BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2, boolean bl3, int n2) {
        InvalidSmilesException.setLastError(null);
        try {
            SmilesSearch smilesSearch = SmilesParser.getMolecule(string, bl);
            smilesSearch.jmolAtoms = jmolNodeArray;
            smilesSearch.jmolAtomCount = Math.abs(n);
            if (n < 0) {
                smilesSearch.isSmilesFind = true;
            }
            smilesSearch.setSelected(bitSet);
            smilesSearch.bsRequired = null;
            smilesSearch.setRingData(bitSet2);
            smilesSearch.firstMatchOnly = bl3;
            smilesSearch.matchAllAtoms = bl2;
            switch (n2) {
                case 1: {
                    smilesSearch.asVector = false;
                    return (BitSet)smilesSearch.search(false);
                }
                case 2: {
                    smilesSearch.asVector = true;
                    Vector vector = (Vector)smilesSearch.search(false);
                    BitSet[] bitSetArray = new BitSet[vector.size()];
                    for (int i = 0; i < bitSetArray.length; ++i) {
                        bitSetArray[i] = (BitSet)vector.get(i);
                    }
                    return bitSetArray;
                }
                case 3: {
                    smilesSearch.getMaps = true;
                    Vector vector = (Vector)smilesSearch.search(false);
                    int[][] nArrayArray = new int[vector.size()][];
                    for (int i = 0; i < nArrayArray.length; ++i) {
                        nArrayArray[i] = (int[])vector.get(i);
                    }
                    return nArrayArray;
                }
            }
        }
        catch (Exception exception) {
            if (InvalidSmilesException.getLastError() == null) {
                InvalidSmilesException.setLastError(exception.getMessage());
            }
            exception.printStackTrace();
        }
        return null;
    }
}

