/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.api.Interface;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolBioResolver;
import org.jmol.api.JmolMolecule;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.RadiusData;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Elements;
import org.jmol.util.Logger;
import org.jmol.util.Quaternion;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

public final class ModelLoader
extends ModelSet {
    private ModelLoader mergeModelSet;
    private boolean merging;
    private String jmolData;
    private final int[] specialAtomIndexes = new int[JmolConstants.ATOMID_MAX];
    private String[] group3Lists;
    private int[][] group3Counts;
    private boolean someModelsHaveUnitcells;
    private boolean isTrajectory;
    private boolean doMinimize;
    private String fileHeader;
    private final Map htAtomMap = new Hashtable();
    private static final int defaultGroupCount = 32;
    private Chain[] chainOf;
    private String[] group3Of;
    private int[] seqcodes;
    private int[] firstAtomIndexes;
    private int currentModelIndex;
    private Model currentModel;
    private char currentChainID;
    private Chain currentChain;
    private int currentGroupSequenceNumber;
    private char currentGroupInsertionCode;
    private String currentGroup3;
    private Group nullGroup;
    private int baseModelIndex = 0;
    private int baseModelCount = 0;
    private int baseAtomIndex = 0;
    private int baseGroupIndex = 0;
    private int baseTrajectoryCount = 0;
    private boolean appendNew;
    private int adapterModelCount = 0;
    private int adapterTrajectoryCount = 0;
    private boolean noAutoBond;
    private boolean is2D;
    private List vStereo;
    private BitSet structuresDefinedInFile = new BitSet();

    public ModelLoader(Viewer viewer, String string) {
        this.viewer = viewer;
        viewer.resetShapes();
        this.preserveState = viewer.getPreserveState();
        this.initializeInfo(string, null);
        this.createModelSet(null, null, null);
        this.modelSetName = string;
        viewer.setStringProperty("_fileType", "");
    }

    public ModelLoader(Viewer viewer, StringBuffer stringBuffer, Object object, ModelLoader modelLoader, String string, BitSet bitSet) {
        this.viewer = viewer;
        JmolAdapter jmolAdapter = viewer.getModelAdapter();
        this.modelSetName = string;
        this.mergeModelSet = modelLoader;
        boolean bl = this.merging = modelLoader != null && modelLoader.atomCount > 0;
        if (!this.merging) {
            viewer.resetShapes();
        }
        this.preserveState = viewer.getPreserveState();
        Hashtable hashtable = jmolAdapter.getAtomSetCollectionAuxiliaryInfo(object);
        hashtable.put("loadScript", stringBuffer);
        this.initializeInfo(jmolAdapter.getFileTypeName(object).toLowerCase().intern(), hashtable);
        this.createModelSet(jmolAdapter, object, bitSet);
    }

    private void initializeInfo(String string, Map map) {
        this.g3d = this.viewer.getGraphics3D();
        this.modelSetTypeName = string;
        this.isXYZ = this.modelSetTypeName == "xyz";
        this.modelSetAuxiliaryInfo = (Hashtable)map;
        this.modelSetProperties = (Properties)this.getModelSetAuxiliaryInfo("properties");
        this.isPDB = this.getModelSetAuxiliaryInfoBoolean("isPDB");
        this.jmolData = (String)this.getModelSetAuxiliaryInfo("jmolData");
        this.fileHeader = (String)this.getModelSetAuxiliaryInfo("fileHeader");
        this.trajectorySteps = (Vector)this.getModelSetAuxiliaryInfo("trajectorySteps");
        this.isTrajectory = this.trajectorySteps != null;
        this.noAutoBond = this.getModelSetAuxiliaryInfoBoolean("noAutoBond");
        this.is2D = this.getModelSetAuxiliaryInfoBoolean("is2D");
        this.doMinimize = this.is2D && this.getModelSetAuxiliaryInfoBoolean("doMinimize");
        this.adapterTrajectoryCount = this.trajectorySteps == null ? 0 : this.trajectorySteps.size();
        this.someModelsHaveSymmetry = this.getModelSetAuxiliaryInfoBoolean("someModelsHaveSymmetry");
        this.someModelsHaveUnitcells = this.getModelSetAuxiliaryInfoBoolean("someModelsHaveUnitcells");
        this.someModelsHaveFractionalCoordinates = this.getModelSetAuxiliaryInfoBoolean("someModelsHaveFractionalCoordinates");
        if (this.merging) {
            this.someModelsHaveSymmetry |= this.mergeModelSet.getModelSetAuxiliaryInfoBoolean("someModelsHaveSymmetry");
            this.someModelsHaveUnitcells |= this.mergeModelSet.getModelSetAuxiliaryInfoBoolean("someModelsHaveUnitcells");
            this.someModelsHaveFractionalCoordinates |= this.mergeModelSet.getModelSetAuxiliaryInfoBoolean("someModelsHaveFractionalCoordinates");
            this.someModelsHaveAromaticBonds |= this.mergeModelSet.someModelsHaveAromaticBonds;
        }
    }

    private void createModelSet(JmolAdapter jmolAdapter, Object object, BitSet bitSet) {
        int n;
        int n2;
        int n3 = n2 = jmolAdapter == null ? 0 : jmolAdapter.getAtomCount(object);
        if (n2 > 0) {
            Logger.info("reading " + n2 + " atoms");
        }
        this.adapterModelCount = jmolAdapter == null ? 1 : jmolAdapter.getAtomSetCount(object);
        this.appendNew = !this.merging || jmolAdapter == null || this.adapterModelCount > 1 || this.isTrajectory || this.viewer.getAppendNew();
        this.htAtomMap.clear();
        this.chainOf = new Chain[32];
        this.group3Of = new String[32];
        this.seqcodes = new int[32];
        this.firstAtomIndexes = new int[32];
        this.currentChainID = (char)65535;
        this.currentChain = null;
        this.currentGroupInsertionCode = (char)65535;
        this.currentGroup3 = "xxxxx";
        this.currentModelIndex = -1;
        this.currentModel = null;
        if (this.merging) {
            this.baseModelCount = this.mergeModelSet.modelCount;
            this.baseTrajectoryCount = this.mergeModelSet.getTrajectoryCount();
            if (this.baseTrajectoryCount > 0) {
                if (this.isTrajectory) {
                    for (int i = 0; i < this.trajectorySteps.size(); ++i) {
                        this.mergeModelSet.trajectorySteps.add(this.trajectorySteps.get(i));
                    }
                }
                this.trajectorySteps = this.mergeModelSet.trajectorySteps;
            }
        }
        this.initializeAtomBondModelCounts(n2);
        if (bitSet != null && this.doMinimize) {
            bitSet.set(this.baseAtomIndex, this.baseAtomIndex + n2);
        }
        if (jmolAdapter == null) {
            this.setModelNameNumberProperties(0, -1, "", 1, null, null, null);
        } else {
            Quaternion quaternion;
            if (this.adapterModelCount > 0) {
                Logger.info("ModelSet: haveSymmetry:" + this.someModelsHaveSymmetry + " haveUnitcells:" + this.someModelsHaveUnitcells + " haveFractionalCoord:" + this.someModelsHaveFractionalCoordinates);
                Logger.info(this.adapterModelCount + " model" + (this.modelCount == 1 ? "" : "s") + " in this collection. Use getProperty \"modelInfo\" or" + " getProperty \"auxiliaryInfo\" to inspect them.");
            }
            if ((quaternion = (Quaternion)this.getModelSetAuxiliaryInfo("defaultOrientationQuaternion")) != null) {
                Logger.info("defaultOrientationQuaternion = " + quaternion);
                Logger.info("Use \"set autoLoadOrientation TRUE\" before loading or \"restore orientation DEFAULT\" after loading to view this orientation.");
            }
            this.iterateOverAllNewModels(jmolAdapter, object);
            this.iterateOverAllNewAtoms(jmolAdapter, object);
            this.iterateOverAllNewBonds(jmolAdapter, object);
            if (jmolAdapter != null) {
                Hashtable hashtable;
                Hashtable hashtable2 = hashtable = this.merging && !this.appendNew ? jmolAdapter.getAtomSetAuxiliaryInfo(object, 0) : null;
                if (hashtable != null) {
                    this.setModelAuxiliaryInfo(this.baseModelIndex, "initialAtomCount", hashtable.get("initialAtomCount"));
                    this.setModelAuxiliaryInfo(this.baseModelIndex, "initialBondCount", hashtable.get("initialBondCount"));
                    hashtable = null;
                }
            }
            this.initializeUnitCellAndSymmetry();
            this.initializeBonding();
            this.setAtomProperties();
        }
        this.finalizeGroupBuild();
        if (jmolAdapter != null) {
            this.calculatePolymers(this.baseGroupIndex, null);
            this.iterateOverAllNewStructures(jmolAdapter, object);
            jmolAdapter.finish(object);
        }
        RadiusData radiusData = this.viewer.getDefaultRadiusData();
        for (n = this.baseAtomIndex; n < this.atomCount; ++n) {
            this.atoms[n].setMadAtom(this.viewer, radiusData);
        }
        for (n = this.models[this.baseModelIndex].firstAtomIndex; n < this.atomCount; ++n) {
            this.models[this.atoms[n].modelIndex].bsAtoms.set(n);
        }
        this.setDefaultRendering(this.viewer.getSmallMoleculeMaxAtoms());
        this.freeze();
        this.calcBoundBoxDimensions(null, 1.0f);
        if (this.is2D) {
            this.applyStereochemistry();
        }
        this.finalizeShapes();
        if (this.mergeModelSet != null) {
            this.mergeModelSet.releaseModelSet();
        }
        this.mergeModelSet = null;
    }

    private void setDefaultRendering(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = this.baseModelIndex; i < this.modelCount; ++i) {
            if (!this.models[i].isPDB) continue;
            this.models[i].getDefaultLargePDBRendering(stringBuffer, n);
        }
        if (stringBuffer.length() == 0) {
            return;
        }
        stringBuffer.append("select *;");
        String string = (String)this.getModelSetAuxiliaryInfo("jmolscript");
        if (string == null) {
            string = "";
        }
        stringBuffer.append(string);
        this.modelSetAuxiliaryInfo.put("jmolscript", stringBuffer.toString());
    }

    private void setAtomProperties() {
        int n = this.baseAtomIndex;
        int n2 = 0;
        for (int i = this.baseModelIndex; i < this.modelCount; ++i) {
            n2 = this.models[i].bsAtoms.cardinality();
            Hashtable hashtable = (Hashtable)this.getModelAuxiliaryInfo(i, "atomProperties");
            if (hashtable != null) {
                Set set = hashtable.entrySet();
                for (Map.Entry entry : set) {
                    String string = (String)entry.getKey();
                    String string2 = (String)entry.getValue();
                    BitSet bitSet = this.getModelAtomBitSetIncludingDeleted(i, true);
                    string = "property_" + string.toLowerCase();
                    Logger.info("creating " + string + " for model " + this.getModelName(i));
                    this.viewer.setData(string, new Object[]{string, string2, bitSet}, this.atomCount, 0, 0, Integer.MAX_VALUE, 0);
                }
            }
            n += n2;
        }
    }

    protected void releaseModelSet() {
        this.group3Lists = null;
        this.group3Counts = null;
        this.groups = null;
        super.releaseModelSet();
    }

    private void initializeAtomBondModelCounts(int n) {
        int n2 = this.adapterTrajectoryCount;
        if (this.merging) {
            if (this.appendNew) {
                this.baseModelIndex = this.baseModelCount;
                this.modelCount = this.baseModelCount + this.adapterModelCount;
            } else {
                this.baseModelIndex = this.viewer.getCurrentModelIndex();
                if (this.baseModelIndex < 0) {
                    this.baseModelIndex = this.baseModelCount - 1;
                }
                this.modelCount = this.baseModelCount;
            }
            this.atomCount = this.baseAtomIndex = this.mergeModelSet.atomCount;
            this.bondCount = this.mergeModelSet.bondCount;
            this.groupCount = this.baseGroupIndex = this.mergeModelSet.groupCount;
            this.mergeModelArrays(this.mergeModelSet);
            this.growAtomArrays(this.atomCount + n);
        } else {
            this.modelCount = this.adapterModelCount;
            this.atomCount = 0;
            this.bondCount = 0;
            this.atoms = new Atom[n];
            this.bonds = new Bond[250 + n];
        }
        if (n2 > 1) {
            this.modelCount += n2 - 1;
        }
        this.models = (Model[])ArrayUtil.setLength(this.models, this.modelCount);
        this.modelFileNumbers = ArrayUtil.setLength(this.modelFileNumbers, this.modelCount);
        this.modelNumbers = ArrayUtil.setLength(this.modelNumbers, this.modelCount);
        this.modelNumbersForAtomLabel = ArrayUtil.setLength(this.modelNumbersForAtomLabel, this.modelCount);
        this.modelNames = ArrayUtil.setLength(this.modelNames, this.modelCount);
        this.frameTitles = ArrayUtil.setLength(this.frameTitles, this.modelCount);
        if (this.merging) {
            this.mergeModels(this.mergeModelSet);
        }
    }

    private void mergeGroups() {
        Hashtable hashtable = this.mergeModelSet.getAuxiliaryInfo(null);
        String[] stringArray = (String[])hashtable.get("group3Lists");
        int[][] nArray = (int[][])hashtable.get("group3Counts");
        if (stringArray != null) {
            for (int i = 0; i < this.baseModelCount; ++i) {
                this.group3Lists[i + 1] = stringArray[i + 1];
                this.group3Counts[i + 1] = nArray[i + 1];
                this.structuresDefinedInFile.set(i);
            }
            this.group3Lists[0] = stringArray[0];
            this.group3Counts[0] = nArray[0];
        }
        if (!this.appendNew && this.isPDB) {
            this.structuresDefinedInFile.clear(this.baseModelIndex);
        }
    }

    private void iterateOverAllNewModels(JmolAdapter jmolAdapter, Object object) {
        CharSequence charSequence;
        if (this.modelCount > 0) {
            this.nullGroup = new Group(new Chain(this, this.models[this.baseModelIndex], ' '), "", 0, -1, -1);
        }
        this.group3Lists = new String[this.modelCount + 1];
        this.group3Counts = new int[this.modelCount + 1][];
        this.structuresDefinedInFile = new BitSet();
        if (this.merging) {
            this.mergeGroups();
        }
        int n = this.isTrajectory ? this.baseTrajectoryCount : -1;
        int n2 = this.baseModelIndex;
        int n3 = 0;
        while (n3 < this.adapterModelCount) {
            boolean bl;
            int n4 = this.appendNew ? jmolAdapter.getAtomSetNumber(object, n3) : Integer.MAX_VALUE;
            charSequence = jmolAdapter.getAtomSetName(object, n3);
            Hashtable hashtable = jmolAdapter.getAtomSetAuxiliaryInfo(object, n3);
            Properties properties = (Properties)hashtable.get("modelProperties");
            this.viewer.setStringProperty("_fileType", (String)hashtable.get("fileType"));
            if (charSequence == null) {
                CharSequence charSequence2 = this.jmolData != null && this.jmolData.indexOf(";") > 2 ? this.jmolData.substring(this.jmolData.indexOf(":") + 2, this.jmolData.indexOf(";")) : (charSequence = n4 == Integer.MAX_VALUE ? "" : "" + n4 % 1000000);
            }
            if (bl = this.setModelNameNumberProperties(n2, n, (String)charSequence, n4, properties, hashtable, this.jmolData)) {
                this.group3Lists[n2 + 1] = JmolConstants.group3List;
                this.group3Counts[n2 + 1] = new int[JmolConstants.group3Count + 10];
                if (this.group3Lists[0] == null) {
                    this.group3Lists[0] = JmolConstants.group3List;
                    this.group3Counts[0] = new int[JmolConstants.group3Count + 10];
                }
            }
            if (this.getModelAuxiliaryInfo(n2, "periodicOriginXyz") != null) {
                this.someModelsHaveSymmetry = true;
            }
            ++n3;
            ++n2;
        }
        Model model = this.models[this.baseModelIndex];
        this.viewer.setSmilesString((String)this.modelSetAuxiliaryInfo.get("smilesString"));
        String string = (String)this.modelSetAuxiliaryInfo.remove("loadState");
        charSequence = (StringBuffer)this.modelSetAuxiliaryInfo.remove("loadScript");
        if (((StringBuffer)charSequence).indexOf("Viewer.AddHydrogens") < 0 || !model.isModelKit) {
            model.loadState = model.loadState + model.loadScript + string;
            model.loadScript = new StringBuffer();
            model.loadScript.append("  ").append((StringBuffer)charSequence).append(";\n");
        }
        if (this.isTrajectory) {
            Logger.info(this.modelCount - n2 + 1 + " trajectory steps read");
            int n5 = this.adapterModelCount;
            for (int i = n2; i < this.modelCount; ++i) {
                this.models[i] = this.models[this.baseModelCount];
                this.modelNumbers[i] = jmolAdapter.getAtomSetNumber(object, n5++);
                this.structuresDefinedInFile.set(i);
            }
        }
        this.finalizeModels(this.baseModelCount);
    }

    private boolean setModelNameNumberProperties(int n, int n2, String string, int n3, Properties properties, Hashtable hashtable, String string2) {
        boolean bl;
        if (n3 != Integer.MAX_VALUE) {
            this.models[n] = new Model(this, n, n2, string2, properties, hashtable);
            this.modelNumbers[n] = n3;
            this.modelNames[n] = string;
        }
        this.models[n].bsAtoms.set(this.atoms.length + 1);
        this.models[n].bsAtoms.clear(this.atoms.length + 1);
        String string3 = (String)this.getModelAuxiliaryInfo(n, "altLocs");
        this.models[n].setNAltLocs(string3 == null ? 0 : string3.length());
        if (string3 != null) {
            char[] cArray = string3.toCharArray();
            Arrays.sort(cArray);
            string3 = String.valueOf(cArray);
            this.setModelAuxiliaryInfo(n, "altLocs", string3);
        }
        string3 = (String)this.getModelAuxiliaryInfo(n, "insertionCodes");
        this.models[n].setNInsertions(string3 == null ? 0 : string3.length());
        this.models[n].isModelKit = bl = this.modelSetName != null && this.modelSetName.startsWith("Jmol Model Kit") || string.startsWith("Jmol Model Kit") || "Jme".equals(this.getModelAuxiliaryInfo(n, "fileType"));
        this.models[n].isPDB = this.getModelAuxiliaryInfoBoolean(n, "isPDB");
        return this.models[n].isPDB;
    }

    private void finalizeModels(int n) {
        int n2;
        int n3;
        if (this.modelCount == n) {
            return;
        }
        int n4 = 0;
        int n5 = -1;
        if (this.isTrajectory) {
            n3 = n;
            while (++n3 < this.modelCount) {
                this.modelNumbers[n3] = this.modelNumbers[n3 - 1] + 1;
            }
        }
        if (n > 0) {
            if (this.modelNumbers[0] < 1000000) {
                for (n3 = 0; n3 < n; ++n3) {
                    if (this.modelNames[n3].length() == 0) {
                        this.modelNames[n3] = "" + this.modelNumbers[n3];
                    }
                    int n6 = n3;
                    this.modelNumbers[n6] = this.modelNumbers[n6] + 1000000;
                    this.modelNumbersForAtomLabel[n3] = "1." + (n3 + 1);
                }
            }
            n3 = this.modelNumbers[n - 1];
            n3 -= n3 % 1000000;
            if (this.modelNumbers[n] < 1000000) {
                n3 += 1000000;
            }
            n2 = n;
            while (n2 < this.modelCount) {
                int n7 = n2++;
                this.modelNumbers[n7] = this.modelNumbers[n7] + n3;
            }
        }
        for (n3 = n; n3 < this.modelCount; ++n3) {
            String string;
            if (this.fileHeader != null) {
                this.setModelAuxiliaryInfo(n3, "fileHeader", this.fileHeader);
            }
            if ((n2 = this.modelNumbers[n3] / 1000000) != n5) {
                n4 = 0;
                n5 = n2;
            }
            ++n4;
            if (n2 == 0) {
                string = "" + this.getModelNumber(n3);
                n2 = 1;
            } else {
                string = n2 + "." + n4;
            }
            this.modelNumbersForAtomLabel[n3] = string;
            this.models[n3].fileIndex = n2 - 1;
            this.modelFileNumbers[n3] = n2 * 1000000 + n4;
            if (this.modelNames[n3] != null && this.modelNames[n3].length() != 0) continue;
            this.modelNames[n3] = string;
        }
        if (this.merging) {
            for (n3 = 0; n3 < n; ++n3) {
                this.models[n3].modelSet = this;
            }
        }
        for (n3 = 0; n3 < this.modelCount; ++n3) {
            this.setModelAuxiliaryInfo(n3, "modelName", this.modelNames[n3]);
            this.setModelAuxiliaryInfo(n3, "modelNumber", this.modelNumbers[n3] % 1000000);
            this.setModelAuxiliaryInfo(n3, "modelFileNumber", this.modelFileNumbers[n3]);
            this.setModelAuxiliaryInfo(n3, "modelNumberDotted", this.getModelNumberDotted(n3));
            String string = (String)this.getModelAuxiliaryInfo(n3, "altLocs");
            if (string == null) continue;
            Logger.info("model " + this.getModelNumberDotted(n3) + " alternative locations: " + string);
        }
    }

    private void iterateOverAllNewAtoms(JmolAdapter jmolAdapter, Object object) {
        int n;
        int n2 = -1;
        boolean bl = false;
        JmolAdapter.AtomIterator atomIterator = jmolAdapter.getAtomIterator(object);
        while (atomIterator.hasNext()) {
            n = atomIterator.getAtomSetIndex() + this.baseModelIndex;
            if (n != n2) {
                this.currentModelIndex = n;
                this.currentModel = this.models[n];
                this.currentChainID = (char)65535;
                this.models[n].bsAtoms.clear();
                bl = this.models[n].isPDB;
                n2 = n;
            }
            this.addAtom(bl, atomIterator.getAtomSymmetry(), atomIterator.getAtomSite(), atomIterator.getUniqueID(), atomIterator.getElementNumber(), atomIterator.getAtomName(), atomIterator.getFormalCharge(), atomIterator.getPartialCharge(), atomIterator.getEllipsoid(), atomIterator.getOccupancy(), atomIterator.getBfactor(), atomIterator.getX(), atomIterator.getY(), atomIterator.getZ(), atomIterator.getIsHetero(), atomIterator.getAtomSerial(), atomIterator.getChainID(), atomIterator.getGroup3(), atomIterator.getSequenceNumber(), atomIterator.getInsertionCode(), atomIterator.getVectorX(), atomIterator.getVectorY(), atomIterator.getVectorZ(), atomIterator.getAlternateLocationID(), atomIterator.getRadius());
        }
        n2 = -1;
        n = -1;
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.atoms[i].modelIndex == n2) continue;
            n2 = this.atoms[i].modelIndex;
            this.models[n2].firstAtomIndex = i;
            int n3 = this.getDefaultVdwType(n2);
            if (n3 == n) continue;
            Logger.info("Default Van der Waals type for model set to " + JmolConstants.getVdwLabel(n3));
            n = n3;
        }
    }

    private void addAtom(boolean bl, BitSet bitSet, int n, Object object, short s, String string, int n2, float f, Object[] objectArray, int n3, float f2, float f3, float f4, float f5, boolean bl2, int n4, char c, String string2, int n5, char c2, float f6, float f7, float f8, char c3, float f9) {
        this.checkNewGroup(c, string2, n5, c2);
        byte by = 0;
        if (string != null) {
            if (bl && string.indexOf(42) >= 0) {
                string = string.replace('*', '\'');
            }
            by = JmolConstants.lookupSpecialAtomID(string);
            if (bl && by == 2 && "CA".equalsIgnoreCase(string2)) {
                by = 0;
            }
        }
        Atom atom = this.addAtom(this.currentModelIndex, this.nullGroup, s, string, n4, n, f3, f4, f5, f9, f6, f7, f8, n2, f, n3, f2, objectArray, bl2, c3, by, bitSet);
        this.htAtomMap.put(object, atom);
    }

    private void checkNewGroup(char c, String string, int n, char c2) {
        String string2;
        String string3 = string2 = string == null ? null : string.intern();
        if (c != this.currentChainID) {
            this.currentChainID = c;
            this.currentChain = this.getOrAllocateChain(this.currentModel, c);
            this.currentGroupInsertionCode = (char)65535;
            this.currentGroupSequenceNumber = -1;
            this.currentGroup3 = "xxxx";
        }
        if (n != this.currentGroupSequenceNumber || c2 != this.currentGroupInsertionCode || string2 != this.currentGroup3) {
            this.currentGroupSequenceNumber = n;
            this.currentGroupInsertionCode = c2;
            this.currentGroup3 = string2;
            while (this.groupCount >= this.group3Of.length) {
                this.chainOf = (Chain[])ArrayUtil.doubleLength(this.chainOf);
                this.group3Of = ArrayUtil.doubleLength(this.group3Of);
                this.seqcodes = ArrayUtil.doubleLength(this.seqcodes);
                this.firstAtomIndexes = ArrayUtil.doubleLength(this.firstAtomIndexes);
            }
            this.firstAtomIndexes[this.groupCount] = this.atomCount;
            this.chainOf[this.groupCount] = this.currentChain;
            this.group3Of[this.groupCount] = string;
            this.seqcodes[this.groupCount] = Group.getSeqcode(n, c2);
            ++this.groupCount;
        }
    }

    private Chain getOrAllocateChain(Model model, char c) {
        Chain chain = model.getChain(c);
        if (chain != null) {
            return chain;
        }
        if (model.chainCount == model.chains.length) {
            model.chains = (Chain[])ArrayUtil.doubleLength(model.chains);
        }
        Chain chain2 = new Chain(this, model, c);
        model.chains[model.chainCount++] = chain2;
        return chain2;
    }

    private void iterateOverAllNewBonds(JmolAdapter jmolAdapter, Object object) {
        JmolAdapter.BondIterator bondIterator = jmolAdapter.getBondIterator(object);
        if (bondIterator == null) {
            return;
        }
        short s = this.viewer.getMadBond();
        this.defaultCovalentMad = this.jmolData == null ? s : (short)0;
        boolean bl = false;
        while (bondIterator.hasNext()) {
            short s2 = (short)bondIterator.getEncodedOrder();
            this.bondAtoms(bondIterator.getAtomUniqueID1(), bondIterator.getAtomUniqueID2(), s2);
            if (s2 <= 1 || s2 == 1025 || s2 == 1041) continue;
            bl = true;
        }
        if (bl && this.someModelsHaveSymmetry && !this.viewer.getApplySymmetryToBonds()) {
            Logger.info("ModelSet: use \"set appletSymmetryToBonds TRUE \" to apply the file-based multiple bonds to symmetry-generated atoms.");
        }
        this.defaultCovalentMad = s;
    }

    private void bondAtoms(Object object, Object object2, short s) {
        Bond bond;
        boolean bl;
        Atom atom = (Atom)this.htAtomMap.get(object);
        if (atom == null) {
            Logger.error("bondAtoms cannot find atomUid1?:" + object);
            return;
        }
        Atom atom2 = (Atom)this.htAtomMap.get(object2);
        if (atom2 == null) {
            Logger.error("bondAtoms cannot find atomUid2?:" + object2);
            return;
        }
        if (atom.isBonded(atom2)) {
            return;
        }
        boolean bl2 = s == 1025;
        boolean bl3 = bl = s == 1041;
        if (bl2 || bl) {
            bond = this.bondMutually(atom, atom2, this.is2D ? s : (short)1, this.getDefaultMadFromOrder(1), 0.0f);
            if (this.vStereo == null) {
                this.vStereo = new ArrayList();
            }
            this.vStereo.add(bond);
        } else {
            bond = this.bondMutually(atom, atom2, s, this.getDefaultMadFromOrder(s), 0.0f);
            if (bond.isAromatic()) {
                this.someModelsHaveAromaticBonds = true;
            }
        }
        if (this.bondCount == this.bonds.length) {
            this.bonds = (Bond[])ArrayUtil.setLength(this.bonds, this.bondCount + 250);
        }
        this.setBond(this.bondCount++, bond);
    }

    private void iterateOverAllNewStructures(JmolAdapter jmolAdapter, Object object) {
        JmolAdapter.StructureIterator structureIterator = jmolAdapter.getStructureIterator(object);
        if (structureIterator != null) {
            while (structureIterator.hasNext()) {
                if (structureIterator.getStructureType() == 1) continue;
                this.defineStructure(structureIterator.getModelIndex(), structureIterator.getSubstructureType(), structureIterator.getStructureID(), structureIterator.getSerialID(), structureIterator.getStrandCount(), structureIterator.getStartChainID(), structureIterator.getStartSequenceNumber(), structureIterator.getStartInsertionCode(), structureIterator.getEndChainID(), structureIterator.getEndSequenceNumber(), structureIterator.getEndInsertionCode());
            }
        }
        if ((structureIterator = jmolAdapter.getStructureIterator(object)) != null) {
            while (structureIterator.hasNext()) {
                if (structureIterator.getStructureType() != 1) continue;
                this.defineStructure(structureIterator.getModelIndex(), structureIterator.getSubstructureType(), structureIterator.getStructureID(), 1, 1, structureIterator.getStartChainID(), structureIterator.getStartSequenceNumber(), structureIterator.getStartInsertionCode(), structureIterator.getEndChainID(), structureIterator.getEndSequenceNumber(), structureIterator.getEndInsertionCode());
            }
        }
    }

    private void defineStructure(int n, int n2, String string, int n3, int n4, char c, int n5, char c2, char c3, int n6, char c4) {
        byte by = (byte)n2;
        if (by < 0) {
            by = 0;
        }
        int n7 = Group.getSeqcode(n5, c2);
        int n8 = Group.getSeqcode(n6, c4);
        if (n >= 0 || this.isTrajectory) {
            if (this.isTrajectory) {
                n = 0;
            }
            this.structuresDefinedInFile.set(n += this.baseModelIndex);
            this.models[n].addSecondaryStructure(by, string, n3, n4, c, n7, c3, n8);
            return;
        }
        for (int i = this.baseModelIndex; i < this.modelCount; ++i) {
            this.structuresDefinedInFile.set(i);
            this.models[i].addSecondaryStructure(by, string, n3, n4, c, n7, c3, n8);
        }
    }

    private void initializeUnitCellAndSymmetry() {
        int n;
        int n2;
        if (this.someModelsHaveUnitcells) {
            this.unitCells = new SymmetryInterface[this.modelCount];
            n2 = this.mergeModelSet != null && this.mergeModelSet.unitCells != null ? 1 : 0;
            for (n = 0; n < this.modelCount; ++n) {
                if (n2 != 0 && n < this.baseModelCount) {
                    this.unitCells[n] = this.mergeModelSet.unitCells[n];
                    continue;
                }
                this.unitCells[n] = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
                this.unitCells[n].setSymmetryInfo(n, this.getModelAuxiliaryInfo(n));
            }
        }
        if (this.someModelsHaveSymmetry) {
            this.getAtomBits(1089470477, null);
            n = -1;
            int n3 = 0;
            for (n2 = this.baseAtomIndex; n2 < this.atomCount; ++n2) {
                if (this.atoms[n2].modelIndex != n) {
                    n = this.atoms[n2].modelIndex;
                    n3 = this.baseAtomIndex + this.getModelAuxiliaryInfoInt(n, "presymmetryAtomIndex") + this.getModelAuxiliaryInfoInt(n, "presymmetryAtomCount");
                }
                if (n2 < n3) continue;
                this.bsSymmetry.set(n2);
            }
        }
        if (this.someModelsHaveFractionalCoordinates) {
            for (n2 = this.baseAtomIndex; n2 < this.atomCount; ++n2) {
                n = this.atoms[n2].modelIndex;
                if (!this.unitCells[n].getCoordinatesAreFractional()) continue;
                this.unitCells[n].toCartesian(this.atoms[n2], false);
            }
        }
    }

    private void initializeBonding() {
        BitSet bitSet;
        BitSet bitSet2 = bitSet = this.getModelSetAuxiliaryInfo("someModelsHaveCONECT") == null ? null : new BitSet();
        if (bitSet != null) {
            this.setPdbConectBonding(this.baseAtomIndex, this.baseModelIndex, bitSet);
        }
        int n = this.baseAtomIndex;
        int n2 = 0;
        boolean bl = this.viewer.getApplySymmetryToBonds();
        boolean bl2 = this.viewer.getAutoBond();
        boolean bl3 = this.viewer.getForceAutoBond();
        BitSet bitSet3 = null;
        boolean bl4 = false;
        if (!this.noAutoBond) {
            for (int i = this.baseModelIndex; i < this.modelCount; ++i) {
                boolean bl5;
                n2 = this.models[i].bsAtoms.cardinality();
                int n3 = this.getModelAuxiliaryInfoInt(i, "initialBondCount");
                boolean bl6 = this.models[i].isPDB;
                if (n3 < 0) {
                    n3 = this.bondCount;
                }
                boolean bl7 = this.getModelAuxiliaryInfoBoolean(i, "hasSymmetry");
                boolean bl8 = bl5 = bl3 || bl2 && (n3 == 0 || bl6 && this.jmolData == null && n3 < n2 / 2 || bl7 && !bl);
                if (bl5) {
                    bl4 = true;
                    if (this.merging || this.modelCount > 1) {
                        if (bitSet3 == null) {
                            bitSet3 = new BitSet(this.atomCount);
                        }
                        if (i == this.baseModelIndex || !this.isTrajectory) {
                            bitSet3.or(this.models[i].bsAtoms);
                        }
                    }
                }
                n += n2;
            }
        }
        if (bl4) {
            this.autoBond(bitSet3, bitSet3, bitSet, null, this.defaultCovalentMad);
            Logger.info("ModelSet: autobonding; use  autobond=false  to not generate bonds automatically");
        } else {
            Logger.info("ModelSet: not autobonding; use  forceAutobond=true  to force automatic bond creation");
        }
    }

    private void finalizeGroupBuild() {
        int n;
        this.groups = new Group[this.groupCount];
        if (this.merging) {
            for (n = 0; n < this.baseGroupIndex; ++n) {
                this.groups[n] = this.mergeModelSet.groups[n];
                this.groups[n].setModelSet(this);
            }
        }
        for (n = this.baseGroupIndex; n < this.groupCount; ++n) {
            this.distinguishAndPropagateGroup(n, this.chainOf[n], this.group3Of[n], this.seqcodes[n], this.firstAtomIndexes[n], n == this.groupCount - 1 ? this.atomCount : this.firstAtomIndexes[n + 1]);
            this.chainOf[n] = null;
            this.group3Of[n] = null;
        }
        this.chainOf = null;
        this.group3Of = null;
        if (this.group3Lists != null && this.modelSetAuxiliaryInfo != null) {
            this.modelSetAuxiliaryInfo.put("group3Lists", this.group3Lists);
            this.modelSetAuxiliaryInfo.put("group3Counts", this.group3Counts);
        }
        this.group3Counts = null;
        this.group3Lists = null;
    }

    private void distinguishAndPropagateGroup(int n, Chain chain, String string, int n2, int n3, int n4) {
        Object object;
        int n5 = n4 - 1;
        if (n5 < n3) {
            throw new NullPointerException();
        }
        short s = this.atoms[n3].modelIndex;
        Group group = null;
        if (string != null && this.haveBioClasses) {
            if (this.jbr == null) {
                try {
                    object = Class.forName("org.jmol.modelsetbio.Resolver");
                    this.jbr = (JmolBioResolver)((Class)object).newInstance();
                    this.haveBioClasses = true;
                }
                catch (Exception exception) {
                    Logger.error("developer error: org.jmol.modelsetbio.Resolver could not be found");
                    this.haveBioClasses = false;
                }
            }
            if (this.haveBioClasses) {
                group = this.jbr.distinguishAndPropagateGroup(chain, string, n2, n3, n4, s, this.specialAtomIndexes, this.atoms);
            }
        }
        if (group == null) {
            group = new Group(chain, string, n2, n3, n5);
            object = "o>";
        } else {
            Object object2 = group.isProtein() ? "p>" : (group.isNucleic() ? "n>" : (object = group.isCarbohydrate() ? "c>" : "o>"));
        }
        if (string != null) {
            this.countGroup(s, (String)object, string);
        }
        this.addGroup(chain, group);
        this.groups[n] = group;
        group.setGroupIndex(n);
        int n6 = n4;
        while (--n6 >= n3) {
            this.atoms[n6].setGroup(group);
        }
    }

    private void addGroup(Chain chain, Group group) {
        if (chain.groupCount == chain.groups.length) {
            chain.groups = (Group[])ArrayUtil.doubleLength(chain.groups);
        }
        chain.groups[chain.groupCount++] = group;
    }

    private void countGroup(int n, String string, String string2) {
        int n2 = n + 1;
        if (this.group3Lists == null || this.group3Lists[n2] == null) {
            return;
        }
        String string3 = (string2 + "   ").substring(0, 3);
        int n3 = this.group3Lists[n2].indexOf(string3);
        if (n3 < 0) {
            int n4 = n2;
            this.group3Lists[n4] = this.group3Lists[n4] + ",[" + string3 + "]";
            n3 = this.group3Lists[n2].indexOf(string3);
            this.group3Counts[n2] = ArrayUtil.setLength(this.group3Counts[n2], this.group3Counts[n2].length + 10);
        }
        int[] nArray = this.group3Counts[n2];
        int n5 = n3 / 6;
        nArray[n5] = nArray[n5] + 1;
        n3 = this.group3Lists[n2].indexOf(",[" + string3);
        if (n3 >= 0) {
            this.group3Lists[n2] = this.group3Lists[n2].substring(0, n3) + string + this.group3Lists[n2].substring(n3 + 2);
        }
        if (n >= 0) {
            this.countGroup(-1, string, string2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void freeze() {
        Object object;
        void var1_2;
        this.htAtomMap.clear();
        if (this.atomCount < this.atoms.length) {
            this.growAtomArrays(this.atomCount);
        }
        if (this.bondCount < this.bonds.length) {
            this.bonds = (Bond[])ArrayUtil.setLength(this.bonds, this.bondCount);
        }
        int bl = 5;
        while (--var1_2 > 0) {
            this.numCached[var1_2] = 0;
            object = this.freeBonds[var1_2];
            int n = ((Bond[][])object).length;
            while (--n >= 0) {
                object[n] = null;
            }
        }
        this.setAtomNamesAndNumbers(0, this.baseAtomIndex, this.mergeModelSet);
        this.findElementsPresent();
        this.molecules = null;
        this.moleculeCount = 0;
        this.currentModel = null;
        this.currentChain = null;
        if (!this.isPDB) {
            return;
        }
        boolean bl2 = this.viewer.getDefaultStructureDSSP();
        object = this.calculateStructuresAllExcept(this.structuresDefinedInFile, bl2, false, true, true, bl2);
        if (((String)object).length() > 0) {
            Logger.info((String)object);
        }
    }

    private void findElementsPresent() {
        int n;
        this.elementsPresent = new BitSet[this.modelCount];
        for (n = 0; n < this.modelCount; ++n) {
            this.elementsPresent[n] = new BitSet(64);
        }
        n = this.atomCount;
        while (--n >= 0) {
            int n2 = this.atoms[n].getAtomicAndIsotopeNumber();
            if (n2 >= Elements.elementNumberMax) {
                n2 = Elements.elementNumberMax + Elements.altElementIndexFromNumber(n2);
            }
            this.elementsPresent[this.atoms[n].modelIndex].set(n2);
        }
    }

    private void applyStereochemistry() {
        this.set2dZ(this.baseAtomIndex, this.atomCount);
        if (this.vStereo != null) {
            BitSet bitSet = new BitSet();
            bitSet.set(this.baseAtomIndex, this.atomCount);
            int n = this.vStereo.size();
            while (--n >= 0) {
                Bond bond = (Bond)this.vStereo.get(n);
                float f = bond.order == 1025 ? 3 : -3;
                bond.order = 1;
                if (bond.atom2.z != bond.atom1.z && f < 0.0f == bond.atom2.z < bond.atom1.z) {
                    f /= 3.0f;
                }
                BitSet bitSet2 = JmolMolecule.getBranchBitSet(this.atoms, bitSet, bond.atom2.index, bond.atom1.index, false, true);
                bitSet2.set(bond.atom2.index);
                int n2 = bitSet2.nextSetBit(0);
                while (n2 >= 0) {
                    this.atoms[n2].z += f;
                    n2 = bitSet2.nextSetBit(n2 + 1);
                }
                bond.atom2.x = (bond.atom1.x + bond.atom2.x) / 2.0f;
                bond.atom2.y = (bond.atom1.y + bond.atom2.y) / 2.0f;
            }
            this.vStereo = null;
        }
        this.is2D = false;
    }

    private void set2dZ(int n, int n2) {
        BitSet bitSet = new BitSet(n2);
        BitSet bitSet2 = new BitSet();
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f vector3f3 = new Vector3f();
        BitSet bitSet3 = new BitSet();
        bitSet3.set(n, n2);
        for (int i = n; i < n2; ++i) {
            if (bitSet.get(i) || bitSet2.get(i)) continue;
            bitSet2 = this.getBranch2dZ(i, -1, bitSet3, bitSet2, vector3f, vector3f2, vector3f3);
            bitSet.or(bitSet2);
        }
    }

    private BitSet getBranch2dZ(int n, int n2, BitSet bitSet, BitSet bitSet2, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        BitSet bitSet3 = new BitSet(this.atomCount);
        if (n < 0) {
            return bitSet3;
        }
        BitSet bitSet4 = new BitSet();
        bitSet4.or(bitSet);
        if (n2 >= 0) {
            bitSet4.clear(n2);
        }
        ModelLoader.setBranch2dZ(this.atoms[n], bitSet3, bitSet4, vector3f, vector3f2, vector3f3);
        return bitSet3;
    }

    private static void setBranch2dZ(Atom atom, BitSet bitSet, BitSet bitSet2, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        int n = atom.index;
        if (!bitSet2.get(n)) {
            return;
        }
        bitSet2.clear(n);
        bitSet.set(n);
        if (atom.bonds == null) {
            return;
        }
        int n2 = atom.bonds.length;
        while (--n2 >= 0) {
            Bond bond = atom.bonds[n2];
            if ((bond.order & 0x7800) != 0) continue;
            Atom atom2 = bond.getOtherAtom(atom);
            ModelLoader.setAtom2dZ(atom, atom2, vector3f, vector3f2, vector3f3);
            ModelLoader.setBranch2dZ(atom2, bitSet, bitSet2, vector3f, vector3f2, vector3f3);
        }
    }

    private static void setAtom2dZ(Atom atom, Atom atom2, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        vector3f.set(atom2);
        vector3f.sub(atom);
        vector3f.z = 0.0f;
        vector3f.normalize();
        vector3f3.cross(vector3f2, vector3f);
        double d = Math.acos(vector3f.dot(vector3f2));
        atom2.z = atom.z + (float)((double)0.8f * Math.sin(4.0 * d));
    }

    private void finalizeShapes() {
        this.shapeManager = this.viewer.getShapeManager();
        if (!this.merging) {
            this.shapeManager.resetShapes();
        }
        this.shapeManager.loadDefaultShapes(this);
        if (this.someModelsHaveAromaticBonds && this.viewer.getSmartAromatic()) {
            this.assignAromaticBonds(false);
        }
        if (this.merging) {
            if (this.baseModelCount == 1) {
                this.shapeManager.setShapeProperty(6, "clearModelIndex", null, null);
            }
            this.merging = false;
        }
    }

    public void createAtomDataSet(int n, Object object, BitSet bitSet) {
        int n2;
        if (object == null) {
            return;
        }
        JmolAdapter jmolAdapter = this.viewer.getModelAdapter();
        Point3f point3f = new Point3f();
        Point3f point3f2 = new Point3f();
        float f = this.viewer.getLoadAtomDataTolerance();
        if (this.unitCells != null) {
            n2 = bitSet.nextSetBit(0);
            while (n2 >= 0) {
                if (this.atoms[n2].getAtomSymmetry() != null) {
                    f = -f;
                    break;
                }
                n2 = bitSet.nextSetBit(n2 + 1);
            }
        }
        n2 = -1;
        int n3 = 0;
        boolean bl = BitSetUtil.cardinalityOf(bitSet) == this.viewer.getAtomCount();
        Object object2 = jmolAdapter.getAtomIterator(object);
        while (((JmolAdapter.AtomIterator)object2).hasNext()) {
            float f2;
            float f3;
            float f4 = ((JmolAdapter.AtomIterator)object2).getX();
            if (Float.isNaN(f4 + (f3 = ((JmolAdapter.AtomIterator)object2).getY()) + (f2 = ((JmolAdapter.AtomIterator)object2).getZ()))) continue;
            if (n == 1146095626) {
                if ((n2 = bitSet.nextSetBit(n2 + 1)) < 0) break;
                ++n3;
                if (Logger.debugging) {
                    Logger.debug("atomIndex = " + n2 + ": " + this.atoms[n2] + " --> (" + f4 + "," + f3 + "," + f2);
                }
                this.setAtomCoord(n2, f4, f3, f2);
                continue;
            }
            point3f.set(f4, f3, f2);
            BitSet bitSet2 = new BitSet(this.atomCount);
            this.getAtomsWithin(f, point3f, bitSet2, -1);
            bitSet2.and(bitSet);
            if (bl) {
                n3 = BitSetUtil.cardinalityOf(bitSet2);
                if (n3 == 0) {
                    Logger.warn("createAtomDataSet: no atom found at position " + point3f);
                    continue;
                }
                if (n3 > 1 && Logger.debugging) {
                    Logger.debug("createAtomDataSet: " + n3 + " atoms found at position " + point3f);
                }
            }
            switch (n) {
                case 1146095630: {
                    float f5 = ((JmolAdapter.AtomIterator)object2).getVectorX();
                    float f6 = ((JmolAdapter.AtomIterator)object2).getVectorY();
                    float f7 = ((JmolAdapter.AtomIterator)object2).getVectorZ();
                    if (Float.isNaN(f5 + f6 + f7)) break;
                    point3f2.set(f5, f6, f7);
                    if (Logger.debugging) {
                        Logger.info("xyz: " + point3f + " vib: " + point3f2);
                    }
                    this.setAtomCoord(bitSet2, 1146095630, point3f2);
                    break;
                }
                case 1129318402: {
                    this.setAtomProperty(bitSet2, n, ((JmolAdapter.AtomIterator)object2).getOccupancy(), 0.0f, null, null, null);
                    break;
                }
                case 1112541195: {
                    this.setAtomProperty(bitSet2, n, 0, ((JmolAdapter.AtomIterator)object2).getPartialCharge(), null, null, null);
                    break;
                }
                case 1112541198: {
                    this.setAtomProperty(bitSet2, n, 0, ((JmolAdapter.AtomIterator)object2).getBfactor(), null, null, null);
                }
            }
        }
        switch (n) {
            case 1146095630: {
                object2 = jmolAdapter.getAtomSetName(object, 0);
                Logger.info("_vibrationName = " + (String)object2);
                this.viewer.setStringProperty("_vibrationName", (String)object2);
                break;
            }
            case 1146095626: {
                Logger.info(n3 + " atom positions read");
                this.recalculateLeadMidpointsAndWingVectors(-1);
            }
        }
    }
}

