/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.util.Measure;
import org.jmol.util.Point3fi;
import org.jmol.util.TriangleData;

public class BoxInfo {
    private final Point3f bbCorner0 = new Point3f(-10.0f, -10.0f, -10.0f);
    private final Point3f bbCorner1 = new Point3f(10.0f, 10.0f, 10.0f);
    private final Point3f bbCenter = new Point3f();
    private final Vector3f bbVector = new Vector3f(-1.0f, -1.0f, -1.0f);
    private final Point3fi[] bbVertices = new Point3fi[8];
    public static char[] bbcageTickEdges = new char[]{'z', '\u0000', '\u0000', 'y', 'x', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    public static char[] uccageTickEdges = new char[]{'z', 'y', 'x', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    public static final byte[] edges = new byte[]{0, 1, 0, 2, 0, 4, 1, 3, 1, 5, 2, 3, 2, 6, 3, 7, 4, 5, 4, 6, 5, 7, 6, 7};
    public static final Point3f[] unitCubePoints = new Point3f[]{new Point3f(0.0f, 0.0f, 0.0f), new Point3f(0.0f, 0.0f, 1.0f), new Point3f(0.0f, 1.0f, 0.0f), new Point3f(0.0f, 1.0f, 1.0f), new Point3f(1.0f, 0.0f, 0.0f), new Point3f(1.0f, 0.0f, 1.0f), new Point3f(1.0f, 1.0f, 0.0f), new Point3f(1.0f, 1.0f, 1.0f)};
    private static Point3i[] facePoints = new Point3i[]{new Point3i(4, 0, 6), new Point3i(4, 6, 5), new Point3i(5, 7, 1), new Point3i(1, 3, 0), new Point3i(6, 2, 7), new Point3i(1, 0, 5)};
    public static final int[] toCanonical = new int[]{0, 3, 4, 7, 1, 2, 5, 6};
    protected static final Point3i[] cubeVertexOffsets = new Point3i[]{new Point3i(0, 0, 0), new Point3i(1, 0, 0), new Point3i(1, 0, 1), new Point3i(0, 0, 1), new Point3i(0, 1, 0), new Point3i(1, 1, 0), new Point3i(1, 1, 1), new Point3i(0, 1, 1)};
    private static final Point3f[] unitBboxPoints = new Point3f[8];

    public BoxInfo() {
        int n = 8;
        while (--n >= 0) {
            this.bbVertices[n] = new Point3fi();
        }
        for (n = 0; n < 8; ++n) {
            BoxInfo.unitBboxPoints[n] = new Point3f(-1.0f, -1.0f, -1.0f);
            unitBboxPoints[n].scaleAdd(2.0f, unitCubePoints[n], unitBboxPoints[n]);
        }
    }

    public Vector intersectPlane(Point4f point4f, float f, int n) {
        Vector<Point3f[]> vector = new Vector<Point3f[]>();
        vector.add(this.getCanonicalCopy(f));
        return TriangleData.intersectPlane(point4f, vector, n);
    }

    public Point3f[] getCanonicalCopy(float f) {
        return BoxInfo.getCanonicalCopy(this.bbVertices, f);
    }

    public static final Point3f[] getCanonicalCopy(Point3f[] point3fArray, float f) {
        Point3f[] point3fArray2 = new Point3f[8];
        for (int i = 0; i < 8; ++i) {
            point3fArray2[BoxInfo.toCanonical[i]] = new Point3f(point3fArray[i]);
        }
        BoxInfo.scaleBox(point3fArray2, f);
        return point3fArray2;
    }

    public static void scaleBox(Point3f[] point3fArray, float f) {
        int n;
        if (f == 0.0f || f == 1.0f) {
            return;
        }
        Point3f point3f = new Point3f();
        Vector3f vector3f = new Vector3f();
        for (n = 0; n < 8; ++n) {
            point3f.add(point3fArray[n]);
        }
        point3f.scale(0.125f);
        for (n = 0; n < 8; ++n) {
            vector3f.sub(point3fArray[n], point3f);
            vector3f.scale(f);
            point3fArray[n].add(point3f, vector3f);
        }
    }

    public static Point4f[] getFacesFromCriticalPoints(Point3f[] point3fArray) {
        int n;
        Point4f[] point4fArray = new Point4f[6];
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Point3f point3f = new Point3f();
        Point3f point3f2 = new Point3f();
        Point3f point3f3 = new Point3f();
        Point3f[] point3fArray2 = new Point3f[8];
        for (n = 0; n < 8; ++n) {
            point3fArray2[n] = new Point3f(point3fArray[0]);
            if ((n & 1) == 1) {
                point3fArray2[n].add(point3fArray[1]);
            }
            if ((n & 2) == 2) {
                point3fArray2[n].add(point3fArray[2]);
            }
            if ((n & 4) != 4) continue;
            point3fArray2[n].add(point3fArray[3]);
        }
        for (n = 0; n < 6; ++n) {
            point3f.set(point3fArray2[BoxInfo.facePoints[n].x]);
            point3f2.set(point3fArray2[BoxInfo.facePoints[n].y]);
            point3f3.set(point3fArray2[BoxInfo.facePoints[n].z]);
            point4fArray[n] = Measure.getPlaneThroughPoints(point3f, point3f2, point3f3, vector3f, vector3f2, vector3f3);
        }
        return point4fArray;
    }

    public static final Point3f[] getCriticalPoints(Point3f[] point3fArray, Point3f point3f) {
        Point3f point3f2 = new Point3f(point3fArray[0]);
        Point3f point3f3 = new Point3f(point3fArray[1]);
        Point3f point3f4 = new Point3f(point3fArray[2]);
        Point3f point3f5 = new Point3f(point3fArray[4]);
        point3f3.sub(point3f2);
        point3f4.sub(point3f2);
        point3f5.sub(point3f2);
        if (point3f != null) {
            point3f2.add(point3f);
        }
        return new Point3f[]{point3f2, point3f3, point3f4, point3f5};
    }

    public Point3f getBoundBoxCenter() {
        return this.bbCenter;
    }

    public Vector3f getBoundBoxCornerVector() {
        return this.bbVector;
    }

    public Point3f[] getBoundBoxPoints() {
        return new Point3f[]{this.bbCenter, new Point3f(this.bbVector), this.bbCorner0, this.bbCorner1};
    }

    public Point3fi[] getBboxVertices() {
        return this.bbVertices;
    }

    Hashtable getBoundBoxInfo() {
        Hashtable<String, Tuple3f> hashtable = new Hashtable<String, Tuple3f>();
        hashtable.put("center", new Point3f(this.bbCenter));
        hashtable.put("vector", new Vector3f(this.bbVector));
        hashtable.put("corner0", new Point3f(this.bbCorner0));
        hashtable.put("corner1", new Point3f(this.bbCorner1));
        return hashtable;
    }

    void setBoundBox(Point3f point3f, Point3f point3f2, boolean bl, float f) {
        if (point3f != null) {
            if (f == 0.0f) {
                return;
            }
            if (bl) {
                if (point3f.distance(point3f2) == 0.0f) {
                    return;
                }
                this.bbCorner0.set(Math.min(point3f.x, point3f2.x), Math.min(point3f.y, point3f2.y), Math.min(point3f.z, point3f2.z));
                this.bbCorner1.set(Math.max(point3f.x, point3f2.x), Math.max(point3f.y, point3f2.y), Math.max(point3f.z, point3f2.z));
            } else {
                if (point3f2.x == 0.0f || point3f2.y == 0.0f && point3f2.z == 0.0f) {
                    return;
                }
                this.bbCorner0.set(point3f.x - point3f2.x, point3f.y - point3f2.y, point3f.z - point3f2.z);
                this.bbCorner1.set(point3f.x + point3f2.x, point3f.y + point3f2.y, point3f.z + point3f2.z);
            }
        }
        this.setBbcage(f);
    }

    void reset() {
        this.bbCorner0.set(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        this.bbCorner1.set(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
    }

    void addBoundBoxPoint(Point3f point3f) {
        float f = point3f.x;
        if (f < this.bbCorner0.x) {
            this.bbCorner0.x = f;
        }
        if (f > this.bbCorner1.x) {
            this.bbCorner1.x = f;
        }
        if ((f = point3f.y) < this.bbCorner0.y) {
            this.bbCorner0.y = f;
        }
        if (f > this.bbCorner1.y) {
            this.bbCorner1.y = f;
        }
        if ((f = point3f.z) < this.bbCorner0.z) {
            this.bbCorner0.z = f;
        }
        if (f > this.bbCorner1.z) {
            this.bbCorner1.z = f;
        }
    }

    void setBbcage(float f) {
        this.bbCenter.add(this.bbCorner0, this.bbCorner1);
        this.bbCenter.scale(0.5f);
        this.bbVector.sub(this.bbCorner1, this.bbCenter);
        if (f > 0.0f) {
            this.bbVector.scale(f);
        } else {
            this.bbVector.x -= f / 2.0f;
            this.bbVector.y -= f / 2.0f;
            this.bbVector.z -= f / 2.0f;
        }
        int n = 8;
        while (--n >= 0) {
            Point3fi point3fi = this.bbVertices[n];
            point3fi.set(unitBboxPoints[n]);
            point3fi.x *= this.bbVector.x;
            point3fi.y *= this.bbVector.y;
            point3fi.z *= this.bbVector.z;
            point3fi.add(this.bbCenter);
        }
        this.bbCorner0.set(this.bbVertices[0]);
        this.bbCorner1.set(this.bbVertices[7]);
    }

    boolean isWithin(Point3f point3f) {
        return point3f.x >= this.bbCorner0.x && point3f.x <= this.bbCorner1.x && point3f.y >= this.bbCorner0.y && point3f.y <= this.bbCorner1.y && point3f.z >= this.bbCorner0.z && point3f.z <= this.bbCorner1.z;
    }
}

