/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolViewer;
import org.jmol.export.JmolFileDropper;
import org.jmol.export.dialog.Dialog;
import org.jmol.export.history.HistoryFile;
import org.jmol.export.image.ImageCreator;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.openscience.jmol.app.Jmol;
import org.openscience.jmol.app.JmolApp;
import org.openscience.jmol.app.SplashInterface;
import org.openscience.jmol.app.jmolpanel.AboutDialog;
import org.openscience.jmol.app.jmolpanel.AtomSetChooser;
import org.openscience.jmol.app.jmolpanel.ConsoleTextArea;
import org.openscience.jmol.app.jmolpanel.DisplayPanel;
import org.openscience.jmol.app.jmolpanel.GaussianDialog;
import org.openscience.jmol.app.jmolpanel.GuiMap;
import org.openscience.jmol.app.jmolpanel.HelpDialog;
import org.openscience.jmol.app.jmolpanel.JmolResourceHandler;
import org.openscience.jmol.app.jmolpanel.PovrayDialog;
import org.openscience.jmol.app.jmolpanel.PreferencesDialog;
import org.openscience.jmol.app.jmolpanel.RecentFilesDialog;
import org.openscience.jmol.app.jmolpanel.Splash;
import org.openscience.jmol.app.jmolpanel.StatusBar;
import org.openscience.jmol.app.jmolpanel.StatusListener;
import org.openscience.jmol.app.jmolpanel.WhatsNewDialog;
import org.openscience.jmol.app.webexport.WebExport;

public class JmolPanel
extends JPanel
implements SplashInterface {
    public JmolViewer viewer;
    JmolAdapter modelAdapter;
    JmolApp jmolApp;
    DisplayPanel display;
    StatusBar status;
    protected GaussianDialog gaussianDialog;
    private PreferencesDialog preferencesDialog;
    RecentFilesDialog recentFiles;
    public AtomSetChooser atomSetChooser;
    private ExecuteScriptAction executeScriptAction;
    protected JFrame frame;
    protected JFrame sizeFrame;
    GuiMap guimap = new GuiMap();
    private static int numWindows = 0;
    private static Dimension screenSize = null;
    int startupWidth;
    int startupHeight;
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static final String CONSOLE_WINDOW_NAME = "Console";
    private static final String EDITOR_WINDOW_NAME = "ScriptEditor";
    private static final String SCRIPT_WINDOW_NAME = "ScriptWindow";
    private static final String FILE_OPEN_WINDOW_NAME = "FileOpen";
    private static final String WEB_MAKER_WINDOW_NAME = "JmolWebPageMaker";
    protected SplashInterface splash;
    protected JFrame consoleframe;
    String appletContext;
    static HistoryFile historyFile;
    private Hashtable commands;
    private Hashtable menuItems;
    private JMenuBar menubar;
    protected JToolBar toolbar;
    private static final String newwinAction = "newwin";
    private static final String openAction = "open";
    private static final String openurlAction = "openurl";
    private static final String newAction = "new";
    private static final String exportActionProperty = "export";
    private static final String closeAction = "close";
    private static final String exitAction = "exit";
    private static final String aboutAction = "about";
    private static final String whatsnewAction = "whatsnew";
    private static final String uguideAction = "uguide";
    private static final String printActionProperty = "print";
    private static final String recentFilesAction = "recentFiles";
    private static final String povrayActionProperty = "povray";
    private static final String writeActionProperty = "write";
    private static final String editorAction = "editor";
    private static final String consoleAction = "console";
    private static final String toWebActionProperty = "toweb";
    private static final String atomsetchooserAction = "atomsetchooser";
    private static final String copyImageActionProperty = "copyImage";
    private static final String copyScriptActionProperty = "copyScript";
    private static final String pasteClipboardActionProperty = "pasteClipboard";
    private static final String gaussianAction = "gauss";
    private static final String resizeAction = "resize";
    private ExportAction exportAction = new ExportAction();
    private PovrayAction povrayAction = new PovrayAction();
    private ToWebAction toWebAction = new ToWebAction();
    private WriteAction writeAction = new WriteAction();
    private PrintAction printAction = new PrintAction();
    private CopyImageAction copyImageAction = new CopyImageAction();
    private CopyScriptAction copyScriptAction = new CopyScriptAction();
    private PasteClipboardAction pasteClipboardAction = new PasteClipboardAction();
    private ViewMeasurementTableAction viewMeasurementTableAction = new ViewMeasurementTableAction();
    int qualityJPG = -1;
    int qualityPNG = -1;
    String imageType;
    private Action[] defaultActions = new Action[]{new NewAction(), new NewwinAction(), new OpenAction(), new OpenUrlAction(), this.printAction, this.exportAction, new CloseAction(), new ExitAction(), this.copyImageAction, this.copyScriptAction, this.pasteClipboardAction, new AboutAction(), new WhatsNewAction(), new UguideAction(), new ConsoleAction(), new RecentFilesAction(), this.povrayAction, this.writeAction, this.toWebAction, new ScriptWindowAction(), new ScriptEditorAction(), new AtomSetChooserAction(), this.viewMeasurementTableAction, new GaussianAction(), new ResizeAction()};
    static final String[] imageChoices;
    static final String[] imageExtensions;
    WebExport webExport;
    static final String chemFileProperty = "chemFile";

    public JmolPanel(JmolApp jmolApp, Splash splash, JFrame jFrame, JmolPanel jmolPanel, int n, int n2, String string, Point point) {
        super(true);
        Object object;
        this.jmolApp = jmolApp;
        this.frame = jFrame;
        this.sizeFrame = new JFrame();
        this.startupWidth = n;
        this.startupHeight = n2;
        historyFile = jmolApp.historyFile;
        ++numWindows;
        try {
            this.say("history file is " + historyFile.getFile().getAbsolutePath());
        }
        catch (Exception exception) {
            // empty catch block
        }
        jFrame.setTitle("Jmol");
        jFrame.getContentPane().setBackground(Color.lightGray);
        jFrame.getContentPane().setLayout(new BorderLayout());
        this.splash = splash;
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.status = new StatusBar();
        this.say(GT._("Initializing 3D display..."));
        this.display = new DisplayPanel(this);
        StatusListener statusListener = new StatusListener(this, this.display);
        this.appletContext = string;
        this.viewer = JmolViewer.allocateViewer(this.display, this.modelAdapter, null, null, null, this.appletContext, statusListener);
        this.display.setViewer(this.viewer);
        statusListener.setViewer(this.viewer);
        if (!jmolApp.haveDisplay) {
            return;
        }
        this.say(GT._("Initializing Preferences..."));
        this.preferencesDialog = new PreferencesDialog(this, jFrame, this.guimap, this.viewer);
        this.say(GT._("Initializing Recent Files..."));
        this.recentFiles = new RecentFilesDialog(jFrame);
        this.say(GT._("Initializing Script Window..."));
        this.viewer.getProperty("DATA_API", "getAppConsole", Boolean.TRUE);
        this.say(GT._("Building Command Hooks..."));
        this.commands = new Hashtable();
        if (this.display != null) {
            object = this.getActions();
            for (int i = 0; i < ((Action[])object).length; ++i) {
                Action action = object[i];
                this.commands.put(action.getValue("Name"), action);
            }
        }
        this.menuItems = new Hashtable();
        this.say(GT._("Building Menubar..."));
        this.executeScriptAction = new ExecuteScriptAction();
        this.menubar = this.createMenubar();
        this.add("North", this.menubar);
        object = new JPanel();
        ((Container)object).setLayout(new BorderLayout());
        this.toolbar = this.createToolbar();
        ((Container)object).add("North", this.toolbar);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add("Center", this.display);
        ((Container)object).add("Center", jPanel);
        this.add("Center", (Component)object);
        this.add("South", this.status);
        this.say(GT._("Starting display..."));
        this.display.start();
        if (jmolApp.menuFile != null) {
            this.viewer.getProperty("DATA_API", "setMenu", this.viewer.getFileAsString(jmolApp.menuFile));
        }
        if (point != null) {
            jFrame.setLocation(point);
        } else if (jmolPanel == null) {
            point = historyFile.getWindowPosition("Jmol");
            if (point != null) {
                jFrame.setLocation(point);
            }
        } else {
            point = jmolPanel.frame.getLocationOnScreen();
            int n3 = JmolPanel.screenSize.width - 50;
            int n4 = JmolPanel.screenSize.height - 50;
            point.x += 40;
            point.y += 40;
            if (point.x > n3 || point.y > n4) {
                point.setLocation(0, 0);
            }
            jFrame.setLocation(point);
        }
        jFrame.getContentPane().add("Center", this);
        jFrame.addWindowListener(new AppCloser());
        jFrame.pack();
        jFrame.setSize(n, n2);
        ImageIcon imageIcon = JmolResourceHandler.getIconX("icon");
        Image image = imageIcon.getImage();
        jFrame.setIconImage(image);
        Component component = (Component)this.viewer.getProperty("DATA_API", "getAppConsole", null);
        if (component != null) {
            historyFile.repositionWindow(SCRIPT_WINDOW_NAME, component, 200, 100);
        }
        this.say(GT._("Setting up Drag-and-Drop..."));
        new JmolFileDropper(this.viewer);
        this.say(GT._("Launching main frame..."));
    }

    protected static void startJmol(JmolApp jmolApp) {
        Dialog.setupUIManager();
        JFrame jFrame = new JFrame();
        Jmol jmol = null;
        try {
            if (jmolApp.jmolPosition != null) {
                jFrame.setLocation(jmolApp.jmolPosition);
            }
            jmol = JmolPanel.getJmol(jmolApp, jFrame);
            jmolApp.startViewer(jmol.viewer, jmol.splash);
        }
        catch (Throwable throwable) {
            Logger.error("uncaught exception: " + throwable);
            throwable.printStackTrace();
        }
        if (jmolApp.haveConsole) {
            jmol.consoleframe = new JFrame(GT._("Jmol Console"));
            jmol.consoleframe.setIconImage(jmol.frame.getIconImage());
            try {
                final ConsoleTextArea consoleTextArea = new ConsoleTextArea(true);
                consoleTextArea.setFont(Font.decode("monospaced"));
                jmol.consoleframe.getContentPane().add((Component)new JScrollPane(consoleTextArea), "Center");
                if (Boolean.getBoolean("clearConsoleButton")) {
                    JButton jButton = new JButton(GT._("Clear"));
                    jButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            consoleTextArea.setText("");
                        }
                    });
                    jmol.consoleframe.getContentPane().add((Component)jButton, "South");
                }
            }
            catch (IOException iOException) {
                JTextArea jTextArea = new JTextArea();
                jTextArea.setFont(Font.decode("monospaced"));
                jmol.consoleframe.getContentPane().add((Component)new JScrollPane(jTextArea), "Center");
                jTextArea.append(GT._("Could not create ConsoleTextArea: ") + iOException);
            }
            JmolPanel.setWindow(CONSOLE_WINDOW_NAME, jmol.consoleframe, jmol);
        }
    }

    public static Jmol getJmol(JmolApp jmolApp, JFrame jFrame) {
        Accessible accessible;
        String string = jmolApp.commandOptions;
        Splash splash = null;
        if (jmolApp.haveDisplay && jmolApp.splashEnabled) {
            accessible = JmolResourceHandler.getIconX("splash");
            if (!jmolApp.isSilent) {
                Logger.info("splash_image=" + accessible);
            }
            splash = new Splash((Frame)(string != null && string.indexOf("-L") >= 0 ? null : jFrame), (ImageIcon)accessible);
            splash.setCursor(new Cursor(3));
            splash.showStatus(GT._("Creating main window..."));
            splash.showStatus(GT._("Initializing Swing..."));
        }
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.err.println("Error loading L&F: " + exception);
        }
        screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (splash != null) {
            splash.showStatus(GT._("Initializing Jmol..."));
        }
        accessible = new Jmol(jmolApp, splash, jFrame, null, jmolApp.startupWidth, jmolApp.startupHeight, string, null);
        if (jmolApp.haveDisplay) {
            jFrame.setVisible(true);
        }
        return accessible;
    }

    private static void setWindow(String string, JFrame jFrame, JmolPanel jmolPanel) {
        Point point = jmolPanel.frame.getLocation();
        Dimension dimension = jmolPanel.frame.getSize();
        Dimension dimension2 = historyFile.getWindowSize(string);
        Point point2 = historyFile.getWindowPosition(string);
        if (dimension2 != null && point2 != null) {
            jFrame.setBounds(point2.x, point2.y, dimension2.width, dimension2.height);
        } else {
            jFrame.setBounds(point.x, point.y + dimension.height, dimension.width, 200);
        }
        Boolean bl = historyFile.getWindowVisibility(string);
        if (bl != null && bl.equals(Boolean.TRUE)) {
            jFrame.setVisible(true);
        }
    }

    public void showStatus(String string) {
        this.splash.showStatus(string);
    }

    void report(String string) {
        if (this.jmolApp.isSilent) {
            return;
        }
        Logger.info(string);
    }

    private void say(String string) {
        if (this.jmolApp.haveDisplay) {
            if (this.splash == null) {
                this.report(string);
            } else {
                this.splash.showStatus(string);
            }
        }
    }

    public Action[] getActions() {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.addAll(Arrays.asList(this.defaultActions));
        arrayList.addAll(Arrays.asList(this.display.getActions()));
        arrayList.addAll(Arrays.asList(this.preferencesDialog.getActions()));
        return arrayList.toArray(new Action[0]);
    }

    void doClose() {
        this.dispose(this.frame);
    }

    private void dispose(JFrame jFrame) {
        Component component;
        if (historyFile != null && this.display != null) {
            this.jmolApp.border.x = this.getFrame().getWidth() - this.display.dimSize.width;
            this.jmolApp.border.y = this.getFrame().getHeight() - this.display.dimSize.height;
            historyFile.addWindowInfo("Jmol", this.getFrame(), this.jmolApp.border);
        }
        if ((component = (Component)this.viewer.getProperty("DATA_API", "getAppConsole", null)) != null) {
            historyFile.addWindowInfo(SCRIPT_WINDOW_NAME, component, null);
        }
        if ((component = (Component)this.viewer.getProperty("DATA_API", "getScriptEditor", null)) != null) {
            historyFile.addWindowInfo(EDITOR_WINDOW_NAME, component, null);
        }
        if (historyFile != null && this.webExport != null) {
            WebExport.saveHistory();
            WebExport.cleanUp();
        }
        if (numWindows <= 1) {
            this.report(GT._("Closing Jmol..."));
            System.exit(0);
        } else {
            --numWindows;
            this.viewer.setModeMouse(-1);
            try {
                jFrame.dispose();
            }
            catch (Exception exception) {
                Logger.error("frame disposal exception");
            }
        }
    }

    protected void setupNewFrame(String string) {
        JFrame jFrame = new JFrame();
        JFrame jFrame2 = this.frame;
        Jmol jmol = new Jmol(this.jmolApp, null, jFrame, (Jmol)this, this.startupWidth, this.startupHeight, "", string == null ? null : jFrame2.getLocationOnScreen());
        jFrame.setVisible(true);
        if (string != null) {
            this.dispose(jFrame2);
            jmol.viewer.evalStringQuiet(string);
        }
    }

    protected Frame getFrame() {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof Frame)) continue;
            return (Frame)container;
        }
        return null;
    }

    protected JMenuItem createMenuItem(String string) {
        JMenuItem jMenuItem = string.endsWith("Check") ? this.guimap.newJCheckBoxMenuItem(string, false) : this.guimap.newJMenuItem(string);
        ImageIcon imageIcon = JmolResourceHandler.getIconX(string + "Image");
        if (imageIcon != null) {
            jMenuItem.setHorizontalTextPosition(4);
            jMenuItem.setIcon(imageIcon);
        }
        if (string.endsWith("Script")) {
            jMenuItem.setActionCommand(JmolResourceHandler.getStringX(string));
            jMenuItem.addActionListener(this.executeScriptAction);
        } else {
            jMenuItem.setActionCommand(string);
            Action action = this.getAction(string);
            if (action != null) {
                jMenuItem.addActionListener(action);
                action.addPropertyChangeListener(new ActionChangedListener(jMenuItem));
                jMenuItem.setEnabled(action.isEnabled());
            } else {
                jMenuItem.setEnabled(false);
            }
        }
        this.menuItems.put(string, jMenuItem);
        return jMenuItem;
    }

    protected JMenuItem getMenuItem(String string) {
        return (JMenuItem)this.menuItems.get(string);
    }

    protected Action getAction(String string) {
        return (Action)this.commands.get(string);
    }

    private JToolBar createToolbar() {
        this.toolbar = new JToolBar();
        String[] stringArray = this.tokenize(JmolResourceHandler.getStringX("toolbar"));
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-")) {
                this.toolbar.addSeparator();
                continue;
            }
            this.toolbar.add(this.createTool(stringArray[i]));
        }
        this.toolbar.add(Box.createHorizontalGlue());
        return this.toolbar;
    }

    protected Component createTool(String string) {
        return this.createToolbarButton(string);
    }

    protected AbstractButton createToolbarButton(String string) {
        String string2;
        boolean bl;
        ImageIcon imageIcon = JmolResourceHandler.getIconX(string + "Image");
        AbstractButton abstractButton = new JButton(imageIcon);
        String string3 = JmolResourceHandler.getStringX(string + "Toggle");
        if (string3 != null && (bl = Boolean.valueOf(string3).booleanValue())) {
            abstractButton = new JToggleButton(imageIcon);
            if (string.equals("rotateScript")) {
                this.display.buttonRotate = (JToggleButton)abstractButton;
            }
            if (string.equals("modelkitScript")) {
                this.display.buttonModelkit = (JToggleButton)abstractButton;
            }
            this.display.toolbarButtonGroup.add(abstractButton);
            string2 = JmolResourceHandler.getStringX(string + "ToggleSelected");
            if (string2 != null) {
                boolean bl2 = Boolean.valueOf(string2);
                abstractButton.setSelected(bl2);
            }
        }
        abstractButton.setRequestFocusEnabled(false);
        abstractButton.setMargin(new Insets(1, 1, 1, 1));
        Action action = null;
        string2 = null;
        if (string.endsWith("Script")) {
            string2 = JmolResourceHandler.getStringX(string);
            action = this.executeScriptAction;
        } else {
            string2 = string;
            action = this.getAction(string);
        }
        if (action != null) {
            abstractButton.setActionCommand(string2);
            abstractButton.addActionListener(action);
            action.addPropertyChangeListener(new ActionChangedListener(abstractButton));
            abstractButton.setEnabled(action.isEnabled());
        } else {
            abstractButton.setEnabled(false);
        }
        String string4 = this.guimap.getLabel(string + "Tip");
        if (string4 != null) {
            abstractButton.setToolTipText(string4);
        }
        return abstractButton;
    }

    protected String[] tokenize(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    protected JMenuBar createMenubar() {
        JMenuBar jMenuBar = new JMenuBar();
        this.addNormalMenuBar(jMenuBar);
        this.addMacrosMenuBar(jMenuBar);
        jMenuBar.add(Box.createHorizontalGlue());
        this.addHelpMenuBar(jMenuBar);
        return jMenuBar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMacrosMenuBar(JMenuBar jMenuBar) {
        JMenu jMenu = this.guimap.newJMenu("macros");
        File file = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".jmol" + System.getProperty("file.separator") + "macros");
        this.report("User macros dir: " + file);
        this.report("       exists: " + file.exists());
        this.report("  isDirectory: " + file.isDirectory());
        if (file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                String string = fileArray[i].getName();
                if (!string.endsWith(".macro")) continue;
                if (Logger.debugging) {
                    Logger.debug("Possible macro found: " + string);
                }
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(fileArray[i]);
                    Properties properties = new Properties();
                    properties.load(fileInputStream);
                    String string2 = properties.getProperty("Title");
                    String string3 = properties.getProperty("Script");
                    JMenuItem jMenuItem = new JMenuItem(string2);
                    jMenuItem.setActionCommand(string3);
                    jMenuItem.addActionListener(this.executeScriptAction);
                    jMenu.add(jMenuItem);
                    continue;
                }
                catch (IOException iOException) {
                    System.err.println("Could not load macro file: ");
                    System.err.println(iOException);
                    continue;
                }
                finally {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {}
                        fileInputStream = null;
                    }
                }
            }
        }
        jMenuBar.add(jMenu);
    }

    protected void addNormalMenuBar(JMenuBar jMenuBar) {
        String[] stringArray = this.tokenize(JmolResourceHandler.getStringX("menubar"));
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-")) {
                jMenuBar.add(Box.createHorizontalGlue());
                continue;
            }
            JMenu jMenu = this.createMenu(stringArray[i]);
            if (jMenu == null) continue;
            jMenuBar.add(jMenu);
        }
    }

    protected void addHelpMenuBar(JMenuBar jMenuBar) {
        String string = "help";
        JMenu jMenu = this.createMenu(string);
        if (jMenu != null) {
            jMenuBar.add(jMenu);
        }
    }

    protected JMenu createMenu(String string) {
        String[] stringArray = this.tokenize(JmolResourceHandler.getStringX(string));
        JMenu jMenu = this.guimap.newJMenu(string);
        ImageIcon imageIcon = JmolResourceHandler.getIconX(string + "Image");
        if (imageIcon != null) {
            jMenu.setHorizontalTextPosition(4);
            jMenu.setIcon(imageIcon);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            JMenuItem jMenuItem;
            String string2 = stringArray[i];
            if (string2.equals("-")) {
                jMenu.addSeparator();
                continue;
            }
            if (string2.endsWith("Menu")) {
                jMenuItem = "recentFilesMenu".equals(string2) ? this.createMenu(string2) : this.createMenu(string2);
                jMenu.add(jMenuItem);
                continue;
            }
            jMenuItem = this.createMenuItem(string2);
            jMenu.add(jMenuItem);
        }
        jMenu.addMenuListener(this.display.getMenuListener());
        return jMenu;
    }

    void setButtonMode(String string) {
        if (string.equals("modelkit")) {
            this.display.buttonModelkit.setSelected(true);
        } else if (string.equals("rotate")) {
            this.display.buttonRotate.setSelected(true);
        }
    }

    public void print() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this.display);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                Logger.error("Error while printing", printerException);
            }
        }
    }

    String createImageStatus(String string, String string2, Object object, int n) {
        if (string != null && object != null) {
            return null;
        }
        String string3 = string;
        if (string3 != null && !string3.startsWith("OK") && this.status != null) {
            this.status.setStatus(1, GT._("IO Exception:"));
            this.status.setStatus(2, string3);
        }
        return string3;
    }

    void createWebExport() {
        this.webExport = WebExport.createAndShowGUI(this.viewer, historyFile, WEB_MAKER_WINDOW_NAME);
    }

    public static File getUserDirectory() {
        String string = System.getProperty("user.dir");
        return string == null ? null : new File(System.getProperty("user.dir"));
    }

    String getOpenFileNameFromDialog(String string) {
        return new Dialog().getOpenFileNameFromDialog(this.appletContext, this.viewer, string, historyFile, FILE_OPEN_WINDOW_NAME, string == null);
    }

    void notifyFileOpen(String string, String string2) {
        if (string == null || !string.equals("file[]")) {
            this.recentFiles.notifyFileOpen(string);
            this.frame.setTitle(string2);
        }
        if (this.atomSetChooser == null) {
            this.atomSetChooser = new AtomSetChooser(this.viewer, this.frame);
            this.pcs.addPropertyChangeListener(chemFileProperty, this.atomSetChooser);
        }
        this.pcs.firePropertyChange(chemFileProperty, null, null);
    }

    void resizeInnerPanel() {
        String string = this.viewer.getScreenWidth() + " " + this.viewer.getScreenHeight();
        String string2 = JOptionPane.showInputDialog(GT._("width height?"), (Object)string);
        if (string2 == null) {
            return;
        }
        float[] fArray = new float[2];
        int n = Parser.parseStringInfestedFloatArray(string2, null, fArray);
        if (n < 2) {
            return;
        }
        int n2 = (int)fArray[0];
        int n3 = (int)fArray[1];
        Dimension dimension = new Dimension(n2, n3);
        this.display.setPreferredSize(dimension);
        dimension = new Dimension(n2, 30);
        this.status.setPreferredSize(dimension);
        this.toolbar.setPreferredSize(dimension);
        this.getFrame().pack();
    }

    static {
        imageChoices = new String[]{"JPEG", "PNG", "GIF", "PPM", "PDF"};
        imageExtensions = new String[]{"jpg", "png", "gif", "ppm", "pdf"};
    }

    class ResizeAction
    extends AbstractAction {
        public ResizeAction() {
            super(JmolPanel.resizeAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JmolPanel.this.resizeInnerPanel();
        }
    }

    class ExecuteScriptAction
    extends AbstractAction {
        public ExecuteScriptAction() {
            super("executeScriptAction");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.indexOf("#showMeasurementTable") >= 0) {
                JmolPanel.this.display.measurementTable.activate();
            }
            JmolPanel.this.viewer.evalStringQuiet(string);
        }
    }

    class ViewMeasurementTableAction
    extends AbstractAction {
        public ViewMeasurementTableAction() {
            super("viewMeasurementTable");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JmolPanel.this.display.measurementTable.activate();
        }
    }

    class ToWebAction
    extends AbstractAction {
        public ToWebAction() {
            super(JmolPanel.toWebActionProperty);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JmolPanel.this.createWebExport();
                }
            });
        }
    }

    class WriteAction
    extends AbstractAction {
        public WriteAction() {
            super(JmolPanel.writeActionProperty);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = new Dialog().getSaveFileNameFromDialog(JmolPanel.this.viewer, null, "SPT");
            if (string != null) {
                Logger.info((String)JmolPanel.this.viewer.createImage(string, "SPT", JmolPanel.this.viewer.getStateInfo(), Integer.MIN_VALUE, 0, 0));
            }
        }
    }

    class PovrayAction
    extends AbstractAction {
        public PovrayAction() {
            super(JmolPanel.povrayActionProperty);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new PovrayDialog(JmolPanel.this.frame, JmolPanel.this.viewer);
        }
    }

    class AtomSetChooserAction
    extends AbstractAction {
        public AtomSetChooserAction() {
            super(JmolPanel.atomsetchooserAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JmolPanel.this.atomSetChooser.setVisible(true);
        }
    }

    class ScriptEditorAction
    extends AbstractAction {
        public ScriptEditorAction() {
            super(JmolPanel.editorAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component = (Component)JmolPanel.this.viewer.getProperty("DATA_API", "getScriptEditor", null);
            if (component != null) {
                component.setVisible(true);
            }
        }
    }

    class ScriptWindowAction
    extends AbstractAction {
        public ScriptWindowAction() {
            super(JmolPanel.consoleAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component = (Component)JmolPanel.this.viewer.getProperty("DATA_API", "getAppConsole", null);
            if (component != null) {
                component.setVisible(true);
            }
        }
    }

    class RecentFilesAction
    extends AbstractAction {
        public RecentFilesAction() {
            super(JmolPanel.recentFilesAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JmolPanel.this.recentFiles.setVisible(true);
            String string = JmolPanel.this.recentFiles.getFile();
            if (string != null) {
                JmolPanel.this.viewer.openFileAsynchronously(string);
            }
        }
    }

    class ExportAction
    extends AbstractAction {
        ExportAction() {
            super(JmolPanel.exportActionProperty);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Dialog dialog = new Dialog();
            String string = dialog.getImageFileNameFromDialog(JmolPanel.this.viewer, null, JmolPanel.this.imageType, imageChoices, imageExtensions, JmolPanel.this.qualityJPG, JmolPanel.this.qualityPNG);
            if (string == null) {
                return;
            }
            JmolPanel.this.qualityJPG = dialog.getQuality("JPG");
            JmolPanel.this.qualityPNG = dialog.getQuality("PNG");
            JmolPanel.this.imageType = dialog.getType();
            String string2 = JmolPanel.this.imageType;
            if (string2 == null) {
                string2 = string;
                int n = string2.lastIndexOf(".");
                if (n < 0) {
                    return;
                }
                string2 = string2.substring(n + 1).toUpperCase();
            }
            Logger.info((String)JmolPanel.this.viewer.createImage(string, string2, null, dialog.getQuality(string2), 0, 0));
        }
    }

    class ExitAction
    extends AbstractAction {
        ExitAction() {
            super(JmolPanel.exitAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JmolPanel.this.doClose();
        }
    }

    class NewAction
    extends AbstractAction {
        NewAction() {
            super(JmolPanel.newAction);
        }

        NewAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JmolPanel.this.revalidate();
        }
    }

    class OpenUrlAction
    extends NewAction {
        String title;
        String prompt;

        OpenUrlAction() {
            super(JmolPanel.openurlAction);
            this.title = GT._("Open URL");
            this.prompt = GT._("Enter URL of molecular model");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = JOptionPane.showInputDialog(JmolPanel.this.frame, this.prompt, this.title, -1);
            if (string != null) {
                if (string.indexOf("://") < 0) {
                    if (string.length() == 4 && string.indexOf(".") < 0) {
                        string = "=" + string;
                    }
                    if (!string.startsWith("=")) {
                        string = "http://" + string;
                    }
                }
                JmolPanel.this.viewer.openFileAsynchronously(string);
            }
        }
    }

    class OpenAction
    extends NewAction {
        OpenAction() {
            super(JmolPanel.openAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = JmolPanel.this.getOpenFileNameFromDialog(null);
            if (string == null) {
                return;
            }
            if (string.startsWith("load append")) {
                JmolPanel.this.viewer.scriptWait(string);
            } else {
                JmolPanel.this.viewer.openFileAsynchronously(string);
            }
        }
    }

    class PrintAction
    extends AbstractAction {
        public PrintAction() {
            super(JmolPanel.printActionProperty);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JmolPanel.this.print();
        }
    }

    class CopyScriptAction
    extends AbstractAction {
        public CopyScriptAction() {
            super(JmolPanel.copyScriptActionProperty);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new ImageCreator(JmolPanel.this.viewer).clipImage((String)JmolPanel.this.viewer.getProperty("string", "stateInfo", null));
        }
    }

    class CopyImageAction
    extends AbstractAction {
        public CopyImageAction() {
            super(JmolPanel.copyImageActionProperty);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new ImageCreator(JmolPanel.this.viewer).clipImage(null);
        }
    }

    class PasteClipboardAction
    extends AbstractAction {
        public PasteClipboardAction() {
            super(JmolPanel.pasteClipboardActionProperty);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JmolPanel.this.viewer.loadInline(ImageCreator.getClipboardTextStatic(), false);
        }
    }

    class UguideAction
    extends AbstractAction {
        public UguideAction() {
            super(JmolPanel.uguideAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new HelpDialog(JmolPanel.this.frame).setVisible(true);
        }
    }

    class NewwinAction
    extends AbstractAction {
        NewwinAction() {
            super(JmolPanel.newwinAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFrame jFrame = new JFrame();
            new Jmol(JmolPanel.this.jmolApp, null, jFrame, (Jmol)JmolPanel.this, JmolPanel.this.startupWidth, JmolPanel.this.startupHeight, "", null);
            jFrame.setVisible(true);
        }
    }

    class GaussianAction
    extends AbstractAction {
        public GaussianAction() {
            super(JmolPanel.gaussianAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JmolPanel.this.gaussianDialog == null) {
                JmolPanel.this.gaussianDialog = new GaussianDialog(JmolPanel.this.frame, JmolPanel.this.viewer);
            }
            JmolPanel.this.gaussianDialog.setVisible(true);
        }
    }

    class WhatsNewAction
    extends AbstractAction {
        public WhatsNewAction() {
            super(JmolPanel.whatsnewAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WhatsNewDialog whatsNewDialog = new WhatsNewDialog(JmolPanel.this.frame);
            whatsNewDialog.setVisible(true);
        }
    }

    class AboutAction
    extends AbstractAction {
        public AboutAction() {
            super(JmolPanel.aboutAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AboutDialog aboutDialog = new AboutDialog(JmolPanel.this.frame);
            aboutDialog.setVisible(true);
        }
    }

    class ConsoleAction
    extends AbstractAction {
        public ConsoleAction() {
            super("jconsole");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JmolPanel.this.consoleframe != null) {
                JmolPanel.this.consoleframe.setVisible(true);
            }
        }
    }

    class CloseAction
    extends AbstractAction {
        CloseAction() {
            super(JmolPanel.closeAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JmolPanel.this.frame.setVisible(false);
            JmolPanel.this.doClose();
        }
    }

    private static class ActionChangedListener
    implements PropertyChangeListener {
        AbstractButton button;

        ActionChangedListener(AbstractButton abstractButton) {
            this.button = abstractButton;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getPropertyName().equals("Name")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                if (this.button.getText() != null) {
                    this.button.setText(string2);
                }
            } else if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.button.setEnabled(bl);
            }
        }
    }

    protected final class AppCloser
    extends WindowAdapter {
        protected AppCloser() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            JmolPanel.this.doClose();
        }
    }
}

