/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.export.UseTable;
import org.jmol.export.__CartesianExporter;
import org.jmol.g3d.Font3D;
import org.jmol.util.Escape;
import org.jmol.util.Quaternion;
import org.jmol.viewer.Viewer;

public class _VrmlExporter
extends __CartesianExporter {
    protected UseTable useTable;
    private Point3f tempQ1 = new Point3f();
    private Point3f tempQ2 = new Point3f();
    private Hashtable htSpheresRendered = new Hashtable();

    public _VrmlExporter() {
        this.useTable = new UseTable("USE ");
        this.commentChar = "# ";
    }

    protected void output(Tuple3f tuple3f) {
        this.output(_VrmlExporter.round(tuple3f));
    }

    protected void outputHeader() {
        this.output("#VRML V2.0 utf8 Generated by Jmol " + Viewer.getJmolVersion() + "\n");
        this.output("WorldInfo { \n");
        this.output(" title " + Escape.escape(this.viewer.getModelSetName()) + "\n");
        this.output(" info [ \"Generated by Jmol " + Viewer.getJmolVersion() + " \", \n");
        this.output("  \"http://www.jmol.org \", \n");
        this.output("  \"Creation date: " + _VrmlExporter.getExportDate() + " \" ]\n");
        this.output("} \n");
        this.output("NavigationInfo { type \"EXAMINE\" } \n");
        this.output("Background { skyColor [" + this.rgbFractionalFromColix(this.backgroundColix, ' ') + "] } \n");
        float f = (float)((double)this.aperatureAngle * Math.PI / 180.0);
        this.viewer.getAxisAngle(this.viewpoint);
        this.output("Viewpoint{fieldOfView " + f + " position " + this.cameraPosition.x + " " + this.cameraPosition.y + " " + this.cameraPosition.z + " orientation " + this.viewpoint.x + " " + this.viewpoint.y + " " + (this.viewpoint.angle == 0.0f ? 1.0f : this.viewpoint.z) + " " + -this.viewpoint.angle);
        this.output("\n jump TRUE description \"v1\"\n}\n\n");
        this.output(this.getJmolPerspective());
        this.output("\nTransform{children Transform{translation ");
        this.tempP1.set(this.center);
        this.tempP1.scale(-1.0f);
        this.output(this.tempP1);
        this.output("\nchildren [\n");
    }

    protected void outputFooter() {
        this.useTable = null;
        this.output("\n]\n");
        this.output("}}\n");
    }

    protected void outputAppearance(short s, boolean bl) {
        String string = this.useTable.getDef((bl ? "T" : "") + s);
        this.output(" appearance ");
        if (string.charAt(0) == '_') {
            String string2 = this.rgbFractionalFromColix(s, ' ');
            this.output(" DEF " + string + " Appearance{material Material{diffuseColor ");
            if (bl) {
                this.output(" 0 0 0 specularColor 0 0 0 ambientIntensity 0.0 shininess 0.0 emissiveColor " + string2 + " }}");
            } else {
                this.output(string2 + " transparency " + _VrmlExporter.translucencyFractionalFromColix(s) + "}}");
            }
            return;
        }
        this.output(string);
    }

    protected void outputCircle(Point3f point3f, Point3f point3f2, float f, short s, boolean bl) {
        if (bl) {
            this.output("Transform{translation ");
            this.tempV1.set(point3f);
            this.tempV1.add(point3f2);
            this.tempV1.scale(0.5f);
            this.output(this.tempV1);
            this.output(" children Billboard{axisOfRotation 0 0 0 children Transform{rotation 1 0 0 1.5708");
            this.outputCylinderChild(point3f, point3f2, s, (byte)2, (int)(f * 2000.0f));
            this.output("}}}\n");
            return;
        }
        String string = this.useTable.getDef("C" + s + "_" + f);
        this.outputTransRot(point3f, point3f2, 0, 0, 1);
        this.tempP3.set(1.0f, 1.0f, 1.0f);
        this.tempP3.scale(f);
        this.output(" scale ");
        this.output(this.tempP3);
        this.output(" children ");
        if (string.charAt(0) == '_') {
            int n;
            this.output("DEF " + string);
            this.output(" Billboard{axisOfRotation 0 0 0 children Transform{children");
            this.output(" Shape{geometry Extrusion{beginCap FALSE convex FALSE endCap FALSE creaseAngle 1.57");
            this.output(" crossSection [");
            float f2 = (float)Math.PI / 180;
            float f3 = 0.02f / f;
            for (n = 0; n <= 360; n += 10) {
                this.output(_VrmlExporter.round(Math.cos((float)n * f2) * (double)f3) + " ");
                this.output(_VrmlExporter.round(Math.sin((float)n * f2) * (double)f3) + " ");
            }
            this.output("] spine [");
            for (n = 0; n <= 360; n += 10) {
                this.output(_VrmlExporter.round(Math.cos((float)n * f2)) + " ");
                this.output(_VrmlExporter.round(Math.sin((float)n * f2)) + " 0 ");
            }
            this.output("]}");
            this.outputAppearance(s, false);
            this.output("}}}");
        } else {
            this.output(string);
        }
        this.output("}\n");
    }

    protected void outputCone(Point3f point3f, Point3f point3f2, float f, short s) {
        float f2 = this.tempP1.distance(this.tempP2);
        this.outputTransRot(this.tempP1, this.tempP2, 0, 1, 0);
        this.output(" children ");
        String string = "o" + (int)(f2 * 100.0f) + "_" + (int)(f * 100.0f);
        String string2 = this.useTable.getDef("c" + string + "_" + s);
        if (string2.charAt(0) == '_') {
            this.output("DEF " + string2 + " Shape{geometry ");
            string = this.useTable.getDef(string);
            if (string.charAt(0) == '_') {
                this.output("DEF " + string + " Cone{height " + _VrmlExporter.round(f2) + " bottomRadius " + _VrmlExporter.round(f) + "}");
            } else {
                this.output(string);
            }
            this.outputAppearance(s, false);
            this.output("}");
        } else {
            this.output(string2);
        }
        this.output("}\n");
    }

    protected boolean outputCylinder(Point3f point3f, Point3f point3f2, Point3f point3f3, short s, byte by, float f, Point3f point3f4, Point3f point3f5) {
        if (point3f4 == null) {
            this.outputTransRot(point3f2, point3f3, 0, 1, 0);
        } else {
            this.output("Transform{translation ");
            this.output(point3f);
            this.outputQuaternionFrame(point3f, point3f5, point3f2, point3f4, 2.0f, " ", "");
            point3f2.set(0.0f, 0.0f, -1.0f);
            point3f3.set(0.0f, 0.0f, 1.0f);
        }
        this.outputCylinderChild(point3f2, point3f3, s, by, f);
        this.output("}\n");
        if (by == 3) {
            this.outputSphere(point3f2, f * 1.01f, s);
            this.outputSphere(point3f3, f * 1.01f, s);
        }
        return true;
    }

    private void outputCylinderChild(Point3f point3f, Point3f point3f2, short s, byte by, float f) {
        this.output(" children ");
        float f2 = point3f.distance(point3f2);
        String string = this.useTable.getDef("C" + s + "_" + (int)(f2 * 100.0f) + "_" + f + "_" + by);
        if (string.charAt(0) == '_') {
            this.output("DEF " + string);
            this.output(" Shape{geometry ");
            String string2 = this.useTable.getDef("c" + _VrmlExporter.round(f2) + "_" + by + "_" + f);
            if (string2.charAt(0) == '_') {
                this.output("DEF " + string2 + " Cylinder{height " + _VrmlExporter.round(f2) + " radius " + f + (by == 2 ? "" : " top FALSE bottom FALSE") + "}");
            } else {
                this.output(string2);
            }
            this.outputAppearance(s, false);
            this.output("}");
        } else {
            this.output(string);
        }
    }

    protected void outputEllipsoid(Point3f point3f, Point3f[] point3fArray, short s) {
        this.output("Transform{translation ");
        this.output(point3f);
        this.outputQuaternionFrame(point3f, point3fArray[1], point3fArray[3], point3fArray[5], 1.0f, " ", "");
        this.output(" children ");
        this.tempP3.set(0.0f, 0.0f, 0.0f);
        this.outputSphereChild(this.tempP3, 1.0f, s);
        this.output("}\n");
    }

    protected void outputQuaternionFrame(Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4, float f, String string, String string2) {
        this.tempQ1.set(point3f2);
        this.tempQ2.set(point3f3);
        AxisAngle4f axisAngle4f = Quaternion.getQuaternionFrame(point3f, this.tempQ1, this.tempQ2).toAxisAngle4f();
        if (!Float.isNaN(axisAngle4f.x)) {
            this.output(" rotation");
            this.output(string);
            this.output(axisAngle4f.x + " " + axisAngle4f.y + " " + axisAngle4f.z + " " + axisAngle4f.angle);
            this.output(string2);
        }
        float f2 = point3f2.distance(point3f);
        float f3 = point3f3.distance(point3f) * f;
        float f4 = point3f4.distance(point3f);
        this.output(" scale");
        this.output(string);
        this.output(f2 + " " + f3 + " " + f4);
        this.output(string2);
    }

    protected void outputSurface(Point3f[] point3fArray, Vector3f[] vector3fArray, short[] sArray, int[][] nArray, short[] sArray2, int n, int n2, int n3, BitSet bitSet, int n4, short s, Vector vector, Hashtable hashtable, Point3f point3f) {
        this.output("Shape {\n");
        this.outputAppearance(s, false);
        this.output(" geometry IndexedFaceSet {\n");
        if (sArray2 != null) {
            this.output(" colorPerVertex FALSE\n");
        }
        this.output("coord Coordinate {\n   point [\n");
        this.outputVertices(point3fArray, n, point3f);
        this.output("   ]\n");
        this.output("  }\n");
        this.output("  coordIndex [\n");
        int[] nArray2 = new int[n];
        this.getCoordinateMap(point3fArray, nArray2);
        this.outputIndices(nArray, nArray2, n2, bitSet, n4);
        this.output("  ]\n");
        if (vector3fArray != null) {
            Vector vector2 = new Vector();
            nArray2 = this.getNormalMap(vector3fArray, n, vector2);
            this.output("  solid FALSE\n  normalPerVertex TRUE\n   normal Normal {\n  vector [\n");
            this.outputNormals(vector2);
            this.output("   ]\n");
            this.output("  }\n");
            this.output("  normalIndex [\n");
            this.outputIndices(nArray, nArray2, n2, bitSet, n4);
            this.output("  ]\n");
        }
        nArray2 = null;
        if (vector != null) {
            this.output("  color Color { color [\n");
            this.outputColors(vector);
            this.output("  ] } \n");
            this.output("  colorIndex [\n");
            this.outputColorIndices(nArray, n2, bitSet, n4, hashtable, sArray, sArray2);
            this.output("  ]\n");
        }
        this.output(" }\n");
        this.output("}\n");
    }

    protected void outputFace(int[] nArray, int[] nArray2, int n) {
        this.output(nArray2[nArray[0]] + " " + nArray2[nArray[1]] + " " + nArray2[nArray[2]] + " -1\n");
        if (n == 4 && nArray.length == 4) {
            this.output(nArray2[nArray[0]] + " " + nArray2[nArray[2]] + " " + nArray2[nArray[3]] + " -1\n");
        }
    }

    protected void outputNormals(Vector vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            this.output((String)vector.get(i));
        }
    }

    protected void outputColors(Vector vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            String string = this.rgbFractionalFromColix((Short)vector.get(i), ' ');
            this.output(" ");
            this.output(string);
            this.output("\n");
        }
    }

    protected void outputColorIndices(int[][] nArray, int n, BitSet bitSet, int n2, Hashtable hashtable, short[] sArray, short[] sArray2) {
        int n3;
        boolean bl = bitSet == null;
        int n4 = n3 = bl ? n - 1 : bitSet.nextSetBit(0);
        while (n4 >= 0) {
            if (sArray2 == null) {
                this.output(hashtable.get("" + sArray[nArray[n4][0]]) + " " + hashtable.get("" + sArray[nArray[n4][1]]) + " " + hashtable.get("" + sArray[nArray[n4][2]]) + " -1\n");
                if (n2 == 4 && nArray[n4].length == 4) {
                    this.output(hashtable.get("" + sArray[nArray[n4][0]]) + " " + hashtable.get("" + sArray[nArray[n4][2]]) + " " + hashtable.get("" + sArray[nArray[n4][3]]) + " -1\n");
                }
            } else {
                this.output(hashtable.get("" + sArray2[n4]) + "\n");
            }
            n4 = bl ? n4 - 1 : bitSet.nextSetBit(n4 + 1);
        }
    }

    protected void outputSphere(Point3f point3f, float f, short s) {
        int n = (int)(f * 100.0f);
        String string = _VrmlExporter.round(point3f) + " " + n;
        if (this.htSpheresRendered.get(string) != null) {
            return;
        }
        this.htSpheresRendered.put(string, Boolean.TRUE);
        this.outputSphereChild(point3f, f, s);
    }

    protected void outputSphereChild(Point3f point3f, float f, short s) {
        int n = (int)(f * 100.0f);
        String string = this.useTable.getDef("S" + s + "_" + n);
        this.output("Transform{translation ");
        this.output(point3f);
        this.output(" children ");
        if (string.charAt(0) == '_') {
            this.output("DEF " + string);
            this.output(" Shape{geometry Sphere{radius " + f + "}");
            this.outputAppearance(s, false);
            this.output("}");
        } else {
            this.output(string);
        }
        this.output("}\n");
    }

    protected void outputTextPixel(Point3f point3f, int n) {
        String string = _VrmlExporter.rgbFractionalFromArgb(n, ' ');
        this.output("Transform{translation ");
        this.output(point3f);
        this.output(" children ");
        String string2 = this.useTable.getDef("p" + n);
        if (string2.charAt(0) == '_') {
            this.output("DEF " + string2 + " Shape{geometry Sphere{radius 0.01}");
            this.output(" appearance Appearance{material Material{diffuseColor 0 0 0 specularColor 0 0 0 ambientIntensity 0.0 shininess 0.0 emissiveColor " + string + " }}}");
        } else {
            this.output(string2);
        }
        this.output("}\n");
    }

    private void outputTransRot(Point3f point3f, Point3f point3f2, int n, int n2, int n3) {
        this.output("Transform{");
        this.outputTransRot(point3f, point3f2, n, n2, n3, " ", "");
    }

    protected void outputTransRot(Point3f point3f, Point3f point3f2, int n, int n2, int n3, String string, String string2) {
        this.tempV1.set(point3f2);
        this.tempV1.add(point3f);
        this.tempV1.scale(0.5f);
        this.output("translation");
        this.output(string);
        this.output(this.tempV1);
        this.output(string2);
        this.tempV1.sub(point3f);
        this.tempV1.normalize();
        this.tempV2.set(n, n2, n3);
        this.tempV2.add(this.tempV1);
        this.tempA.set(this.tempV2.x, this.tempV2.y, this.tempV2.z, 3.14159f);
        this.output(" rotation");
        this.output(string);
        this.output(_VrmlExporter.round(this.tempA.x) + " " + _VrmlExporter.round(this.tempA.y) + " " + _VrmlExporter.round(this.tempA.z) + " " + _VrmlExporter.round(this.tempA.angle));
        this.output(string2);
    }

    protected void outputTriangle(Point3f point3f, Point3f point3f2, Point3f point3f3, short s) {
        this.output("Shape{geometry IndexedFaceSet{solid FALSE coord Coordinate{point[");
        this.output(point3f);
        this.output(" ");
        this.output(point3f2);
        this.output(" ");
        this.output(point3f3);
        this.output("]}coordIndex[ 0 1 2 -1 ]}");
        this.outputAppearance(s, false);
        this.output("}\n");
    }

    void plotText(int n, int n2, int n3, short s, String string, Font3D font3D) {
        if (n3 < 3) {
            n3 = this.viewer.getFrontPlane();
        }
        String string2 = font3D.fontStyle.toUpperCase();
        String string3 = font3D.fontFace.toUpperCase();
        String string4 = string3.equals("MONOSPACED") ? "TYPEWRITER" : (string3.equals("SERIF") ? "SERIF" : "SANS");
        this.output("Transform{translation ");
        this.tempP3.set(n, n2, n3);
        this.viewer.unTransformPoint(this.tempP3, this.tempP1);
        this.output(this.tempP1);
        this.output(" children ");
        String string5 = this.useTable.getDef("T" + s + string4 + string2 + "_" + string);
        if (string5.charAt(0) == '_') {
            this.output("DEF " + string5 + " Billboard{axisOfRotation 0 0 0 children Transform{children Shape{");
            this.outputAppearance(s, true);
            this.output(" geometry Text{fontStyle ");
            String string6 = this.useTable.getDef("F" + string4 + string2);
            if (string6.charAt(0) == '_') {
                this.output("DEF " + string6 + " FontStyle{size 0.4 family \"" + string4 + "\" style \"" + string2 + "\"}");
            } else {
                this.output(string6);
            }
            this.output(" string " + Escape.escape(string) + "}}}}");
        } else {
            this.output(string5);
        }
        this.output("}\n");
    }
}

