/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.server;

import com.sparshui.gestures.Gesture;
import com.sparshui.server.GestureFactory;
import com.sparshui.server.ServerToClientProtocol;
import com.sparshui.server.TouchPoint;
import java.io.IOException;
import java.util.Vector;

public class Group {
    private int _id;
    private Vector _gestureIDs;
    private Vector _gestures;
    private Vector _touchPoints;
    private ServerToClientProtocol _clientProtocol;

    public Group(int n, Vector vector, ServerToClientProtocol serverToClientProtocol) {
        this._id = n;
        this._gestureIDs = vector;
        this._gestures = new Vector();
        this._touchPoints = new Vector();
        this._clientProtocol = serverToClientProtocol;
        for (int i = 0; i < this._gestureIDs.size(); ++i) {
            Gesture gesture = GestureFactory.createGesture(this._gestureIDs.get(i));
            if (gesture == null) continue;
            this._gestures.add(gesture);
        }
    }

    public int getID() {
        return this._id;
    }

    public synchronized void update(TouchPoint touchPoint) {
        Vector vector = new Vector();
        int n = touchPoint.getState();
        if (n == 0) {
            this._touchPoints.add(touchPoint);
        }
        Vector vector2 = null;
        for (int i = 0; i < this._gestures.size(); ++i) {
            Gesture gesture = (Gesture)this._gestures.get(i);
            vector.addAll(gesture.processChange(vector2 == null ? this._touchPoints : vector2, touchPoint));
        }
        if (n == 1) {
            this._touchPoints.remove(touchPoint);
        }
        try {
            this._clientProtocol.processEvents(this._id, vector);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

