//
// (c)  JAMES T. MACDONALD 2010
// This file is part of the PRODART 2 software
// suite and is made available under license.
//
// For more information please contact by email: j.t.macdonald+prodart@gmail.com
//
#include "line_fit.h"

using std::cout;
using std::cerr;
using std::cin;
using std::endl;

using std::pow;
using std::sqrt;
using std::acos;
using std::asin;

using std::ostream;
using std::istream;


namespace PRODART {

namespace UTILS {


bool is_vector3d_vector_valid(const vector3d_vector& vec){

	bool isOK = true;
	//vector3d_vector::const_iterator it;
	for (unsigned long it = 0; it < vec.size(); it++){
		const vector3d v3d = vec[it];
		for (int i = 0; i < 3; i++){
			if (boost::math::isinf(v3d[i])){
				cerr << "is_vector3d_vector_valid: ERROR: isinf at " << it << "[" << i << "]" << endl;
				isOK = false;
			}
			else if (boost::math::isnan(v3d[i])){
				cerr << "is_vector3d_vector_valid: ERROR: isnan at " << it << "[" << i << "]" << endl;
				isOK = false;
			}
		}
	}
	return isOK;
}

//! returned vector3ds are the fitted endpoints
void line_fit3d(const vector3d_vector& points,
		vector3d& a,
		vector3d& b){

	const int n = points.size();

	vector3d CoM(0,0,0);
	for (int i = 0; i < n; i++){
		CoM += points[i];
	}

	CoM = CoM / static_cast<double>(n);

	gsl_matrix *m = gsl_matrix_calloc(3, 3);

	for (int i = 0; i < n; i++){
		const vector3d c = points[i] - CoM;

		/*
        mom[0][0] += c.x * c.x;
        mom[1][1] += c.y * c.y;
        mom[2][2] += c.z * c.z;
        mom[0][1] = mom[1][0] += c.x * c.y;
        mom[0][2] = mom[2][0] += c.x * c.z;
        mom[1][2] = mom[2][1] += c.y * c.z;
        */

        for (int j = 0 ; j < 3; j++){
            for (int k = j ; k < 3; k++){
            	const double new_val = gsl_matrix_get(m, j, k) + (c[j] * c[k]);
            	gsl_matrix_set(m, j, k, new_val);
            	if (j != k){
                	gsl_matrix_set(m, k, j, new_val);
            	}

            }
        }


	}


	gsl_vector *eval = gsl_vector_alloc (3);
	gsl_matrix *evec = gsl_matrix_alloc (3, 3);

	gsl_eigen_symmv_workspace * w =
		gsl_eigen_symmv_alloc (3);

	gsl_eigen_symmv (m, eval, evec, w);

	gsl_eigen_symmv_free (w);

	gsl_eigen_symmv_sort (eval, evec,
			GSL_EIGEN_SORT_ABS_DESC);

	/*
	{
		int i;

		for (i = 0; i < 3; i++)
		{
			double eval_i
			= gsl_vector_get (eval, i);
			gsl_vector_view evec_i
			 = gsl_matrix_column (evec, i);

			printf ("eigenvalue = %g\n", eval_i);
			printf ("eigenvector = \n");
			gsl_vector_fprintf (stdout,
					&evec_i.vector, "%g");
		}
	}
	*/

	gsl_vector_view evec_i = gsl_matrix_column (evec, 0);

	vector3d v(gsl_vector_get(&evec_i.vector,0),
			gsl_vector_get(&evec_i.vector,1),
			gsl_vector_get(&evec_i.vector,2));

	v = v / v.mod();

	const vector3d first = points[0] - CoM;
	const vector3d last = points[n-1] - CoM;

	a = CoM + (first.dot(v) * v);
	b = CoM + (last.dot(v) * v);

	gsl_vector_free (eval);
	gsl_matrix_free (evec);
	gsl_matrix_free (m);


}

//! returned vector3ds are the fitted endpoints
void line_fit3d(const vector3d_vector& points,
		vector3d& a,
		vector3d& b,
		const vector3d alternative_first,
		const vector3d alternative_last){

	const int n = points.size();

	vector3d CoM(0,0,0);
	for (int i = 0; i < n; i++){
		CoM += points[i];
	}

	CoM = CoM / static_cast<double>(n);

	gsl_matrix *m = gsl_matrix_calloc(3, 3);

	for (int i = 0; i < n; i++){
		const vector3d c = points[i] - CoM;

		/*
        mom[0][0] += c.x * c.x;
        mom[1][1] += c.y * c.y;
        mom[2][2] += c.z * c.z;
        mom[0][1] = mom[1][0] += c.x * c.y;
        mom[0][2] = mom[2][0] += c.x * c.z;
        mom[1][2] = mom[2][1] += c.y * c.z;
        */

        for (int j = 0 ; j < 3; j++){
            for (int k = j ; k < 3; k++){
            	const double new_val = gsl_matrix_get(m, j, k) + (c[j] * c[k]);
            	gsl_matrix_set(m, j, k, new_val);
            	if (j != k){
                	gsl_matrix_set(m, k, j, new_val);
            	}

            }
        }


	}


	gsl_vector *eval = gsl_vector_alloc (3);
	gsl_matrix *evec = gsl_matrix_alloc (3, 3);

	gsl_eigen_symmv_workspace * w =
		gsl_eigen_symmv_alloc (3);

	gsl_eigen_symmv (m, eval, evec, w);

	gsl_eigen_symmv_free (w);

	gsl_eigen_symmv_sort (eval, evec,
			GSL_EIGEN_SORT_ABS_DESC);

	/*
	{
		int i;

		for (i = 0; i < 3; i++)
		{
			double eval_i
			= gsl_vector_get (eval, i);
			gsl_vector_view evec_i
			 = gsl_matrix_column (evec, i);

			printf ("eigenvalue = %g\n", eval_i);
			printf ("eigenvector = \n");
			gsl_vector_fprintf (stdout,
					&evec_i.vector, "%g");
		}
	}
	*/

	gsl_vector_view evec_i = gsl_matrix_column (evec, 0);

	vector3d v(gsl_vector_get(&evec_i.vector,0),
			gsl_vector_get(&evec_i.vector,1),
			gsl_vector_get(&evec_i.vector,2));

	v = v / v.mod();

	const vector3d first = alternative_first - CoM;
	const vector3d last = alternative_last - CoM;

	a = CoM + (first.dot(v) * v);
	b = CoM + (last.dot(v) * v);

	gsl_vector_free (eval);
	gsl_matrix_free (evec);
	gsl_matrix_free (m);


}

void line_fit3d(const vector3d_vector& points, vector3d& a, vector3d& b, double& dens, double& dvar, double* ev)
{
vector3d cent(0,0,0);

for(unsigned int k=0;k<points.size();k++)
		cent+=points[k];

cent=cent/static_cast<double>(points.size());

gsl_matrix *m = gsl_matrix_calloc(3, 3);

for (unsigned int i = 0; i < points.size(); i++)
	{
	const vector3d c = points[i] - cent;
        for (int j = 0 ; j < 3; j++){
	 	for (int k = j ; k < 3; k++){
	           	const double new_val = gsl_matrix_get(m, j, k) + (c[j] * c[k]);
	           	gsl_matrix_set(m, j, k, new_val);
	           		gsl_matrix_set(m, k, j, new_val);
                	}
		}
	}

gsl_vector *eval = gsl_vector_alloc (3);
gsl_matrix *evec = gsl_matrix_alloc (3, 3);

gsl_eigen_symmv_workspace * w =
	gsl_eigen_symmv_alloc (3);

gsl_eigen_symmv (m, eval, evec, w);

gsl_eigen_symmv_free (w);

gsl_eigen_symmv_sort (eval, evec,
		GSL_EIGEN_SORT_ABS_DESC);

gsl_vector_view evec_i = gsl_matrix_column (evec, 0);

vector3d v (gsl_vector_get(&evec_i.vector,0),
		gsl_vector_get(&evec_i.vector,1),
		gsl_vector_get(&evec_i.vector,2));

v = v / v.mod();

const vector3d first = points[0] - cent;
const vector3d last = points[points.size()-1] - cent;

a = cent + (first.dot(v) * v);
b = cent + (last.dot(v) * v);

// find mean axial rise
//

double ds=0.0, e=0.0, lastd=0.0;
vector3d c0=first.dot(v)*v;
for(unsigned int k=1;k<points.size();k++)
	{
	vector3d pt=points[k]-cent;
	vector3d p1=(pt.dot(v)*v);
	double d=p1.dist(c0);
	double f=d-lastd;
	//cout << "k: " << k << " c0: " << c0.x << " " << c0.y << " " << c0.z << " p1: " << p1.x << " " << p1.y << " " <<p1.z <<" D: " << f <<endl;
	ds+=f;
	e+=f*f;
	lastd=d;
	}
dens=ds/static_cast<double>(points.size()-1);
dvar=(e/static_cast<double>(points.size()-1)) - dens*dens;

ev[0]=gsl_vector_get(eval,0);
ev[1]=gsl_vector_get(eval,1);
ev[2]=gsl_vector_get(eval,2);

gsl_vector_free (eval);
gsl_matrix_free (evec);
gsl_matrix_free (m);

}


}
}




