/*
 * potentials_store.cpp
 *
 *  Created on: 6 Aug 2010
 *      Author: jmacdona
 */
#include "potentials_store.h"

using namespace std;

namespace PRODART {
namespace POSE {
namespace POTENTIALS {



std::ostream& potentials_energies_map::print_headers(std::ostream& output) const{

	potentials_energies_map::const_iterator iter;

	cout << "total_energy";

	for (iter = this->begin(); iter != this->end(); iter++ ){
		output << "\t" << iter->first.get_label();
	}

	output << "\n";

	return output;
}


std::ostream& potentials_energies_map::print_unweighted_components(std::ostream& output) const{

	potentials_energies_map::const_iterator iter;

	cout << total_energy;

	for (iter = this->begin(); iter != this->end(); iter++ ){
		output << "\t" << iter->second.energy;
	}

	output << "\n";

	return output;
}

std::ostream& potentials_energies_map::print_weighted_components(std::ostream& output) const{

	potentials_energies_map::const_iterator iter;

	cout << total_energy;

	for (iter = this->begin(); iter != this->end(); iter++ ){
		output << "\t" << iter->second.energy * iter->second.weight;
	}

	output << "\n";

	return output;
}

std::ostream& potentials_energies_map::print_weights(std::ostream& output) const{

	potentials_energies_map::const_iterator iter;

	cout << 1.0;

	for (iter = this->begin(); iter != this->end(); iter++ ){
		output << "\t" << iter->second.weight;
	}

	output << "\n";

	return output;

}


}
}
}


