:- set(h,10000)?
:- set(c,6)?
:- set(noise,20)?
:- set(nodes,200)?

% :- set(inflate,200)?
% :- set(verbose,1)?

% mode declarations

:- modeh(1,fold(#fold_t,+dom_t))?

% Facts about secondary structure chain

% :- modeb(*,adjacent(+dom_t,-unit_t,-unit_t,#nat,#sec_t,#sec_t))?

% :- modeb(*,follows(+dom_t,-unit_t,-unit_t,#nat,#nat,#sec_t,#sec_t))?

% :- modeb(1,unit_len(+unit_t,#sym_t))?
% :- modeb(1,unit_aveh(+unit_t,#sym_t))?
% :- modeb(1,unit_hmom(+unit_t,#sym_t))?

% :- modeb(*,coil(+unit_t,+unit_t,#nat))?

% Global facts

:- modeb(1,len(+dom_t,-nat))?
:- modeb(1,nb_alpha(+dom_t,-nat))?
:- modeb(1,nb_beta(+dom_t,-nat))?

:- modeb(1,interval(#nat =< +nat =< #nat))?
:- modeb(1,interval_l(+nat =< #nat))?
:- modeb(1,interval_r(#nat =< +nat))?

:- constraint(interval/1)?
:- constraint(interval_l/1)?
:- constraint(interval_r/1)?

%% Obsolete,
% :- modeb(*,sec_struc(+dom_t,-unit_t))?
% :- modeb(1,unit_type(+unit_t,#sec_t))?
% :- modeb(1,follows(+unit_t,+unit_t))?
% :- modeb(*,follows_by_n_units(+unit_t,+unit_t,#nat))?
% :- modeb(*,follows_by_n_res(+unit_t,+unit_t,#nat))?
% :- modeb(1,gte(+nat,#nat))?
% :- modeb(1,lte(+nat,#nat))?

% types

nat1(n(X)) :- nat(X).

sym_t(very_lo).
sym_t(lo).
sym_t(ave).
sym_t(hi).
sym_t(very_hi).

sec_t(e).
sec_t(h).

%% background knowledge

unit_type(Unit,Type) :-
	sst(Unit,_,_,_,Type,_,_).
unit_len(Unit,Const) :- 
	sst(Unit,_,_,Val,Type,_,_),
	class(Class, _),
	params(Type, Class, Ave, StdE, _, _, _, _),
	gen_const(Val, Ave, StdE, Const).
unit_aveh(Unit,Const) :-
	sst(Unit,_,_,_,Type,Val,_),
	class(Class, _),
	params(Type, Class, Ave, StdE, _, _, _, _),
	gen_const(Val, Ave, StdE, Const).
unit_hmom(Unit,Const) :-
	sst(Unit,_,_,_,Type,_,Val),
	class(Class, _),
	params(Type, Class, Ave, StdE, _, _, _, _),
	gen_const(Val, Ave, StdE, Const).

% coil(A,B,Const) :-
%	sec_struc(Dom, A),
%	sec_struc(Dom, B),
%	sst(A, NumA, PosA, LenA, _, _, _),
%	sst(B, NumB, PosB, _, _, _, _),
%	Dist is NumB - NumA,
%	Dist == 1,
%	Val is PosB - PosA - LenA,
%	write(len(Val)),nl,
%	class(Class, _),
%	params(c, Class, Ave, StdE),
%	gen_const(Val, Ave, StdE, Const).

coil(A,B,Const) :-
	var(Const), !,
	sec_struc(Dom, A),
	sec_struc(Dom, B),
	sst(A, NumA, PosA, LenA, _, _, _),
	sst(B, NumB, PosB, _, _, _, _),
	Dist is NumB - NumA,
	Dist == 1,
	Const is PosB - PosA - LenA.
coil(A,B,Const) :-
	sec_struc(Dom, A),
	sec_struc(Dom, B),
	sst(A, NumA, PosA, LenA, _, _, _),
	sst(B, NumB, PosB, _, _, _, _),
	Dist is NumB - NumA,
	Dist == 1,
	Len is PosB - PosA - LenA,
	Lo is 0.5 * Len,
	Hi is 1.5 * Len,
	Lo =< Const,
	Const =< Hi.

follows(A,B) :-
	sec_struc(Dom, A),
	sec_struc(Dom, B),
	sst(A, NumA, _, _, _, _, _),
	sst(B, NumB, _, _, _, _, _),
	Dist is NumB - NumA,
	Dist == 1.

adjacent(Dom, A,B,NumA,TypA,TypB) :-
	var(NumA), !,
	sec_struc(Dom, A),
	sec_struc(Dom, B),
	sst(A, NumA, _, _, TypA, _, _),
	sst(B, NumB, _, _, TypB, _, _),
	Dist is NumB - NumA,
	Dist == 1.
adjacent(Dom, A,B,P,TypA,TypB) :-
	sec_struc(Dom, A),
	sec_struc(Dom, B),
	sst(A, NumA, _, _, TypA, _, _),
	sst(B, NumB, _, _, TypB, _, _),
	Lo1 is P-3,
	Lo2 is 0.6 * P,
	min(Lo1,Lo2,Lo),
	Hi1 is P+3,
	Hi2 is 1.4 * P,
	max(Hi1,Hi2,Hi),
	NumA >= Lo,
	NumA =< Hi,
	Dist is NumB - NumA,
	Dist == 1.

follows(Dom, A,B,NumA,Dist,TypA,TypB) :-
	var(NumA), var(N), !,
	sec_struc(Dom, A),
	sec_struc(Dom, B),
	sst(A, NumA, _, _, TypA, _, _),
	sst(B, NumB, _, _, TypB, _, _),
	Dist is NumB - NumA,
	Dist >= 2,
	Dist =< 2.
follows(Dom, A,B,P,N,TypA,TypB) :-
	sec_struc(Dom, A),
	sec_struc(Dom, B),
	sst(A, NumA, _, _, TypA, _, _),
	sst(B, NumB, _, _, TypB, _, _),
	Lo1 is P-3,
	Lo2 is 0.6 * P,
	min(Lo1,Lo2,Lo),
	Hi1 is P+3,
	Hi2 is 1.4 * P,
	max(Hi1,Hi2,Hi),
	NumA >= Lo,
	NumA =< Hi,
	Dist is NumB - NumA,
	Dist >= N,
	Dist =< N.

max(A,B,A) :-
	A > B, !.
max(A,B,B).

min(A,B,A) :-
	A < B, !.
min(A,B,B).


% follows_by_n_units(A,B,N) :-
%	 not(var(N)), nat(N), !,
%	 sst(Dom, A, NumA, _, _, _, _, _),
%	 sst(Dom, B, NumB, _, _, _, _, _),
%	 Dist is NumB - NumA,
%	 Upper is N + (N / 2),
%	 Dist < Upper,
%	 Lower is N - (N / 2),
%	 Dist > Lower.
% follows_by_n_units(A,B,N) :-
%	 sst(Dom, A, NumA, _, _, _, _, _),
%	 sst(Dom, B, NumB, _, _, _, _, _),
%	 N is NumB - NumA,
%	 N > 0.
 
% follows_by_n_res(A,B,N) :-
%	 not(var(N)), nat(N), !,
%	 sst(Dom, A, _, PosA, _, _, _, _),
%	 sst(Dom, B, _, PosB, _, _, _, _),
%	 Dist is PosB - PosA,
%	 Upper is N + (N / 2),
%	 Dist < Upper,
%	 Lower is N - (N / 2),
%	 Dist > Lower.
% follows_by_n_res(A,B,N) :-
%	 sst(Dom, A, _, PosA, _, _, _, _),
%	 sst(Dom, B, _, PosB, _, _, _, _),
%	 N is PosB - PosA,
%	 N > 0.

interval(Min=<[L|_]=<Max) :-
	solving,
	flatten(L,L1),
	meansigma(L1,Mu,Sg),
	Min is ceil(Mu-2*Sg),
	Max is floor(Mu+2*Sg).
interval(Min=<X=<Max) :-
	not(solving),
	Min=<X, X=<Max.

interval_l([L|_]=<Max) :-
	solving,
	flatten(L,L1),
	minmax(L1,_,Max).
interval_l(X=<Max) :-
	not(solving),
	X=<Max.

interval_r(Min=<[L|_]) :-
	solving,
	flatten(L,L1),
	minmax(L1,Min,_).
interval_r(Min=<X) :-
	not(solving),
	Min =< X.

minmax([X],X,X) :- not(var(X)), not(X=[_|_]), !.
minmax([H|T],Min,Max) :-
	minmax(T,Min1,Max1),
	min(H,Min1,Min),
	max(H,Max1,Max), !.

min(X,Y,X) :- (X=<Y; not(number(Y))), !.
min(X,Y,Y) :- (Y<X; not(number(X))), !.

max(X,Y,X) :- (X>=Y;not(number(Y))), !.
max(X,Y,Y) :- (Y>X;not(number(X))), !.

flatten(L1,L2) :-
	flatten(L1,L2,[]).

list([_|_]).

flatten([],E,E).
flatten([H|T],[H|E2],E3) :-
	not(list(H)),
	flatten(T,E2,E3).
flatten([H|T],E2,E3) :-
	list(H),
	flatten(H,E2,E4),
	flatten(T,E4,E3).

meansigma(Bag,Mu,Sg) :-
	ms1(Bag,0,0,0,Mu,Sg).

ms1([],Sum,Sum2,N,Mu,Sg) :-
	Mu is Sum/N,
	Sg is (Sum2/N-Mu^2)^0.5.
ms1([X|T],Sum,Sum2,N,Mu,Sg) :-
	ms1(T,Sum+X,Sum2+X^2,N+1,Mu,Sg).

gte(X,Y):-
	not(var(X)), not(var(Y)),
	nat(X), nat(Y), !,
	X >= Y.
gte(X,X).

lte(X,Y):-
	not(var(X)), not(var(Y)),
	nat(X), nat(Y), !,
	X =< Y.
lte(X,X).

gen_const(V, M, E, very_hi) :-
	Threshold is M + (2 * E),
	V > Threshold, !.
gen_const(V, M, E, hi) :-
	Threshold is M + E,
	V > Threshold, !.
gen_const(V, M, E, very_lo) :-
	Threshold is M - (2 * E),
	V < Threshold, !.
gen_const(V, M, E, lo) :-
	Threshold is M - E,
	V < Threshold, !.
% gen_const(V, M, E, ave).

%% params(Type, Class, Len_Mean, Len_StdE, AveH_Mean, AveH_StdE, HMom_Mean, HMom_StdE)

params(e, 'All beta',              6.81, 2.74,  0.15, 0.36, 2.57, 1.93).
params(e, 'All alpha',             3.52, 1.47,  0.21, 0.45, 1.97, 1.33).
params(e, 'Alpha and beta (a/b)',  5.89, 2.12,  0.29, 0.38, 1.96, 1.51).
params(e, 'Alpha and beta (a+b)',  6.75, 3.16,  0.13, 0.39, 2.44, 1.92).

params(h, 'All beta',             10.45, 4.94, -0.11, 0.29, 3.25, 1.56).
params(h, 'All alpha',            15.36, 7.31, -0.07, 0.27, 5.18, 2.36).
params(h, 'Alpha and beta (a/b)', 13.51, 5.61, -0.01, 0.27, 4.37, 2.30).
params(h, 'Alpha and beta (a+b)', 13.59, 5.68, -0.01, 0.26, 4.19, 2.04).

params(c, 'All alpha', 4.730, 5.490).
params(c, 'All beta', 5.396, 5.137).
params(c, 'Alpha and beta (a+b)', 6.150, 6.508).
params(c, 'Alpha and beta (a/b)', 5.617, 6.477).

:- [info]?

% :- [bg]?
% :- [eg]?

% prune(_,Body) :-

% false:-
%	hypothesis(_,Body,_),
%	has_lit(follows(_,_,_),Body,true), !.
% false:-
%	hypothesis(_,Body,_),
%	has_lit(follows(_,_,_),Body,Rest),
%	all_lits(follows(_,_,_),Rest), !.

prune(_,Body) :-
	 has_n_lits(2,adjacent/6,Body),!.

% prune(_,Body) :-
%	 has_n_lits(2,follows/7,Body),!.
% prune(_,Body) :-
%	not(start_with(adjacent/6,Body)), !.

start_with(L/M,(T,_)) :-
	functor(T,L,M), !.
start_with(L/M,T) :-
	functor(T,L,M), !.
start_with(L/M,true).

has_n_lits(0,_,_) :- !.
has_n_lits(1,L/M,T) :- 
	functor(T,L,M),!.
has_n_lits(N,L/M,(T,Rest)) :-
	functor(T,L,M),!,
	N1 is N - 1,
	has_n_lits(N1,L/M,Rest).
has_n_lits(N,L/M,(_,Rest)) :-
	has_n_lits(N,L/M,Rest).

has_lit(L,(L,Rest),Rest).
has_lit(L,(_,Lits),Rest):-
	!,
	has_lit(L,Lits,Rest).
has_lit(L,L,true).

all_lits(L,(L,Rest)):-
	!,
	all_lits(L,Rest).
all_lits(L,L).
